package code.snippet

import _root_.net.liftweb.util.Helpers._
import _root_.scala.xml.{NodeSeq, Text }
import net.liftweb.http.{RequestVar, S}
import code.util.Util._
import code.util.RDiffBackup

/**
 * 履歴一覧表示ポップアップ画面で使用するスニペットです。
 */
class HistorySnippet {

  private object paramRoot extends RequestVar[String](S.param("root").open_!)
  private object paramPath extends RequestVar[String](S.param("path").openOr(""))

  def show(xhtml : NodeSeq) : NodeSeq = {
    // パスのセキュリティチェック
    checkRoot(paramRoot)
    checkPath(paramPath)

    S.skipDocType = true
    S.skipXmlHeader= true

    val historyList = RDiffBackup.list(buildPath(paramRoot, paramPath))

    bind("history", xhtml,
      "title" -> {if(historyList.isEmpty) Text("No Increments.") else Text("Found " + historyList.size + " Increments.")},
      "list" -> <ul>
        {historyList.map(history => {
          <li class={if(historyList.indexOf(history) % 2 == 0) "odd" else "even"}>
            <a href="javascript:void(0);" onclick={"showChanges('%s','%s','%s');".format(paramRoot, paramPath, history)}>{history}</a>
          </li>
        })}
      </ul>)
  }



}