/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.util;

import net.liftweb.common.Box;
import net.liftweb.util.Currency$;
import net.liftweb.util.CurrencyMismatchException;
import net.liftweb.util.Helpers$;
import net.liftweb.util.HttpHelpers$class;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001!4\u0001\"\u0001\u0002\u0005\u0002\u0003\u0005\t!\u0003\u0002\t\u0007V\u0014(/\u001a8ds*\u00111\u0001B\u0001\u0005kRLGN\u0003\u0002\u0006\r\u00059A.\u001b4uo\u0016\u0014'\"A\u0004\u0002\u00079,Go\u0001\u0001\u0014\u0007\u0001Q!\u0003\u0005\u0002\f!5\tAB\u0003\u0002\u000e\u001d\u0005!A.\u00198h\u0015\u0005y\u0011\u0001\u00026bm\u0006L!!\u0005\u0007\u0003\r=\u0013'.Z2u!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011e\u0001!Q1A\u0005\u0002i\ta!Y7pk:$X#A\u000e\u0011\u0005Ma\u0012BA\u000f\u0015\u0005\u0011auN\\4\t\u0011}\u0001!\u0011!Q\u0001\nm\tq!Y7pk:$\b\u0005\u0003\u0005\"\u0001\t\u0015\r\u0011\"\u0001#\u0003\u0019\u0019\u00180\u001c2pYV\t1\u0005\u0005\u0002%O9\u00111#J\u0005\u0003MQ\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0015*\u0005\u0019\u0019FO]5oO*\u0011a\u0005\u0006\u0005\tW\u0001\u0011\t\u0011)A\u0005G\u000591/_7c_2\u0004\u0003\u0002C\u0017\u0001\u0005\u000b\u0007I\u0011\u0001\u0018\u0002\u0011\u0011,7-[7bYN,\u0012a\f\t\u0003'AJ!!\r\u000b\u0003\u0007%sG\u000f\u0003\u00054\u0001\t\u0005\t\u0015!\u00030\u0003%!WmY5nC2\u001c\b\u0005C\u00036\u0001\u0011\u0005a'\u0001\u0004=S:LGO\u0010\u000b\u0005oeR4\b\u0005\u00029\u00015\t!\u0001C\u0003\u001ai\u0001\u00071\u0004C\u0003\"i\u0001\u00071\u0005C\u0003.i\u0001\u0007q\u0006C\u0003>\u0001\u0011\u0005c(\u0001\u0005u_N#(/\u001b8h)\u0005y\u0004CA\u0006A\u0013\tAC\u0002C\u0003C\u0001\u0011\u0005!%A\u0003g_J$%\tC\u0003E\u0001\u0011\u0005S)\u0001\u0004fcV\fGn\u001d\u000b\u0003\r&\u0003\"aE$\n\u0005!#\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u0015\u000e\u0003\raS\u0001\u0006_RDWM\u001d\t\u0003'1K!!\u0014\u000b\u0003\u0007\u0005s\u0017\u0010C\u0003P\u0001\u0011\u0005\u0001+A\u0003%a2,8\u000f\u0006\u00028#\")!J\u0014a\u0001o!)1\u000b\u0001C\u0001)\u00061A%\\5okN$\"aN+\t\u000b)\u0013\u0006\u0019A\u001c\b\u000b]\u0013\u0001R\u0001-\u0002\u0011\r+(O]3oGf\u0004\"\u0001O-\u0007\u0011\u0005\u0011A\u0011!A\t\u0006i\u001b2!\u0017\u0006\u0013\u0011\u0015)\u0014\f\"\u0001])\u0005A\u0006\"\u00020Z\t\u0003y\u0016!B1qa2LHC\u00011g!\r\tGmN\u0007\u0002E*\u00111\rB\u0001\u0007G>lWn\u001c8\n\u0005\u0015\u0014'a\u0001\"pq\")q-\u0018a\u0001G\u0005\t1\u000f")
public class Currency
implements ScalaObject {
    private final long amount;
    private final String symbol;
    private final int decimals;

    public static final Box<Currency> apply(String string2) {
        return Currency$.MODULE$.apply(string2);
    }

    public long amount() {
        return this.amount;
    }

    public String symbol() {
        return this.symbol;
    }

    public int decimals() {
        return this.decimals;
    }

    public String toString() {
        String string2;
        if (this.decimals() == 0) {
            long l = this.amount();
            string2 = new StringBuilder().append((Object)this.symbol()).append((Object)BoxesRunTime.boxToLong((long)l)).toString();
        } else {
            double d = this.amount();
            double pow = package$.MODULE$.pow(10.0, (double)this.decimals());
            double d2 = d / pow;
            string2 = new StringBuilder().append((Object)this.symbol()).append((Object)BoxesRunTime.boxToDouble((double)d2)).toString();
        }
        return string2;
    }

    public String forDB() {
        String string2 = this.symbol();
        Helpers$ helpers$ = Helpers$.MODULE$;
        long l = this.amount();
        int n = this.decimals();
        return new StringBuilder().append((Object)HttpHelpers$class.urlEncode(helpers$, string2)).append((Object)"&").append((Object)BoxesRunTime.boxToLong((long)l)).append((Object)"&").append((Object)BoxesRunTime.boxToInteger((int)n)).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof Currency)) return false;
        Currency currency = (Currency)other;
        if (currency.amount() != this.amount()) return false;
        String string2 = currency.symbol();
        String string3 = this.symbol();
        if (string2 == null) {
            if (string3 != null) {
                return false;
            }
        } else if (!string2.equals(string3)) return false;
        if (currency.decimals() != this.decimals()) return false;
        return true;
    }

    public Currency $plus(Currency other) {
        String string2 = this.symbol();
        String string3 = other.symbol();
        if (!(string2 != null ? !string2.equals(string3) : string3 != null) && this.decimals() == other.decimals()) {
            return new Currency(this.amount() + other.amount(), this.symbol(), this.decimals());
        }
        throw new CurrencyMismatchException();
    }

    public Currency $minus(Currency other) {
        String string2 = this.symbol();
        String string3 = other.symbol();
        if (!(string2 != null ? !string2.equals(string3) : string3 != null) && this.decimals() == other.decimals()) {
            return new Currency(this.amount() - other.amount(), this.symbol(), this.decimals());
        }
        throw new CurrencyMismatchException();
    }

    public Currency(long amount, String symbol, int decimals) {
        this.amount = amount;
        this.symbol = symbol;
        this.decimals = decimals;
    }
}

