/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Set;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.event.download.PrepareDownloadEvent;
import org.apache.ivy.core.event.resolve.EndResolveEvent;
import org.apache.ivy.core.event.resolve.StartResolveEvent;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ConfigurationResolveReport;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeCallers;
import org.apache.ivy.core.resolve.IvyNodeEviction;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngineSettings;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.RestartResolveProcess;
import org.apache.ivy.core.resolve.VisitNode;
import org.apache.ivy.core.sort.SortEngine;
import org.apache.ivy.core.sort.SortOptions;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.resolver.CacheResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.filter.Filter;

public class ResolveEngine {
    private ResolveEngineSettings settings;
    private EventManager eventManager;
    private SortEngine sortEngine;
    private Set fetchedSet = new HashSet();
    private DependencyResolver dictatorResolver;

    public ResolveEngine(ResolveEngineSettings settings, EventManager eventManager, SortEngine sortEngine) {
        this.settings = settings;
        this.eventManager = eventManager;
        this.sortEngine = sortEngine;
    }

    public DependencyResolver getDictatorResolver() {
        return this.dictatorResolver;
    }

    public void setDictatorResolver(DependencyResolver dictatorResolver) {
        this.dictatorResolver = dictatorResolver;
        this.settings.setDictatorResolver(dictatorResolver);
    }

    public ResolveReport resolve(ModuleDescriptor md, ResolveOptions options) throws ParseException, IOException {
        DependencyResolver oldDictator = this.getDictatorResolver();
        IvyContext context = IvyContext.getContext();
        if (options.isUseCacheOnly()) {
            this.setDictatorResolver(new CacheResolver(this.settings));
        }
        try {
            String[] confs = options.getConfs(md);
            options.setConfs(confs);
            if (options.getResolveId() == null) {
                options.setResolveId(ResolveOptions.getDefaultResolveId(md));
            }
            this.eventManager.fireIvyEvent(new StartResolveEvent(md, confs));
            long start = System.currentTimeMillis();
            if ("default".equals(options.getLog())) {
                Message.info(":: resolving dependencies :: " + md.getResolvedModuleRevisionId() + (options.isTransitive() ? "" : " [not transitive]"));
                Message.info("\tconfs: " + Arrays.asList(confs));
            } else {
                Message.verbose(":: resolving dependencies :: " + md.getResolvedModuleRevisionId() + (options.isTransitive() ? "" : " [not transitive]"));
                Message.verbose("\tconfs: " + Arrays.asList(confs));
            }
            Message.verbose("\tvalidate = " + options.isValidate());
            Message.verbose("\trefresh = " + options.isRefresh());
            ResolveReport report = new ResolveReport(md, options.getResolveId());
            ResolveData data = new ResolveData(this, options);
            context.setResolveData(data);
            IvyNode[] dependencies = this.getDependencies(md, options, report);
            report.setDependencies(Arrays.asList(dependencies), options.getArtifactFilter());
            if (options.getCheckIfChanged()) {
                report.checkIfChanged();
            }
            ResolutionCacheManager cacheManager = this.settings.getResolutionCacheManager();
            File ivyFileInCache = cacheManager.getResolvedIvyFileInCache(md.getResolvedModuleRevisionId());
            md.toIvyFile(ivyFileInCache);
            File ivyPropertiesInCache = cacheManager.getResolvedIvyPropertiesInCache(md.getResolvedModuleRevisionId());
            Properties props = new Properties();
            if (dependencies.length > 0) {
                IvyNode root = dependencies[0].getRoot();
                for (int i = 0; i < dependencies.length; ++i) {
                    DependencyDescriptor dd;
                    if (dependencies[i].hasProblem() || (dd = dependencies[i].getDependencyDescriptor(root)) == null) continue;
                    ModuleRevisionId depResolvedId = dependencies[i].getResolvedId();
                    ModuleDescriptor depDescriptor = dependencies[i].getDescriptor();
                    ModuleRevisionId depRevisionId = dd.getDependencyRevisionId();
                    if (depResolvedId == null) {
                        throw new NullPointerException("getResolvedId() is null for " + dependencies[i].toString());
                    }
                    if (depRevisionId == null) {
                        throw new NullPointerException("getDependencyRevisionId() is null for " + dd.toString());
                    }
                    String rev = depResolvedId.getRevision();
                    String status = depDescriptor == null ? "?" : depDescriptor.getStatus();
                    props.put(depRevisionId.encodeToString(), rev + " " + status);
                }
            }
            FileOutputStream out = new FileOutputStream(ivyPropertiesInCache);
            props.store(out, md.getResolvedModuleRevisionId() + " resolved revisions");
            out.close();
            Message.verbose("\tresolved ivy file produced in " + ivyFileInCache);
            report.setResolveTime(System.currentTimeMillis() - start);
            if (options.isDownload()) {
                Message.verbose(":: downloading artifacts ::");
                this.downloadArtifacts(report, options.getArtifactFilter(), (DownloadOptions)new DownloadOptions().setLog(options.getLog()));
            }
            if (options.isOutputReport()) {
                this.outputReport(report, cacheManager, options);
            }
            Message.verbose("\tresolve done (" + report.getResolveTime() + "ms resolve - " + report.getDownloadTime() + "ms download)");
            Message.sumupProblems();
            this.eventManager.fireIvyEvent(new EndResolveEvent(md, confs, report));
            ResolveReport resolveReport = report;
            return resolveReport;
        }
        catch (RuntimeException ex) {
            Message.error(ex.getMessage());
            Message.sumupProblems();
            throw ex;
        }
        finally {
            context.setResolveData(null);
            this.setDictatorResolver(oldDictator);
        }
    }

    public void outputReport(ResolveReport report, ResolutionCacheManager cacheMgr, ResolveOptions options) throws IOException {
        if ("default".equals(options.getLog())) {
            Message.info(":: resolution report :: resolve " + report.getResolveTime() + "ms" + " :: artifacts dl " + report.getDownloadTime() + "ms");
        } else {
            Message.verbose(":: resolution report :: resolve " + report.getResolveTime() + "ms" + " :: artifacts dl " + report.getDownloadTime() + "ms");
        }
        report.setProblemMessages(Message.getProblems());
        report.output(this.settings.getReportOutputters(), cacheMgr, options);
    }

    public void downloadArtifacts(ResolveReport report, Filter artifactFilter, DownloadOptions options) {
        long start = System.currentTimeMillis();
        IvyNode[] dependencies = report.getDependencies().toArray(new IvyNode[report.getDependencies().size()]);
        this.eventManager.fireIvyEvent(new PrepareDownloadEvent(report.getArtifacts().toArray(new Artifact[report.getArtifacts().size()])));
        long totalSize = 0L;
        for (int i = 0; i < dependencies.length; ++i) {
            this.checkInterrupted();
            if (dependencies[i].isCompletelyEvicted() || dependencies[i].hasProblem() || dependencies[i].getModuleRevision() == null) continue;
            DependencyResolver resolver = dependencies[i].getModuleRevision().getArtifactResolver();
            Artifact[] selectedArtifacts = dependencies[i].getSelectedArtifacts(artifactFilter);
            DownloadReport dReport = resolver.download(selectedArtifacts, options);
            ArtifactDownloadReport[] adrs = dReport.getArtifactsReports();
            for (int j = 0; j < adrs.length; ++j) {
                if (adrs[j].getDownloadStatus() == DownloadStatus.FAILED) {
                    if (adrs[j].getArtifact().getExtraAttribute("ivy:merged") != null) {
                        Message.warn("\tmerged artifact not found: " + adrs[j].getArtifact() + ". It was required in " + adrs[j].getArtifact().getExtraAttribute("ivy:merged"));
                        continue;
                    }
                    Message.warn("\t" + adrs[j]);
                    resolver.reportFailure(adrs[j].getArtifact());
                    continue;
                }
                if (adrs[j].getDownloadStatus() != DownloadStatus.SUCCESSFUL) continue;
                totalSize += adrs[j].getSize();
            }
            String[] dconfs = dependencies[i].getRootModuleConfigurations();
            for (int j = 0; j < dconfs.length; ++j) {
                if (dependencies[i].isEvicted(dconfs[j]) || dependencies[i].isBlacklisted(dconfs[j])) {
                    report.getConfigurationReport(dconfs[j]).addDependency(dependencies[i]);
                    continue;
                }
                report.getConfigurationReport(dconfs[j]).addDependency(dependencies[i], dReport);
            }
        }
        report.setDownloadTime(System.currentTimeMillis() - start);
        report.setDownloadSize(totalSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IvyNode[] getDependencies(ModuleDescriptor md, ResolveOptions options, ResolveReport report) {
        if (md == null) {
            throw new NullPointerException("module descriptor must not be null");
        }
        String[] confs = options.getConfs(md);
        ArrayList<String> missingConfs = new ArrayList<String>();
        for (int i = 0; i < confs.length; ++i) {
            if (confs[i] == null) {
                throw new NullPointerException("null conf not allowed: confs where: " + Arrays.asList(confs));
            }
            if (md.getConfiguration(confs[i]) != null) continue;
            missingConfs.add(" '" + confs[i] + "' ");
        }
        if (!missingConfs.isEmpty()) {
            throw new IllegalArgumentException("requested configuration" + (missingConfs.size() > 1 ? "s" : "") + " not found in " + md.getModuleRevisionId() + ": " + missingConfs);
        }
        IvyContext context = IvyContext.pushNewCopyContext();
        try {
            options.setConfs(confs);
            Date reportDate = new Date();
            ResolveData data = context.getResolveData();
            if (data == null) {
                data = new ResolveData(this, options);
                context.setResolveData(data);
            }
            IvyNode rootNode = new IvyNode(data, md);
            for (int i = 0; i < confs.length; ++i) {
                Message.verbose("resolving dependencies for configuration '" + confs[i] + "'");
                this.fetchedSet.clear();
                ConfigurationResolveReport confReport = null;
                if (report != null && (confReport = report.getConfigurationReport(confs[i])) == null) {
                    confReport = new ConfigurationResolveReport(this, md, confs[i], reportDate, options);
                    report.addReport(confs[i], confReport);
                }
                data.setReport(confReport);
                VisitNode root = new VisitNode(data, rootNode, null, confs[i], null);
                root.setRequestedConf(confs[i]);
                rootNode.updateConfsToFetch(Collections.singleton(confs[i]));
                boolean fetched = false;
                while (!fetched) {
                    try {
                        this.fetchDependencies(root, confs[i], false);
                        fetched = true;
                    }
                    catch (RestartResolveProcess restart) {
                        Message.verbose("====================================================");
                        Message.verbose("=           RESTARTING RESOLVE PROCESS");
                        Message.verbose("= " + restart.getMessage());
                        Message.verbose("====================================================");
                        this.fetchedSet.clear();
                    }
                }
                Iterator iter = data.getNodes().iterator();
                while (iter.hasNext()) {
                    IvyNode dep = (IvyNode)iter.next();
                    dep.clean();
                }
            }
            Collection nodes = data.getNodes();
            LinkedHashSet<IvyNode> dependencies = new LinkedHashSet<IvyNode>(nodes.size());
            Iterator iter = nodes.iterator();
            while (iter.hasNext()) {
                IvyNode node = (IvyNode)iter.next();
                if (node == null || node.isRoot() || node.isCompletelyBlacklisted()) continue;
                dependencies.add(node);
            }
            List sortedDependencies = this.sortEngine.sortNodes(dependencies, SortOptions.SILENT);
            Collections.reverse(sortedDependencies);
            this.handleTransiviteEviction(md, confs, data, sortedDependencies);
            IvyNode[] ivyNodeArray = dependencies.toArray(new IvyNode[dependencies.size()]);
            return ivyNodeArray;
        }
        finally {
            IvyContext.popContext();
        }
    }

    private void handleTransiviteEviction(ModuleDescriptor moduleDescriptor, String[] stringArray, ResolveData resolveData, List list) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            IvyNode ivyNode = (IvyNode)listIterator.next();
            if (ivyNode.isCompletelyEvicted()) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                IvyNodeCallers.Caller[] callerArray = ivyNode.getCallers(stringArray[i]);
                if (this.settings.debugConflictResolution()) {
                    Message.debug("checking if " + ivyNode.getId() + " is transitively evicted in " + stringArray[i]);
                }
                boolean bl = callerArray.length > 0;
                for (int j = 0; j < callerArray.length; ++j) {
                    if (callerArray[j].getModuleRevisionId().equals(moduleDescriptor.getModuleRevisionId())) {
                        bl = false;
                        break;
                    }
                    IvyNode ivyNode2 = resolveData.getNode(callerArray[j].getModuleRevisionId());
                    if (ivyNode2 == null) {
                        Message.warn("ivy internal error: no node found for " + callerArray[j].getModuleRevisionId() + ": looked in " + resolveData.getNodeIds() + " and root module id was " + moduleDescriptor.getModuleRevisionId());
                        continue;
                    }
                    if (!ivyNode2.isEvicted(stringArray[i])) {
                        bl = false;
                        break;
                    }
                    if (!this.settings.debugConflictResolution()) continue;
                    Message.debug("caller " + ivyNode2.getId() + " of " + ivyNode.getId() + " is evicted");
                }
                if (bl) {
                    Message.verbose("all callers are evicted for " + ivyNode + ": evicting too");
                    ivyNode.markEvicted(stringArray[i], null, null, null);
                    continue;
                }
                if (!this.settings.debugConflictResolution()) continue;
                Message.debug(ivyNode.getId() + " isn't transitively evicted, at least one caller was" + " not evicted");
            }
        }
    }

    private void fetchDependencies(VisitNode visitNode, String string, boolean bl) {
        int n;
        String[] stringArray;
        this.checkInterrupted();
        long l = System.currentTimeMillis();
        if (visitNode.getParent() != null) {
            Message.verbose("== resolving dependencies " + visitNode.getParent().getId() + "->" + visitNode.getId() + " [" + visitNode.getParentConf() + "->" + string + "]");
        } else {
            Message.verbose("== resolving dependencies for " + visitNode.getId() + " [" + string + "]");
        }
        ResolveData resolveData = visitNode.getNode().getData();
        VisitNode visitNode2 = resolveData.getCurrentVisitNode();
        resolveData.setCurrentVisitNode(visitNode);
        DependencyDescriptor dependencyDescriptor = visitNode.getDependencyDescriptor();
        VersionMatcher versionMatcher = visitNode.getNode().getData().getSettings().getVersionMatcher();
        if (!(dependencyDescriptor == null || visitNode.getRoot() == visitNode.getParent() && versionMatcher.isDynamic(dependencyDescriptor.getDependencyRevisionId()))) {
            this.resolveConflict(visitNode, string);
        }
        if (visitNode.loadData(string, bl)) {
            this.resolveConflict(visitNode, string);
            if (!visitNode.isEvicted() && !visitNode.isCircular()) {
                stringArray = visitNode.getRealConfs(string);
                for (n = 0; n < stringArray.length; ++n) {
                    this.doFetchDependencies(visitNode, stringArray[n]);
                }
            }
        } else if (!(visitNode.hasProblem() || visitNode.isEvicted() || visitNode.isCircular())) {
            stringArray = visitNode.getRealConfs(string);
            for (n = 0; n < stringArray.length; ++n) {
                this.doFetchDependencies(visitNode, stringArray[n]);
            }
        }
        if (visitNode.isEvicted() && (stringArray = visitNode.getEvictedData()).getSelected() != null) {
            Iterator iterator = stringArray.getSelected().iterator();
            while (iterator.hasNext()) {
                IvyNode ivyNode = (IvyNode)iterator.next();
                if (!ivyNode.isLoaded()) {
                    ivyNode.updateConfsToFetch(Collections.singleton(string));
                    continue;
                }
                this.fetchDependencies(visitNode.gotoNode(ivyNode), string, true);
            }
        }
        if (this.settings.debugConflictResolution()) {
            Message.debug(visitNode.getId() + " => dependencies resolved in " + string + " (" + (System.currentTimeMillis() - l) + "ms)");
        }
        resolveData.setCurrentVisitNode(visitNode2);
    }

    private void doFetchDependencies(VisitNode visitNode, String string) {
        String[] stringArray;
        Configuration configuration = visitNode.getConfiguration(string);
        if (configuration == null) {
            if (!visitNode.isConfRequiredByMergedUsageOnly(string)) {
                Message.warn("configuration not found '" + string + "' in " + visitNode.getResolvedId() + ": ignoring");
                if (visitNode.getParent() != null) {
                    Message.warn("it was required from " + visitNode.getParent().getResolvedId());
                }
            }
            return;
        }
        boolean bl = false;
        if (visitNode.getRequestedConf() == null) {
            visitNode.setRequestedConf(string);
            bl = true;
        }
        if ((stringArray = configuration.getExtends()).length > 0) {
            visitNode.updateConfsToFetch(Arrays.asList(stringArray));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.fetchDependencies(visitNode, stringArray[i], false);
        }
        DependencyDescriptor dependencyDescriptor = visitNode.getDependencyDescriptor();
        if (!this.isDependenciesFetched(visitNode.getNode(), string) && (dependencyDescriptor == null || visitNode.isTransitive())) {
            Collection collection = visitNode.getDependencies(string);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                int n;
                VisitNode visitNode2 = (VisitNode)iterator.next();
                visitNode2.useRealNode();
                String[] stringArray2 = visitNode2.getRequiredConfigurations(visitNode, string);
                for (n = 0; n < stringArray2.length; ++n) {
                    this.fetchDependencies(visitNode2, stringArray2[n], true);
                }
                if (visitNode2.isEvicted() || visitNode2.hasProblem()) continue;
                stringArray2 = visitNode2.getConfsToFetch();
                for (n = 0; n < stringArray2.length; ++n) {
                    this.fetchDependencies(visitNode2, stringArray2[n], false);
                }
            }
            this.markDependenciesFetched(visitNode.getNode(), string);
        }
        if (bl) {
            visitNode.setRequestedConf(null);
        }
    }

    private boolean isDependenciesFetched(IvyNode node, String conf) {
        String key = this.getDependenciesFetchedKey(node, conf);
        return this.fetchedSet.contains(key);
    }

    private void markDependenciesFetched(IvyNode node, String conf) {
        String key = this.getDependenciesFetchedKey(node, conf);
        this.fetchedSet.add(key);
    }

    private String getDependenciesFetchedKey(IvyNode ivyNode, String string) {
        ModuleRevisionId moduleRevisionId = ivyNode.getResolvedId();
        String string2 = moduleRevisionId.getOrganisation() + "|" + moduleRevisionId.getName() + "|" + moduleRevisionId.getRevision() + "|" + string;
        return string2;
    }

    private void resolveConflict(VisitNode node, String conf) {
        this.resolveConflict(node, node.getParent(), conf, Collections.EMPTY_SET);
    }

    private boolean resolveConflict(VisitNode visitNode, VisitNode visitNode2, String string, Collection collection) {
        if (visitNode2 == null || visitNode == visitNode2) {
            return true;
        }
        if (this.checkConflictSolvedEvicted(visitNode, visitNode2)) {
            return true;
        }
        boolean bl = this.settings.debugConflictResolution();
        if (this.checkConflictSolvedSelected(visitNode, visitNode2)) {
            if (this.resolveConflict(visitNode, visitNode2.getParent(), string, collection)) {
                IvyNodeEviction.EvictionData evictionData = visitNode.getEvictionDataInRoot(visitNode.getRootModuleConf(), visitNode2);
                if (evictionData != null) {
                    if (bl) {
                        Message.debug(visitNode + " was previously evicted in root module conf " + visitNode.getRootModuleConf());
                    }
                    visitNode.markEvicted(evictionData);
                    if (bl) {
                        Message.debug("evicting " + visitNode + " by " + evictionData);
                    }
                }
                return true;
            }
            return false;
        }
        Set set = visitNode2.getNode().getResolvedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf());
        set.addAll(visitNode2.getNode().getPendingConflicts(visitNode.getRootModuleConf(), visitNode.getModuleId()));
        Collection collection2 = this.computeConflicts(visitNode, visitNode2, string, collection, set);
        ConflictManager conflictManager = visitNode2.getNode().getConflictManager(visitNode.getModuleId());
        Collection collection3 = this.resolveConflicts(visitNode, visitNode2, collection2, conflictManager);
        if (collection3 == null) {
            if (bl) {
                Message.debug("impossible to resolve conflicts for " + visitNode + " in " + visitNode2 + " yet");
                Message.debug("setting all nodes as pending conflicts for later conflict resolution: " + collection2);
            }
            visitNode2.getNode().setPendingConflicts(visitNode.getModuleId(), visitNode.getRootModuleConf(), collection2);
            return false;
        }
        if (bl) {
            Message.debug("selected revisions for " + visitNode + " in " + visitNode2 + ": " + collection3);
        }
        if (collection3.contains(visitNode.getNode())) {
            collection = set;
            collection.removeAll(collection3);
            Object object = collection.iterator();
            while (object.hasNext()) {
                IvyNode ivyNode = (IvyNode)object.next();
                ivyNode.markEvicted(visitNode.getRootModuleConf(), visitNode2.getNode(), conflictManager, collection3);
                if (!bl) continue;
                Message.debug("evicting " + ivyNode + " by " + ivyNode.getEvictedData(visitNode.getRootModuleConf()));
            }
            visitNode2.getNode().setResolvedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf(), collection3);
            object = new HashSet(visitNode2.getNode().getEvictedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf()));
            object.removeAll(collection3);
            object.addAll(collection);
            visitNode2.getNode().setEvictedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf(), (Collection)object);
            visitNode2.getNode().setPendingConflicts(visitNode.getModuleId(), visitNode.getRootModuleConf(), Collections.EMPTY_SET);
            return this.resolveConflict(visitNode, visitNode2.getParent(), string, collection);
        }
        if (collection3.isEmpty() && bl) {
            Message.verbose("conflict manager '" + conflictManager + "' evicted all revisions among " + collection2);
        }
        HashSet<IvyNode> hashSet = new HashSet<IvyNode>(visitNode2.getNode().getEvictedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf()));
        collection.removeAll(collection3);
        hashSet.removeAll(collection3);
        hashSet.addAll(collection);
        hashSet.add(visitNode.getNode());
        visitNode2.getNode().setEvictedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf(), hashSet);
        visitNode2.getNode().setPendingConflicts(visitNode.getModuleId(), visitNode.getRootModuleConf(), Collections.EMPTY_SET);
        visitNode.markEvicted(visitNode2, conflictManager, collection3);
        if (bl) {
            Message.debug("evicting " + visitNode + " by " + visitNode.getEvictedData());
        }
        Set set2 = visitNode2.getNode().getResolvedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf());
        boolean bl2 = true;
        if (!((Object)set2).equals(collection3)) {
            visitNode2.getNode().setResolvedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf(), collection3);
            Iterator iterator = collection3.iterator();
            while (iterator.hasNext()) {
                IvyNode ivyNode = (IvyNode)iterator.next();
                if (set2.contains(ivyNode)) continue;
                bl2 &= this.resolveConflict(visitNode.gotoNode(ivyNode), visitNode2.getParent(), string, collection);
            }
        }
        return bl2;
    }

    private Collection resolveConflicts(VisitNode visitNode, VisitNode visitNode2, Collection collection, ConflictManager conflictManager) {
        if (visitNode.getParent() != visitNode2 && conflictManager == this.settings.getConflictManager(visitNode.getModuleId()) && ((Object)visitNode.getParent().getNode().getResolvedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf())).equals(collection)) {
            if (this.settings.debugConflictResolution()) {
                Message.debug("no new conflicting revisions for " + visitNode + " in " + visitNode2 + ": " + collection);
            }
            return collection;
        }
        if (this.settings.debugConflictResolution()) {
            Message.debug("found conflicting revisions for " + visitNode + " in " + visitNode2 + ": " + collection);
        }
        return conflictManager.resolveConflicts(visitNode2.getNode(), collection);
    }

    private Collection computeConflicts(VisitNode node, VisitNode ancestor, String conf, Collection toevict, Collection selectedNodes) {
        LinkedHashSet<IvyNode> conflicts = new LinkedHashSet<IvyNode>();
        conflicts.add(node.getNode());
        if (selectedNodes.removeAll(toevict) || selectedNodes.isEmpty() && !node.getParent().getNode().equals(ancestor.getNode())) {
            Collection deps = ancestor.getNode().getDependencies(node.getRootModuleConf(), ancestor.getNode().getConfigurations(node.getRootModuleConf()));
            Iterator iter = deps.iterator();
            while (iter.hasNext()) {
                IvyNode dep = (IvyNode)iter.next();
                if (dep.getModuleId().equals(node.getModuleId())) {
                    conflicts.add(dep);
                }
                conflicts.addAll(dep.getResolvedNodes(node.getModuleId(), node.getRootModuleConf()));
            }
        } else if (selectedNodes.isEmpty()) {
            Collection parentDepIvyNodes = node.getParent().getNode().getDependencies(node.getRootModuleConf(), new String[]{node.getParentConf()});
            Iterator it = parentDepIvyNodes.iterator();
            while (it.hasNext()) {
                IvyNode parentDep = (IvyNode)it.next();
                if (!parentDep.getModuleId().equals(node.getModuleId())) continue;
                conflicts.add(parentDep);
            }
        } else {
            conflicts.addAll(selectedNodes);
        }
        return conflicts;
    }

    private boolean checkConflictSolvedSelected(VisitNode visitNode, VisitNode visitNode2) {
        if (visitNode2.getResolvedRevisions(visitNode.getModuleId()).contains(visitNode.getResolvedId())) {
            if (this.settings.debugConflictResolution()) {
                Message.debug("conflict resolution already done for " + visitNode + " in " + visitNode2);
            }
            return true;
        }
        return false;
    }

    private boolean checkConflictSolvedEvicted(VisitNode visitNode, VisitNode visitNode2) {
        if (visitNode2.getEvictedRevisions(visitNode.getModuleId()).contains(visitNode.getResolvedId())) {
            if (this.settings.debugConflictResolution()) {
                Message.debug("conflict resolution already done for " + visitNode + " in " + visitNode2);
            }
            return true;
        }
        return false;
    }

    public DependencyDescriptor mediate(DependencyDescriptor dependencyDescriptor, ResolveOptions resolveOptions) {
        String string;
        if (dependencyDescriptor == null) {
            return null;
        }
        String string2 = string = resolveOptions.getResolveMode() == null ? this.settings.getResolveMode(dependencyDescriptor.getDependencyId()) : resolveOptions.getResolveMode();
        if ("dynamic".equals(string) && !dependencyDescriptor.getDynamicConstraintDependencyRevisionId().equals(dependencyDescriptor.getDependencyRevisionId())) {
            return dependencyDescriptor.clone(ModuleRevisionId.newInstance(dependencyDescriptor.getDynamicConstraintDependencyRevisionId(), dependencyDescriptor.getDynamicConstraintDependencyRevisionId().getRevision()));
        }
        return dependencyDescriptor;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public ResolveEngineSettings getSettings() {
        return this.settings;
    }

    public SortEngine getSortEngine() {
        return this.sortEngine;
    }

    private void checkInterrupted() {
        IvyContext.getContext().getIvy().checkInterrupted();
    }
}

