/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.IOException;
import java.text.ParseException;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.resolver.AbstractResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.Message;

public class DualResolver
extends AbstractResolver {
    private DependencyResolver ivyResolver;
    private DependencyResolver artifactResolver;
    private boolean allownomd = true;

    public ResolvedModuleRevision getDependency(DependencyDescriptor dd, ResolveData data) throws ParseException {
        if (this.ivyResolver == null || this.artifactResolver == null) {
            throw new IllegalStateException("exactly two resolvers must be added: ivy(1) and artifact(2) one");
        }
        ResolvedModuleRevision resolved = data.getCurrentResolvedModuleRevision();
        ResolvedModuleRevision mr = this.ivyResolver.getDependency(dd, data = new ResolveData(data, this.doValidate(data)));
        if (mr == null) {
            this.checkInterrupted();
            if (this.isAllownomd()) {
                Message.verbose("ivy resolver didn't find " + dd + ": trying with artifact resolver");
                return this.artifactResolver.getDependency(dd, data);
            }
            return null;
        }
        if (mr == resolved) {
            return mr;
        }
        return new ResolvedModuleRevision(mr.getResolver(), this, mr.getDescriptor(), mr.getReport(), mr.isForce());
    }

    public ResolvedResource findIvyFileRef(DependencyDescriptor dd, ResolveData data) {
        return this.ivyResolver.findIvyFileRef(dd, data);
    }

    public void reportFailure() {
        this.ivyResolver.reportFailure();
        this.artifactResolver.reportFailure();
    }

    public void reportFailure(Artifact art) {
        this.ivyResolver.reportFailure(art);
        this.artifactResolver.reportFailure(art);
    }

    public DownloadReport download(Artifact[] artifacts, DownloadOptions options) {
        return this.artifactResolver.download(artifacts, options);
    }

    public DependencyResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public DependencyResolver getIvyResolver() {
        return this.ivyResolver;
    }

    public void abortPublishTransaction() throws IOException {
        this.ivyResolver.abortPublishTransaction();
        this.artifactResolver.abortPublishTransaction();
    }

    public void beginPublishTransaction(ModuleRevisionId module, boolean overwrite) throws IOException {
        this.ivyResolver.beginPublishTransaction(module, overwrite);
        this.artifactResolver.beginPublishTransaction(module, overwrite);
    }

    public void commitPublishTransaction() throws IOException {
        this.ivyResolver.commitPublishTransaction();
        this.artifactResolver.commitPublishTransaction();
    }

    public void dumpSettings() {
        if (this.ivyResolver == null || this.artifactResolver == null) {
            throw new IllegalStateException("exactly two resolvers must be added: ivy(1) and artifact(2) one");
        }
        Message.verbose("\t" + this.getName() + " [dual " + this.ivyResolver.getName() + " " + this.artifactResolver.getName() + "]");
    }

    public boolean exists(Artifact artifact) {
        if (artifact.isMetadata()) {
            return this.ivyResolver.exists(artifact);
        }
        return this.artifactResolver.exists(artifact);
    }

    public ArtifactOrigin locate(Artifact artifact) {
        if (artifact.isMetadata()) {
            return this.ivyResolver.locate(artifact);
        }
        return this.artifactResolver.locate(artifact);
    }

    public ArtifactDownloadReport download(ArtifactOrigin artifact, DownloadOptions options) {
        if (artifact.getArtifact().isMetadata()) {
            return this.ivyResolver.download(artifact, options);
        }
        return this.artifactResolver.download(artifact, options);
    }

    public boolean isAllownomd() {
        return this.allownomd;
    }
}

