/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.Message;

public final class ResolverHelper {
    private ResolverHelper() {
    }

    public static String[] listTokenValues(Repository rep, String pattern, String token) {
        String tokenString;
        String fileSep = rep.getFileSeparator();
        int index = (pattern = rep.standardize(pattern)).indexOf(tokenString = IvyPatternHelper.getTokenString(token));
        if (index == -1) {
            Message.verbose("unable to list " + token + " in " + pattern + ": token not found in pattern");
            return null;
        }
        if ((pattern.length() <= index + tokenString.length() || fileSep.equals(pattern.substring(index + tokenString.length(), index + tokenString.length() + 1))) && (index == 0 || fileSep.equals(pattern.substring(index - 1, index)))) {
            String root = pattern.substring(0, index);
            return ResolverHelper.listAll(rep, root);
        }
        int slashIndex = pattern.substring(0, index).lastIndexOf(fileSep);
        String root = slashIndex == -1 ? "" : pattern.substring(0, slashIndex);
        try {
            Message.debug("\tusing " + rep + " to list all in " + root);
            List all = rep.list(root);
            if (all != null) {
                Message.debug("\t\tfound " + all.size() + " urls");
                ArrayList<String> ret = new ArrayList<String>(all.size());
                int endNameIndex = pattern.indexOf(fileSep, slashIndex + 1);
                String namePattern = endNameIndex != -1 ? pattern.substring(slashIndex + 1, endNameIndex) : pattern.substring(slashIndex + 1);
                namePattern = namePattern.replaceAll("\\.", "\\\\.");
                String acceptNamePattern = ".*?" + IvyPatternHelper.substituteToken(namePattern, token, "([^" + fileSep + "]+)") + "($|" + fileSep + ".*)";
                Pattern p = Pattern.compile(acceptNamePattern);
                Iterator iter = all.iterator();
                while (iter.hasNext()) {
                    String path = (String)iter.next();
                    Matcher m = p.matcher(path);
                    if (!m.matches()) continue;
                    String value = m.group(1);
                    ret.add(value);
                }
                Message.debug("\t\t" + ret.size() + " matched " + pattern);
                return ret.toArray(new String[ret.size()]);
            }
            return null;
        }
        catch (IOException e) {
            Message.verbose("problem while listing resources in " + root + " with " + rep + ":");
            Message.verbose("  " + e.getClass().getName() + " " + e.getMessage());
            return null;
        }
        catch (Exception e) {
            Message.warn("problem while listing resources in " + root + " with " + rep + ":");
            Message.warn("  " + e.getClass().getName() + " " + e.getMessage());
            return null;
        }
    }

    public static String[] listAll(Repository rep, String parent) {
        try {
            String fileSep = rep.getFileSeparator();
            Message.debug("\tusing " + rep + " to list all in " + parent);
            List all = rep.list(parent);
            if (all != null) {
                Message.debug("\t\tfound " + all.size() + " resources");
                ArrayList<String> names = new ArrayList<String>(all.size());
                Iterator iter = all.iterator();
                while (iter.hasNext()) {
                    String path = (String)iter.next();
                    if (path.endsWith(fileSep)) {
                        path = path.substring(0, path.length() - 1);
                    }
                    int slashIndex = path.lastIndexOf(fileSep);
                    names.add(path.substring(slashIndex + 1));
                }
                return names.toArray(new String[names.size()]);
            }
            Message.debug("\t\tno resources found");
            return null;
        }
        catch (IOException e) {
            Message.verbose("problem while listing resources in " + parent + " with " + rep + ":");
            Message.verbose("  " + e.getClass().getName() + " " + e.getMessage());
            return null;
        }
        catch (Exception e) {
            Message.warn("problem while listing resources in " + parent + " with " + rep + ":");
            Message.warn("  " + e.getClass().getName() + " " + e.getMessage());
            return null;
        }
    }

    public static ResolvedResource[] findAll(Repository rep, ModuleRevisionId mrid, String pattern, Artifact artifact) {
        String partiallyResolvedPattern = IvyPatternHelper.substitute(pattern, ModuleRevisionId.newInstance(mrid, IvyPatternHelper.getTokenString("revision")), artifact);
        Message.debug("\tlisting all in " + partiallyResolvedPattern);
        String[] revs = ResolverHelper.listTokenValues(rep, partiallyResolvedPattern, "revision");
        if (revs != null) {
            Message.debug("\tfound revs: " + Arrays.asList(revs));
            ArrayList<ResolvedResource> ret = new ArrayList<ResolvedResource>(revs.length);
            for (int i = 0; i < revs.length; ++i) {
                String rres = IvyPatternHelper.substituteToken(partiallyResolvedPattern, "revision", revs[i]);
                try {
                    Resource res = rep.getResource(rres);
                    if (res == null) continue;
                    ret.add(new ResolvedResource(res, revs[i]));
                    continue;
                }
                catch (IOException e) {
                    Message.warn("impossible to get resource from name listed by repository: " + rres + ": " + e.getMessage());
                }
            }
            if (revs.length != ret.size()) {
                Message.debug("\tfound resolved res: " + ret);
            }
            return ret.toArray(new ResolvedResource[ret.size()]);
        }
        if (partiallyResolvedPattern.indexOf("[revision]") == -1) {
            try {
                Resource res = rep.getResource(partiallyResolvedPattern);
                if (res.exists()) {
                    Message.debug("\tonly one resource found without real listing: using and defining it as working@" + rep.getName() + " revision: " + res.getName());
                    return new ResolvedResource[]{new ResolvedResource(res, "working@" + rep.getName())};
                }
            }
            catch (IOException e) {
                Message.debug("\timpossible to get resource from name listed by repository: " + partiallyResolvedPattern + ": " + e.getMessage());
            }
            Message.debug("\tno revision found");
        }
        return null;
    }
}

