/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory.component;

import org.seasar.framework.container.AutoBindingDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.InstanceDef;
import org.seasar.framework.container.annotation.tiger.AutoBindingType;
import org.seasar.framework.container.annotation.tiger.Component;
import org.seasar.framework.container.annotation.tiger.InstanceType;
import org.seasar.framework.container.assembler.AutoBindingDefFactory;
import org.seasar.framework.container.deployer.InstanceDefFactory;
import org.seasar.framework.container.factory.AnnotationHandler;
import org.seasar.framework.container.factory.ComponentDefBuilder;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoComponentDefBuilder
implements ComponentDefBuilder {
    @Override
    public ComponentDef createComponentDef(AnnotationHandler annotationHandler, Class<?> componentClass, InstanceDef defaultInstanceDef, AutoBindingDef defaultAutoBindingDef, boolean defaultExternalBinding) {
        Component component = componentClass.getAnnotation(Component.class);
        if (component == null) {
            return null;
        }
        ComponentDefImpl componentDef = new ComponentDefImpl(componentClass);
        if (!StringUtil.isEmpty((String)component.name())) {
            componentDef.setComponentName(component.name());
        }
        componentDef.setInstanceDef(this.getInstanceDef(component, defaultInstanceDef));
        componentDef.setAutoBindingDef(this.getAutoBindingDef(component, defaultAutoBindingDef));
        componentDef.setExternalBinding(component.externalBinding());
        return componentDef;
    }

    protected InstanceDef getInstanceDef(Component component, InstanceDef defaultInstanceDef) {
        InstanceType instanceType = component.instance();
        if (instanceType == null || StringUtil.isEmpty((String)instanceType.getName())) {
            return defaultInstanceDef;
        }
        return InstanceDefFactory.getInstanceDef((String)instanceType.getName());
    }

    protected AutoBindingDef getAutoBindingDef(Component component, AutoBindingDef defaultAutoBindingDef) {
        AutoBindingType autoBindingType = component.autoBinding();
        if (autoBindingType == null || StringUtil.isEmpty((String)autoBindingType.getName())) {
            return defaultAutoBindingDef;
        }
        return AutoBindingDefFactory.getAutoBindingDef((String)autoBindingType.getName());
    }
}

