/*
 * Copyright 2004-2010 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.framework.container.deployer;

import java.util.Map;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentDeployer;
import org.seasar.framework.container.ExternalContext;
import org.seasar.framework.exception.EmptyRuntimeException;

/**
 * インスタンス属性がapplication用の{@link ComponentDeployer}です。
 * 
 * @author higa
 * 
 */
public class ApplicationComponentDeployer extends AbstractComponentDeployer {

    /**
     * {@link ApplicationComponentDeployer}を作成します。
     * 
     * @param componentDef
     */
    public ApplicationComponentDeployer(ComponentDef componentDef) {
        super(componentDef);
    }

    public Object deploy() {
        ComponentDef cd = getComponentDef();
        ExternalContext extCtx = cd.getContainer().getRoot()
                .getExternalContext();
        if (extCtx == null) {
            throw new EmptyRuntimeException("externalContext");
        }
        Map applicationMap = extCtx.getApplicationMap();
        String componentName = getComponentName();
        Object component = applicationMap.get(componentName);
        if (component == null) {
            component = getConstructorAssembler().assemble();
            getPropertyAssembler().assemble(component);
            getInitMethodAssembler().assemble(component);
            applicationMap.put(componentName, component);
        }
        return component;
    }

    public void injectDependency(Object component) {
        throw new UnsupportedOperationException("injectDependency");
    }

    public void init() {
    }

    public void destroy() {
    }
}