/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import org.h2.command.Prepared;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.Message;
import org.h2.security.SHA256;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.store.FileStoreOutputStream;
import org.h2.tools.CompressTool;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.SmallLRUCache;
import org.h2.value.Value;

public abstract class ScriptBase
extends Prepared
implements DataHandler {
    protected OutputStream out;
    protected InputStream in;
    private Expression file;
    private String fileName;
    private String cipher;
    private byte[] key;
    private FileStore store;
    private String compressionAlgorithm;

    public ScriptBase(Session session) {
        super(session);
    }

    public void setCipher(String c) {
        this.cipher = c;
    }

    protected boolean isEncrypted() {
        return this.cipher != null;
    }

    public void setPassword(char[] password) {
        SHA256 sha = new SHA256();
        this.key = sha.getKeyPasswordHash("script", password);
    }

    public void setFile(Expression file) {
        this.file = file;
    }

    protected String getFileName() throws SQLException {
        if (this.file != null) {
            String string = this.fileName = this.file == null ? null : this.file.getValue(this.session).getString();
            if (this.fileName == null || this.fileName.trim().length() == 0) {
                this.fileName = "script.sql";
            }
            this.fileName = SysProperties.scriptDirectory + this.fileName;
        }
        return this.fileName;
    }

    public boolean isTransactional() {
        return false;
    }

    protected void deleteStore() throws SQLException {
        String fileName = this.getFileName();
        if (fileName != null) {
            FileUtils.delete(fileName);
        }
    }

    private void initStore() throws SQLException {
        byte[] magic = Database.getMagic(true);
        Database db = this.session.getDatabase();
        String fileName = this.getFileName();
        this.store = FileStore.open(db, fileName, "rw", magic, this.cipher, this.key);
        this.store.setCheckedWriting(false);
        this.store.init();
    }

    protected void openOutput() throws SQLException {
        String fileName = this.getFileName();
        if (fileName == null) {
            return;
        }
        if (this.isEncrypted()) {
            this.initStore();
            this.out = new FileStoreOutputStream(this.store, this, this.compressionAlgorithm);
            this.out = new BufferedOutputStream(this.out, 131072);
        } else {
            OutputStream o = FileUtils.openFileOutputStream(fileName, false);
            this.out = new BufferedOutputStream(o, 4096);
            this.out = CompressTool.wrapOutputStream(this.out, this.compressionAlgorithm, "script.sql");
        }
    }

    protected void openInput() throws SQLException {
        String fileName = this.getFileName();
        if (fileName == null) {
            return;
        }
        if (this.isEncrypted()) {
            this.initStore();
            this.in = new FileStoreInputStream(this.store, this, this.compressionAlgorithm != null, false);
        } else {
            InputStream inStream;
            try {
                inStream = FileUtils.openFileInputStream(fileName);
            }
            catch (IOException e) {
                throw Message.convertIOException(e, fileName);
            }
            this.in = new BufferedInputStream(inStream, 4096);
            this.in = CompressTool.wrapInputStream(this.in, this.compressionAlgorithm, "script.sql");
            if (this.in == null) {
                throw Message.getSQLException(90124, "script.sql in " + fileName);
            }
        }
    }

    protected void closeIO() {
        IOUtils.closeSilently(this.out);
        this.out = null;
        IOUtils.closeSilently(this.in);
        this.in = null;
        if (this.store != null) {
            this.store.closeSilently();
            this.store = null;
        }
    }

    public boolean needRecompile() {
        return false;
    }

    public boolean getTextStorage() {
        return true;
    }

    public String getDatabasePath() {
        return null;
    }

    public FileStore openFile(String name, String mode, boolean mustExist) throws SQLException {
        return null;
    }

    public int getChecksum(byte[] data, int start, int end) {
        return this.session.getDatabase().getChecksum(data, start, end);
    }

    public void checkPowerOff() throws SQLException {
        this.session.getDatabase().checkPowerOff();
    }

    public void checkWritingAllowed() throws SQLException {
        this.session.getDatabase().checkWritingAllowed();
    }

    public void freeUpDiskSpace() throws SQLException {
        this.session.getDatabase().checkWritingAllowed();
    }

    public void handleInvalidChecksum() throws SQLException {
        this.session.getDatabase().handleInvalidChecksum();
    }

    public int compareTypeSave(Value a, Value b) throws SQLException {
        throw Message.getInternalError();
    }

    public int getMaxLengthInplaceLob() {
        return this.session.getDatabase().getMaxLengthInplaceLob();
    }

    public int allocateObjectId(boolean b, boolean c) {
        return this.session.getDatabase().allocateObjectId(b, c);
    }

    public String createTempFile() throws SQLException {
        return this.session.getDatabase().createTempFile();
    }

    public String getLobCompressionAlgorithm(int type) {
        return this.session.getDatabase().getLobCompressionAlgorithm(type);
    }

    public void setCompressionAlgorithm(String algorithm) {
        this.compressionAlgorithm = algorithm;
    }

    public Object getLobSyncObject() {
        return this;
    }

    public boolean getLobFilesInDirectories() {
        return this.session.getDatabase().getLobFilesInDirectories();
    }

    public SmallLRUCache getLobFileListCache() {
        return null;
    }
}

