# -*- coding: utf-8 -*-

# お守りのスキル保持用クラス
# 2013/12/09 written by kei9 

import db_supports

class AmuletSkillsHolder(object):
    u""" お守りのスキルを保持するクラス """
    def __init__(self, skill_id_list):
        u""" skill_id_list: list of skill id
            if skill is unknown, element must be None
        """
        self.skill_id_list = list(skill_id_list)

    def is_empty(self):
        u""" すべての要素がNoneのときTrueを返す """
        if all([x is None for x in self.skill_id_list]):
            return True
        else:
            return False

    def get_where_and_sql(self, remove_where=False):
        u""" SQLのWhere文に変換する(AND結合) """
        if any([x is not None for x in self.skill_id_list]):
            valid_eqls = []
            for col, skill_id in zip(db_supports.SEED2_SKILL2_COL_SKILL2_LIST, self.skill_id_list):
                if skill_id is not None:
                    valid_eqls.append(u"{col}={skill_id}".format(col=col,skill_id=skill_id)) 
            if remove_where:
                return u" and ".join(valid_eqls)
            else:
                return u" where " + u" and ".join(valid_eqls)
        else:
            return ""

    def get_where_in_sql(self, remove_where=False):
        u""" SQLのWhere文に変換する(IN結合) """
        if len(self.skill_id_list) >= 1:
            uni_list = [u"{0}".format(x) for x in self.skill_id_list if x is not None]
            sql = u" {col} IN({in_phrase})".format(
                    col=db_supports.MIN_MAX_COL_SKILL_ID,
                    in_phrase=u",".join(uni_list))

            if remove_where:
                return sql
            else:
                return u" where" + sql
        else:
            return ""

