package jp.sourceforge.andjong.mahjong;

/**
 * ͂ǗB
 *
 * @author Yuji Urushibara
 *
 */
public class Kawa {
	/** ̔v̔z̒̍ől */
	public final static int SUTE_HAIS_LENGTH_MAX = 24;

	/** ̔v̔z */
	private SuteHai[] m_suteHais = new SuteHai[SUTE_HAIS_LENGTH_MAX];

	/** ̔v̔z̒ */
	private int m_suteHaisLength = 0;

	{
		for (int i = 0; i < SUTE_HAIS_LENGTH_MAX; i++) {
			m_suteHais[i] = new SuteHai();
		}
	}

	/**
	 * ͂쐬B
	 */
	public Kawa() {
		initialize();
	}

	/**
	 * ͂B
	 */
	public void initialize() {
		m_suteHaisLength = 0;
	}

	/**
	 * ͂Rs[B
	 *
	 * @param a_dest
	 *            Rs[̉
	 * @param a_src
	 *            Rs[̉
	 */
	public static void copy(Kawa a_dest, Kawa a_src) {
		a_dest.m_suteHaisLength = a_src.m_suteHaisLength;
		for (int i = 0; i < a_dest.m_suteHaisLength; i++) {
			SuteHai.copy(a_dest.m_suteHais[i], a_src.m_suteHais[i]);
		}
	}

	/**
	 * ̔v̔z擾B
	 *
	 * @return ̔v̔z
	 */
	public SuteHai[] getSuteHais() {
		return m_suteHais;
	}

	/**
	 * ̔v̔z̒擾B
	 *
	 * @return ̔v̔z̒
	 */
	public int getSuteHaisLength() {
		return m_suteHaisLength;
	}

	/**
	 * ̔v̔zɔvǉB
	 *
	 * @param a_hai
	 *            ǉv
	 */
	public boolean add(Hai a_hai) {
		if (m_suteHaisLength >= SUTE_HAIS_LENGTH_MAX) {
			return false;
		}

		SuteHai.copy(m_suteHais[m_suteHaisLength], a_hai);
		m_suteHaisLength++;

		return true;
	}

	/**
	 * ̔v̔z̍Ō̔vɁAtOݒ肷B
	 *
	 * @param a_naki
	 *            tO
	 */
	public boolean setNaki(boolean a_naki) {
		if (m_suteHaisLength <= 0) {
			return false;
		}

		m_suteHais[m_suteHaisLength - 1].setNaki(a_naki);

		return true;
	}

	/**
	 * ̔v̔z̍Ō̔vɁA[`tOݒ肷B
	 *
	 * @param a_reach
	 *            [`tO
	 */
	public boolean setReach(boolean a_reach) {
		if (m_suteHaisLength <= 0) {
			return false;
		}

		m_suteHais[m_suteHaisLength - 1].setReach(a_reach);

		return true;
	}

	/**
	 * ̔v̔z̍Ō̔vɁAotOݒ肷B
	 *
	 * @param a_tedashi
	 *            otO
	 */
	public boolean setTedashi(boolean a_tedashi) {
		if (m_suteHaisLength <= 0) {
			return false;
		}

		m_suteHais[m_suteHaisLength - 1].setTedashi(a_tedashi);

		return true;
	}
}
