package jp.sourceforge.andjong.mahjong;

/**
 * vC[ǗNXłB
 *
 * @author Yuji Urushibara
 *
 */
class Player {
	/** EventIF */
	private EventIf eventIf;

	/**
	 * EventIF擾܂BB
	 *
	 * @return EventIF
	 */
	EventIf getEventIf() {
		return eventIf;
	}

	/** v */
	private Tehai m_tehai = new Tehai();

	/**
	 * v擾܂B
	 *
	 * @return v
	 */
	Tehai getTehai() {
		return m_tehai;
	}

	/**  */
	private Kawa kawa = new Kawa();

	/**
	 * ͂擾܂B
	 *
	 * @return 
	 */
	Kawa getKawa() {
		return kawa;
	}

	/**  */
	private int jikaze;

	/**
	 * 擾܂B
	 *
	 * @return 
	 */
	int getJikaze() {
		return jikaze;
	}

	/**
	 * ݒ肵܂B
	 *
	 * @param jikaze
	 *            
	 */
	void setJikaze(int jikaze) {
		this.jikaze = jikaze;
	}

	/** __ */
	private int tenbou;

	/**
	 * __擾܂B
	 *
	 * @return
	 */
	int getTenbou() {
		return tenbou;
	}

	/**
	 * __ݒ肵܂B
	 *
	 * @param tenbou
	 *            __
	 */
	void setTenbou(int tenbou) {
		this.tenbou = tenbou;
	}

	/**
	 * __𑝂₵܂B
	 *
	 * @param ten
	 *            _
	 */
	void increaseTenbou(int ten) {
		tenbou += ten;
	}

	/**
	 * __炵܂B
	 *
	 * @param ten
	 *            _
	 */
	void reduceTenbou(int ten) {
		tenbou -= ten;
	}

	/** [` */
	private boolean reach;

	/**
	 * [`擾܂B
	 *
	 * @return [`
	 */
	boolean isReach() {
		return reach;
	}

	/**
	 * [`ݒ肵܂B
	 *
	 * @param reach
	 *            [`
	 */
	void setReach(boolean reach) {
		this.reach = reach;
	}

	/** _u[` */
	private boolean m_doubleReach;

	/**
	 * _u[`擾܂B
	 *
	 * @return _u[`
	 */
	boolean isDoubleReach() {
		return m_doubleReach;
	}

	/**
	 * _u[`ݒ肵܂B
	 *
	 * @param reach
	 *            _u[`
	 */
	void setDoubleReach(boolean a_doubleReach) {
		this.m_doubleReach = a_doubleReach;
	}

	private int m_suteHaisCount;
	void setSuteHaisCount(int a_suteHaisCount) {
		this.m_suteHaisCount = a_suteHaisCount;
	}
	int getSuteHaisCount() {
		return m_suteHaisCount;
	}

	private CountFormat m_countFormat = new CountFormat();

	boolean isTenpai() {
		if (reach) {
			return true;
		}

		Hai addHai;
		for (int id = 0; id < Hai.ID_ITEM_MAX; id++) {
			addHai = new Hai(id);
			m_countFormat.setCountFormat(m_tehai, addHai);
			if (m_countFormat.getCombis(null) > 0) {
				return true;
			}
		}

		return false;
	}

	/**
	 * vC[B
	 *
	 * @param eventIf
	 *            EventIF
	 */
	Player(EventIf eventIf) {
		this.eventIf = eventIf;
	}

	/**
	 * vC[܂B
	 */
	void init() {
		// v܂B
		m_tehai.initialize();

		// ͂܂B
		kawa.initialize();

		// [`܂B
		reach = false;

		m_ippatsu = false;
		m_doubleReach = false;
	}

	public void setIppatsu(boolean a_ippatsu) {
		this.m_ippatsu = a_ippatsu;
	}

	public boolean isIppatsu() {
		return m_ippatsu;
	}

	private boolean m_ippatsu;
}
