package jp.sourceforge.andjong;

import static jp.sourceforge.andjong.Hai.*;

/**
 * ConsoleNXłB
 * 
 * @author Yuji Urushibara
 * 
 */
public class Console implements EventIF {
	/** InfoUIIuWFNg */
	private InfoUI infoUi;

	/** v */
	private Tehai tehai = new Tehai();

	/**  */
	private Kawa kawa = new Kawa();

	/** ̔ṽCfbNX */
	private int sutehaiIdx = 0;

	private String name;

	public String getName() {
		return name;
	}

	/**
	 * UI܂B
	 * 
	 * @param infoUi
	 *            InfoUIIuWFNg
	 */
	public Console(InfoUI infoUi, String name) {
		this.infoUi = infoUi;
		this.name = name;
	}

	private void dispInfo() {
		System.out.println("-------- INFO --------");
		int kyoku = infoUi.getkyoku();
		switch (kyoku) {
		case Game.KYOKU_TON_1:
			System.out.print("[]");
			break;
		case Game.KYOKU_TON_2:
			System.out.print("[]");
			break;
		case Game.KYOKU_TON_3:
			System.out.print("[O]");
			break;
		case Game.KYOKU_TON_4:
			System.out.print("[l]");
			break;
		}
		System.out.print("[" + infoUi.getHonba() + "{]");
		System.out.println("[c:" + infoUi.getTsumoRemain() + "]");
		// h\v\܂B
		Hai[] doras = infoUi.getDoras();
		System.out.print("[h\v]");
		for (Hai hai : doras) {
			System.out.print("[" + idToString(hai.getId()) + "]");
		}
		System.out.println();

		// OȂǂ\Ă݂B
		System.out.println("[" + jikazeToString(0) + "][" + infoUi.getName(0)
				+ "][" + infoUi.getTenbou(0) + "]");
		System.out.println("[" + jikazeToString(1) + "][" + infoUi.getName(1)
				+ "][" + infoUi.getTenbou(1) + "]");
		System.out.println("[" + jikazeToString(2) + "][" + infoUi.getName(2)
				+ "][" + infoUi.getTenbou(2) + "]");
		System.out.println("[" + jikazeToString(3) + "][" + infoUi.getName(3)
				+ "][" + infoUi.getTenbou(3) + "]");

		System.out.println("----------------------");
	}

	/**
	 * Cxg܂B
	 * 
	 * @param fromKaze
	 *            Cxg𔭍s
	 * @param toKaze
	 *            Cxg̑Ώۂ̉
	 * @param eid
	 *            CxgID
	 */
	public EID event(EID eid, int fromKaze, int toKaze) {
		switch (eid) {
		case BASHOGIME:// ꏊ
			// \邱Ƃ͂ȂB
			break;
		case OYAGIME:// e
			// TCU\܂B
			// Sai[] sai = infoUi.getSais();
			// System.out.println("[e][" + sai[0].getNo() + "]["
			// + sai[1].getNo() + "]");
			break;
		case SENPAI:// v
			break;
		case SAIFURI:// TCU
			dispInfo();
			break;
		case RYUUKYOKU:// 
			System.out.println("[]");
			break;
		case NAGASHI:// 
			// \邱Ƃ͂ȂB
			break;
		case TSUMO:// c
			System.out
					.print("[" + jikazeToString(infoUi.getJikaze()) + "][c]");

			// v\܂B
			printJyunTehai(tehai);

			// cv\܂B
			System.out
					.println(":" + idToString((infoUi.getTsumoHai()).getId()));
			break;
		case TSUMOAGARI:// c
			System.out.print("[" + jikazeToString(infoUi.getJikaze())
					+ "][c]");

			// v\܂B
			printJyunTehai(tehai);

			// cv\܂B
			System.out
					.println(":" + idToString((infoUi.getTsumoHai()).getId()));
			break;
		case SUTEHAI:// ̔v
			// ̎̔v݂̂\܂B
			if (fromKaze == infoUi.getJikaze()) {
				System.out.print("[" + jikazeToString(infoUi.getJikaze())
						+ "][̔v]");

				// ͂\܂B
				printKawa(kawa);

				// ̔v\܂B
				// System.out.println(":"
				// + idToString((infoUi.getSuteHai()).getId()));
				System.out.println();
			}
			break;
		case PON:// |
			// ̎̔v݂̂\܂B
			if (fromKaze == infoUi.getJikaze()) {
				System.out.print("[" + jikazeToString(infoUi.getJikaze())
						+ "][|]");

				// v\܂B
				printJyunTehai(tehai);

				System.out.println();

				System.out.print("[" + jikazeToString(infoUi.getJikaze())
						+ "][̔v]");

				// ͂\܂B
				printKawa(kawa);

				// ̔v\܂B
				// System.out.println(":"
				// + idToString((infoUi.getSuteHai()).getId()));
				System.out.println();
			}
			break;
		case REACH:
			// ̎̔v݂̂\܂B
			if (fromKaze == infoUi.getJikaze()) {
				System.out.print("[" + jikazeToString(infoUi.getJikaze())
						+ "][[`]");

				// ͂\܂B
				printKawa(kawa);

				// ̔v\܂B
				// System.out.println(":"
				// + idToString((infoUi.getSuteHai()).getId()));
				System.out.println();
			}
			break;
		case RON:// 
			System.out
					.print("[" + jikazeToString(infoUi.getJikaze()) + "][]");

			// v\܂B
			printJyunTehai(tehai);

			// v\܂B
			System.out.println(":" + idToString((infoUi.getSuteHai()).getId()));
			break;
		default:
			break;
		}

		return EID.NAGASHI;
	}

	public int getSutehaiIdx() {
		return sutehaiIdx;
	}

	/**
	 * v\܂B
	 * <p>
	 * TODO v\邱ƁB
	 * </p>
	 * 
	 * @param tehai
	 *            v
	 */
	private void printJyunTehai(Tehai tehai) {
		infoUi.copyTehai(tehai, infoUi.getJikaze());
		Hai[] jyunTehai = tehai.getJyunTehai();
		int jyunTehaiLength = tehai.getJyunTehaiLength();
		for (int i = 0; i < jyunTehaiLength; i++)
			System.out.print(idToString(jyunTehai[i].getId()));

		int minkousLength = tehai.getMinKousLength();
		Hai[][] minkous = tehai.getMinKous();
		for (int i = 0; i < minkousLength; i++) {
			System.out.print("[");
			System.out.print(idToString(minkous[i][0].getId()));
			System.out.print(idToString(minkous[i][1].getId()));
			System.out.print(idToString(minkous[i][2].getId()));
			System.out.print("]");
		}
	}

	/**
	 * ͂\܂B
	 * 
	 * @param kawa
	 *            
	 */
	private void printKawa(Kawa kawa) {
		infoUi.copyKawa(kawa, infoUi.getJikaze());
		SuteHai[] SuteHai = kawa.getSuteHais();
		int kawaLength = kawa.getSuteHaisLength();
		for (int i = 0; i < kawaLength; i++)
			System.out.print(idToString(SuteHai[i].getId()));
	}

	/**
	 * vԍ𕶎ɕϊ܂
	 * 
	 * @param id
	 *            vԍ
	 * @return 
	 */
	static public String idToString(int id) {
		switch (id) {
		case ID_WAN_1:
			return "";
		case ID_WAN_2:
			return "";
		case ID_WAN_3:
			return "O";
		case ID_WAN_4:
			return "l";
		case ID_WAN_5:
			return "";
		case ID_WAN_6:
			return "Z";
		case ID_WAN_7:
			return "";
		case ID_WAN_8:
			return "";
		case ID_WAN_9:
			return "";
		case ID_PIN_1:
			return "@";
		case ID_PIN_2:
			return "A";
		case ID_PIN_3:
			return "B";
		case ID_PIN_4:
			return "C";
		case ID_PIN_5:
			return "D";
		case ID_PIN_6:
			return "E";
		case ID_PIN_7:
			return "F";
		case ID_PIN_8:
			return "G";
		case ID_PIN_9:
			return "H";
		case ID_SOU_1:
			return "P";
		case ID_SOU_2:
			return "Q";
		case ID_SOU_3:
			return "R";
		case ID_SOU_4:
			return "S";
		case ID_SOU_5:
			return "T";
		case ID_SOU_6:
			return "U";
		case ID_SOU_7:
			return "V";
		case ID_SOU_8:
			return "W";
		case ID_SOU_9:
			return "X";
		case ID_TON:
			return "";
		case ID_NAN:
			return "";
		case ID_SHA:
			return "";
		case ID_PE:
			return "k";
		case ID_HAKU:
			return "";
		case ID_HATSU:
			return "";
		case ID_CHUN:
			return "";
		}

		return null;
	}

	/**
	 * 𕶎ɕϊ܂B
	 * 
	 * @param jikaze
	 *            
	 * @return@
	 */
	static public String jikazeToString(int jikaze) {
		switch (jikaze) {
		case 0:
			return "";
		case 1:
			return "";
		case 2:
			return "";
		case 3:
			return "k";
		}

		return null;
	}
	
	/**
	 * Ă\܂B
	 * 
	 * @param jikaze
	 *            
	 * @return@
	 */
	 public void jikazeToString(Hai addHai) {
		String[] yakuNames = this.infoUi.game.getYakuName(tehai, addHai);
		for(int i = 0 ; i < yakuNames.length ; i++){
			System.out.println(yakuNames[i]);
		}
	}
}
