package jp.sourceforge.andjong;

import java.util.Random;

/**
 * RǗB
 *
 * @author Yuji Urushibara
 *
 */
public class Yama {
	/** Rv̍ő吔 */
	private final static int YAMAHAIS_MAX = 136;

	/** Rv̔z */
	private Hai[] yamaHais = new Hai[YAMAHAIS_MAX];

	/** cv̍ő吔 */
	private final static int TSUMO_HAIS_MAX = 122;

	/** cv̔z */
	private Hai[] tsumoHais = new Hai[TSUMO_HAIS_MAX];

	/** cv̈ʒu */
	private int tsumoHaisIdx;

	/** Vv̍ő吔 */
	private final static int RINSHAN_HAIS_MAX = 4;

	/** Vv̔z */
	private Hai[] rinshanHais = new Hai[RINSHAN_HAIS_MAX];

	/** Vv̈ʒu */
	private int rinshanHaisIdx;

	/** ehv̍ő吔 */
	private final static int DORA_HAIS_MAX = RINSHAN_HAIS_MAX + 1;

	/** \hv̔z */
	private Hai[] omoteDoraHais = new Hai[DORA_HAIS_MAX];

	/** hv̔z */
	private Hai[] uraDoraHais = new Hai[DORA_HAIS_MAX];

	/**
	 * R쐬B
	 */
	Yama() {
		initialize();
		setTsumoHaisStartIdx(0);
	}

	/**
	 * RvB
	 */
	private void initialize() {
		for (int id = Hai.ID_WAN_1, idx = 0; id <= Hai.ID_CHUN; id++) {
			for (int i = 0; i < 4; i++, idx++) {
				yamaHais[idx] = new Hai(id);
			}
		}
	}

	/**
	 * vB
	 */
	void xipai() {
		Random random = new Random();
		Hai temp;

		for (int i = 0, j; i < YAMAHAIS_MAX; i++) {
			j = random.nextInt(YAMAHAIS_MAX);
			temp = yamaHais[i];
			yamaHais[i] = yamaHais[j];
			yamaHais[j] = temp;
		}
	}

	/**
	 * cv擾B
	 *
	 * @return cv
	 */
	Hai tsumo() {
		if (tsumoHaisIdx >= TSUMO_HAIS_MAX) {
			return null;
		}

		Hai tsumoHai = new Hai(tsumoHais[tsumoHaisIdx]);
		tsumoHaisIdx++;

		return tsumoHai;
	}

	/**
	 * Vv擾B
	 *
	 * @return Vv
	 */
	Hai rinshanTsumo() {
		if (rinshanHaisIdx >= RINSHAN_HAIS_MAX) {
			return null;
		}

		Hai rinshanHai = new Hai(rinshanHais[rinshanHaisIdx]);
		rinshanHaisIdx++;

		return rinshanHai;
	}

	/**
	 * \h̔z擾B
	 *
	 * @return \h̔z
	 */
	Hai[] getOmoteDoraHais() {
		int omoteDoraHaisLength = rinshanHaisIdx + 1;
		Hai[] omoteDoraHais = new Hai[omoteDoraHaisLength];

		for (int i = 0; i < omoteDoraHaisLength; i++) {
			omoteDoraHais[i] = new Hai(this.omoteDoraHais[i]);
		}

		return omoteDoraHais;
	}

	/**
	 * h̔z擾B
	 *
	 * @return h̔z
	 */
	Hai[] getUraDoraHais() {
		int uraDoraHaisLength = rinshanHaisIdx + 1;
		Hai[] uraDoraHais = new Hai[uraDoraHaisLength];

		for (int i = 0; i < uraDoraHaisLength; i++) {
			uraDoraHais[i] = new Hai(this.uraDoraHais[i]);
		}

		return uraDoraHais;
	}

	/**
	 * cv̊Jnʒuݒ肷B
	 *
	 * @param tsumoHaiStartIdx
	 *            cv̊Jnʒu
	 */
	boolean setTsumoHaisStartIdx(int tsumoHaiStartIdx) {
		if (tsumoHaiStartIdx >= YAMAHAIS_MAX) {
			return false;
		}

		int yamaHaisIdx = tsumoHaiStartIdx;

		for (int i = 0; i < TSUMO_HAIS_MAX; i++) {
			tsumoHais[i] = yamaHais[yamaHaisIdx];

			yamaHaisIdx++;
			if (yamaHaisIdx >= YAMAHAIS_MAX) {
				yamaHaisIdx = 0;
			}
		}

		for (int i = 0; i < RINSHAN_HAIS_MAX; i++) {
			rinshanHais[i] = yamaHais[yamaHaisIdx];

			yamaHaisIdx++;
			if (yamaHaisIdx >= YAMAHAIS_MAX) {
				yamaHaisIdx = 0;
			}
		}

		for (int i = 0; i < DORA_HAIS_MAX; i++) {
			omoteDoraHais[i] = yamaHais[yamaHaisIdx];

			yamaHaisIdx++;
			if (yamaHaisIdx >= YAMAHAIS_MAX) {
				yamaHaisIdx = 0;
			}

			uraDoraHais[i] = yamaHais[yamaHaisIdx];

			yamaHaisIdx++;
			if (yamaHaisIdx >= YAMAHAIS_MAX) {
				yamaHaisIdx = 0;
			}
		}

		tsumoHaisIdx = 0;
		rinshanHaisIdx = 0;

		return true;
	}

	/**
	 * cv̎c萔擾B
	 *
	 * @return cv̎c萔
	 */
	int getTsumoNokori() {
		return TSUMO_HAIS_MAX - tsumoHaisIdx;
	}
}
