package com.bonpu.slotscratchpro;

import java.util.Random;

import android.app.Activity;
import android.content.Intent;

import com.bonpu.slotscratchpro.R;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Bitmap.Config;
import android.graphics.Paint.Align;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;

public class SlotScratchProView extends View{
	private static final String TAG = "AndjongView";

	/*
	 * wi
	 */

	@Override
	public boolean onKeyDown(int keyCode, KeyEvent event) {
		// TODO ꂽ\bhEX^u
		if (KeyEvent.KEYCODE_DPAD_CENTER == keyCode) {
			if (m_clearMode) {
				m_clearMode = false;
			} else {
				m_clearMode = true;
			}
			//Log.d("test", "KEYCODE_DPAD_CENTER start ");
			allClear();
			//Log.d("test", "KEYCODE_DPAD_CENTER end");
			return true;
		}
		return super.onKeyDown(keyCode, event);
	}

	private boolean m_clearMode = false;
	private Bitmap m_clearImage;
	private void allClear() {
//		synchronized (m_scratchImage) {
//			for (int i = 0; i < 320; i++) {
//				for (int j = 0; j < 320; j++) {
//					m_scratchImage.setPixel(i, j, Color.TRANSPARENT);
//				}
//			}
//		}
		m_scratchImage = m_clearImage;

		for (int i = 0; i < SYMBOL_COLUMN; i++) {
			for (int j = 0; j < SYMBOL_ROW; j++) {
				if (!m_scratchedSymbols[i][j]) {
					m_scratchedSymbols[i][j] = true;
					m_score--;
				}
			}
		}

		upDateWinScore();
		invalidate();
	}

	/** wĩC[W */
	private Bitmap m_backgroundImage;
	/** wĩC[W̃Rs[ */
	private Bitmap m_backgroundImageCopy;
	/** wi̕ */
	private int m_backgroundWidth;
	/** wi̍ */
	private int m_backgroundHeight;

	/*
	 * XNb`
	 */

	/** XNb`̃C[W */
	private Bitmap m_scratchImage;
	/** XNb`̔a */
	private static final int SCRACH_RADIUS = 7;

	/*
	 * XNb`̃x[X
	 */

	/** XNb`̃x[XLeft̊ */
	private static final int SCRACH_BASE_LEFT = 0;
	/** XNb`̃x[XTop̊ */
	private static final int SCRACH_BASE_TOP = 110;
	/** XNb`̃x[XLeft */
	private int m_scratchBaseLeft;
	/** XNb`̃x[XTop */
	private int m_scratchBaseTop;
	/** XNb`̃x[X̕ */
	private int m_scratchBaseWidth;
	/** XNb`̃x[X̍ */
	private int m_scratchBaseHeight;

	/*
	 * V{
	 */

	/** V{̃C[W */
	private Bitmap[] m_symbolImages;
	/** Ԃ7 */
	private static final int SYMBOL_SEVEN_RED = 0;
	/** 7 */
	private static final int SYMBOL_SEVEN_BLUE = 1;
	/** BAR 1 */
	private static final int SYMBOL_BAR_1 = 2;
	/** BAR 2 */
	private static final int SYMBOL_BAR_2 = 3;
	/** BAR 3 */
	private static final int SYMBOL_BAR_3 = 4;
	/** `F[ */
	private static final int SYMBOL_CHERRY = 5;
	/** ΂7 */
	private static final int SYMBOL_SEVEN_GREEN = 6;
	/** V{̍ől */
	private static final int SYMBOL_MAX = 7;

	private static final int[] SYMBOL_SCORE = {10000, 1000, 100, 200, 300, 50, 50000};

	/** V{̗̐ */
	private static final int SYMBOL_COLUMN = 3;
	/** V{̍s̐ */
	private static final int SYMBOL_ROW = 3;

	private static final int SYMBOL_START_LEFT_OFFSET = 10;
	private static final int SYMBOL_START_TOP_OFFSET = 13;
	private static final int SYMBOL_LEFT_OFFSET = 106;
	private static final int SYMBOL_TOP_OFFSET = 103;
	private int m_symbolStartLeftOffset;
	private int m_symbolStartTopOffset;
	private int m_symbolLeftOffset;
	private int m_symbolTopOffset;

	private int[][] m_symbols = new int[SYMBOL_COLUMN][SYMBOL_ROW];
	private Random m_random = new Random();
	private static final int[] REEL = { SYMBOL_SEVEN_GREEN, SYMBOL_SEVEN_RED, SYMBOL_SEVEN_RED, SYMBOL_SEVEN_BLUE, SYMBOL_SEVEN_BLUE, SYMBOL_SEVEN_BLUE, SYMBOL_BAR_3, SYMBOL_BAR_3, SYMBOL_BAR_3, SYMBOL_BAR_3, SYMBOL_BAR_2, SYMBOL_BAR_2, SYMBOL_BAR_2, SYMBOL_BAR_2, SYMBOL_BAR_2, SYMBOL_BAR_1, SYMBOL_BAR_1, SYMBOL_BAR_1, SYMBOL_BAR_1, SYMBOL_BAR_1, SYMBOL_BAR_1, SYMBOL_CHERRY, SYMBOL_CHERRY, SYMBOL_CHERRY, SYMBOL_CHERRY, SYMBOL_CHERRY, SYMBOL_CHERRY, SYMBOL_CHERRY, SYMBOL_CHERRY, SYMBOL_CHERRY, SYMBOL_CHERRY };

	private boolean[][] m_scratchedSymbols = new boolean[SYMBOL_COLUMN][SYMBOL_ROW];

	/** ANeBreB */
	private Game mGame;

	private Paint m_stringPaint;
	private int m_score;
	private int m_winScore;
	private static final int TEXT_SIZE = 24;

	public int getPrefData() {
		return m_score + m_winScore;
	}

	/**
	 * RXgN^
	 *
	 * @param context
	 *            ANeBreB
	 */
	public SlotScratchProView(Context context, int a_score) {
		super(context);

		// ANeBreBۑB
		this.mGame = (Game) context;

		// C[WB
		initializeImage(getResources());

		m_score = a_score;
		m_stringPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
		m_stringPaint.setTextSize(TEXT_SIZE);
		m_stringPaint.setTextAlign(Align.CENTER);

		m_winScore = 0;

		// tH[JXLɂB
		setFocusable(true);
		setFocusableInTouchMode(true);
	}

	/**
	 * C[WB
	 *
	 * @param a_res
	 *            \[X
	 */
	private void initializeImage(Resources a_res) {
		// V{̃C[WB
		m_symbolImages = new Bitmap[SYMBOL_MAX];
		m_symbolImages[SYMBOL_SEVEN_RED] = BitmapFactory.decodeResource(a_res, R.drawable.symbol_seven_red);
		m_symbolImages[SYMBOL_SEVEN_BLUE] = BitmapFactory.decodeResource(a_res, R.drawable.symbol_seven_blue);
		m_symbolImages[SYMBOL_BAR_1] = BitmapFactory.decodeResource(a_res, R.drawable.symbol_bar1);
		m_symbolImages[SYMBOL_BAR_2] = BitmapFactory.decodeResource(a_res, R.drawable.symbol_bar2);
		m_symbolImages[SYMBOL_BAR_3] = BitmapFactory.decodeResource(a_res, R.drawable.symbol_bar3);
		m_symbolImages[SYMBOL_CHERRY] = BitmapFactory.decodeResource(a_res, R.drawable.symbol_cherry);
		m_symbolImages[SYMBOL_SEVEN_GREEN] = BitmapFactory.decodeResource(a_res, R.drawable.symbol_seven_green);

		m_symbolStartLeftOffset = SYMBOL_START_LEFT_OFFSET;
		m_symbolStartTopOffset = SYMBOL_START_TOP_OFFSET;
		m_symbolLeftOffset = SYMBOL_LEFT_OFFSET;
		m_symbolTopOffset = SYMBOL_TOP_OFFSET;

		// wĩC[W̃Rs[B
		m_backgroundImageCopy = BitmapFactory.decodeResource(a_res, R.drawable.background).copy(Bitmap.Config.ARGB_8888, true);
		m_backgroundWidth = m_backgroundImageCopy.getWidth();
		m_backgroundHeight = m_backgroundImageCopy.getHeight();

		// XNb`̃x[XB
		Bitmap scratchBaseImage = BitmapFactory.decodeResource(a_res, R.drawable.scratch_base);
		m_scratchBaseLeft = SCRACH_BASE_LEFT;
		m_scratchBaseTop = SCRACH_BASE_TOP;
		m_scratchBaseWidth = scratchBaseImage.getWidth();
		m_scratchBaseHeight = scratchBaseImage.getHeight();

		// wĩC[W̃Rs[쐬B
		Canvas backgroundCanvas = new Canvas(m_backgroundImageCopy);
		backgroundCanvas.drawBitmap(scratchBaseImage, m_scratchBaseLeft, m_scratchBaseTop, null);

		// wĩC[W쐬B
		m_backgroundImage = m_backgroundImageCopy.copy(Bitmap.Config.ARGB_8888, true);

		// V{`悷B
		drawSymbol(m_backgroundImage);

		// XNb`̃C[W쐬B
		m_scratchImage = BitmapFactory.decodeResource(a_res, R.drawable.scratch).copy(Bitmap.Config.ARGB_8888, true);

		m_clearImage = Bitmap.createBitmap(320, 320, Config.ARGB_8888);
	}

	private void drawSymbol(Bitmap a_image) {
		Canvas canvas = new Canvas(a_image);

		for (int i = 0; i < SYMBOL_COLUMN; i++) {
			for (int j = 0; j < SYMBOL_ROW; j++) {
				m_scratchedSymbols[i][j] = false;
				m_symbols[i][j] = REEL[m_random.nextInt(REEL.length)];
				canvas.drawBitmap(m_symbolImages[m_symbols[i][j]], m_scratchBaseLeft + m_symbolStartLeftOffset + (i * m_symbolLeftOffset), m_scratchBaseTop + m_symbolStartTopOffset + (j * m_symbolTopOffset), null);
			}
		}
	}

	@Override
	protected void onDraw(Canvas a_canvas) {
		// wĩC[W`悷B
		a_canvas.drawBitmap(m_backgroundImage, 0, 0, null);

		// XNb`̃C[W`悷B
		a_canvas.drawBitmap(m_scratchImage, m_scratchBaseLeft, m_scratchBaseTop, null);

		if (m_winScore == 0) {
			drawString(160, 92, a_canvas, Color.WHITE, new Integer(m_score).toString());
		} else {
			drawString(160, 92, a_canvas, Color.RED, new Integer(m_score).toString() + " +" + new Integer(m_winScore).toString());
		}
	}

	private void drawString(int left, int top, Canvas canvas,
			int color, String string) {
		m_stringPaint.setColor(color);
		//m_stringPaint.setTextSize(textSize);
		//m_stringPaint.setTextAlign(a_align);

		canvas.drawText(string, left, top - ((m_stringPaint.ascent() + m_stringPaint.descent()) / 2), m_stringPaint);
	}

	private void upDateWinScore() {
		int winScore = 0;
		// s
		for (int row = 0; row < 3; row++) {
			if (m_scratchedSymbols[0][row] && m_scratchedSymbols[1][row] && m_scratchedSymbols[2][row]) {
				if ((m_symbols[0][row] == m_symbols[1][row]) && (m_symbols[1][row] == m_symbols[2][row])) {
					winScore += SYMBOL_SCORE[m_symbols[0][row]];
				}
			}
		}
		// ȂȂ
		if (m_scratchedSymbols[0][0] && m_scratchedSymbols[1][1] && m_scratchedSymbols[2][2]) {
			if ((m_symbols[0][0] == m_symbols[1][1]) && (m_symbols[1][1] == m_symbols[2][2])) {
				winScore += SYMBOL_SCORE[m_symbols[0][0]];
			}
		}
		// ȂȂ
		if (m_scratchedSymbols[0][2] && m_scratchedSymbols[1][1] && m_scratchedSymbols[2][0]) {
			if ((m_symbols[0][2] == m_symbols[1][1]) && (m_symbols[1][1] == m_symbols[2][0])) {
				winScore += SYMBOL_SCORE[m_symbols[0][2]];
			}
		}
		m_winScore = winScore;
	}

	@Override
	public boolean onTouchEvent(MotionEvent a_event) {
		int x = (int) a_event.getX();
		int y = (int) a_event.getY();
		int action = a_event.getAction();
		int column = 0;
		int row = 0;
		boolean find = false;

		if (action == MotionEvent.ACTION_MOVE) {
			int left = x;
			int top = y - m_scratchBaseTop;
			//Log.d(TAG, "left = " + left + ", top = " + top);
			if ((top >= 0) && (top < (m_scratchBaseHeight))) {
				int color;
				synchronized (m_scratchImage) {
					for (int i = -SCRACH_RADIUS; i <= SCRACH_RADIUS; i++) {
						for (int j = -SCRACH_RADIUS; j <= SCRACH_RADIUS; j++) {
							if ((left + i >= 0) && (left + i < m_scratchBaseWidth) && (top + j >= 0) && (top + j < m_scratchBaseHeight)) {
								color = m_scratchImage.getPixel(left + i, top + j);
								if ((!find) && (color != Color.TRANSPARENT)) {
									find = true;
									if (left < 107) {
										column = 0;
										//Log.d(TAG, "c1");
									} else if (left < 212) {
										column = 1;
										//Log.d(TAG, "c2");
									} else {
										column = 2;
										//Log.d(TAG, "c3");
									}

									if (top < 109) {
										row = 0;
										//Log.d(TAG, "r1");
									} else if (top < 212) {
										row = 1;
										//Log.d(TAG, "r2");
									} else {
										row = 2;
										//Log.d(TAG, "r3");
									}
									if (!m_scratchedSymbols[column][row]) {
										m_scratchedSymbols[column][row] = true;
										m_score--;
										upDateWinScore();
										invalidate();
									}
									//Log.d(TAG, "color = " + color);
								}
								//m_scratchImage.setPixel(left + i, top + j, Color.RED);
								//Log.d(TAG, "i = " + (left + i) + ", j = " + (top + j));
								//m_scratchImage.setPixel(20 + i, 20 + j, Color.RED);
								m_scratchImage.setPixel(left + i, top + j, Color.TRANSPARENT);
							}
						}
					}
				}
				//invalidate();
				invalidate(x - SCRACH_RADIUS, y - SCRACH_RADIUS, x + SCRACH_RADIUS + 1, y + SCRACH_RADIUS + 1);
				return true;
			}
//			int left = x;
//			int top = y - m_scratchBaseTop;
//			if ((top >= SCRACH_RADIUS) && (top < (m_scratchBaseHeight - SCRACH_RADIUS)) && (left >= SCRACH_RADIUS) && (left < (m_scratchBaseWidth - SCRACH_RADIUS))) {
//				if (left <= 106) {
//					Log.d(TAG, "1");
//				} else if (left <= 214) {
//					Log.d(TAG, "2");
//				} else {
//					Log.d(TAG, "3");
//				}
//
//				synchronized (m_scratchImage) {
//					for (int i = -SCRACH_RADIUS; i <= SCRACH_RADIUS; i++) {
//						for (int j = -SCRACH_RADIUS; j <= SCRACH_RADIUS; j++) {
//							m_scratchImage.setPixel(left + i, top + j, Color.TRANSPARENT);
//						}
//					}
//				}
//				invalidate(x - SCRACH_RADIUS, y - SCRACH_RADIUS, x + SCRACH_RADIUS, y + SCRACH_RADIUS);
//				return true;
//			}
		} else if (action == MotionEvent.ACTION_DOWN) {
			if (y >= SCRACH_BASE_TOP + m_scratchBaseHeight) {
				if (x >= m_backgroundWidth / 2) {
					m_score += m_winScore;
					m_winScore = 0;
					// wĩC[W쐬B
					m_backgroundImage = m_backgroundImageCopy.copy(Bitmap.Config.ARGB_8888, true);
					// V{`悷B
					drawSymbol(m_backgroundImage);
					// XNb`̃C[W쐬B
					if (m_clearMode) {
						m_scratchImage = m_clearImage;

						for (int i = 0; i < SYMBOL_COLUMN; i++) {
							for (int j = 0; j < SYMBOL_ROW; j++) {
								m_scratchedSymbols[i][j] = true;
								m_score--;
							}
						}

						upDateWinScore();
					} else {
						m_scratchImage = BitmapFactory.decodeResource(getResources(), R.drawable.scratch).copy(Bitmap.Config.ARGB_8888, true);
					}
					invalidate();
				} else {
					mGame.startActivity(new Intent(mGame, About.class));
				}
			}
		}

		return true;
	}
}