package jp.sourceforge.andjong.mahjong;

/**
 * CxgIFǗNXłB
 *
 * @author Yuji Urushibara
 *
 */
public interface EventIf {
	/** CxgID */
	enum EventId {
		/** Q[̊Jn */
		START_GAME,
		/** ǂ̊Jn */
		START_KYOKU,
		/** c */
		TSUMO,
		/** ̔v̑I */
		SELECT_SUTEHAI,
		/** ̔v */
		SUTEHAI,
		/** [` */
		REACH,
		/** | */
		PON,
		/** `[() */
		CHII_LEFT,
		/** `[() */
		CHII_CENTER,
		/** `[(E) */
		CHII_RIGHT,
		/** 喾 */
		DAIMINKAN,
		/**  */
		KAN,
		/** Þ */
		ANKAN,
		/** c */
		TSUMO_AGARI,
		/**  */
		RON_AGARI,
		/**  */
		NAGASHI,
		/**  */
		RYUUKYOKU,
		/** ǂ̏I */
		END_KYOKU,
		/** Q[̏I */
		END_GAME,

		/** ̃`FbN */
		RON_CHECK,

		/** v҂ */
		UI_WAIT_RIHAI,
		/** is҂ */
		UI_WAIT_PROGRESS,
		/** vC[ANV̓ */
		UI_INPUT_PLAYER_ACTION
	}

	/** () */
	public final static int KAZE_TON = 0;
	/** () */
	public final static int KAZE_NAN = 1;
	/** () */
	public final static int KAZE_SHA = 2;
	/** (k) */
	public final static int KAZE_PE = 3;
	/** ̎ނ̌ */
	public final static int KAZE_KIND_NUM = KAZE_PE + 1;
	/** (Ȃ) */
	public final static int KAZE_NONE = 4;

	/**
	 * CxgIF̖O擾B
	 *
	 * @return CxgIF̖O
	 */
	public String getName();

	/**
	 * ̔ṽCfbNX擾܂B
	 *
	 * @return ̔ṽCfbNX
	 */
	int getISutehai();

	/**
	 * CxgB
	 *
	 * @param a_eventId
	 *            CxgID
	 * @param a_kazeFrom
	 *            Cxg𔭍s
	 * @param a_kazeTo
	 *            Cxg̑ΏۂƂȂ
	 * @return CxgID
	 */
	EventId event(EventId a_eventId, int a_kazeFrom, int a_kazeTo);
}
