package jp.sourceforge.andjong;
import static jp.sourceforge.andjong.Hai.*;
import static jp.sourceforge.andjong.Tehai.JYUNTEHAI_MAX;
import static jp.sourceforge.andjong.AgariSetting.YakuflgName.*;
import jp.sourceforge.andjong.CountFormat.Combi;

/**
 * vŜ̖𔻒肷NXłB
 *
 * @author Hiroyuki Muromachi
 *
 */
public class Yaku {
	public static final int JIKAZE_TON = 0;
	public static final int JIKAZE_NAN = 1;
	public static final int JIKAZE_SYA = 2;
	public static final int JIKAZE_PEI = 3;

	Tehai tehai;
	Hai addHai;
	Combi combi;
	AgariSetting setting;
	YakuHantei yakuhantei[];
	boolean nakiflg = false;

	/**
	 * YakuNX̃RXgN^B
	 * ۑAYakuHanteiNX̔z쐬B
	 * @param tehai v@addHai オv  combi v ̑gݍ킹 info 
	 */
	Yaku(Tehai tehai, Hai addHai, Combi combi,AgariSetting setting){
		this.tehai = tehai;
		this.addHai = addHai;
		this.combi  = combi;
		this.setting = setting;
		//ꍇ
		if((tehai.getMinKansLength() != 0)
		|| (tehai.getMinKousLength() != 0)
		|| (tehai.getMinShunsLength() != 0)
		){
			nakiflg = true;
		}

		YakuHantei buffer[] = {new CheckTanyao(),
							   new CheckPinfu(),
							   new CheckIpeikou(),
							   new CheckReach(),
							   new CheckIppatu(),
							   new CheckTumo(),
							   new CheckTon(),
							   new CheckNan(),
							   new CheckSya(),
							   new CheckPei(),
							   new CheckHaku(),
							   new CheckHatu(),
							   new CheckCyun(),
							   new CheckHaitei(),
							   new CheckHoutei(),
							   new CheckRinsyan(),
							   new CheckCyankan(),
							   new CheckDoubleReach(),
							   new CheckTeetoitu(),
							   new CheckCyanta(),
							   new CheckIkkituukan(),
							   new CheckSansyokuDoukou(),
							   new CheckSansyokuDoujun(),
							   new CheckToitoi(),
							   new CheckSanankou(),
							   new CheckSankantu(),
							   new CheckRyanpeikou(),
							   new CheckHonitu(),
							   new CheckJunCyan(),
							   new CheckSyousangen(),
							   new CheckHonroutou(),
							   new CheckTinitu(),
							   new CheckSuuankou(),
							   new CheckSuukantu(),
							   new CheckDaisangen(),
							   new CheckSyousuushi(),
							   new CheckDaisuushi(),
							   new CheckTuuisou(),
							   new CheckChinroutou(),
							   new CheckRyuuisou(),
							   new CheckCyuurennpoutou(),
							   new CheckKokushi()
		};

		yakuhantei = buffer;

		//𖞐͑̈ʖ͐؂̂Ă
		for(int i = 0 ; i < yakuhantei.length ; i++){
			if((yakuhantei[i].getYakuman() == true) && (yakuhantei[i].getYakuHantei() == true)) {
				for(int j = 0 ; j < yakuhantei.length; j++){
					if(yakuhantei[j].getYakuman() == false){
						yakuhantei[j].setYakuHantei(false);
					}
				}
			}
		}
	}

	/**
	 * vŜ̖|擾܂B
	 *
	 * @return vŜ̖|
	 */
	int getHanSuu(){
		int hanSuu = 0;
		for(int i = 0 ; i < yakuhantei.length ; i++){
			if( yakuhantei[i].getYakuHantei() == true){
				hanSuu+= yakuhantei[i].getHanSuu();
			}
		}

		return hanSuu;
	}

	/**
	 * Ă̖O擾܂B
	 *
	 * @return Ă̖O̔z
	 */
	String[] getYakuName(){
		int count = 0;

		//Ă̐JEg
		for(int i = 0 ; i < yakuhantei.length ; i++){
			if( yakuhantei[i].getYakuHantei() == true){
				count++;
			}
		}

		String yakuName[] = new String[count];
		count = 0;
		for(int i = 0 ; i < yakuhantei.length ; i++){
			if( yakuhantei[i].getYakuHantei() == true){
				yakuName[count] = yakuhantei[i].getYakuName() + " " + yakuhantei[i].getHanSuu() + "|";
				count++;
			}
		}
		return yakuName;
	}

	/**
	 * 𖞂Ă邩擾܂B
	 *
	 * @return 𖞐tO
	 */
	boolean getYakumanflg(){
		for(int i = 0 ; yakuhantei[i] != null ; i++){
			if( yakuhantei[i].getYakuman() == true){
				return true;
			}
		}
		return false;
	}

	/**
	 * ʂ̖𔻒肷NXłB
	 *
	 * @author Hiroyuki Muromachi
	 *
	 */
	private class YakuHantei{
		/** ̐tO */
		boolean hantei = false;
		/** 𖞂̔tO */
		boolean yakuman = false;
		/** ̖O */
		String  yakuName;
		/** ̖| */
		int hanSuu;

		/**
		 * ̐tO擾܂B
		 *
		 * @return ̐tO
		 */
		boolean getYakuHantei(){
			return hantei;
		}

		/**
		 * ̐tOݒ肵܂B
		 *
		 * @param hantei
		 */
		void setYakuHantei(boolean hantei){
			this.hantei = hantei;
		}

		/**
		 * ̖|擾܂B
		 *
		 * @return ̖|
		 */
		int getHanSuu(){
			return hanSuu;
		}

		/**
		 * ̖O擾܂B
		 *
		 * @return ̖O
		 */
		String getYakuName(){
			return yakuName;
		}

		/**
		 * 𖞂̔tO擾܂B
		 *
		 * @return 𖞂̔tO
		 */
		boolean getYakuman(){
			return yakuman;
		}
	}

	private class CheckTanyao extends YakuHantei{
		CheckTanyao(){
			hantei = checkTanyao();
			yakuName = "f";
			hanSuu = 1;
		}
	}

	private class CheckPinfu extends YakuHantei{
		CheckPinfu(){
			hantei = checkPinfu();
			yakuName = "a";
			hanSuu = 1;
		}
	}

	private class CheckIpeikou extends YakuHantei{
		CheckIpeikou(){
			hantei = checkIpeikou();
			if(checkRyanpeikou()){
				hantei = false;
			}
			yakuName = "u";
			hanSuu = 1;
		}
	}

	private class CheckReach extends YakuHantei{
		CheckReach(){
			hantei = checkReach();
			if(checkDoubleReach() == true){
				hantei = false;
			}
			yakuName = "";
			hanSuu = 1;
		}
	}

	private class CheckIppatu extends YakuHantei{
		CheckIppatu(){
			hantei = checkIppatu();
			yakuName = "ꔭ";
			hanSuu = 1;
		}
	}

	private class CheckTumo extends YakuHantei{
		CheckTumo(){
			hantei = checkTumo();
			yakuName = "O̘a";
			hanSuu = 1;
		}
	}

	private class CheckTon extends YakuHantei{
		CheckTon(){
			hantei = checkTon();
			if(setting.getJikaze() == JIKAZE_TON){
				yakuName = "_u";
				hanSuu = 2;
			}else{
				yakuName = "";
				hanSuu = 1;
			}
		}
	}

	private class CheckNan extends YakuHantei{
		CheckNan(){
			hantei = checkNan();
			yakuName = "";
			hanSuu = 1;
		}
	}

	private class CheckSya extends YakuHantei{
		CheckSya(){
			hantei = checkSya();
			yakuName = "";
			hanSuu = 1;
		}
	}

	private class CheckPei extends YakuHantei{
		CheckPei(){
			hantei = checkPei();
			yakuName = "k";
			hanSuu = 1;
		}
	}

	private class CheckHaku extends YakuHantei{
		CheckHaku(){
			hantei = checkHaku();
			yakuName = "";
			hanSuu = 1;
		}
	}

	private class CheckHatu extends YakuHantei{
		CheckHatu(){
			hantei = checkHatu();
			yakuName = "";
			hanSuu = 1;
		}
	}

	private class CheckCyun extends YakuHantei{
		CheckCyun(){
			hantei = checkCyun();
			yakuName = "";
			hanSuu = 1;
		}
	}

	private class CheckHaitei extends YakuHantei{
		CheckHaitei(){
			hantei = checkHaitei();
			yakuName = "Č";
			hanSuu = 1;
		}
	}

	private class CheckHoutei extends YakuHantei{
		CheckHoutei(){
			hantei = checkHoutei();
			yakuName = "͒ꝝ";
			hanSuu = 1;
		}
	}

	private class CheckRinsyan extends YakuHantei{
		CheckRinsyan(){
			hantei = checkRinsyan();
			yakuName = "J";
			hanSuu = 1;
		}
	}

	private class CheckCyankan extends YakuHantei{
		CheckCyankan(){
			hantei = checkCyankan();
			yakuName = "";
			hanSuu = 1;
		}
	}

	private class CheckDoubleReach extends YakuHantei{
		CheckDoubleReach(){
			hantei = checkDoubleReach();
			yakuName = "_u";
			hanSuu = 2;
		}
	}

	private class CheckTeetoitu extends YakuHantei{
		CheckTeetoitu(){
			hantei = checkTeetoitu();
			yakuName = "Ύq";
			hanSuu = 2;
		}
	}

	private class CheckCyanta extends YakuHantei{
		CheckCyanta(){
			hantei = checkCyanta();
			if(checkJunCyan()){
				hantei = false;
			}
			if(checkHonroutou()){
				hantei = false;
			}
			yakuName = "S";
			if (nakiflg == true) {
				hanSuu = 1;
			}else{
				hanSuu = 2;
			}
		}
	}

	private class CheckIkkituukan extends YakuHantei{
		CheckIkkituukan(){
			hantei = checkIkkituukan();
			yakuName = "Cʊ";
			if (nakiflg == true) {
				hanSuu = 1;
			}else{
				hanSuu = 2;
			}
		}
	}

	private class CheckSansyokuDoujun extends YakuHantei{
		CheckSansyokuDoujun(){
			hantei = checkSansyokuDoujun();
			yakuName = "OF";
			if (nakiflg == true) {
				hanSuu = 1;
			}else{
				hanSuu = 2;
			}
		}
	}

	private class CheckSansyokuDoukou extends YakuHantei{
		CheckSansyokuDoukou(){
			hantei = checkSansyokuDoukou();
			yakuName = "OF";
			hanSuu = 2;
		}
	}

	private class CheckToitoi extends YakuHantei{
		CheckToitoi(){
			hantei = checkToitoi();
			yakuName = "΁Xa";
			hanSuu = 2;
		}
	}

	private class CheckSanankou extends YakuHantei{
		CheckSanankou(){
			hantei = checkSanankou();
			yakuName = "OÍ";
			hanSuu = 2;
		}
	}

	private class CheckSankantu extends YakuHantei{
		CheckSankantu(){
			hantei = checkSankantu();
			yakuName = "OȎq";
			hanSuu = 2;
		}
	}

	private class CheckRyanpeikou extends YakuHantei{
		CheckRyanpeikou(){
			hantei = checkRyanpeikou();
			yakuName = "u";
			hanSuu = 3;
		}
	}

	private class CheckHonitu extends YakuHantei{
		CheckHonitu(){
			hantei = checkHonitu();
			if(checkTinitu()){
				hantei = false;
			}
			yakuName = "F";
			if (nakiflg == true) {
				hanSuu = 2;
			}else{
				hanSuu = 3;
			}
		}
	}

	private class CheckJunCyan extends YakuHantei{
		CheckJunCyan(){
			hantei = checkJunCyan();
			yakuName = "S";
			if (nakiflg == true) {
				hanSuu = 2;
			}else{
				hanSuu = 3;
			}
		}
	}

	private class CheckSyousangen extends YakuHantei{
		CheckSyousangen(){
			hantei = checkSyousangen();
			yakuName = "O";
			hanSuu = 2;
		}
	}

	private class CheckHonroutou extends YakuHantei{
		CheckHonroutou(){
			hantei = checkHonroutou();
			yakuName = "V";
			hanSuu = 2;
		}
	}

	private class CheckTinitu extends YakuHantei{
		CheckTinitu(){
			hantei = checkTinitu();
			yakuName = "F";
			if (nakiflg == true) {
				hanSuu = 5;
			}else{
				hanSuu = 6;
			}
		}
	}

	private class CheckSuuankou extends YakuHantei{
		CheckSuuankou(){
			hantei = checkSuuankou();
			yakuName = "lÍ";
			hanSuu = 13;
			yakuman = true;
		}
	}

	private class CheckSuukantu extends YakuHantei{
		CheckSuukantu(){
			hantei = checkSuukantu();
			yakuName = "lȎq";
			hanSuu = 13;
			yakuman = true;
		}
	}

	private class CheckDaisangen extends YakuHantei{
		CheckDaisangen(){
			hantei = checkDaisangen();
			yakuName = "O";
			hanSuu = 13;
			yakuman = true;
		}
	}

	private class CheckSyousuushi extends YakuHantei{
		CheckSyousuushi(){
			hantei = checkSyousuushi();
			yakuName = "l";
			hanSuu = 13;
			yakuman = true;
		}
	}

	private class CheckDaisuushi extends YakuHantei{
		CheckDaisuushi(){
			hantei = checkDaisuushi();
			yakuName = "l";
			hanSuu = 13;
			yakuman = true;
		}
	}

	private class CheckTuuisou extends YakuHantei{
		CheckTuuisou(){
			hantei = checkTuuisou();
			yakuName = "F";
			hanSuu = 13;
			yakuman = true;
		}
	}

	private class CheckChinroutou extends YakuHantei{
		CheckChinroutou(){
			hantei = checkChinroutou();
			yakuName = "V";
			hanSuu = 13;
			yakuman = true;
		}
	}

	private class CheckRyuuisou extends YakuHantei{
		CheckRyuuisou(){
			hantei = checkRyuuisou();
			yakuName = "ΈF";
			hanSuu = 13;
			yakuman = true;
		}
	}
	private class CheckCyuurennpoutou extends YakuHantei{
		CheckCyuurennpoutou(){
			hantei = checkCyuurennpoutou();
			yakuName = "@";
			hanSuu = 13;
			yakuman = true;
		}
	}
	private class CheckKokushi extends YakuHantei{
		CheckKokushi(){
			hantei = checkKokushi();
			yakuName = "mo";
			hanSuu = 13;
			yakuman = true;
		}
	}


	boolean checkTanyao() {
		int id;
		Hai[] jyunTehai = tehai.getJyunTehai();
		Hai checkHai[][];

		//v`FbN
		int jyunTehaiLength = tehai.getJyunTehaiLength();
		for (int i = 0; i < jyunTehaiLength; i++) {
			//PXvȂΕs
			if (jyunTehai[i].isYaotyuu() == true){
				return false;
			}
		}

		//̔v`FbN
		for(int i = 0; i < tehai.getMinShunsLength(); i++){
			checkHai = tehai.getMinShuns();
			id = checkHai[i][0].getNo();
			//123 Ɓ@789 ̏qΕs
			if ((id == 1) || (id == 7)){
				return false;
			}
		}

		//̔v`FbN
		for(int i = 0; i < tehai.getMinKousLength(); i++){
			checkHai = tehai.getMinKous();
			if (checkHai[i][0].isYaotyuu() == true){
				return false;
			}
		}

		//Ȃ̔v`FbN
		for(int i = 0; i < tehai.getMinKansLength(); i++){
			checkHai = tehai.getMinKans();
			if (checkHai[i][0].isYaotyuu() == true){
				return false;
			}
		}

		//ÞȂ̔v`FbN
		for(int i = 0; i < tehai.getAnKansLength(); i++){
			checkHai = tehai.getAnKans();
			if (checkHai[i][0].isYaotyuu() == true){
				return false;
			}
		}

		return true;
	}

	boolean checkPinfu() {
		Hai atamaHai;
		//Ăꍇ͐Ȃ
		if(nakiflg == true){
			return false;
		}

		//ʎqqł͂Ȃ
		if(combi.shunCount != 4){
			return false;
		}

		//Ov
		atamaHai = new Hai(combi.atamaId);
		if( atamaHai.getKind() == KIND_SANGEN ){
			return false;
		}

		//ꕗ
		if( atamaHai.getKind() == KIND_FON
				&& atamaHai.getNo() == setting.getBakaze()){
			return false;
		}

		//
		if( atamaHai.getKind() == KIND_FON
				&& atamaHai.getNo() == setting.getJikaze()){
			return false;
		}

		//v̓҂̏ꍇ͕s
		if(addHai.isTsuu() == true){
			return false;
		}

		//҂ʑ҂
		boolean ryanmenflg = false;
		int addHaiid = addHai.getId();
		//オv̐`FbNďꍇ
		switch(addHai.getNo()){
			//オv1,2,3̏ꍇ123,234,345̏qłĂ邩ǂ`FbN
			case 1:
			case 2:
			case 3:
				for(int i = 0 ; i < combi.shunCount ; i++){
					if(addHaiid == combi.shunIds[i]){
						ryanmenflg = true;
					}
				}
				break;
			//オv4,5,6̏ꍇ456234,567345,678456̏qłĂ邩ǂ`FbN
			case 4:
			case 5:
			case 6:
				for(int i = 0 ; i < combi.shunCount ; i++){
					if((addHaiid == combi.shunIds[i])
					 ||(addHaiid-2 == combi.shunIds[i])){
						ryanmenflg = true;
					}
				}
				break;
			//オv7,8,9̏ꍇ567,678,789̏qłĂ邩ǂ`FbN
			case 7:
			case 8:
			case 9:
				for(int i = 0 ; i < combi.shunCount ; i++){
					if(addHaiid-2 == (combi.shunIds[i])){
						ryanmenflg = true;
					}
				}
				break;
			default:
				break;
		}
		if(ryanmenflg == false){
			return false;
		}


		//𖞂Ă΁A񐬗
		return true;
	}

	boolean checkIpeikou() {
		//Ăꍇ͐Ȃ
		if(nakiflg == true){
			return false;
		}

		//q̑gݍ킹mF
		for (int i = 0; i < combi.shunCount -1; i++) {
			if(combi.shunIds[i] == combi.shunIds[i+1]){
				return true;
			}
		}
		return false;
	}

	boolean checkReach() {
		return setting.getYakuflg(REACH.ordinal());
	}

	boolean checkIppatu() {
		return setting.getYakuflg(IPPATU.ordinal());
	}

	boolean checkTumo() {
		//Ăꍇ͐Ȃ
		if(nakiflg == true){
			return false;
		}
		return setting.getYakuflg(TUMO.ordinal());
	}


	//vłĂ邩ǂ̔Ɏg⏕\bh
	private boolean checkYakuHai(Tehai tehai, Combi combi , int yakuHaiId) {
		int id;
		Hai checkHai[][];

		//v`FbN
		for(int i = 0; i < combi.kouCount ; i++){
			//IDƖvID`FbN
			if( combi.kouIds[i] == yakuHaiId ){
				return true;
			}
		}

		//̔v`FbN
		for(int i = 0; i < tehai.getMinKousLength(); i++){
			checkHai = tehai.getMinKous();
			id = checkHai[i][0].getId();
			//IDƖvID`FbN
			if( id == yakuHaiId ){
				return true;
			}
		}

		//Ȃ̔v`FbN
		for(int i = 0; i < tehai.getMinKansLength(); i++){
			checkHai = tehai.getMinKans();
			id = checkHai[i][0].getId();
			//IDƖvID`FbN
			if( id == yakuHaiId ){
				return true;
			}
		}
		//ÞȂ̔v`FbN
		for(int i = 0; i < tehai.getAnKansLength(); i++){
			checkHai = tehai.getAnKans();
			id = checkHai[i][0].getId();
			//IDƖvID`FbN
			if( id == yakuHaiId ){
				return true;
			}
		}
		return false;
	}

	boolean checkTon() {
		return checkYakuHai(tehai,combi,ID_TON);
	}

	boolean checkNan() {
		if(setting.getJikaze() == JIKAZE_NAN){
			return checkYakuHai(tehai,combi,ID_NAN);
		}else{
			return false;
		}
	}

	boolean checkSya() {
		if(setting.getJikaze() == JIKAZE_SYA){
			return checkYakuHai(tehai,combi,ID_SHA);
		}else{
			return false;
		}
	}

	boolean checkPei() {
		if(setting.getJikaze() == JIKAZE_PEI){
			return checkYakuHai(tehai,combi,ID_PE);
		}else{
			return false;
		}
	}

	boolean checkHaku() {
		return checkYakuHai(tehai,combi,ID_HAKU);
	}

	boolean checkHatu() {
		return checkYakuHai(tehai,combi,ID_HATSU);
	}

	boolean checkCyun() {
		return checkYakuHai(tehai,combi,ID_CHUN);
	}

	boolean checkHaitei() {
		return setting.getYakuflg(HAITEI.ordinal());
	}

	boolean checkHoutei(){
		return setting.getYakuflg(HOUTEI.ordinal());
	}

	boolean checkRinsyan() {
		return setting.getYakuflg(RINSYAN.ordinal());
	}

	boolean checkCyankan() {
		return setting.getYakuflg(CHANKAN.ordinal());
	}

	boolean checkDoubleReach() {
		return setting.getYakuflg(DOUBLEREACH.ordinal());
	}

	boolean checkTeetoitu() {
		//Ăꍇ͐Ȃ
		if(nakiflg == true){
			return false;
		}
		//TODO Ύq
		return false;
	}

	boolean checkCyanta() {
		Hai checkHais[][];
		Hai checkHai;

		//v̍q`FbN
		for(int i = 0; i < combi.kouCount ; i++){
			checkHai = new Hai(combi.kouIds[i]);
			//v̏ꍇ͐`FbN
			if (checkHai.isYaotyuu() == false){
				return false;
			}
		}

		//v̏q`FbN
		for(int i = 0; i < combi.shunCount ; i++){
			checkHai = new Hai(combi.shunIds[i]);
			//v̏ꍇ͐`FbN
			if (checkHai.isTsuu() == false){
				if ((checkHai.getNo() > 1) && (checkHai.getNo() < 7))
					return false;
			}
		}

		//v̓`FbN
		checkHai = new Hai(combi.atamaId);
		if (checkHai.isYaotyuu() == false){
			return false;
		}

		//̔v`FbN
		for(int i = 0; i < tehai.getMinShunsLength(); i++){
			checkHais = tehai.getMinShuns();
			//123 Ɓ@789 ȊȌqΕs
			if ((checkHais[i][0].getNo() > 1) && (checkHais[i][0].getNo() < 7))
				return false;
		}

		//̔v`FbN
		for(int i = 0; i < tehai.getMinKousLength(); i++){
			checkHais = tehai.getMinKous();
			//v̏ꍇ͐`FbN
			if (checkHais[i][0].isYaotyuu() == false){
				return false;
			}
		}

		//Ȃ̔v`FbN
		for(int i = 0; i < tehai.getMinKansLength(); i++){
			checkHais = tehai.getMinKans();
			//v̏ꍇ͐`FbN
			if (checkHais[i][0].isYaotyuu() == false){
				return false;
			}
		}

		//ÞȂ̔v`FbN
		for(int i = 0; i < tehai.getAnKansLength(); i++){
			checkHais = tehai.getAnKans();
			//v̏ꍇ͐`FbN
			if (checkHais[i][0].isYaotyuu() == false){
				return false;
			}
		}

		return true;
	}

	boolean checkIkkituukan() {
		int id;
		Hai checkHai[][];
		boolean ikkituukanflg[]= {false,false,false,false,false,false,false,false,false};
		//ݎqAqAq1,4,7`FbN
		int checkId[] = {ID_WAN_1,ID_WAN_4,ID_WAN_7,ID_PIN_1,ID_PIN_4,ID_PIN_7,ID_SOU_1,ID_SOU_4,ID_SOU_7};

		//v̏q`FbN
		for(int i = 0 ; i < combi.shunCount ; i++){
			id = combi.shunIds[i];
			for(int j =0 ; j < checkId.length ; j++){
				if(id == checkId[j]){
					ikkituukanflg[j] = true;
				}
			}
		}

		//v`FbN
		for(int i = 0 ; i < tehai.getMinShunsLength() ; i++){
			checkHai = tehai.getMinShuns();
			id = checkHai[i][0].getId();
			for(int j =0 ; j < checkId.length ; j++){
				if(id == checkId[j]){
					ikkituukanflg[j] = true;
				}
			}
		}

		//CʊтoĂ邩ǂ`FbN
		if(   (ikkituukanflg[0] == true && ikkituukanflg[1] == true && ikkituukanflg[2] == true )
			||(ikkituukanflg[3] == true && ikkituukanflg[4] == true && ikkituukanflg[5] == true )
			||(ikkituukanflg[6] == true && ikkituukanflg[7] == true && ikkituukanflg[8] == true )){
			return true;
		}else{
			return false;
		}
	}

	//OFłĂ邩ǂ̔Ɏg⏕\bh
	private static void checkSansyoku(int id , boolean sansyokuflg[][]){
		//ݎqAqAq`FbN
		int checkId[] = {ID_WAN_1,ID_PIN_1,ID_SOU_1};
		for(int i =0 ; i < sansyokuflg.length ; i++){
			for(int j = 0; j < sansyokuflg[i].length ; j++){
				if(id == (checkId[i] + j) ){
					sansyokuflg[i][j] = true;
				}
			}
		}
	}

	boolean checkSansyokuDoujun() {
		int id;
		Hai checkHai[][];
		boolean sansyokuflg[][]= new boolean[3][9];

		//tȌ
		for(int i = 0 ; i<sansyokuflg.length; i++){
			for (int k = 0; k <sansyokuflg[i].length ; k++){
				sansyokuflg[i][k] = false;
			}
		}

		//v̏q`FbN
		for(int i = 0 ; i < combi.shunCount ; i++){
			id = combi.shunIds[i];
			checkSansyoku(id,sansyokuflg);
		}

		//v`FbN
		for(int i = 0 ; i < tehai.getMinShunsLength() ; i++){
			checkHai = tehai.getMinShuns();
			id = checkHai[i][0].getId();
			checkSansyoku(id,sansyokuflg);
		}

		//OFoĂ邩ǂ`FbN
		for(int i = 0 ; i < sansyokuflg[0].length ; i++){
			if( (sansyokuflg[0][i] == true) && (sansyokuflg[1][i] == true ) && (sansyokuflg[2][i] == true)){
				return true;
			}
		}
		//oĂȂꍇ falseԋp
		return false;
	}

	boolean checkSansyokuDoukou() {
		int id;
		Hai checkHai[][];
		boolean sansyokuflg[][]= new boolean[3][9];


		//tȌ
		for(int i = 0 ; i<sansyokuflg.length; i++){
			for (int k = 0; k <sansyokuflg[i].length ; k++){
				sansyokuflg[i][k] = false;
			}
		}

		//v̍q`FbN
		for(int i = 0 ; i < combi.kouCount ; i++){
			id = combi.kouIds[i];
			checkSansyoku(id,sansyokuflg);
		}

		//v̖`FbN
		for(int i = 0 ; i < tehai.getMinKousLength() ; i++){
			checkHai = tehai.getMinKous();
			id = checkHai[i][0].getId();
			checkSansyoku(id,sansyokuflg);
		}

		//v̖Ȃ`FbN
		for(int i = 0 ; i < tehai.getMinKansLength() ; i++){
			checkHai = tehai.getMinKans();
			id = checkHai[i][0].getId();
			checkSansyoku(id,sansyokuflg);
		}

		//v̈ÞȂ`FbN
		for(int i = 0 ; i < tehai.getAnKansLength() ; i++){
			checkHai = tehai.getAnKans();
			id = checkHai[i][0].getId();
			checkSansyoku(id,sansyokuflg);
		}

		//OFoĂ邩ǂ`FbN
		for(int i = 0 ; i < sansyokuflg[0].length ; i++){
			if( (sansyokuflg[0][i] == true) && (sansyokuflg[1][i] == true ) && (sansyokuflg[2][i] == true)){
				return true;
			}
		}

		//oĂȂꍇ falseԋp
		return false;
	}

	boolean checkToitoi() {
		//vɏq
		if((combi.shunCount != 0) || (tehai.getMinShunsLength() != 0) ){
			return false;
		}else{
			return true;
		}
	}

	boolean checkSanankou() {

		//΁X`ŖȂΐĂycaPȐꍇAlÍD悳j
		if((checkToitoi() == true)
		 &&(nakiflg == false)){
			return true;
		}

		//ÍƈÞȂ̍vRł͂Ȃꍇ͕s
		if((combi.kouCount + tehai.getAnKansLength()) != 3){
			return false;
		}

		//cオ̏ꍇ͐
		if(setting.getYakuflg(TUMO.ordinal()) == true){
			return true;
		}
		//オ̏ꍇAav
		else{
			int id = addHai.getId();
			//オœ҂̏ꍇ͐
			if(id == combi.atamaId){
				return true;
			}else{
				//avƍqɂȂĂvmF
				boolean checkflg = false;
				for(int i = 0 ; i < combi.kouCount ; i++){
					if(id == combi.kouIds[i]){
						checkflg = true;
					}
				}

				//q̔vŘaꍇ
				if(checkflg == true){
					//vȂΕs
					if(addHai.isTsuu() == true){
						return false;
					}else{
						//q̑҂ɂȂĂȂmF
						//@:11123 1Řa  , 45556 5Řa
						boolean checkshun = false;
						for(int i = 0 ; i < combi.shunCount ; i++){
							switch(addHai.getNo()){
								case 1:
									if(id == combi.shunIds[i]){
										checkshun = true;
									}
									break;
								case 2:
									if((id == combi.shunIds[i])
									 ||(id-1 == combi.shunIds[i])){
										checkshun = true;
									}
									break;
								case 3:
								case 4:
								case 5:
								case 6:
								case 7:
									if((id == combi.shunIds[i])
										 ||(id-1 == combi.shunIds[i])
										 ||(id-2 == combi.shunIds[i])){
											checkshun = true;
									}
									break;
								case 8:
									if((id-1 == combi.shunIds[i])
										 ||(id-2 == combi.shunIds[i])){
											checkshun = true;
									}
									break;
								case 9:
									if(id-2 == combi.shunIds[i]){
											checkshun = true;
									}
									break;
							}
						}
						//q̔vłꍇ͐
						if(checkshun == true){
							return true;
						}
						//֌W鏇qȂꍇ͕s
						else{
							return false;
						}
					}
				}
				//qƊ֌WȂvŘaꍇ͐
				else{
					return true;
				}
			}
		}
	}

	boolean checkSankantu() {
		int kansnumber = 0;
		kansnumber += tehai.getAnKansLength();
		kansnumber += tehai.getMinKansLength();
		if(kansnumber == 3){
			return true;
		}else{
			return false;
		}
	}

	boolean checkRyanpeikou() {
		//Ăꍇ͐Ȃ
		if(nakiflg == true){
			return false;
		}

		//qSł
		if(combi.shunCount < 4){
			return false;
		}

		//q̑gݍ킹mF
		if(combi.shunIds[0] == combi.shunIds[1]
		&& combi.shunIds[2] == combi.shunIds[3]){
			return true;
		}else{
			return false;
		}
	}

	boolean checkHonitu() {
		Hai[] jyunTehai = tehai.getJyunTehai();
		Hai checkHai[][];

		//ݎqAqAq`FbN
		int checkId[] = {KIND_WAN,KIND_PIN,KIND_SOU};

		for (int i = 0 ; i < checkId.length ; i++){
			boolean honituflg = true;
			//v`FbN
			int jyunTehaiLength = tehai.getJyunTehaiLength();
			for (int j = 0; j < jyunTehaiLength; j++) {
				//v(ݎqAqAq)ȊO͎vȊO
				if ((jyunTehai[j].getKind() != checkId[i]) && (jyunTehai[j].isTsuu() == false)){
					honituflg = false;
				}
			}

			//̔v`FbN
			for(int j = 0; j < tehai.getMinShunsLength(); j++){
				checkHai = tehai.getMinShuns();
				//v(ݎqAqAq)ȊO͎vȊO
				if ((checkHai[j][0].getKind() != checkId[i]) && (checkHai[j][0].isTsuu() == false)){
					honituflg = false;
				}
			}

			//̔v`FbN
			for(int j = 0; j < tehai.getMinKousLength(); j++){
				checkHai = tehai.getMinKous();
				//v(ݎqAqAq)ȊO͎vȊO
				if ((checkHai[j][0].getKind() != checkId[i]) && (checkHai[j][0].isTsuu() == false)){
					honituflg = false;
				}
			}

			//Ȃ̔v`FbN
			for(int j = 0; j < tehai.getMinKansLength(); j++){
				checkHai = tehai.getMinKans();
				//v(ݎqAqAq)ȊO͎vȊO
				if ((checkHai[j][0].getKind() != checkId[i]) && (checkHai[j][0].isTsuu() == false)){
					honituflg = false;
				}
			}

			//ÞȂ̔v`FbN
			for(int j = 0; j < tehai.getAnKansLength(); j++){
				checkHai = tehai.getAnKans();
				//v(ݎqAqAq)ȊO͎vȊO
				if ((checkHai[j][0].getKind() != checkId[i]) && (checkHai[j][0].isTsuu() == false)){
					honituflg = false;
				}
			}

			//ꂪĂ
			if(honituflg == true){
				return true;
			}

		}
		//ĂȂΕs
		return false;

	}

	boolean checkJunCyan() {
		Hai checkHais[][];
		Hai checkHai;

		//v̍q`FbN
		for(int i = 0; i < combi.kouCount ; i++){
			checkHai = new Hai(combi.kouIds[i]);
			//vΕs
			if( checkHai.isTsuu() == true){
				return false;
			}

			//vȂΕs
			if(checkHai.isYaotyuu() == false ){
				return false;
			}
		}

		//v̏q`FbN
		for(int i = 0; i < combi.shunCount ; i++){
			checkHai = new Hai(combi.shunIds[i]);
			//vΕs
			if( checkHai.isTsuu() == true){
				return false;
			}

			//v̏ꍇ͐`FbN
			if ((checkHai.getNo() > NO_1) && (checkHai.getNo() < NO_7)){
				return false;
			}
		}

		//v̓`FbN
		checkHai = new Hai(combi.atamaId);
		//vΕs
		if( checkHai.isTsuu() == true){
			return false;
		}
		//vȂΕs
		if(checkHai.isYaotyuu() == false ){
			return false;
		}

		//̔v`FbN
		for(int i = 0; i < tehai.getMinShunsLength(); i++){
			checkHais = tehai.getMinShuns();
			//123 Ɓ@789 ȊȌqΕs
			if ((checkHais[i][0].getNo() > NO_1) && (checkHais[i][0].getNo()< NO_7)){
				return false;
			}
		}

		//̔v`FbN
		for(int i = 0; i < tehai.getMinKousLength(); i++){
			checkHais = tehai.getMinKous();
			//vΕs
			if( checkHais[i][0].isTsuu() == true){
				return false;
			}
			//vȂΕs
			if(checkHais[i][0].isYaotyuu() == false ){
				return false;
			}
		}

		//Ȃ̔v`FbN
		for(int i = 0; i < tehai.getMinKansLength(); i++){
			checkHais = tehai.getMinKans();
			//vΕs
			if( checkHais[i][0].isTsuu() == true){
				return false;
			}
			//vȂΕs
			if(checkHais[i][0].isYaotyuu() == false ){
				return false;
			}
		}

		//ÞȂ̔v`FbN
		for(int i = 0; i < tehai.getAnKansLength(); i++){
			checkHais = tehai.getAnKans();
			//vΕs
			if( checkHais[i][0].isTsuu() == true){
				return false;
			}
			//vȂΕs
			if(checkHais[i][0].isYaotyuu() == false ){
				return false;
			}
		}

		return true;
	}

	boolean checkSyousangen() {
		//OvĂ𒲂ׂ
		int countSangen = 0;
		//q
		if(checkHaku() == true){
			countSangen++;
		}
		//q
		if(checkHatu() == true){
			countSangen++;
		}
		//q
		if(checkCyun() == true){
			countSangen++;
		}
		//Ov AOv2
		Hai atamaHai = new Hai(combi.atamaId);
		if((atamaHai.getKind() == KIND_SANGEN) && (countSangen == 2)){
			return true;
		}

		return false;
	}

	boolean checkHonroutou() {
		//gCgCĂ
		if(checkToitoi() == false){
			return false;
		}

		//`^Ă
		if(checkCyanta() == true){
			return true;
		}else{
			return false;
		}
	}

	boolean checkRenhou() {
		if(setting.getYakuflg(RENHOU.ordinal())){
			return true;
		}else{
			return false;
		}
	}

	boolean checkTinitu() {
		Hai[] jyunTehai = tehai.getJyunTehai();
		Hai checkHai[][];

		//ݎqAqAq`FbN
		int checkId[] = {KIND_WAN,KIND_PIN,KIND_SOU};

		for (int i = 0 ; i < checkId.length ; i++){
			boolean Tinituflg = true;
			//v`FbN
			int jyunTehaiLength = tehai.getJyunTehaiLength();
			for (int j = 0; j < jyunTehaiLength; j++) {
				//v(ݎqAqAq)ȊO
				if (jyunTehai[j].getKind() != checkId[i]){
					Tinituflg = false;
				}
			}

			//̔v`FbN
			for(int j = 0; j < tehai.getMinShunsLength(); j++){
				checkHai = tehai.getMinShuns();
				//v(ݎqAqAq)ȊO
				if (checkHai[j][0].getKind() != checkId[i]){
					Tinituflg = false;
				}
			}

			//̔v`FbN
			for(int j = 0; j < tehai.getMinKousLength(); j++){
				checkHai = tehai.getMinKous();
				//v(ݎqAqAq)ȊO
				if (checkHai[j][0].getKind() != checkId[i]){
					Tinituflg = false;
				}
			}

			//Ȃ̔v`FbN
			for(int j = 0; j < tehai.getMinKansLength(); j++){
				checkHai = tehai.getMinKans();
				//v(ݎqAqAq)ȊO
				if (checkHai[j][0].getKind() != checkId[i]){
					Tinituflg = false;
				}
			}

			//ÞȂ̔v`FbN
			for(int j = 0; j < tehai.getAnKansLength(); j++){
				checkHai = tehai.getAnKans();
				//v(ݎqAqAq)ȊO
				if (checkHai[j][0].getKind() != checkId[i]){
					Tinituflg = false;
				}
			}

			//ꂪĂ
			if(Tinituflg == true){
				return true;
			}

		}
		//ĂȂΕs
		return false;

	}

	boolean checkSuuankou() {
		//v̈Í4
		if((combi.kouCount + tehai.getAnKansLength()) != 4){
			return false;
		}else{
			//cȁꍇ͐
			if(setting.getYakuflg(TUMO.ordinal())){
				return true;
			}
			//ȁꍇ
			else{
				//҂Ȃΐ (lÍPR҂)
				if(addHai.getId() == combi.atamaId){
					return true;
				}else{
					return false;
				}
			}
		}
	}

	boolean checkSuukantu() {
		int kansnumber = 0;
		kansnumber += tehai.getAnKansLength();
		kansnumber += tehai.getMinKansLength();
		if(kansnumber == 4){
			return true;
		}else{
			return false;
		}
	}

	boolean checkDaisangen() {
		//OvĂ𒲂ׂ
		int countSangen = 0;
		//q
		if(checkHaku() == true){
			countSangen++;
		}
		//q
		if(checkHatu() == true){
			countSangen++;
		}
		//q
		if(checkCyun() == true){
			countSangen++;
		}
		//RvRĂ
		if(countSangen == 3){
			return true;
		}else{
			return false;
		}
	}

	boolean checkTenhou() {
		return setting.getYakuflg(TENHOU.ordinal());
	}

	boolean checkTihou() {
		return setting.getYakuflg(TIHOU.ordinal());
	}

	boolean checkSyousuushi() {
		//vĂ𒲂ׂ
		int countFon = 0;
		//q
		if(checkTon() == true){
			countFon++;
		}
		//삪q
		if(checkNan() == true){
			countFon++;
		}
		//q
		if(checkSya() == true){
			countFon++;
		}
		//kq
		if(checkPei() == true){
			countFon++;
		}

		//v Av3
		Hai atamaHai = new Hai(combi.atamaId);
		if((atamaHai.getKind() == KIND_FON) && (countFon == 3)){
			return true;
		}else{
			return false;
		}
	}

	boolean checkDaisuushi() {
		//vĂ𒲂ׂ
		int countFon = 0;
		//q
		if(checkTon() == true){
			countFon++;
		}
		//삪q
		if(checkNan() == true){
			countFon++;
		}
		//q
		if(checkSya() == true){
			countFon++;
		}
		//kq
		if(checkPei() == true){
			countFon++;
		}
			//v4
		if(countFon == 4){
			return true;
		}else{
			return false;
		}
	}

	boolean checkTuuisou() {
		Hai[] jyunTehai = tehai.getJyunTehai();
		Hai checkHai[][];

		//q邩ǂmF
		if(checkToitoi() == false){
			return false;
		}

		//v`FbN
		int jyunTehaiLength = tehai.getJyunTehaiLength();
		for (int j = 0; j < jyunTehaiLength; j++) {
			//vvł͂Ȃ
			if (jyunTehai[j].isTsuu() == false){
				return false;
			}
		}

		//̔v`FbN
		for(int j = 0; j < tehai.getMinKousLength(); j++){
			checkHai = tehai.getMinKous();
			//vvł͂Ȃ
			if (checkHai[j][0].isTsuu() == false){
				return false;
			}
		}

		//Ȃ̔v`FbN
		for(int j = 0; j < tehai.getMinKansLength(); j++){
			checkHai = tehai.getMinKans();
			//vvł͂Ȃ
			if (checkHai[j][0].isTsuu() == false){
				return false;
			}
		}

		//ÞȂ̔v`FbN
		for(int j = 0; j < tehai.getAnKansLength(); j++){
			checkHai = tehai.getAnKans();
			//vvł͂Ȃ
			if (checkHai[j][0].isTsuu() == false){
				return false;
			}
		}

		return true;
	}

	boolean checkChinroutou() {
		//q邩ǂmF
		if(checkToitoi() == false){
			return false;
		}

		//qȂŃW`Ă邩i19݂̂ō쐬j
		if(checkJunCyan() == false){
			return false;
		}

		return true;

	}

	boolean checkRyuuisou() {
		int checkId[] = {ID_SOU_2,ID_SOU_3,ID_SOU_4,ID_SOU_6,ID_SOU_8,ID_HATSU};
		int id;
		boolean ryuuisouflg = false;
		Hai[] jyunTehai = tehai.getJyunTehai();
		Hai checkHai[][];

		//v`FbN
		int jyunTehaiLength = tehai.getJyunTehaiLength();
		for (int i = 0; i < jyunTehaiLength; i++) {
			id = jyunTehai[i].getId();
			ryuuisouflg = false;
			for(int j = 0 ; j < checkId.length ; j++){
				//ΈFɎgpłv
				if(id == checkId[j]){
					ryuuisouflg = true;
				}
			}
			//Yvł͂Ȃ
			if(ryuuisouflg == false){
				return false;
			}
		}

		//̔v`FbN
		for(int i = 0; i < tehai.getMinShunsLength(); i++){
			checkHai = tehai.getMinShuns();
			id = checkHai[i][0].getId();
			//q2,3,4ȊȌqꍇs
			if (id != ID_SOU_2){
				return false;
			}
		}

		//̔v`FbN
		for(int i = 0; i < tehai.getMinKousLength(); i++){
			checkHai = tehai.getMinKous();
			id = checkHai[i][0].getId();
			ryuuisouflg = false;
			for(int j = 0 ; j < checkId.length ; j++){
				//ΈFɎgpłv
				if(id == checkId[j]){
					ryuuisouflg = true;
				}
			}
			//Yvł͂Ȃ
			if(ryuuisouflg == false){
				return false;
			}
		}

		//Ȃ̔v`FbN
		for(int i = 0; i < tehai.getMinKansLength(); i++){
			checkHai = tehai.getMinKans();
			id = checkHai[i][0].getId();
			ryuuisouflg = false;
			for(int j = 0 ; j < checkId.length ; j++){
				//ΈFɎgpłv
				if(id == checkId[j]){
					ryuuisouflg = true;
				}
			}
			//Yvł͂Ȃ
			if(ryuuisouflg == false){
				return false;
			}
		}

		//ÞȂ̔v`FbN
		for(int i = 0; i < tehai.getAnKansLength(); i++){
			checkHai = tehai.getAnKans();
			id = checkHai[i][0].getId();
			ryuuisouflg = false;
			for(int j = 0 ; j < checkId.length ; j++){
				//ΈFɎgpłv
				if(id == checkId[j]){
					ryuuisouflg = true;
				}
			}
			//Yvł͂Ȃ
			if(ryuuisouflg == false){
				return false;
			}
		}

		//ɊY
		return true;
	}

	boolean checkCyuurennpoutou() {
		//v̐𒲂ׂ邽߂̔z (0Ԓn͎gpȂj
		int countNumber[] = {0,0,0,0,0,0,0,0,0,0};
		Hai checkHai[] = new Hai[JYUNTEHAI_MAX];

		//ꍇ͐Ȃ
		if(nakiflg == true){
			return false;
		}
		//vɂȂĂȂꍇȂ
		if(checkTinitu() == false){
			return false;
		}

		//vRs[
		checkHai = tehai.getJyunTehai();

		//vɂv̔ԍ𒲂ׂ
		for(int i = 0 ; i < tehai.getJyunTehaiLength() ; i++){
			//̔ԍCNg
			countNumber[checkHai[i].getNo()]++;
		}

		//@󓕂ɂȂĂ邩ׂi19Rȏ 2`8Pȏ)
		if(( countNumber[1] >= 3)
		&& ( countNumber[2] >= 1)
		&& ( countNumber[3] >= 1)
		&& ( countNumber[4] >= 1)
		&& ( countNumber[5] >= 1)
		&& ( countNumber[6] >= 1)
		&& ( countNumber[7] >= 1)
		&& ( countNumber[8] >= 1)
		&& ( countNumber[9] >= 3)){
			return true;
		}
		return false;
	}

	boolean checkKokushi() {
		//v̐𒲂ׂ邽߂̔z (0Ԓn͎gpȂj
		int checkId[] = {ID_WAN_1,ID_WAN_9,ID_PIN_1,ID_PIN_9,ID_SOU_1,ID_SOU_9,
								ID_TON,ID_NAN,ID_SHA,ID_PE,ID_HAKU,ID_HATSU,ID_CHUN};
		int countHai[] = {0,0,0,0,0,0,0,0,0,0,0,0,0};
		Hai checkHai[] = new Hai[JYUNTEHAI_MAX];

		//ꍇ͐Ȃ
		if(nakiflg == true){
			return false;
		}

		//vRs[
		checkHai = tehai.getJyunTehai();

		//vID
		for(int i = 0 ; i < tehai.getJyunTehaiLength() ; i++){
			for(int j = 0 ; j < checkId.length ; j++){
				if(checkHai[i].getId() == checkId[j]){
					countHai[j]++;
				}
			}
		}

		//moĂ邩ׂ(vׂ1.9v ׂĂ̂P,XvĂj
		for(int i = 0 ; i < countHai.length ; i++){
			//0̔vΕs
			if(countHai[i] == 0){
				return false;
			}
		}
		//𖞂Ăΐ
		return true;
	}
}
