package com.bonpu.slotscratchpro;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.Window;
import android.view.WindowManager;

public class Game extends Activity {
	private SlotScratchProView m_slotScratchView;

	private static final String PREF_DATA = "pref_data";

	@Override
	protected void onPause() {
		// TODO ꂽ\bhEX^u
		super.onPause();

		int prefData = m_slotScratchView.getPrefData();
		//Log.d("Game", "onPause, prefData = " + prefData);
		getPreferences(Context.MODE_PRIVATE).edit().putInt(PREF_DATA, prefData).commit();
		//int score = getPreferences(Context.MODE_PRIVATE).getInt(PREF_DATA, 1000);
		//Log.d("Game", "onPause, score = " + score);
	}

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		// ^Cg\Ȃ悤ɂB
		requestWindowFeature(Window.FEATURE_NO_TITLE);

		// tXN[ɂB
		getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);

		int score = getPreferences(Context.MODE_PRIVATE).getInt(PREF_DATA, 1000);
		//Log.d("Game", "onCreate, " + score);

		// View쐬B
		m_slotScratchView = new SlotScratchProView(this, score);
		setContentView(m_slotScratchView);
		m_slotScratchView.requestFocus();
	}
}
