package jp.sourceforge.android_ab.addressbook.common.helper;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

import jp.sourceforge.android_ab.addressbook.common.data.ContactDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.HistoryDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.HistoryDetailDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.impl.HistoryDataElementImpl;
import jp.sourceforge.android_ab.addressbook.common.data.impl.HistoryDetailDataElementImpl;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.CallLog;
import android.provider.CallLog.Calls;
import android.provider.ContactsContract.PhoneLookup;
import android.text.TextUtils;

/**
 * TODO: [hɎԂĂ悤Ȃ̂ŗv
 * @author toshiaki
 *
 */
public class HistoryDataHelper extends ContactDataHelper {
	private Map<Object, HistoryDataElement> contacts;

	public HistoryDataHelper(Context context) {
		super(context);
		contacts = new LinkedHashMap<Object, HistoryDataElement>();
	}

	public Collection<HistoryDataElement> getHistory() {
		Uri uri = CallLog.Calls.CONTENT_URI;
		ContentResolver cr = getContext().getContentResolver();

		Cursor cursor = cr.query(uri, null, null, null,
				CallLog.Calls.DEFAULT_SORT_ORDER);

		while (cursor.moveToNext()) {
			HistoryDetailDataElementImpl data = new HistoryDetailDataElementImpl();
			data.setCachedName(
					cursor.getString(cursor.getColumnIndex(Calls.CACHED_NAME)));
			data.setCachedNumberLabel(
					cursor.getString(cursor.getColumnIndex(Calls.CACHED_NUMBER_LABEL)));
			data.setCachedNumberType(
					cursor.getInt(cursor.getColumnIndex(Calls.CACHED_NUMBER_TYPE)));
			data.setDate(cursor.getLong(cursor.getColumnIndex(Calls.DATE)));
			data.setDuration(
					cursor.getLong(cursor.getColumnIndex(Calls.DURATION)));
			data.setNumber(cursor.getString(cursor.getColumnIndex(Calls.NUMBER)));
			data.setType(cursor.getInt(cursor.getColumnIndex(Calls.TYPE)));

			// TODO: new̒lPtruevmF
			int intNewFlag = cursor.getInt(cursor.getColumnIndex(Calls.NEW));
			boolean newFlag = intNewFlag == 1 ? true : false;
			data.setNewFlag(newFlag);

			loadContact(data);
		}

		return contacts.values();
	}

	private ContactDataElement loadContact(HistoryDetailDataElement callLog) {
		String number = callLog.getNumber();
		
		HistoryDataElementImpl contact;
		if(contacts.containsKey(number)) {
			contact = (HistoryDataElementImpl) contacts.get(number);
			contact.addHistory(callLog);
			
			return contact;
		}
		
		Uri uri = Uri.withAppendedPath(PhoneLookup.CONTENT_FILTER_URI, number);

		ContentResolver cr = getContext().getContentResolver();
		Cursor cursor = cr.query(uri, null, null, null, null);


		// A悪擾łȂꍇA_~[̘A쐬
		// TODO: R^NgIDǂH
		if (!cursor.moveToFirst()) {
			return loadDummyContact(callLog);
		}

		contact = (HistoryDataElementImpl) 
				loadContactData(cursor, new HistoryDataElementImpl());
		contact.setLastContactDate(callLog.getDate());
		contacts.put(number, contact);
//		long contactId = cursor.getLong(cursor.getColumnIndex(Contacts._ID));
//		if (contacts.containsKey(contactId)) {
//			contact = (HistoryDataElementImpl) contacts.get(contactId);
//		} else {
//			contact = (HistoryDataElementImpl) 
//					loadContactData(cursor, new HistoryDataElementImpl());
//			contact.setLastContactDate(callLog.getDate());
//			contacts.put(contactId, contact);
//		}

		contact.addHistory(callLog);

		return contact;
	}

	private ContactDataElement loadDummyContact(HistoryDetailDataElement callLog) {
		String key = callLog.getNumber();
		HistoryDataElementImpl data = (HistoryDataElementImpl) contacts
				.get(key);
		if (data == null) {
			data = new HistoryDataElementImpl();
			data.setId(0);
			String displayName = TextUtils.isEmpty(callLog.getCachedName()) ? 
					key: callLog.getCachedName();
			data.setDisplayName(displayName);
			data.setLastContactDate(callLog.getDate());
		}

		data.addHistory(callLog);
		contacts.put(key, data);

		return data;
	}
}
