package jp.sourceforge.android_ab.addressbook.common.data;

import java.util.List;

import jp.sourceforge.android_ab.addressbook.common.data.detail.EmailDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.EventDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.GroupMembershipDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.ImDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.NicknameDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.NoteDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.OrganizationDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.PhoneDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.PhotoDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.RelationDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.SipAddressDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.StructuredNameDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.StructuredPostalDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.WebsiteDataElement;


public interface ContactDetailDataElement extends ContactDataElement {
	public List<StructuredNameDataElement> getStructuredName();
	public void addStructuredName(StructuredNameDataElement element);
	public void removeStructuredName(StructuredNameDataElement element);
	
	public List<PhoneDataElement> getPhone();
	public void addPhone(PhoneDataElement element);
	public void removePhone(PhoneDataElement element);
	
	public List<EmailDataElement> getEmail();
	public void addEmail(EmailDataElement element);
	public void removeEmail(EmailDataElement element);
	
	public List<PhotoDataElement> getPhoto();
	public void addPhoto(PhotoDataElement element);
	public void removePhoto(PhotoDataElement element);
	
	public List<OrganizationDataElement> getOrganization();
	public void addOrganization(OrganizationDataElement element);
	public void removeOrganization(OrganizationDataElement element);
	
	public List<ImDataElement> getIm();
	public void addIm(ImDataElement element);
	public void removeIm(ImDataElement element);
	
	public List<NicknameDataElement> getNickname();
	public void addNickname(NicknameDataElement element);
	public void removeNickname(NicknameDataElement element);
	
	public List<NoteDataElement> getNote();
	public void addNote(NoteDataElement element);
	public void removeNote(NoteDataElement element);
	
	public List<StructuredPostalDataElement> getStructuredPostal();
	public void addStructuredPostal(StructuredPostalDataElement element);
	public void removeStructuredPostal(StructuredPostalDataElement element);
	
	public List<GroupMembershipDataElement> getGroupMembership();
	public void addGroupMembership(GroupMembershipDataElement element);
	public void removeGroupMembership(GroupMembershipDataElement element);
	
	public List<WebsiteDataElement> getWebsite();
	public void addWebsite(WebsiteDataElement element);
	public void removeWebsite(WebsiteDataElement element);
	
	public List<EventDataElement> getEvent();
	public void addEvent(EventDataElement element);
	public void removeEvent(EventDataElement element);
	
	public List<RelationDataElement> getRelation();
	public void addRelation(RelationDataElement element);
	public void removeRelation(RelationDataElement element);
	
	public List<SipAddressDataElement> getSipAddress();
	public void addSipAddress(SipAddressDataElement element);
	public void removeSipAddress(SipAddressDataElement element);
}
