package jp.sourceforge.android_ab.addressbook.common.data.impl;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.android_ab.addressbook.common.data.AccountDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.GroupDataElement;

public class AccountDataElementImpl extends GroupDataElementImpl implements AccountDataElement {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private String accountName;

	private String accountType;
	
	private ArrayList<GroupDataElement> groups = new ArrayList<GroupDataElement>();
	
	public String getAccountName() {
		return accountName;
	}
	
	public void setAccountName(String accountName) {
		this.accountName = accountName;
	}
	
	public String getAccountType() {
		return accountType;
	}
	
	public void setAccountType(String acctounType) {
		this.accountType = acctounType;
	}

	public List<GroupDataElement> getGroup() {
		return groups;
	}
	
	public void addGroup(GroupDataElement element) {
		groups.add(element);
	}

	public boolean hasGroup() {
		return !groups.isEmpty();
	}
	
	public String getTitle() {
		if(hasGroup()) {
			return getAccountName();
		}
		
		return super.getTitle();
	}
}
