/*
 * Copyright (c) 2012, ToshiakiAsazuma All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * ERedistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  
 * ERedistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation
 *  and/or other materials provided with the distribution.
 *  
 * ENeither the name of the ToshiakiAsazuma nor the names of its contributors
 *  may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *  
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 *  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 *  OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 *  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 *  OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 *  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.sourceforge.android_ab.addressbook.addressdetail.view;

import java.io.InputStream;
import java.util.List;

import jp.sourceforge.android_ab.addressbook.R;
import jp.sourceforge.android_ab.addressbook.addressdetail.adapter.AddressDetailInfoAdapter;
import jp.sourceforge.android_ab.addressbook.addressdetail.data.AddressDetailDataBean;
import jp.sourceforge.android_ab.addressbook.addressdetail.data.AddressEmailDataBean;
import jp.sourceforge.android_ab.addressbook.addressdetail.data.AddressImDataBean;
import jp.sourceforge.android_ab.addressbook.addressdetail.data.AddressPhoneDataBean;
import jp.sourceforge.android_ab.addressbook.common.helper.AddressDetailDataHelper;
import android.content.ContentUris;
import android.content.Context;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Bundle;
import android.provider.ContactsContract.Contacts;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListView;
import android.widget.QuickContactBadge;
import android.widget.TextView;

public class ContactInfoPage extends Fragment {
	public static ContactInfoPage newInstance(Uri targetUri) {
		ContactInfoPage f = new ContactInfoPage();
		Bundle args = new Bundle();
		f.setArguments(args);
		return new ContactInfoPage();
	}
	
	@Override
	public void onCreate(Bundle savedInstanceState) {
		Log.d("AddressDetailActivity", "onCreate: start");
		super.onCreate(savedInstanceState);
		Log.d("AddressDetailActivity", "onCreate: end");
	}
	
	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,Bundle savedInstanceState) {
		View view = (ViewGroup) inflater.inflate(R.layout.addressdetail, null);
		
		ViewGroup rootView = (ViewGroup) view.findViewById(R.id.otherInfo);

		AddressDetailDataBean addressBean = initAddressBean();
		setBaseInfoView(rootView, addressBean);
		setPhoneInfo(rootView, addressBean.getPhoneBean());
		setEmailInfo(rootView, addressBean.getEmailBean());
		setImInfo(rootView, addressBean.getImBean());
		Log.d("AddressDetailActivity", "onCreate: end");
		
		return rootView;
	}

	private AddressDetailDataBean initAddressBean() {
		Log.d("AddressDetailActivity", "initAddressBean: start");
		Uri lookupUri = getActivity().getIntent().getData();
		AddressDetailDataHelper helper = new AddressDetailDataHelper(getActivity(), lookupUri);
		AddressDetailDataBean addressBean = helper.getDataBean();
		
		Log.d("AddressDetailActivity", "initAddressBean: end");
		return addressBean;
	}
	
	private void setBaseInfoView(View view, AddressDetailDataBean addressBean) {
		Log.d("AddressDetailActivity", "setBaseInfoView: start");
		QuickContactBadge badge = (QuickContactBadge) view.findViewById(R.id.badge);
		TextView displayName = (TextView) view.findViewById(R.id.basicInfoDisplayName);
		TextView basicInfoKana = (TextView) view.findViewById(R.id.basicInfoKana);
		
		displayName.setText(addressBean.getDisplayName());
		basicInfoKana.setText(addressBean.getPhoneticName());
		
		badge.assignContactUri(addressBean.getLookupUri());
		Uri photoUri = ContentUris.withAppendedId(Contacts.CONTENT_URI, addressBean.getContactId());
		InputStream photoIs = Contacts.openContactPhotoInputStream(getActivity().getContentResolver(), photoUri);
		
		if(photoIs == null) {
			// TODO:
			badge.setImageResource(R.drawable.ic_contact_picture);
		} else {
			badge.setImageBitmap(BitmapFactory.decodeStream(photoIs));
		}
		Log.d("AddressDetailActivity", "setBaseInfoView: end");
	}
	
	private void setPhoneInfo(ViewGroup parentView, List<AddressPhoneDataBean> phoneBeanList) {
		Log.d("AddressDetailActivity", "setPhoneInfo: start");
		if(phoneBeanList == null || phoneBeanList.size() == 0) {
			Log.d("AddressDetailActivity", "setPhoneInfo: nothing end");
			return;
		}
		
		LayoutInflater inflater = (LayoutInflater) getActivity().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		View view = inflater.inflate(R.layout.addressdetaillist, null);
		parentView.addView(view);

		TextView title = (TextView) view.findViewById(R.id.detailListTitle);
		ListView list = (ListView) view.findViewById(R.id.detailList);
		title.setText("dbԍ");
		
		AddressDetailInfoAdapter<AddressPhoneDataBean> adapter =
				new AddressDetailInfoAdapter<AddressPhoneDataBean>(getActivity(), phoneBeanList) {
					@Override
					public View getView(int arg0, View arg1, ViewGroup arg2) {
						Log.d("AddressDetailInfoAdapter", "getView(phone): start");
						LayoutInflater inflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
						ViewGroup row = (ViewGroup) inflater.inflate(R.layout.addressdetaillistrow, null);
						
						TextView label = new TextView(getContext()); 
						row.addView(label);
						label.setText(((AddressPhoneDataBean) getItem(arg0)).getLabel());
						
						TextView number = new TextView(getContext());
						row.addView(number);
						number.setText(((AddressPhoneDataBean) getItem(arg0)).getNumber());
						
						Log.d("getView", "label: " + ((AddressPhoneDataBean) getItem(arg0)).getLabel());
						Log.d("getView", "number: " + ((AddressPhoneDataBean) getItem(arg0)).getNumber());
						Log.d("getView", "type: " + String.valueOf(((AddressPhoneDataBean) getItem(arg0)).getType()));
						Log.d("AddressDetailInfoAdapter", "getView: end");
						return row;
					}
				};
		
		list.setAdapter(adapter);
		Log.d("AddressDetailActivity", "setPhoneInfo: end");
	}
	
	private void setEmailInfo(ViewGroup parentView, List<AddressEmailDataBean> emailBeanList) {
		Log.d("AddressDetailActivity", "setEmailInfo: start");
		if(emailBeanList == null || emailBeanList.size() == 0) {
			Log.d("AddressDetailActivity", "setEmailInfo: nothing end");
			return;
		}
		
		LayoutInflater inflater = (LayoutInflater) getActivity().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		View view = inflater.inflate(R.layout.addressdetaillist, null);
		parentView.addView(view);
		
		TextView title = (TextView) view.findViewById(R.id.detailListTitle);
		ListView list = (ListView) view.findViewById(R.id.detailList);
		
		title.setText("[AhX");
		
		AddressDetailInfoAdapter<AddressEmailDataBean> adapter =
				new AddressDetailInfoAdapter<AddressEmailDataBean>(getActivity(), emailBeanList) {
					@Override
					public View getView(int arg0, View arg1, ViewGroup arg2) {
						Log.d("AddressDetailInfoAdapter", "getView(email): start");
						LayoutInflater inflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
						ViewGroup row = (ViewGroup) inflater.inflate(R.layout.addressdetaillistrow, null);
						
						TextView label = new TextView(getContext()); 
						row.addView(label);
						label.setText(((AddressEmailDataBean) getItem(arg0)).getLabel());
						
						TextView address = new TextView(getContext());
						row.addView(address);
						address.setText(((AddressEmailDataBean) getItem(arg0)).getAddress());
						
						Log.d("getView", "label: " + ((AddressEmailDataBean) getItem(arg0)).getLabel());
						Log.d("getView", "address: " + ((AddressEmailDataBean) getItem(arg0)).getAddress());
						Log.d("getView", "type: " + String.valueOf(((AddressEmailDataBean) getItem(arg0)).getType()));
						Log.d("AddressDetailInfoAdapter", "getView: end");
						return row;
					}
				};
		
		list.setAdapter(adapter);
		Log.d("AddressDetailActivity", "setEmailInfo: end");
	}
	
	private void setImInfo(ViewGroup parentView, List<AddressImDataBean> imBeanList) {
		Log.d("AddressDetailActivity", "setEmailInfo: start");
		if(imBeanList == null || imBeanList.size() == 0) {
			return;
		}
		
		LayoutInflater inflater = (LayoutInflater) getActivity().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		View view = inflater.inflate(R.layout.addressdetaillist, null);
		parentView.addView(view);
		
		TextView title = (TextView) view.findViewById(R.id.detailListTitle);
		ListView list = (ListView) view.findViewById(R.id.detailList);
		
		title.setText("IM");
		
		AddressDetailInfoAdapter<AddressImDataBean> adapter =
				new AddressDetailInfoAdapter<AddressImDataBean>(getActivity(), imBeanList) {
					@Override
					public View getView(int arg0, View arg1, ViewGroup arg2) {
						Log.d("AddressDetailInfoAdapter", "getView(email): start");
						LayoutInflater inflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
						ViewGroup row = (ViewGroup) inflater.inflate(R.layout.addressdetaillistrow, null);
						
						TextView label = new TextView(getContext()); 
						row.addView(label);
						label.setText(((AddressImDataBean) getItem(arg0)).getLabel());
						
						TextView address = new TextView(getContext());
						row.addView(address);
						address.setText(((AddressImDataBean) getItem(arg0)).getData());
						
						Log.d("getView", "label: " + ((AddressEmailDataBean) getItem(arg0)).getLabel());
						Log.d("getView", "address: " + ((AddressEmailDataBean) getItem(arg0)).getAddress());
						Log.d("getView", "type: " + String.valueOf(((AddressEmailDataBean) getItem(arg0)).getType()));
						Log.d("AddressDetailInfoAdapter", "getView: end");
						return row;
					}
				};
		
		list.setAdapter(adapter);
		
		Log.d("AddressDetailActivity", "setEmailInfo: end");
	}
}
