package jp.sourceforge.android_ab.addressbook.common.actionbar;

import java.util.HashSet;
import java.util.Set;

import jp.sourceforge.android_ab.addressbook.R;
import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout.LayoutParams;
import android.widget.TextView;

public class ActionBarHelper {
	private Activity activity;
	
    protected Set<Integer> actionItemIds = new HashSet<Integer>();
    
    public static ActionBarHelper getInstance(Activity activity) {
    	return new ActionBarHelper(activity);
    }
    
	public ActionBarHelper(Activity activity) {
		this.activity = activity;
	}
	
	public void setupActionBar() {
		final ViewGroup actionBar = getActionBar();
		
		LayoutParams params = new LayoutParams(0, ViewGroup.LayoutParams.MATCH_PARENT);
		params.weight = 1;
		
		// j[{^\
//		SimpleMenu tmpMenu = new SimpleMenu(activity);
//		SimpleMenuItem mainMenuItem = new SimpleMenuItem(tmpMenu, android.R.id.home, 0, "");
//		mainMenuItem.setIcon(android.R.drawable.ic_menu_more);
//		addActionItemCompatFromMenuItem(mainMenuItem);
		
		// ^Cg\
		TextView titleView = new TextView(activity, null, R.attr.actionbarTitleStyle);
		titleView.setLayoutParams(params);
		titleView.setText(activity.getTitle());
		
		actionBar.addView(titleView);
		
	}
	
    public void onCreate(Bundle savedInstanceState) {
    	activity.requestWindowFeature(Window.FEATURE_CUSTOM_TITLE);
    	
    }
    
    public void onPostCreate(Bundle savedInstanceState) {
        Log.d("onPostCreate", "start");
//    	activity.getWindow().setFeatureInt(Window.FEATURE_CUSTOM_TITLE, R.layout.actionbar);
//    	setupActionBar();
    	SimpleMenu menu = new SimpleMenu(activity);
    	activity.onCreatePanelMenu(Window.FEATURE_OPTIONS_PANEL, menu);
//    	activity.onPrepareOptionsMenu(menu);
    	
        for (int i = 0; i < menu.size(); i++) {
            MenuItem item = menu.getItem(i);
//            if (actionItemIds.contains(item.getItemId())) {
                Log.d("com.blogspot.started.a.newleaf.contactlist", "loadActionBarMetadata: OKOK");
                addActionItemCompatFromMenuItem(item);
//            }
        }
        Log.d("onPostCreate", "end");
    }
    
//    public MenuInflater getMenuInflater(MenuInflater superMenuInflater) {
//    	return new WrappedMenuInflater(activity, superMenuInflater);
//    }
//    
    private ViewGroup getActionBar() {
        return (ViewGroup) activity.findViewById(R.id.actionbar);
    }
    
    /**
     * Adds an action button to the compatibility action bar, using menu information from a {@link
     * android.view.MenuItem}. If the menu item ID is <code>menu_refresh</code>, the menu item's
     * state can be changed to show a loading spinner using
     * {@link com.example.android.actionbarcompat.ActionBarHelperBase#setRefreshActionItemState(boolean)}.
     */
    private View addActionItemCompatFromMenuItem(final MenuItem item) {
        final ViewGroup actionBar = getActionBar();
        if (actionBar == null) {
            Log.d("com.blogspot.started.a.newleaf.contactlist", "loadActionBarMetadata: addActionItemCompatFromMenuItem: false");
            return null;
        }

        Log.d("com.blogspot.started.a.newleaf.contactlist", "loadActionBarMetadata: addActionItemCompatFromMenuItem");
        // Create the button
        ImageButton actionButton = new ImageButton(activity, null, R.attr.actionbarItemStyle);
        actionButton.setLayoutParams(new ViewGroup.LayoutParams(
                (int) activity.getResources().getDimension(R.dimen.actionbar_button_width),
                ViewGroup.LayoutParams.MATCH_PARENT));

        actionButton.setImageDrawable(item.getIcon());
        actionButton.setScaleType(ImageView.ScaleType.CENTER);
        actionButton.setContentDescription(item.getTitle());
        actionButton.setBackgroundColor(0);
        actionButton.setOnClickListener(new View.OnClickListener() {
            public void onClick(View view) {
            	activity.onMenuItemSelected(Window.FEATURE_OPTIONS_PANEL, item);
            }
        });

        Log.d("com.blogspot.started.a.newleaf.contactlist", "loadActionBarMetadata: addActionItemCompatFromMenuItem");
        actionBar.addView(actionButton);

        return actionButton;
    }
}
