/*
 * Copyright (c) 2012, ToshiakiAsazuma All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * ERedistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  
 * ERedistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation
 *  and/or other materials provided with the distribution.
 *  
 * ENeither the name of the ToshiakiAsazuma nor the names of its contributors
 *  may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *  
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 *  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 *  OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 *  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 *  OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 *  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.sourceforge.android_ab.addressbook.history.adapter;

import java.io.InputStream;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;

import jp.sourceforge.android_ab.addressbook.R;
import jp.sourceforge.android_ab.addressbook.common.adapter.ListAdapter;
import jp.sourceforge.android_ab.addressbook.common.data.HistoryDataElement;
import android.content.ContentUris;
import android.content.Context;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.provider.CallLog.Calls;
import android.provider.ContactsContract.Contacts;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.QuickContactBadge;
import android.widget.TextView;

public class HistoryListDataAdapter extends ListAdapter<HistoryDataElement> {

	public HistoryListDataAdapter(Context context) {
		super(context);
	}

	public HistoryListDataAdapter(Context context,
			Collection<HistoryDataElement> dataList) {
		super(context, dataList);
	}

	public View getView(int position, View convertView, ViewGroup parent) {
		Log.d(getClass().getName(), "getView: start");
		
		LayoutInflater inflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		View row = (View) inflater.inflate(R.layout.historylistrow, null);
		
		HistoryDataElement bean = (HistoryDataElement) getItem(position);
		
		TextView displayName = (TextView) row.findViewById(R.id.displayName);
		displayName.setText(bean.getDisplayName());
		
		if(bean.getCount() != 1) {
			TextView displayCount = (TextView) row.findViewById(R.id.count);
			displayCount.setText("(" + String.valueOf(bean.getCount()) + ")");
		}
		
		if(!bean.getDisplayName().equals(bean.getHistory().get(0).getNumber())) {
			TextView displayNumberLabel = (TextView) row.findViewById(R.id.numberLabel);
			displayNumberLabel.setText(bean.getHistory().get(0).getCachedNumberLabel());

			TextView displayNumber = (TextView) row.findViewById(R.id.number);
			displayNumber.setText(bean.getHistory().get(0).getNumber());
		}
		
		TextView displayLastDate = (TextView) row.findViewById(R.id.lastContactDate);
		DateFormat dateFormat = android.text.format.DateFormat.getDateFormat(getContext());
		DateFormat timeFormat = android.text.format.DateFormat.getTimeFormat(getContext());
		
		displayLastDate.setText(
				dateFormat.format(new Date(bean.getLastContactDate()))
				+ " " + timeFormat.format(new Date(bean.getLastContactDate())));

		ImageView callType = (ImageView) row.findViewById(R.id.callsType);
		int callTypeResource = getCallTypeResource(bean.getHistory().get(0).getType());
		callType.setImageResource(callTypeResource);

		QuickContactBadge badge = (QuickContactBadge) row.findViewById(R.id.quickContactBadge1);
		Uri contactUri = Contacts.getLookupUri(bean.getId(), bean.getLookupKey());
		badge.assignContactUri(contactUri);
		Uri photoUri = ContentUris.withAppendedId(Contacts.CONTENT_URI, bean.getId());
		InputStream photoIs = Contacts.openContactPhotoInputStream(getContentResolver(), photoUri);
		
		if(photoIs == null) {
			// TODO:
			badge.setImageResource(R.drawable.ic_contact_picture);
		} else {
			badge.setImageBitmap(BitmapFactory.decodeStream(photoIs));
		}
		
		displayName.setText(bean.getDisplayName());
		Log.d(getClass().getName(), "getView: end");
		return row;
	}
	
	private int getCallTypeResource(int callType) {
		int callTypeResource;
		switch (callType) {
		case Calls.INCOMING_TYPE:
			callTypeResource = android.R.drawable.sym_call_incoming;
			break;

		case Calls.OUTGOING_TYPE:
			callTypeResource = android.R.drawable.sym_call_outgoing;
			break;

		case Calls.MISSED_TYPE:
			callTypeResource = android.R.drawable.sym_call_missed;
			break;
			
		default:
			callTypeResource = android.R.drawable.sym_call_missed;
			Log.w(getClass().getName(), "Illegal Call Type");
		}
		
		return callTypeResource;
	}
}
