/*
 * Copyright (c) 2012, ToshiakiAsazuma All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * ERedistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  
 * ERedistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation
 *  and/or other materials provided with the distribution.
 *  
 * ENeither the name of the ToshiakiAsazuma nor the names of its contributors
 *  may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *  
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 *  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 *  OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 *  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 *  OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 *  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.sourceforge.android_ab.addressbook.groupaddresslist.view;

import java.util.List;

import jp.sourceforge.android_ab.addressbook.R;
import jp.sourceforge.android_ab.addressbook.common.actionbar.ActionBarHelper;
import jp.sourceforge.android_ab.addressbook.common.data.GroupDataElement;
import jp.sourceforge.android_ab.addressbook.common.helper.GroupSearchDataHelper;
import jp.sourceforge.android_ab.addressbook.groupaddresslist.adapter.GroupListFragmentAdapter;
import jp.sourceforge.android_ab.addressbook.history.view.ContactHistoryActivity;
import android.accounts.Account;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.view.ViewPager;
import android.support.v4.view.ViewPager.OnPageChangeListener;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.Spinner;
import android.widget.Toast;

/**
 * <b>O[vʕ\Activity</b><br>
 * 
 * 
 * @author toshiaki
 *
 */
public class GroupAddressListActivity extends FragmentActivity implements
		OnPageChangeListener, OnItemSelectedListener {
	private ActionBarHelper actionBar = new ActionBarHelper(this);

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		setContentView(R.layout.groupaddresslist);
		GroupSearchDataHelper helper = new GroupSearchDataHelper(this);
		List<GroupDataElement> groupList = helper.getGroup(new Account[0]);
		GroupListFragmentAdapter adapter = new GroupListFragmentAdapter(getSupportFragmentManager(), groupList);
		ViewPager pager = (ViewPager) findViewById(R.id.groupListPager);
		pager.setAdapter(adapter);
		pager.setOnPageChangeListener(this);
		
		
		
//		ListPageDataBean<AddressDataBean> pageBean = getPageBean();
//		FragmentStatePagerAdapter pageAdapter =
//				new GroupAddressListPageAdapter(getSupportFragmentManager(), pageBean);
//		ViewPager pager = (ViewPager) findViewById(R.id.groupListPager);
//		pager.setAdapter(pageAdapter);
//		pager.setOnPageChangeListener(this);

		Spinner groupSelecter = (Spinner) findViewById(R.id.groupSelect);
		ArrayAdapter<String> groupSelectAdapter = new ArrayAdapter<String>(
				this, android.R.layout.simple_spinner_item);

		for (GroupDataElement group : groupList) {
			groupSelectAdapter.add(group.getTitle());
		}

		groupSelecter.setAdapter(groupSelectAdapter);
		groupSelecter.setOnItemSelectedListener(this);
		
	}

	public void onPostCreate(Bundle savedInstanceState) {
		super.onPostCreate(savedInstanceState);
		actionBar.setupActionBar();
		actionBar.onPostCreate(savedInstanceState);
		
//		AccountDataHelper accountHelper = new AccountDataHelper(this);
//		Account[] accounts = accountHelper.getAccount();
//		Log.d("GroupAddressListActivity", "AccountCount: " + accounts.length);
//
//		for(Account account: accounts) {
//			Log.d("GroupAddressListActivity", "AccountName: " + account.name);
//			Log.d("GroupAddressListActivity", "AccountType: " + account.type);
//		}
//		
//		GroupSearchDataHelper helper = new GroupSearchDataHelper(this);
//		List<GroupDataElement> groupList = helper.getGroup(new Account[0]);
//		Log.d("GroupAddressListActivity", "group count: " + groupList.size());
//		for(GroupDataElement group: groupList) {
//			Log.d("GroupAddressListActivity", "Group:count: " + group.getCount());
//			Log.d("GroupAddressListActivity", "Group:id: " + group.getId());
//			Log.d("GroupAddressListActivity", "Group:accountName " + group.getAccountName());
//			Log.d("GroupAddressListActivity", "Group:accountType " + group.getAccountType());
//			Log.d("GroupAddressListActivity", "Group:title " + group.getTitle());
//			Log.d("GroupAddressListActivity", "Group:notes " + group.getNotes());
//			Log.d("GroupAddressListActivity", "Group:systemId " + group.getSystemId());
//			Log.d("GroupAddressListActivity", "Group:deleted " + group.getDeleted());
//			Log.d("GroupAddressListActivity", "Group:groupVisivle " + group.isGroupVisivle());
//			Log.d("GroupAddressListActivity", "Group:souldSync " + group.isShouldSync());
//			
//			List<ContactDataElement> contacts = helper.getContactList(group);
////			for(ContactDataElement contact: contacts) {
////				Log.d("GroupAddressListActivity", "Contact: id" + contact.getId());
////				Log.d("GroupAddressListActivity", "Contact: lookupKey" + contact.getLookupKey());
////				Log.d("GroupAddressListActivity", "Contact: displayName" + contact.getDisplayName());
////				Log.d("GroupAddressListActivity", "Contact: accountName" + contact.getAccountName());
////				Log.d("GroupAddressListActivity", "Contact: accountType" + contact.getAccountType());
////			}
//		}
		
		
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		MenuInflater inflater = getMenuInflater();
		inflater.inflate(R.menu.groupview, menu);
		for (int i = 0; i < menu.size(); i++) {
			menu.getItem(i).setVisible(false);
		}
		super.onCreateOptionsMenu(menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		switch (item.getItemId()) {
		case R.id.menu_move_dial:
			Toast.makeText(this, "tapped move dial", Toast.LENGTH_SHORT).show();
			break;
		case R.id.menu_move_history:
			Toast.makeText(this, "tapped move history", Toast.LENGTH_SHORT)
					.show();
			Intent intent = new Intent(this, ContactHistoryActivity.class);
			startActivity(intent);
			
			break;
		}
		return true;
	}

	public void onPageScrollStateChanged(int arg0) {
		// TODO ꂽ\bhEX^u

	}

	public void onPageScrolled(int arg0, float arg1, int arg2) {
		// TODO ꂽ\bhEX^u

	}

	public void onPageSelected(int arg0) {
		Spinner groupSelecter = (Spinner) findViewById(R.id.groupSelect);
		groupSelecter.setSelection(arg0);
	}

	public void onItemSelected(AdapterView<?> parent,
			View view, int position, long id) {
		ViewPager pager = (ViewPager) findViewById(R.id.groupListPager);
		pager.setCurrentItem(position);

	}

	public void onNothingSelected(AdapterView<?> arg0) {
		// TODO ꂽ\bhEX^u

	}
}
