package jp.sourceforge.android_ab.addressbook.common.data.impl;

import java.util.ArrayList;
import java.util.List;

import android.database.Cursor;
import android.provider.ContactsContract.CommonDataKinds.Email;
import android.provider.ContactsContract.CommonDataKinds.Event;
import android.provider.ContactsContract.CommonDataKinds.GroupMembership;
import android.provider.ContactsContract.CommonDataKinds.Im;
import android.provider.ContactsContract.CommonDataKinds.Nickname;
import android.provider.ContactsContract.CommonDataKinds.Note;
import android.provider.ContactsContract.CommonDataKinds.Organization;
import android.provider.ContactsContract.CommonDataKinds.Phone;
import android.provider.ContactsContract.CommonDataKinds.Photo;
import android.provider.ContactsContract.CommonDataKinds.Relation;
import android.provider.ContactsContract.CommonDataKinds.SipAddress;
import android.provider.ContactsContract.CommonDataKinds.StructuredName;
import android.provider.ContactsContract.CommonDataKinds.StructuredPostal;
import android.provider.ContactsContract.CommonDataKinds.Website;

import jp.sourceforge.android_ab.addressbook.common.data.ContactDetailDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.ContactDetailBaseElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.EmailDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.EventDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.GroupMembershipDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.ImDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.NicknameDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.NoteDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.OrganizationDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.PhoneDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.PhotoDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.RelationDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.SipAddressDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.StructuredNameDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.StructuredPostalDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.WebsiteDataElement;

public class ContactDetailDataElementImpl extends ContactDataElementImpl implements ContactDetailDataElement {
	public static final String[] TARGET_MIMETYPE = new String[] {
		StructuredName.MIMETYPE,
		Phone.MIMETYPE,
		Email.MIMETYPE,
		Photo.MIMETYPE,
		Organization.MIMETYPE,
		Im.MIMETYPE,
		Nickname.MIMETYPE,
		Note.MIMETYPE,
		StructuredPostal.MIMETYPE,
		GroupMembership.MIMETYPE,
		Website.MIMETYPE,
		Event.MIMETYPE,
		Relation.MIMETYPE,
		SipAddress.MIMETYPE,
	};
	
	
	private List<StructuredNameDataElement> structuredNameList = new ArrayList<StructuredNameDataElement>();
	private List<PhoneDataElement> phoneList = new ArrayList<PhoneDataElement>();
	private List<EmailDataElement> emailList = new ArrayList<EmailDataElement>();
	private List<PhotoDataElement> photoList = new ArrayList<PhotoDataElement>();
	private List<OrganizationDataElement> organizationList = new ArrayList<OrganizationDataElement>();
	private List<ImDataElement> imList = new ArrayList<ImDataElement>();
	private List<NicknameDataElement> nicknameList = new ArrayList<NicknameDataElement>();
	private List<NoteDataElement> noteList = new ArrayList<NoteDataElement>();
	private List<StructuredPostalDataElement> structuredPostalList = new ArrayList<StructuredPostalDataElement>();
	private List<GroupMembershipDataElement> groupMembershipList = new ArrayList<GroupMembershipDataElement>();
	private List<WebsiteDataElement> websiteList = new ArrayList<WebsiteDataElement>();
	private List<EventDataElement> eventList = new ArrayList<EventDataElement>();
	private List<RelationDataElement> relationList = new ArrayList<RelationDataElement>();
	private List<SipAddressDataElement> sipAddressList = new ArrayList<SipAddressDataElement>();
	
	public List<StructuredNameDataElement> getStructuredName() {
		return structuredNameList;
	}
	
	public void addStructuredName(StructuredNameDataElement element) {
		structuredNameList.add(element);
	}
	
	public void removeStructuredName(StructuredNameDataElement element) {
		structuredNameList.remove(element);
	}
	
	public List<PhoneDataElement> getPhone() {
		return phoneList;
	}

	public void addPhone(PhoneDataElement element) {
		phoneList.add(element);
	}
	
	public void removePhone(PhoneDataElement element) {
		phoneList.remove(element);
	}

	public List<EmailDataElement> getEmail() {
		return emailList;
	}
	
	public void addEmail(EmailDataElement element) {
		emailList.add(element);
	}
	
	public void removeEmail(EmailDataElement element) {
		emailList.remove(element);
	}
	
	public List<PhotoDataElement> getPhoto() {
		return photoList;
	}
	
	public void addPhoto(PhotoDataElement element) {
		photoList.add(element);
	}
	
	public void removePhoto(PhotoDataElement element) {
		photoList.remove(element);
	}
	
	public List<OrganizationDataElement> getOrganization() {
		return organizationList;
	}

	public void addOrganization(OrganizationDataElement element) {
		organizationList.add(element);
	}

	public void removeOrganization(OrganizationDataElement element) {
		organizationList.remove(element);
	}
	
	public List<ImDataElement> getIm() {
		return imList;
	}

	public void addIm(ImDataElement element) {
		imList.add(element);
	}

	public void removeIm(ImDataElement element) {
		imList.remove(element);
	}

	public List<NicknameDataElement> getNickname() {
		return nicknameList;
	}
	
	public void addNickname(NicknameDataElement element) {
		nicknameList.add(element);
	}
	
	public void removeNickname(NicknameDataElement element) {
		nicknameList.remove(element);
	}

	public List<NoteDataElement> getNote() {
		return noteList;
	}

	public void addNote(NoteDataElement element) {
		noteList.add(element);
	}
	
	public void removeNote(NoteDataElement element) {
		noteList.remove(element);
	}

	public List<StructuredPostalDataElement> getStructuredPostal() {
		return structuredPostalList;
	}
	
	public void addStructuredPostal(
			StructuredPostalDataElement element) {
		structuredPostalList.add(element);
	}
	
	public void removeStructuredPostal(
			StructuredPostalDataElement element) {
		structuredPostalList.remove(element);
	}

	
	public List<GroupMembershipDataElement> getGroupMembership() {
		return groupMembershipList;
	}
	
	public void addGroupMembership(GroupMembershipDataElement element) {
		groupMembershipList.add(element);
	}
	
	public void removeGroupMembership(GroupMembershipDataElement element) {
		groupMembershipList.remove(element);
	}
	
	public List<WebsiteDataElement> getWebsite() {
		return websiteList;
	}
	
	public void addWebsite(WebsiteDataElement element) {
		websiteList.add(element);
	}
	
	public void removeWebsite(WebsiteDataElement element) {
		websiteList.remove(element);
	}
	
	public List<EventDataElement> getEvent() {
		return eventList;
	}
	
	public void addEvent(EventDataElement element) {
		eventList.add(element);
	}
	
	public void removeEvent(EventDataElement element) {
		eventList.remove(element);
	}
	
	public List<RelationDataElement> getRelation() {
		return relationList;
	}
	
	public void addRelation(RelationDataElement element) {
		relationList.add(element);
	}
	
	public void removeRelation(RelationDataElement element) {
		relationList.remove(element);
	}
	
	public List<SipAddressDataElement> getSipAddress() {
		return sipAddressList;
	}
	
	public void addSipAddress(SipAddressDataElement element) {
		sipAddressList.add(element);
	}

	public void removeSipAddress(SipAddressDataElement element) {
		sipAddressList.remove(element);
	}
}
