package jp.sourceforge.android_ab.addressbook.common.helper;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.android_ab.addressbook.common.data.ContactDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.GroupDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.impl.ContactDataElementImpl;
import jp.sourceforge.android_ab.addressbook.common.data.impl.GroupDataElementImpl;
import android.accounts.Account;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract.Contacts;
import android.provider.ContactsContract.Groups;
import android.util.Log;

public class GroupSearchDataHelper extends ContactDataHelper {

	public GroupSearchDataHelper(Context context) {
		super(context);
	}
	
	/**
	 * O[vꗗ̎擾
	 * @return
	 */
	public List<GroupDataElement> getGroup(Account[] accounts) {
		ArrayList<GroupDataElement> resultList = new ArrayList<GroupDataElement>();
		String[] projection = new String[] {
				Groups._ID,
				Groups.ACCOUNT_NAME,
				Groups.ACCOUNT_TYPE,
				Groups.TITLE,
				Groups.NOTES,
				Groups.SYSTEM_ID,
				Groups.DELETED,
				Groups.GROUP_VISIBLE,
				Groups.SHOULD_SYNC
		};
		
		StringBuffer selectionBuffer = new StringBuffer();
		ArrayList<String> selectionArgs = new ArrayList<String>();

		selectionBuffer.append(Groups.DELETED + " = ? ");
		selectionArgs.add("0");
		
//		String selection = Groups.DELETED + " = ?";
//		String[] selectionArgs = new String[] { "0"};
//		String selection = null;
//		String[] selectionArgs = null;
		
		for(Account account: accounts) {
			if (selectionBuffer.length() != 0) {
				selectionBuffer.append(" OR ");
			}
			
			selectionBuffer.append(Groups.ACCOUNT_NAME + " = ? ");
			selectionBuffer.append(Groups.ACCOUNT_TYPE + " = ? ");
			
			selectionArgs.add(account.name);
			selectionArgs.add(account.type);
		}
		
		ContentResolver cr = getContext().getContentResolver();
		Cursor cursor = cr.query(Groups.CONTENT_URI, projection, selectionBuffer.toString(), selectionArgs.toArray(new String[0]), null);
		
		while(cursor.moveToNext()) {
			GroupDataElementImpl data = new GroupDataElementImpl();
			data.setId(cursor.getLong(cursor.getColumnIndex(Groups._ID)));
			data.setAccountName(cursor.getString(cursor.getColumnIndex(Groups.ACCOUNT_NAME)));
			data.setAccountType(cursor.getString(cursor.getColumnIndex(Groups.ACCOUNT_TYPE)));
			data.setTitle(cursor.getString(cursor.getColumnIndex(Groups.TITLE)));
			data.setNotes(cursor.getString(cursor.getColumnIndex(Groups.NOTES)));
			data.setSystemId(cursor.getString(cursor.getColumnIndex(Groups.SYSTEM_ID)));
			data.setDeleted(cursor.getInt(cursor.getColumnIndex(Groups.DELETED)));
			
			boolean groupVisivle = (0 == cursor.getInt(cursor.getColumnIndex(Groups.GROUP_VISIBLE)));
			data.setGroupVisivle(groupVisivle);
			boolean shouldSync = (0== cursor.getInt(cursor.getColumnIndex(Groups.SHOULD_SYNC)));
			data.setShouldSync(shouldSync);
			
			resultList.add(data);
		}
		
		return resultList;
	}
	
	/**
	 * O[vf[^̎擾
	 * w肳ꂽO[vɏf[^擾܂B
	 * 
	 * @param target ΏۃO[v
	 * @return ΏۃO[vɏR^Ng
	 */
	public List<ContactDataElement> getContactList(GroupDataElement target) {
		Log.d(getClass().getName(), "getContactList: START");
		Uri uri = Uri.withAppendedPath(Contacts.CONTENT_GROUP_URI, target.getTitle());
		
		String[] projection = new String[] {
				Contacts._ID,
				Contacts.LOOKUP_KEY,
				Contacts.DISPLAY_NAME,
				Contacts.PHOTO_ID,
				Contacts.IN_VISIBLE_GROUP,
				Contacts.HAS_PHONE_NUMBER,
				Contacts.TIMES_CONTACTED,
				Contacts.LAST_TIME_CONTACTED,
				Contacts.STARRED,
				Contacts.CUSTOM_RINGTONE,
				Contacts.SEND_TO_VOICEMAIL,
				Contacts.CONTACT_PRESENCE,
				Contacts.CONTACT_STATUS,
				Contacts.CONTACT_STATUS_TIMESTAMP,
				Contacts.CONTACT_STATUS_RES_PACKAGE,
				Contacts.CONTACT_STATUS_LABEL,
				Contacts.CONTACT_STATUS_ICON,
//				
//				RawContacts.ACCOUNT_NAME,
//				RawContacts.ACCOUNT_TYPE,
//				
		};
//		
		String selection = null;
		String[] selectionArgs = null;
		
		ContentResolver cr = getContext().getContentResolver();
		Cursor cursor = cr.query(uri, projection, selection, selectionArgs, null);
		
		ArrayList<ContactDataElement> resultList = new ArrayList<ContactDataElement>();
		
		while(cursor.moveToNext()) {
			ContactDataElementImpl data = new ContactDataElementImpl();
			data.setId(cursor.getLong(cursor.getColumnIndex(Contacts._ID)));
			data.setLookupKey(cursor.getString(cursor.getColumnIndex(Contacts.LOOKUP_KEY)));
			data.setDisplayName(cursor.getString(cursor.getColumnIndex(Contacts.DISPLAY_NAME)));
			data.setPhotoId(cursor.getLong(cursor.getColumnIndex(Contacts.PHOTO_ID)));
			data.setInVisibleGroup(cursor.getInt(cursor.getColumnIndex(Contacts.IN_VISIBLE_GROUP)));
			data.setHasPhoneNumber(cursor.getInt(cursor.getColumnIndex(Contacts.HAS_PHONE_NUMBER)));
			data.setTimesContacted(cursor.getInt(cursor.getColumnIndex(Contacts.TIMES_CONTACTED)));
			data.setLastTimeContacted(cursor.getLong(cursor.getColumnIndex(Contacts.LAST_TIME_CONTACTED)));
			data.setStarred(cursor.getInt(cursor.getColumnIndex(Contacts.STARRED)));
			data.setCustomRingtone(cursor.getString(cursor.getColumnIndex(Contacts.CUSTOM_RINGTONE)));
			data.setSendToVoicemail(cursor.getInt(cursor.getColumnIndex(Contacts.SEND_TO_VOICEMAIL)));
			data.setContactPresence(cursor.getInt(cursor.getColumnIndex(Contacts.CONTACT_PRESENCE)));
			data.setContactStatus(cursor.getString(cursor.getColumnIndex(Contacts.CONTACT_STATUS)));
			data.setContactStatusTimestamp(cursor.getLong(cursor.getColumnIndex(Contacts.CONTACT_STATUS_TIMESTAMP)));
			data.setContactStatusResPackage(cursor.getString(cursor.getColumnIndex(Contacts.CONTACT_STATUS_RES_PACKAGE)));			
			data.setContactStatusLabel(cursor.getLong(cursor.getColumnIndex(Contacts.CONTACT_STATUS_LABEL)));
			data.setContactStatusIcon(cursor.getLong(cursor.getColumnIndex(Contacts.CONTACT_STATUS_ICON)));
//
//			data.setAccountName(cursor.getString(cursor.getColumnIndex(RawContacts.ACCOUNT_NAME)));
//			data.setAccountType(cursor.getString(cursor.getColumnIndex(RawContacts.ACCOUNT_TYPE)));
			
			Log.d("RawContactsEntity", "---- Start ----------------------------------------------------------------");
			for(int i = 0; i < cursor.getColumnCount(); i++) {
				try {
					Log.d("RawContactsEntity", "columnName: " + cursor.getColumnName(i) + "   columnValue: " + cursor.getString(i));
				} catch (Exception e) {
					Log.d("RawContactsEntity", "columnName: " + cursor.getColumnName(i) + "   columnValue: error");
				}
			}
			Log.d("RawContactsEntity", "---- End   ----------------------------------------------------------------");
			
			resultList.add(data);
		}
		
		Log.d(getClass().getName(), "getContactList: END");
		return resultList;
	}
	
}
