/*
 * Copyright (C) 2008 The Android Open Source Project
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <private/bionic_asm.h>
#include <linux/sched.h>

// TODO: mips' uapi signal.h is missing #ifndef __ASSEMBLY__.
// #include <asm/signal.h>
#define SIGCHLD 18

ENTRY(vfork)
__BIONIC_WEAK_ASM_FOR_NATIVE_BRIDGE(vfork)
	.set	noreorder
	.cpload	$t9

	// __get_tls()[TLS_SLOT_THREAD_ID]->cached_pid_ = 0
	.set	push
	.set	mips32r2
	rdhwr	$v0, $29			// v0 = tls; kernel trap on mips32r1
	.set	pop
	lw	$v0, REGSZ*1($v0)		// v0 = v0[TLS_SLOT_THREAD_ID ie 1]
	sw	$0, REGSZ*2+4($v0)	// v0->cached_pid_ = 0

	li	$a0, (CLONE_VM | CLONE_VFORK | SIGCHLD)
	li	$a1, 0
	li	$a2, 0
	li	$a3, 0
	subu	$sp, 8
	sw	$0, 16($sp)
	li	$v0, __NR_clone
	syscall
	addu	$sp, 8
	bnez	$a3, 1f
	 move	$a0, $v0

	j	$ra
	 nop
1:
	la	$t9, __set_errno_internal
	j	$t9
	 nop
END(vfork)
