/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

static data_1_2_t<double, double, double> g_fdim_intel_data[] = {
  { // Entry 0
    0x1.334d6a161e4f48p-2,
    -0x1.999999999999fp-3,
    -0x1.000d1b71758e2p-1
  },
  { // Entry 1
    0x1.99b3d07c84b5c8p-2,
    -0x1.999999999999fp-3,
    -0x1.33404ea4a8c16p-1
  },
  { // Entry 2
    0x1.99999999999988p-12,
    -0x1.999999999999fp-13,
    -0x1.3333333333334p-11
  },
  { // Entry 3
    0x1.f07c1f07c1f0f8p-12,
    -0x1.dbcc48676f2f9p-13,
    -0x1.6f31219dbcc46p-11
  },
  { // Entry 4
    0x1.111e2c82869f18p-1,
    -0x1.ddddddddddde1p-2,
    -0x1.00068db8bac71p0
  },
  { // Entry 5
    0x1.111e2c82869ea8p-1,
    -0x1.dddddddddddefp-2,
    -0x1.00068db8bac71p0
  },
  { // Entry 6
    0x1.p1,
    0x1.0p-1074,
    -0x1.0p1
  },
  { // Entry 7
    0x1.af286bca1af30800000000000080p-4,
    0x1.0000000000001p-57,
    -0x1.af286bca1af30p-4
  },
  { // Entry 8
    0x1.0000000000000fffffffffffffffffffp350,
    0x1.0000000000001p350,
    0x1.af286bca1af20p-4
  },
  { // Entry 9
    0x1.af286bca1af30800800000000080p-4,
    0x1.0010000000001p-57,
    -0x1.af286bca1af30p-4
  },
  { // Entry 10
    0x1.0c30c30c30c308p-10,
    0x1.8618618618610p-15,
    -0x1.0p-10
  },
  { // Entry 11
    0x1.a4924924924938p-2,
    0x1.ffffffffffffep-4,
    -0x1.2492492492494p-2
  },
  { // Entry 12
    0x1.7ffffffffffff8p-51,
    0x1.ffffffffffffep-53,
    -0x1.0p-51
  },
  { // Entry 13
    0x1.fffffffffffff0p1023,
    0x1.fffffffffffffp1023,
    -0x1.9p-1068
  },
  { // Entry 14
    0x1.ffffffffffffefffffffffffffffffffp1023,
    0x1.fffffffffffffp1023,
    0x1.0p-1074
  },
  { // Entry 15
    0.0,
    -0x1.4p3,
    -0x1.4p3
  },
  { // Entry 16
    0x1.p1,
    -0x1.0p3,
    -0x1.4p3
  },
  { // Entry 17
    0x1.p2,
    -0x1.8p2,
    -0x1.4p3
  },
  { // Entry 18
    0x1.80p2,
    -0x1.0p2,
    -0x1.4p3
  },
  { // Entry 19
    0x1.p3,
    -0x1.0p1,
    -0x1.4p3
  },
  { // Entry 20
    0x1.40p3,
    0.0,
    -0x1.4p3
  },
  { // Entry 21
    0x1.80p3,
    0x1.0p1,
    -0x1.4p3
  },
  { // Entry 22
    0x1.c0p3,
    0x1.0p2,
    -0x1.4p3
  },
  { // Entry 23
    0x1.p4,
    0x1.8p2,
    -0x1.4p3
  },
  { // Entry 24
    0x1.20p4,
    0x1.0p3,
    -0x1.4p3
  },
  { // Entry 25
    0x1.40p4,
    0x1.4p3,
    -0x1.4p3
  },
  { // Entry 26
    0.0,
    -0x1.8p-1073,
    -0x1.8p-1073
  },
  { // Entry 27
    0.0,
    -0x1.8p-1073,
    -0x1.0p-1073
  },
  { // Entry 28
    0.0,
    -0x1.8p-1073,
    -0x1.0p-1074
  },
  { // Entry 29
    0.0,
    -0x1.8p-1073,
    -0.0
  },
  { // Entry 30
    0.0,
    -0x1.8p-1073,
    0x1.0p-1074
  },
  { // Entry 31
    0.0,
    -0x1.8p-1073,
    0x1.0p-1073
  },
  { // Entry 32
    0.0,
    -0x1.8p-1073,
    0x1.8p-1073
  },
  { // Entry 33
    0x1.p-1074,
    -0x1.0p-1073,
    -0x1.8p-1073
  },
  { // Entry 34
    0.0,
    -0x1.0p-1073,
    -0x1.0p-1073
  },
  { // Entry 35
    0.0,
    -0x1.0p-1073,
    -0x1.0p-1074
  },
  { // Entry 36
    0.0,
    -0x1.0p-1073,
    -0.0
  },
  { // Entry 37
    0.0,
    -0x1.0p-1073,
    0x1.0p-1074
  },
  { // Entry 38
    0.0,
    -0x1.0p-1073,
    0x1.0p-1073
  },
  { // Entry 39
    0.0,
    -0x1.0p-1073,
    0x1.8p-1073
  },
  { // Entry 40
    0x1.p-1073,
    -0x1.0p-1074,
    -0x1.8p-1073
  },
  { // Entry 41
    0x1.p-1074,
    -0x1.0p-1074,
    -0x1.0p-1073
  },
  { // Entry 42
    0.0,
    -0x1.0p-1074,
    -0x1.0p-1074
  },
  { // Entry 43
    0.0,
    -0x1.0p-1074,
    -0.0
  },
  { // Entry 44
    0.0,
    -0x1.0p-1074,
    0x1.0p-1074
  },
  { // Entry 45
    0.0,
    -0x1.0p-1074,
    0x1.0p-1073
  },
  { // Entry 46
    0.0,
    -0x1.0p-1074,
    0x1.8p-1073
  },
  { // Entry 47
    0x1.80p-1073,
    -0.0,
    -0x1.8p-1073
  },
  { // Entry 48
    0x1.p-1073,
    -0.0,
    -0x1.0p-1073
  },
  { // Entry 49
    0x1.p-1074,
    -0.0,
    -0x1.0p-1074
  },
  { // Entry 50
    0.0,
    -0.0,
    -0.0
  },
  { // Entry 51
    0.0,
    -0.0,
    0x1.0p-1074
  },
  { // Entry 52
    0.0,
    -0.0,
    0x1.0p-1073
  },
  { // Entry 53
    0.0,
    -0.0,
    0x1.8p-1073
  },
  { // Entry 54
    0x1.p-1072,
    0x1.0p-1074,
    -0x1.8p-1073
  },
  { // Entry 55
    0x1.80p-1073,
    0x1.0p-1074,
    -0x1.0p-1073
  },
  { // Entry 56
    0x1.p-1073,
    0x1.0p-1074,
    -0x1.0p-1074
  },
  { // Entry 57
    0x1.p-1074,
    0x1.0p-1074,
    -0.0
  },
  { // Entry 58
    0.0,
    0x1.0p-1074,
    0x1.0p-1074
  },
  { // Entry 59
    0.0,
    0x1.0p-1074,
    0x1.0p-1073
  },
  { // Entry 60
    0.0,
    0x1.0p-1074,
    0x1.8p-1073
  },
  { // Entry 61
    0x1.40p-1072,
    0x1.0p-1073,
    -0x1.8p-1073
  },
  { // Entry 62
    0x1.p-1072,
    0x1.0p-1073,
    -0x1.0p-1073
  },
  { // Entry 63
    0x1.80p-1073,
    0x1.0p-1073,
    -0x1.0p-1074
  },
  { // Entry 64
    0x1.p-1073,
    0x1.0p-1073,
    -0.0
  },
  { // Entry 65
    0x1.p-1074,
    0x1.0p-1073,
    0x1.0p-1074
  },
  { // Entry 66
    0.0,
    0x1.0p-1073,
    0x1.0p-1073
  },
  { // Entry 67
    0.0,
    0x1.0p-1073,
    0x1.8p-1073
  },
  { // Entry 68
    0x1.80p-1072,
    0x1.8p-1073,
    -0x1.8p-1073
  },
  { // Entry 69
    0x1.40p-1072,
    0x1.8p-1073,
    -0x1.0p-1073
  },
  { // Entry 70
    0x1.p-1072,
    0x1.8p-1073,
    -0x1.0p-1074
  },
  { // Entry 71
    0x1.80p-1073,
    0x1.8p-1073,
    -0.0
  },
  { // Entry 72
    0x1.p-1073,
    0x1.8p-1073,
    0x1.0p-1074
  },
  { // Entry 73
    0x1.p-1074,
    0x1.8p-1073,
    0x1.0p-1073
  },
  { // Entry 74
    0.0,
    0x1.8p-1073,
    0x1.8p-1073
  },
  { // Entry 75
    0.0,
    -0x1.fffffffffffffp1023,
    -0x1.fffffffffffffp1023
  },
  { // Entry 76
    0.0,
    0x1.fffffffffffffp1023,
    0x1.fffffffffffffp1023
  },
  { // Entry 77
    0.0,
    -0x1.0p-1074,
    -0x1.0p-1074
  },
  { // Entry 78
    0.0,
    0x1.0p-1074,
    0x1.0p-1074
  },
  { // Entry 79
    0x1.p-1073,
    0x1.0p-1074,
    -0x1.0p-1074
  },
  { // Entry 80
    0x1.fffffffffffff0p1023,
    0x1.fffffffffffffp1023,
    -0x1.0p-1074
  },
  { // Entry 81
    0x1.fffffffffffff0p1023,
    0x1.fffffffffffffp1023,
    -0.0
  },
  { // Entry 82
    0x1.ffffffffffffefffffffffffffffffffp1023,
    0x1.fffffffffffffp1023,
    0x1.0p-1074
  },
  { // Entry 83
    0.0,
    -0x1.0p-1074,
    0x1.fffffffffffffp1023
  },
  { // Entry 84
    0.0,
    -0.0,
    0x1.fffffffffffffp1023
  },
  { // Entry 85
    0.0,
    0x1.0p-1074,
    0x1.fffffffffffffp1023
  },
  { // Entry 86
    0x1.fffffffffffff0p1023,
    0x1.fffffffffffffp1022,
    -0x1.fffffffffffffp1022
  },
  { // Entry 87
    0.0,
    0x1.ffffffffffffcp-1024,
    0x1.ffffffffffffcp-1024
  },
  { // Entry 88
    0.0,
    0x1.ffffffffffffcp-1024,
    0x1.0p-1023
  },
  { // Entry 89
    0.0,
    0x1.ffffffffffffcp-1024,
    0x1.0000000000002p-1023
  },
  { // Entry 90
    0x1.p-1074,
    0x1.0p-1023,
    0x1.ffffffffffffcp-1024
  },
  { // Entry 91
    0.0,
    0x1.0p-1023,
    0x1.0p-1023
  },
  { // Entry 92
    0.0,
    0x1.0p-1023,
    0x1.0000000000002p-1023
  },
  { // Entry 93
    0x1.p-1073,
    0x1.0000000000002p-1023,
    0x1.ffffffffffffcp-1024
  },
  { // Entry 94
    0x1.p-1074,
    0x1.0000000000002p-1023,
    0x1.0p-1023
  },
  { // Entry 95
    0.0,
    0x1.0000000000002p-1023,
    0x1.0000000000002p-1023
  },
  { // Entry 96
    0.0,
    0x1.fffffffffffffp-51,
    0x1.fffffffffffffp-51
  },
  { // Entry 97
    0.0,
    0x1.fffffffffffffp-51,
    0x1.0p-50
  },
  { // Entry 98
    0.0,
    0x1.fffffffffffffp-51,
    0x1.0000000000001p-50
  },
  { // Entry 99
    0x1.p-103,
    0x1.0p-50,
    0x1.fffffffffffffp-51
  },
  { // Entry 100
    0.0,
    0x1.0p-50,
    0x1.0p-50
  },
  { // Entry 101
    0.0,
    0x1.0p-50,
    0x1.0000000000001p-50
  },
  { // Entry 102
    0x1.80p-102,
    0x1.0000000000001p-50,
    0x1.fffffffffffffp-51
  },
  { // Entry 103
    0x1.p-102,
    0x1.0000000000001p-50,
    0x1.0p-50
  },
  { // Entry 104
    0.0,
    0x1.0000000000001p-50,
    0x1.0000000000001p-50
  },
  { // Entry 105
    0.0,
    0x1.fffffffffffffp-11,
    0x1.fffffffffffffp-11
  },
  { // Entry 106
    0.0,
    0x1.fffffffffffffp-11,
    0x1.0p-10
  },
  { // Entry 107
    0.0,
    0x1.fffffffffffffp-11,
    0x1.0000000000001p-10
  },
  { // Entry 108
    0x1.p-63,
    0x1.0p-10,
    0x1.fffffffffffffp-11
  },
  { // Entry 109
    0.0,
    0x1.0p-10,
    0x1.0p-10
  },
  { // Entry 110
    0.0,
    0x1.0p-10,
    0x1.0000000000001p-10
  },
  { // Entry 111
    0x1.80p-62,
    0x1.0000000000001p-10,
    0x1.fffffffffffffp-11
  },
  { // Entry 112
    0x1.p-62,
    0x1.0000000000001p-10,
    0x1.0p-10
  },
  { // Entry 113
    0.0,
    0x1.0000000000001p-10,
    0x1.0000000000001p-10
  },
  { // Entry 114
    0.0,
    0x1.fffffffffffffp-2,
    0x1.fffffffffffffp-2
  },
  { // Entry 115
    0.0,
    0x1.fffffffffffffp-2,
    0x1.0p-1
  },
  { // Entry 116
    0.0,
    0x1.fffffffffffffp-2,
    0x1.0000000000001p-1
  },
  { // Entry 117
    0x1.p-54,
    0x1.0p-1,
    0x1.fffffffffffffp-2
  },
  { // Entry 118
    0.0,
    0x1.0p-1,
    0x1.0p-1
  },
  { // Entry 119
    0.0,
    0x1.0p-1,
    0x1.0000000000001p-1
  },
  { // Entry 120
    0x1.80p-53,
    0x1.0000000000001p-1,
    0x1.fffffffffffffp-2
  },
  { // Entry 121
    0x1.p-53,
    0x1.0000000000001p-1,
    0x1.0p-1
  },
  { // Entry 122
    0.0,
    0x1.0000000000001p-1,
    0x1.0000000000001p-1
  },
  { // Entry 123
    0.0,
    0x1.fffffffffffffp0,
    0x1.fffffffffffffp0
  },
  { // Entry 124
    0.0,
    0x1.fffffffffffffp0,
    0x1.0p1
  },
  { // Entry 125
    0.0,
    0x1.fffffffffffffp0,
    0x1.0000000000001p1
  },
  { // Entry 126
    0x1.p-52,
    0x1.0p1,
    0x1.fffffffffffffp0
  },
  { // Entry 127
    0.0,
    0x1.0p1,
    0x1.0p1
  },
  { // Entry 128
    0.0,
    0x1.0p1,
    0x1.0000000000001p1
  },
  { // Entry 129
    0x1.80p-51,
    0x1.0000000000001p1,
    0x1.fffffffffffffp0
  },
  { // Entry 130
    0x1.p-51,
    0x1.0000000000001p1,
    0x1.0p1
  },
  { // Entry 131
    0.0,
    0x1.0000000000001p1,
    0x1.0000000000001p1
  },
  { // Entry 132
    0.0,
    0x1.fffffffffffffp9,
    0x1.fffffffffffffp9
  },
  { // Entry 133
    0.0,
    0x1.fffffffffffffp9,
    0x1.0p10
  },
  { // Entry 134
    0.0,
    0x1.fffffffffffffp9,
    0x1.0000000000001p10
  },
  { // Entry 135
    0x1.p-43,
    0x1.0p10,
    0x1.fffffffffffffp9
  },
  { // Entry 136
    0.0,
    0x1.0p10,
    0x1.0p10
  },
  { // Entry 137
    0.0,
    0x1.0p10,
    0x1.0000000000001p10
  },
  { // Entry 138
    0x1.80p-42,
    0x1.0000000000001p10,
    0x1.fffffffffffffp9
  },
  { // Entry 139
    0x1.p-42,
    0x1.0000000000001p10,
    0x1.0p10
  },
  { // Entry 140
    0.0,
    0x1.0000000000001p10,
    0x1.0000000000001p10
  },
  { // Entry 141
    0.0,
    0x1.fffffffffffffp49,
    0x1.fffffffffffffp49
  },
  { // Entry 142
    0.0,
    0x1.fffffffffffffp49,
    0x1.0p50
  },
  { // Entry 143
    0.0,
    0x1.fffffffffffffp49,
    0x1.0000000000001p50
  },
  { // Entry 144
    0x1.p-3,
    0x1.0p50,
    0x1.fffffffffffffp49
  },
  { // Entry 145
    0.0,
    0x1.0p50,
    0x1.0p50
  },
  { // Entry 146
    0.0,
    0x1.0p50,
    0x1.0000000000001p50
  },
  { // Entry 147
    0x1.80p-2,
    0x1.0000000000001p50,
    0x1.fffffffffffffp49
  },
  { // Entry 148
    0x1.p-2,
    0x1.0000000000001p50,
    0x1.0p50
  },
  { // Entry 149
    0.0,
    0x1.0000000000001p50,
    0x1.0000000000001p50
  },
  { // Entry 150
    0.0,
    0x1.fffffffffffffp1022,
    0x1.fffffffffffffp1022
  },
  { // Entry 151
    0.0,
    0x1.fffffffffffffp1022,
    0x1.0p1023
  },
  { // Entry 152
    0.0,
    0x1.fffffffffffffp1022,
    0x1.0000000000001p1023
  },
  { // Entry 153
    0x1.p970,
    0x1.0p1023,
    0x1.fffffffffffffp1022
  },
  { // Entry 154
    0.0,
    0x1.0p1023,
    0x1.0p1023
  },
  { // Entry 155
    0.0,
    0x1.0p1023,
    0x1.0000000000001p1023
  },
  { // Entry 156
    0x1.80p971,
    0x1.0000000000001p1023,
    0x1.fffffffffffffp1022
  },
  { // Entry 157
    0x1.p971,
    0x1.0000000000001p1023,
    0x1.0p1023
  },
  { // Entry 158
    0.0,
    0x1.0000000000001p1023,
    0x1.0000000000001p1023
  },
  { // Entry 159
    0.0,
    HUGE_VAL,
    HUGE_VAL
  },
  { // Entry 160
    HUGE_VAL,
    HUGE_VAL,
    0x1.fffffffffffffp1023
  },
  { // Entry 161
    HUGE_VAL,
    HUGE_VAL,
    0x1.0p-1022
  },
  { // Entry 162
    HUGE_VAL,
    HUGE_VAL,
    0x1.ffffffffffffep-1023
  },
  { // Entry 163
    HUGE_VAL,
    HUGE_VAL,
    0x1.0p-1074
  },
  { // Entry 164
    HUGE_VAL,
    HUGE_VAL,
    0.0
  },
  { // Entry 165
    HUGE_VAL,
    HUGE_VAL,
    -0.0
  },
  { // Entry 166
    HUGE_VAL,
    HUGE_VAL,
    -0x1.0p-1074
  },
  { // Entry 167
    HUGE_VAL,
    HUGE_VAL,
    -0x1.ffffffffffffep-1023
  },
  { // Entry 168
    HUGE_VAL,
    HUGE_VAL,
    -0x1.0p-1022
  },
  { // Entry 169
    HUGE_VAL,
    HUGE_VAL,
    -0x1.0p0
  },
  { // Entry 170
    HUGE_VAL,
    HUGE_VAL,
    -0x1.fffffffffffffp1023
  },
  { // Entry 171
    HUGE_VAL,
    HUGE_VAL,
    -HUGE_VAL
  },
  { // Entry 172
    0.0,
    0x1.fffffffffffffp1023,
    HUGE_VAL
  },
  { // Entry 173
    0.0,
    0x1.fffffffffffffp1023,
    0x1.fffffffffffffp1023
  },
  { // Entry 174
    0x1.ffffffffffffefffffffffffffffffffp1023,
    0x1.fffffffffffffp1023,
    0x1.0p-1022
  },
  { // Entry 175
    0x1.ffffffffffffefffffffffffffffffffp1023,
    0x1.fffffffffffffp1023,
    0x1.ffffffffffffep-1023
  },
  { // Entry 176
    0x1.ffffffffffffefffffffffffffffffffp1023,
    0x1.fffffffffffffp1023,
    0x1.0p-1074
  },
  { // Entry 177
    0x1.fffffffffffff0p1023,
    0x1.fffffffffffffp1023,
    0.0
  },
  { // Entry 178
    0x1.fffffffffffff0p1023,
    0x1.fffffffffffffp1023,
    -0.0
  },
  { // Entry 179
    0x1.fffffffffffff0p1023,
    0x1.fffffffffffffp1023,
    -0x1.0p-1074
  },
  { // Entry 180
    0x1.fffffffffffff0p1023,
    0x1.fffffffffffffp1023,
    -0x1.ffffffffffffep-1023
  },
  { // Entry 181
    0x1.fffffffffffff0p1023,
    0x1.fffffffffffffp1023,
    -0x1.0p-1022
  },
  { // Entry 182
    0x1.fffffffffffff0p1023,
    0x1.fffffffffffffp1023,
    -0x1.0p0
  },
  { // Entry 183
    HUGE_VAL,
    0x1.fffffffffffffp1023,
    -0x1.fffffffffffffp1023
  },
  { // Entry 184
    HUGE_VAL,
    0x1.fffffffffffffp1023,
    -HUGE_VAL
  },
  { // Entry 185
    0.0,
    0x1.0p-1022,
    HUGE_VAL
  },
  { // Entry 186
    0.0,
    0x1.0p-1022,
    0x1.fffffffffffffp1023
  },
  { // Entry 187
    0.0,
    0x1.0p-1022,
    0x1.0p-1022
  },
  { // Entry 188
    0x1.p-1074,
    0x1.0p-1022,
    0x1.ffffffffffffep-1023
  },
  { // Entry 189
    0x1.ffffffffffffe0p-1023,
    0x1.0p-1022,
    0x1.0p-1074
  },
  { // Entry 190
    0x1.p-1022,
    0x1.0p-1022,
    0.0
  },
  { // Entry 191
    0x1.p-1022,
    0x1.0p-1022,
    -0.0
  },
  { // Entry 192
    0x1.00000000000010p-1022,
    0x1.0p-1022,
    -0x1.0p-1074
  },
  { // Entry 193
    0x1.fffffffffffff0p-1022,
    0x1.0p-1022,
    -0x1.ffffffffffffep-1023
  },
  { // Entry 194
    0x1.p-1021,
    0x1.0p-1022,
    -0x1.0p-1022
  },
  { // Entry 195
    0x1.p0,
    0x1.0p-1022,
    -0x1.0p0
  },
  { // Entry 196
    0x1.fffffffffffff0p1023,
    0x1.0p-1022,
    -0x1.fffffffffffffp1023
  },
  { // Entry 197
    HUGE_VAL,
    0x1.0p-1022,
    -HUGE_VAL
  },
  { // Entry 198
    0.0,
    0x1.ffffffffffffep-1023,
    HUGE_VAL
  },
  { // Entry 199
    0.0,
    0x1.ffffffffffffep-1023,
    0x1.fffffffffffffp1023
  },
  { // Entry 200
    0.0,
    0x1.ffffffffffffep-1023,
    0x1.0p-1022
  },
  { // Entry 201
    0.0,
    0x1.ffffffffffffep-1023,
    0x1.ffffffffffffep-1023
  },
  { // Entry 202
    0x1.ffffffffffffc0p-1023,
    0x1.ffffffffffffep-1023,
    0x1.0p-1074
  },
  { // Entry 203
    0x1.ffffffffffffe0p-1023,
    0x1.ffffffffffffep-1023,
    0.0
  },
  { // Entry 204
    0x1.ffffffffffffe0p-1023,
    0x1.ffffffffffffep-1023,
    -0.0
  },
  { // Entry 205
    0x1.p-1022,
    0x1.ffffffffffffep-1023,
    -0x1.0p-1074
  },
  { // Entry 206
    0x1.ffffffffffffe0p-1022,
    0x1.ffffffffffffep-1023,
    -0x1.ffffffffffffep-1023
  },
  { // Entry 207
    0x1.fffffffffffff0p-1022,
    0x1.ffffffffffffep-1023,
    -0x1.0p-1022
  },
  { // Entry 208
    0x1.p0,
    0x1.ffffffffffffep-1023,
    -0x1.0p0
  },
  { // Entry 209
    0x1.fffffffffffff0p1023,
    0x1.ffffffffffffep-1023,
    -0x1.fffffffffffffp1023
  },
  { // Entry 210
    HUGE_VAL,
    0x1.ffffffffffffep-1023,
    -HUGE_VAL
  },
  { // Entry 211
    0.0,
    0x1.0p-1074,
    HUGE_VAL
  },
  { // Entry 212
    0.0,
    0x1.0p-1074,
    0x1.fffffffffffffp1023
  },
  { // Entry 213
    0.0,
    0x1.0p-1074,
    0x1.0p-1022
  },
  { // Entry 214
    0.0,
    0x1.0p-1074,
    0x1.ffffffffffffep-1023
  },
  { // Entry 215
    0.0,
    0x1.0p-1074,
    0x1.0p-1074
  },
  { // Entry 216
    0x1.p-1074,
    0x1.0p-1074,
    0.0
  },
  { // Entry 217
    0x1.p-1074,
    0x1.0p-1074,
    -0.0
  },
  { // Entry 218
    0x1.p-1073,
    0x1.0p-1074,
    -0x1.0p-1074
  },
  { // Entry 219
    0x1.p-1022,
    0x1.0p-1074,
    -0x1.ffffffffffffep-1023
  },
  { // Entry 220
    0x1.00000000000010p-1022,
    0x1.0p-1074,
    -0x1.0p-1022
  },
  { // Entry 221
    0x1.p0,
    0x1.0p-1074,
    -0x1.0p0
  },
  { // Entry 222
    0x1.fffffffffffff0p1023,
    0x1.0p-1074,
    -0x1.fffffffffffffp1023
  },
  { // Entry 223
    HUGE_VAL,
    0x1.0p-1074,
    -HUGE_VAL
  },
  { // Entry 224
    0.0,
    0.0,
    HUGE_VAL
  },
  { // Entry 225
    0.0,
    0.0,
    0x1.fffffffffffffp1023
  },
  { // Entry 226
    0.0,
    0.0,
    0x1.0p-1022
  },
  { // Entry 227
    0.0,
    0.0,
    0x1.ffffffffffffep-1023
  },
  { // Entry 228
    0.0,
    0.0,
    0x1.0p-1074
  },
  { // Entry 229
    0.0,
    0.0,
    0.0
  },
  { // Entry 230
    0.0,
    0.0,
    -0.0
  },
  { // Entry 231
    0x1.p-1074,
    0.0,
    -0x1.0p-1074
  },
  { // Entry 232
    0x1.ffffffffffffe0p-1023,
    0.0,
    -0x1.ffffffffffffep-1023
  },
  { // Entry 233
    0x1.p-1022,
    0.0,
    -0x1.0p-1022
  },
  { // Entry 234
    0x1.p0,
    0.0,
    -0x1.0p0
  },
  { // Entry 235
    0x1.fffffffffffff0p1023,
    0.0,
    -0x1.fffffffffffffp1023
  },
  { // Entry 236
    HUGE_VAL,
    0.0,
    -HUGE_VAL
  },
  { // Entry 237
    0.0,
    -0.0,
    HUGE_VAL
  },
  { // Entry 238
    0.0,
    -0.0,
    0x1.fffffffffffffp1023
  },
  { // Entry 239
    0.0,
    -0.0,
    0x1.0p-1022
  },
  { // Entry 240
    0.0,
    -0.0,
    0x1.ffffffffffffep-1023
  },
  { // Entry 241
    0.0,
    -0.0,
    0x1.0p-1074
  },
  { // Entry 242
    0.0,
    -0.0,
    0.0
  },
  { // Entry 243
    0.0,
    -0.0,
    -0.0
  },
  { // Entry 244
    0x1.p-1074,
    -0.0,
    -0x1.0p-1074
  },
  { // Entry 245
    0x1.ffffffffffffe0p-1023,
    -0.0,
    -0x1.ffffffffffffep-1023
  },
  { // Entry 246
    0x1.p-1022,
    -0.0,
    -0x1.0p-1022
  },
  { // Entry 247
    0x1.p0,
    -0.0,
    -0x1.0p0
  },
  { // Entry 248
    0x1.fffffffffffff0p1023,
    -0.0,
    -0x1.fffffffffffffp1023
  },
  { // Entry 249
    HUGE_VAL,
    -0.0,
    -HUGE_VAL
  },
  { // Entry 250
    0.0,
    -0x1.0p-1074,
    HUGE_VAL
  },
  { // Entry 251
    0.0,
    -0x1.0p-1074,
    0x1.fffffffffffffp1023
  },
  { // Entry 252
    0.0,
    -0x1.0p-1074,
    0x1.0p-1022
  },
  { // Entry 253
    0.0,
    -0x1.0p-1074,
    0x1.ffffffffffffep-1023
  },
  { // Entry 254
    0.0,
    -0x1.0p-1074,
    0x1.0p-1074
  },
  { // Entry 255
    0.0,
    -0x1.0p-1074,
    0.0
  },
  { // Entry 256
    0.0,
    -0x1.0p-1074,
    -0.0
  },
  { // Entry 257
    0.0,
    -0x1.0p-1074,
    -0x1.0p-1074
  },
  { // Entry 258
    0x1.ffffffffffffc0p-1023,
    -0x1.0p-1074,
    -0x1.ffffffffffffep-1023
  },
  { // Entry 259
    0x1.ffffffffffffe0p-1023,
    -0x1.0p-1074,
    -0x1.0p-1022
  },
  { // Entry 260
    0x1.ffffffffffffffffffffffffffffffffp-1,
    -0x1.0p-1074,
    -0x1.0p0
  },
  { // Entry 261
    0x1.ffffffffffffefffffffffffffffffffp1023,
    -0x1.0p-1074,
    -0x1.fffffffffffffp1023
  },
  { // Entry 262
    HUGE_VAL,
    -0x1.0p-1074,
    -HUGE_VAL
  },
  { // Entry 263
    0.0,
    -0x1.ffffffffffffep-1023,
    HUGE_VAL
  },
  { // Entry 264
    0.0,
    -0x1.ffffffffffffep-1023,
    0x1.fffffffffffffp1023
  },
  { // Entry 265
    0.0,
    -0x1.ffffffffffffep-1023,
    0x1.0p-1022
  },
  { // Entry 266
    0.0,
    -0x1.ffffffffffffep-1023,
    0x1.ffffffffffffep-1023
  },
  { // Entry 267
    0.0,
    -0x1.ffffffffffffep-1023,
    0x1.0p-1074
  },
  { // Entry 268
    0.0,
    -0x1.ffffffffffffep-1023,
    0.0
  },
  { // Entry 269
    0.0,
    -0x1.ffffffffffffep-1023,
    -0.0
  },
  { // Entry 270
    0.0,
    -0x1.ffffffffffffep-1023,
    -0x1.0p-1074
  },
  { // Entry 271
    0.0,
    -0x1.ffffffffffffep-1023,
    -0x1.ffffffffffffep-1023
  },
  { // Entry 272
    0x1.p-1074,
    -0x1.ffffffffffffep-1023,
    -0x1.0p-1022
  },
  { // Entry 273
    0x1.ffffffffffffffffffffffffffffffffp-1,
    -0x1.ffffffffffffep-1023,
    -0x1.0p0
  },
  { // Entry 274
    0x1.ffffffffffffefffffffffffffffffffp1023,
    -0x1.ffffffffffffep-1023,
    -0x1.fffffffffffffp1023
  },
  { // Entry 275
    HUGE_VAL,
    -0x1.ffffffffffffep-1023,
    -HUGE_VAL
  },
  { // Entry 276
    0.0,
    -0x1.0p-1022,
    HUGE_VAL
  },
  { // Entry 277
    0.0,
    -0x1.0p-1022,
    0x1.fffffffffffffp1023
  },
  { // Entry 278
    0.0,
    -0x1.0p-1022,
    0x1.0p-1022
  },
  { // Entry 279
    0.0,
    -0x1.0p-1022,
    0x1.ffffffffffffep-1023
  },
  { // Entry 280
    0.0,
    -0x1.0p-1022,
    0x1.0p-1074
  },
  { // Entry 281
    0.0,
    -0x1.0p-1022,
    0.0
  },
  { // Entry 282
    0.0,
    -0x1.0p-1022,
    -0.0
  },
  { // Entry 283
    0.0,
    -0x1.0p-1022,
    -0x1.0p-1074
  },
  { // Entry 284
    0.0,
    -0x1.0p-1022,
    -0x1.ffffffffffffep-1023
  },
  { // Entry 285
    0.0,
    -0x1.0p-1022,
    -0x1.0p-1022
  },
  { // Entry 286
    0x1.ffffffffffffffffffffffffffffffffp-1,
    -0x1.0p-1022,
    -0x1.0p0
  },
  { // Entry 287
    0x1.ffffffffffffefffffffffffffffffffp1023,
    -0x1.0p-1022,
    -0x1.fffffffffffffp1023
  },
  { // Entry 288
    HUGE_VAL,
    -0x1.0p-1022,
    -HUGE_VAL
  },
  { // Entry 289
    0.0,
    -0x1.fffffffffffffp-1,
    HUGE_VAL
  },
  { // Entry 290
    0.0,
    -0x1.fffffffffffffp-1,
    0x1.fffffffffffffp1023
  },
  { // Entry 291
    0.0,
    -0x1.fffffffffffffp-1,
    0x1.0p-1022
  },
  { // Entry 292
    0.0,
    -0x1.fffffffffffffp-1,
    0x1.ffffffffffffep-1023
  },
  { // Entry 293
    0.0,
    -0x1.fffffffffffffp-1,
    0x1.0p-1074
  },
  { // Entry 294
    0.0,
    -0x1.fffffffffffffp-1,
    0.0
  },
  { // Entry 295
    0.0,
    -0x1.fffffffffffffp-1,
    -0.0
  },
  { // Entry 296
    0.0,
    -0x1.fffffffffffffp-1,
    -0x1.0p-1074
  },
  { // Entry 297
    0.0,
    -0x1.fffffffffffffp-1,
    -0x1.ffffffffffffep-1023
  },
  { // Entry 298
    0.0,
    -0x1.fffffffffffffp-1,
    -0x1.0p-1022
  },
  { // Entry 299
    0x1.p-53,
    -0x1.fffffffffffffp-1,
    -0x1.0p0
  },
  { // Entry 300
    0x1.ffffffffffffefffffffffffffffffffp1023,
    -0x1.fffffffffffffp-1,
    -0x1.fffffffffffffp1023
  },
  { // Entry 301
    HUGE_VAL,
    -0x1.fffffffffffffp-1,
    -HUGE_VAL
  },
  { // Entry 302
    0.0,
    -0x1.0p0,
    HUGE_VAL
  },
  { // Entry 303
    0.0,
    -0x1.0p0,
    0x1.fffffffffffffp1023
  },
  { // Entry 304
    0.0,
    -0x1.0p0,
    0x1.0p-1022
  },
  { // Entry 305
    0.0,
    -0x1.0p0,
    0x1.ffffffffffffep-1023
  },
  { // Entry 306
    0.0,
    -0x1.0p0,
    0x1.0p-1074
  },
  { // Entry 307
    0.0,
    -0x1.0p0,
    0.0
  },
  { // Entry 308
    0.0,
    -0x1.0p0,
    -0.0
  },
  { // Entry 309
    0.0,
    -0x1.0p0,
    -0x1.0p-1074
  },
  { // Entry 310
    0.0,
    -0x1.0p0,
    -0x1.ffffffffffffep-1023
  },
  { // Entry 311
    0.0,
    -0x1.0p0,
    -0x1.0p-1022
  },
  { // Entry 312
    0.0,
    -0x1.0p0,
    -0x1.0p0
  },
  { // Entry 313
    0x1.ffffffffffffefffffffffffffffffffp1023,
    -0x1.0p0,
    -0x1.fffffffffffffp1023
  },
  { // Entry 314
    HUGE_VAL,
    -0x1.0p0,
    -HUGE_VAL
  },
  { // Entry 315
    0.0,
    -0x1.0000000000001p0,
    HUGE_VAL
  },
  { // Entry 316
    0.0,
    -0x1.0000000000001p0,
    0x1.fffffffffffffp1023
  },
  { // Entry 317
    0.0,
    -0x1.0000000000001p0,
    0x1.0p-1022
  },
  { // Entry 318
    0.0,
    -0x1.0000000000001p0,
    0x1.ffffffffffffep-1023
  },
  { // Entry 319
    0.0,
    -0x1.0000000000001p0,
    0x1.0p-1074
  },
  { // Entry 320
    0.0,
    -0x1.0000000000001p0,
    0.0
  },
  { // Entry 321
    0.0,
    -0x1.0000000000001p0,
    -0.0
  },
  { // Entry 322
    0.0,
    -0x1.0000000000001p0,
    -0x1.0p-1074
  },
  { // Entry 323
    0.0,
    -0x1.0000000000001p0,
    -0x1.ffffffffffffep-1023
  },
  { // Entry 324
    0.0,
    -0x1.0000000000001p0,
    -0x1.0p-1022
  },
  { // Entry 325
    0.0,
    -0x1.0000000000001p0,
    -0x1.0p0
  },
  { // Entry 326
    0x1.ffffffffffffefffffffffffffffffffp1023,
    -0x1.0000000000001p0,
    -0x1.fffffffffffffp1023
  },
  { // Entry 327
    HUGE_VAL,
    -0x1.0000000000001p0,
    -HUGE_VAL
  },
  { // Entry 328
    0.0,
    -0x1.fffffffffffffp1023,
    HUGE_VAL
  },
  { // Entry 329
    0.0,
    -0x1.fffffffffffffp1023,
    0x1.fffffffffffffp1023
  },
  { // Entry 330
    0.0,
    -0x1.fffffffffffffp1023,
    0x1.0p-1022
  },
  { // Entry 331
    0.0,
    -0x1.fffffffffffffp1023,
    0x1.ffffffffffffep-1023
  },
  { // Entry 332
    0.0,
    -0x1.fffffffffffffp1023,
    0x1.0p-1074
  },
  { // Entry 333
    0.0,
    -0x1.fffffffffffffp1023,
    0.0
  },
  { // Entry 334
    0.0,
    -0x1.fffffffffffffp1023,
    -0.0
  },
  { // Entry 335
    0.0,
    -0x1.fffffffffffffp1023,
    -0x1.0p-1074
  },
  { // Entry 336
    0.0,
    -0x1.fffffffffffffp1023,
    -0x1.ffffffffffffep-1023
  },
  { // Entry 337
    0.0,
    -0x1.fffffffffffffp1023,
    -0x1.0p-1022
  },
  { // Entry 338
    0.0,
    -0x1.fffffffffffffp1023,
    -0x1.0p0
  },
  { // Entry 339
    0.0,
    -0x1.fffffffffffffp1023,
    -0x1.fffffffffffffp1023
  },
  { // Entry 340
    HUGE_VAL,
    -0x1.fffffffffffffp1023,
    -HUGE_VAL
  },
  { // Entry 341
    0.0,
    -HUGE_VAL,
    HUGE_VAL
  },
  { // Entry 342
    0.0,
    -HUGE_VAL,
    0x1.fffffffffffffp1023
  },
  { // Entry 343
    0.0,
    -HUGE_VAL,
    0x1.0p-1022
  },
  { // Entry 344
    0.0,
    -HUGE_VAL,
    0x1.ffffffffffffep-1023
  },
  { // Entry 345
    0.0,
    -HUGE_VAL,
    0x1.0p-1074
  },
  { // Entry 346
    0.0,
    -HUGE_VAL,
    0.0
  },
  { // Entry 347
    0.0,
    -HUGE_VAL,
    -0.0
  },
  { // Entry 348
    0.0,
    -HUGE_VAL,
    -0x1.0p-1074
  },
  { // Entry 349
    0.0,
    -HUGE_VAL,
    -0x1.ffffffffffffep-1023
  },
  { // Entry 350
    0.0,
    -HUGE_VAL,
    -0x1.0p-1022
  },
  { // Entry 351
    0.0,
    -HUGE_VAL,
    -0x1.0p0
  },
  { // Entry 352
    0.0,
    -HUGE_VAL,
    -0x1.fffffffffffffp1023
  },
  { // Entry 353
    0.0,
    -HUGE_VAL,
    -HUGE_VAL
  }
};
