#!/usr/bin/python

# This tool is used to generate the version scripts for libc and libm
# for every architecture.

import atexit
import os.path
import shutil
import tempfile
import sys


all_arches = ["arm", "arm64", "mips", "mips64", "x86", "x86_64"]
bionic_libc_root = os.path.join(os.environ["ANDROID_BUILD_TOP"], "bionic/libc")
bionic_libm_root = os.path.join(os.environ["ANDROID_BUILD_TOP"], "bionic/libm")
bionic_libdl_root = os.path.join(os.environ["ANDROID_BUILD_TOP"], "bionic/libdl")
libc_script = os.path.join(bionic_libc_root, "libc.map.txt")
libm_script = os.path.join(bionic_libm_root, "libm.map.txt")
libdl_script = os.path.join(bionic_libdl_root, "libdl.map.txt")

script_name = os.path.basename(sys.argv[0])

# TODO (dimity): generate architecture-specific version scripts as part of build

# temp directory where we store all intermediate files
bionic_temp = tempfile.mkdtemp(prefix="bionic_genversionscripts")
# Make sure the directory is deleted when the script exits.
atexit.register(shutil.rmtree, bionic_temp)

bionic_libc_root = os.path.join(os.environ["ANDROID_BUILD_TOP"], "bionic/libc")

warning = "Generated by %s. Do not edit." % script_name


class VersionScriptGenerator(object):

  def run(self):
    for script in [libc_script, libm_script, libdl_script]:
      basename = os.path.basename(script)
      dirname = os.path.dirname(script)
      for arch in all_arches:
        for brillo in [False, True]:
          has_nobrillo = False
          name = basename.split(".")[0] + "." + arch + (".brillo" if brillo else "") + ".map"
          tmp_path = os.path.join(bionic_temp, name)
          dest_path = os.path.join(dirname, name)
          with open(tmp_path, "w") as fout:
            with open(script, "r") as fin:
              fout.write("# %s\n" % warning)
              for line in fin:
                index = line.find("#")
                if index != -1:
                  tags = line[index+1:].split()
                  if arch not in tags:
                    continue
                  if brillo and "nobrillo" in tags:
                    has_nobrillo = True
                    continue
                fout.write(line)
          if not brillo or has_nobrillo:
            shutil.copyfile(tmp_path, dest_path)


generator = VersionScriptGenerator()
generator.run()

