# This is a generic product that isn't specialized for a specific device.
# It includes the base Android-x86 platform.

PRODUCT_PACKAGES := \
    GlobalTime \
    JETBoy \
    LiveWallpapers \
    LiveWallpapersPicker \
    LunarLander \
    MagicSmokeWallpapers \
    NotePad \
    Provision \
    RSSReader \
    Snake \
    SoundRecorder \
    VisualizationWallpapers \
    VoiceDialer \
    acoustics.default \
    alsa_ctl \
    alsa.default \
    chat \
    com.android.future.usb.accessory \
    faketsd \
    librs_jni \
    make_ext4fs \
    powerbtnd \
    v86d \

PRODUCT_PACKAGES += \
    badblocks \
    e2fsck \
    mke2fs \
    resize2fs \
    tune2fs \

THIRD_PARTY_APPS = \
    ConnectBot \
    FileManager \
    LIME \

# Get the long list of APNs
PRODUCT_COPY_FILES := \
    device/sample/etc/apns-full-conf.xml:system/etc/apns-conf.xml \
    frameworks/base/data/etc/android.hardware.usb.accessory.xml:system/etc/permissions/android.hardware.usb.accessory.xml \

$(call inherit-product,$(SRC_TARGET_DIR)/product/generic.mk)

# Pick up some sounds
$(call inherit-product,frameworks/base/data/sounds/OriginalAudio.mk)

# Get the hardware acceleration libraries
$(call inherit-product-if-exists,device/common/gpu/gpu_mesa.mk)

# Get the touchscreen calibration tool
$(call inherit-product-if-exists,external/tslib/tslib.mk)

# Get the language keymaps
$(call inherit-product-if-exists,device/common/keymaps/keymaps.mk)

# Get the TTS language packs
$(call inherit-product-if-exists,external/svox/pico/lang/all_pico_languages.mk)

# Overrides
PRODUCT_BRAND := generic_x86
PRODUCT_DEVICE := generic_x86
PRODUCT_NAME := generic_x86
PRODUCT_POLICY := android.policy_phone
PRODUCT_PROPERTY_OVERRIDES += ro.com.android.dataroaming=true

PRODUCT_LOCALES += hdpi mdpi

GENERIC_X86_CONFIG_MK := $(SRC_TARGET_DIR)/board/generic_x86/BoardConfig.mk
GENERIC_X86_ANDROID_MK := $(SRC_TARGET_DIR)/board/generic_x86/AndroidBoard.mk
