/* Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package tests.api.java.nio.charset;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;

import junit.framework.TestCase;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;

/**
 * Super class for concrete charset test suites.
 */
public class Charset_TestGenerator_Res {

    Charset charset;
    CharsetDecoder decoder;
    CharsetEncoder encoder;

    // List of encodings currently required for Android.
    static String[] charsetNames = new String[] {
            // Encoding required by Java specification.
            "US-ASCII",
            "UTF-8",
            "UTF-16",
            "UTF-16BE",
            "UTF-16LE",
            "ISO-8859-1",
            
            // Additional encodings included in standard ICU
            "ISO-8859-2",
            "ISO-8859-3",
            "ISO-8859-4",
            "ISO-8859-5",
            "ISO-8859-6",
            "ISO-8859-7",
            "ISO-8859-8",
//jdk NoSup            "ISO-8859-8-I",
            "ISO-8859-9",
//jdk NoSup            "ISO-8859-10", 
            "ISO-8859-11",  //jdk x-...
            "ISO-8859-13",
//jdk NoSup            "ISO-8859-14", 
            "ISO-8859-15",
//jdk NoSup            "ISO-8859-16", 
            "ISO-2022-JP",
            "Windows-950",  //jdk x-...
            "Windows-1250",  //jdk x-...
            "Windows-1251",
            "Windows-1252",
            "Windows-1253",
            "Windows-1254",
            "Windows-1255",
            "Windows-1256",
            "Windows-1257",
            "Windows-1258",              
            "Big5",
            "CP864",
            "CP874",
            "EUC-CN",
            "EUC-JP",
            "KOI8-R",
//jdk NoSup            "Macintosh",
            "GBK",
            "GB2312",
            "EUC-KR"};

    static final short[] codes = {
        9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
        89, 97, 100, 103, 106, 109, 112, 115, 118, 121, 170, 181, 186, 192, 195, 198, 
        201, 204, 207, 210, 213, 216, 219, 222, 225, 228, 231, 234, 237, 240, 243, 246, 
        249, 252, 255, 258, 261, 264, 267, 270, 273, 276, 279, 282, 285, 288, 291, 294, 
        297, 300, 303, 306, 309, 312, 315, 318, 321, 324, 327, 330, 333, 336, 339, 342, 
        345, 348, 351, 354, 357, 360, 363, 366, 369, 372, 375, 378, 381, 384, 387, 390, 
        393, 396, 399, 402, 405, 408, 411, 414, 417, 420, 423, 426, 429, 432, 435, 438, 
        441, 444, 447, 450, 453, 456, 459, 462, 465, 468, 471, 474, 477, 480, 483, 486, 
        489, 492, 495, 498, 501, 504, 507, 510, 513, 516, 519, 522, 525, 528, 531, 534, 
        537, 540, 543, 546, 549, 552, 555, 558, 561, 564, 592, 595, 598, 601, 604, 607, 
        610, 613, 616, 619, 622, 625, 628, 631, 634, 637, 640, 643, 646, 649, 652, 655, 
        658, 661, 664, 667, 670, 673, 676, 679, 682, 685, 688, 691, 694, 697, 700, 703, 
        710, 713, 716, 719, 736, 739, 750, 890, 902, 905, 908, 911, 914, 917, 920, 923, 
        926, 929, 932, 935, 938, 941, 944, 947, 950, 953, 956, 959, 962, 965, 968, 971, 
        974, 977, 980, 983, 986, 989, 992, 995, 998, 1001, 1004, 1007, 1010, 1013, 1016, 1019, 
        1024, 1027, 1060, 1093, 1126, 1162, 1195, 1228, 1261, 1294, 1329, 1362, 1395, 1488, 1521, 1569, 
        1602, 1635, 1668, 1701, 1734, 1774, 1808, 1869, 1920, 1953, 2308, 2341, 2384, 2437, 2470, 2524, 
        2565, 2598, 2649, 2693, 2726, 2768, 2821, 2854, 2908, 2947, 2980, 3047, 3080, 3114, 3168, 3205, 
        3238, 3294, 3333, 3366, 3424, 3461, 3494, 3585, 3618, 3651, 3713, 3746, 3779, 3840, 3873, 3906, 
        3939, 3976, 4096, 4129, 4162, 4256, 4289, 4322, 4355, 4388, 4421, 4454, 4487, 4520, 4553, 4586, 
        4619, 4652, 4685, 4718, 4752, 4786, 4819, 4852, 4885, 4918, 4951, 5024, 5057, 5090, 5123, 5156, 
        5189, 5222, 5255, 5288, 5321, 5354, 5387, 5420, 5453, 5486, 5519, 5552, 5585, 5618, 5651, 5684, 
        5717, 5750, 5783, 5816, 5849, 5888, 5921, 5954, 5987, 6020, 6053, 6103, 6158, 6191, 6224, 6257, 
        6290, 6400, 6470, 6503, 7424, 7457, 7490, 7523, 7680, 7713, 7746, 7779, 7812, 7845, 7878, 7911, 
        7944, 7977, 8010, 8043, 8076, 8109, 8144, 8178, 8232, 8287, 8450, 8484, 8517, 12288, 12337, 12370, 
        12403, 12436, 12469, 12502, 12535, 12568, 12601, 12634, 12667, 12704, 12784, 13312, 13345, 13378, 13411, 13444, 
        13477, 13510, 13543, 13576, 13609, 13642, 13675, 13708, 13741, 13774, 13807, 13840, 13873, 13906, 13939, 13972, 
        14005, 14038, 14071, 14104, 14137, 14170, 14203, 14236, 14269, 14302, 14335, 14368, 14401, 14434, 14467, 14500, 
        14533, 14566, 14599, 14632, 14665, 14698, 14731, 14764, 14797, 14830, 14863, 14896, 14929, 14962, 14995, 15028, 
        15061, 15094, 15127, 15160, 15193, 15226, 15259, 15292, 15325, 15358, 15391, 15424, 15457, 15490, 15523, 15556, 
        15589, 15622, 15655, 15688, 15721, 15754, 15787, 15820, 15853, 15886, 15919, 15952, 15985, 16018, 16051, 16084, 
        16117, 16150, 16183, 16216, 16249, 16282, 16315, 16348, 16381, 16414, 16447, 16480, 16513, 16546, 16579, 16612, 
        16645, 16678, 16711, 16744, 16777, 16810, 16843, 16876, 16909, 16942, 16975, 17008, 17041, 17074, 17107, 17140, 
        17173, 17206, 17239, 17272, 17305, 17338, 17371, 17404, 17437, 17470, 17503, 17536, 17569, 17602, 17635, 17668, 
        17701, 17734, 17767, 17800, 17833, 17866, 17899, 17932, 17965, 17998, 18031, 18064, 18097, 18130, 18163, 18196, 
        18229, 18262, 18295, 18328, 18361, 18394, 18427, 18460, 18493, 18526, 18559, 18592, 18625, 18658, 18691, 18724, 
        18757, 18790, 18823, 18856, 18889, 18922, 18955, 18988, 19021, 19054, 19087, 19120, 19153, 19186, 19219, 19252, 
        19285, 19318, 19351, 19384, 19417, 19450, 19483, 19516, 19549, 19582, 19615, 19648, 19681, 19714, 19747, 19780, 
        19813, 19846, 19879, 19968, 20001, 20034, 20067, 20100, 20133, 20166, 20199, 20232, 20265, 20298, 20331, 20364, 
        20397, 20430, 20463, 20496, 20529, 20562, 20595, 20628, 20661, 20694, 20727, 20760, 20793, 20826, 20859, 20892, 
        20925, 20958, 20991, 21024, 21057, 21090, 21123, 21156, 21189, 21222, 21255, 21288, 21321, 21354, 21387, 21420, 
        21453, 21486, 21519, 21552, 21585, 21618, 21651, 21684, 21717, 21750, 21783, 21816, 21849, 21882, 21915, 21948, 
        21981, 22014, 22047, 22080, 22113, 22146, 22179, 22212, 22245, 22278, 22311, 22344, 22377, 22410, 22443, 22476, 
        22509, 22542, 22575, 22608, 22641, 22674, 22707, 22740, 22773, 22806, 22839, 22872, 22905, 22938, 22971, 23004, 
        23037, 23070, 23103, 23136, 23169, 23202, 23235, 23268, 23301, 23334, 23367, 23400, 23433, 23466, 23499, 23532, 
        23565, 23598, 23631, 23664, 23697, 23730, 23763, 23796, 23829, 23862, 23895, 23928, 23961, 23994, 24027, 24060, 
        24093, 24126, 24159, 24192, 24225, 24258, 24291, 24324, 24357, 24390, 24423, 24456, 24489, 24522, 24555, 24588, 
        24621, 24654, 24687, 24720, 24753, 24786, 24819, 24852, 24885, 24918, 24951, 24984, 25017, 25050, 25083, 25116, 
        25149, 25182, 25215, 25248, 25281, 25314, 25347, 25380, 25413, 25446, 25479, 25512, 25545, 25578, 25611, 25644, 
        25677, 25710, 25743, 25776, 25809, 25842, 25875, 25908, 25941, 25974, 26007, 26040, 26073, 26106, 26139, 26172, 
        26205, 26238, 26271, 26304, 26337, 26370, 26403, 26436, 26469, 26502, 26535, 26568, 26601, 26634, 26667, 26700, 
        26733, 26766, 26799, 26832, 26865, 26898, 26931, 26964, 26997, 27030, 27063, 27096, 27129, 27162, 27195, 27228, 
        27261, 27294, 27327, 27360, 27393, 27426, 27459, 27492, 27525, 27558, 27591, 27624, 27657, 27690, 27723, 27756, 
        27789, 27822, 27855, 27888, 27921, 27954, 27987, 28020, 28053, 28086, 28119, 28152, 28185, 28218, 28251, 28284, 
        28317, 28350, 28383, 28416, 28449, 28482, 28515, 28548, 28581, 28614, 28647, 28680, 28713, 28746, 28779, 28812, 
        28845, 28878, 28911, 28944, 28977, 29010, 29043, 29076, 29109, 29142, 29175, 29208, 29241, 29274, 29307, 29340, 
        29373, 29406, 29439, 29472, 29505, 29538, 29571, 29604, 29637, 29670, 29703, 29736, 29769, 29802, 29835, 29868, 
        29901, 29934, 29967, 30000, 30033, 30066, 30099, 30132, 30165, 30198, 30231, 30264, 30297, 30330, 30363, 30396, 
        30429, 30462, 30495, 30528, 30561, 30594, 30627, 30660, 30693, 30726, 30759, 30792, 30825, 30858, 30891, 30924, 
        30957, 30990, 31023, 31056, 31089, 31122, 31155, 31188, 31221, 31254, 31287, 31320, 31353, 31386, 31419, 31452, 
        31485, 31518, 31551, 31584, 31617, 31650, 31683, 31716, 31749, 31782, 31815, 31848, 31881, 31914, 31947, 31980, 
        32013, 32046, 32079, 32112, 32145, 32178, 32211, 32244, 32277, 32310, 32343, 32376, 32409, 32442, 32475, 32508, 
        32541, 32574, 32607, 32640, 32673, 32706, 32739
    };
    static final char[] chars = new char[codes.length]; // Is filled with contents of codes.

//    {
//        System.out.println("TEST");
////        System.arraycopy(codes, 0, chars, 0, codes.length); // Na super! Der Compiler nimmt's, aber Runtime gibt's ArrayStoreException.
//        for (int i = 0; i < codes.length; i++) chars[i] = (char) codes[i];
//    }



/*
US-ASCII
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, 63, 63, 63, 63, 63, 63, 
 */

/*
UTF-8
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, -62, -86, -62, -75, -62, -70, 
-61, -128, -61, -125, -61, -122, -61, -119, -61, -116, -61, -113, -61, -110, -61, -107, 
-61, -104, -61, -101, -61, -98, -61, -95, -61, -92, -61, -89, -61, -86, -61, -83, 
-61, -80, -61, -77, -61, -74, -61, -71, -61, -68, -61, -65, -60, -126, -60, -123, 
-60, -120, -60, -117, -60, -114, -60, -111, -60, -108, -60, -105, -60, -102, -60, -99, 
-60, -96, -60, -93, -60, -90, -60, -87, -60, -84, -60, -81, -60, -78, -60, -75, 
-60, -72, -60, -69, -60, -66, -59, -127, -59, -124, -59, -121, -59, -118, -59, -115, 
-59, -112, -59, -109, -59, -106, -59, -103, -59, -100, -59, -97, -59, -94, -59, -91, 
-59, -88, -59, -85, -59, -82, -59, -79, -59, -76, -59, -73, -59, -70, -59, -67, 
-58, -128, -58, -125, -58, -122, -58, -119, -58, -116, -58, -113, -58, -110, -58, -107, 
-58, -104, -58, -101, -58, -98, -58, -95, -58, -92, -58, -89, -58, -86, -58, -83, 
-58, -80, -58, -77, -58, -74, -58, -71, -58, -68, -58, -65, -57, -126, -57, -123, 
-57, -120, -57, -117, -57, -114, -57, -111, -57, -108, -57, -105, -57, -102, -57, -99, 
-57, -96, -57, -93, -57, -90, -57, -87, -57, -84, -57, -81, -57, -78, -57, -75, 
-57, -72, -57, -69, -57, -66, -56, -127, -56, -124, -56, -121, -56, -118, -56, -115, 
-56, -112, -56, -109, -56, -106, -56, -103, -56, -100, -56, -97, -56, -94, -56, -91, 
-56, -88, -56, -85, -56, -82, -56, -79, -56, -76, -55, -112, -55, -109, -55, -106, 
-55, -103, -55, -100, -55, -97, -55, -94, -55, -91, -55, -88, -55, -85, -55, -82, 
-55, -79, -55, -76, -55, -73, -55, -70, -55, -67, -54, -128, -54, -125, -54, -122, 
-54, -119, -54, -116, -54, -113, -54, -110, -54, -107, -54, -104, -54, -101, -54, -98, 
-54, -95, -54, -92, -54, -89, -54, -86, -54, -83, -54, -80, -54, -77, -54, -74, 
-54, -71, -54, -68, -54, -65, -53, -122, -53, -119, -53, -116, -53, -113, -53, -96, 
-53, -93, -53, -82, -51, -70, -50, -122, -50, -119, -50, -116, -50, -113, -50, -110, 
-50, -107, -50, -104, -50, -101, -50, -98, -50, -95, -50, -92, -50, -89, -50, -86, 
-50, -83, -50, -80, -50, -77, -50, -74, -50, -71, -50, -68, -50, -65, -49, -126, 
-49, -123, -49, -120, -49, -117, -49, -114, -49, -111, -49, -108, -49, -105, -49, -102, 
-49, -99, -49, -96, -49, -93, -49, -90, -49, -87, -49, -84, -49, -81, -49, -78, 
-49, -75, -49, -72, -49, -69, -48, -128, -48, -125, -48, -92, -47, -123, -47, -90, 
-46, -118, -46, -85, -45, -116, -45, -83, -44, -114, -44, -79, -43, -110, -43, -77, 
-41, -112, -41, -79, -40, -95, -39, -126, -39, -93, -38, -124, -38, -91, -37, -122, 
-37, -82, -36, -112, -35, -115, -34, -128, -34, -95, -32, -92, -124, -32, -92, -91, 
-32, -91, -112, -32, -90, -123, -32, -90, -90, -32, -89, -100, -32, -88, -123, -32, 
-88, -90, -32, -87, -103, -32, -86, -123, -32, -86, -90, -32, -85, -112, -32, -84, 
-123, -32, -84, -90, -32, -83, -100, -32, -82, -125, -32, -82, -92, -32, -81, -89, 
-32, -80, -120, -32, -80, -86, -32, -79, -96, -32, -78, -123, -32, -78, -90, -32, 
-77, -98, -32, -76, -123, -32, -76, -90, -32, -75, -96, -32, -74, -123, -32, -74, 
-90, -32, -72, -127, -32, -72, -94, -32, -71, -125, -32, -70, -127, -32, -70, -94, 
-32, -69, -125, -32, -68, -128, -32, -68, -95, -32, -67, -126, -32, -67, -93, -32, 
-66, -120, -31, -128, -128, -31, -128, -95, -31, -127, -126, -31, -126, -96, -31, -125, 
-127, -31, -125, -94, -31, -124, -125, -31, -124, -92, -31, -123, -123, -31, -123, -90, 
-31, -122, -121, -31, -122, -88, -31, -121, -119, -31, -121, -86, -31, -120, -117, -31, 
-120, -84, -31, -119, -115, -31, -119, -82, -31, -118, -112, -31, -118, -78, -31, -117, 
-109, -31, -117, -76, -31, -116, -107, -31, -116, -74, -31, -115, -105, -31, -114, -96, 
-31, -113, -127, -31, -113, -94, -31, -112, -125, -31, -112, -92, -31, -111, -123, -31, 
-111, -90, -31, -110, -121, -31, -110, -88, -31, -109, -119, -31, -109, -86, -31, -108, 
-117, -31, -108, -84, -31, -107, -115, -31, -107, -82, -31, -106, -113, -31, -106, -80, 
-31, -105, -111, -31, -105, -78, -31, -104, -109, -31, -104, -76, -31, -103, -107, -31, 
-103, -74, -31, -102, -105, -31, -102, -72, -31, -101, -103, -31, -100, -128, -31, -100, 
-95, -31, -99, -126, -31, -99, -93, -31, -98, -124, -31, -98, -91, -31, -97, -105, 
-31, -96, -114, -31, -96, -81, -31, -95, -112, -31, -95, -79, -31, -94, -110, -31, 
-92, -128, -31, -91, -122, -31, -91, -89, -31, -76, -128, -31, -76, -95, -31, -75, 
-126, -31, -75, -93, -31, -72, -128, -31, -72, -95, -31, -71, -126, -31, -71, -93, 
-31, -70, -124, -31, -70, -91, -31, -69, -122, -31, -69, -89, -31, -68, -120, -31, 
-68, -87, -31, -67, -118, -31, -67, -85, -31, -66, -116, -31, -66, -83, -31, -65, 
-112, -31, -65, -78, -30, -128, -88, -30, -127, -97, -30, -124, -126, -30, -124, -92, 
-30, -123, -123, -29, -128, -128, -29, -128, -79, -29, -127, -110, -29, -127, -77, -29, 
-126, -108, -29, -126, -75, -29, -125, -106, -29, -125, -73, -29, -124, -104, -29, -124, 
-71, -29, -123, -102, -29, -123, -69, -29, -122, -96, -29, -121, -80, -29, -112, -128, 
-29, -112, -95, -29, -111, -126, -29, -111, -93, -29, -110, -124, -29, -110, -91, -29, 
-109, -122, -29, -109, -89, -29, -108, -120, -29, -108, -87, -29, -107, -118, -29, -107, 
-85, -29, -106, -116, -29, -106, -83, -29, -105, -114, -29, -105, -81, -29, -104, -112, 
-29, -104, -79, -29, -103, -110, -29, -103, -77, -29, -102, -108, -29, -102, -75, -29, 
-101, -106, -29, -101, -73, -29, -100, -104, -29, -100, -71, -29, -99, -102, -29, -99, 
-69, -29, -98, -100, -29, -98, -67, -29, -97, -98, -29, -97, -65, -29, -96, -96, 
-29, -95, -127, -29, -95, -94, -29, -94, -125, -29, -94, -92, -29, -93, -123, -29, 
-93, -90, -29, -92, -121, -29, -92, -88, -29, -91, -119, -29, -91, -86, -29, -90, 
-117, -29, -90, -84, -29, -89, -115, -29, -89, -82, -29, -88, -113, -29, -88, -80, 
-29, -87, -111, -29, -87, -78, -29, -86, -109, -29, -86, -76, -29, -85, -107, -29, 
-85, -74, -29, -84, -105, -29, -84, -72, -29, -83, -103, -29, -83, -70, -29, -82, 
-101, -29, -82, -68, -29, -81, -99, -29, -81, -66, -29, -80, -97, -29, -79, -128, 
-29, -79, -95, -29, -78, -126, -29, -78, -93, -29, -77, -124, -29, -77, -91, -29, 
-76, -122, -29, -76, -89, -29, -75, -120, -29, -75, -87, -29, -74, -118, -29, -74, 
-85, -29, -73, -116, -29, -73, -83, -29, -72, -114, -29, -72, -81, -29, -71, -112, 
-29, -71, -79, -29, -70, -110, -29, -70, -77, -29, -69, -108, -29, -69, -75, -29, 
-68, -106, -29, -68, -73, -29, -67, -104, -29, -67, -71, -29, -66, -102, -29, -66, 
-69, -29, -65, -100, -29, -65, -67, -28, -128, -98, -28, -128, -65, -28, -127, -96, 
-28, -126, -127, -28, -126, -94, -28, -125, -125, -28, -125, -92, -28, -124, -123, -28, 
-124, -90, -28, -123, -121, -28, -123, -88, -28, -122, -119, -28, -122, -86, -28, -121, 
-117, -28, -121, -84, -28, -120, -115, -28, -120, -82, -28, -119, -113, -28, -119, -80, 
-28, -118, -111, -28, -118, -78, -28, -117, -109, -28, -117, -76, -28, -116, -107, -28, 
-116, -74, -28, -115, -105, -28, -115, -72, -28, -114, -103, -28, -114, -70, -28, -113, 
-101, -28, -113, -68, -28, -112, -99, -28, -112, -66, -28, -111, -97, -28, -110, -128, 
-28, -110, -95, -28, -109, -126, -28, -109, -93, -28, -108, -124, -28, -108, -91, -28, 
-107, -122, -28, -107, -89, -28, -106, -120, -28, -106, -87, -28, -105, -118, -28, -105, 
-85, -28, -104, -116, -28, -104, -83, -28, -103, -114, -28, -103, -81, -28, -102, -112, 
-28, -102, -79, -28, -101, -110, -28, -101, -77, -28, -100, -108, -28, -100, -75, -28, 
-99, -106, -28, -99, -73, -28, -98, -104, -28, -98, -71, -28, -97, -102, -28, -97, 
-69, -28, -96, -100, -28, -96, -67, -28, -95, -98, -28, -95, -65, -28, -94, -96, 
-28, -93, -127, -28, -93, -94, -28, -92, -125, -28, -92, -92, -28, -91, -123, -28, 
-91, -90, -28, -90, -121, -28, -90, -88, -28, -89, -119, -28, -89, -86, -28, -88, 
-117, -28, -88, -84, -28, -87, -115, -28, -87, -82, -28, -86, -113, -28, -86, -80, 
-28, -85, -111, -28, -85, -78, -28, -84, -109, -28, -84, -76, -28, -83, -107, -28, 
-83, -74, -28, -82, -105, -28, -82, -72, -28, -81, -103, -28, -81, -70, -28, -80, 
-101, -28, -80, -68, -28, -79, -99, -28, -79, -66, -28, -78, -97, -28, -77, -128, 
-28, -77, -95, -28, -76, -126, -28, -76, -93, -28, -75, -124, -28, -75, -91, -28, 
-74, -122, -28, -74, -89, -28, -72, -128, -28, -72, -95, -28, -71, -126, -28, -71, 
-93, -28, -70, -124, -28, -70, -91, -28, -69, -122, -28, -69, -89, -28, -68, -120, 
-28, -68, -87, -28, -67, -118, -28, -67, -85, -28, -66, -116, -28, -66, -83, -28, 
-65, -114, -28, -65, -81, -27, -128, -112, -27, -128, -79, -27, -127, -110, -27, -127, 
-77, -27, -126, -108, -27, -126, -75, -27, -125, -106, -27, -125, -73, -27, -124, -104, 
-27, -124, -71, -27, -123, -102, -27, -123, -69, -27, -122, -100, -27, -122, -67, -27, 
-121, -98, -27, -121, -65, -27, -120, -96, -27, -119, -127, -27, -119, -94, -27, -118, 
-125, -27, -118, -92, -27, -117, -123, -27, -117, -90, -27, -116, -121, -27, -116, -88, 
-27, -115, -119, -27, -115, -86, -27, -114, -117, -27, -114, -84, -27, -113, -115, -27, 
-113, -82, -27, -112, -113, -27, -112, -80, -27, -111, -111, -27, -111, -78, -27, -110, 
-109, -27, -110, -76, -27, -109, -107, -27, -109, -74, -27, -108, -105, -27, -108, -72, 
-27, -107, -103, -27, -107, -70, -27, -106, -101, -27, -106, -68, -27, -105, -99, -27, 
-105, -66, -27, -104, -97, -27, -103, -128, -27, -103, -95, -27, -102, -126, -27, -102, 
-93, -27, -101, -124, -27, -101, -91, -27, -100, -122, -27, -100, -89, -27, -99, -120, 
-27, -99, -87, -27, -98, -118, -27, -98, -85, -27, -97, -116, -27, -97, -83, -27, 
-96, -114, -27, -96, -81, -27, -95, -112, -27, -95, -79, -27, -94, -110, -27, -94, 
-77, -27, -93, -108, -27, -93, -75, -27, -92, -106, -27, -92, -73, -27, -91, -104, 
-27, -91, -71, -27, -90, -102, -27, -90, -69, -27, -89, -100, -27, -89, -67, -27, 
-88, -98, -27, -88, -65, -27, -87, -96, -27, -86, -127, -27, -86, -94, -27, -85, 
-125, -27, -85, -92, -27, -84, -123, -27, -84, -90, -27, -83, -121, -27, -83, -88, 
-27, -82, -119, -27, -82, -86, -27, -81, -117, -27, -81, -84, -27, -80, -115, -27, 
-80, -82, -27, -79, -113, -27, -79, -80, -27, -78, -111, -27, -78, -78, -27, -77, 
-109, -27, -77, -76, -27, -76, -107, -27, -76, -74, -27, -75, -105, -27, -75, -72, 
-27, -74, -103, -27, -74, -70, -27, -73, -101, -27, -73, -68, -27, -72, -99, -27, 
-72, -66, -27, -71, -97, -27, -70, -128, -27, -70, -95, -27, -69, -126, -27, -69, 
-93, -27, -68, -124, -27, -68, -91, -27, -67, -122, -27, -67, -89, -27, -66, -120, 
-27, -66, -87, -27, -65, -118, -27, -65, -85, -26, -128, -116, -26, -128, -83, -26, 
-127, -114, -26, -127, -81, -26, -126, -112, -26, -126, -79, -26, -125, -110, -26, -125, 
-77, -26, -124, -108, -26, -124, -75, -26, -123, -106, -26, -123, -73, -26, -122, -104, 
-26, -122, -71, -26, -121, -102, -26, -121, -69, -26, -120, -100, -26, -120, -67, -26, 
-119, -98, -26, -119, -65, -26, -118, -96, -26, -117, -127, -26, -117, -94, -26, -116, 
-125, -26, -116, -92, -26, -115, -123, -26, -115, -90, -26, -114, -121, -26, -114, -88, 
-26, -113, -119, -26, -113, -86, -26, -112, -117, -26, -112, -84, -26, -111, -115, -26, 
-111, -82, -26, -110, -113, -26, -110, -80, -26, -109, -111, -26, -109, -78, -26, -108, 
-109, -26, -108, -76, -26, -107, -107, -26, -107, -74, -26, -106, -105, -26, -106, -72, 
-26, -105, -103, -26, -105, -70, -26, -104, -101, -26, -104, -68, -26, -103, -99, -26, 
-103, -66, -26, -102, -97, -26, -101, -128, -26, -101, -95, -26, -100, -126, -26, -100, 
-93, -26, -99, -124, -26, -99, -91, -26, -98, -122, -26, -98, -89, -26, -97, -120, 
-26, -97, -87, -26, -96, -118, -26, -96, -85, -26, -95, -116, -26, -95, -83, -26, 
-94, -114, -26, -94, -81, -26, -93, -112, -26, -93, -79, -26, -92, -110, -26, -92, 
-77, -26, -91, -108, -26, -91, -75, -26, -90, -106, -26, -90, -73, -26, -89, -104, 
-26, -89, -71, -26, -88, -102, -26, -88, -69, -26, -87, -100, -26, -87, -67, -26, 
-86, -98, -26, -86, -65, -26, -85, -96, -26, -84, -127, -26, -84, -94, -26, -83, 
-125, -26, -83, -92, -26, -82, -123, -26, -82, -90, -26, -81, -121, -26, -81, -88, 
-26, -80, -119, -26, -80, -86, -26, -79, -117, -26, -79, -84, -26, -78, -115, -26, 
-78, -82, -26, -77, -113, -26, -77, -80, -26, -76, -111, -26, -76, -78, -26, -75, 
-109, -26, -75, -76, -26, -74, -107, -26, -74, -74, -26, -73, -105, -26, -73, -72, 
-26, -72, -103, -26, -72, -70, -26, -71, -101, -26, -71, -68, -26, -70, -99, -26, 
-70, -66, -26, -69, -97, -26, -68, -128, -26, -68, -95, -26, -67, -126, -26, -67, 
-93, -26, -66, -124, -26, -66, -91, -26, -65, -122, -26, -65, -89, -25, -128, -120, 
-25, -128, -87, -25, -127, -118, -25, -127, -85, -25, -126, -116, -25, -126, -83, -25, 
-125, -114, -25, -125, -81, -25, -124, -112, -25, -124, -79, -25, -123, -110, -25, -123, 
-77, -25, -122, -108, -25, -122, -75, -25, -121, -106, -25, -121, -73, -25, -120, -104, 
-25, -120, -71, -25, -119, -102, -25, -119, -69, -25, -118, -100, -25, -118, -67, -25, 
-117, -98, -25, -117, -65, -25, -116, -96, -25, -115, -127, -25, -115, -94, -25, -114, 
-125, -25, -114, -92, -25, -113, -123, -25, -113, -90, -25, -112, -121, -25, -112, -88, 
-25, -111, -119, -25, -111, -86, -25, -110, -117, -25, -110, -84, -25, -109, -115, -25, 
-109, -82, -25, -108, -113, -25, -108, -80, -25, -107, -111, -25, -107, -78, -25, -106, 
-109, -25, -106, -76, -25, -105, -107, -25, -105, -74, -25, -104, -105, -25, -104, -72, 
-25, -103, -103, -25, -103, -70, -25, -102, -101, -25, -102, -68, -25, -101, -99, -25, 
-101, -66, -25, -100, -97, -25, -99, -128, -25, -99, -95, -25, -98, -126, -25, -98, 
-93, -25, -97, -124, -25, -97, -91, -25, -96, -122, -25, -96, -89, -25, -95, -120, 
-25, -95, -87, -25, -94, -118, -25, -94, -85, -25, -93, -116, -25, -93, -83, -25, 
-92, -114, -25, -92, -81, -25, -91, -112, -25, -91, -79, -25, -90, -110, -25, -90, 
-77, -25, -89, -108, -25, -89, -75, -25, -88, -106, -25, -88, -73, -25, -87, -104, 
-25, -87, -71, -25, -86, -102, -25, -86, -69, -25, -85, -100, -25, -85, -67, -25, 
-84, -98, -25, -84, -65, -25, -83, -96, -25, -82, -127, -25, -82, -94, -25, -81, 
-125, -25, -81, -92, -25, -80, -123, -25, -80, -90, -25, -79, -121, -25, -79, -88, 
-25, -78, -119, -25, -78, -86, -25, -77, -117, -25, -77, -84, -25, -76, -115, -25, 
-76, -82, -25, -75, -113, -25, -75, -80, -25, -74, -111, -25, -74, -78, -25, -73, 
-109, -25, -73, -76, -25, -72, -107, -25, -72, -74, -25, -71, -105, -25, -71, -72, 
-25, -70, -103, -25, -70, -70, -25, -69, -101, -25, -69, -68, -25, -68, -99, -25, 
-68, -66, -25, -67, -97, -25, -66, -128, -25, -66, -95, -25, -65, -126, -25, -65, 
-93, 
 */

/*
UTF-16
-2, -1, 0, 9, 0, 12, 0, 28, 0, 31, 0, 48, 0, 51, 0, 54, 
0, 57, 0, 65, 0, 68, 0, 71, 0, 74, 0, 77, 0, 80, 0, 83, 
0, 86, 0, 89, 0, 97, 0, 100, 0, 103, 0, 106, 0, 109, 0, 112, 
0, 115, 0, 118, 0, 121, 0, -86, 0, -75, 0, -70, 0, -64, 0, -61, 
0, -58, 0, -55, 0, -52, 0, -49, 0, -46, 0, -43, 0, -40, 0, -37, 
0, -34, 0, -31, 0, -28, 0, -25, 0, -22, 0, -19, 0, -16, 0, -13, 
0, -10, 0, -7, 0, -4, 0, -1, 1, 2, 1, 5, 1, 8, 1, 11, 
1, 14, 1, 17, 1, 20, 1, 23, 1, 26, 1, 29, 1, 32, 1, 35, 
1, 38, 1, 41, 1, 44, 1, 47, 1, 50, 1, 53, 1, 56, 1, 59, 
1, 62, 1, 65, 1, 68, 1, 71, 1, 74, 1, 77, 1, 80, 1, 83, 
1, 86, 1, 89, 1, 92, 1, 95, 1, 98, 1, 101, 1, 104, 1, 107, 
1, 110, 1, 113, 1, 116, 1, 119, 1, 122, 1, 125, 1, -128, 1, -125, 
1, -122, 1, -119, 1, -116, 1, -113, 1, -110, 1, -107, 1, -104, 1, -101, 
1, -98, 1, -95, 1, -92, 1, -89, 1, -86, 1, -83, 1, -80, 1, -77, 
1, -74, 1, -71, 1, -68, 1, -65, 1, -62, 1, -59, 1, -56, 1, -53, 
1, -50, 1, -47, 1, -44, 1, -41, 1, -38, 1, -35, 1, -32, 1, -29, 
1, -26, 1, -23, 1, -20, 1, -17, 1, -14, 1, -11, 1, -8, 1, -5, 
1, -2, 2, 1, 2, 4, 2, 7, 2, 10, 2, 13, 2, 16, 2, 19, 
2, 22, 2, 25, 2, 28, 2, 31, 2, 34, 2, 37, 2, 40, 2, 43, 
2, 46, 2, 49, 2, 52, 2, 80, 2, 83, 2, 86, 2, 89, 2, 92, 
2, 95, 2, 98, 2, 101, 2, 104, 2, 107, 2, 110, 2, 113, 2, 116, 
2, 119, 2, 122, 2, 125, 2, -128, 2, -125, 2, -122, 2, -119, 2, -116, 
2, -113, 2, -110, 2, -107, 2, -104, 2, -101, 2, -98, 2, -95, 2, -92, 
2, -89, 2, -86, 2, -83, 2, -80, 2, -77, 2, -74, 2, -71, 2, -68, 
2, -65, 2, -58, 2, -55, 2, -52, 2, -49, 2, -32, 2, -29, 2, -18, 
3, 122, 3, -122, 3, -119, 3, -116, 3, -113, 3, -110, 3, -107, 3, -104, 
3, -101, 3, -98, 3, -95, 3, -92, 3, -89, 3, -86, 3, -83, 3, -80, 
3, -77, 3, -74, 3, -71, 3, -68, 3, -65, 3, -62, 3, -59, 3, -56, 
3, -53, 3, -50, 3, -47, 3, -44, 3, -41, 3, -38, 3, -35, 3, -32, 
3, -29, 3, -26, 3, -23, 3, -20, 3, -17, 3, -14, 3, -11, 3, -8, 
3, -5, 4, 0, 4, 3, 4, 36, 4, 69, 4, 102, 4, -118, 4, -85, 
4, -52, 4, -19, 5, 14, 5, 49, 5, 82, 5, 115, 5, -48, 5, -15, 
6, 33, 6, 66, 6, 99, 6, -124, 6, -91, 6, -58, 6, -18, 7, 16, 
7, 77, 7, -128, 7, -95, 9, 4, 9, 37, 9, 80, 9, -123, 9, -90, 
9, -36, 10, 5, 10, 38, 10, 89, 10, -123, 10, -90, 10, -48, 11, 5, 
11, 38, 11, 92, 11, -125, 11, -92, 11, -25, 12, 8, 12, 42, 12, 96, 
12, -123, 12, -90, 12, -34, 13, 5, 13, 38, 13, 96, 13, -123, 13, -90, 
14, 1, 14, 34, 14, 67, 14, -127, 14, -94, 14, -61, 15, 0, 15, 33, 
15, 66, 15, 99, 15, -120, 16, 0, 16, 33, 16, 66, 16, -96, 16, -63, 
16, -30, 17, 3, 17, 36, 17, 69, 17, 102, 17, -121, 17, -88, 17, -55, 
17, -22, 18, 11, 18, 44, 18, 77, 18, 110, 18, -112, 18, -78, 18, -45, 
18, -12, 19, 21, 19, 54, 19, 87, 19, -96, 19, -63, 19, -30, 20, 3, 
20, 36, 20, 69, 20, 102, 20, -121, 20, -88, 20, -55, 20, -22, 21, 11, 
21, 44, 21, 77, 21, 110, 21, -113, 21, -80, 21, -47, 21, -14, 22, 19, 
22, 52, 22, 85, 22, 118, 22, -105, 22, -72, 22, -39, 23, 0, 23, 33, 
23, 66, 23, 99, 23, -124, 23, -91, 23, -41, 24, 14, 24, 47, 24, 80, 
24, 113, 24, -110, 25, 0, 25, 70, 25, 103, 29, 0, 29, 33, 29, 66, 
29, 99, 30, 0, 30, 33, 30, 66, 30, 99, 30, -124, 30, -91, 30, -58, 
30, -25, 31, 8, 31, 41, 31, 74, 31, 107, 31, -116, 31, -83, 31, -48, 
31, -14, 32, 40, 32, 95, 33, 2, 33, 36, 33, 69, 48, 0, 48, 49, 
48, 82, 48, 115, 48, -108, 48, -75, 48, -42, 48, -9, 49, 24, 49, 57, 
49, 90, 49, 123, 49, -96, 49, -16, 52, 0, 52, 33, 52, 66, 52, 99, 
52, -124, 52, -91, 52, -58, 52, -25, 53, 8, 53, 41, 53, 74, 53, 107, 
53, -116, 53, -83, 53, -50, 53, -17, 54, 16, 54, 49, 54, 82, 54, 115, 
54, -108, 54, -75, 54, -42, 54, -9, 55, 24, 55, 57, 55, 90, 55, 123, 
55, -100, 55, -67, 55, -34, 55, -1, 56, 32, 56, 65, 56, 98, 56, -125, 
56, -92, 56, -59, 56, -26, 57, 7, 57, 40, 57, 73, 57, 106, 57, -117, 
57, -84, 57, -51, 57, -18, 58, 15, 58, 48, 58, 81, 58, 114, 58, -109, 
58, -76, 58, -43, 58, -10, 59, 23, 59, 56, 59, 89, 59, 122, 59, -101, 
59, -68, 59, -35, 59, -2, 60, 31, 60, 64, 60, 97, 60, -126, 60, -93, 
60, -60, 60, -27, 61, 6, 61, 39, 61, 72, 61, 105, 61, -118, 61, -85, 
61, -52, 61, -19, 62, 14, 62, 47, 62, 80, 62, 113, 62, -110, 62, -77, 
62, -44, 62, -11, 63, 22, 63, 55, 63, 88, 63, 121, 63, -102, 63, -69, 
63, -36, 63, -3, 64, 30, 64, 63, 64, 96, 64, -127, 64, -94, 64, -61, 
64, -28, 65, 5, 65, 38, 65, 71, 65, 104, 65, -119, 65, -86, 65, -53, 
65, -20, 66, 13, 66, 46, 66, 79, 66, 112, 66, -111, 66, -78, 66, -45, 
66, -12, 67, 21, 67, 54, 67, 87, 67, 120, 67, -103, 67, -70, 67, -37, 
67, -4, 68, 29, 68, 62, 68, 95, 68, -128, 68, -95, 68, -62, 68, -29, 
69, 4, 69, 37, 69, 70, 69, 103, 69, -120, 69, -87, 69, -54, 69, -21, 
70, 12, 70, 45, 70, 78, 70, 111, 70, -112, 70, -79, 70, -46, 70, -13, 
71, 20, 71, 53, 71, 86, 71, 119, 71, -104, 71, -71, 71, -38, 71, -5, 
72, 28, 72, 61, 72, 94, 72, 127, 72, -96, 72, -63, 72, -30, 73, 3, 
73, 36, 73, 69, 73, 102, 73, -121, 73, -88, 73, -55, 73, -22, 74, 11, 
74, 44, 74, 77, 74, 110, 74, -113, 74, -80, 74, -47, 74, -14, 75, 19, 
75, 52, 75, 85, 75, 118, 75, -105, 75, -72, 75, -39, 75, -6, 76, 27, 
76, 60, 76, 93, 76, 126, 76, -97, 76, -64, 76, -31, 77, 2, 77, 35, 
77, 68, 77, 101, 77, -122, 77, -89, 78, 0, 78, 33, 78, 66, 78, 99, 
78, -124, 78, -91, 78, -58, 78, -25, 79, 8, 79, 41, 79, 74, 79, 107, 
79, -116, 79, -83, 79, -50, 79, -17, 80, 16, 80, 49, 80, 82, 80, 115, 
80, -108, 80, -75, 80, -42, 80, -9, 81, 24, 81, 57, 81, 90, 81, 123, 
81, -100, 81, -67, 81, -34, 81, -1, 82, 32, 82, 65, 82, 98, 82, -125, 
82, -92, 82, -59, 82, -26, 83, 7, 83, 40, 83, 73, 83, 106, 83, -117, 
83, -84, 83, -51, 83, -18, 84, 15, 84, 48, 84, 81, 84, 114, 84, -109, 
84, -76, 84, -43, 84, -10, 85, 23, 85, 56, 85, 89, 85, 122, 85, -101, 
85, -68, 85, -35, 85, -2, 86, 31, 86, 64, 86, 97, 86, -126, 86, -93, 
86, -60, 86, -27, 87, 6, 87, 39, 87, 72, 87, 105, 87, -118, 87, -85, 
87, -52, 87, -19, 88, 14, 88, 47, 88, 80, 88, 113, 88, -110, 88, -77, 
88, -44, 88, -11, 89, 22, 89, 55, 89, 88, 89, 121, 89, -102, 89, -69, 
89, -36, 89, -3, 90, 30, 90, 63, 90, 96, 90, -127, 90, -94, 90, -61, 
90, -28, 91, 5, 91, 38, 91, 71, 91, 104, 91, -119, 91, -86, 91, -53, 
91, -20, 92, 13, 92, 46, 92, 79, 92, 112, 92, -111, 92, -78, 92, -45, 
92, -12, 93, 21, 93, 54, 93, 87, 93, 120, 93, -103, 93, -70, 93, -37, 
93, -4, 94, 29, 94, 62, 94, 95, 94, -128, 94, -95, 94, -62, 94, -29, 
95, 4, 95, 37, 95, 70, 95, 103, 95, -120, 95, -87, 95, -54, 95, -21, 
96, 12, 96, 45, 96, 78, 96, 111, 96, -112, 96, -79, 96, -46, 96, -13, 
97, 20, 97, 53, 97, 86, 97, 119, 97, -104, 97, -71, 97, -38, 97, -5, 
98, 28, 98, 61, 98, 94, 98, 127, 98, -96, 98, -63, 98, -30, 99, 3, 
99, 36, 99, 69, 99, 102, 99, -121, 99, -88, 99, -55, 99, -22, 100, 11, 
100, 44, 100, 77, 100, 110, 100, -113, 100, -80, 100, -47, 100, -14, 101, 19, 
101, 52, 101, 85, 101, 118, 101, -105, 101, -72, 101, -39, 101, -6, 102, 27, 
102, 60, 102, 93, 102, 126, 102, -97, 102, -64, 102, -31, 103, 2, 103, 35, 
103, 68, 103, 101, 103, -122, 103, -89, 103, -56, 103, -23, 104, 10, 104, 43, 
104, 76, 104, 109, 104, -114, 104, -81, 104, -48, 104, -15, 105, 18, 105, 51, 
105, 84, 105, 117, 105, -106, 105, -73, 105, -40, 105, -7, 106, 26, 106, 59, 
106, 92, 106, 125, 106, -98, 106, -65, 106, -32, 107, 1, 107, 34, 107, 67, 
107, 100, 107, -123, 107, -90, 107, -57, 107, -24, 108, 9, 108, 42, 108, 75, 
108, 108, 108, -115, 108, -82, 108, -49, 108, -16, 109, 17, 109, 50, 109, 83, 
109, 116, 109, -107, 109, -74, 109, -41, 109, -8, 110, 25, 110, 58, 110, 91, 
110, 124, 110, -99, 110, -66, 110, -33, 111, 0, 111, 33, 111, 66, 111, 99, 
111, -124, 111, -91, 111, -58, 111, -25, 112, 8, 112, 41, 112, 74, 112, 107, 
112, -116, 112, -83, 112, -50, 112, -17, 113, 16, 113, 49, 113, 82, 113, 115, 
113, -108, 113, -75, 113, -42, 113, -9, 114, 24, 114, 57, 114, 90, 114, 123, 
114, -100, 114, -67, 114, -34, 114, -1, 115, 32, 115, 65, 115, 98, 115, -125, 
115, -92, 115, -59, 115, -26, 116, 7, 116, 40, 116, 73, 116, 106, 116, -117, 
116, -84, 116, -51, 116, -18, 117, 15, 117, 48, 117, 81, 117, 114, 117, -109, 
117, -76, 117, -43, 117, -10, 118, 23, 118, 56, 118, 89, 118, 122, 118, -101, 
118, -68, 118, -35, 118, -2, 119, 31, 119, 64, 119, 97, 119, -126, 119, -93, 
119, -60, 119, -27, 120, 6, 120, 39, 120, 72, 120, 105, 120, -118, 120, -85, 
120, -52, 120, -19, 121, 14, 121, 47, 121, 80, 121, 113, 121, -110, 121, -77, 
121, -44, 121, -11, 122, 22, 122, 55, 122, 88, 122, 121, 122, -102, 122, -69, 
122, -36, 122, -3, 123, 30, 123, 63, 123, 96, 123, -127, 123, -94, 123, -61, 
123, -28, 124, 5, 124, 38, 124, 71, 124, 104, 124, -119, 124, -86, 124, -53, 
124, -20, 125, 13, 125, 46, 125, 79, 125, 112, 125, -111, 125, -78, 125, -45, 
125, -12, 126, 21, 126, 54, 126, 87, 126, 120, 126, -103, 126, -70, 126, -37, 
126, -4, 127, 29, 127, 62, 127, 95, 127, -128, 127, -95, 127, -62, 127, -29, 
 */

/*
UTF-16BE
0, 9, 0, 12, 0, 28, 0, 31, 0, 48, 0, 51, 0, 54, 0, 57, 
0, 65, 0, 68, 0, 71, 0, 74, 0, 77, 0, 80, 0, 83, 0, 86, 
0, 89, 0, 97, 0, 100, 0, 103, 0, 106, 0, 109, 0, 112, 0, 115, 
0, 118, 0, 121, 0, -86, 0, -75, 0, -70, 0, -64, 0, -61, 0, -58, 
0, -55, 0, -52, 0, -49, 0, -46, 0, -43, 0, -40, 0, -37, 0, -34, 
0, -31, 0, -28, 0, -25, 0, -22, 0, -19, 0, -16, 0, -13, 0, -10, 
0, -7, 0, -4, 0, -1, 1, 2, 1, 5, 1, 8, 1, 11, 1, 14, 
1, 17, 1, 20, 1, 23, 1, 26, 1, 29, 1, 32, 1, 35, 1, 38, 
1, 41, 1, 44, 1, 47, 1, 50, 1, 53, 1, 56, 1, 59, 1, 62, 
1, 65, 1, 68, 1, 71, 1, 74, 1, 77, 1, 80, 1, 83, 1, 86, 
1, 89, 1, 92, 1, 95, 1, 98, 1, 101, 1, 104, 1, 107, 1, 110, 
1, 113, 1, 116, 1, 119, 1, 122, 1, 125, 1, -128, 1, -125, 1, -122, 
1, -119, 1, -116, 1, -113, 1, -110, 1, -107, 1, -104, 1, -101, 1, -98, 
1, -95, 1, -92, 1, -89, 1, -86, 1, -83, 1, -80, 1, -77, 1, -74, 
1, -71, 1, -68, 1, -65, 1, -62, 1, -59, 1, -56, 1, -53, 1, -50, 
1, -47, 1, -44, 1, -41, 1, -38, 1, -35, 1, -32, 1, -29, 1, -26, 
1, -23, 1, -20, 1, -17, 1, -14, 1, -11, 1, -8, 1, -5, 1, -2, 
2, 1, 2, 4, 2, 7, 2, 10, 2, 13, 2, 16, 2, 19, 2, 22, 
2, 25, 2, 28, 2, 31, 2, 34, 2, 37, 2, 40, 2, 43, 2, 46, 
2, 49, 2, 52, 2, 80, 2, 83, 2, 86, 2, 89, 2, 92, 2, 95, 
2, 98, 2, 101, 2, 104, 2, 107, 2, 110, 2, 113, 2, 116, 2, 119, 
2, 122, 2, 125, 2, -128, 2, -125, 2, -122, 2, -119, 2, -116, 2, -113, 
2, -110, 2, -107, 2, -104, 2, -101, 2, -98, 2, -95, 2, -92, 2, -89, 
2, -86, 2, -83, 2, -80, 2, -77, 2, -74, 2, -71, 2, -68, 2, -65, 
2, -58, 2, -55, 2, -52, 2, -49, 2, -32, 2, -29, 2, -18, 3, 122, 
3, -122, 3, -119, 3, -116, 3, -113, 3, -110, 3, -107, 3, -104, 3, -101, 
3, -98, 3, -95, 3, -92, 3, -89, 3, -86, 3, -83, 3, -80, 3, -77, 
3, -74, 3, -71, 3, -68, 3, -65, 3, -62, 3, -59, 3, -56, 3, -53, 
3, -50, 3, -47, 3, -44, 3, -41, 3, -38, 3, -35, 3, -32, 3, -29, 
3, -26, 3, -23, 3, -20, 3, -17, 3, -14, 3, -11, 3, -8, 3, -5, 
4, 0, 4, 3, 4, 36, 4, 69, 4, 102, 4, -118, 4, -85, 4, -52, 
4, -19, 5, 14, 5, 49, 5, 82, 5, 115, 5, -48, 5, -15, 6, 33, 
6, 66, 6, 99, 6, -124, 6, -91, 6, -58, 6, -18, 7, 16, 7, 77, 
7, -128, 7, -95, 9, 4, 9, 37, 9, 80, 9, -123, 9, -90, 9, -36, 
10, 5, 10, 38, 10, 89, 10, -123, 10, -90, 10, -48, 11, 5, 11, 38, 
11, 92, 11, -125, 11, -92, 11, -25, 12, 8, 12, 42, 12, 96, 12, -123, 
12, -90, 12, -34, 13, 5, 13, 38, 13, 96, 13, -123, 13, -90, 14, 1, 
14, 34, 14, 67, 14, -127, 14, -94, 14, -61, 15, 0, 15, 33, 15, 66, 
15, 99, 15, -120, 16, 0, 16, 33, 16, 66, 16, -96, 16, -63, 16, -30, 
17, 3, 17, 36, 17, 69, 17, 102, 17, -121, 17, -88, 17, -55, 17, -22, 
18, 11, 18, 44, 18, 77, 18, 110, 18, -112, 18, -78, 18, -45, 18, -12, 
19, 21, 19, 54, 19, 87, 19, -96, 19, -63, 19, -30, 20, 3, 20, 36, 
20, 69, 20, 102, 20, -121, 20, -88, 20, -55, 20, -22, 21, 11, 21, 44, 
21, 77, 21, 110, 21, -113, 21, -80, 21, -47, 21, -14, 22, 19, 22, 52, 
22, 85, 22, 118, 22, -105, 22, -72, 22, -39, 23, 0, 23, 33, 23, 66, 
23, 99, 23, -124, 23, -91, 23, -41, 24, 14, 24, 47, 24, 80, 24, 113, 
24, -110, 25, 0, 25, 70, 25, 103, 29, 0, 29, 33, 29, 66, 29, 99, 
30, 0, 30, 33, 30, 66, 30, 99, 30, -124, 30, -91, 30, -58, 30, -25, 
31, 8, 31, 41, 31, 74, 31, 107, 31, -116, 31, -83, 31, -48, 31, -14, 
32, 40, 32, 95, 33, 2, 33, 36, 33, 69, 48, 0, 48, 49, 48, 82, 
48, 115, 48, -108, 48, -75, 48, -42, 48, -9, 49, 24, 49, 57, 49, 90, 
49, 123, 49, -96, 49, -16, 52, 0, 52, 33, 52, 66, 52, 99, 52, -124, 
52, -91, 52, -58, 52, -25, 53, 8, 53, 41, 53, 74, 53, 107, 53, -116, 
53, -83, 53, -50, 53, -17, 54, 16, 54, 49, 54, 82, 54, 115, 54, -108, 
54, -75, 54, -42, 54, -9, 55, 24, 55, 57, 55, 90, 55, 123, 55, -100, 
55, -67, 55, -34, 55, -1, 56, 32, 56, 65, 56, 98, 56, -125, 56, -92, 
56, -59, 56, -26, 57, 7, 57, 40, 57, 73, 57, 106, 57, -117, 57, -84, 
57, -51, 57, -18, 58, 15, 58, 48, 58, 81, 58, 114, 58, -109, 58, -76, 
58, -43, 58, -10, 59, 23, 59, 56, 59, 89, 59, 122, 59, -101, 59, -68, 
59, -35, 59, -2, 60, 31, 60, 64, 60, 97, 60, -126, 60, -93, 60, -60, 
60, -27, 61, 6, 61, 39, 61, 72, 61, 105, 61, -118, 61, -85, 61, -52, 
61, -19, 62, 14, 62, 47, 62, 80, 62, 113, 62, -110, 62, -77, 62, -44, 
62, -11, 63, 22, 63, 55, 63, 88, 63, 121, 63, -102, 63, -69, 63, -36, 
63, -3, 64, 30, 64, 63, 64, 96, 64, -127, 64, -94, 64, -61, 64, -28, 
65, 5, 65, 38, 65, 71, 65, 104, 65, -119, 65, -86, 65, -53, 65, -20, 
66, 13, 66, 46, 66, 79, 66, 112, 66, -111, 66, -78, 66, -45, 66, -12, 
67, 21, 67, 54, 67, 87, 67, 120, 67, -103, 67, -70, 67, -37, 67, -4, 
68, 29, 68, 62, 68, 95, 68, -128, 68, -95, 68, -62, 68, -29, 69, 4, 
69, 37, 69, 70, 69, 103, 69, -120, 69, -87, 69, -54, 69, -21, 70, 12, 
70, 45, 70, 78, 70, 111, 70, -112, 70, -79, 70, -46, 70, -13, 71, 20, 
71, 53, 71, 86, 71, 119, 71, -104, 71, -71, 71, -38, 71, -5, 72, 28, 
72, 61, 72, 94, 72, 127, 72, -96, 72, -63, 72, -30, 73, 3, 73, 36, 
73, 69, 73, 102, 73, -121, 73, -88, 73, -55, 73, -22, 74, 11, 74, 44, 
74, 77, 74, 110, 74, -113, 74, -80, 74, -47, 74, -14, 75, 19, 75, 52, 
75, 85, 75, 118, 75, -105, 75, -72, 75, -39, 75, -6, 76, 27, 76, 60, 
76, 93, 76, 126, 76, -97, 76, -64, 76, -31, 77, 2, 77, 35, 77, 68, 
77, 101, 77, -122, 77, -89, 78, 0, 78, 33, 78, 66, 78, 99, 78, -124, 
78, -91, 78, -58, 78, -25, 79, 8, 79, 41, 79, 74, 79, 107, 79, -116, 
79, -83, 79, -50, 79, -17, 80, 16, 80, 49, 80, 82, 80, 115, 80, -108, 
80, -75, 80, -42, 80, -9, 81, 24, 81, 57, 81, 90, 81, 123, 81, -100, 
81, -67, 81, -34, 81, -1, 82, 32, 82, 65, 82, 98, 82, -125, 82, -92, 
82, -59, 82, -26, 83, 7, 83, 40, 83, 73, 83, 106, 83, -117, 83, -84, 
83, -51, 83, -18, 84, 15, 84, 48, 84, 81, 84, 114, 84, -109, 84, -76, 
84, -43, 84, -10, 85, 23, 85, 56, 85, 89, 85, 122, 85, -101, 85, -68, 
85, -35, 85, -2, 86, 31, 86, 64, 86, 97, 86, -126, 86, -93, 86, -60, 
86, -27, 87, 6, 87, 39, 87, 72, 87, 105, 87, -118, 87, -85, 87, -52, 
87, -19, 88, 14, 88, 47, 88, 80, 88, 113, 88, -110, 88, -77, 88, -44, 
88, -11, 89, 22, 89, 55, 89, 88, 89, 121, 89, -102, 89, -69, 89, -36, 
89, -3, 90, 30, 90, 63, 90, 96, 90, -127, 90, -94, 90, -61, 90, -28, 
91, 5, 91, 38, 91, 71, 91, 104, 91, -119, 91, -86, 91, -53, 91, -20, 
92, 13, 92, 46, 92, 79, 92, 112, 92, -111, 92, -78, 92, -45, 92, -12, 
93, 21, 93, 54, 93, 87, 93, 120, 93, -103, 93, -70, 93, -37, 93, -4, 
94, 29, 94, 62, 94, 95, 94, -128, 94, -95, 94, -62, 94, -29, 95, 4, 
95, 37, 95, 70, 95, 103, 95, -120, 95, -87, 95, -54, 95, -21, 96, 12, 
96, 45, 96, 78, 96, 111, 96, -112, 96, -79, 96, -46, 96, -13, 97, 20, 
97, 53, 97, 86, 97, 119, 97, -104, 97, -71, 97, -38, 97, -5, 98, 28, 
98, 61, 98, 94, 98, 127, 98, -96, 98, -63, 98, -30, 99, 3, 99, 36, 
99, 69, 99, 102, 99, -121, 99, -88, 99, -55, 99, -22, 100, 11, 100, 44, 
100, 77, 100, 110, 100, -113, 100, -80, 100, -47, 100, -14, 101, 19, 101, 52, 
101, 85, 101, 118, 101, -105, 101, -72, 101, -39, 101, -6, 102, 27, 102, 60, 
102, 93, 102, 126, 102, -97, 102, -64, 102, -31, 103, 2, 103, 35, 103, 68, 
103, 101, 103, -122, 103, -89, 103, -56, 103, -23, 104, 10, 104, 43, 104, 76, 
104, 109, 104, -114, 104, -81, 104, -48, 104, -15, 105, 18, 105, 51, 105, 84, 
105, 117, 105, -106, 105, -73, 105, -40, 105, -7, 106, 26, 106, 59, 106, 92, 
106, 125, 106, -98, 106, -65, 106, -32, 107, 1, 107, 34, 107, 67, 107, 100, 
107, -123, 107, -90, 107, -57, 107, -24, 108, 9, 108, 42, 108, 75, 108, 108, 
108, -115, 108, -82, 108, -49, 108, -16, 109, 17, 109, 50, 109, 83, 109, 116, 
109, -107, 109, -74, 109, -41, 109, -8, 110, 25, 110, 58, 110, 91, 110, 124, 
110, -99, 110, -66, 110, -33, 111, 0, 111, 33, 111, 66, 111, 99, 111, -124, 
111, -91, 111, -58, 111, -25, 112, 8, 112, 41, 112, 74, 112, 107, 112, -116, 
112, -83, 112, -50, 112, -17, 113, 16, 113, 49, 113, 82, 113, 115, 113, -108, 
113, -75, 113, -42, 113, -9, 114, 24, 114, 57, 114, 90, 114, 123, 114, -100, 
114, -67, 114, -34, 114, -1, 115, 32, 115, 65, 115, 98, 115, -125, 115, -92, 
115, -59, 115, -26, 116, 7, 116, 40, 116, 73, 116, 106, 116, -117, 116, -84, 
116, -51, 116, -18, 117, 15, 117, 48, 117, 81, 117, 114, 117, -109, 117, -76, 
117, -43, 117, -10, 118, 23, 118, 56, 118, 89, 118, 122, 118, -101, 118, -68, 
118, -35, 118, -2, 119, 31, 119, 64, 119, 97, 119, -126, 119, -93, 119, -60, 
119, -27, 120, 6, 120, 39, 120, 72, 120, 105, 120, -118, 120, -85, 120, -52, 
120, -19, 121, 14, 121, 47, 121, 80, 121, 113, 121, -110, 121, -77, 121, -44, 
121, -11, 122, 22, 122, 55, 122, 88, 122, 121, 122, -102, 122, -69, 122, -36, 
122, -3, 123, 30, 123, 63, 123, 96, 123, -127, 123, -94, 123, -61, 123, -28, 
124, 5, 124, 38, 124, 71, 124, 104, 124, -119, 124, -86, 124, -53, 124, -20, 
125, 13, 125, 46, 125, 79, 125, 112, 125, -111, 125, -78, 125, -45, 125, -12, 
126, 21, 126, 54, 126, 87, 126, 120, 126, -103, 126, -70, 126, -37, 126, -4, 
127, 29, 127, 62, 127, 95, 127, -128, 127, -95, 127, -62, 127, -29,  */

/*
UTF-16LE
9, 0, 12, 0, 28, 0, 31, 0, 48, 0, 51, 0, 54, 0, 57, 0, 
65, 0, 68, 0, 71, 0, 74, 0, 77, 0, 80, 0, 83, 0, 86, 0, 
89, 0, 97, 0, 100, 0, 103, 0, 106, 0, 109, 0, 112, 0, 115, 0, 
118, 0, 121, 0, -86, 0, -75, 0, -70, 0, -64, 0, -61, 0, -58, 0, 
-55, 0, -52, 0, -49, 0, -46, 0, -43, 0, -40, 0, -37, 0, -34, 0, 
-31, 0, -28, 0, -25, 0, -22, 0, -19, 0, -16, 0, -13, 0, -10, 0, 
-7, 0, -4, 0, -1, 0, 2, 1, 5, 1, 8, 1, 11, 1, 14, 1, 
17, 1, 20, 1, 23, 1, 26, 1, 29, 1, 32, 1, 35, 1, 38, 1, 
41, 1, 44, 1, 47, 1, 50, 1, 53, 1, 56, 1, 59, 1, 62, 1, 
65, 1, 68, 1, 71, 1, 74, 1, 77, 1, 80, 1, 83, 1, 86, 1, 
89, 1, 92, 1, 95, 1, 98, 1, 101, 1, 104, 1, 107, 1, 110, 1, 
113, 1, 116, 1, 119, 1, 122, 1, 125, 1, -128, 1, -125, 1, -122, 1, 
-119, 1, -116, 1, -113, 1, -110, 1, -107, 1, -104, 1, -101, 1, -98, 1, 
-95, 1, -92, 1, -89, 1, -86, 1, -83, 1, -80, 1, -77, 1, -74, 1, 
-71, 1, -68, 1, -65, 1, -62, 1, -59, 1, -56, 1, -53, 1, -50, 1, 
-47, 1, -44, 1, -41, 1, -38, 1, -35, 1, -32, 1, -29, 1, -26, 1, 
-23, 1, -20, 1, -17, 1, -14, 1, -11, 1, -8, 1, -5, 1, -2, 1, 
1, 2, 4, 2, 7, 2, 10, 2, 13, 2, 16, 2, 19, 2, 22, 2, 
25, 2, 28, 2, 31, 2, 34, 2, 37, 2, 40, 2, 43, 2, 46, 2, 
49, 2, 52, 2, 80, 2, 83, 2, 86, 2, 89, 2, 92, 2, 95, 2, 
98, 2, 101, 2, 104, 2, 107, 2, 110, 2, 113, 2, 116, 2, 119, 2, 
122, 2, 125, 2, -128, 2, -125, 2, -122, 2, -119, 2, -116, 2, -113, 2, 
-110, 2, -107, 2, -104, 2, -101, 2, -98, 2, -95, 2, -92, 2, -89, 2, 
-86, 2, -83, 2, -80, 2, -77, 2, -74, 2, -71, 2, -68, 2, -65, 2, 
-58, 2, -55, 2, -52, 2, -49, 2, -32, 2, -29, 2, -18, 2, 122, 3, 
-122, 3, -119, 3, -116, 3, -113, 3, -110, 3, -107, 3, -104, 3, -101, 3, 
-98, 3, -95, 3, -92, 3, -89, 3, -86, 3, -83, 3, -80, 3, -77, 3, 
-74, 3, -71, 3, -68, 3, -65, 3, -62, 3, -59, 3, -56, 3, -53, 3, 
-50, 3, -47, 3, -44, 3, -41, 3, -38, 3, -35, 3, -32, 3, -29, 3, 
-26, 3, -23, 3, -20, 3, -17, 3, -14, 3, -11, 3, -8, 3, -5, 3, 
0, 4, 3, 4, 36, 4, 69, 4, 102, 4, -118, 4, -85, 4, -52, 4, 
-19, 4, 14, 5, 49, 5, 82, 5, 115, 5, -48, 5, -15, 5, 33, 6, 
66, 6, 99, 6, -124, 6, -91, 6, -58, 6, -18, 6, 16, 7, 77, 7, 
-128, 7, -95, 7, 4, 9, 37, 9, 80, 9, -123, 9, -90, 9, -36, 9, 
5, 10, 38, 10, 89, 10, -123, 10, -90, 10, -48, 10, 5, 11, 38, 11, 
92, 11, -125, 11, -92, 11, -25, 11, 8, 12, 42, 12, 96, 12, -123, 12, 
-90, 12, -34, 12, 5, 13, 38, 13, 96, 13, -123, 13, -90, 13, 1, 14, 
34, 14, 67, 14, -127, 14, -94, 14, -61, 14, 0, 15, 33, 15, 66, 15, 
99, 15, -120, 15, 0, 16, 33, 16, 66, 16, -96, 16, -63, 16, -30, 16, 
3, 17, 36, 17, 69, 17, 102, 17, -121, 17, -88, 17, -55, 17, -22, 17, 
11, 18, 44, 18, 77, 18, 110, 18, -112, 18, -78, 18, -45, 18, -12, 18, 
21, 19, 54, 19, 87, 19, -96, 19, -63, 19, -30, 19, 3, 20, 36, 20, 
69, 20, 102, 20, -121, 20, -88, 20, -55, 20, -22, 20, 11, 21, 44, 21, 
77, 21, 110, 21, -113, 21, -80, 21, -47, 21, -14, 21, 19, 22, 52, 22, 
85, 22, 118, 22, -105, 22, -72, 22, -39, 22, 0, 23, 33, 23, 66, 23, 
99, 23, -124, 23, -91, 23, -41, 23, 14, 24, 47, 24, 80, 24, 113, 24, 
-110, 24, 0, 25, 70, 25, 103, 25, 0, 29, 33, 29, 66, 29, 99, 29, 
0, 30, 33, 30, 66, 30, 99, 30, -124, 30, -91, 30, -58, 30, -25, 30, 
8, 31, 41, 31, 74, 31, 107, 31, -116, 31, -83, 31, -48, 31, -14, 31, 
40, 32, 95, 32, 2, 33, 36, 33, 69, 33, 0, 48, 49, 48, 82, 48, 
115, 48, -108, 48, -75, 48, -42, 48, -9, 48, 24, 49, 57, 49, 90, 49, 
123, 49, -96, 49, -16, 49, 0, 52, 33, 52, 66, 52, 99, 52, -124, 52, 
-91, 52, -58, 52, -25, 52, 8, 53, 41, 53, 74, 53, 107, 53, -116, 53, 
-83, 53, -50, 53, -17, 53, 16, 54, 49, 54, 82, 54, 115, 54, -108, 54, 
-75, 54, -42, 54, -9, 54, 24, 55, 57, 55, 90, 55, 123, 55, -100, 55, 
-67, 55, -34, 55, -1, 55, 32, 56, 65, 56, 98, 56, -125, 56, -92, 56, 
-59, 56, -26, 56, 7, 57, 40, 57, 73, 57, 106, 57, -117, 57, -84, 57, 
-51, 57, -18, 57, 15, 58, 48, 58, 81, 58, 114, 58, -109, 58, -76, 58, 
-43, 58, -10, 58, 23, 59, 56, 59, 89, 59, 122, 59, -101, 59, -68, 59, 
-35, 59, -2, 59, 31, 60, 64, 60, 97, 60, -126, 60, -93, 60, -60, 60, 
-27, 60, 6, 61, 39, 61, 72, 61, 105, 61, -118, 61, -85, 61, -52, 61, 
-19, 61, 14, 62, 47, 62, 80, 62, 113, 62, -110, 62, -77, 62, -44, 62, 
-11, 62, 22, 63, 55, 63, 88, 63, 121, 63, -102, 63, -69, 63, -36, 63, 
-3, 63, 30, 64, 63, 64, 96, 64, -127, 64, -94, 64, -61, 64, -28, 64, 
5, 65, 38, 65, 71, 65, 104, 65, -119, 65, -86, 65, -53, 65, -20, 65, 
13, 66, 46, 66, 79, 66, 112, 66, -111, 66, -78, 66, -45, 66, -12, 66, 
21, 67, 54, 67, 87, 67, 120, 67, -103, 67, -70, 67, -37, 67, -4, 67, 
29, 68, 62, 68, 95, 68, -128, 68, -95, 68, -62, 68, -29, 68, 4, 69, 
37, 69, 70, 69, 103, 69, -120, 69, -87, 69, -54, 69, -21, 69, 12, 70, 
45, 70, 78, 70, 111, 70, -112, 70, -79, 70, -46, 70, -13, 70, 20, 71, 
53, 71, 86, 71, 119, 71, -104, 71, -71, 71, -38, 71, -5, 71, 28, 72, 
61, 72, 94, 72, 127, 72, -96, 72, -63, 72, -30, 72, 3, 73, 36, 73, 
69, 73, 102, 73, -121, 73, -88, 73, -55, 73, -22, 73, 11, 74, 44, 74, 
77, 74, 110, 74, -113, 74, -80, 74, -47, 74, -14, 74, 19, 75, 52, 75, 
85, 75, 118, 75, -105, 75, -72, 75, -39, 75, -6, 75, 27, 76, 60, 76, 
93, 76, 126, 76, -97, 76, -64, 76, -31, 76, 2, 77, 35, 77, 68, 77, 
101, 77, -122, 77, -89, 77, 0, 78, 33, 78, 66, 78, 99, 78, -124, 78, 
-91, 78, -58, 78, -25, 78, 8, 79, 41, 79, 74, 79, 107, 79, -116, 79, 
-83, 79, -50, 79, -17, 79, 16, 80, 49, 80, 82, 80, 115, 80, -108, 80, 
-75, 80, -42, 80, -9, 80, 24, 81, 57, 81, 90, 81, 123, 81, -100, 81, 
-67, 81, -34, 81, -1, 81, 32, 82, 65, 82, 98, 82, -125, 82, -92, 82, 
-59, 82, -26, 82, 7, 83, 40, 83, 73, 83, 106, 83, -117, 83, -84, 83, 
-51, 83, -18, 83, 15, 84, 48, 84, 81, 84, 114, 84, -109, 84, -76, 84, 
-43, 84, -10, 84, 23, 85, 56, 85, 89, 85, 122, 85, -101, 85, -68, 85, 
-35, 85, -2, 85, 31, 86, 64, 86, 97, 86, -126, 86, -93, 86, -60, 86, 
-27, 86, 6, 87, 39, 87, 72, 87, 105, 87, -118, 87, -85, 87, -52, 87, 
-19, 87, 14, 88, 47, 88, 80, 88, 113, 88, -110, 88, -77, 88, -44, 88, 
-11, 88, 22, 89, 55, 89, 88, 89, 121, 89, -102, 89, -69, 89, -36, 89, 
-3, 89, 30, 90, 63, 90, 96, 90, -127, 90, -94, 90, -61, 90, -28, 90, 
5, 91, 38, 91, 71, 91, 104, 91, -119, 91, -86, 91, -53, 91, -20, 91, 
13, 92, 46, 92, 79, 92, 112, 92, -111, 92, -78, 92, -45, 92, -12, 92, 
21, 93, 54, 93, 87, 93, 120, 93, -103, 93, -70, 93, -37, 93, -4, 93, 
29, 94, 62, 94, 95, 94, -128, 94, -95, 94, -62, 94, -29, 94, 4, 95, 
37, 95, 70, 95, 103, 95, -120, 95, -87, 95, -54, 95, -21, 95, 12, 96, 
45, 96, 78, 96, 111, 96, -112, 96, -79, 96, -46, 96, -13, 96, 20, 97, 
53, 97, 86, 97, 119, 97, -104, 97, -71, 97, -38, 97, -5, 97, 28, 98, 
61, 98, 94, 98, 127, 98, -96, 98, -63, 98, -30, 98, 3, 99, 36, 99, 
69, 99, 102, 99, -121, 99, -88, 99, -55, 99, -22, 99, 11, 100, 44, 100, 
77, 100, 110, 100, -113, 100, -80, 100, -47, 100, -14, 100, 19, 101, 52, 101, 
85, 101, 118, 101, -105, 101, -72, 101, -39, 101, -6, 101, 27, 102, 60, 102, 
93, 102, 126, 102, -97, 102, -64, 102, -31, 102, 2, 103, 35, 103, 68, 103, 
101, 103, -122, 103, -89, 103, -56, 103, -23, 103, 10, 104, 43, 104, 76, 104, 
109, 104, -114, 104, -81, 104, -48, 104, -15, 104, 18, 105, 51, 105, 84, 105, 
117, 105, -106, 105, -73, 105, -40, 105, -7, 105, 26, 106, 59, 106, 92, 106, 
125, 106, -98, 106, -65, 106, -32, 106, 1, 107, 34, 107, 67, 107, 100, 107, 
-123, 107, -90, 107, -57, 107, -24, 107, 9, 108, 42, 108, 75, 108, 108, 108, 
-115, 108, -82, 108, -49, 108, -16, 108, 17, 109, 50, 109, 83, 109, 116, 109, 
-107, 109, -74, 109, -41, 109, -8, 109, 25, 110, 58, 110, 91, 110, 124, 110, 
-99, 110, -66, 110, -33, 110, 0, 111, 33, 111, 66, 111, 99, 111, -124, 111, 
-91, 111, -58, 111, -25, 111, 8, 112, 41, 112, 74, 112, 107, 112, -116, 112, 
-83, 112, -50, 112, -17, 112, 16, 113, 49, 113, 82, 113, 115, 113, -108, 113, 
-75, 113, -42, 113, -9, 113, 24, 114, 57, 114, 90, 114, 123, 114, -100, 114, 
-67, 114, -34, 114, -1, 114, 32, 115, 65, 115, 98, 115, -125, 115, -92, 115, 
-59, 115, -26, 115, 7, 116, 40, 116, 73, 116, 106, 116, -117, 116, -84, 116, 
-51, 116, -18, 116, 15, 117, 48, 117, 81, 117, 114, 117, -109, 117, -76, 117, 
-43, 117, -10, 117, 23, 118, 56, 118, 89, 118, 122, 118, -101, 118, -68, 118, 
-35, 118, -2, 118, 31, 119, 64, 119, 97, 119, -126, 119, -93, 119, -60, 119, 
-27, 119, 6, 120, 39, 120, 72, 120, 105, 120, -118, 120, -85, 120, -52, 120, 
-19, 120, 14, 121, 47, 121, 80, 121, 113, 121, -110, 121, -77, 121, -44, 121, 
-11, 121, 22, 122, 55, 122, 88, 122, 121, 122, -102, 122, -69, 122, -36, 122, 
-3, 122, 30, 123, 63, 123, 96, 123, -127, 123, -94, 123, -61, 123, -28, 123, 
5, 124, 38, 124, 71, 124, 104, 124, -119, 124, -86, 124, -53, 124, -20, 124, 
13, 125, 46, 125, 79, 125, 112, 125, -111, 125, -78, 125, -45, 125, -12, 125, 
21, 126, 54, 126, 87, 126, 120, 126, -103, 126, -70, 126, -37, 126, -4, 126, 
29, 127, 62, 127, 95, 127, -128, 127, -95, 127, -62, 127, -29, 127,  */

/* 1-BYTE:
US-ASCII
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, 63, 63, 63, 63, 63, 63, 

ISO-8859-1
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, -86, -75, -70, -64, -61, -58, 
-55, -52, -49, -46, -43, -40, -37, -34, -31, -28, -25, -22, -19, -16, -13, -10, 
-7, -4, -1, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 

ISO-8859-2
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, 63, 63, 63, 63, 63, 63, 
-55, 63, 63, 63, 63, 63, 63, 63, -31, -28, -25, 63, -19, 63, -13, -10, 
63, -4, 63, -61, -79, 63, 63, -49, -16, 63, 63, -52, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, -75, -93, -15, -46, 63, 63, -43, 63, 63, 
-8, 63, -70, -34, -69, 63, 63, -39, -5, 63, 63, -68, -82, 63, 63, 63, 

ISO-8859-3
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, 63, -75, 63, -64, 63, 63, 
-55, -52, -49, -46, 63, 63, -37, 63, -31, -28, -25, -22, -19, 63, -13, -10, 
-7, -4, 63, 63, 63, -58, -27, 63, 63, 63, 63, 63, -8, -43, 63, -95, 
63, 63, 63, 63, -68, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, -34, -70, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 

ISO-8859-4
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, 63, 63, 63, 63, -61, -58, 
-55, 63, 63, 63, -43, -40, -37, 63, -31, -28, 63, 63, -19, 63, 63, -10, 
63, -4, 63, 63, -79, 63, 63, 63, -16, 63, -20, 63, 63, 63, -69, 63, 
-75, 63, -25, 63, 63, -94, -90, 63, 63, 63, 63, -67, -14, 63, 63, -93, 
63, 63, 63, 63, 63, -35, -2, 63, 63, 63, 63, 63, -82, 63, 63, 63, 

ISO-8859-5
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, -93, -60, -27, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 

ISO-8859-6
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -63, 
-30, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 

ISO-8859-7
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, -74, -71, -68, -65, -62, -59, -56, -53, 
-50, -47, -44, -41, -38, -35, -32, -29, -26, -23, -20, -17, -14, -11, -8, -5, 
-2, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 

ISO-8859-8
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, 63, -75, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -32, 63, 63, 

ISO-8859-9
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, -86, -75, -70, -64, -61, -58, 
-55, -52, -49, -46, -43, -40, -37, 63, -31, -28, -25, -22, -19, 63, -13, -10, 
-7, -4, -1, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 

x-iso-8859-11
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, -95, -62, -29, 63, 63, 63, 63, 63, 63, 

ISO-8859-13
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, 63, -75, 63, 63, 63, -81, 
-55, 63, 63, 63, -43, -88, 63, 63, 63, -28, 63, 63, 63, 63, -13, -10, 
63, -4, 63, 63, -32, 63, 63, 63, 63, 63, -21, 63, 63, 63, -20, 63, 
63, 63, -31, 63, 63, 63, -49, 63, -39, -15, 63, 63, -12, 63, 63, -86, 
63, 63, 63, 63, 63, 63, -5, 63, 63, 63, 63, -22, -34, 63, 63, 63, 

ISO-8859-15
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, -86, -75, -70, -64, -61, -58, 
-55, -52, -49, -46, -43, -40, -37, -34, -31, -28, -25, -22, -19, -16, -13, -10, 
-7, -4, -1, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -67, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -76, 63, 63, 63, 

 */

/*
ISO-2022-JP  // MaxBytes = 8 !!!
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, 27, 36, 66, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 38, 34, 38, 37, 38, 40, 38, 43, 38, 46, 38, 49, 38, 51, 38, 
54, 33, 41, 33, 41, 33, 41, 38, 67, 38, 70, 38, 73, 38, 76, 38, 
79, 33, 41, 38, 84, 38, 87, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 39, 54, 39, 
103, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 33, 33, 41, 36, 50, 36, 83, 33, 41, 37, 53, 37, 
86, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 48, 
108, 78, 62, 80, 41, 33, 41, 33, 41, 48, 103, 80, 61, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 75, 121, 80, 89, 80, 109, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 58, 68, 81, 37, 33, 41, 80, 
86, 33, 41, 69, 94, 33, 41, 33, 41, 81, 88, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 51, 68, 33, 41, 68, 60, 82, 43, 33, 41, 33, 
41, 82, 67, 33, 41, 33, 41, 33, 41, 72, 63, 82, 90, 77, 121, 33, 
41, 70, 93, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 83, 
57, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 83, 85, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 48, 53, 33, 
41, 84, 48, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 116, 33, 33, 
41, 33, 41, 33, 41, 74, 47, 33, 41, 33, 41, 51, 48, 48, 80, 84, 
121, 33, 41, 33, 41, 58, 74, 85, 42, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 48, 66, 33, 41, 33, 41, 33, 41, 85, 116, 33, 41, 86, 34, 33, 
41, 86, 42, 33, 41, 33, 41, 33, 41, 86, 61, 33, 41, 33, 41, 33, 
41, 33, 41, 78, 102, 86, 95, 33, 41, 68, 107, 33, 41, 86, 112, 33, 
41, 33, 41, 86, 123, 87, 34, 79, 46, 76, 111, 33, 41, 33, 41, 87, 
76, 73, 124, 33, 41, 50, 119, 33, 41, 33, 41, 33, 41, 66, 41, 33, 
41, 33, 41, 33, 41, 65, 91, 33, 41, 33, 41, 33, 41, 88, 77, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 89, 42, 62, 53, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 63, 
100, 89, 102, 33, 41, 33, 41, 72, 66, 33, 41, 33, 41, 33, 41, 64, 
113, 33, 41, 90, 51, 33, 41, 90, 61, 90, 69, 33, 41, 69, 77, 33, 
41, 90, 90, 50, 34, 33, 41, 67, 107, 90, 108, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 77, 104, 33, 41, 33, 41, 33, 
41, 91, 77, 33, 41, 91, 97, 33, 41, 33, 41, 33, 41, 68, 116, 33, 
41, 33, 41, 92, 37, 33, 41, 92, 56, 54, 75, 33, 41, 33, 41, 77, 
77, 92, 95, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 93, 61, 58, 33, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 93, 108, 93, 124, 33, 41, 66, 
89, 33, 41, 61, 39, 33, 41, 77, 97, 94, 56, 33, 41, 33, 41, 33, 
41, 94, 82, 94, 93, 67, 57, 33, 41, 57, 66, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 64, 33, 33, 41, 95, 57, 33, 41, 33, 
41, 33, 41, 33, 41, 50, 80, 33, 41, 67, 58, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 77, 80, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 96, 117, 96, 120, 33, 41, 33, 41, 97, 37, 33, 41, 69, 
68, 72, 42, 33, 41, 33, 41, 33, 41, 58, 47, 33, 41, 33, 41, 33, 
41, 33, 41, 72, 47, 33, 41, 33, 41, 33, 41, 61, 98, 63, 63, 67, 
101, 63, 103, 33, 41, 33, 41, 33, 41, 67, 78, 33, 41, 53, 78, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 65, 67, 33, 41, 77, 
52, 33, 41, 33, 41, 99, 58, 33, 41, 33, 41, 33, 41, 99, 77, 33, 
41, 99, 86, 33, 41, 33, 41, 78, 53, 33, 41, 99, 122, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 70, 70, 33, 41, 33, 41, 33, 41, 33, 
41, 74, 52, 33, 41, 33, 41, 33, 41, 71, 60, 101, 39, 101, 50, 33, 
41, 33, 41, 76, 86, 33, 41, 78, 125, 33, 41, 33, 41, 33, 41, 33, 
41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 33, 41, 102, 42, 33, 
41, 33, 41, 33, 41, 33, 41,  */

/*
x-windows-950
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, -93, -68, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -93, 69, -93, 
72, -93, 75, -93, 78, -93, 81, -93, 84, -93, 86, -93, 89, 63, 63, 63, 
-93, 94, -93, 97, -93, 100, -93, 103, -93, 106, 63, -93, 111, -93, 114, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -95, 64, 63, 
63, 63, 63, 63, 63, 63, -93, -87, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, -92, 64, 63, -55, 64, 63, -36, -78, -91, -24, -92, 
-78, 63, -55, -77, 63, 63, -53, -53, 63, 63, -85, 91, -83, -63, 63, -48, 
-36, 63, -44, 101, -40, 83, -74, -59, -71, -81, 63, -66, -88, -11, -63, -48, 
-34, 63, 63, -88, -26, -24, -7, 63, 63, -88, -17, -48, -20, -71, -70, 63, 
63, -74, -45, 63, 63, -91, 99, 63, 63, -31, 70, -92, -49, -91, 109, -90, 
79, -54, 118, 63, -50, 77, 63, 63, 63, 63, -48, -14, -80, -31, 63, 63, 
63, 63, -36, -48, -71, -66, -71, -54, -27, 65, 63, -20, -57, 63, 63, -54, 
-87, 63, 63, 63, -87, 88, 63, 63, -47, 74, -44, -76, -44, -62, -77, -13, 
63, -36, -15, 63, -68, 88, -20, -53, 63, -91, 126, -90, 105, -82, 78, -90, 
111, 63, -87, 100, -85, -72, -50, 105, -47, 99, 63, -44, -50, 63, -40, -71, 
63, 63, -27, 95, -20, -44, -11, -56, 63, -90, 119, 63, -40, -46, -68, 101, 
-71, -17, 63, -85, -52, 63, -89, -62, 63, -50, -89, -82, 115, 63, -40, -17, 
63, 63, -27, 98, -64, -83, 63, 63, -85, -46, -43, 69, -68, 109, -55, 121, 
63, -76, 91, -68, 115, -89, -53, 63, -71, -5, -47, 123, -85, -36, -76, 95, 
63, -89, -42, -52, -82, -52, 122, 63, -82, -89, -43, 82, -43, 94, 63, -73, 
81, -40, -2, 63, -31, -43, -70, 66, 63, 63, 63, -14, 65, 63, -52, -78, 
-55, -28, -87, -45, 63, 63, 63, -50, -39, 63, -47, -74, 63, -43, 115, -79, 
-64, -76, 124, -76, -86, -35, -74, -73, 104, -31, -38, -27, -83, -27, -76, -68, 
-74, 63, -62, 89, -12, 78, 63, -79, -43, -27, -67, -92, -26, -8, -16, 63, 
-87, -12, 63, 63, -79, -34, -76, -67, -31, -8, -23, -75, 63, 63, -23, -67, 
63, 63, -52, -38, 63, -50, -3, -84, 94, 63, -47, -27, -82, -32, -43, -76, 
63, -79, -24, -39, -58, -39, -79, -76, -44, -35, -37, -73, -92, -73, -91, -30, 
66, -70, 101, 63, 63, 63, -23, -52, 63, 63, -20, -5, 63, -14, 77, 63, 
63, -35, -9, -90, -71, 63, -27, -12, -23, -27, -46, 64, -19, 77, -43, -33, 
-55, -2, 63, -88, 91, -86, 113, -51, 77, -82, -11, -49, 123, -84, 119, 63, 
-81, 68, -82, -9, 63, -42, 68, 63, -75, 65, -76, -7, -76, -17, 63, -73, 
-66, -34, 90, 63, -26, 83, -30, -71, 63, -26, 94, -68, -31, -23, -9, -27, 
-3, -19, 85, 63, -14, 100, -11, -43, -92, -11, 63, -84, -76, -46, 123, -78, 
109, -42, 81, -38, 93, -34, 109, 63, -70, -78, -26, 105, -22, 75, 63, 63, 
-81, 82, -38, 103, -42, 93, 63, -53, 98, 63, -42, 103, 63, 63, -26, -95, 
-9, -23, -51, 102, -49, -54, 63, -42, 113, -75, 98, 63, -70, -65, -68, -3, 
63, 63, -49, -40, -19, 114, -91, -48, 63, 63, 63, 63, -78, -86, -34, -47, 
63, -65, 97, -16, 76, 63, -26, -69, 63, -34, -41, -84, -34, -81, 117, 63, 
-70, -50, -30, -27, -22, 124, -14, 123, -86, -66, -49, -22, -81, 122, -42, -77, 
-38, -50, 63, -30, -15, -26, -61, -22, -85, -62, -90, -11, -29, -81, -89, 63, 
-29, 66, -59, -95, 63, 63, 63, -67, 94, -19, -76, -86, -58, 63, 63, 63, 
-84, -14, -78, -57, 63, -72, 97, 63, 63, 63, -65, 119, -19, -70, -16, 104, 
-12, -87, 63, -81, -69, 63, -26, -30, -14, -83, -81, -57, -78, -49, -38, -14, 
-75, -69, -72, 105, -70, -12, 63, -67, 109, -22, -43, -19, -34, -16, 118, -14, 
-79, -7, 66, 63, 63, 63, 63, -38, -4, -81, -53, 63, -37, 67, -45, 100, 
-29, 124,  */

/* 1-BYTE:
windows-1250
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, 63, -75, 63, 63, 63, 63, 
-55, 63, 63, 63, 63, 63, 63, 63, -31, -28, -25, 63, -19, 63, -13, -10, 
63, -4, 63, -61, -71, 63, 63, -49, -16, 63, 63, -52, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, -66, -93, -15, -46, 63, 63, -43, 63, 63, 
-8, 63, -70, -34, -99, 63, 63, -39, -5, 63, 63, -97, -114, 63, 63, 63, 

windows-1251
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, 63, -75, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, -127, -44, -11, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 

windows-1252
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, -86, -75, -70, -64, -61, -58, 
-55, -52, -49, -46, -43, -40, -37, -34, -31, -28, -25, -22, -19, -16, -13, -10, 
-7, -4, -1, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -100, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -114, 63, 63, 63, 
63, 63, 63, -125, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
-120, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 

windows-1253
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, 63, -75, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, -125, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, -94, -71, -68, -65, -62, -59, -56, -53, 
-50, -47, -44, -41, -38, -35, -32, -29, -26, -23, -20, -17, -14, -11, -8, -5, 
-2, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 

windows-1254
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, -86, -75, -70, -64, -61, -58, 
-55, -52, -49, -46, -43, -40, -37, 63, -31, -28, -25, -22, -19, 63, -13, -10, 
-7, -4, -1, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -100, 63, 
63, 63, -2, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, -125, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 

windows-1255
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, 63, -75, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, -125, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
-120, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -32, -43, 63, 

windows-1256
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, 63, -75, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -25, -22, 63, 63, 63, 63, 
-7, -4, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -100, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, -125, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
-120, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -63, 
-34, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 

windows-1257
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, 63, -75, 63, 63, 63, -81, 
-55, 63, 63, 63, -43, -88, 63, 63, 63, -28, 63, 63, 63, 63, -13, -10, 
63, -4, 63, 63, -32, 63, 63, 63, 63, 63, -21, 63, 63, 63, -20, 63, 
63, 63, -31, 63, 63, 63, -49, 63, -39, -15, 63, 63, -12, 63, 63, -86, 
63, 63, 63, 63, 63, 63, -5, 63, 63, 63, 63, -22, -34, 63, 63, 63, 

windows-1258
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, -86, -75, -70, -64, 63, -58, 
-55, 63, -49, 63, 63, -40, -37, 63, -31, -28, -25, -22, -19, 63, -13, -10, 
-7, -4, -1, -61, 63, 63, 63, 63, -16, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -100, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, -125, 63, 63, 63, 63, -11, 63, 63, 63, 63, -3, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
-120, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 


 */

/*
Big5
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, -93, -68, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -93, 69, -93, 
72, -93, 75, -93, 78, -93, 81, -93, 84, -93, 86, -93, 89, 63, 63, 63, 
-93, 94, -93, 97, -93, 100, -93, 103, -93, 106, 63, -93, 111, -93, 114, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, -57, -68, -57, -34, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -95, 
64, 63, -58, -74, -58, -41, 63, -57, 77, -57, 110, 63, -93, -87, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -92, 64, 63, -55, 64, 
63, -36, -78, -91, -24, -92, -78, 63, -55, -77, 63, 63, -53, -53, 63, 63, 
-85, 91, -83, -63, 63, -48, -36, 63, -44, 101, -40, 83, -74, -59, -71, -81, 
63, -66, -88, -11, -63, -48, -34, 63, 63, -88, -26, -24, -7, 63, 63, -88, 
-17, -48, -20, -71, -70, 63, 63, -74, -45, 63, 63, -91, 99, 63, 63, -31, 
70, -92, -49, -91, 109, -90, 79, -54, 118, 63, -50, 77, 63, 63, 63, 63, 
-48, -14, -80, -31, 63, 63, 63, 63, -36, -48, -71, -66, -71, -54, -27, 65, 
63, -20, -57, 63, 63, -54, -87, 63, 63, 63, -87, 88, 63, 63, -47, 74, 
-44, -76, -44, -62, -77, -13, 63, -36, -15, 63, -68, 88, -20, -53, 63, -91, 
126, -90, 105, -82, 78, -90, 111, 63, -87, 100, -85, -72, -50, 105, -47, 99, 
63, -44, -50, 63, -40, -71, 63, 63, -27, 95, -20, -44, -11, -56, 63, -90, 
119, 63, -40, -46, -68, 101, -71, -17, 63, -85, -52, 63, -89, -62, 63, -50, 
-89, -82, 115, 63, -40, -17, 63, 63, -27, 98, -64, -83, 63, 63, -85, -46, 
-43, 69, -68, 109, -55, 121, 63, -76, 91, -68, 115, -89, -53, 63, -71, -5, 
-47, 123, -85, -36, -76, 95, 63, -89, -42, -52, -82, -52, 122, 63, -82, -89, 
-43, 82, -43, 94, 63, -73, 81, -40, -2, 63, -31, -43, -70, 66, 63, 63, 
63, -14, 65, 63, -52, -78, -55, -28, -87, -45, 63, 63, 63, -50, -39, 63, 
-47, -74, 63, -43, 115, -79, -64, -76, 124, -76, -86, -35, -74, -73, 104, -31, 
-38, -27, -83, -27, -76, -68, -74, 63, -62, 89, -12, 78, 63, -79, -43, -27, 
-67, -92, -26, -8, -16, 63, -87, -12, 63, 63, -79, -34, -76, -67, -31, -8, 
-23, -75, 63, 63, -23, -67, 63, 63, -52, -38, 63, -50, -3, -84, 94, 63, 
-47, -27, -82, -32, -43, -76, 63, -79, -24, -39, -58, -39, -79, -76, -44, -35, 
-37, -73, -92, -73, -91, -30, 66, -70, 101, 63, 63, 63, -23, -52, 63, 63, 
-20, -5, 63, -14, 77, 63, 63, -35, -9, -90, -71, 63, -27, -12, -23, -27, 
-46, 64, -19, 77, -43, -33, -55, -2, 63, -88, 91, -86, 113, -51, 77, -82, 
-11, -49, 123, -84, 119, 63, -81, 68, -82, -9, 63, -42, 68, 63, -75, 65, 
-76, -7, -76, -17, 63, -73, -66, -34, 90, 63, -26, 83, -30, -71, 63, -26, 
94, -68, -31, -23, -9, -27, -3, -19, 85, 63, -14, 100, -11, -43, -92, -11, 
63, -84, -76, -46, 123, -78, 109, -42, 81, -38, 93, -34, 109, 63, -70, -78, 
-26, 105, -22, 75, 63, 63, -81, 82, -38, 103, -42, 93, 63, -53, 98, 63, 
-42, 103, 63, 63, -26, -95, -9, -23, -51, 102, -49, -54, 63, -42, 113, -75, 
98, 63, -70, -65, -68, -3, 63, 63, -49, -40, -19, 114, -91, -48, 63, 63, 
63, 63, -78, -86, -34, -47, 63, -65, 97, -16, 76, 63, -26, -69, 63, -34, 
-41, -84, -34, -81, 117, 63, -70, -50, -30, -27, -22, 124, -14, 123, -86, -66, 
-49, -22, -81, 122, -42, -77, -38, -50, 63, -30, -15, -26, -61, -22, -85, -62, 
-90, -11, -29, -81, -89, 63, -29, 66, -59, -95, 63, 63, 63, -67, 94, -19, 
-76, -86, -58, 63, 63, 63, -84, -14, -78, -57, 63, -72, 97, 63, 63, 63, 
-65, 119, -19, -70, -16, 104, -12, -87, 63, -81, -69, 63, -26, -30, -14, -83, 
-81, -57, -78, -49, -38, -14, -75, -69, -72, 105, -70, -12, 63, -67, 109, -22, 
-43, -19, -34, -16, 118, -14, -79, -7, 66, 63, 63, 63, 63, -38, -4, -81, 
-53, 63, -37, 67, -45, 100, -29, 124,  */

/* 1-BYTE:
IBM864
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, -77, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 

x-IBM874
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, -95, -62, -29, 63, 63, 63, 63, 63, 63, 
 */

/*
GB2312
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, -88, -94, 63, 63, -88, -70, -88, -86, 
63, -88, -82, 63, -88, -76, -88, -71, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, -88, -83, 63, 63, 63, 63, 63, 63, 63, 63, 63, -88, -79, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -88, 
-93, 63, -88, -77, 63, -88, -73, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -95, -91, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, -90, -94, -90, -91, -90, -88, -90, -85, 
-90, -82, -90, -79, -90, -77, -90, -74, 63, 63, 63, -90, -61, -90, -58, -90, 
-55, -90, -52, -90, -49, 63, -90, -44, -90, -41, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -89, -74, -89, 
-25, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -95, -95, 63, -92, -78, -92, 
-45, 63, -91, -75, -91, -42, 63, -88, -40, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, -46, -69, 63, 63, 63, 63, -70, -91, -58, -51, 
63, 63, 63, 63, 63, 63, 63, -39, -34, -72, -87, 63, 63, 63, 63, 63, 
63, -39, -46, 63, 63, 63, -75, -77, -47, -8, -59, -87, -39, -3, 63, -44, 
-28, -55, -66, -74, -25, 63, 63, 63, 63, 63, 63, 63, -69, -36, 63, -47, 
-71, 63, -73, -76, -74, -93, -64, -12, 63, 63, -33, -38, 63, -33, -44, -33, 
-36, 63, 63, 63, 63, 63, 63, 63, -32, -61, -32, -43, -32, -67, 63, 63, 
63, -49, -7, 63, 63, -44, -78, 63, 63, -37, -31, 63, -75, -26, 63, -36, 
-92, 63, 63, 63, 63, -55, -54, 63, 63, 63, -51, -30, -46, -60, -34, -54, 
-53, -3, 63, -58, -34, -67, -86, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, -80, -78, -49, -36, 63, 63, 63, 63, -58, -63, 63, -31, -81, 
63, 63, 63, 63, 63, 63, 63, -31, -41, 63, -25, -35, 63, -75, -37, 63, 
63, -30, -49, 63, 63, 63, -59, -86, -61, -42, 63, 63, -70, -36, 63, 63, 
-65, -20, 63, 63, 63, -49, -94, 63, -29, -83, 63, -49, -21, 63, 63, 63, 
-65, -74, 63, 63, 63, 63, 63, -20, -26, 63, -77, -48, -65, -39, 63, -62, 
-93, 63, -68, -73, -51, -79, 63, -74, -34, -51, -58, -56, -32, -66, -66, -34, 
-11, -80, -31, 63, 63, 63, -41, -85, 63, 63, 63, -22, -73, -21, -73, 63, 
-74, -73, 63, 63, -51, -6, 63, -42, -25, 63, -63, -64, 63, 63, 63, 63, 
63, 63, -64, -76, 63, -24, -59, 63, -24, -47, -24, -48, 63, -41, -64, 63, 
63, -52, -35, 63, -64, -30, -67, -73, 63, -48, -88, 63, 63, -56, -74, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, -69, -74, -20, -90, -76, -53, 63, 
63, 63, 63, 63, -21, -76, 63, 63, 63, -66, -38, 63, -52, -87, 63, -42, 
-34, -59, -88, -44, -95, -52, -23, 63, 63, 63, 63, -61, -20, -43, -65, 63, 
63, 63, -28, -39, 63, 63, 63, 63, -77, -50, 63, 63, 63, 63, 63, 63, 
-69, -16, 63, -52, -65, 63, -49, -87, -20, -55, -20, -51, 63, -20, -50, -56, 
-37, -20, -40, 63, 63, 63, -75, -7, 63, 63, 63, 63, -60, -4, 63, 63, 
63, 63, 63, 63, 63, 63, 63, -25, -5, 63, 63, -24, -80, 63, 63, -50, 
-51, -22, -76, -52, -17, 63, -18, -76, 63, -16, -30, -70, -37, 63, -16, -7, 
-56, -77, 63, 63, 63, 63, 63, -74, -36, -43, -26, -41, -59, -53, -81, 63, 
63, 63, -42, -86, 63, -43, -24, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, -20, -4, 63, 63, 63, -16, -94, 63, -15, -73, 63, 63, 63, -13, 
-60, -13, -41, 63, -13, -34, 63, -13, -18, 63, 63, 63, -12, -93, 63, 63, 
-73, -37, -73, -32, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, -73, -60, -25, -83, -41, -37, -73, -20, 63, -18, -71, 63, -49, 
-37, 63, 63,  */

/*
EUC-JP
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, -113, -94, -20, 63, -113, -94, 
-21, -113, -86, -94, -113, -86, -86, -113, -87, -95, -113, -86, -79, -113, -86, -64, 
-113, -86, -63, -113, -86, -46, -113, -86, -40, -113, -87, -84, -113, -86, -27, -113, 
-87, -80, -113, -85, -95, -113, -85, -93, -113, -85, -82, -113, -85, -76, -113, -85, 
-65, -113, -87, -61, -113, -85, -47, -113, -85, -45, -113, -85, -29, -113, -85, -28, 
-113, -85, -13, -113, -86, -91, -113, -85, -88, -113, -86, -84, -113, -85, -81, -113, 
-86, -80, -113, -87, -62, 63, -113, -85, -74, -113, -86, -75, -113, -85, -70, -113, 
-86, -67, 63, -113, -87, -92, -113, -85, -57, 63, -113, -85, -58, -113, -87, -90, 
-113, -85, -56, -113, -87, -57, -113, -86, -52, -113, -85, -53, -113, -87, -88, -113, 
-85, -51, -113, -86, -50, -113, -87, -85, -113, -85, -41, -113, -86, -42, -113, -87, 
-51, -113, -86, -37, -113, -85, -38, -113, -86, -35, -113, -85, -33, -113, -86, -31, 
-113, -85, -32, -113, -86, -20, -113, -85, -23, -113, -86, -21, -113, -85, -24, -113, 
-86, -15, -113, -85, -12, -113, -85, -11, -113, -86, -10, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, -113, -85, -90, -113, -86, -43, -113, -85, -25, -113, -86, 
-19, -113, -85, -17, 63, 63, 63, 63, 63, 63, 63, 63, -113, -85, -71, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, -113, -90, -31, -113, -90, -29, -113, -90, -25, -113, -90, -20, -90, -94, 
-90, -91, -90, -88, -90, -85, -90, -82, -90, -79, -90, -77, -90, -74, -113, -90, 
-27, -113, -90, -14, -113, -90, -5, -90, -61, -90, -58, -90, -55, -90, -52, -90, 
-49, -113, -90, -8, -90, -44, -90, -41, -113, -90, -6, -113, -90, -4, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -113, -89, 
-61, -89, -74, -89, -25, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -95, -95, 
63, -92, -78, -92, -45, 63, -91, -75, -91, -42, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, -80, -20, -50, -66, -48, -87, -113, 
-80, -74, 63, -80, -25, -48, -67, 63, -113, -80, -43, 63, 63, 63, -113, -79, 
-92, -53, -7, -48, -39, -48, -19, -113, -79, -48, 63, -113, -79, -24, 63, -113, 
-78, -93, -70, -60, -47, -91, 63, -48, -42, -113, -78, -28, -59, -34, 63, 63, 
-47, -40, -113, -77, -88, 63, 63, 63, 63, -77, -60, -113, -77, -39, -60, -68, 
-46, -85, 63, -113, -76, -85, -46, -61, 63, 63, 63, -56, -65, -46, -38, -51, 
-7, 63, -58, -35, 63, 63, 63, 63, -113, -75, -63, 63, -45, -71, 63, 63, 
63, 63, 63, -45, -43, 63, -113, -74, -66, -113, -74, -54, 63, 63, 63, -113, 
-74, -8, 63, -80, -75, 63, -44, -80, 63, 63, -113, -73, -23, -113, -73, -14, 
63, -12, -95, -113, -72, -79, 63, 63, -54, -81, -113, -72, -41, 63, -77, -80, 
-80, -48, -44, -7, -113, -71, -91, 63, -70, -54, -43, -86, 63, -113, -71, -45, 
63, 63, 63, -113, -71, -12, 63, 63, 63, 63, 63, -113, -70, -64, -80, -62, 
63, 63, 63, -43, -12, -113, -70, -14, -42, -94, -113, -69, -94, -42, -86, -113, 
-69, -75, 63, -113, -69, -63, -42, -67, 63, 63, 63, -113, -69, -20, -50, -26, 
-42, -33, 63, -60, -21, -113, -68, -79, -42, -16, -113, -68, -62, 63, -42, -5, 
-41, -94, -49, -82, -52, -17, 63, -113, -68, -2, -41, -52, -55, -4, 63, -78, 
-9, 63, -113, -67, -37, 63, -62, -87, 63, -113, -67, -3, 63, -63, -37, -113, 
-66, -64, -113, -66, -53, 63, -40, -51, -113, -66, -28, -113, -66, -18, 63, 63, 
-113, -65, -86, -113, -65, -78, -39, -86, -66, -75, 63, 63, 63, -113, -65, -37, 
63, 63, -113, -65, -7, -113, -64, -89, -65, -28, -39, -26, -113, -64, -64, 63, 
-56, -62, 63, 63, -113, -64, -18, -64, -15, -113, -63, -88, -38, -77, -113, -63, 
-69, -38, -67, -38, -59, 63, -59, -51, 63, -38, -38, -78, -94, 63, -61, -21, 
-38, -20, -113, -62, -61, -113, -62, -42, -113, -62, -33, 63, 63, 63, 63, -51, 
-24, 63, 63, -113, -61, -67, -37, -51, 63, -37, -31, -113, -61, -37, 63, 63, 
-60, -12, -113, -60, -95, -113, -60, -81, -36, -91, -113, -60, -66, -36, -72, -74, 
-53, -113, -60, -40, -113, -60, -31, -51, -51, -36, -33, -113, -60, -8, -113, -59, 
-93, 63, 63, -113, -59, -64, -113, -59, -54, 63, 63, 63, -35, -67, -70, -95, 
-113, -58, -93, 63, 63, 63, -113, -58, -58, 63, -113, -58, -39, 63, -35, -20, 
-35, -4, -113, -58, -7, -62, -39, -113, -57, -80, -67, -89, 63, -51, -31, -34, 
-72, 63, 63, 63, -34, -46, -34, -35, -61, -71, 63, -71, -62, 63, 63, 63, 
63, 63, 63, -64, -95, -113, -56, -15, -33, -71, 63, 63, 63, -113, -55, -69, 
-78, -48, 63, -61, -70, 63, 63, 63, -113, -55, -16, -113, -55, -7, 63, -51, 
-48, 63, -113, -54, -72, 63, 63, -113, -54, -52, -113, -54, -41, -113, -54, -29, 
63, 63, 63, 63, 63, 63, 63, -113, -53, -49, 63, -113, -53, -24, -113, -53, 
-11, -113, -52, -91, -113, -52, -84, 63, -32, -11, -32, -8, 63, 63, -31, -91, 
63, -59, -60, -56, -86, 63, -113, -51, -57, -113, -51, -51, -70, -81, 63, 63, 
-113, -51, -3, -113, -50, -84, -56, -81, -113, -50, -70, 63, 63, -67, -30, -65, 
-65, -61, -27, -65, -25, 63, 63, 63, -61, -50, -113, -49, -49, -75, -50, -113, 
-49, -32, 63, -113, -49, -17, 63, -113, -48, -89, 63, -63, -61, 63, -51, -76, 
63, 63, -29, -70, -113, -48, -6, 63, 63, -29, -51, 63, -29, -42, 63, -113, 
-47, -30, -50, -75, -113, -47, -15, -29, -6, -113, -46, -92, -113, -46, -86, 63, 
63, 63, -58, -58, 63, -113, -46, -22, 63, 63, -54, -76, 63, 63, 63, -57, 
-68, -27, -89, -27, -78, -113, -45, -19, -113, -45, -5, -52, -42, 63, -50, -3, 
-113, -44, -62, -113, -44, -51, 63, -113, -44, -34, 63, 63, 63, 63, 63, -113, 
-44, -18, -26, -86, -113, -43, -91, -113, -43, -82, 63, -113, -43, -67,  */

/* 1-BYTE:
KOI8-R
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, -26, -56, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 

x-MacRoman
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, -69, -75, -68, -53, -52, -82, 
-125, -19, -20, -15, -51, -81, -13, 63, -121, -118, -115, -112, -110, 63, -105, -102, 
-99, -97, -40, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -49, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, -60, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
-10, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
 */

/*
GBK
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, -88, -94, 63, 63, -88, -70, -88, -86, 
63, -88, -82, 63, -88, -76, -88, -71, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -88, 
-67, 63, 63, -88, -83, 63, 63, 63, 63, 63, 63, 63, 63, 63, -88, -79, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
-88, -93, 63, -88, -77, 63, -88, -73, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -95, -91, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, -90, -94, -90, -91, -90, -88, -90, 
-85, -90, -82, -90, -79, -90, -77, -90, -74, 63, 63, 63, -90, -61, -90, -58, 
-90, -55, -90, -52, -90, -49, 63, -90, -44, -90, -41, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -89, -74, 
-89, -25, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -95, -95, 63, -92, -78, 
-92, -45, 63, -91, -75, -91, -42, 63, -88, -40, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, -46, -69, -127, 73, -127, 86, -127, 96, -127, 
123, -70, -91, -58, -51, -127, -97, -127, -78, -127, -65, -127, -45, -127, -34, -127, 
-16, -126, 66, -39, -34, -72, -87, -126, -126, -126, -109, -126, -85, -126, -57, -126, 
-33, -126, -7, -39, -46, -125, 112, -125, -115, -125, -83, -75, -77, -47, -8, -59, 
-87, -39, -3, -124, 68, -44, -28, -55, -66, -74, -25, -124, -122, -124, -99, -124, 
-77, -124, -56, -124, -32, -124, -7, -123, 77, -69, -36, -123, 109, -47, -71, -123, 
-111, -73, -76, -74, -93, -64, -12, -123, -58, -123, -41, -33, -38, -123, -9, -33, 
-44, -33, -36, -122, 95, -122, 116, -122, -120, -122, -99, -122, -80, -122, -65, -122, 
-42, -32, -61, -32, -43, -32, -67, -121, 101, -121, 126, -121, -107, -49, -7, -121, 
-50, -121, -29, -44, -78, -120, 82, -120, 99, -37, -31, -120, -124, -75, -26, -120, 
-80, -36, -92, -120, -39, -120, -14, -119, 79, -119, 105, -55, -54, -119, -98, -119, 
-69, -119, -43, -51, -30, -46, -60, -34, -54, -53, -3, -118, 118, -58, -34, -67, 
-86, -118, -71, -118, -52, -118, -29, -118, -2, -117, 87, -117, 117, -117, -113, -117, 
-90, -117, -61, -117, -31, -117, -2, -116, 78, -80, -78, -49, -36, -116, 123, -116, 
-110, -116, -90, -116, -71, -58, -63, -116, -37, -31, -81, -115, 68, -115, 91, -115, 
115, -115, -114, -115, -91, -115, -64, -115, -39, -31, -41, -114, 88, -25, -35, -114, 
-121, -75, -37, -114, -86, -114, -61, -30, -49, -114, -27, -114, -5, -113, 86, -59, 
-86, -61, -42, -113, -107, -113, -86, -70, -36, -113, -51, -113, -30, -65, -20, -112, 
67, -112, 80, -112, 103, -49, -94, -112, -118, -29, -83, -112, -78, -49, -21, -112, 
-42, -112, -18, -111, 73, -65, -74, -111, -126, -111, -99, -111, -74, -111, -43, -111, 
-28, -20, -26, -110, 73, -77, -48, -65, -39, -110, 126, -62, -93, -110, -108, -68, 
-73, -51, -79, -110, -51, -74, -34, -51, -58, -56, -32, -66, -66, -34, -11, -80, 
-31, -109, -103, -109, -77, -109, -51, -41, -85, -109, -8, -108, 83, -108, 113, -22, 
-73, -21, -73, -108, -76, -74, -73, -108, -31, -108, -13, -51, -6, -107, 90, -42, 
-25, -107, -125, -63, -64, -107, -80, -107, -53, -107, -24, -107, -3, -106, 83, -106, 
101, -64, -76, -106, -119, -24, -59, -106, -82, -24, -47, -24, -48, -106, -25, -41, 
-64, -105, 70, -105, 96, -52, -35, -105, -110, -64, -30, -67, -73, -105, -36, -48, 
-88, -104, 79, -104, 98, -56, -74, -104, -108, -104, -80, -104, -52, -104, -26, -103, 
64, -103, 92, -103, 119, -103, -107, -103, -74, -103, -41, -69, -74, -20, -90, -76, 
-53, -102, 125, -102, -109, -102, -85, -102, -64, -102, -41, -21, -76, -102, -11, -101, 
72, -101, 90, -66, -38, -101, 123, -52, -87, -101, -102, -42, -34, -59, -88, -44, 
-95, -52, -23, -101, -15, -100, 72, -100, 91, -100, 111, -61, -20, -43, -65, -100, 
-72, -100, -49, -100, -30, -28, -39, -99, 78, -99, 103, -99, 126, -99, -104, -77, 
-50, -99, -54, -99, -27, -98, 65, -98, 96, -98, 125, -98, -99, -69, -16, -98, 
-51, -52, -65, -98, -12, -49, -87, -20, -55, -20, -51, -97, -104, -20, -50, -56, 
-37, -20, -40, -96, 64, -96, 93, -96, 124, -75, -7, -96, -86, -96, -67, -96, 
-44, -96, -21, -60, -4, -86, 80, -86, 101, -86, 119, -86, -108, -85, 80, -85, 
103, -85, 124, -85, -109, -84, 76, -25, -5, -84, 122, -84, -108, -24, -80, -83, 
100, -83, -123, -50, -51, -22, -76, -52, -17, -82, 120, -18, -76, -81, 71, -16, 
-30, -70, -37, -81, 116, -16, -7, -56, -77, -80, 80, -80, 107, -80, 126, -80, 
-101, -79, 74, -74, -36, -43, -26, -41, -59, -53, -81, -78, 88, -78, 111, -78, 
-122, -42, -86, -77, 81, -43, -24, -77, 115, -77, -115, -76, 68, -76, 86, -76, 
107, -76, -121, -75, 65, -75, 95, -75, 118, -75, -120, -75, -96, -20, -4, -74, 
112, -74, -122, -74, -100, -16, -94, -73, 110, -15, -73, -73, -100, -72, 82, -72, 
111, -13, -60, -13, -41, -71, 74, -13, -34, -71, 114, -13, -18, -71, -97, -70, 
86, -70, 111, -12, -93, -69, 68, -69, 100, -73, -37, -73, -32, -68, 71, -68, 
94, -68, 123, -68, -103, -67, 88, -67, 120, -67, -103, -66, 87, -66, 120, -66, 
-102, -65, 90, -65, 123, -65, -102, -64, 90, -64, 122, -73, -60, -25, -83, -41, 
-37, -73, -20, -64, -112, -18, -71, -63, 91, -49, -37, -63, -119, -63, -96,  */

/*
GB2312
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, -88, -94, 63, 63, -88, -70, -88, -86, 
63, -88, -82, 63, -88, -76, -88, -71, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, -88, -83, 63, 63, 63, 63, 63, 63, 63, 63, 63, -88, -79, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -88, 
-93, 63, -88, -77, 63, -88, -73, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -95, -91, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, -90, -94, -90, -91, -90, -88, -90, -85, 
-90, -82, -90, -79, -90, -77, -90, -74, 63, 63, 63, -90, -61, -90, -58, -90, 
-55, -90, -52, -90, -49, 63, -90, -44, -90, -41, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -89, -74, -89, 
-25, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -95, -95, 63, -92, -78, -92, 
-45, 63, -91, -75, -91, -42, 63, -88, -40, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, -46, -69, 63, 63, 63, 63, -70, -91, -58, -51, 
63, 63, 63, 63, 63, 63, 63, -39, -34, -72, -87, 63, 63, 63, 63, 63, 
63, -39, -46, 63, 63, 63, -75, -77, -47, -8, -59, -87, -39, -3, 63, -44, 
-28, -55, -66, -74, -25, 63, 63, 63, 63, 63, 63, 63, -69, -36, 63, -47, 
-71, 63, -73, -76, -74, -93, -64, -12, 63, 63, -33, -38, 63, -33, -44, -33, 
-36, 63, 63, 63, 63, 63, 63, 63, -32, -61, -32, -43, -32, -67, 63, 63, 
63, -49, -7, 63, 63, -44, -78, 63, 63, -37, -31, 63, -75, -26, 63, -36, 
-92, 63, 63, 63, 63, -55, -54, 63, 63, 63, -51, -30, -46, -60, -34, -54, 
-53, -3, 63, -58, -34, -67, -86, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, -80, -78, -49, -36, 63, 63, 63, 63, -58, -63, 63, -31, -81, 
63, 63, 63, 63, 63, 63, 63, -31, -41, 63, -25, -35, 63, -75, -37, 63, 
63, -30, -49, 63, 63, 63, -59, -86, -61, -42, 63, 63, -70, -36, 63, 63, 
-65, -20, 63, 63, 63, -49, -94, 63, -29, -83, 63, -49, -21, 63, 63, 63, 
-65, -74, 63, 63, 63, 63, 63, -20, -26, 63, -77, -48, -65, -39, 63, -62, 
-93, 63, -68, -73, -51, -79, 63, -74, -34, -51, -58, -56, -32, -66, -66, -34, 
-11, -80, -31, 63, 63, 63, -41, -85, 63, 63, 63, -22, -73, -21, -73, 63, 
-74, -73, 63, 63, -51, -6, 63, -42, -25, 63, -63, -64, 63, 63, 63, 63, 
63, 63, -64, -76, 63, -24, -59, 63, -24, -47, -24, -48, 63, -41, -64, 63, 
63, -52, -35, 63, -64, -30, -67, -73, 63, -48, -88, 63, 63, -56, -74, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, -69, -74, -20, -90, -76, -53, 63, 
63, 63, 63, 63, -21, -76, 63, 63, 63, -66, -38, 63, -52, -87, 63, -42, 
-34, -59, -88, -44, -95, -52, -23, 63, 63, 63, 63, -61, -20, -43, -65, 63, 
63, 63, -28, -39, 63, 63, 63, 63, -77, -50, 63, 63, 63, 63, 63, 63, 
-69, -16, 63, -52, -65, 63, -49, -87, -20, -55, -20, -51, 63, -20, -50, -56, 
-37, -20, -40, 63, 63, 63, -75, -7, 63, 63, 63, 63, -60, -4, 63, 63, 
63, 63, 63, 63, 63, 63, 63, -25, -5, 63, 63, -24, -80, 63, 63, -50, 
-51, -22, -76, -52, -17, 63, -18, -76, 63, -16, -30, -70, -37, 63, -16, -7, 
-56, -77, 63, 63, 63, 63, 63, -74, -36, -43, -26, -41, -59, -53, -81, 63, 
63, 63, -42, -86, 63, -43, -24, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, -20, -4, 63, 63, 63, -16, -94, 63, -15, -73, 63, 63, 63, -13, 
-60, -13, -41, 63, -13, -34, 63, -13, -18, 63, 63, 63, -12, -93, 63, 63, 
-73, -37, -73, -32, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, -73, -60, -25, -83, -41, -37, -73, -20, 63, -18, -71, 63, -49, 
-37, 63, 63,  */

/*
EUC-KR
9, 12, 28, 31, 48, 51, 54, 57, 65, 68, 71, 74, 77, 80, 83, 86, 
89, 97, 100, 103, 106, 109, 112, 115, 118, 121, -88, -93, 63, -88, -84, 63, 
63, -88, -95, 63, 63, 63, 63, 63, -88, -86, 63, -88, -83, 63, 63, 63, 
63, 63, -87, -93, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -87, -94, 
63, 63, 63, 63, 63, 63, -88, -92, 63, 63, 63, -88, -90, 63, -87, -89, 
63, 63, -88, -87, 63, 63, -88, -81, 63, 63, -87, -85, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, -91, -62, -91, -59, -91, -56, -91, 
-53, -91, -50, -91, -47, -91, -45, -91, -42, 63, 63, 63, -91, -29, -91, -26, 
-91, -23, -91, -20, -91, -17, 63, -91, -12, -91, -9, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -84, -74, 
-84, -25, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -95, -95, 63, -86, -78, 
-86, -45, 63, -85, -75, -85, -42, 63, 63, -92, -87, -92, -54, -92, -21, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, -20, -23, 63, -25, -47, 63, 63, 
-6, -92, 63, 63, 63, 63, 63, 63, 63, 63, -16, -69, -36, -10, 63, 63, 
63, 63, 63, -13, -16, -3, -22, 63, 63, 63, 63, 63, 63, -42, -87, -3, 
-21, 63, 63, 63, 63, -4, -15, -48, -62, -10, -49, 63, 63, 63, -3, -63, 
63, 63, 63, -38, -29, 63, -41, -39, 63, -9, -94, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, -15, -77, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, 63, 63, -24, -21, 63, 63, 63, -35, -59, 
63, 63, -24, -30, -20, -88, 63, 63, 63, -12, -93, -53, -87, 63, 63, 63, 
63, 63, 63, 63, 63, -5, -5, 63, 63, 63, -28, -52, 63, 63, -50, -80, 
-45, -33, 63, 63, 63, -19, -44, 63, 63, -6, -42, 63, 63, 63, 63, 63, 
-42, -70, 63, 63, -16, -88, 63, -10, -70, 63, 63, -33, -53, -50, -58, -42, 
-25, 63, 63, -23, -18, 63, -36, -42, 63, -10, -31, 63, 63, 63, -29, -45, 
63, 63, 63, -33, -52, 63, 63, 63, -53, -81, -3, -13, 63, 63, 63, 63, 
63, 63, -29, -81, 63, 63, 63, 63, 63, 63, 63, 63, -11, -49, 63, 63, 
63, -38, -26, 63, 63, 63, -13, -68, 63, -12, -83, 63, 63, 63, 63, -44, 
-32, 63, 63, -24, -38, 63, 63, -15, -72, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, -49, -81, 63, 63, 63, -14, -51, 63, -16, -84, 63, 63, 
-11, -95, 63, -32, -37, -48, -65, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, -13, -82, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
-18, -63, 63, -9, -63, -36, -57, -15, -67, 63, -23, -79, -12, -15, 63, 63, 
-12, -24, -4, -71, -39, -35, -45, -64, 63, -49, -75, 63, 63, 63, 63, 63, 
63, -13, -91, 63, 63, 63, 63, 63, 63, -5, -3, 63, -9, -87, 63, 63, 
63, 63, 63, 63, -23, -62, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63, 63, 63, 63, 63, 63, 63, -6, -64, -30, -81, -51, -28, 63, -40, -91, 
-19, -16, 63, 63, -24, -73, 63, -17, -93, -17, -91, 63, 63, 63, -3, -35, 
63, 63, 63, 63, 63, 63, 63, 63, -30, -22, 63, -13, -73, -30, -78, 63, 
63, 63, -14, -79, 63, -10, -37, 63, 63, 63, 63, 63, 63, -11, -88, 63, 
-23, -34, 63, 63, -27, -52, 63, 63, 63, -14, -61, 63, -49, -30, 63, 63, 
63, 63, -9, -62, 63, -48, -75, 63, 63, 63, -44, -65, 63, 63, 63, 63, 
-35, -49, 63, 63, 63, -46, -95, -13, -49, 63, 63, 63, -40, -47, 63, -42, 
-93, -24, -78, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
63,  */


/*
~/ddeclipse/dalvik$ ./run-core-tests.sh tests.api.java.nio.charset.Charset_DomainEndToEnd_Test
mode: simulator
Running selected tests...
.US-ASCII  MaxBytes = 1.0
 - IBM367
 - iso_646.irv:1983
 - csASCII
 - US-ASCII
 - ascii7
 - cp367
 - windows-20127
 - ASCII
 - ANSI_X3.4-1986
 - 646
 - ISO646-US
 - ANSI_X3.4-1968
 - iso-ir-6
 - ibm-367
 - ISO_646.irv:1991
 - us
UTF-8  MaxBytes = 3.0
 - ibm-17593
 - ibm-1208
 - UTF-8
 - ibm-1209
 - cp1208
 - ibm-13496
 - ibm-13497
 - windows-65001
 - ibm-5304
 - ibm-5305
 - ibm-17592
UTF-16  MaxBytes = 2.0
 - ucs-2
 - UTF-16
 - csUnicode
 - unicode
 - ibm-1204
 - ISO-10646-UCS-2
 - ibm-1205
UTF-16BE  MaxBytes = 2.0
 - x-utf-16be
 - ibm-61955
 - ibm-61956
 - UTF16_BigEndian
 - windows-1201
 - cp1200
 - UTF-16BE
 - cp1201
 - ibm-17584
 - ibm-17585
 - ibm-21680
 - ibm-21681
 - ibm-13488
 - ibm-1200
 - ibm-13489
 - ibm-25776
 - ibm-1201
 - ibm-25777
UTF-16LE  MaxBytes = 2.0
 - UTF16_LittleEndian
 - UTF-16LE
 - windows-1200
 - ibm-13490
 - ibm-13491
 - ibm-17586
 - ibm-17587
 - ibm-21682
 - x-utf-16le
 - ibm-21683
 - ibm-1202
 - ibm-25778
 - ibm-1203
 - ibm-25779
ISO-8859-1  MaxBytes = 1.0
 - 819
 - ISO-8859-1
 - csISOLatin1
 - cp819
 - l1
 - iso-ir-100
 - 8859_1
 - ibm-819
 - IBM819
 - latin1
 - ISO_8859-1:1987
ISO-8859-2  MaxBytes = 1.0
 - ISO-8859-2
 - ibm-912
 - ibm-912_P100-1995
 - csISOLatin2
 - l2
 - iso-ir-101
 - 8859_2
 - 912
 - cp912
 - windows-28592
 - latin2
 - ISO_8859-2:1987
ISO-8859-3  MaxBytes = 1.0
 - ISO-8859-3
 - ibm-913
 - csISOLatin3
 - l3
 - 8859_3
 - 913
 - ibm-913_P100-2000
 - cp913
 - iso-ir-109
 - ISO_8859-3:1988
 - windows-28593
 - latin3
ISO-8859-4  MaxBytes = 1.0
 - windows-28594
 - latin4
 - ISO-8859-4
 - ibm-914
 - iso-ir-110
 - ibm-914_P100-1995
 - csISOLatin4
 - l4
 - 8859_4
 - 914
 - ISO_8859-4:1988
 - cp914
ISO-8859-5  MaxBytes = 1.0
 - cp915
 - windows-28595
 - ISO-8859-5
 - ibm-915
 - iso-ir-144
 - ibm-915_P100-1995
 - csISOLatinCyrillic
 - cyrillic
 - 8859_5
 - ISO_8859-5:1988
 - 915
ISO-8859-6  MaxBytes = 1.0
 - 1089
 - windows-28596
 - ASMO-708
 - ibm-1089_P100-1995
 - arabic
 - ISO-8859-6-E
 - cp1089
 - ISO-8859-6-I
 - ISO-8859-6
 - ibm-1089
 - ECMA-114
 - iso-ir-127
 - ISO_8859-6:1987
 - csISOLatinArabic
 - 8859_6
ISO-8859-7  MaxBytes = 1.0
 - greek
 - ibm-9005_X110-2007
 - csISOLatinGreek
 - windows-28597
 - sun_eu_greek
 - ibm-9005
 - ISO-8859-7
 - greek8
 - ISO_8859-7:1987
 - iso-ir-126
 - ELOT_928
 - ECMA-118
ISO-8859-8  MaxBytes = 1.0
 - ISO-8859-8-I
 - windows-28598
 - ibm-5012
 - ISO-8859-8
 - ISO_8859-8:1988
 - iso-ir-138
 - ibm-5012_P100-1999
 - 8859_8
 - csISOLatinHebrew
 - ISO-8859-8-E
 - hebrew
ISO-8859-8  MaxBytes = 1.0
 - ISO-8859-8-I
 - windows-28598
 - ibm-5012
 - ISO-8859-8
 - ISO_8859-8:1988
 - iso-ir-138
 - ibm-5012_P100-1999
 - 8859_8
 - csISOLatinHebrew
 - ISO-8859-8-E
 - hebrew
ISO-8859-9  MaxBytes = 1.0
 - windows-28599
 - csISOLatin5
 - l5
 - cp920
 - ibm-920_P100-1995
 - latin5
 - 920
 - ISO-8859-9
 - iso-ir-148
 - ISO_8859-9:1989
 - ECMA-128
 - ibm-920
 - 8859_9
ISO-8859-10  MaxBytes = 1.0
 - ISO-8859-10
 - latin6
 - iso-8859_10-1998
 - csISOLatin6
 - iso-ir-157
 - l6
 - ISO_8859-10:1992
x-iso-8859_11-2001  MaxBytes = 1.0
 - ISO-8859-11
 - iso-8859_11-2001
 - thai8
ISO-8859-13  MaxBytes = 1.0
 - ibm-921_P100-1995
 - ISO-8859-13
 - 921
 - windows-28603
 - cp921
 - 8859_13
 - ibm-921
ISO-8859-14  MaxBytes = 1.0
 - latin8
 - ISO-8859-14
 - iso-ir-199
 - l8
 - iso-celtic
 - iso-8859_14-1998
 - ISO_8859-14:1998
ISO-8859-15  MaxBytes = 1.0
 - ibm-923
 - csisolatin0
 - ISO-8859-15
 - csisolatin9
 - windows-28605
 - latin0
 - l9
 - iso8859_15_fdis
 - cp923
 - Latin-9
 - ibm-923_P100-1998
 - 923
 - 8859_15
ISO-8859-16  MaxBytes = 1.0
 - latin10
 - iso-8859_16-2001
 - ISO_8859-16:2001
 - ISO-8859-16
 - iso-ir-226
 - l10
ISO-2022-JP  MaxBytes = 6.0
 - csISO2022JP
 - ISO-2022-JP
Big5  MaxBytes = 2.0
 - windows-950-2000
 - csBig5
 - Big5
 - x-big5
 - windows-950
windows-1250  MaxBytes = 1.0
 - windows-1250
 - cp1250
 - ibm-5346
 - ibm-5346_P100-1998
windows-1251  MaxBytes = 1.0
 - ANSI1251
 - windows-1251
 - cp1251
 - ibm-5347
 - ibm-5347_P100-1998
windows-1252  MaxBytes = 1.0
 - windows-1252
 - cp1252
 - ibm-5348
 - ibm-5348_P100-1997
windows-1253  MaxBytes = 1.0
 - ibm-5349_P100-1998
 - windows-1253
 - cp1253
 - ibm-5349
windows-1254  MaxBytes = 1.0
 - ibm-5350
 - ibm-5350_P100-1998
 - windows-1254
 - cp1254
windows-1255  MaxBytes = 1.0
 - ibm-9447_P100-2002
 - ibm-9447
 - windows-1255
 - cp1255
windows-1256  MaxBytes = 1.0
 - ibm-9448_X100-2005
 - ibm-9448
 - windows-1256
 - cp1256
windows-1257  MaxBytes = 1.0
 - cp1257
 - ibm-9449_P100-2002
 - ibm-9449
 - windows-1257
windows-1258  MaxBytes = 1.0
 - cp1258
 - ibm-5354
 - ibm-5354_P100-1998
 - windows-1258
Big5  MaxBytes = 2.0
 - windows-950-2000
 - csBig5
 - Big5
 - x-big5
 - windows-950
cp864  MaxBytes = 1.0
 - csIBM864
 - IBM864
 - cp864
 - ibm-864_X110-1999
 - ibm-864
TIS-620  MaxBytes = 1.0
 - ibm-9066
 - TIS-620
 - eucTH
 - cp874
 - tis620.2533
 - ibm-874
 - ibm-874_P100-1995
GBK  MaxBytes = 2.0
 - EUC-CN
 - csISO58GB231280
 - chinese
 - csGB2312
 - CP936
 - GBK
 - gb2312-1980
 - windows-936
 - MS936
 - windows-936-2000
 - GB2312
 - iso-ir-58
 - GB_2312-80
EUC-JP  MaxBytes = 3.0
 - EUC-JP
 - ibm-954_P101-2007
 - eucjis
 - X-EUC-JP
 - csEUCPkdFmtJapanese
 - Extended_UNIX_Code_Packed_Format_for_Japanese
 - ujis
 - ibm-954
KOI8-R  MaxBytes = 1.0
 - windows-20866
 - ibm-878
 - ibm-878_P100-1996
 - koi8
 - KOI8-R
 - cp878
 - csKOI8R
macintosh  MaxBytes = 1.0
 - csMacintosh
 - macintosh
 - windows-10000
 - macos-0_2-10.2
 - mac
GBK  MaxBytes = 2.0
 - EUC-CN
 - csISO58GB231280
 - chinese
 - csGB2312
 - CP936
 - GBK
 - gb2312-1980
 - windows-936
 - MS936
 - windows-936-2000
 - GB2312
 - iso-ir-58
 - GB_2312-80
GBK  MaxBytes = 2.0
 - EUC-CN
 - csISO58GB231280
 - chinese
 - csGB2312
 - CP936
 - GBK
 - gb2312-1980
 - windows-936
 - MS936
 - windows-936-2000
 - GB2312
 - iso-ir-58
 - GB_2312-80
EUC-KR  MaxBytes = 2.0
 - KS_C_5601-1989
 - EUC-KR
 - 5601
 - korean
 - csKSC56011987
 - windows-949
 - KSC_5601
 - windows-949-2000
 - ms949
 - csEUCKR
 - iso-ir-149
 - KS_C_5601-1987
Big5
 - windows-950-2000
 - csBig5
 - Big5
 - x-big5
 - windows-950
BOCU-1
 - csBOCU-1
 - BOCU-1
 - ibm-1214
 - ibm-1215
CESU-8
 - ibm-9400
 - CESU-8
cp864
 - csIBM864
 - IBM864
 - cp864
 - ibm-864_X110-1999
 - ibm-864
EUC-JP
 - EUC-JP
 - ibm-954_P101-2007
 - eucjis
 - X-EUC-JP
 - csEUCPkdFmtJapanese
 - Extended_UNIX_Code_Packed_Format_for_Japanese
 - ujis
 - ibm-954
EUC-KR
 - KS_C_5601-1989
 - EUC-KR
 - 5601
 - korean
 - csKSC56011987
 - windows-949
 - KSC_5601
 - windows-949-2000
 - ms949
 - csEUCKR
 - iso-ir-149
 - KS_C_5601-1987
GBK
 - EUC-CN
 - csISO58GB231280
 - chinese
 - csGB2312
 - CP936
 - GBK
 - gb2312-1980
 - windows-936
 - MS936
 - windows-936-2000
 - GB2312
 - iso-ir-58
 - GB_2312-80
HZ-GB-2312
 - HZ
 - HZ-GB-2312
ISO-2022-JP
 - csISO2022JP
 - ISO-2022-JP
ISO-8859-1
 - 819
 - ISO-8859-1
 - csISOLatin1
 - cp819
 - l1
 - iso-ir-100
 - 8859_1
 - ibm-819
 - IBM819
 - latin1
 - ISO_8859-1:1987
ISO-8859-10
 - ISO-8859-10
 - latin6
 - iso-8859_10-1998
 - csISOLatin6
 - iso-ir-157
 - l6
 - ISO_8859-10:1992
ISO-8859-13
 - ibm-921_P100-1995
 - ISO-8859-13
 - 921
 - windows-28603
 - cp921
 - 8859_13
 - ibm-921
ISO-8859-14
 - latin8
 - ISO-8859-14
 - iso-ir-199
 - l8
 - iso-celtic
 - iso-8859_14-1998
 - ISO_8859-14:1998
ISO-8859-15
 - ibm-923
 - csisolatin0
 - ISO-8859-15
 - csisolatin9
 - windows-28605
 - latin0
 - l9
 - iso8859_15_fdis
 - cp923
 - Latin-9
 - ibm-923_P100-1998
 - 923
 - 8859_15
ISO-8859-16
 - latin10
 - iso-8859_16-2001
 - ISO_8859-16:2001
 - ISO-8859-16
 - iso-ir-226
 - l10
ISO-8859-2
 - ISO-8859-2
 - ibm-912
 - ibm-912_P100-1995
 - csISOLatin2
 - l2
 - iso-ir-101
 - 8859_2
 - 912
 - cp912
 - windows-28592
 - latin2
 - ISO_8859-2:1987
ISO-8859-3
 - ISO-8859-3
 - ibm-913
 - csISOLatin3
 - l3
 - 8859_3
 - 913
 - ibm-913_P100-2000
 - cp913
 - iso-ir-109
 - ISO_8859-3:1988
 - windows-28593
 - latin3
ISO-8859-4
 - windows-28594
 - latin4
 - ISO-8859-4
 - ibm-914
 - iso-ir-110
 - ibm-914_P100-1995
 - csISOLatin4
 - l4
 - 8859_4
 - 914
 - ISO_8859-4:1988
 - cp914
ISO-8859-5
 - cp915
 - windows-28595
 - ISO-8859-5
 - ibm-915
 - iso-ir-144
 - ibm-915_P100-1995
 - csISOLatinCyrillic
 - cyrillic
 - 8859_5
 - ISO_8859-5:1988
 - 915
ISO-8859-6
 - 1089
 - windows-28596
 - ASMO-708
 - ibm-1089_P100-1995
 - arabic
 - ISO-8859-6-E
 - cp1089
 - ISO-8859-6-I
 - ISO-8859-6
 - ibm-1089
 - ECMA-114
 - iso-ir-127
 - ISO_8859-6:1987
 - csISOLatinArabic
 - 8859_6
ISO-8859-7
 - greek
 - ibm-9005_X110-2007
 - csISOLatinGreek
 - windows-28597
 - sun_eu_greek
 - ibm-9005
 - ISO-8859-7
 - greek8
 - ISO_8859-7:1987
 - iso-ir-126
 - ELOT_928
 - ECMA-118
ISO-8859-8
 - ISO-8859-8-I
 - windows-28598
 - ibm-5012
 - ISO-8859-8
 - ISO_8859-8:1988
 - iso-ir-138
 - ibm-5012_P100-1999
 - 8859_8
 - csISOLatinHebrew
 - ISO-8859-8-E
 - hebrew
ISO-8859-9
 - windows-28599
 - csISOLatin5
 - l5
 - cp920
 - ibm-920_P100-1995
 - latin5
 - 920
 - ISO-8859-9
 - iso-ir-148
 - ISO_8859-9:1989
 - ECMA-128
 - ibm-920
 - 8859_9
KOI8-R
 - windows-20866
 - ibm-878
 - ibm-878_P100-1996
 - koi8
 - KOI8-R
 - cp878
 - csKOI8R
macintosh
 - csMacintosh
 - macintosh
 - windows-10000
 - macos-0_2-10.2
 - mac
SCSU
 - SCSU
 - ibm-1212
 - ibm-1213
Shift_JIS
 - sjis
 - ibm-943_P15A-2003
 - csShiftJIS
 - windows-31j
 - IBM-943C
 - cp932
 - windows-932
 - ms932
 - x-sjis
 - Shift_JIS
 - pck
 - cp943c
 - csWindows31J
 - x-ms-cp932
 - ibm-943_VSUB_VPUA
 - MS_Kanji
 - ibm-943
TIS-620
 - ibm-9066
 - TIS-620
 - eucTH
 - cp874
 - tis620.2533
 - ibm-874
 - ibm-874_P100-1995
US-ASCII
 - IBM367
 - iso_646.irv:1983
 - csASCII
 - US-ASCII
 - ascii7
 - cp367
 - windows-20127
 - ASCII
 - ANSI_X3.4-1986
 - 646
 - ISO646-US
 - ANSI_X3.4-1968
 - iso-ir-6
 - ibm-367
 - ISO_646.irv:1991
 - us
UTF-16
 - ucs-2
 - UTF-16
 - csUnicode
 - unicode
 - ibm-1204
 - ISO-10646-UCS-2
 - ibm-1205
UTF-16BE
 - x-utf-16be
 - ibm-61955
 - ibm-61956
 - UTF16_BigEndian
 - windows-1201
 - cp1200
 - UTF-16BE
 - cp1201
 - ibm-17584
 - ibm-17585
 - ibm-21680
 - ibm-21681
 - ibm-13488
 - ibm-1200
 - ibm-13489
 - ibm-25776
 - ibm-1201
 - ibm-25777
UTF-16LE
 - UTF16_LittleEndian
 - UTF-16LE
 - windows-1200
 - ibm-13490
 - ibm-13491
 - ibm-17586
 - ibm-17587
 - ibm-21682
 - x-utf-16le
 - ibm-21683
 - ibm-1202
 - ibm-25778
 - ibm-1203
 - ibm-25779
UTF-32
 - ISO-10646-UCS-4
 - UTF-32
 - ucs-4
 - ibm-1236
 - ibm-1237
 - csUCS4
UTF-32BE
 - UTF32_BigEndian
 - UTF-32BE
 - ibm-1232
 - ibm-1233
UTF-32LE
 - UTF32_LittleEndian
 - ibm-1234
 - ibm-1235
 - UTF-32LE
UTF-7
 - UTF-7
 - windows-65000
UTF-8
 - ibm-17593
 - ibm-1208
 - UTF-8
 - ibm-1209
 - cp1208
 - ibm-13496
 - ibm-13497
 - windows-65001
 - ibm-5304
 - ibm-5305
 - ibm-17592
windows-1250
 - windows-1250
 - cp1250
 - ibm-5346
 - ibm-5346_P100-1998
windows-1251
 - ANSI1251
 - windows-1251
 - cp1251
 - ibm-5347
 - ibm-5347_P100-1998
windows-1252
 - windows-1252
 - cp1252
 - ibm-5348
 - ibm-5348_P100-1997
windows-1253
 - ibm-5349_P100-1998
 - windows-1253
 - cp1253
 - ibm-5349
windows-1254
 - ibm-5350
 - ibm-5350_P100-1998
 - windows-1254
 - cp1254
windows-1255
 - ibm-9447_P100-2002
 - ibm-9447
 - windows-1255
 - cp1255
windows-1256
 - ibm-9448_X100-2005
 - ibm-9448
 - windows-1256
 - cp1256
windows-1257
 - cp1257
 - ibm-9449_P100-2002
 - ibm-9449
 - windows-1257
windows-1258
 - cp1258
 - ibm-5354
 - ibm-5354_P100-1998
 - windows-1258
x-gsm-03.38-2000
 - gsm-03.38-2000
 - GSM0338
x-ibm-1383_P110-1999
 - ibm-eucCN
 - ibm-1383
 - hp15CN
 - cp1383
 - ibm-1383_P110-1999
 - 1383
 - ibm-1383_VPUA
x-IMAP-mailbox-name
 - IMAP-mailbox-name
x-iscii-be
 - iscii-bng
 - windows-57003
 - windows-57006
 - x-iscii-as
 - x-iscii-be
x-iscii-de
 - ibm-4902
 - iscii-dev
 - windows-57002
 - x-iscii-de
x-iscii-gu
 - windows-57010
 - x-iscii-gu
 - iscii-guj
x-iscii-ka
 - windows-57008
 - iscii-knd
 - x-iscii-ka
x-iscii-ma
 - iscii-mlm
 - windows-57009
 - x-iscii-ma
x-iscii-or
 - iscii-ori
 - windows-57007
 - x-iscii-or
x-iscii-pa
 - iscii-gur
 - windows-57011
 - x-iscii-pa
x-iscii-ta
 - x-iscii-ta
 - windows-57004
 - iscii-tml
x-iscii-te
 - windows-57005
 - x-iscii-te
 - iscii-tlg
x-iso-8859_11-2001
 - ISO-8859-11
 - iso-8859_11-2001
 - thai8
x-UTF16_OppositeEndian
 - UTF16_OppositeEndian
x-UTF16_PlatformEndian
 - UTF16_PlatformEndian
x-UTF32_OppositeEndian
 - UTF32_OppositeEndian
x-UTF32_PlatformEndian
 - UTF32_PlatformEndian
 */
}
