/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.tracking.android;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.text.TextUtils;
import com.google.analytics.tracking.android.Dispatcher;
import com.google.analytics.tracking.android.GANetworkReceiver;
import com.google.analytics.tracking.android.GoogleAnalytics;
import com.google.analytics.tracking.android.Hit;
import com.google.analytics.tracking.android.HitBuilder;
import com.google.analytics.tracking.android.Log;
import com.google.analytics.tracking.android.Utils;
import com.google.android.gms.common.util.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;

class SimpleNetworkDispatcher
implements Dispatcher {
    private static final String USER_AGENT_TEMPLATE = "%s/%s (Linux; U; Android %s; %s; %s Build/%s)";
    private final String userAgent;
    private final HttpClient httpClient;
    private final Context ctx;
    private GoogleAnalytics gaInstance;
    private URL mOverrideHostUrl;

    @VisibleForTesting
    SimpleNetworkDispatcher(HttpClient httpClient, GoogleAnalytics gaInstance, Context ctx) {
        this.ctx = ctx.getApplicationContext();
        this.userAgent = this.createUserAgentString("GoogleAnalytics", "3.0", Build.VERSION.RELEASE, Utils.getLanguage(Locale.getDefault()), Build.MODEL, Build.ID);
        this.httpClient = httpClient;
        this.gaInstance = gaInstance;
    }

    SimpleNetworkDispatcher(HttpClient httpClient, Context ctx) {
        this(httpClient, GoogleAnalytics.getInstance(ctx), ctx);
    }

    @Override
    public boolean okToDispatch() {
        ConnectivityManager cm = (ConnectivityManager)this.ctx.getSystemService("connectivity");
        NetworkInfo network = cm.getActiveNetworkInfo();
        if (network == null || !network.isConnected()) {
            Log.v("...no network connectivity");
            return false;
        }
        return true;
    }

    @Override
    public int dispatchHits(List<Hit> hits) {
        int hitsDispatched = 0;
        int maxHits = Math.min(hits.size(), 40);
        boolean firstSend = true;
        for (int i = 0; i < maxHits; ++i) {
            Hit hit = hits.get(i);
            URL url = this.getUrl(hit);
            if (url == null) {
                if (Log.isVerbose()) {
                    Log.w("No destination: discarding hit: " + hit.getHitParams());
                } else {
                    Log.w("No destination: discarding hit.");
                }
                ++hitsDispatched;
                continue;
            }
            HttpHost targetHost = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
            String path = url.getPath();
            String params = TextUtils.isEmpty((CharSequence)hit.getHitParams()) ? "" : HitBuilder.postProcessHit(hit, System.currentTimeMillis());
            HttpEntityEnclosingRequest request = this.buildRequest(params, path);
            if (request == null) {
                ++hitsDispatched;
                continue;
            }
            request.addHeader("Host", targetHost.toHostString());
            if (Log.isVerbose()) {
                this.logDebugInformation(request);
            }
            if (params.length() > 8192) {
                Log.w("Hit too long (> 8192 bytes)--not sent");
            } else if (this.gaInstance.isDryRunEnabled()) {
                Log.i("Dry run enabled. Hit not actually sent.");
            } else {
                try {
                    if (firstSend) {
                        GANetworkReceiver.sendRadioPoweredBroadcast(this.ctx);
                        firstSend = false;
                    }
                    HttpResponse response = this.httpClient.execute(targetHost, (HttpRequest)request);
                    int statusCode = response.getStatusLine().getStatusCode();
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        entity.consumeContent();
                    }
                    if (statusCode != 200) {
                        Log.w("Bad response: " + response.getStatusLine().getStatusCode());
                    }
                }
                catch (ClientProtocolException e) {
                    Log.w("ClientProtocolException sending hit; discarding hit...");
                }
                catch (IOException e) {
                    Log.w("Exception sending hit: " + e.getClass().getSimpleName());
                    Log.w(e.getMessage());
                    return hitsDispatched;
                }
            }
            ++hitsDispatched;
        }
        return hitsDispatched;
    }

    @Override
    public void close() {
        this.httpClient.getConnectionManager().shutdown();
    }

    private HttpEntityEnclosingRequest buildRequest(String params, String path) {
        BasicHttpEntityEnclosingRequest request;
        if (TextUtils.isEmpty((CharSequence)params)) {
            Log.w("Empty hit, discarding.");
            return null;
        }
        String full = path + "?" + params;
        if (full.length() < 2036) {
            request = new BasicHttpEntityEnclosingRequest("GET", full);
        } else {
            request = new BasicHttpEntityEnclosingRequest("POST", path);
            try {
                request.setEntity((HttpEntity)new StringEntity(params));
            }
            catch (UnsupportedEncodingException e) {
                Log.w("Encoding error, discarding hit");
                return null;
            }
        }
        request.addHeader("User-Agent", this.userAgent);
        return request;
    }

    private void logDebugInformation(HttpEntityEnclosingRequest request) {
        StringBuffer httpHeaders = new StringBuffer();
        for (Header header : request.getAllHeaders()) {
            httpHeaders.append(header.toString()).append("\n");
        }
        httpHeaders.append(request.getRequestLine().toString()).append("\n");
        if (request.getEntity() != null) {
            try {
                int avail;
                InputStream is = request.getEntity().getContent();
                if (is != null && (avail = is.available()) > 0) {
                    byte[] b = new byte[avail];
                    is.read(b);
                    httpHeaders.append("POST:\n");
                    httpHeaders.append(new String(b)).append("\n");
                }
            }
            catch (IOException e) {
                Log.v("Error Writing hit to log...");
            }
        }
        Log.v(httpHeaders.toString());
    }

    String createUserAgentString(String product, String version, String release, String language, String model, String id) {
        return String.format(USER_AGENT_TEMPLATE, product, version, release, language, model, id);
    }

    @VisibleForTesting
    URL getUrl(Hit hit) {
        if (this.mOverrideHostUrl != null) {
            return this.mOverrideHostUrl;
        }
        String hitUrlScheme = hit.getHitUrlScheme();
        try {
            return new URL("http:".equals(hitUrlScheme) ? "http://www.google-analytics.com/collect" : "https://ssl.google-analytics.com/collect");
        }
        catch (MalformedURLException e) {
            Log.e("Error trying to parse the hardcoded host url. This really shouldn't happen.");
            return null;
        }
    }

    @Override
    @VisibleForTesting
    public void overrideHostUrl(String hostUrl) {
        try {
            this.mOverrideHostUrl = new URL(hostUrl);
        }
        catch (MalformedURLException e1) {
            this.mOverrideHostUrl = null;
        }
    }
}

