/*
 * Decompiled with CFR 0.152.
 */
package com.google.tagmanager;

import android.content.Context;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.tagmanager.HitSendingThread;
import com.google.tagmanager.HitStore;
import com.google.tagmanager.Log;
import com.google.tagmanager.ServiceManagerImpl;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.concurrent.LinkedBlockingQueue;

class HitSendingThreadImpl
extends Thread
implements HitSendingThread {
    private final LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue();
    private volatile boolean mDisabled = false;
    private volatile boolean mClosed = false;
    private static HitSendingThreadImpl sInstance;
    private volatile HitStore mUrlStore;
    private final Context mContext;

    static HitSendingThreadImpl getInstance(Context ctx) {
        if (sInstance == null) {
            sInstance = new HitSendingThreadImpl(ctx);
        }
        return sInstance;
    }

    private HitSendingThreadImpl(Context ctx) {
        super("GAThread");
        this.mContext = ctx != null ? ctx.getApplicationContext() : ctx;
        this.start();
    }

    @VisibleForTesting
    HitSendingThreadImpl(Context ctx, HitStore store) {
        super("GAThread");
        this.mContext = ctx != null ? ctx.getApplicationContext() : ctx;
        this.mUrlStore = store;
        this.start();
    }

    @VisibleForTesting
    HitStore getStore() {
        return this.mUrlStore;
    }

    @Override
    public void sendHit(String url) {
        this.sendHit(url, System.currentTimeMillis());
    }

    @VisibleForTesting
    void sendHit(final String url, final long hitTime) {
        final HitSendingThreadImpl thread = this;
        this.queueToThread(new Runnable(){

            @Override
            public void run() {
                if (HitSendingThreadImpl.this.mUrlStore == null) {
                    ServiceManagerImpl instance = ServiceManagerImpl.getInstance();
                    instance.initialize(HitSendingThreadImpl.this.mContext, thread);
                    HitSendingThreadImpl.this.mUrlStore = instance.getStore();
                }
                HitSendingThreadImpl.this.mUrlStore.putHit(hitTime, url);
            }
        });
    }

    @Override
    public void queueToThread(Runnable r) {
        this.queue.add(r);
    }

    @VisibleForTesting
    int getQueueSize() {
        return this.queue.size();
    }

    private String printStackTrace(Throwable t) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(baos);
        t.printStackTrace(stream);
        stream.flush();
        return new String(baos.toByteArray());
    }

    @Override
    public void run() {
        while (!this.mClosed) {
            try {
                try {
                    Runnable r = this.queue.take();
                    if (this.mDisabled) continue;
                    r.run();
                }
                catch (InterruptedException e) {
                    Log.i(e.toString());
                }
            }
            catch (Throwable t) {
                Log.e("Error on GAThread: " + this.printStackTrace(t));
                Log.e("Google Analytics is shutting down.");
                this.mDisabled = true;
            }
        }
    }

    @VisibleForTesting
    void close() {
        this.mClosed = true;
        this.interrupt();
    }

    @VisibleForTesting
    boolean isDisabled() {
        return this.mDisabled;
    }
}

