/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.tracking.android;

import android.util.Log;
import com.google.analytics.tracking.android.Logger;
import com.google.android.gms.common.util.VisibleForTesting;

class DefaultLoggerImpl
implements Logger {
    @VisibleForTesting
    static final String LOG_TAG = "GAV3";
    private Logger.LogLevel mLogLevel = Logger.LogLevel.INFO;

    DefaultLoggerImpl() {
    }

    @Override
    public void verbose(String msg) {
        if (this.mLogLevel.ordinal() <= Logger.LogLevel.VERBOSE.ordinal()) {
            Log.v((String)LOG_TAG, (String)this.formatMessage(msg));
        }
    }

    @Override
    public void info(String msg) {
        if (this.mLogLevel.ordinal() <= Logger.LogLevel.INFO.ordinal()) {
            Log.i((String)LOG_TAG, (String)this.formatMessage(msg));
        }
    }

    @Override
    public void warn(String msg) {
        if (this.mLogLevel.ordinal() <= Logger.LogLevel.WARNING.ordinal()) {
            Log.w((String)LOG_TAG, (String)this.formatMessage(msg));
        }
    }

    @Override
    public void error(String msg) {
        if (this.mLogLevel.ordinal() <= Logger.LogLevel.ERROR.ordinal()) {
            Log.e((String)LOG_TAG, (String)this.formatMessage(msg));
        }
    }

    @Override
    public void error(Exception exception) {
        if (this.mLogLevel.ordinal() <= Logger.LogLevel.ERROR.ordinal()) {
            Log.e((String)LOG_TAG, null, (Throwable)exception);
        }
    }

    @Override
    public void setLogLevel(Logger.LogLevel level) {
        this.mLogLevel = level;
    }

    @Override
    public Logger.LogLevel getLogLevel() {
        return this.mLogLevel;
    }

    private String formatMessage(String msg) {
        return Thread.currentThread().toString() + ": " + msg;
    }
}

