/*
 * Decompiled with CFR 0.152.
 */
package com.google.tagmanager;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import com.google.tagmanager.Log;
import com.google.tagmanager.TagManager;

public class PreviewActivity
extends Activity {
    public void onCreate(Bundle savedInstanceState) {
        try {
            Intent intent;
            super.onCreate(savedInstanceState);
            Log.i("Preview activity");
            Uri data = this.getIntent().getData();
            if (!TagManager.getInstance((Context)this).setPreviewData(data)) {
                String message = "Cannot preview the app with the uri: " + data + ". Launching current version instead.";
                Log.w(message);
                this.displayAlert("Preview failure", message, "Continue");
            }
            if ((intent = this.getPackageManager().getLaunchIntentForPackage(this.getPackageName())) != null) {
                Log.i("Invoke the launch activity for package name: " + this.getPackageName());
                this.startActivity(intent);
            } else {
                Log.i("No launch activity found for package name: " + this.getPackageName());
            }
        }
        catch (Exception e) {
            Log.e("Calling preview threw an exception: " + e.getMessage());
        }
    }

    private void displayAlert(String title, String message, String buttonLabel) {
        AlertDialog alertDialog = new AlertDialog.Builder((Context)this).create();
        alertDialog.setTitle((CharSequence)title);
        alertDialog.setMessage((CharSequence)message);
        alertDialog.setButton(-1, (CharSequence)buttonLabel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        });
        alertDialog.show();
    }
}

