/* This file is generated by venus-protocol git-2564dba1. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_DRIVER_COMMAND_POOL_H
#define VN_PROTOCOL_DRIVER_COMMAND_POOL_H

#include "vn_device.h"
#include "vn_protocol_driver_structs.h"

/* struct VkCommandPoolCreateInfo chain */

static inline size_t
vn_sizeof_VkCommandPoolCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkCommandPoolCreateInfo_self(const VkCommandPoolCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_uint32_t(&val->queueFamilyIndex);
    return size;
}

static inline size_t
vn_sizeof_VkCommandPoolCreateInfo(const VkCommandPoolCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkCommandPoolCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkCommandPoolCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkCommandPoolCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkCommandPoolCreateInfo_self(struct vn_cs_encoder *enc, const VkCommandPoolCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_uint32_t(enc, &val->queueFamilyIndex);
}

static inline void
vn_encode_VkCommandPoolCreateInfo(struct vn_cs_encoder *enc, const VkCommandPoolCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO });
    vn_encode_VkCommandPoolCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkCommandPoolCreateInfo_self(enc, val);
}

static inline size_t vn_sizeof_vkCreateCommandPool(VkDevice device, const VkCommandPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCommandPool* pCommandPool)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateCommandPool_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pCreateInfo);
    if (pCreateInfo)
        cmd_size += vn_sizeof_VkCommandPoolCreateInfo(pCreateInfo);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);
    cmd_size += vn_sizeof_simple_pointer(pCommandPool);
    if (pCommandPool)
        cmd_size += vn_sizeof_VkCommandPool(pCommandPool);

    return cmd_size;
}

static inline void vn_encode_vkCreateCommandPool(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkCommandPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCommandPool* pCommandPool)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateCommandPool_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pCreateInfo))
        vn_encode_VkCommandPoolCreateInfo(enc, pCreateInfo);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
    if (vn_encode_simple_pointer(enc, pCommandPool))
        vn_encode_VkCommandPool(enc, pCommandPool);
}

static inline size_t vn_sizeof_vkCreateCommandPool_reply(VkDevice device, const VkCommandPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCommandPool* pCommandPool)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateCommandPool_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip pCreateInfo */
    /* skip pAllocator */
    cmd_size += vn_sizeof_simple_pointer(pCommandPool);
    if (pCommandPool)
        cmd_size += vn_sizeof_VkCommandPool(pCommandPool);

    return cmd_size;
}

static inline VkResult vn_decode_vkCreateCommandPool_reply(struct vn_cs_decoder *dec, VkDevice device, const VkCommandPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCommandPool* pCommandPool)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCreateCommandPool_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip pCreateInfo */
    /* skip pAllocator */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkCommandPool(dec, pCommandPool);
    } else {
        pCommandPool = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkDestroyCommandPool(VkDevice device, VkCommandPool commandPool, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyCommandPool_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkCommandPool(&commandPool);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);

    return cmd_size;
}

static inline void vn_encode_vkDestroyCommandPool(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkCommandPool commandPool, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyCommandPool_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkCommandPool(enc, &commandPool);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
}

static inline size_t vn_sizeof_vkDestroyCommandPool_reply(VkDevice device, VkCommandPool commandPool, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyCommandPool_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip commandPool */
    /* skip pAllocator */

    return cmd_size;
}

static inline void vn_decode_vkDestroyCommandPool_reply(struct vn_cs_decoder *dec, VkDevice device, VkCommandPool commandPool, const VkAllocationCallbacks* pAllocator)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkDestroyCommandPool_EXT);

    /* skip device */
    /* skip commandPool */
    /* skip pAllocator */
}

static inline size_t vn_sizeof_vkResetCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolResetFlags flags)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkResetCommandPool_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkCommandPool(&commandPool);
    cmd_size += vn_sizeof_VkFlags(&flags);

    return cmd_size;
}

static inline void vn_encode_vkResetCommandPool(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkCommandPool commandPool, VkCommandPoolResetFlags flags)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkResetCommandPool_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkCommandPool(enc, &commandPool);
    vn_encode_VkFlags(enc, &flags);
}

static inline size_t vn_sizeof_vkResetCommandPool_reply(VkDevice device, VkCommandPool commandPool, VkCommandPoolResetFlags flags)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkResetCommandPool_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip commandPool */
    /* skip flags */

    return cmd_size;
}

static inline VkResult vn_decode_vkResetCommandPool_reply(struct vn_cs_decoder *dec, VkDevice device, VkCommandPool commandPool, VkCommandPoolResetFlags flags)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkResetCommandPool_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip commandPool */
    /* skip flags */

    return ret;
}

static inline size_t vn_sizeof_vkTrimCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkTrimCommandPool_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkCommandPool(&commandPool);
    cmd_size += vn_sizeof_VkFlags(&flags);

    return cmd_size;
}

static inline void vn_encode_vkTrimCommandPool(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkTrimCommandPool_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkCommandPool(enc, &commandPool);
    vn_encode_VkFlags(enc, &flags);
}

static inline size_t vn_sizeof_vkTrimCommandPool_reply(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkTrimCommandPool_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip commandPool */
    /* skip flags */

    return cmd_size;
}

static inline void vn_decode_vkTrimCommandPool_reply(struct vn_cs_decoder *dec, VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkTrimCommandPool_EXT);

    /* skip device */
    /* skip commandPool */
    /* skip flags */
}

static inline void vn_submit_vkCreateCommandPool(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkCommandPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCommandPool* pCommandPool, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCreateCommandPool(device, pCreateInfo, pAllocator, pCommandPool);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCreateCommandPool(&submit->command, cmd_flags, device, pCreateInfo, pAllocator, pCommandPool);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCreateCommandPool_reply(device, pCreateInfo, pAllocator, pCommandPool) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkDestroyCommandPool(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, VkCommandPool commandPool, const VkAllocationCallbacks* pAllocator, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkDestroyCommandPool(device, commandPool, pAllocator);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkDestroyCommandPool(&submit->command, cmd_flags, device, commandPool, pAllocator);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkDestroyCommandPool_reply(device, commandPool, pAllocator) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkResetCommandPool(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, VkCommandPool commandPool, VkCommandPoolResetFlags flags, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkResetCommandPool(device, commandPool, flags);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkResetCommandPool(&submit->command, cmd_flags, device, commandPool, flags);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkResetCommandPool_reply(device, commandPool, flags) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkTrimCommandPool(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkTrimCommandPool(device, commandPool, flags);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkTrimCommandPool(&submit->command, cmd_flags, device, commandPool, flags);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkTrimCommandPool_reply(device, commandPool, flags) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline VkResult vn_call_vkCreateCommandPool(struct vn_instance *vn_instance, VkDevice device, const VkCommandPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCommandPool* pCommandPool)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCreateCommandPool(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pCreateInfo, pAllocator, pCommandPool, &submit);
    if (submit.reply_bo) {
        const VkResult ret = vn_decode_vkCreateCommandPool_reply(&submit.reply, device, pCreateInfo, pAllocator, pCommandPool);
        vn_renderer_bo_unref(submit.reply_bo);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkCreateCommandPool(struct vn_instance *vn_instance, VkDevice device, const VkCommandPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCommandPool* pCommandPool)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCreateCommandPool(vn_instance, 0, device, pCreateInfo, pAllocator, pCommandPool, &submit);
}

static inline void vn_call_vkDestroyCommandPool(struct vn_instance *vn_instance, VkDevice device, VkCommandPool commandPool, const VkAllocationCallbacks* pAllocator)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkDestroyCommandPool(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, commandPool, pAllocator, &submit);
    if (submit.reply_bo) {
        vn_decode_vkDestroyCommandPool_reply(&submit.reply, device, commandPool, pAllocator);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkDestroyCommandPool(struct vn_instance *vn_instance, VkDevice device, VkCommandPool commandPool, const VkAllocationCallbacks* pAllocator)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkDestroyCommandPool(vn_instance, 0, device, commandPool, pAllocator, &submit);
}

static inline VkResult vn_call_vkResetCommandPool(struct vn_instance *vn_instance, VkDevice device, VkCommandPool commandPool, VkCommandPoolResetFlags flags)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkResetCommandPool(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, commandPool, flags, &submit);
    if (submit.reply_bo) {
        const VkResult ret = vn_decode_vkResetCommandPool_reply(&submit.reply, device, commandPool, flags);
        vn_renderer_bo_unref(submit.reply_bo);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkResetCommandPool(struct vn_instance *vn_instance, VkDevice device, VkCommandPool commandPool, VkCommandPoolResetFlags flags)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkResetCommandPool(vn_instance, 0, device, commandPool, flags, &submit);
}

static inline void vn_call_vkTrimCommandPool(struct vn_instance *vn_instance, VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkTrimCommandPool(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, commandPool, flags, &submit);
    if (submit.reply_bo) {
        vn_decode_vkTrimCommandPool_reply(&submit.reply, device, commandPool, flags);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkTrimCommandPool(struct vn_instance *vn_instance, VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkTrimCommandPool(vn_instance, 0, device, commandPool, flags, &submit);
}

#endif /* VN_PROTOCOL_DRIVER_COMMAND_POOL_H */
