/* This file is generated by venus-protocol git-2564dba1. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_DRIVER_BUFFER_H
#define VN_PROTOCOL_DRIVER_BUFFER_H

#include "vn_device.h"
#include "vn_protocol_driver_structs.h"

/* struct VkExternalMemoryBufferCreateInfo chain */

static inline size_t
vn_sizeof_VkExternalMemoryBufferCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkExternalMemoryBufferCreateInfo_self(const VkExternalMemoryBufferCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->handleTypes);
    return size;
}

static inline size_t
vn_sizeof_VkExternalMemoryBufferCreateInfo(const VkExternalMemoryBufferCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkExternalMemoryBufferCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkExternalMemoryBufferCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkExternalMemoryBufferCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkExternalMemoryBufferCreateInfo_self(struct vn_cs_encoder *enc, const VkExternalMemoryBufferCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->handleTypes);
}

static inline void
vn_encode_VkExternalMemoryBufferCreateInfo(struct vn_cs_encoder *enc, const VkExternalMemoryBufferCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO });
    vn_encode_VkExternalMemoryBufferCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkExternalMemoryBufferCreateInfo_self(enc, val);
}

/* struct VkBufferOpaqueCaptureAddressCreateInfo chain */

static inline size_t
vn_sizeof_VkBufferOpaqueCaptureAddressCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkBufferOpaqueCaptureAddressCreateInfo_self(const VkBufferOpaqueCaptureAddressCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint64_t(&val->opaqueCaptureAddress);
    return size;
}

static inline size_t
vn_sizeof_VkBufferOpaqueCaptureAddressCreateInfo(const VkBufferOpaqueCaptureAddressCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkBufferOpaqueCaptureAddressCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkBufferOpaqueCaptureAddressCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkBufferOpaqueCaptureAddressCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkBufferOpaqueCaptureAddressCreateInfo_self(struct vn_cs_encoder *enc, const VkBufferOpaqueCaptureAddressCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint64_t(enc, &val->opaqueCaptureAddress);
}

static inline void
vn_encode_VkBufferOpaqueCaptureAddressCreateInfo(struct vn_cs_encoder *enc, const VkBufferOpaqueCaptureAddressCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO });
    vn_encode_VkBufferOpaqueCaptureAddressCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkBufferOpaqueCaptureAddressCreateInfo_self(enc, val);
}

/* struct VkBufferCreateInfo chain */

static inline size_t
vn_sizeof_VkBufferCreateInfo_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkBufferCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkExternalMemoryBufferCreateInfo_self((const VkExternalMemoryBufferCreateInfo *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkBufferCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkBufferOpaqueCaptureAddressCreateInfo_self((const VkBufferOpaqueCaptureAddressCreateInfo *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkBufferCreateInfo_self(const VkBufferCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_VkDeviceSize(&val->size);
    size += vn_sizeof_VkFlags(&val->usage);
    size += vn_sizeof_VkSharingMode(&val->sharingMode);
    size += vn_sizeof_uint32_t(&val->queueFamilyIndexCount);
    if (val->pQueueFamilyIndices) {
        size += vn_sizeof_array_size(val->queueFamilyIndexCount);
        size += vn_sizeof_uint32_t_array(val->pQueueFamilyIndices, val->queueFamilyIndexCount);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkBufferCreateInfo(const VkBufferCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkBufferCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkBufferCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkBufferCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkBufferCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkExternalMemoryBufferCreateInfo_self(enc, (const VkExternalMemoryBufferCreateInfo *)pnext);
            return;
        case VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkBufferCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkBufferOpaqueCaptureAddressCreateInfo_self(enc, (const VkBufferOpaqueCaptureAddressCreateInfo *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkBufferCreateInfo_self(struct vn_cs_encoder *enc, const VkBufferCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_VkDeviceSize(enc, &val->size);
    vn_encode_VkFlags(enc, &val->usage);
    vn_encode_VkSharingMode(enc, &val->sharingMode);
    vn_encode_uint32_t(enc, &val->queueFamilyIndexCount);
    if (val->pQueueFamilyIndices) {
        vn_encode_array_size(enc, val->queueFamilyIndexCount);
        vn_encode_uint32_t_array(enc, val->pQueueFamilyIndices, val->queueFamilyIndexCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkBufferCreateInfo(struct vn_cs_encoder *enc, const VkBufferCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO });
    vn_encode_VkBufferCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkBufferCreateInfo_self(enc, val);
}

/* struct VkBindBufferMemoryDeviceGroupInfo chain */

static inline size_t
vn_sizeof_VkBindBufferMemoryDeviceGroupInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkBindBufferMemoryDeviceGroupInfo_self(const VkBindBufferMemoryDeviceGroupInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->deviceIndexCount);
    if (val->pDeviceIndices) {
        size += vn_sizeof_array_size(val->deviceIndexCount);
        size += vn_sizeof_uint32_t_array(val->pDeviceIndices, val->deviceIndexCount);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkBindBufferMemoryDeviceGroupInfo(const VkBindBufferMemoryDeviceGroupInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkBindBufferMemoryDeviceGroupInfo_pnext(val->pNext);
    size += vn_sizeof_VkBindBufferMemoryDeviceGroupInfo_self(val);

    return size;
}

static inline void
vn_encode_VkBindBufferMemoryDeviceGroupInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkBindBufferMemoryDeviceGroupInfo_self(struct vn_cs_encoder *enc, const VkBindBufferMemoryDeviceGroupInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->deviceIndexCount);
    if (val->pDeviceIndices) {
        vn_encode_array_size(enc, val->deviceIndexCount);
        vn_encode_uint32_t_array(enc, val->pDeviceIndices, val->deviceIndexCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkBindBufferMemoryDeviceGroupInfo(struct vn_cs_encoder *enc, const VkBindBufferMemoryDeviceGroupInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO });
    vn_encode_VkBindBufferMemoryDeviceGroupInfo_pnext(enc, val->pNext);
    vn_encode_VkBindBufferMemoryDeviceGroupInfo_self(enc, val);
}

static inline void
vn_decode_VkBindBufferMemoryDeviceGroupInfo_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkBindBufferMemoryDeviceGroupInfo_self(struct vn_cs_decoder *dec, VkBindBufferMemoryDeviceGroupInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->deviceIndexCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->deviceIndexCount);
        vn_decode_uint32_t_array(dec, (uint32_t *)val->pDeviceIndices, array_size);
    } else {
        vn_decode_array_size(dec, 0);
        val->pDeviceIndices = NULL;
    }
}

static inline void
vn_decode_VkBindBufferMemoryDeviceGroupInfo(struct vn_cs_decoder *dec, VkBindBufferMemoryDeviceGroupInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO);

    assert(val->sType == stype);
    vn_decode_VkBindBufferMemoryDeviceGroupInfo_pnext(dec, val->pNext);
    vn_decode_VkBindBufferMemoryDeviceGroupInfo_self(dec, val);
}

/* struct VkBindBufferMemoryInfo chain */

static inline size_t
vn_sizeof_VkBindBufferMemoryInfo_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkBindBufferMemoryInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkBindBufferMemoryDeviceGroupInfo_self((const VkBindBufferMemoryDeviceGroupInfo *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkBindBufferMemoryInfo_self(const VkBindBufferMemoryInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBuffer(&val->buffer);
    size += vn_sizeof_VkDeviceMemory(&val->memory);
    size += vn_sizeof_VkDeviceSize(&val->memoryOffset);
    return size;
}

static inline size_t
vn_sizeof_VkBindBufferMemoryInfo(const VkBindBufferMemoryInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkBindBufferMemoryInfo_pnext(val->pNext);
    size += vn_sizeof_VkBindBufferMemoryInfo_self(val);

    return size;
}

static inline void
vn_encode_VkBindBufferMemoryInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkBindBufferMemoryInfo_pnext(enc, pnext->pNext);
            vn_encode_VkBindBufferMemoryDeviceGroupInfo_self(enc, (const VkBindBufferMemoryDeviceGroupInfo *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkBindBufferMemoryInfo_self(struct vn_cs_encoder *enc, const VkBindBufferMemoryInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBuffer(enc, &val->buffer);
    vn_encode_VkDeviceMemory(enc, &val->memory);
    vn_encode_VkDeviceSize(enc, &val->memoryOffset);
}

static inline void
vn_encode_VkBindBufferMemoryInfo(struct vn_cs_encoder *enc, const VkBindBufferMemoryInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO });
    vn_encode_VkBindBufferMemoryInfo_pnext(enc, val->pNext);
    vn_encode_VkBindBufferMemoryInfo_self(enc, val);
}

static inline void
vn_decode_VkBindBufferMemoryInfo_pnext(struct vn_cs_decoder *dec, const void *val)
{
    VkBaseOutStructure *pnext = (VkBaseOutStructure *)val;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return;

    vn_decode_VkStructureType(dec, &stype);
    while (true) {
        assert(pnext);
        if (pnext->sType == stype)
            break;
    }

    switch ((int32_t)pnext->sType) {
    case VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO:
        vn_decode_VkBindBufferMemoryInfo_pnext(dec, pnext->pNext);
        vn_decode_VkBindBufferMemoryDeviceGroupInfo_self(dec, (VkBindBufferMemoryDeviceGroupInfo *)pnext);
        break;
    default:
        assert(false);
        break;
    }
}

static inline void
vn_decode_VkBindBufferMemoryInfo_self(struct vn_cs_decoder *dec, VkBindBufferMemoryInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBuffer(dec, &val->buffer);
    vn_decode_VkDeviceMemory(dec, &val->memory);
    vn_decode_VkDeviceSize(dec, &val->memoryOffset);
}

static inline void
vn_decode_VkBindBufferMemoryInfo(struct vn_cs_decoder *dec, VkBindBufferMemoryInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO);

    assert(val->sType == stype);
    vn_decode_VkBindBufferMemoryInfo_pnext(dec, val->pNext);
    vn_decode_VkBindBufferMemoryInfo_self(dec, val);
}

/* struct VkBufferMemoryRequirementsInfo2 chain */

static inline size_t
vn_sizeof_VkBufferMemoryRequirementsInfo2_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkBufferMemoryRequirementsInfo2_self(const VkBufferMemoryRequirementsInfo2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBuffer(&val->buffer);
    return size;
}

static inline size_t
vn_sizeof_VkBufferMemoryRequirementsInfo2(const VkBufferMemoryRequirementsInfo2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkBufferMemoryRequirementsInfo2_pnext(val->pNext);
    size += vn_sizeof_VkBufferMemoryRequirementsInfo2_self(val);

    return size;
}

static inline void
vn_encode_VkBufferMemoryRequirementsInfo2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkBufferMemoryRequirementsInfo2_self(struct vn_cs_encoder *enc, const VkBufferMemoryRequirementsInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBuffer(enc, &val->buffer);
}

static inline void
vn_encode_VkBufferMemoryRequirementsInfo2(struct vn_cs_encoder *enc, const VkBufferMemoryRequirementsInfo2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2 });
    vn_encode_VkBufferMemoryRequirementsInfo2_pnext(enc, val->pNext);
    vn_encode_VkBufferMemoryRequirementsInfo2_self(enc, val);
}

/* struct VkBufferDeviceAddressInfo chain */

static inline size_t
vn_sizeof_VkBufferDeviceAddressInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkBufferDeviceAddressInfo_self(const VkBufferDeviceAddressInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBuffer(&val->buffer);
    return size;
}

static inline size_t
vn_sizeof_VkBufferDeviceAddressInfo(const VkBufferDeviceAddressInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkBufferDeviceAddressInfo_pnext(val->pNext);
    size += vn_sizeof_VkBufferDeviceAddressInfo_self(val);

    return size;
}

static inline void
vn_encode_VkBufferDeviceAddressInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkBufferDeviceAddressInfo_self(struct vn_cs_encoder *enc, const VkBufferDeviceAddressInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBuffer(enc, &val->buffer);
}

static inline void
vn_encode_VkBufferDeviceAddressInfo(struct vn_cs_encoder *enc, const VkBufferDeviceAddressInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO });
    vn_encode_VkBufferDeviceAddressInfo_pnext(enc, val->pNext);
    vn_encode_VkBufferDeviceAddressInfo_self(enc, val);
}

static inline void
vn_decode_VkBufferDeviceAddressInfo_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkBufferDeviceAddressInfo_self(struct vn_cs_decoder *dec, VkBufferDeviceAddressInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBuffer(dec, &val->buffer);
}

static inline void
vn_decode_VkBufferDeviceAddressInfo(struct vn_cs_decoder *dec, VkBufferDeviceAddressInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO);

    assert(val->sType == stype);
    vn_decode_VkBufferDeviceAddressInfo_pnext(dec, val->pNext);
    vn_decode_VkBufferDeviceAddressInfo_self(dec, val);
}

static inline size_t vn_sizeof_vkGetBufferMemoryRequirements(VkDevice device, VkBuffer buffer, VkMemoryRequirements* pMemoryRequirements)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetBufferMemoryRequirements_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkBuffer(&buffer);
    cmd_size += vn_sizeof_simple_pointer(pMemoryRequirements);
    if (pMemoryRequirements)
        cmd_size += vn_sizeof_VkMemoryRequirements_partial(pMemoryRequirements);

    return cmd_size;
}

static inline void vn_encode_vkGetBufferMemoryRequirements(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkBuffer buffer, VkMemoryRequirements* pMemoryRequirements)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetBufferMemoryRequirements_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkBuffer(enc, &buffer);
    if (vn_encode_simple_pointer(enc, pMemoryRequirements))
        vn_encode_VkMemoryRequirements_partial(enc, pMemoryRequirements);
}

static inline size_t vn_sizeof_vkGetBufferMemoryRequirements_reply(VkDevice device, VkBuffer buffer, VkMemoryRequirements* pMemoryRequirements)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetBufferMemoryRequirements_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip buffer */
    cmd_size += vn_sizeof_simple_pointer(pMemoryRequirements);
    if (pMemoryRequirements)
        cmd_size += vn_sizeof_VkMemoryRequirements(pMemoryRequirements);

    return cmd_size;
}

static inline void vn_decode_vkGetBufferMemoryRequirements_reply(struct vn_cs_decoder *dec, VkDevice device, VkBuffer buffer, VkMemoryRequirements* pMemoryRequirements)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetBufferMemoryRequirements_EXT);

    /* skip device */
    /* skip buffer */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkMemoryRequirements(dec, pMemoryRequirements);
    } else {
        pMemoryRequirements = NULL;
    }
}

static inline size_t vn_sizeof_vkBindBufferMemory(VkDevice device, VkBuffer buffer, VkDeviceMemory memory, VkDeviceSize memoryOffset)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkBindBufferMemory_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkBuffer(&buffer);
    cmd_size += vn_sizeof_VkDeviceMemory(&memory);
    cmd_size += vn_sizeof_VkDeviceSize(&memoryOffset);

    return cmd_size;
}

static inline void vn_encode_vkBindBufferMemory(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkBuffer buffer, VkDeviceMemory memory, VkDeviceSize memoryOffset)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkBindBufferMemory_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkBuffer(enc, &buffer);
    vn_encode_VkDeviceMemory(enc, &memory);
    vn_encode_VkDeviceSize(enc, &memoryOffset);
}

static inline size_t vn_sizeof_vkBindBufferMemory_reply(VkDevice device, VkBuffer buffer, VkDeviceMemory memory, VkDeviceSize memoryOffset)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkBindBufferMemory_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip buffer */
    /* skip memory */
    /* skip memoryOffset */

    return cmd_size;
}

static inline VkResult vn_decode_vkBindBufferMemory_reply(struct vn_cs_decoder *dec, VkDevice device, VkBuffer buffer, VkDeviceMemory memory, VkDeviceSize memoryOffset)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkBindBufferMemory_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip buffer */
    /* skip memory */
    /* skip memoryOffset */

    return ret;
}

static inline size_t vn_sizeof_vkCreateBuffer(VkDevice device, const VkBufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBuffer* pBuffer)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateBuffer_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pCreateInfo);
    if (pCreateInfo)
        cmd_size += vn_sizeof_VkBufferCreateInfo(pCreateInfo);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);
    cmd_size += vn_sizeof_simple_pointer(pBuffer);
    if (pBuffer)
        cmd_size += vn_sizeof_VkBuffer(pBuffer);

    return cmd_size;
}

static inline void vn_encode_vkCreateBuffer(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkBufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBuffer* pBuffer)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateBuffer_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pCreateInfo))
        vn_encode_VkBufferCreateInfo(enc, pCreateInfo);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
    if (vn_encode_simple_pointer(enc, pBuffer))
        vn_encode_VkBuffer(enc, pBuffer);
}

static inline size_t vn_sizeof_vkCreateBuffer_reply(VkDevice device, const VkBufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBuffer* pBuffer)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateBuffer_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip pCreateInfo */
    /* skip pAllocator */
    cmd_size += vn_sizeof_simple_pointer(pBuffer);
    if (pBuffer)
        cmd_size += vn_sizeof_VkBuffer(pBuffer);

    return cmd_size;
}

static inline VkResult vn_decode_vkCreateBuffer_reply(struct vn_cs_decoder *dec, VkDevice device, const VkBufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBuffer* pBuffer)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCreateBuffer_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip pCreateInfo */
    /* skip pAllocator */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkBuffer(dec, pBuffer);
    } else {
        pBuffer = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkDestroyBuffer(VkDevice device, VkBuffer buffer, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyBuffer_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkBuffer(&buffer);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);

    return cmd_size;
}

static inline void vn_encode_vkDestroyBuffer(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkBuffer buffer, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyBuffer_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkBuffer(enc, &buffer);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
}

static inline size_t vn_sizeof_vkDestroyBuffer_reply(VkDevice device, VkBuffer buffer, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyBuffer_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip buffer */
    /* skip pAllocator */

    return cmd_size;
}

static inline void vn_decode_vkDestroyBuffer_reply(struct vn_cs_decoder *dec, VkDevice device, VkBuffer buffer, const VkAllocationCallbacks* pAllocator)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkDestroyBuffer_EXT);

    /* skip device */
    /* skip buffer */
    /* skip pAllocator */
}

static inline size_t vn_sizeof_vkBindBufferMemory2(VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkBindBufferMemory2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_uint32_t(&bindInfoCount);
    if (pBindInfos) {
        cmd_size += vn_sizeof_array_size(bindInfoCount);
        for (uint32_t i = 0; i < bindInfoCount; i++)
            cmd_size += vn_sizeof_VkBindBufferMemoryInfo(&pBindInfos[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkBindBufferMemory2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkBindBufferMemory2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_uint32_t(enc, &bindInfoCount);
    if (pBindInfos) {
        vn_encode_array_size(enc, bindInfoCount);
        for (uint32_t i = 0; i < bindInfoCount; i++)
            vn_encode_VkBindBufferMemoryInfo(enc, &pBindInfos[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkBindBufferMemory2_reply(VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkBindBufferMemory2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip bindInfoCount */
    /* skip pBindInfos */

    return cmd_size;
}

static inline VkResult vn_decode_vkBindBufferMemory2_reply(struct vn_cs_decoder *dec, VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkBindBufferMemory2_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip bindInfoCount */
    /* skip pBindInfos */

    return ret;
}

static inline size_t vn_sizeof_vkGetBufferMemoryRequirements2(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetBufferMemoryRequirements2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pInfo);
    if (pInfo)
        cmd_size += vn_sizeof_VkBufferMemoryRequirementsInfo2(pInfo);
    cmd_size += vn_sizeof_simple_pointer(pMemoryRequirements);
    if (pMemoryRequirements)
        cmd_size += vn_sizeof_VkMemoryRequirements2_partial(pMemoryRequirements);

    return cmd_size;
}

static inline void vn_encode_vkGetBufferMemoryRequirements2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetBufferMemoryRequirements2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pInfo))
        vn_encode_VkBufferMemoryRequirementsInfo2(enc, pInfo);
    if (vn_encode_simple_pointer(enc, pMemoryRequirements))
        vn_encode_VkMemoryRequirements2_partial(enc, pMemoryRequirements);
}

static inline size_t vn_sizeof_vkGetBufferMemoryRequirements2_reply(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetBufferMemoryRequirements2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip pInfo */
    cmd_size += vn_sizeof_simple_pointer(pMemoryRequirements);
    if (pMemoryRequirements)
        cmd_size += vn_sizeof_VkMemoryRequirements2(pMemoryRequirements);

    return cmd_size;
}

static inline void vn_decode_vkGetBufferMemoryRequirements2_reply(struct vn_cs_decoder *dec, VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetBufferMemoryRequirements2_EXT);

    /* skip device */
    /* skip pInfo */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkMemoryRequirements2(dec, pMemoryRequirements);
    } else {
        pMemoryRequirements = NULL;
    }
}

static inline size_t vn_sizeof_vkGetBufferOpaqueCaptureAddress(VkDevice device, const VkBufferDeviceAddressInfo* pInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetBufferOpaqueCaptureAddress_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pInfo);
    if (pInfo)
        cmd_size += vn_sizeof_VkBufferDeviceAddressInfo(pInfo);

    return cmd_size;
}

static inline void vn_encode_vkGetBufferOpaqueCaptureAddress(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkBufferDeviceAddressInfo* pInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetBufferOpaqueCaptureAddress_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pInfo))
        vn_encode_VkBufferDeviceAddressInfo(enc, pInfo);
}

static inline size_t vn_sizeof_vkGetBufferOpaqueCaptureAddress_reply(VkDevice device, const VkBufferDeviceAddressInfo* pInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetBufferOpaqueCaptureAddress_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    uint64_t ret;
    cmd_size += vn_sizeof_uint64_t(&ret);
    /* skip device */
    /* skip pInfo */

    return cmd_size;
}

static inline uint64_t vn_decode_vkGetBufferOpaqueCaptureAddress_reply(struct vn_cs_decoder *dec, VkDevice device, const VkBufferDeviceAddressInfo* pInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetBufferOpaqueCaptureAddress_EXT);

    uint64_t ret;
    vn_decode_uint64_t(dec, &ret);
    /* skip device */
    /* skip pInfo */

    return ret;
}

static inline size_t vn_sizeof_vkGetBufferDeviceAddress(VkDevice device, const VkBufferDeviceAddressInfo* pInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetBufferDeviceAddress_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pInfo);
    if (pInfo)
        cmd_size += vn_sizeof_VkBufferDeviceAddressInfo(pInfo);

    return cmd_size;
}

static inline void vn_encode_vkGetBufferDeviceAddress(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkBufferDeviceAddressInfo* pInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetBufferDeviceAddress_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pInfo))
        vn_encode_VkBufferDeviceAddressInfo(enc, pInfo);
}

static inline size_t vn_sizeof_vkGetBufferDeviceAddress_reply(VkDevice device, const VkBufferDeviceAddressInfo* pInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetBufferDeviceAddress_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkDeviceAddress ret;
    cmd_size += vn_sizeof_VkDeviceAddress(&ret);
    /* skip device */
    /* skip pInfo */

    return cmd_size;
}

static inline VkDeviceAddress vn_decode_vkGetBufferDeviceAddress_reply(struct vn_cs_decoder *dec, VkDevice device, const VkBufferDeviceAddressInfo* pInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetBufferDeviceAddress_EXT);

    VkDeviceAddress ret;
    vn_decode_VkDeviceAddress(dec, &ret);
    /* skip device */
    /* skip pInfo */

    return ret;
}

static inline void vn_submit_vkGetBufferMemoryRequirements(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, VkBuffer buffer, VkMemoryRequirements* pMemoryRequirements, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetBufferMemoryRequirements(device, buffer, pMemoryRequirements);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkGetBufferMemoryRequirements(&submit->command, cmd_flags, device, buffer, pMemoryRequirements);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetBufferMemoryRequirements_reply(device, buffer, pMemoryRequirements) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkBindBufferMemory(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, VkBuffer buffer, VkDeviceMemory memory, VkDeviceSize memoryOffset, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkBindBufferMemory(device, buffer, memory, memoryOffset);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkBindBufferMemory(&submit->command, cmd_flags, device, buffer, memory, memoryOffset);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkBindBufferMemory_reply(device, buffer, memory, memoryOffset) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCreateBuffer(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkBufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBuffer* pBuffer, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCreateBuffer(device, pCreateInfo, pAllocator, pBuffer);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCreateBuffer(&submit->command, cmd_flags, device, pCreateInfo, pAllocator, pBuffer);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCreateBuffer_reply(device, pCreateInfo, pAllocator, pBuffer) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkDestroyBuffer(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, VkBuffer buffer, const VkAllocationCallbacks* pAllocator, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkDestroyBuffer(device, buffer, pAllocator);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkDestroyBuffer(&submit->command, cmd_flags, device, buffer, pAllocator);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkDestroyBuffer_reply(device, buffer, pAllocator) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkBindBufferMemory2(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkBindBufferMemory2(device, bindInfoCount, pBindInfos);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkBindBufferMemory2(&submit->command, cmd_flags, device, bindInfoCount, pBindInfos);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkBindBufferMemory2_reply(device, bindInfoCount, pBindInfos) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkGetBufferMemoryRequirements2(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetBufferMemoryRequirements2(device, pInfo, pMemoryRequirements);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkGetBufferMemoryRequirements2(&submit->command, cmd_flags, device, pInfo, pMemoryRequirements);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetBufferMemoryRequirements2_reply(device, pInfo, pMemoryRequirements) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkGetBufferOpaqueCaptureAddress(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkBufferDeviceAddressInfo* pInfo, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetBufferOpaqueCaptureAddress(device, pInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkGetBufferOpaqueCaptureAddress(&submit->command, cmd_flags, device, pInfo);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetBufferOpaqueCaptureAddress_reply(device, pInfo) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkGetBufferDeviceAddress(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkBufferDeviceAddressInfo* pInfo, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetBufferDeviceAddress(device, pInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkGetBufferDeviceAddress(&submit->command, cmd_flags, device, pInfo);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetBufferDeviceAddress_reply(device, pInfo) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_call_vkGetBufferMemoryRequirements(struct vn_instance *vn_instance, VkDevice device, VkBuffer buffer, VkMemoryRequirements* pMemoryRequirements)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetBufferMemoryRequirements(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, buffer, pMemoryRequirements, &submit);
    if (submit.reply_bo) {
        vn_decode_vkGetBufferMemoryRequirements_reply(&submit.reply, device, buffer, pMemoryRequirements);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkGetBufferMemoryRequirements(struct vn_instance *vn_instance, VkDevice device, VkBuffer buffer, VkMemoryRequirements* pMemoryRequirements)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetBufferMemoryRequirements(vn_instance, 0, device, buffer, pMemoryRequirements, &submit);
}

static inline VkResult vn_call_vkBindBufferMemory(struct vn_instance *vn_instance, VkDevice device, VkBuffer buffer, VkDeviceMemory memory, VkDeviceSize memoryOffset)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkBindBufferMemory(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, buffer, memory, memoryOffset, &submit);
    if (submit.reply_bo) {
        const VkResult ret = vn_decode_vkBindBufferMemory_reply(&submit.reply, device, buffer, memory, memoryOffset);
        vn_renderer_bo_unref(submit.reply_bo);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkBindBufferMemory(struct vn_instance *vn_instance, VkDevice device, VkBuffer buffer, VkDeviceMemory memory, VkDeviceSize memoryOffset)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkBindBufferMemory(vn_instance, 0, device, buffer, memory, memoryOffset, &submit);
}

static inline VkResult vn_call_vkCreateBuffer(struct vn_instance *vn_instance, VkDevice device, const VkBufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBuffer* pBuffer)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCreateBuffer(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pCreateInfo, pAllocator, pBuffer, &submit);
    if (submit.reply_bo) {
        const VkResult ret = vn_decode_vkCreateBuffer_reply(&submit.reply, device, pCreateInfo, pAllocator, pBuffer);
        vn_renderer_bo_unref(submit.reply_bo);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkCreateBuffer(struct vn_instance *vn_instance, VkDevice device, const VkBufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBuffer* pBuffer)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCreateBuffer(vn_instance, 0, device, pCreateInfo, pAllocator, pBuffer, &submit);
}

static inline void vn_call_vkDestroyBuffer(struct vn_instance *vn_instance, VkDevice device, VkBuffer buffer, const VkAllocationCallbacks* pAllocator)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkDestroyBuffer(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, buffer, pAllocator, &submit);
    if (submit.reply_bo) {
        vn_decode_vkDestroyBuffer_reply(&submit.reply, device, buffer, pAllocator);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkDestroyBuffer(struct vn_instance *vn_instance, VkDevice device, VkBuffer buffer, const VkAllocationCallbacks* pAllocator)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkDestroyBuffer(vn_instance, 0, device, buffer, pAllocator, &submit);
}

static inline VkResult vn_call_vkBindBufferMemory2(struct vn_instance *vn_instance, VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkBindBufferMemory2(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, bindInfoCount, pBindInfos, &submit);
    if (submit.reply_bo) {
        const VkResult ret = vn_decode_vkBindBufferMemory2_reply(&submit.reply, device, bindInfoCount, pBindInfos);
        vn_renderer_bo_unref(submit.reply_bo);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkBindBufferMemory2(struct vn_instance *vn_instance, VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkBindBufferMemory2(vn_instance, 0, device, bindInfoCount, pBindInfos, &submit);
}

static inline void vn_call_vkGetBufferMemoryRequirements2(struct vn_instance *vn_instance, VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetBufferMemoryRequirements2(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pInfo, pMemoryRequirements, &submit);
    if (submit.reply_bo) {
        vn_decode_vkGetBufferMemoryRequirements2_reply(&submit.reply, device, pInfo, pMemoryRequirements);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkGetBufferMemoryRequirements2(struct vn_instance *vn_instance, VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetBufferMemoryRequirements2(vn_instance, 0, device, pInfo, pMemoryRequirements, &submit);
}

static inline uint64_t vn_call_vkGetBufferOpaqueCaptureAddress(struct vn_instance *vn_instance, VkDevice device, const VkBufferDeviceAddressInfo* pInfo)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetBufferOpaqueCaptureAddress(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pInfo, &submit);
    if (submit.reply_bo) {
        const uint64_t ret = vn_decode_vkGetBufferOpaqueCaptureAddress_reply(&submit.reply, device, pInfo);
        vn_renderer_bo_unref(submit.reply_bo);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkGetBufferOpaqueCaptureAddress(struct vn_instance *vn_instance, VkDevice device, const VkBufferDeviceAddressInfo* pInfo)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetBufferOpaqueCaptureAddress(vn_instance, 0, device, pInfo, &submit);
}

static inline VkDeviceAddress vn_call_vkGetBufferDeviceAddress(struct vn_instance *vn_instance, VkDevice device, const VkBufferDeviceAddressInfo* pInfo)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetBufferDeviceAddress(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pInfo, &submit);
    if (submit.reply_bo) {
        const VkDeviceAddress ret = vn_decode_vkGetBufferDeviceAddress_reply(&submit.reply, device, pInfo);
        vn_renderer_bo_unref(submit.reply_bo);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkGetBufferDeviceAddress(struct vn_instance *vn_instance, VkDevice device, const VkBufferDeviceAddressInfo* pInfo)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetBufferDeviceAddress(vn_instance, 0, device, pInfo, &submit);
}

#endif /* VN_PROTOCOL_DRIVER_BUFFER_H */
