/* ------------------------------------------------------------------
 * Copyright (C) 1998-2009 PacketVideo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 * -------------------------------------------------------------------
 */
#include "oscl_types.h"
#include "sbc_type_defs.h"
#include "sbcenc_crc8.h"

#define USE_CRC_TABLE   /* Another method is not yet implemented */

#define CRC_POLY    0x1D
#define CRC_INIT    0x0F

#if defined(USE_CRC_TABLE)

static const UWord8 crctable[256] =
{
    0x00, 0x1D, 0x3A, 0x27, 0x74, 0x69, 0x4E, 0x53, 0xE8, 0xF5, 0xD2, 0xCF, 0x9C, 0x81, 0xA6, 0xBB,
    0xCD, 0xD0, 0xF7, 0xEA, 0xB9, 0xA4, 0x83, 0x9E, 0x25, 0x38, 0x1F, 0x02, 0x51, 0x4C, 0x6B, 0x76,
    0x87, 0x9A, 0xBD, 0xA0, 0xF3, 0xEE, 0xC9, 0xD4, 0x6F, 0x72, 0x55, 0x48, 0x1B, 0x06, 0x21, 0x3C,
    0x4A, 0x57, 0x70, 0x6D, 0x3E, 0x23, 0x04, 0x19, 0xA2, 0xBF, 0x98, 0x85, 0xD6, 0xCB, 0xEC, 0xF1,
    0x13, 0x0E, 0x29, 0x34, 0x67, 0x7A, 0x5D, 0x40, 0xFB, 0xE6, 0xC1, 0xDC, 0x8F, 0x92, 0xB5, 0xA8,
    0xDE, 0xC3, 0xE4, 0xF9, 0xAA, 0xB7, 0x90, 0x8D, 0x36, 0x2B, 0x0C, 0x11, 0x42, 0x5F, 0x78, 0x65,
    0x94, 0x89, 0xAE, 0xB3, 0xE0, 0xFD, 0xDA, 0xC7, 0x7C, 0x61, 0x46, 0x5B, 0x08, 0x15, 0x32, 0x2F,
    0x59, 0x44, 0x63, 0x7E, 0x2D, 0x30, 0x17, 0x0A, 0xB1, 0xAC, 0x8B, 0x96, 0xC5, 0xD8, 0xFF, 0xE2,
    0x26, 0x3B, 0x1C, 0x01, 0x52, 0x4F, 0x68, 0x75, 0xCE, 0xD3, 0xF4, 0xE9, 0xBA, 0xA7, 0x80, 0x9D,
    0xEB, 0xF6, 0xD1, 0xCC, 0x9F, 0x82, 0xA5, 0xB8, 0x03, 0x1E, 0x39, 0x24, 0x77, 0x6A, 0x4D, 0x50,
    0xA1, 0xBC, 0x9B, 0x86, 0xD5, 0xC8, 0xEF, 0xF2, 0x49, 0x54, 0x73, 0x6E, 0x3D, 0x20, 0x07, 0x1A,
    0x6C, 0x71, 0x56, 0x4B, 0x18, 0x05, 0x22, 0x3F, 0x84, 0x99, 0xBE, 0xA3, 0xF0, 0xED, 0xCA, 0xD7,
    0x35, 0x28, 0x0F, 0x12, 0x41, 0x5C, 0x7B, 0x66, 0xDD, 0xC0, 0xE7, 0xFA, 0xA9, 0xB4, 0x93, 0x8E,
    0xF8, 0xE5, 0xC2, 0xDF, 0x8C, 0x91, 0xB6, 0xAB, 0x10, 0x0D, 0x2A, 0x37, 0x64, 0x79, 0x5E, 0x43,
    0xB2, 0xAF, 0x88, 0x95, 0xC6, 0xDB, 0xFC, 0xE1, 0x5A, 0x47, 0x60, 0x7D, 0x2E, 0x33, 0x14, 0x09,
    0x7F, 0x62, 0x45, 0x58, 0x0B, 0x16, 0x31, 0x2C, 0x97, 0x8A, 0xAD, 0xB0, 0xE3, 0xFE, 0xD9, 0xC4
};
/*$F
 ===============================================================================
 *    A2DP specification Adopted version 1.0: Appendix B, Section 12.6.1.1 Page 56
 *    CRC Check:
 *    The error detection method used is "CRC-8" with generator polynomial
 *
 *           G(X) = X8 + X4 + X3 + X2 + 1 (CRC-8)
 *
 *           i.e. [1:0001:1101] => Polynomial is 0x1D
 *
 *    Reference: ftp://ftp.adelaide.edu.au/pub/rocksoft/crc_v3.txt
 ===============================================================================
 */
UWord8 crc8(const UWord8 *data, UInt len)
{
    /********************************************************************************
     * For loop need to be optimized and number of local variable should be reduced *
     ********************************************************************************/
    /*~~~~~~~~~~~~~~~~~~~~~~~~*/
    UWord8  CrcReg = CRC_INIT;
    UInt    nBytes = len >> 3;  /* len/8 */
    UInt    nBits = len & 0x7;  /* len%8 */
    UInt    i;
    UWord8  octet;
    UWord8  bit;
    /*~~~~~~~~~~~~~~~~~~~~~~~~*/

    for (i = 0; i < nBytes; i++)
    {
        CrcReg = crctable[CrcReg ^ data[i]];
    }

    octet = data[i];

    for (i = 0; i < nBits; i++)
    {
        bit = (UWord8)(((octet ^ CrcReg) & 0x80) >> 7);

        CrcReg = (UWord8)(((CrcReg & 0x7F) << 1) ^(bit ? CRC_POLY : 0));

        octet = (UWord8)(octet << 1);
    }

    return(CrcReg);
}

#else /* USE_CRC_TABLE */

UWord8 crc8(const UWord8 *data, UInt len)
{
    ;
}
#endif /* USE_CRC_TABLE */
