/* ------------------------------------------------------------------
 * Copyright (C) 1998-2009 PacketVideo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 * -------------------------------------------------------------------
 */
/*********************************************************************************/
/*     -------------------------------------------------------------------       */
/*                      MPEG-4 ChunkLargeOffsetAtom Class                        */
/*     -------------------------------------------------------------------       */
/*********************************************************************************/
/*
    This ChunkLargeOffsetAtom Class gives the index of each chunk into the
    containing file.
*/


#ifndef CHUNKLARGEOFFSETATOM_H_INCLUDED
#define CHUNKLARGEOFFSETATOM_H_INCLUDED

#ifndef OSCL_FILE_IO_H_INCLUDED
#include "oscl_file_io.h"
#endif

#ifndef FULLATOM_H_INCLUDED
#include "fullatom.h"
#endif

class ChunkLargeOffsetAtom : public FullAtom
{

    public:
        ChunkLargeOffsetAtom(uint8 version, uint32 flags); // Constructor
        ChunkLargeOffsetAtom(ChunkLargeOffsetAtom atom); // Copy Constructor
        virtual ~ChunkLargeOffsetAtom();

        // Member gets and sets
        uint32 getEntryCount()
        {
            return _entryCount;
        }
        void setEntryCount(uint32 count)
        {
            _entryCount = count;
        }

        // Adding to and getting first chunk offset values
        void addChunkOffset(uint64 offset);
        vector<uint64>* getChunkOffsets()
        {
            return _pchunkOffsets;
        }

        // Rendering the Atom in proper format (bitlengths, etc.) to an ostream
        virtual void renderToFileStream(ofstream &os);
        // Reading in the Atom components from an input stream
        virtual void readFromFileStream(ifstream &is);


    private:
        uint32 _entryCount;
        vector<uint64>* _pchunkOffsets;

};


#endif // CHUNKLARGEOFFSETATOM_H_INCLUDED
