/*!****************************************************************************

 @file         PVRTMathTable.h
 @copyright    Copyright (c) Imagination Technologies Limited.
 @brief        Trigonometric lookup table. 
 @details      This is a low-precision lookup table that should only be used 
               for trigonometric operations that do not require high precision.

******************************************************************************/
#ifndef _TRIGTABLE
#define _TRIGTABLE

/*! 
 @def   NUM_ENTRIES
 @brief Define number of entries in table = 1024
*/
#define NUM_ENTRIES 1024

// Fixed-point lookup tables for all trigonometric functions */

 /*! @brief COS value lookup table */
const int cos_val[]={
(int)0x00010000,(int)0x0000FFFE,(int)0x0000FFFB,(int)0x0000FFF4,(int)0x0000FFEC,(int)0x0000FFE1,(int)0x0000FFD3,(int)0x0000FFC3,(int)0x0000FFB0,(int)0x0000FF9B,
(int)0x0000FF84,(int)0x0000FF6A,(int)0x0000FF4E,(int)0x0000FF2F,(int)0x0000FF0D,(int)0x0000FEEA,(int)0x0000FEC3,(int)0x0000FE9B,(int)0x0000FE6F,(int)0x0000FE42,
(int)0x0000FE12,(int)0x0000FDDF,(int)0x0000FDAA,(int)0x0000FD73,(int)0x0000FD39,(int)0x0000FCFC,(int)0x0000FCBE,(int)0x0000FC7C,(int)0x0000FC39,(int)0x0000FBF3,
(int)0x0000FBAA,(int)0x0000FB5F,(int)0x0000FB12,(int)0x0000FAC2,(int)0x0000FA70,(int)0x0000FA1B,(int)0x0000F9C4,(int)0x0000F96B,(int)0x0000F90F,(int)0x0000F8B0,
(int)0x0000F850,(int)0x0000F7ED,(int)0x0000F787,(int)0x0000F71F,(int)0x0000F6B5,(int)0x0000F648,(int)0x0000F5D9,(int)0x0000F568,(int)0x0000F4F4,(int)0x0000F47E,
(int)0x0000F405,(int)0x0000F38B,(int)0x0000F30D,(int)0x0000F28E,(int)0x0000F20C,(int)0x0000F188,(int)0x0000F101,(int)0x0000F078,(int)0x0000EFED,(int)0x0000EF5F,
(int)0x0000EED0,(int)0x0000EE3D,(int)0x0000EDA9,(int)0x0000ED12,(int)0x0000EC79,(int)0x0000EBDE,(int)0x0000EB40,(int)0x0000EAA0,(int)0x0000E9FE,(int)0x0000E95A,
(int)0x0000E8B3,(int)0x0000E80A,(int)0x0000E75F,(int)0x0000E6B2,(int)0x0000E602,(int)0x0000E550,(int)0x0000E49C,(int)0x0000E3E6,(int)0x0000E32E,(int)0x0000E273,
(int)0x0000E1B6,(int)0x0000E0F7,(int)0x0000E036,(int)0x0000DF73,(int)0x0000DEAD,(int)0x0000DDE6,(int)0x0000DD1C,(int)0x0000DC50,(int)0x0000DB82,(int)0x0000DAB2,
(int)0x0000D9DF,(int)0x0000D90B,(int)0x0000D834,(int)0x0000D75C,(int)0x0000D681,(int)0x0000D5A5,(int)0x0000D4C6,(int)0x0000D3E5,(int)0x0000D302,(int)0x0000D21D,
(int)0x0000D136,(int)0x0000D04D,(int)0x0000CF62,(int)0x0000CE75,(int)0x0000CD86,(int)0x0000CC95,(int)0x0000CBA2,(int)0x0000CAAD,(int)0x0000C9B6,(int)0x0000C8BE,
(int)0x0000C7C3,(int)0x0000C6C6,(int)0x0000C5C8,(int)0x0000C4C7,(int)0x0000C3C5,(int)0x0000C2C0,(int)0x0000C1BA,(int)0x0000C0B2,(int)0x0000BFA8,(int)0x0000BE9C,
(int)0x0000BD8F,(int)0x0000BC7F,(int)0x0000BB6E,(int)0x0000BA5B,(int)0x0000B946,(int)0x0000B82F,(int)0x0000B717,(int)0x0000B5FD,(int)0x0000B4E1,(int)0x0000B3C3,
(int)0x0000B2A4,(int)0x0000B183,(int)0x0000B060,(int)0x0000AF3B,(int)0x0000AE15,(int)0x0000ACED,(int)0x0000ABC3,(int)0x0000AA98,(int)0x0000A96B,(int)0x0000A83C,
(int)0x0000A70C,(int)0x0000A5DA,(int)0x0000A4A7,(int)0x0000A372,(int)0x0000A23B,(int)0x0000A103,(int)0x00009FC9,(int)0x00009E8E,(int)0x00009D51,(int)0x00009C13,
(int)0x00009AD3,(int)0x00009992,(int)0x0000984F,(int)0x0000970B,(int)0x000095C5,(int)0x0000947E,(int)0x00009336,(int)0x000091EB,(int)0x000090A0,(int)0x00008F53,
(int)0x00008E05,(int)0x00008CB5,(int)0x00008B65,(int)0x00008A12,(int)0x000088BF,(int)0x0000876A,(int)0x00008613,(int)0x000084BC,(int)0x00008363,(int)0x00008209,
(int)0x000080AE,(int)0x00007F51,(int)0x00007DF3,(int)0x00007C94,(int)0x00007B34,(int)0x000079D3,(int)0x00007870,(int)0x0000770C,(int)0x000075A7,(int)0x00007441,
(int)0x000072DA,(int)0x00007172,(int)0x00007008,(int)0x00006E9E,(int)0x00006D32,(int)0x00006BC6,(int)0x00006A58,(int)0x000068E9,(int)0x0000677A,(int)0x00006609,
(int)0x00006498,(int)0x00006325,(int)0x000061B1,(int)0x0000603D,(int)0x00005EC7,(int)0x00005D51,(int)0x00005BDA,(int)0x00005A62,(int)0x000058E8,(int)0x0000576F,
(int)0x000055F4,(int)0x00005478,(int)0x000052FC,(int)0x0000517F,(int)0x00005001,(int)0x00004E82,(int)0x00004D03,(int)0x00004B82,(int)0x00004A01,(int)0x00004880,
(int)0x000046FD,(int)0x0000457A,(int)0x000043F6,(int)0x00004272,(int)0x000040ED,(int)0x00003F67,(int)0x00003DE1,(int)0x00003C5A,(int)0x00003AD3,(int)0x0000394B,
(int)0x000037C2,(int)0x00003639,(int)0x000034AF,(int)0x00003325,(int)0x0000319B,(int)0x0000300F,(int)0x00002E84,(int)0x00002CF8,(int)0x00002B6B,(int)0x000029DE,
(int)0x00002851,(int)0x000026C3,(int)0x00002535,(int)0x000023A7,(int)0x00002218,(int)0x00002089,(int)0x00001EFA,(int)0x00001D6A,(int)0x00001BDA,(int)0x00001A4A,
(int)0x000018B9,(int)0x00001729,(int)0x00001598,(int)0x00001406,(int)0x00001275,(int)0x000010E3,(int)0x00000F52,(int)0x00000DC0,(int)0x00000C2E,(int)0x00000A9C,
(int)0x00000909,(int)0x00000777,(int)0x000005E5,(int)0x00000452,(int)0x000002C0,(int)0x0000012D,(int)0xFFFFFF9C,(int)0xFFFFFE09,(int)0xFFFFFC77,(int)0xFFFFFAE4,
(int)0xFFFFF952,(int)0xFFFFF7C0,(int)0xFFFFF62D,(int)0xFFFFF49B,(int)0xFFFFF309,(int)0xFFFFF177,(int)0xFFFFEFE5,(int)0xFFFFEE54,(int)0xFFFFECC2,(int)0xFFFFEB31,
(int)0xFFFFE9A0,(int)0xFFFFE80F,(int)0xFFFFE67E,(int)0xFFFFE4EE,(int)0xFFFFE35E,(int)0xFFFFE1CE,(int)0xFFFFE03F,(int)0xFFFFDEAF,(int)0xFFFFDD20,(int)0xFFFFDB92,
(int)0xFFFFDA04,(int)0xFFFFD876,(int)0xFFFFD6E8,(int)0xFFFFD55B,(int)0xFFFFD3CE,(int)0xFFFFD242,(int)0xFFFFD0B6,(int)0xFFFFCF2B,(int)0xFFFFCDA0,(int)0xFFFFCC16,
(int)0xFFFFCA8C,(int)0xFFFFC902,(int)0xFFFFC77A,(int)0xFFFFC5F1,(int)0xFFFFC469,(int)0xFFFFC2E2,(int)0xFFFFC15C,(int)0xFFFFBFD6,(int)0xFFFFBE50,(int)0xFFFFBCCC,
(int)0xFFFFBB48,(int)0xFFFFB9C4,(int)0xFFFFB841,(int)0xFFFFB6BF,(int)0xFFFFB53E,(int)0xFFFFB3BD,(int)0xFFFFB23E,(int)0xFFFFB0BE,(int)0xFFFFAF40,(int)0xFFFFADC3,
(int)0xFFFFAC46,(int)0xFFFFAACA,(int)0xFFFFA94F,(int)0xFFFFA7D4,(int)0xFFFFA65B,(int)0xFFFFA4E2,(int)0xFFFFA36B,(int)0xFFFFA1F4,(int)0xFFFFA07E,(int)0xFFFF9F09,
(int)0xFFFF9D95,(int)0xFFFF9C22,(int)0xFFFF9AB0,(int)0xFFFF993E,(int)0xFFFF97CE,(int)0xFFFF965F,(int)0xFFFF94F1,(int)0xFFFF9384,(int)0xFFFF9218,(int)0xFFFF90AD,
(int)0xFFFF8F43,(int)0xFFFF8DDA,(int)0xFFFF8C72,(int)0xFFFF8B0C,(int)0xFFFF89A6,(int)0xFFFF8842,(int)0xFFFF86DF,(int)0xFFFF857D,(int)0xFFFF841C,(int)0xFFFF82BC,
(int)0xFFFF815E,(int)0xFFFF8000,(int)0xFFFF7EA5,(int)0xFFFF7D4A,(int)0xFFFF7BF0,(int)0xFFFF7A98,(int)0xFFFF7941,(int)0xFFFF77EC,(int)0xFFFF7697,(int)0xFFFF7544,
(int)0xFFFF73F3,(int)0xFFFF72A3,(int)0xFFFF7154,(int)0xFFFF7006,(int)0xFFFF6EBA,(int)0xFFFF6D6F,(int)0xFFFF6C26,(int)0xFFFF6ADE,(int)0xFFFF6998,(int)0xFFFF6853,
(int)0xFFFF670F,(int)0xFFFF65CD,(int)0xFFFF648D,(int)0xFFFF634E,(int)0xFFFF6210,(int)0xFFFF60D4,(int)0xFFFF5F99,(int)0xFFFF5E61,(int)0xFFFF5D29,(int)0xFFFF5BF3,
(int)0xFFFF5ABF,(int)0xFFFF598D,(int)0xFFFF585C,(int)0xFFFF572C,(int)0xFFFF55FE,(int)0xFFFF54D2,(int)0xFFFF53A8,(int)0xFFFF527F,(int)0xFFFF5158,(int)0xFFFF5032,
(int)0xFFFF4F0F,(int)0xFFFF4DED,(int)0xFFFF4CCC,(int)0xFFFF4BAE,(int)0xFFFF4A91,(int)0xFFFF4976,(int)0xFFFF485D,(int)0xFFFF4745,(int)0xFFFF462F,(int)0xFFFF451B,
(int)0xFFFF4409,(int)0xFFFF42F9,(int)0xFFFF41EA,(int)0xFFFF40DD,(int)0xFFFF3FD3,(int)0xFFFF3ECA,(int)0xFFFF3DC3,(int)0xFFFF3CBD,(int)0xFFFF3BBA,(int)0xFFFF3AB8,
(int)0xFFFF39B9,(int)0xFFFF38BB,(int)0xFFFF37C0,(int)0xFFFF36C6,(int)0xFFFF35CE,(int)0xFFFF34D8,(int)0xFFFF33E4,(int)0xFFFF32F2,(int)0xFFFF3202,(int)0xFFFF3114,
(int)0xFFFF3028,(int)0xFFFF2F3E,(int)0xFFFF2E56,(int)0xFFFF2D70,(int)0xFFFF2C8C,(int)0xFFFF2BAA,(int)0xFFFF2ACB,(int)0xFFFF29ED,(int)0xFFFF2911,(int)0xFFFF2838,
(int)0xFFFF2760,(int)0xFFFF268B,(int)0xFFFF25B7,(int)0xFFFF24E6,(int)0xFFFF2417,(int)0xFFFF234A,(int)0xFFFF227F,(int)0xFFFF21B6,(int)0xFFFF20F0,(int)0xFFFF202B,
(int)0xFFFF1F69,(int)0xFFFF1EA9,(int)0xFFFF1DEB,(int)0xFFFF1D2F,(int)0xFFFF1C76,(int)0xFFFF1BBE,(int)0xFFFF1B09,(int)0xFFFF1A56,(int)0xFFFF19A6,(int)0xFFFF18F7,
(int)0xFFFF184B,(int)0xFFFF17A1,(int)0xFFFF16F9,(int)0xFFFF1654,(int)0xFFFF15B0,(int)0xFFFF150F,(int)0xFFFF1471,(int)0xFFFF13D4,(int)0xFFFF133A,(int)0xFFFF12A2,
(int)0xFFFF120C,(int)0xFFFF1179,(int)0xFFFF10E8,(int)0xFFFF1059,(int)0xFFFF0FCD,(int)0xFFFF0F43,(int)0xFFFF0EBB,(int)0xFFFF0E36,(int)0xFFFF0DB3,(int)0xFFFF0D32,
(int)0xFFFF0CB4,(int)0xFFFF0C38,(int)0xFFFF0BBE,(int)0xFFFF0B47,(int)0xFFFF0AD2,(int)0xFFFF0A5F,(int)0xFFFF09EF,(int)0xFFFF0981,(int)0xFFFF0916,(int)0xFFFF08AD,
(int)0xFFFF0846,(int)0xFFFF07E2,(int)0xFFFF0780,(int)0xFFFF0720,(int)0xFFFF06C3,(int)0xFFFF0668,(int)0xFFFF0610,(int)0xFFFF05BA,(int)0xFFFF0567,(int)0xFFFF0516,
(int)0xFFFF04C7,(int)0xFFFF047B,(int)0xFFFF0431,(int)0xFFFF03EA,(int)0xFFFF03A5,(int)0xFFFF0363,(int)0xFFFF0323,(int)0xFFFF02E5,(int)0xFFFF02AA,(int)0xFFFF0271,
(int)0xFFFF023B,(int)0xFFFF0207,(int)0xFFFF01D6,(int)0xFFFF01A7,(int)0xFFFF017B,(int)0xFFFF0151,(int)0xFFFF0129,(int)0xFFFF0104,(int)0xFFFF00E2,(int)0xFFFF00C2,
(int)0xFFFF00A4,(int)0xFFFF0089,(int)0xFFFF0070,(int)0xFFFF005A,(int)0xFFFF0046,(int)0xFFFF0035,(int)0xFFFF0026,(int)0xFFFF001A,(int)0xFFFF0010,(int)0xFFFF0008,
(int)0xFFFF0003,(int)0xFFFF0001,(int)0xFFFF0001,(int)0xFFFF0003,(int)0xFFFF0008,(int)0xFFFF0010,(int)0xFFFF001A,(int)0xFFFF0026,(int)0xFFFF0035,(int)0xFFFF0046,
(int)0xFFFF005A,(int)0xFFFF0070,(int)0xFFFF0089,(int)0xFFFF00A4,(int)0xFFFF00C2,(int)0xFFFF00E2,(int)0xFFFF0104,(int)0xFFFF0129,(int)0xFFFF0151,(int)0xFFFF017B,
(int)0xFFFF01A7,(int)0xFFFF01D6,(int)0xFFFF0207,(int)0xFFFF023B,(int)0xFFFF0271,(int)0xFFFF02AA,(int)0xFFFF02E5,(int)0xFFFF0323,(int)0xFFFF0363,(int)0xFFFF03A5,
(int)0xFFFF03EA,(int)0xFFFF0431,(int)0xFFFF047B,(int)0xFFFF04C7,(int)0xFFFF0516,(int)0xFFFF0567,(int)0xFFFF05BA,(int)0xFFFF0610,(int)0xFFFF0668,(int)0xFFFF06C3,
(int)0xFFFF0720,(int)0xFFFF0780,(int)0xFFFF07E2,(int)0xFFFF0846,(int)0xFFFF08AD,(int)0xFFFF0916,(int)0xFFFF0981,(int)0xFFFF09EF,(int)0xFFFF0A5F,(int)0xFFFF0AD2,
(int)0xFFFF0B47,(int)0xFFFF0BBE,(int)0xFFFF0C38,(int)0xFFFF0CB4,(int)0xFFFF0D32,(int)0xFFFF0DB3,(int)0xFFFF0E36,(int)0xFFFF0EBB,(int)0xFFFF0F43,(int)0xFFFF0FCD,
(int)0xFFFF1059,(int)0xFFFF10E8,(int)0xFFFF1179,(int)0xFFFF120C,(int)0xFFFF12A2,(int)0xFFFF133A,(int)0xFFFF13D4,(int)0xFFFF1471,(int)0xFFFF150F,(int)0xFFFF15B0,
(int)0xFFFF1654,(int)0xFFFF16F9,(int)0xFFFF17A1,(int)0xFFFF184B,(int)0xFFFF18F7,(int)0xFFFF19A6,(int)0xFFFF1A56,(int)0xFFFF1B09,(int)0xFFFF1BBE,(int)0xFFFF1C76,
(int)0xFFFF1D2F,(int)0xFFFF1DEB,(int)0xFFFF1EA9,(int)0xFFFF1F69,(int)0xFFFF202B,(int)0xFFFF20F0,(int)0xFFFF21B6,(int)0xFFFF227F,(int)0xFFFF234A,(int)0xFFFF2417,
(int)0xFFFF24E6,(int)0xFFFF25B7,(int)0xFFFF268B,(int)0xFFFF2760,(int)0xFFFF2838,(int)0xFFFF2911,(int)0xFFFF29ED,(int)0xFFFF2ACB,(int)0xFFFF2BAA,(int)0xFFFF2C8C,
(int)0xFFFF2D70,(int)0xFFFF2E56,(int)0xFFFF2F3E,(int)0xFFFF3028,(int)0xFFFF3114,(int)0xFFFF3202,(int)0xFFFF32F2,(int)0xFFFF33E4,(int)0xFFFF34D8,(int)0xFFFF35CE,
(int)0xFFFF36C6,(int)0xFFFF37C0,(int)0xFFFF38BB,(int)0xFFFF39B9,(int)0xFFFF3AB8,(int)0xFFFF3BBA,(int)0xFFFF3CBD,(int)0xFFFF3DC3,(int)0xFFFF3ECA,(int)0xFFFF3FD3,
(int)0xFFFF40DD,(int)0xFFFF41EA,(int)0xFFFF42F9,(int)0xFFFF4409,(int)0xFFFF451B,(int)0xFFFF462F,(int)0xFFFF4745,(int)0xFFFF485D,(int)0xFFFF4976,(int)0xFFFF4A91,
(int)0xFFFF4BAE,(int)0xFFFF4CCC,(int)0xFFFF4DED,(int)0xFFFF4F0F,(int)0xFFFF5032,(int)0xFFFF5158,(int)0xFFFF527F,(int)0xFFFF53A8,(int)0xFFFF54D2,(int)0xFFFF55FE,
(int)0xFFFF572C,(int)0xFFFF585C,(int)0xFFFF598D,(int)0xFFFF5ABF,(int)0xFFFF5BF3,(int)0xFFFF5D29,(int)0xFFFF5E61,(int)0xFFFF5F99,(int)0xFFFF60D4,(int)0xFFFF6210,
(int)0xFFFF634E,(int)0xFFFF648D,(int)0xFFFF65CD,(int)0xFFFF670F,(int)0xFFFF6853,(int)0xFFFF6998,(int)0xFFFF6ADE,(int)0xFFFF6C26,(int)0xFFFF6D6F,(int)0xFFFF6EBA,
(int)0xFFFF7006,(int)0xFFFF7154,(int)0xFFFF72A3,(int)0xFFFF73F3,(int)0xFFFF7544,(int)0xFFFF7697,(int)0xFFFF77EC,(int)0xFFFF7941,(int)0xFFFF7A98,(int)0xFFFF7BF0,
(int)0xFFFF7D4A,(int)0xFFFF7EA5,(int)0xFFFF8001,(int)0xFFFF815E,(int)0xFFFF82BC,(int)0xFFFF841C,(int)0xFFFF857D,(int)0xFFFF86DF,(int)0xFFFF8842,(int)0xFFFF89A6,
(int)0xFFFF8B0C,(int)0xFFFF8C72,(int)0xFFFF8DDA,(int)0xFFFF8F43,(int)0xFFFF90AD,(int)0xFFFF9218,(int)0xFFFF9384,(int)0xFFFF94F1,(int)0xFFFF965F,(int)0xFFFF97CE,
(int)0xFFFF993E,(int)0xFFFF9AB0,(int)0xFFFF9C22,(int)0xFFFF9D95,(int)0xFFFF9F09,(int)0xFFFFA07E,(int)0xFFFFA1F4,(int)0xFFFFA36B,(int)0xFFFFA4E2,(int)0xFFFFA65B,
(int)0xFFFFA7D4,(int)0xFFFFA94F,(int)0xFFFFAACA,(int)0xFFFFAC46,(int)0xFFFFADC3,(int)0xFFFFAF40,(int)0xFFFFB0BE,(int)0xFFFFB23E,(int)0xFFFFB3BD,(int)0xFFFFB53E,
(int)0xFFFFB6BF,(int)0xFFFFB841,(int)0xFFFFB9C4,(int)0xFFFFBB48,(int)0xFFFFBCCC,(int)0xFFFFBE50,(int)0xFFFFBFD6,(int)0xFFFFC15C,(int)0xFFFFC2E2,(int)0xFFFFC469,
(int)0xFFFFC5F1,(int)0xFFFFC77A,(int)0xFFFFC902,(int)0xFFFFCA8C,(int)0xFFFFCC16,(int)0xFFFFCDA0,(int)0xFFFFCF2B,(int)0xFFFFD0B6,(int)0xFFFFD242,(int)0xFFFFD3CE,
(int)0xFFFFD55B,(int)0xFFFFD6E8,(int)0xFFFFD876,(int)0xFFFFDA04,(int)0xFFFFDB92,(int)0xFFFFDD20,(int)0xFFFFDEAF,(int)0xFFFFE03F,(int)0xFFFFE1CE,(int)0xFFFFE35E,
(int)0xFFFFE4EE,(int)0xFFFFE67E,(int)0xFFFFE80F,(int)0xFFFFE9A0,(int)0xFFFFEB31,(int)0xFFFFECC2,(int)0xFFFFEE54,(int)0xFFFFEFE5,(int)0xFFFFF177,(int)0xFFFFF309,
(int)0xFFFFF49B,(int)0xFFFFF62D,(int)0xFFFFF7C0,(int)0xFFFFF952,(int)0xFFFFFAE4,(int)0xFFFFFC77,(int)0xFFFFFE09,(int)0xFFFFFF9C,(int)0x0000012D,(int)0x000002C0,
(int)0x00000452,(int)0x000005E5,(int)0x00000777,(int)0x00000909,(int)0x00000A9C,(int)0x00000C2E,(int)0x00000DC0,(int)0x00000F52,(int)0x000010E3,(int)0x00001275,
(int)0x00001406,(int)0x00001598,(int)0x00001729,(int)0x000018B9,(int)0x00001A4A,(int)0x00001BDA,(int)0x00001D6A,(int)0x00001EFA,(int)0x00002089,(int)0x00002218,
(int)0x000023A7,(int)0x00002535,(int)0x000026C3,(int)0x00002851,(int)0x000029DE,(int)0x00002B6B,(int)0x00002CF8,(int)0x00002E84,(int)0x0000300F,(int)0x0000319B,
(int)0x00003325,(int)0x000034AF,(int)0x00003639,(int)0x000037C2,(int)0x0000394B,(int)0x00003AD3,(int)0x00003C5A,(int)0x00003DE1,(int)0x00003F67,(int)0x000040ED,
(int)0x00004272,(int)0x000043F6,(int)0x0000457A,(int)0x000046FD,(int)0x00004880,(int)0x00004A01,(int)0x00004B82,(int)0x00004D03,(int)0x00004E82,(int)0x00005001,
(int)0x0000517F,(int)0x000052FC,(int)0x00005478,(int)0x000055F4,(int)0x0000576F,(int)0x000058E9,(int)0x00005A62,(int)0x00005BDA,(int)0x00005D51,(int)0x00005EC7,
(int)0x0000603D,(int)0x000061B1,(int)0x00006325,(int)0x00006498,(int)0x00006609,(int)0x0000677A,(int)0x000068EA,(int)0x00006A58,(int)0x00006BC6,(int)0x00006D32,
(int)0x00006E9E,(int)0x00007008,(int)0x00007172,(int)0x000072DA,(int)0x00007441,(int)0x000075A7,(int)0x0000770C,(int)0x00007870,(int)0x000079D3,(int)0x00007B34,
(int)0x00007C94,(int)0x00007DF3,(int)0x00007F51,(int)0x000080AE,(int)0x00008209,(int)0x00008363,(int)0x000084BC,(int)0x00008613,(int)0x0000876A,(int)0x000088BF,
(int)0x00008A12,(int)0x00008B65,(int)0x00008CB5,(int)0x00008E05,(int)0x00008F53,(int)0x000090A0,(int)0x000091EC,(int)0x00009336,(int)0x0000947E,(int)0x000095C5,
(int)0x0000970B,(int)0x0000984F,(int)0x00009992,(int)0x00009AD3,(int)0x00009C13,(int)0x00009D51,(int)0x00009E8E,(int)0x00009FC9,(int)0x0000A103,(int)0x0000A23B,
(int)0x0000A372,(int)0x0000A4A7,(int)0x0000A5DA,(int)0x0000A70C,(int)0x0000A83C,(int)0x0000A96B,(int)0x0000AA98,(int)0x0000ABC3,(int)0x0000ACED,(int)0x0000AE15,
(int)0x0000AF3B,(int)0x0000B060,(int)0x0000B183,(int)0x0000B2A4,(int)0x0000B3C3,(int)0x0000B4E1,(int)0x0000B5FD,(int)0x0000B717,(int)0x0000B82F,(int)0x0000B946,
(int)0x0000BA5B,(int)0x0000BB6E,(int)0x0000BC7F,(int)0x0000BD8F,(int)0x0000BE9C,(int)0x0000BFA8,(int)0x0000C0B2,(int)0x0000C1BA,(int)0x0000C2C0,(int)0x0000C3C5,
(int)0x0000C4C7,(int)0x0000C5C8,(int)0x0000C6C6,(int)0x0000C7C3,(int)0x0000C8BE,(int)0x0000C9B6,(int)0x0000CAAD,(int)0x0000CBA2,(int)0x0000CC95,(int)0x0000CD86,
(int)0x0000CE75,(int)0x0000CF62,(int)0x0000D04D,(int)0x0000D136,(int)0x0000D21D,(int)0x0000D302,(int)0x0000D3E5,(int)0x0000D4C6,(int)0x0000D5A5,(int)0x0000D681,
(int)0x0000D75C,(int)0x0000D834,(int)0x0000D90B,(int)0x0000D9DF,(int)0x0000DAB2,(int)0x0000DB82,(int)0x0000DC50,(int)0x0000DD1C,(int)0x0000DDE6,(int)0x0000DEAD,
(int)0x0000DF73,(int)0x0000E036,(int)0x0000E0F7,(int)0x0000E1B6,(int)0x0000E273,(int)0x0000E32E,(int)0x0000E3E6,(int)0x0000E49C,(int)0x0000E550,(int)0x0000E602,
(int)0x0000E6B2,(int)0x0000E75F,(int)0x0000E80A,(int)0x0000E8B3,(int)0x0000E95A,(int)0x0000E9FE,(int)0x0000EAA0,(int)0x0000EB40,(int)0x0000EBDE,(int)0x0000EC79,
(int)0x0000ED12,(int)0x0000EDA9,(int)0x0000EE3D,(int)0x0000EED0,(int)0x0000EF5F,(int)0x0000EFED,(int)0x0000F078,(int)0x0000F101,(int)0x0000F188,(int)0x0000F20C,
(int)0x0000F28E,(int)0x0000F30D,(int)0x0000F38B,(int)0x0000F405,(int)0x0000F47E,(int)0x0000F4F4,(int)0x0000F568,(int)0x0000F5D9,(int)0x0000F648,(int)0x0000F6B5,
(int)0x0000F71F,(int)0x0000F787,(int)0x0000F7ED,(int)0x0000F850,(int)0x0000F8B0,(int)0x0000F90F,(int)0x0000F96B,(int)0x0000F9C4,(int)0x0000FA1B,(int)0x0000FA70,
(int)0x0000FAC2,(int)0x0000FB12,(int)0x0000FB5F,(int)0x0000FBAA,(int)0x0000FBF3,(int)0x0000FC39,(int)0x0000FC7C,(int)0x0000FCBE,(int)0x0000FCFC,(int)0x0000FD39,
(int)0x0000FD73,(int)0x0000FDAA,(int)0x0000FDDF,(int)0x0000FE12,(int)0x0000FE42,(int)0x0000FE6F,(int)0x0000FE9B,(int)0x0000FEC3,(int)0x0000FEEA,(int)0x0000FF0D,
(int)0x0000FF2F,(int)0x0000FF4E,(int)0x0000FF6A,(int)0x0000FF84,(int)0x0000FF9B,(int)0x0000FFB0,(int)0x0000FFC3,(int)0x0000FFD3,(int)0x0000FFE1,(int)0x0000FFEC,
(int)0x0000FFF4,(int)0x0000FFFB,(int)0x0000FFFE,(int)0x00010000,
0};

 /*! @brief SIN value lookup table */
const int sin_val[]={
(int)0x00000000,(int)0x00000192,(int)0x00000325,(int)0x000004B7,(int)0x00000649,(int)0x000007DC,(int)0x0000096E,(int)0x00000B00,(int)0x00000C92,(int)0x00000E24,
(int)0x00000FB6,(int)0x00001148,(int)0x000012D9,(int)0x0000146B,(int)0x000015FC,(int)0x0000178D,(int)0x0000191D,(int)0x00001AAE,(int)0x00001C3E,(int)0x00001DCE,
(int)0x00001F5E,(int)0x000020ED,(int)0x0000227C,(int)0x0000240B,(int)0x00002599,(int)0x00002727,(int)0x000028B5,(int)0x00002A42,(int)0x00002BCF,(int)0x00002D5B,
(int)0x00002EE7,(int)0x00003072,(int)0x000031FD,(int)0x00003388,(int)0x00003512,(int)0x0000369B,(int)0x00003824,(int)0x000039AD,(int)0x00003B35,(int)0x00003CBC,
(int)0x00003E43,(int)0x00003FC9,(int)0x0000414E,(int)0x000042D3,(int)0x00004457,(int)0x000045DB,(int)0x0000475E,(int)0x000048E0,(int)0x00004A62,(int)0x00004BE2,
(int)0x00004D62,(int)0x00004EE2,(int)0x00005060,(int)0x000051DE,(int)0x0000535B,(int)0x000054D7,(int)0x00005653,(int)0x000057CD,(int)0x00005947,(int)0x00005AC0,
(int)0x00005C38,(int)0x00005DAF,(int)0x00005F25,(int)0x0000609A,(int)0x0000620E,(int)0x00006382,(int)0x000064F4,(int)0x00006665,(int)0x000067D6,(int)0x00006945,
(int)0x00006AB4,(int)0x00006C21,(int)0x00006D8D,(int)0x00006EF9,(int)0x00007063,(int)0x000071CC,(int)0x00007334,(int)0x0000749B,(int)0x00007601,(int)0x00007765,
(int)0x000078C9,(int)0x00007A2B,(int)0x00007B8C,(int)0x00007CEC,(int)0x00007E4B,(int)0x00007FA8,(int)0x00008105,(int)0x00008260,(int)0x000083B9,(int)0x00008512,
(int)0x00008669,(int)0x000087BF,(int)0x00008914,(int)0x00008A67,(int)0x00008BB9,(int)0x00008D09,(int)0x00008E59,(int)0x00008FA7,(int)0x000090F3,(int)0x0000923E,
(int)0x00009388,(int)0x000094D0,(int)0x00009617,(int)0x0000975C,(int)0x000098A0,(int)0x000099E2,(int)0x00009B23,(int)0x00009C63,(int)0x00009DA1,(int)0x00009EDD,
(int)0x0000A018,(int)0x0000A151,(int)0x0000A289,(int)0x0000A3BF,(int)0x0000A4F4,(int)0x0000A627,(int)0x0000A758,(int)0x0000A888,(int)0x0000A9B6,(int)0x0000AAE3,
(int)0x0000AC0E,(int)0x0000AD37,(int)0x0000AE5E,(int)0x0000AF84,(int)0x0000B0A9,(int)0x0000B1CB,(int)0x0000B2EC,(int)0x0000B40B,(int)0x0000B528,(int)0x0000B644,
(int)0x0000B75D,(int)0x0000B875,(int)0x0000B98C,(int)0x0000BAA0,(int)0x0000BBB3,(int)0x0000BCC3,(int)0x0000BDD2,(int)0x0000BEE0,(int)0x0000BFEB,(int)0x0000C0F4,
(int)0x0000C1FC,(int)0x0000C302,(int)0x0000C405,(int)0x0000C507,(int)0x0000C607,(int)0x0000C706,(int)0x0000C802,(int)0x0000C8FC,(int)0x0000C9F4,(int)0x0000CAEB,
(int)0x0000CBDF,(int)0x0000CCD2,(int)0x0000CDC2,(int)0x0000CEB1,(int)0x0000CF9D,(int)0x0000D088,(int)0x0000D170,(int)0x0000D256,(int)0x0000D33B,(int)0x0000D41D,
(int)0x0000D4FE,(int)0x0000D5DC,(int)0x0000D6B8,(int)0x0000D792,(int)0x0000D86A,(int)0x0000D940,(int)0x0000DA14,(int)0x0000DAE6,(int)0x0000DBB6,(int)0x0000DC83,
(int)0x0000DD4E,(int)0x0000DE18,(int)0x0000DEDF,(int)0x0000DFA4,(int)0x0000E067,(int)0x0000E127,(int)0x0000E1E6,(int)0x0000E2A2,(int)0x0000E35C,(int)0x0000E414,
(int)0x0000E4CA,(int)0x0000E57D,(int)0x0000E62E,(int)0x0000E6DD,(int)0x0000E78A,(int)0x0000E835,(int)0x0000E8DD,(int)0x0000E983,(int)0x0000EA27,(int)0x0000EAC9,
(int)0x0000EB68,(int)0x0000EC05,(int)0x0000ECA0,(int)0x0000ED38,(int)0x0000EDCE,(int)0x0000EE62,(int)0x0000EEF4,(int)0x0000EF83,(int)0x0000F010,(int)0x0000F09B,
(int)0x0000F123,(int)0x0000F1A9,(int)0x0000F22D,(int)0x0000F2AE,(int)0x0000F32D,(int)0x0000F3AA,(int)0x0000F424,(int)0x0000F49C,(int)0x0000F511,(int)0x0000F584,
(int)0x0000F5F5,(int)0x0000F664,(int)0x0000F6D0,(int)0x0000F739,(int)0x0000F7A1,(int)0x0000F806,(int)0x0000F868,(int)0x0000F8C8,(int)0x0000F926,(int)0x0000F981,
(int)0x0000F9DA,(int)0x0000FA30,(int)0x0000FA85,(int)0x0000FAD6,(int)0x0000FB25,(int)0x0000FB72,(int)0x0000FBBD,(int)0x0000FC04,(int)0x0000FC4A,(int)0x0000FC8D,
(int)0x0000FCCE,(int)0x0000FD0C,(int)0x0000FD47,(int)0x0000FD81,(int)0x0000FDB8,(int)0x0000FDEC,(int)0x0000FE1E,(int)0x0000FE4D,(int)0x0000FE7A,(int)0x0000FEA5,
(int)0x0000FECD,(int)0x0000FEF3,(int)0x0000FF16,(int)0x0000FF37,(int)0x0000FF55,(int)0x0000FF71,(int)0x0000FF8A,(int)0x0000FFA1,(int)0x0000FFB5,(int)0x0000FFC7,
(int)0x0000FFD7,(int)0x0000FFE4,(int)0x0000FFEE,(int)0x0000FFF6,(int)0x0000FFFC,(int)0x0000FFFF,(int)0x0000FFFF,(int)0x0000FFFE,(int)0x0000FFF9,(int)0x0000FFF2,
(int)0x0000FFE9,(int)0x0000FFDD,(int)0x0000FFCF,(int)0x0000FFBF,(int)0x0000FFAB,(int)0x0000FF96,(int)0x0000FF7E,(int)0x0000FF63,(int)0x0000FF46,(int)0x0000FF27,
(int)0x0000FF05,(int)0x0000FEE0,(int)0x0000FEB9,(int)0x0000FE90,(int)0x0000FE64,(int)0x0000FE36,(int)0x0000FE05,(int)0x0000FDD2,(int)0x0000FD9D,(int)0x0000FD64,
(int)0x0000FD2A,(int)0x0000FCED,(int)0x0000FCAE,(int)0x0000FC6C,(int)0x0000FC27,(int)0x0000FBE1,(int)0x0000FB98,(int)0x0000FB4C,(int)0x0000FAFE,(int)0x0000FAAE,
(int)0x0000FA5B,(int)0x0000FA06,(int)0x0000F9AE,(int)0x0000F954,(int)0x0000F8F7,(int)0x0000F898,(int)0x0000F837,(int)0x0000F7D3,(int)0x0000F76D,(int)0x0000F705,
(int)0x0000F69A,(int)0x0000F62D,(int)0x0000F5BD,(int)0x0000F54B,(int)0x0000F4D7,(int)0x0000F460,(int)0x0000F3E7,(int)0x0000F36B,(int)0x0000F2EE,(int)0x0000F26E,
(int)0x0000F1EB,(int)0x0000F166,(int)0x0000F0DF,(int)0x0000F056,(int)0x0000EFCA,(int)0x0000EF3C,(int)0x0000EEAB,(int)0x0000EE19,(int)0x0000ED84,(int)0x0000ECEC,
(int)0x0000EC53,(int)0x0000EBB7,(int)0x0000EB19,(int)0x0000EA78,(int)0x0000E9D5,(int)0x0000E930,(int)0x0000E889,(int)0x0000E7E0,(int)0x0000E734,(int)0x0000E686,
(int)0x0000E5D6,(int)0x0000E524,(int)0x0000E46F,(int)0x0000E3B8,(int)0x0000E2FF,(int)0x0000E244,(int)0x0000E187,(int)0x0000E0C7,(int)0x0000E005,(int)0x0000DF42,
(int)0x0000DE7C,(int)0x0000DDB3,(int)0x0000DCE9,(int)0x0000DC1D,(int)0x0000DB4E,(int)0x0000DA7D,(int)0x0000D9AA,(int)0x0000D8D6,(int)0x0000D7FF,(int)0x0000D725,
(int)0x0000D64A,(int)0x0000D56D,(int)0x0000D48E,(int)0x0000D3AC,(int)0x0000D2C9,(int)0x0000D1E4,(int)0x0000D0FC,(int)0x0000D013,(int)0x0000CF27,(int)0x0000CE3A,
(int)0x0000CD4A,(int)0x0000CC59,(int)0x0000CB65,(int)0x0000CA70,(int)0x0000C978,(int)0x0000C87F,(int)0x0000C784,(int)0x0000C687,(int)0x0000C588,(int)0x0000C487,
(int)0x0000C384,(int)0x0000C27F,(int)0x0000C178,(int)0x0000C070,(int)0x0000BF65,(int)0x0000BE59,(int)0x0000BD4B,(int)0x0000BC3B,(int)0x0000BB29,(int)0x0000BA16,
(int)0x0000B901,(int)0x0000B7EA,(int)0x0000B6D1,(int)0x0000B5B6,(int)0x0000B49A,(int)0x0000B37B,(int)0x0000B25C,(int)0x0000B13A,(int)0x0000B017,(int)0x0000AEF2,
(int)0x0000ADCB,(int)0x0000ACA3,(int)0x0000AB78,(int)0x0000AA4D,(int)0x0000A91F,(int)0x0000A7F0,(int)0x0000A6C0,(int)0x0000A58E,(int)0x0000A45A,(int)0x0000A324,
(int)0x0000A1ED,(int)0x0000A0B5,(int)0x00009F7B,(int)0x00009E3F,(int)0x00009D02,(int)0x00009BC3,(int)0x00009A83,(int)0x00009941,(int)0x000097FE,(int)0x000096BA,
(int)0x00009574,(int)0x0000942C,(int)0x000092E3,(int)0x00009199,(int)0x0000904D,(int)0x00008F00,(int)0x00008DB1,(int)0x00008C61,(int)0x00008B10,(int)0x000089BD,
(int)0x0000886A,(int)0x00008714,(int)0x000085BE,(int)0x00008466,(int)0x0000830D,(int)0x000081B2,(int)0x00008057,(int)0x00007EFA,(int)0x00007D9C,(int)0x00007C3C,
(int)0x00007ADC,(int)0x0000797A,(int)0x00007817,(int)0x000076B3,(int)0x0000754E,(int)0x000073E7,(int)0x00007280,(int)0x00007117,(int)0x00006FAE,(int)0x00006E43,
(int)0x00006CD7,(int)0x00006B6A,(int)0x000069FD,(int)0x0000688E,(int)0x0000671E,(int)0x000065AD,(int)0x0000643B,(int)0x000062C8,(int)0x00006154,(int)0x00005FDF,
(int)0x00005E6A,(int)0x00005CF3,(int)0x00005B7C,(int)0x00005A03,(int)0x0000588A,(int)0x00005710,(int)0x00005595,(int)0x00005419,(int)0x0000529D,(int)0x0000511F,
(int)0x00004FA1,(int)0x00004E22,(int)0x00004CA3,(int)0x00004B22,(int)0x000049A1,(int)0x0000481F,(int)0x0000469D,(int)0x00004519,(int)0x00004395,(int)0x00004211,
(int)0x0000408C,(int)0x00003F06,(int)0x00003D7F,(int)0x00003BF8,(int)0x00003A71,(int)0x000038E9,(int)0x00003760,(int)0x000035D7,(int)0x0000344D,(int)0x000032C3,
(int)0x00003138,(int)0x00002FAD,(int)0x00002E21,(int)0x00002C95,(int)0x00002B08,(int)0x0000297B,(int)0x000027EE,(int)0x00002660,(int)0x000024D2,(int)0x00002343,
(int)0x000021B4,(int)0x00002025,(int)0x00001E96,(int)0x00001D06,(int)0x00001B76,(int)0x000019E6,(int)0x00001855,(int)0x000016C4,(int)0x00001533,(int)0x000013A2,
(int)0x00001211,(int)0x0000107F,(int)0x00000EED,(int)0x00000D5B,(int)0x00000BC9,(int)0x00000A37,(int)0x000008A5,(int)0x00000713,(int)0x00000580,(int)0x000003EE,
(int)0x0000025B,(int)0x000000C9,(int)0xFFFFFF37,(int)0xFFFFFDA5,(int)0xFFFFFC12,(int)0xFFFFFA80,(int)0xFFFFF8ED,(int)0xFFFFF75B,(int)0xFFFFF5C9,(int)0xFFFFF437,
(int)0xFFFFF2A5,(int)0xFFFFF113,(int)0xFFFFEF81,(int)0xFFFFEDEF,(int)0xFFFFEC5E,(int)0xFFFFEACD,(int)0xFFFFE93C,(int)0xFFFFE7AB,(int)0xFFFFE61A,(int)0xFFFFE48A,
(int)0xFFFFE2FA,(int)0xFFFFE16A,(int)0xFFFFDFDB,(int)0xFFFFDE4C,(int)0xFFFFDCBD,(int)0xFFFFDB2E,(int)0xFFFFD9A0,(int)0xFFFFD812,(int)0xFFFFD685,(int)0xFFFFD4F8,
(int)0xFFFFD36B,(int)0xFFFFD1DF,(int)0xFFFFD053,(int)0xFFFFCEC8,(int)0xFFFFCD3D,(int)0xFFFFCBB3,(int)0xFFFFCA29,(int)0xFFFFC8A0,(int)0xFFFFC717,(int)0xFFFFC58F,
(int)0xFFFFC408,(int)0xFFFFC281,(int)0xFFFFC0FA,(int)0xFFFFBF74,(int)0xFFFFBDEF,(int)0xFFFFBC6B,(int)0xFFFFBAE7,(int)0xFFFFB963,(int)0xFFFFB7E1,(int)0xFFFFB65F,
(int)0xFFFFB4DE,(int)0xFFFFB35D,(int)0xFFFFB1DE,(int)0xFFFFB05F,(int)0xFFFFAEE1,(int)0xFFFFAD63,(int)0xFFFFABE7,(int)0xFFFFAA6B,(int)0xFFFFA8F0,(int)0xFFFFA776,
(int)0xFFFFA5FD,(int)0xFFFFA484,(int)0xFFFFA30D,(int)0xFFFFA196,(int)0xFFFFA020,(int)0xFFFF9EAC,(int)0xFFFF9D38,(int)0xFFFF9BC5,(int)0xFFFF9A53,(int)0xFFFF98E2,
(int)0xFFFF9772,(int)0xFFFF9603,(int)0xFFFF9496,(int)0xFFFF9329,(int)0xFFFF91BD,(int)0xFFFF9052,(int)0xFFFF8EE9,(int)0xFFFF8D80,(int)0xFFFF8C18,(int)0xFFFF8AB2,
(int)0xFFFF894D,(int)0xFFFF87E9,(int)0xFFFF8686,(int)0xFFFF8524,(int)0xFFFF83C4,(int)0xFFFF8264,(int)0xFFFF8106,(int)0xFFFF7FA9,(int)0xFFFF7E4E,(int)0xFFFF7CF3,
(int)0xFFFF7B9A,(int)0xFFFF7A42,(int)0xFFFF78EC,(int)0xFFFF7796,(int)0xFFFF7643,(int)0xFFFF74F0,(int)0xFFFF739F,(int)0xFFFF724F,(int)0xFFFF7100,(int)0xFFFF6FB3,
(int)0xFFFF6E67,(int)0xFFFF6D1D,(int)0xFFFF6BD4,(int)0xFFFF6A8C,(int)0xFFFF6946,(int)0xFFFF6802,(int)0xFFFF66BF,(int)0xFFFF657D,(int)0xFFFF643D,(int)0xFFFF62FE,
(int)0xFFFF61C1,(int)0xFFFF6085,(int)0xFFFF5F4B,(int)0xFFFF5E13,(int)0xFFFF5CDC,(int)0xFFFF5BA6,(int)0xFFFF5A72,(int)0xFFFF5940,(int)0xFFFF5810,(int)0xFFFF56E1,
(int)0xFFFF55B3,(int)0xFFFF5487,(int)0xFFFF535D,(int)0xFFFF5235,(int)0xFFFF510E,(int)0xFFFF4FE9,(int)0xFFFF4EC6,(int)0xFFFF4DA4,(int)0xFFFF4C85,(int)0xFFFF4B66,
(int)0xFFFF4A4A,(int)0xFFFF492F,(int)0xFFFF4816,(int)0xFFFF46FF,(int)0xFFFF45EA,(int)0xFFFF44D7,(int)0xFFFF43C5,(int)0xFFFF42B5,(int)0xFFFF41A7,(int)0xFFFF409B,
(int)0xFFFF3F90,(int)0xFFFF3E88,(int)0xFFFF3D81,(int)0xFFFF3C7C,(int)0xFFFF3B79,(int)0xFFFF3A78,(int)0xFFFF3979,(int)0xFFFF387C,(int)0xFFFF3781,(int)0xFFFF3688,
(int)0xFFFF3590,(int)0xFFFF349B,(int)0xFFFF33A7,(int)0xFFFF32B6,(int)0xFFFF31C6,(int)0xFFFF30D9,(int)0xFFFF2FED,(int)0xFFFF2F04,(int)0xFFFF2E1C,(int)0xFFFF2D37,
(int)0xFFFF2C54,(int)0xFFFF2B72,(int)0xFFFF2A93,(int)0xFFFF29B6,(int)0xFFFF28DB,(int)0xFFFF2801,(int)0xFFFF272A,(int)0xFFFF2656,(int)0xFFFF2583,(int)0xFFFF24B2,
(int)0xFFFF23E3,(int)0xFFFF2317,(int)0xFFFF224D,(int)0xFFFF2184,(int)0xFFFF20BE,(int)0xFFFF1FFB,(int)0xFFFF1F39,(int)0xFFFF1E79,(int)0xFFFF1DBC,(int)0xFFFF1D01,
(int)0xFFFF1C48,(int)0xFFFF1B91,(int)0xFFFF1ADC,(int)0xFFFF1A2A,(int)0xFFFF197A,(int)0xFFFF18CC,(int)0xFFFF1820,(int)0xFFFF1777,(int)0xFFFF16D0,(int)0xFFFF162B,
(int)0xFFFF1588,(int)0xFFFF14E7,(int)0xFFFF1449,(int)0xFFFF13AD,(int)0xFFFF1314,(int)0xFFFF127C,(int)0xFFFF11E7,(int)0xFFFF1155,(int)0xFFFF10C4,(int)0xFFFF1036,
(int)0xFFFF0FAA,(int)0xFFFF0F21,(int)0xFFFF0E9A,(int)0xFFFF0E15,(int)0xFFFF0D92,(int)0xFFFF0D12,(int)0xFFFF0C95,(int)0xFFFF0C19,(int)0xFFFF0BA0,(int)0xFFFF0B29,
(int)0xFFFF0AB5,(int)0xFFFF0A43,(int)0xFFFF09D3,(int)0xFFFF0966,(int)0xFFFF08FB,(int)0xFFFF0893,(int)0xFFFF082D,(int)0xFFFF07C9,(int)0xFFFF0768,(int)0xFFFF0709,
(int)0xFFFF06AC,(int)0xFFFF0652,(int)0xFFFF05FA,(int)0xFFFF05A5,(int)0xFFFF0552,(int)0xFFFF0502,(int)0xFFFF04B4,(int)0xFFFF0468,(int)0xFFFF041F,(int)0xFFFF03D9,
(int)0xFFFF0394,(int)0xFFFF0352,(int)0xFFFF0313,(int)0xFFFF02D6,(int)0xFFFF029C,(int)0xFFFF0263,(int)0xFFFF022E,(int)0xFFFF01FB,(int)0xFFFF01CA,(int)0xFFFF019C,
(int)0xFFFF0170,(int)0xFFFF0147,(int)0xFFFF0120,(int)0xFFFF00FB,(int)0xFFFF00D9,(int)0xFFFF00BA,(int)0xFFFF009D,(int)0xFFFF0082,(int)0xFFFF006A,(int)0xFFFF0055,
(int)0xFFFF0041,(int)0xFFFF0031,(int)0xFFFF0023,(int)0xFFFF0017,(int)0xFFFF000E,(int)0xFFFF0007,(int)0xFFFF0002,(int)0xFFFF0001,(int)0xFFFF0001,(int)0xFFFF0004,
(int)0xFFFF000A,(int)0xFFFF0012,(int)0xFFFF001C,(int)0xFFFF0029,(int)0xFFFF0039,(int)0xFFFF004B,(int)0xFFFF005F,(int)0xFFFF0076,(int)0xFFFF008F,(int)0xFFFF00AB,
(int)0xFFFF00C9,(int)0xFFFF00EA,(int)0xFFFF010D,(int)0xFFFF0133,(int)0xFFFF015B,(int)0xFFFF0186,(int)0xFFFF01B3,(int)0xFFFF01E2,(int)0xFFFF0214,(int)0xFFFF0248,
(int)0xFFFF027F,(int)0xFFFF02B9,(int)0xFFFF02F4,(int)0xFFFF0332,(int)0xFFFF0373,(int)0xFFFF03B6,(int)0xFFFF03FC,(int)0xFFFF0443,(int)0xFFFF048E,(int)0xFFFF04DB,
(int)0xFFFF052A,(int)0xFFFF057B,(int)0xFFFF05D0,(int)0xFFFF0626,(int)0xFFFF067F,(int)0xFFFF06DA,(int)0xFFFF0738,(int)0xFFFF0798,(int)0xFFFF07FA,(int)0xFFFF085F,
(int)0xFFFF08C7,(int)0xFFFF0930,(int)0xFFFF099C,(int)0xFFFF0A0B,(int)0xFFFF0A7C,(int)0xFFFF0AEF,(int)0xFFFF0B64,(int)0xFFFF0BDC,(int)0xFFFF0C56,(int)0xFFFF0CD3,
(int)0xFFFF0D52,(int)0xFFFF0DD3,(int)0xFFFF0E57,(int)0xFFFF0EDD,(int)0xFFFF0F65,(int)0xFFFF0FF0,(int)0xFFFF107D,(int)0xFFFF110C,(int)0xFFFF119E,(int)0xFFFF1232,
(int)0xFFFF12C8,(int)0xFFFF1360,(int)0xFFFF13FB,(int)0xFFFF1498,(int)0xFFFF1537,(int)0xFFFF15D9,(int)0xFFFF167D,(int)0xFFFF1723,(int)0xFFFF17CB,(int)0xFFFF1876,
(int)0xFFFF1923,(int)0xFFFF19D2,(int)0xFFFF1A83,(int)0xFFFF1B36,(int)0xFFFF1BEC,(int)0xFFFF1CA4,(int)0xFFFF1D5E,(int)0xFFFF1E1A,(int)0xFFFF1ED9,(int)0xFFFF1F99,
(int)0xFFFF205C,(int)0xFFFF2121,(int)0xFFFF21E8,(int)0xFFFF22B2,(int)0xFFFF237D,(int)0xFFFF244A,(int)0xFFFF251A,(int)0xFFFF25EC,(int)0xFFFF26C0,(int)0xFFFF2796,
(int)0xFFFF286E,(int)0xFFFF2948,(int)0xFFFF2A24,(int)0xFFFF2B02,(int)0xFFFF2BE3,(int)0xFFFF2CC5,(int)0xFFFF2DAA,(int)0xFFFF2E90,(int)0xFFFF2F78,(int)0xFFFF3063,
(int)0xFFFF314F,(int)0xFFFF323E,(int)0xFFFF332E,(int)0xFFFF3421,(int)0xFFFF3515,(int)0xFFFF360C,(int)0xFFFF3704,(int)0xFFFF37FE,(int)0xFFFF38FA,(int)0xFFFF39F9,
(int)0xFFFF3AF9,(int)0xFFFF3BFB,(int)0xFFFF3CFE,(int)0xFFFF3E04,(int)0xFFFF3F0C,(int)0xFFFF4015,(int)0xFFFF4121,(int)0xFFFF422E,(int)0xFFFF433D,(int)0xFFFF444D,
(int)0xFFFF4560,(int)0xFFFF4674,(int)0xFFFF478B,(int)0xFFFF48A3,(int)0xFFFF49BC,(int)0xFFFF4AD8,(int)0xFFFF4BF5,(int)0xFFFF4D14,(int)0xFFFF4E35,(int)0xFFFF4F57,
(int)0xFFFF507C,(int)0xFFFF51A2,(int)0xFFFF52C9,(int)0xFFFF53F2,(int)0xFFFF551D,(int)0xFFFF564A,(int)0xFFFF5778,(int)0xFFFF58A8,(int)0xFFFF59D9,(int)0xFFFF5B0C,
(int)0xFFFF5C41,(int)0xFFFF5D77,(int)0xFFFF5EAF,(int)0xFFFF5FE8,(int)0xFFFF6123,(int)0xFFFF625F,(int)0xFFFF639D,(int)0xFFFF64DD,(int)0xFFFF661E,(int)0xFFFF6760,
(int)0xFFFF68A4,(int)0xFFFF69E9,(int)0xFFFF6B30,(int)0xFFFF6C78,(int)0xFFFF6DC2,(int)0xFFFF6F0D,(int)0xFFFF7059,(int)0xFFFF71A7,(int)0xFFFF72F7,(int)0xFFFF7447,
(int)0xFFFF7599,(int)0xFFFF76EC,(int)0xFFFF7841,(int)0xFFFF7997,(int)0xFFFF7AEE,(int)0xFFFF7C47,(int)0xFFFF7DA0,(int)0xFFFF7EFB,(int)0xFFFF8058,(int)0xFFFF81B5,
(int)0xFFFF8314,(int)0xFFFF8474,(int)0xFFFF85D5,(int)0xFFFF8737,(int)0xFFFF889B,(int)0xFFFF89FF,(int)0xFFFF8B65,(int)0xFFFF8CCC,(int)0xFFFF8E34,(int)0xFFFF8F9D,
(int)0xFFFF9107,(int)0xFFFF9273,(int)0xFFFF93DF,(int)0xFFFF954C,(int)0xFFFF96BB,(int)0xFFFF982A,(int)0xFFFF999B,(int)0xFFFF9B0C,(int)0xFFFF9C7E,(int)0xFFFF9DF2,
(int)0xFFFF9F66,(int)0xFFFFA0DB,(int)0xFFFFA251,(int)0xFFFFA3C8,(int)0xFFFFA540,(int)0xFFFFA6B9,(int)0xFFFFA833,(int)0xFFFFA9AD,(int)0xFFFFAB29,(int)0xFFFFACA5,
(int)0xFFFFAE22,(int)0xFFFFAFA0,(int)0xFFFFB11E,(int)0xFFFFB29E,(int)0xFFFFB41E,(int)0xFFFFB59E,(int)0xFFFFB720,(int)0xFFFFB8A2,(int)0xFFFFBA25,(int)0xFFFFBBA9,
(int)0xFFFFBD2D,(int)0xFFFFBEB2,(int)0xFFFFC037,(int)0xFFFFC1BD,(int)0xFFFFC344,(int)0xFFFFC4CB,(int)0xFFFFC653,(int)0xFFFFC7DC,(int)0xFFFFC965,(int)0xFFFFCAEE,
(int)0xFFFFCC78,(int)0xFFFFCE03,(int)0xFFFFCF8E,(int)0xFFFFD119,(int)0xFFFFD2A5,(int)0xFFFFD432,(int)0xFFFFD5BE,(int)0xFFFFD74B,(int)0xFFFFD8D9,(int)0xFFFFDA67,
(int)0xFFFFDBF5,(int)0xFFFFDD84,(int)0xFFFFDF13,(int)0xFFFFE0A2,(int)0xFFFFE232,(int)0xFFFFE3C2,(int)0xFFFFE552,(int)0xFFFFE6E3,(int)0xFFFFE873,(int)0xFFFFEA04,
(int)0xFFFFEB95,(int)0xFFFFED27,(int)0xFFFFEEB8,(int)0xFFFFF04A,(int)0xFFFFF1DC,(int)0xFFFFF36E,(int)0xFFFFF500,(int)0xFFFFF692,(int)0xFFFFF824,(int)0xFFFFF9B7,
(int)0xFFFFFB49,(int)0xFFFFFCDC,(int)0xFFFFFE6E,(int)0x00000000,
0};

 /*! @brief TAN value lookup table */
const int tan_val[]={
(int)0x00000000,(int)0x00000192,(int)0x00000325,(int)0x000004B7,(int)0x0000064A,(int)0x000007DD,(int)0x00000970,(int)0x00000B03,(int)0x00000C96,(int)0x00000E2A,
(int)0x00000FBE,(int)0x00001152,(int)0x000012E6,(int)0x0000147B,(int)0x00001611,(int)0x000017A6,(int)0x0000193D,(int)0x00001AD3,(int)0x00001C6A,(int)0x00001E02,
(int)0x00001F9B,(int)0x00002134,(int)0x000022CD,(int)0x00002467,(int)0x00002602,(int)0x0000279E,(int)0x0000293B,(int)0x00002AD8,(int)0x00002C76,(int)0x00002E16,
(int)0x00002FB6,(int)0x00003157,(int)0x000032F8,(int)0x0000349B,(int)0x00003640,(int)0x000037E5,(int)0x0000398B,(int)0x00003B32,(int)0x00003CDB,(int)0x00003E85,
(int)0x00004030,(int)0x000041DD,(int)0x0000438A,(int)0x0000453A,(int)0x000046EA,(int)0x0000489D,(int)0x00004A50,(int)0x00004C05,(int)0x00004DBC,(int)0x00004F75,
(int)0x0000512F,(int)0x000052EB,(int)0x000054A8,(int)0x00005668,(int)0x00005829,(int)0x000059EC,(int)0x00005BB1,(int)0x00005D79,(int)0x00005F42,(int)0x0000610D,
(int)0x000062DB,(int)0x000064AA,(int)0x0000667C,(int)0x00006850,(int)0x00006A27,(int)0x00006C00,(int)0x00006DDB,(int)0x00006FB9,(int)0x0000719A,(int)0x0000737D,
(int)0x00007562,(int)0x0000774B,(int)0x00007936,(int)0x00007B25,(int)0x00007D16,(int)0x00007F0A,(int)0x00008101,(int)0x000082FB,(int)0x000084F9,(int)0x000086FA,
(int)0x000088FE,(int)0x00008B05,(int)0x00008D10,(int)0x00008F1F,(int)0x00009131,(int)0x00009347,(int)0x00009560,(int)0x0000977E,(int)0x0000999F,(int)0x00009BC5,
(int)0x00009DEE,(int)0x0000A01C,(int)0x0000A24E,(int)0x0000A485,(int)0x0000A6C0,(int)0x0000A900,(int)0x0000AB44,(int)0x0000AD8D,(int)0x0000AFDB,(int)0x0000B22E,
(int)0x0000B486,(int)0x0000B6E3,(int)0x0000B946,(int)0x0000BBAE,(int)0x0000BE1C,(int)0x0000C08F,(int)0x0000C308,(int)0x0000C587,(int)0x0000C80D,(int)0x0000CA98,
(int)0x0000CD2A,(int)0x0000CFC2,(int)0x0000D261,(int)0x0000D507,(int)0x0000D7B4,(int)0x0000DA68,(int)0x0000DD23,(int)0x0000DFE5,(int)0x0000E2B0,(int)0x0000E582,
(int)0x0000E85C,(int)0x0000EB3E,(int)0x0000EE29,(int)0x0000F11C,(int)0x0000F418,(int)0x0000F71D,(int)0x0000FA2B,(int)0x0000FD43,(int)0x00010064,(int)0x0001038F,
(int)0x000106C5,(int)0x00010A05,(int)0x00010D4F,(int)0x000110A5,(int)0x00011406,(int)0x00011772,(int)0x00011AEA,(int)0x00011E6E,(int)0x000121FF,(int)0x0001259C,
(int)0x00012947,(int)0x00012CFF,(int)0x000130C5,(int)0x00013499,(int)0x0001387C,(int)0x00013C6E,(int)0x0001406F,(int)0x00014480,(int)0x000148A2,(int)0x00014CD4,
(int)0x00015118,(int)0x0001556D,(int)0x000159D5,(int)0x00015E50,(int)0x000162DE,(int)0x00016780,(int)0x00016C37,(int)0x00017103,(int)0x000175E5,(int)0x00017ADD,
(int)0x00017FED,(int)0x00018515,(int)0x00018A56,(int)0x00018FB1,(int)0x00019526,(int)0x00019AB6,(int)0x0001A063,(int)0x0001A62D,(int)0x0001AC16,(int)0x0001B21E,
(int)0x0001B846,(int)0x0001BE91,(int)0x0001C4FE,(int)0x0001CB8F,(int)0x0001D245,(int)0x0001D923,(int)0x0001E029,(int)0x0001E758,(int)0x0001EEB4,(int)0x0001F63C,
(int)0x0001FDF4,(int)0x000205DD,(int)0x00020DF8,(int)0x00021649,(int)0x00021ED0,(int)0x00022792,(int)0x0002308F,(int)0x000239CC,(int)0x0002434A,(int)0x00024D0C,
(int)0x00025716,(int)0x0002616B,(int)0x00026C0E,(int)0x00027704,(int)0x00028250,(int)0x00028DF6,(int)0x000299FC,(int)0x0002A665,(int)0x0002B338,(int)0x0002C079,
(int)0x0002CE2F,(int)0x0002DC61,(int)0x0002EB14,(int)0x0002FA50,(int)0x00030A1E,(int)0x00031A86,(int)0x00032B90,(int)0x00033D49,(int)0x00034FB9,(int)0x000362ED,
(int)0x000376F3,(int)0x00038BD7,(int)0x0003A1A9,(int)0x0003B87A,(int)0x0003D05D,(int)0x0003E964,(int)0x000403A8,(int)0x00041F3F,(int)0x00043C45,(int)0x00045AD8,
(int)0x00047B19,(int)0x00049D2D,(int)0x0004C13F,(int)0x0004E77C,(int)0x00051018,(int)0x00053B51,(int)0x00056968,(int)0x00059AAA,(int)0x0005CF70,(int)0x0006081D,
(int)0x00064527,(int)0x00068714,(int)0x0006CE83,(int)0x00071C2F,(int)0x000770F1,(int)0x0007CDD3,(int)0x0008340E,(int)0x0008A523,(int)0x000922E6,(int)0x0009AF9F,
(int)0x000A4E23,(int)0x000B0214,(int)0x000BD01E,(int)0x000CBE65,(int)0x000DD524,(int)0x000F1FA6,(int)0x0010ADD8,(int)0x001296EE,(int)0x0014FE1A,(int)0x00181B64,
(int)0x001C4DD6,(int)0x0022446F,(int)0x002B68EF,(int)0x003B333C,(int)0x005D08B5,(int)0x00D915F5,(int)0xFD74C7B8,(int)0xFF7DC061,(int)0xFFB7A479,(int)0xFFCDE8E1,
(int)0xFFD9B2FF,(int)0xFFE0FF8F,(int)0xFFE5F65F,(int)0xFFE98EBE,(int)0xFFEC481E,(int)0xFFEE6AD3,(int)0xFFF022F6,(int)0xFFF18CF1,(int)0xFFF2BBEB,(int)0xFFF3BD3C,
(int)0xFFF49A83,(int)0xFFF55AD6,(int)0xFFF6038E,(int)0xFFF698C6,(int)0xFFF71DB3,(int)0xFFF794DE,(int)0xFFF80051,(int)0xFFF861B4,(int)0xFFF8BA63,(int)0xFFF90B7C,
(int)0xFFF955F0,(int)0xFFF99A89,(int)0xFFF9D9F2,(int)0xFFFA14BE,(int)0xFFFA4B6A,(int)0xFFFA7E62,(int)0xFFFAAE04,(int)0xFFFADAA3,(int)0xFFFB0486,(int)0xFFFB2BEC,
(int)0xFFFB510D,(int)0xFFFB741A,(int)0xFFFB9540,(int)0xFFFBB4A6,(int)0xFFFBD26E,(int)0xFFFBEEB9,(int)0xFFFC09A3,(int)0xFFFC2346,(int)0xFFFC3BB8,(int)0xFFFC530F,
(int)0xFFFC695F,(int)0xFFFC7EB8,(int)0xFFFC932B,(int)0xFFFCA6C6,(int)0xFFFCB997,(int)0xFFFCCBAA,(int)0xFFFCDD0A,(int)0xFFFCEDC2,(int)0xFFFCFDDC,(int)0xFFFD0D60,
(int)0xFFFD1C57,(int)0xFFFD2AC8,(int)0xFFFD38BB,(int)0xFFFD4636,(int)0xFFFD533F,(int)0xFFFD5FDC,(int)0xFFFD6C13,(int)0xFFFD77E9,(int)0xFFFD8361,(int)0xFFFD8E81,
(int)0xFFFD994E,(int)0xFFFDA3C9,(int)0xFFFDADF8,(int)0xFFFDB7DE,(int)0xFFFDC17E,(int)0xFFFDCADB,(int)0xFFFDD3F7,(int)0xFFFDDCD6,(int)0xFFFDE57B,(int)0xFFFDEDE7,
(int)0xFFFDF61C,(int)0xFFFDFE1E,(int)0xFFFE05EE,(int)0xFFFE0D8E,(int)0xFFFE14FF,(int)0xFFFE1C45,(int)0xFFFE235F,(int)0xFFFE2A51,(int)0xFFFE311B,(int)0xFFFE37BF,
(int)0xFFFE3E3D,(int)0xFFFE4499,(int)0xFFFE4AD2,(int)0xFFFE50EA,(int)0xFFFE56E2,(int)0xFFFE5CBB,(int)0xFFFE6277,(int)0xFFFE6816,(int)0xFFFE6D98,(int)0xFFFE7300,
(int)0xFFFE784E,(int)0xFFFE7D82,(int)0xFFFE829E,(int)0xFFFE87A2,(int)0xFFFE8C8F,(int)0xFFFE9166,(int)0xFFFE9627,(int)0xFFFE9AD4,(int)0xFFFE9F6C,(int)0xFFFEA3F0,
(int)0xFFFEA861,(int)0xFFFEACC0,(int)0xFFFEB10C,(int)0xFFFEB547,(int)0xFFFEB971,(int)0xFFFEBD8A,(int)0xFFFEC193,(int)0xFFFEC58D,(int)0xFFFEC977,(int)0xFFFECD53,
(int)0xFFFED120,(int)0xFFFED4DF,(int)0xFFFED890,(int)0xFFFEDC34,(int)0xFFFEDFCB,(int)0xFFFEE355,(int)0xFFFEE6D4,(int)0xFFFEEA46,(int)0xFFFEEDAC,(int)0xFFFEF107,
(int)0xFFFEF457,(int)0xFFFEF79C,(int)0xFFFEFAD7,(int)0xFFFEFE07,(int)0xFFFF012E,(int)0xFFFF044A,(int)0xFFFF075D,(int)0xFFFF0A67,(int)0xFFFF0D67,(int)0xFFFF105F,
(int)0xFFFF134E,(int)0xFFFF1634,(int)0xFFFF1912,(int)0xFFFF1BE8,(int)0xFFFF1EB6,(int)0xFFFF217D,(int)0xFFFF243C,(int)0xFFFF26F3,(int)0xFFFF29A3,(int)0xFFFF2C4D,
(int)0xFFFF2EEF,(int)0xFFFF318B,(int)0xFFFF3420,(int)0xFFFF36AE,(int)0xFFFF3937,(int)0xFFFF3BB9,(int)0xFFFF3E35,(int)0xFFFF40AB,(int)0xFFFF431C,(int)0xFFFF4587,
(int)0xFFFF47EC,(int)0xFFFF4A4C,(int)0xFFFF4CA7,(int)0xFFFF4EFC,(int)0xFFFF514D,(int)0xFFFF5398,(int)0xFFFF55DF,(int)0xFFFF5821,(int)0xFFFF5A5E,(int)0xFFFF5C97,
(int)0xFFFF5ECB,(int)0xFFFF60FB,(int)0xFFFF6327,(int)0xFFFF654E,(int)0xFFFF6772,(int)0xFFFF6991,(int)0xFFFF6BAD,(int)0xFFFF6DC5,(int)0xFFFF6FD9,(int)0xFFFF71E9,
(int)0xFFFF73F6,(int)0xFFFF75FF,(int)0xFFFF7805,(int)0xFFFF7A07,(int)0xFFFF7C06,(int)0xFFFF7E02,(int)0xFFFF7FFB,(int)0xFFFF81F1,(int)0xFFFF83E3,(int)0xFFFF85D3,
(int)0xFFFF87C0,(int)0xFFFF89AA,(int)0xFFFF8B91,(int)0xFFFF8D75,(int)0xFFFF8F57,(int)0xFFFF9136,(int)0xFFFF9313,(int)0xFFFF94ED,(int)0xFFFF96C5,(int)0xFFFF989A,
(int)0xFFFF9A6D,(int)0xFFFF9C3E,(int)0xFFFF9E0C,(int)0xFFFF9FD9,(int)0xFFFFA1A3,(int)0xFFFFA36B,(int)0xFFFFA531,(int)0xFFFFA6F6,(int)0xFFFFA8B8,(int)0xFFFFAA78,
(int)0xFFFFAC37,(int)0xFFFFADF3,(int)0xFFFFAFAE,(int)0xFFFFB168,(int)0xFFFFB31F,(int)0xFFFFB4D5,(int)0xFFFFB68A,(int)0xFFFFB83D,(int)0xFFFFB9EE,(int)0xFFFFBB9E,
(int)0xFFFFBD4D,(int)0xFFFFBEFA,(int)0xFFFFC0A6,(int)0xFFFFC250,(int)0xFFFFC3F9,(int)0xFFFFC5A1,(int)0xFFFFC748,(int)0xFFFFC8EE,(int)0xFFFFCA93,(int)0xFFFFCC36,
(int)0xFFFFCDD9,(int)0xFFFFCF7A,(int)0xFFFFD11B,(int)0xFFFFD2BA,(int)0xFFFFD459,(int)0xFFFFD5F7,(int)0xFFFFD794,(int)0xFFFFD930,(int)0xFFFFDACB,(int)0xFFFFDC66,
(int)0xFFFFDE00,(int)0xFFFFDF99,(int)0xFFFFE132,(int)0xFFFFE2CA,(int)0xFFFFE461,(int)0xFFFFE5F8,(int)0xFFFFE78F,(int)0xFFFFE925,(int)0xFFFFEABA,(int)0xFFFFEC4F,
(int)0xFFFFEDE4,(int)0xFFFFEF78,(int)0xFFFFF10C,(int)0xFFFFF2A0,(int)0xFFFFF433,(int)0xFFFFF5C7,(int)0xFFFFF75A,(int)0xFFFFF8ED,(int)0xFFFFFA7F,(int)0xFFFFFC12,
(int)0xFFFFFDA5,(int)0xFFFFFF37,(int)0x000000C9,(int)0x0000025B,(int)0x000003EE,(int)0x00000581,(int)0x00000713,(int)0x000008A6,(int)0x00000A39,(int)0x00000BCD,
(int)0x00000D60,(int)0x00000EF4,(int)0x00001088,(int)0x0000121C,(int)0x000013B1,(int)0x00001546,(int)0x000016DB,(int)0x00001871,(int)0x00001A08,(int)0x00001B9F,
(int)0x00001D36,(int)0x00001ECE,(int)0x00002067,(int)0x00002200,(int)0x0000239A,(int)0x00002535,(int)0x000026D0,(int)0x0000286C,(int)0x00002A09,(int)0x00002BA7,
(int)0x00002D46,(int)0x00002EE5,(int)0x00003086,(int)0x00003227,(int)0x000033CA,(int)0x0000356D,(int)0x00003712,(int)0x000038B8,(int)0x00003A5F,(int)0x00003C07,
(int)0x00003DB0,(int)0x00003F5A,(int)0x00004106,(int)0x000042B3,(int)0x00004462,(int)0x00004612,(int)0x000047C3,(int)0x00004976,(int)0x00004B2B,(int)0x00004CE1,
(int)0x00004E98,(int)0x00005052,(int)0x0000520D,(int)0x000053C9,(int)0x00005588,(int)0x00005748,(int)0x0000590A,(int)0x00005ACF,(int)0x00005C95,(int)0x00005E5D,
(int)0x00006027,(int)0x000061F4,(int)0x000063C2,(int)0x00006593,(int)0x00006766,(int)0x0000693B,(int)0x00006B13,(int)0x00006CED,(int)0x00006ECA,(int)0x000070A9,
(int)0x0000728B,(int)0x0000746F,(int)0x00007656,(int)0x00007840,(int)0x00007A2D,(int)0x00007C1D,(int)0x00007E0F,(int)0x00008005,(int)0x000081FE,(int)0x000083FA,
(int)0x000085F9,(int)0x000087FB,(int)0x00008A01,(int)0x00008C0A,(int)0x00008E17,(int)0x00009027,(int)0x0000923B,(int)0x00009453,(int)0x0000966F,(int)0x0000988E,
(int)0x00009AB2,(int)0x00009CD9,(int)0x00009F05,(int)0x0000A135,(int)0x0000A369,(int)0x0000A5A2,(int)0x0000A7DF,(int)0x0000AA21,(int)0x0000AC68,(int)0x0000AEB3,
(int)0x0000B104,(int)0x0000B359,(int)0x0000B5B4,(int)0x0000B814,(int)0x0000BA79,(int)0x0000BCE4,(int)0x0000BF55,(int)0x0000C1CB,(int)0x0000C447,(int)0x0000C6C9,
(int)0x0000C952,(int)0x0000CBE0,(int)0x0000CE75,(int)0x0000D111,(int)0x0000D3B3,(int)0x0000D65D,(int)0x0000D90D,(int)0x0000DBC4,(int)0x0000DE83,(int)0x0000E14A,
(int)0x0000E418,(int)0x0000E6EE,(int)0x0000E9CC,(int)0x0000ECB2,(int)0x0000EFA1,(int)0x0000F299,(int)0x0000F599,(int)0x0000F8A3,(int)0x0000FBB6,(int)0x0000FED2,
(int)0x000101F9,(int)0x00010529,(int)0x00010864,(int)0x00010BA9,(int)0x00010EF9,(int)0x00011254,(int)0x000115BA,(int)0x0001192C,(int)0x00011CAB,(int)0x00012035,
(int)0x000123CC,(int)0x00012770,(int)0x00012B21,(int)0x00012EE0,(int)0x000132AD,(int)0x00013689,(int)0x00013A73,(int)0x00013E6D,(int)0x00014276,(int)0x0001468F,
(int)0x00014AB9,(int)0x00014EF4,(int)0x00015340,(int)0x0001579F,(int)0x00015C10,(int)0x00016094,(int)0x0001652C,(int)0x000169D9,(int)0x00016E9A,(int)0x00017371,
(int)0x0001785E,(int)0x00017D62,(int)0x0001827E,(int)0x000187B2,(int)0x00018D00,(int)0x00019268,(int)0x000197EB,(int)0x00019D89,(int)0x0001A345,(int)0x0001A91E,
(int)0x0001AF16,(int)0x0001B52E,(int)0x0001BB67,(int)0x0001C1C3,(int)0x0001C842,(int)0x0001CEE5,(int)0x0001D5AF,(int)0x0001DCA1,(int)0x0001E3BB,(int)0x0001EB01,
(int)0x0001F272,(int)0x0001FA12,(int)0x000201E2,(int)0x000209E4,(int)0x0002121A,(int)0x00021A85,(int)0x0002232A,(int)0x00022C09,(int)0x00023526,(int)0x00023E82,
(int)0x00024822,(int)0x00025208,(int)0x00025C37,(int)0x000266B2,(int)0x0002717F,(int)0x00027C9F,(int)0x00028818,(int)0x000293ED,(int)0x0002A024,(int)0x0002ACC1,
(int)0x0002B9CA,(int)0x0002C746,(int)0x0002D538,(int)0x0002E3A9,(int)0x0002F2A0,(int)0x00030224,(int)0x0003123E,(int)0x000322F6,(int)0x00033456,(int)0x00034669,
(int)0x0003593A,(int)0x00036CD5,(int)0x00038148,(int)0x000396A1,(int)0x0003ACF1,(int)0x0003C448,(int)0x0003DCBB,(int)0x0003F65D,(int)0x00041147,(int)0x00042D92,
(int)0x00044B5B,(int)0x00046AC1,(int)0x00048BE6,(int)0x0004AEF4,(int)0x0004D414,(int)0x0004FB7B,(int)0x0005255D,(int)0x000551FC,(int)0x0005819E,(int)0x0005B497,
(int)0x0005EB42,(int)0x0006260E,(int)0x00066578,(int)0x0006AA11,(int)0x0006F485,(int)0x0007459E,(int)0x00079E4D,(int)0x0007FFAF,(int)0x00086B23,(int)0x0008E24D,
(int)0x0009673B,(int)0x0009FC72,(int)0x000AA52C,(int)0x000B6581,(int)0x000C42C6,(int)0x000D441A,(int)0x000E730F,(int)0x000FDD0F,(int)0x0011952E,(int)0x0013B7E9,
(int)0x00167144,(int)0x001A09AE,(int)0x001F006D,(int)0x00264D12,(int)0x00321715,(int)0x00485BC3,(int)0x0082416B,(int)0x028B4B44,(int)0xFF26ED97,(int)0xFFA2F76A,
(int)0xFFC4CD07,(int)0xFFD49718,(int)0xFFDDBBA8,(int)0xFFE3B22D,(int)0xFFE7E4A3,(int)0xFFEB01E4,(int)0xFFED6915,(int)0xFFEF5230,(int)0xFFF0E05D,(int)0xFFF22AE1,
(int)0xFFF3419C,(int)0xFFF42FE5,(int)0xFFF4FDEC,(int)0xFFF5B1DF,(int)0xFFF65062,(int)0xFFF6DD1B,(int)0xFFF75ADD,(int)0xFFF7CBF2,(int)0xFFF8322F,(int)0xFFF88F0F,
(int)0xFFF8E3D3,(int)0xFFF9317D,(int)0xFFF978ED,(int)0xFFF9BADA,(int)0xFFF9F7E4,(int)0xFFFA3090,(int)0xFFFA6556,(int)0xFFFA9698,(int)0xFFFAC4B0,(int)0xFFFAEFE7,
(int)0xFFFB1885,(int)0xFFFB3EC2,(int)0xFFFB62D3,(int)0xFFFB84E8,(int)0xFFFBA529,(int)0xFFFBC3BC,(int)0xFFFBE0C1,(int)0xFFFBFC59,(int)0xFFFC169C,(int)0xFFFC2FA4,
(int)0xFFFC4786,(int)0xFFFC5E57,(int)0xFFFC742A,(int)0xFFFC890D,(int)0xFFFC9D13,(int)0xFFFCB047,(int)0xFFFCC2B8,(int)0xFFFCD470,(int)0xFFFCE57B,(int)0xFFFCF5E2,
(int)0xFFFD05B0,(int)0xFFFD14EC,(int)0xFFFD23A0,(int)0xFFFD31D1,(int)0xFFFD3F87,(int)0xFFFD4CC8,(int)0xFFFD599B,(int)0xFFFD6604,(int)0xFFFD720A,(int)0xFFFD7DB0,
(int)0xFFFD88FC,(int)0xFFFD93F2,(int)0xFFFD9E95,(int)0xFFFDA8EA,(int)0xFFFDB2F4,(int)0xFFFDBCB7,(int)0xFFFDC634,(int)0xFFFDCF71,(int)0xFFFDD86E,(int)0xFFFDE130,
(int)0xFFFDE9B8,(int)0xFFFDF208,(int)0xFFFDFA24,(int)0xFFFE020C,(int)0xFFFE09C4,(int)0xFFFE114C,(int)0xFFFE18A8,(int)0xFFFE1FD7,(int)0xFFFE26DD,(int)0xFFFE2DBB,
(int)0xFFFE3471,(int)0xFFFE3B03,(int)0xFFFE416F,(int)0xFFFE47BA,(int)0xFFFE4DE2,(int)0xFFFE53EA,(int)0xFFFE59D3,(int)0xFFFE5F9D,(int)0xFFFE654A,(int)0xFFFE6ADA,
(int)0xFFFE704F,(int)0xFFFE75AA,(int)0xFFFE7AEB,(int)0xFFFE8013,(int)0xFFFE8523,(int)0xFFFE8A1B,(int)0xFFFE8EFD,(int)0xFFFE93C9,(int)0xFFFE9880,(int)0xFFFE9D22,
(int)0xFFFEA1B0,(int)0xFFFEA62B,(int)0xFFFEAA93,(int)0xFFFEAEE8,(int)0xFFFEB32C,(int)0xFFFEB75E,(int)0xFFFEBB80,(int)0xFFFEBF91,(int)0xFFFEC392,(int)0xFFFEC784,
(int)0xFFFECB67,(int)0xFFFECF3B,(int)0xFFFED301,(int)0xFFFED6B9,(int)0xFFFEDA64,(int)0xFFFEDE01,(int)0xFFFEE192,(int)0xFFFEE516,(int)0xFFFEE88E,(int)0xFFFEEBFA,
(int)0xFFFEEF5B,(int)0xFFFEF2B1,(int)0xFFFEF5FB,(int)0xFFFEF93B,(int)0xFFFEFC71,(int)0xFFFEFF9C,(int)0xFFFF02BD,(int)0xFFFF05D5,(int)0xFFFF08E3,(int)0xFFFF0BE8,
(int)0xFFFF0EE4,(int)0xFFFF11D7,(int)0xFFFF14C2,(int)0xFFFF17A4,(int)0xFFFF1A7E,(int)0xFFFF1D50,(int)0xFFFF201B,(int)0xFFFF22DD,(int)0xFFFF2598,(int)0xFFFF284C,
(int)0xFFFF2AF9,(int)0xFFFF2D9F,(int)0xFFFF303E,(int)0xFFFF32D6,(int)0xFFFF3568,(int)0xFFFF37F3,(int)0xFFFF3A79,(int)0xFFFF3CF8,(int)0xFFFF3F71,(int)0xFFFF41E4,
(int)0xFFFF4452,(int)0xFFFF46BA,(int)0xFFFF491D,(int)0xFFFF4B7A,(int)0xFFFF4DD2,(int)0xFFFF5025,(int)0xFFFF5273,(int)0xFFFF54BC,(int)0xFFFF5700,(int)0xFFFF5940,
(int)0xFFFF5B7B,(int)0xFFFF5DB2,(int)0xFFFF5FE4,(int)0xFFFF6212,(int)0xFFFF643B,(int)0xFFFF6661,(int)0xFFFF6882,(int)0xFFFF6AA0,(int)0xFFFF6CB9,(int)0xFFFF6ECF,
(int)0xFFFF70E1,(int)0xFFFF72F0,(int)0xFFFF74FB,(int)0xFFFF7702,(int)0xFFFF7906,(int)0xFFFF7B07,(int)0xFFFF7D05,(int)0xFFFF7EFF,(int)0xFFFF80F6,(int)0xFFFF82EA,
(int)0xFFFF84DB,(int)0xFFFF86CA,(int)0xFFFF88B5,(int)0xFFFF8A9E,(int)0xFFFF8C83,(int)0xFFFF8E66,(int)0xFFFF9047,(int)0xFFFF9225,(int)0xFFFF9400,(int)0xFFFF95D9,
(int)0xFFFF97B0,(int)0xFFFF9984,(int)0xFFFF9B56,(int)0xFFFF9D25,(int)0xFFFF9EF3,(int)0xFFFFA0BE,(int)0xFFFFA287,(int)0xFFFFA44F,(int)0xFFFFA614,(int)0xFFFFA7D7,
(int)0xFFFFA998,(int)0xFFFFAB58,(int)0xFFFFAD15,(int)0xFFFFAED1,(int)0xFFFFB08B,(int)0xFFFFB244,(int)0xFFFFB3FB,(int)0xFFFFB5B0,(int)0xFFFFB763,(int)0xFFFFB916,
(int)0xFFFFBAC6,(int)0xFFFFBC76,(int)0xFFFFBE23,(int)0xFFFFBFD0,(int)0xFFFFC17B,(int)0xFFFFC325,(int)0xFFFFC4CE,(int)0xFFFFC675,(int)0xFFFFC81B,(int)0xFFFFC9C0,
(int)0xFFFFCB65,(int)0xFFFFCD08,(int)0xFFFFCEA9,(int)0xFFFFD04A,(int)0xFFFFD1EA,(int)0xFFFFD38A,(int)0xFFFFD528,(int)0xFFFFD6C5,(int)0xFFFFD862,(int)0xFFFFD9FE,
(int)0xFFFFDB99,(int)0xFFFFDD33,(int)0xFFFFDECC,(int)0xFFFFE065,(int)0xFFFFE1FE,(int)0xFFFFE396,(int)0xFFFFE52D,(int)0xFFFFE6C3,(int)0xFFFFE85A,(int)0xFFFFE9EF,
(int)0xFFFFEB85,(int)0xFFFFED1A,(int)0xFFFFEEAE,(int)0xFFFFF042,(int)0xFFFFF1D6,(int)0xFFFFF36A,(int)0xFFFFF4FD,(int)0xFFFFF690,(int)0xFFFFF823,(int)0xFFFFF9B6,
(int)0xFFFFFB49,(int)0xFFFFFCDB,(int)0xFFFFFE6E,(int)0x00000000,
0};

 /*! @brief ACOS value lookup table */
const int acos_val[]={
(int)0x0003243F,(int)0x0003143C,(int)0x00030D9A,(int)0x00030882,(int)0x00030436,(int)0x0003006C,(int)0x0002FCFF,(int)0x0002F9D8,(int)0x0002F6E9,(int)0x0002F427,
(int)0x0002F18B,(int)0x0002EF0F,(int)0x0002ECAF,(int)0x0002EA68,(int)0x0002E836,(int)0x0002E618,(int)0x0002E40C,(int)0x0002E20F,(int)0x0002E021,(int)0x0002DE40,
(int)0x0002DC6C,(int)0x0002DAA3,(int)0x0002D8E4,(int)0x0002D72F,(int)0x0002D584,(int)0x0002D3E1,(int)0x0002D246,(int)0x0002D0B2,(int)0x0002CF26,(int)0x0002CDA1,
(int)0x0002CC22,(int)0x0002CAA9,(int)0x0002C937,(int)0x0002C7C9,(int)0x0002C661,(int)0x0002C4FE,(int)0x0002C3A0,(int)0x0002C247,(int)0x0002C0F2,(int)0x0002BFA1,
(int)0x0002BE55,(int)0x0002BD0C,(int)0x0002BBC8,(int)0x0002BA87,(int)0x0002B949,(int)0x0002B80F,(int)0x0002B6D8,(int)0x0002B5A5,(int)0x0002B474,(int)0x0002B347,
(int)0x0002B21C,(int)0x0002B0F5,(int)0x0002AFD0,(int)0x0002AEAD,(int)0x0002AD8D,(int)0x0002AC70,(int)0x0002AB55,(int)0x0002AA3D,(int)0x0002A927,(int)0x0002A813,
(int)0x0002A701,(int)0x0002A5F2,(int)0x0002A4E4,(int)0x0002A3D9,(int)0x0002A2CF,(int)0x0002A1C8,(int)0x0002A0C2,(int)0x00029FBE,(int)0x00029EBC,(int)0x00029DBC,
(int)0x00029CBD,(int)0x00029BC0,(int)0x00029AC5,(int)0x000299CB,(int)0x000298D3,(int)0x000297DD,(int)0x000296E8,(int)0x000295F4,(int)0x00029502,(int)0x00029411,
(int)0x00029322,(int)0x00029234,(int)0x00029147,(int)0x0002905C,(int)0x00028F72,(int)0x00028E89,(int)0x00028DA2,(int)0x00028CBC,(int)0x00028BD7,(int)0x00028AF3,
(int)0x00028A10,(int)0x0002892E,(int)0x0002884E,(int)0x0002876F,(int)0x00028690,(int)0x000285B3,(int)0x000284D7,(int)0x000283FC,(int)0x00028321,(int)0x00028248,
(int)0x00028170,(int)0x00028099,(int)0x00027FC3,(int)0x00027EED,(int)0x00027E19,(int)0x00027D45,(int)0x00027C73,(int)0x00027BA1,(int)0x00027AD0,(int)0x00027A00,
(int)0x00027931,(int)0x00027862,(int)0x00027795,(int)0x000276C8,(int)0x000275FC,(int)0x00027531,(int)0x00027466,(int)0x0002739D,(int)0x000272D4,(int)0x0002720C,
(int)0x00027144,(int)0x0002707D,(int)0x00026FB7,(int)0x00026EF2,(int)0x00026E2D,(int)0x00026D69,(int)0x00026CA6,(int)0x00026BE4,(int)0x00026B22,(int)0x00026A60,
(int)0x000269A0,(int)0x000268E0,(int)0x00026820,(int)0x00026761,(int)0x000266A3,(int)0x000265E6,(int)0x00026529,(int)0x0002646C,(int)0x000263B0,(int)0x000262F5,
(int)0x0002623B,(int)0x00026180,(int)0x000260C7,(int)0x0002600E,(int)0x00025F55,(int)0x00025E9D,(int)0x00025DE6,(int)0x00025D2F,(int)0x00025C79,(int)0x00025BC3,
(int)0x00025B0E,(int)0x00025A59,(int)0x000259A4,(int)0x000258F0,(int)0x0002583D,(int)0x0002578A,(int)0x000256D8,(int)0x00025626,(int)0x00025574,(int)0x000254C3,
(int)0x00025413,(int)0x00025362,(int)0x000252B3,(int)0x00025204,(int)0x00025155,(int)0x000250A6,(int)0x00024FF8,(int)0x00024F4B,(int)0x00024E9E,(int)0x00024DF1,
(int)0x00024D45,(int)0x00024C99,(int)0x00024BED,(int)0x00024B42,(int)0x00024A97,(int)0x000249ED,(int)0x00024943,(int)0x0002489A,(int)0x000247F0,(int)0x00024748,
(int)0x0002469F,(int)0x000245F7,(int)0x00024550,(int)0x000244A8,(int)0x00024401,(int)0x0002435B,(int)0x000242B4,(int)0x0002420E,(int)0x00024169,(int)0x000240C4,
(int)0x0002401F,(int)0x00023F7A,(int)0x00023ED6,(int)0x00023E32,(int)0x00023D8E,(int)0x00023CEB,(int)0x00023C48,(int)0x00023BA6,(int)0x00023B03,(int)0x00023A61,
(int)0x000239C0,(int)0x0002391E,(int)0x0002387D,(int)0x000237DC,(int)0x0002373C,(int)0x0002369C,(int)0x000235FC,(int)0x0002355C,(int)0x000234BD,(int)0x0002341E,
(int)0x0002337F,(int)0x000232E1,(int)0x00023242,(int)0x000231A4,(int)0x00023107,(int)0x00023069,(int)0x00022FCC,(int)0x00022F30,(int)0x00022E93,(int)0x00022DF7,
(int)0x00022D5B,(int)0x00022CBF,(int)0x00022C23,(int)0x00022B88,(int)0x00022AED,(int)0x00022A52,(int)0x000229B8,(int)0x0002291D,(int)0x00022883,(int)0x000227E9,
(int)0x00022750,(int)0x000226B7,(int)0x0002261D,(int)0x00022585,(int)0x000224EC,(int)0x00022454,(int)0x000223BB,(int)0x00022323,(int)0x0002228C,(int)0x000221F4,
(int)0x0002215D,(int)0x000220C6,(int)0x0002202F,(int)0x00021F98,(int)0x00021F02,(int)0x00021E6C,(int)0x00021DD6,(int)0x00021D40,(int)0x00021CAA,(int)0x00021C15,
(int)0x00021B80,(int)0x00021AEB,(int)0x00021A56,(int)0x000219C1,(int)0x0002192D,(int)0x00021899,(int)0x00021805,(int)0x00021771,(int)0x000216DD,(int)0x0002164A,
(int)0x000215B7,(int)0x00021524,(int)0x00021491,(int)0x000213FE,(int)0x0002136C,(int)0x000212D9,(int)0x00021247,(int)0x000211B5,(int)0x00021123,(int)0x00021092,
(int)0x00021000,(int)0x00020F6F,(int)0x00020EDE,(int)0x00020E4D,(int)0x00020DBC,(int)0x00020D2C,(int)0x00020C9B,(int)0x00020C0B,(int)0x00020B7B,(int)0x00020AEB,
(int)0x00020A5B,(int)0x000209CC,(int)0x0002093C,(int)0x000208AD,(int)0x0002081E,(int)0x0002078F,(int)0x00020700,(int)0x00020671,(int)0x000205E3,(int)0x00020555,
(int)0x000204C6,(int)0x00020438,(int)0x000203AA,(int)0x0002031D,(int)0x0002028F,(int)0x00020201,(int)0x00020174,(int)0x000200E7,(int)0x0002005A,(int)0x0001FFCD,
(int)0x0001FF40,(int)0x0001FEB3,(int)0x0001FE27,(int)0x0001FD9B,(int)0x0001FD0E,(int)0x0001FC82,(int)0x0001FBF6,(int)0x0001FB6A,(int)0x0001FADF,(int)0x0001FA53,
(int)0x0001F9C8,(int)0x0001F93C,(int)0x0001F8B1,(int)0x0001F826,(int)0x0001F79B,(int)0x0001F710,(int)0x0001F686,(int)0x0001F5FB,(int)0x0001F570,(int)0x0001F4E6,
(int)0x0001F45C,(int)0x0001F3D2,(int)0x0001F348,(int)0x0001F2BE,(int)0x0001F234,(int)0x0001F1AA,(int)0x0001F121,(int)0x0001F097,(int)0x0001F00E,(int)0x0001EF85,
(int)0x0001EEFC,(int)0x0001EE73,(int)0x0001EDEA,(int)0x0001ED61,(int)0x0001ECD9,(int)0x0001EC50,(int)0x0001EBC8,(int)0x0001EB3F,(int)0x0001EAB7,(int)0x0001EA2F,
(int)0x0001E9A7,(int)0x0001E91F,(int)0x0001E897,(int)0x0001E80F,(int)0x0001E788,(int)0x0001E700,(int)0x0001E679,(int)0x0001E5F1,(int)0x0001E56A,(int)0x0001E4E3,
(int)0x0001E45C,(int)0x0001E3D5,(int)0x0001E34E,(int)0x0001E2C7,(int)0x0001E240,(int)0x0001E1BA,(int)0x0001E133,(int)0x0001E0AD,(int)0x0001E026,(int)0x0001DFA0,
(int)0x0001DF1A,(int)0x0001DE94,(int)0x0001DE0E,(int)0x0001DD88,(int)0x0001DD02,(int)0x0001DC7C,(int)0x0001DBF6,(int)0x0001DB71,(int)0x0001DAEB,(int)0x0001DA66,
(int)0x0001D9E1,(int)0x0001D95B,(int)0x0001D8D6,(int)0x0001D851,(int)0x0001D7CC,(int)0x0001D747,(int)0x0001D6C2,(int)0x0001D63D,(int)0x0001D5B8,(int)0x0001D534,
(int)0x0001D4AF,(int)0x0001D42A,(int)0x0001D3A6,(int)0x0001D322,(int)0x0001D29D,(int)0x0001D219,(int)0x0001D195,(int)0x0001D111,(int)0x0001D08D,(int)0x0001D009,
(int)0x0001CF85,(int)0x0001CF01,(int)0x0001CE7D,(int)0x0001CDF9,(int)0x0001CD76,(int)0x0001CCF2,(int)0x0001CC6E,(int)0x0001CBEB,(int)0x0001CB67,(int)0x0001CAE4,
(int)0x0001CA61,(int)0x0001C9DE,(int)0x0001C95A,(int)0x0001C8D7,(int)0x0001C854,(int)0x0001C7D1,(int)0x0001C74E,(int)0x0001C6CB,(int)0x0001C648,(int)0x0001C5C6,
(int)0x0001C543,(int)0x0001C4C0,(int)0x0001C43D,(int)0x0001C3BB,(int)0x0001C338,(int)0x0001C2B6,(int)0x0001C233,(int)0x0001C1B1,(int)0x0001C12F,(int)0x0001C0AC,
(int)0x0001C02A,(int)0x0001BFA8,(int)0x0001BF26,(int)0x0001BEA4,(int)0x0001BE22,(int)0x0001BDA0,(int)0x0001BD1E,(int)0x0001BC9C,(int)0x0001BC1A,(int)0x0001BB98,
(int)0x0001BB16,(int)0x0001BA94,(int)0x0001BA13,(int)0x0001B991,(int)0x0001B90F,(int)0x0001B88E,(int)0x0001B80C,(int)0x0001B78B,(int)0x0001B709,(int)0x0001B688,
(int)0x0001B606,(int)0x0001B585,(int)0x0001B504,(int)0x0001B482,(int)0x0001B401,(int)0x0001B380,(int)0x0001B2FF,(int)0x0001B27D,(int)0x0001B1FC,(int)0x0001B17B,
(int)0x0001B0FA,(int)0x0001B079,(int)0x0001AFF8,(int)0x0001AF77,(int)0x0001AEF6,(int)0x0001AE75,(int)0x0001ADF4,(int)0x0001AD73,(int)0x0001ACF2,(int)0x0001AC72,
(int)0x0001ABF1,(int)0x0001AB70,(int)0x0001AAEF,(int)0x0001AA6F,(int)0x0001A9EE,(int)0x0001A96D,(int)0x0001A8ED,(int)0x0001A86C,(int)0x0001A7EB,(int)0x0001A76B,
(int)0x0001A6EA,(int)0x0001A66A,(int)0x0001A5E9,(int)0x0001A569,(int)0x0001A4E8,(int)0x0001A468,(int)0x0001A3E7,(int)0x0001A367,(int)0x0001A2E6,(int)0x0001A266,
(int)0x0001A1E6,(int)0x0001A165,(int)0x0001A0E5,(int)0x0001A065,(int)0x00019FE4,(int)0x00019F64,(int)0x00019EE4,(int)0x00019E63,(int)0x00019DE3,(int)0x00019D63,
(int)0x00019CE3,(int)0x00019C62,(int)0x00019BE2,(int)0x00019B62,(int)0x00019AE2,(int)0x00019A62,(int)0x000199E1,(int)0x00019961,(int)0x000198E1,(int)0x00019861,
(int)0x000197E1,(int)0x00019761,(int)0x000196E0,(int)0x00019660,(int)0x000195E0,(int)0x00019560,(int)0x000194E0,(int)0x00019460,(int)0x000193E0,(int)0x00019360,
(int)0x000192DF,(int)0x0001925F,(int)0x000191DF,(int)0x0001915F,(int)0x000190DF,(int)0x0001905F,(int)0x00018FDF,(int)0x00018F5F,(int)0x00018EDE,(int)0x00018E5E,
(int)0x00018DDE,(int)0x00018D5E,(int)0x00018CDE,(int)0x00018C5E,(int)0x00018BDD,(int)0x00018B5D,(int)0x00018ADD,(int)0x00018A5D,(int)0x000189DD,(int)0x0001895D,
(int)0x000188DC,(int)0x0001885C,(int)0x000187DC,(int)0x0001875C,(int)0x000186DB,(int)0x0001865B,(int)0x000185DB,(int)0x0001855B,(int)0x000184DA,(int)0x0001845A,
(int)0x000183DA,(int)0x00018359,(int)0x000182D9,(int)0x00018259,(int)0x000181D8,(int)0x00018158,(int)0x000180D8,(int)0x00018057,(int)0x00017FD7,(int)0x00017F56,
(int)0x00017ED6,(int)0x00017E55,(int)0x00017DD5,(int)0x00017D54,(int)0x00017CD4,(int)0x00017C53,(int)0x00017BD2,(int)0x00017B52,(int)0x00017AD1,(int)0x00017A50,
(int)0x000179D0,(int)0x0001794F,(int)0x000178CE,(int)0x0001784E,(int)0x000177CD,(int)0x0001774C,(int)0x000176CB,(int)0x0001764A,(int)0x000175C9,(int)0x00017548,
(int)0x000174C7,(int)0x00017446,(int)0x000173C5,(int)0x00017344,(int)0x000172C3,(int)0x00017242,(int)0x000171C1,(int)0x00017140,(int)0x000170BF,(int)0x0001703D,
(int)0x00016FBC,(int)0x00016F3B,(int)0x00016EBA,(int)0x00016E38,(int)0x00016DB7,(int)0x00016D35,(int)0x00016CB4,(int)0x00016C32,(int)0x00016BB1,(int)0x00016B2F,
(int)0x00016AAD,(int)0x00016A2C,(int)0x000169AA,(int)0x00016928,(int)0x000168A7,(int)0x00016825,(int)0x000167A3,(int)0x00016721,(int)0x0001669F,(int)0x0001661D,
(int)0x0001659B,(int)0x00016519,(int)0x00016497,(int)0x00016414,(int)0x00016392,(int)0x00016310,(int)0x0001628D,(int)0x0001620B,(int)0x00016189,(int)0x00016106,
(int)0x00016084,(int)0x00016001,(int)0x00015F7E,(int)0x00015EFC,(int)0x00015E79,(int)0x00015DF6,(int)0x00015D73,(int)0x00015CF0,(int)0x00015C6D,(int)0x00015BEA,
(int)0x00015B67,(int)0x00015AE4,(int)0x00015A61,(int)0x000159DE,(int)0x0001595A,(int)0x000158D7,(int)0x00015854,(int)0x000157D0,(int)0x0001574C,(int)0x000156C9,
(int)0x00015645,(int)0x000155C1,(int)0x0001553E,(int)0x000154BA,(int)0x00015436,(int)0x000153B2,(int)0x0001532E,(int)0x000152AA,(int)0x00015225,(int)0x000151A1,
(int)0x0001511D,(int)0x00015098,(int)0x00015014,(int)0x00014F8F,(int)0x00014F0B,(int)0x00014E86,(int)0x00014E01,(int)0x00014D7D,(int)0x00014CF8,(int)0x00014C73,
(int)0x00014BEE,(int)0x00014B68,(int)0x00014AE3,(int)0x00014A5E,(int)0x000149D9,(int)0x00014953,(int)0x000148CE,(int)0x00014848,(int)0x000147C2,(int)0x0001473D,
(int)0x000146B7,(int)0x00014631,(int)0x000145AB,(int)0x00014525,(int)0x0001449E,(int)0x00014418,(int)0x00014392,(int)0x0001430B,(int)0x00014285,(int)0x000141FE,
(int)0x00014177,(int)0x000140F1,(int)0x0001406A,(int)0x00013FE3,(int)0x00013F5C,(int)0x00013ED5,(int)0x00013E4D,(int)0x00013DC6,(int)0x00013D3E,(int)0x00013CB7,
(int)0x00013C2F,(int)0x00013BA8,(int)0x00013B20,(int)0x00013A98,(int)0x00013A10,(int)0x00013988,(int)0x000138FF,(int)0x00013877,(int)0x000137EE,(int)0x00013766,
(int)0x000136DD,(int)0x00013654,(int)0x000135CC,(int)0x00013543,(int)0x000134B9,(int)0x00013430,(int)0x000133A7,(int)0x0001331E,(int)0x00013294,(int)0x0001320A,
(int)0x00013181,(int)0x000130F7,(int)0x0001306D,(int)0x00012FE3,(int)0x00012F58,(int)0x00012ECE,(int)0x00012E44,(int)0x00012DB9,(int)0x00012D2E,(int)0x00012CA3,
(int)0x00012C18,(int)0x00012B8D,(int)0x00012B02,(int)0x00012A77,(int)0x000129EB,(int)0x00012960,(int)0x000128D4,(int)0x00012848,(int)0x000127BC,(int)0x00012730,
(int)0x000126A4,(int)0x00012617,(int)0x0001258B,(int)0x000124FE,(int)0x00012472,(int)0x000123E5,(int)0x00012358,(int)0x000122CA,(int)0x0001223D,(int)0x000121AF,
(int)0x00012122,(int)0x00012094,(int)0x00012006,(int)0x00011F78,(int)0x00011EEA,(int)0x00011E5B,(int)0x00011DCD,(int)0x00011D3E,(int)0x00011CAF,(int)0x00011C21,
(int)0x00011B91,(int)0x00011B02,(int)0x00011A73,(int)0x000119E3,(int)0x00011953,(int)0x000118C3,(int)0x00011833,(int)0x000117A3,(int)0x00011713,(int)0x00011682,
(int)0x000115F1,(int)0x00011560,(int)0x000114CF,(int)0x0001143E,(int)0x000113AD,(int)0x0001131B,(int)0x00011289,(int)0x000111F7,(int)0x00011165,(int)0x000110D3,
(int)0x00011040,(int)0x00010FAE,(int)0x00010F1B,(int)0x00010E88,(int)0x00010DF4,(int)0x00010D61,(int)0x00010CCD,(int)0x00010C3A,(int)0x00010BA6,(int)0x00010B11,
(int)0x00010A7D,(int)0x000109E8,(int)0x00010954,(int)0x000108BF,(int)0x0001082A,(int)0x00010794,(int)0x000106FF,(int)0x00010669,(int)0x000105D3,(int)0x0001053D,
(int)0x000104A6,(int)0x0001040F,(int)0x00010379,(int)0x000102E2,(int)0x0001024A,(int)0x000101B3,(int)0x0001011B,(int)0x00010083,(int)0x0000FFEB,(int)0x0000FF52,
(int)0x0000FEBA,(int)0x0000FE21,(int)0x0000FD88,(int)0x0000FCEF,(int)0x0000FC55,(int)0x0000FBBB,(int)0x0000FB21,(int)0x0000FA87,(int)0x0000F9EC,(int)0x0000F951,
(int)0x0000F8B6,(int)0x0000F81B,(int)0x0000F780,(int)0x0000F6E4,(int)0x0000F648,(int)0x0000F5AB,(int)0x0000F50F,(int)0x0000F472,(int)0x0000F3D5,(int)0x0000F338,
(int)0x0000F29A,(int)0x0000F1FC,(int)0x0000F15E,(int)0x0000F0BF,(int)0x0000F021,(int)0x0000EF82,(int)0x0000EEE2,(int)0x0000EE43,(int)0x0000EDA3,(int)0x0000ED03,
(int)0x0000EC62,(int)0x0000EBC1,(int)0x0000EB20,(int)0x0000EA7F,(int)0x0000E9DD,(int)0x0000E93B,(int)0x0000E899,(int)0x0000E7F6,(int)0x0000E753,(int)0x0000E6B0,
(int)0x0000E60C,(int)0x0000E569,(int)0x0000E4C4,(int)0x0000E420,(int)0x0000E37B,(int)0x0000E2D6,(int)0x0000E230,(int)0x0000E18A,(int)0x0000E0E4,(int)0x0000E03D,
(int)0x0000DF96,(int)0x0000DEEF,(int)0x0000DE47,(int)0x0000DD9F,(int)0x0000DCF7,(int)0x0000DC4E,(int)0x0000DBA5,(int)0x0000DAFB,(int)0x0000DA51,(int)0x0000D9A7,
(int)0x0000D8FC,(int)0x0000D851,(int)0x0000D7A6,(int)0x0000D6FA,(int)0x0000D64D,(int)0x0000D5A1,(int)0x0000D4F4,(int)0x0000D446,(int)0x0000D398,(int)0x0000D2EA,
(int)0x0000D23B,(int)0x0000D18C,(int)0x0000D0DC,(int)0x0000D02C,(int)0x0000CF7B,(int)0x0000CECA,(int)0x0000CE19,(int)0x0000CD67,(int)0x0000CCB4,(int)0x0000CC01,
(int)0x0000CB4E,(int)0x0000CA9A,(int)0x0000C9E6,(int)0x0000C931,(int)0x0000C87C,(int)0x0000C7C6,(int)0x0000C70F,(int)0x0000C658,(int)0x0000C5A1,(int)0x0000C4E9,
(int)0x0000C431,(int)0x0000C378,(int)0x0000C2BE,(int)0x0000C204,(int)0x0000C149,(int)0x0000C08E,(int)0x0000BFD2,(int)0x0000BF16,(int)0x0000BE59,(int)0x0000BD9B,
(int)0x0000BCDD,(int)0x0000BC1E,(int)0x0000BB5F,(int)0x0000BA9F,(int)0x0000B9DE,(int)0x0000B91D,(int)0x0000B85B,(int)0x0000B798,(int)0x0000B6D5,(int)0x0000B611,
(int)0x0000B54C,(int)0x0000B487,(int)0x0000B3C1,(int)0x0000B2FA,(int)0x0000B233,(int)0x0000B16B,(int)0x0000B0A2,(int)0x0000AFD8,(int)0x0000AF0E,(int)0x0000AE43,
(int)0x0000AD77,(int)0x0000ACAA,(int)0x0000ABDC,(int)0x0000AB0E,(int)0x0000AA3F,(int)0x0000A96F,(int)0x0000A89E,(int)0x0000A7CC,(int)0x0000A6F9,(int)0x0000A626,
(int)0x0000A551,(int)0x0000A47C,(int)0x0000A3A6,(int)0x0000A2CE,(int)0x0000A1F6,(int)0x0000A11D,(int)0x0000A043,(int)0x00009F68,(int)0x00009E8B,(int)0x00009DAE,
(int)0x00009CD0,(int)0x00009BF1,(int)0x00009B10,(int)0x00009A2E,(int)0x0000994C,(int)0x00009868,(int)0x00009783,(int)0x0000969C,(int)0x000095B5,(int)0x000094CC,
(int)0x000093E2,(int)0x000092F7,(int)0x0000920A,(int)0x0000911D,(int)0x0000902D,(int)0x00008F3D,(int)0x00008E4A,(int)0x00008D57,(int)0x00008C62,(int)0x00008B6B,
(int)0x00008A73,(int)0x0000897A,(int)0x0000887E,(int)0x00008781,(int)0x00008683,(int)0x00008583,(int)0x00008480,(int)0x0000837D,(int)0x00008277,(int)0x0000816F,
(int)0x00008066,(int)0x00007F5A,(int)0x00007E4D,(int)0x00007D3D,(int)0x00007C2C,(int)0x00007B18,(int)0x00007A02,(int)0x000078E9,(int)0x000077CE,(int)0x000076B1,
(int)0x00007591,(int)0x0000746F,(int)0x0000734A,(int)0x00007222,(int)0x000070F8,(int)0x00006FCA,(int)0x00006E9A,(int)0x00006D66,(int)0x00006C2F,(int)0x00006AF5,
(int)0x000069B8,(int)0x00006877,(int)0x00006732,(int)0x000065E9,(int)0x0000649D,(int)0x0000634C,(int)0x000061F7,(int)0x0000609E,(int)0x00005F40,(int)0x00005DDD,
(int)0x00005C75,(int)0x00005B08,(int)0x00005995,(int)0x0000581C,(int)0x0000569E,(int)0x00005518,(int)0x0000538C,(int)0x000051F9,(int)0x0000505E,(int)0x00004EBB,
(int)0x00004D0F,(int)0x00004B5A,(int)0x0000499C,(int)0x000047D3,(int)0x000045FE,(int)0x0000441D,(int)0x0000422F,(int)0x00004033,(int)0x00003E26,(int)0x00003C08,
(int)0x000039D7,(int)0x0000378F,(int)0x00003530,(int)0x000032B4,(int)0x00003018,(int)0x00002D56,(int)0x00002A66,(int)0x0000273F,(int)0x000023D2,(int)0x00002009,
(int)0x00001BBD,(int)0x000016A5,(int)0x00001002,(int)0x00000000,
0};

#endif

