/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Assembly Matcher Source Fragment                                           *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_ASSEMBLER_HEADER
#undef GET_ASSEMBLER_HEADER
  // This should be included into the middle of the declaration of
  // your subclasses implementation of MCTargetAsmParser.
  uint64_t ComputeAvailableFeatures(const FeatureBitset& FB) const;
  void convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                       const OperandVector &Operands);
  void convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) override;
  unsigned MatchInstructionImpl(const OperandVector &Operands,
                                MCInst &Inst,
                                uint64_t &ErrorInfo,
                                bool matchingInlineAsm,
                                unsigned VariantID = 0);
#endif // GET_ASSEMBLER_HEADER_INFO


#ifdef GET_OPERAND_DIAGNOSTIC_TYPES
#undef GET_OPERAND_DIAGNOSTIC_TYPES

#endif // GET_OPERAND_DIAGNOSTIC_TYPES


#ifdef GET_REGISTER_MATCHER
#undef GET_REGISTER_MATCHER

// Flags for subtarget features that participate in instruction matching.
enum SubtargetFeatureFlag : uint8_t {
  Feature_Not64BitMode = (1ULL << 4),
  Feature_In64BitMode = (1ULL << 2),
  Feature_In16BitMode = (1ULL << 0),
  Feature_Not16BitMode = (1ULL << 3),
  Feature_In32BitMode = (1ULL << 1),
  Feature_None = 0
};

static unsigned MatchRegisterName(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 2:	 // 33 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 3 strings to match.
      switch (Name[1]) {
      default: break;
      case 'h':	 // 1 string to match.
        return 1;	 // "ah"
      case 'l':	 // 1 string to match.
        return 2;	 // "al"
      case 'x':	 // 1 string to match.
        return 3;	 // "ax"
      }
      break;
    case 'b':	 // 4 strings to match.
      switch (Name[1]) {
      default: break;
      case 'h':	 // 1 string to match.
        return 4;	 // "bh"
      case 'l':	 // 1 string to match.
        return 5;	 // "bl"
      case 'p':	 // 1 string to match.
        return 6;	 // "bp"
      case 'x':	 // 1 string to match.
        return 9;	 // "bx"
      }
      break;
    case 'c':	 // 4 strings to match.
      switch (Name[1]) {
      default: break;
      case 'h':	 // 1 string to match.
        return 10;	 // "ch"
      case 'l':	 // 1 string to match.
        return 11;	 // "cl"
      case 's':	 // 1 string to match.
        return 12;	 // "cs"
      case 'x':	 // 1 string to match.
        return 13;	 // "cx"
      }
      break;
    case 'd':	 // 5 strings to match.
      switch (Name[1]) {
      default: break;
      case 'h':	 // 1 string to match.
        return 15;	 // "dh"
      case 'i':	 // 1 string to match.
        return 16;	 // "di"
      case 'l':	 // 1 string to match.
        return 19;	 // "dl"
      case 's':	 // 1 string to match.
        return 20;	 // "ds"
      case 'x':	 // 1 string to match.
        return 21;	 // "dx"
      }
      break;
    case 'e':	 // 1 string to match.
      if (Name[1] != 's')
        break;
      return 31;	 // "es"
    case 'f':	 // 1 string to match.
      if (Name[1] != 's')
        break;
      return 35;	 // "fs"
    case 'g':	 // 1 string to match.
      if (Name[1] != 's')
        break;
      return 36;	 // "gs"
    case 'i':	 // 1 string to match.
      if (Name[1] != 'p')
        break;
      return 46;	 // "ip"
    case 'k':	 // 8 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 1 string to match.
        return 109;	 // "k0"
      case '1':	 // 1 string to match.
        return 110;	 // "k1"
      case '2':	 // 1 string to match.
        return 111;	 // "k2"
      case '3':	 // 1 string to match.
        return 112;	 // "k3"
      case '4':	 // 1 string to match.
        return 113;	 // "k4"
      case '5':	 // 1 string to match.
        return 114;	 // "k5"
      case '6':	 // 1 string to match.
        return 115;	 // "k6"
      case '7':	 // 1 string to match.
        return 116;	 // "k7"
      }
      break;
    case 'r':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case '8':	 // 1 string to match.
        return 125;	 // "r8"
      case '9':	 // 1 string to match.
        return 126;	 // "r9"
      }
      break;
    case 's':	 // 3 strings to match.
      switch (Name[1]) {
      default: break;
      case 'i':	 // 1 string to match.
        return 57;	 // "si"
      case 'p':	 // 1 string to match.
        return 60;	 // "sp"
      case 's':	 // 1 string to match.
        return 63;	 // "ss"
      }
      break;
    }
    break;
  case 3:	 // 73 strings to match.
    switch (Name[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(Name.data()+1, "pl", 2) != 0)
        break;
      return 8;	 // "bpl"
    case 'c':	 // 10 strings to match.
      if (Name[1] != 'r')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 1 string to match.
        return 69;	 // "cr0"
      case '1':	 // 1 string to match.
        return 70;	 // "cr1"
      case '2':	 // 1 string to match.
        return 71;	 // "cr2"
      case '3':	 // 1 string to match.
        return 72;	 // "cr3"
      case '4':	 // 1 string to match.
        return 73;	 // "cr4"
      case '5':	 // 1 string to match.
        return 74;	 // "cr5"
      case '6':	 // 1 string to match.
        return 75;	 // "cr6"
      case '7':	 // 1 string to match.
        return 76;	 // "cr7"
      case '8':	 // 1 string to match.
        return 77;	 // "cr8"
      case '9':	 // 1 string to match.
        return 78;	 // "cr9"
      }
      break;
    case 'd':	 // 11 strings to match.
      switch (Name[1]) {
      default: break;
      case 'i':	 // 1 string to match.
        if (Name[2] != 'l')
          break;
        return 18;	 // "dil"
      case 'r':	 // 10 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 1 string to match.
          return 85;	 // "dr0"
        case '1':	 // 1 string to match.
          return 86;	 // "dr1"
        case '2':	 // 1 string to match.
          return 87;	 // "dr2"
        case '3':	 // 1 string to match.
          return 88;	 // "dr3"
        case '4':	 // 1 string to match.
          return 89;	 // "dr4"
        case '5':	 // 1 string to match.
          return 90;	 // "dr5"
        case '6':	 // 1 string to match.
          return 91;	 // "dr6"
        case '7':	 // 1 string to match.
          return 92;	 // "dr7"
        case '8':	 // 1 string to match.
          return 93;	 // "dr8"
        case '9':	 // 1 string to match.
          return 94;	 // "dr9"
        }
        break;
      }
      break;
    case 'e':	 // 10 strings to match.
      switch (Name[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (Name[2] != 'x')
          break;
        return 22;	 // "eax"
      case 'b':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'p':	 // 1 string to match.
          return 23;	 // "ebp"
        case 'x':	 // 1 string to match.
          return 24;	 // "ebx"
        }
        break;
      case 'c':	 // 1 string to match.
        if (Name[2] != 'x')
          break;
        return 25;	 // "ecx"
      case 'd':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'i':	 // 1 string to match.
          return 26;	 // "edi"
        case 'x':	 // 1 string to match.
          return 27;	 // "edx"
        }
        break;
      case 'i':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'p':	 // 1 string to match.
          return 29;	 // "eip"
        case 'z':	 // 1 string to match.
          return 30;	 // "eiz"
        }
        break;
      case 's':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'i':	 // 1 string to match.
          return 32;	 // "esi"
        case 'p':	 // 1 string to match.
          return 33;	 // "esp"
        }
        break;
      }
      break;
    case 'f':	 // 8 strings to match.
      if (Name[1] != 'p')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 1 string to match.
        return 101;	 // "fp0"
      case '1':	 // 1 string to match.
        return 102;	 // "fp1"
      case '2':	 // 1 string to match.
        return 103;	 // "fp2"
      case '3':	 // 1 string to match.
        return 104;	 // "fp3"
      case '4':	 // 1 string to match.
        return 105;	 // "fp4"
      case '5':	 // 1 string to match.
        return 106;	 // "fp5"
      case '6':	 // 1 string to match.
        return 107;	 // "fp6"
      case '7':	 // 1 string to match.
        return 108;	 // "fp7"
      }
      break;
    case 'm':	 // 8 strings to match.
      if (Name[1] != 'm')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 1 string to match.
        return 117;	 // "mm0"
      case '1':	 // 1 string to match.
        return 118;	 // "mm1"
      case '2':	 // 1 string to match.
        return 119;	 // "mm2"
      case '3':	 // 1 string to match.
        return 120;	 // "mm3"
      case '4':	 // 1 string to match.
        return 121;	 // "mm4"
      case '5':	 // 1 string to match.
        return 122;	 // "mm5"
      case '6':	 // 1 string to match.
        return 123;	 // "mm6"
      case '7':	 // 1 string to match.
        return 124;	 // "mm7"
      }
      break;
    case 'r':	 // 22 strings to match.
      switch (Name[1]) {
      default: break;
      case '1':	 // 6 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 1 string to match.
          return 127;	 // "r10"
        case '1':	 // 1 string to match.
          return 128;	 // "r11"
        case '2':	 // 1 string to match.
          return 129;	 // "r12"
        case '3':	 // 1 string to match.
          return 130;	 // "r13"
        case '4':	 // 1 string to match.
          return 131;	 // "r14"
        case '5':	 // 1 string to match.
          return 132;	 // "r15"
        }
        break;
      case '8':	 // 3 strings to match.
        switch (Name[2]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 237;	 // "r8b"
        case 'd':	 // 1 string to match.
          return 253;	 // "r8d"
        case 'w':	 // 1 string to match.
          return 261;	 // "r8w"
        }
        break;
      case '9':	 // 3 strings to match.
        switch (Name[2]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 238;	 // "r9b"
        case 'd':	 // 1 string to match.
          return 254;	 // "r9d"
        case 'w':	 // 1 string to match.
          return 262;	 // "r9w"
        }
        break;
      case 'a':	 // 1 string to match.
        if (Name[2] != 'x')
          break;
        return 47;	 // "rax"
      case 'b':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'p':	 // 1 string to match.
          return 48;	 // "rbp"
        case 'x':	 // 1 string to match.
          return 49;	 // "rbx"
        }
        break;
      case 'c':	 // 1 string to match.
        if (Name[2] != 'x')
          break;
        return 50;	 // "rcx"
      case 'd':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'i':	 // 1 string to match.
          return 51;	 // "rdi"
        case 'x':	 // 1 string to match.
          return 52;	 // "rdx"
        }
        break;
      case 'i':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'p':	 // 1 string to match.
          return 53;	 // "rip"
        case 'z':	 // 1 string to match.
          return 54;	 // "riz"
        }
        break;
      case 's':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'i':	 // 1 string to match.
          return 55;	 // "rsi"
        case 'p':	 // 1 string to match.
          return 56;	 // "rsp"
        }
        break;
      }
      break;
    case 's':	 // 3 strings to match.
      switch (Name[1]) {
      default: break;
      case 'i':	 // 1 string to match.
        if (Name[2] != 'l')
          break;
        return 59;	 // "sil"
      case 'p':	 // 1 string to match.
        if (Name[2] != 'l')
          break;
        return 62;	 // "spl"
      case 's':	 // 1 string to match.
        if (Name[2] != 'p')
          break;
        return 64;	 // "ssp"
      }
      break;
    }
    break;
  case 4:	 // 65 strings to match.
    switch (Name[0]) {
    default: break;
    case 'b':	 // 4 strings to match.
      if (memcmp(Name.data()+1, "nd", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return 65;	 // "bnd0"
      case '1':	 // 1 string to match.
        return 66;	 // "bnd1"
      case '2':	 // 1 string to match.
        return 67;	 // "bnd2"
      case '3':	 // 1 string to match.
        return 68;	 // "bnd3"
      }
      break;
    case 'c':	 // 6 strings to match.
      if (memcmp(Name.data()+1, "r1", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return 79;	 // "cr10"
      case '1':	 // 1 string to match.
        return 80;	 // "cr11"
      case '2':	 // 1 string to match.
        return 81;	 // "cr12"
      case '3':	 // 1 string to match.
        return 82;	 // "cr13"
      case '4':	 // 1 string to match.
        return 83;	 // "cr14"
      case '5':	 // 1 string to match.
        return 84;	 // "cr15"
      }
      break;
    case 'd':	 // 6 strings to match.
      if (memcmp(Name.data()+1, "r1", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return 95;	 // "dr10"
      case '1':	 // 1 string to match.
        return 96;	 // "dr11"
      case '2':	 // 1 string to match.
        return 97;	 // "dr12"
      case '3':	 // 1 string to match.
        return 98;	 // "dr13"
      case '4':	 // 1 string to match.
        return 99;	 // "dr14"
      case '5':	 // 1 string to match.
        return 100;	 // "dr15"
      }
      break;
    case 'f':	 // 1 string to match.
      if (memcmp(Name.data()+1, "psw", 3) != 0)
        break;
      return 34;	 // "fpsw"
    case 'r':	 // 18 strings to match.
      if (Name[1] != '1')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 3 strings to match.
        switch (Name[3]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 239;	 // "r10b"
        case 'd':	 // 1 string to match.
          return 255;	 // "r10d"
        case 'w':	 // 1 string to match.
          return 263;	 // "r10w"
        }
        break;
      case '1':	 // 3 strings to match.
        switch (Name[3]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 240;	 // "r11b"
        case 'd':	 // 1 string to match.
          return 256;	 // "r11d"
        case 'w':	 // 1 string to match.
          return 264;	 // "r11w"
        }
        break;
      case '2':	 // 3 strings to match.
        switch (Name[3]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 241;	 // "r12b"
        case 'd':	 // 1 string to match.
          return 257;	 // "r12d"
        case 'w':	 // 1 string to match.
          return 265;	 // "r12w"
        }
        break;
      case '3':	 // 3 strings to match.
        switch (Name[3]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 242;	 // "r13b"
        case 'd':	 // 1 string to match.
          return 258;	 // "r13d"
        case 'w':	 // 1 string to match.
          return 266;	 // "r13w"
        }
        break;
      case '4':	 // 3 strings to match.
        switch (Name[3]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 243;	 // "r14b"
        case 'd':	 // 1 string to match.
          return 259;	 // "r14d"
        case 'w':	 // 1 string to match.
          return 267;	 // "r14w"
        }
        break;
      case '5':	 // 3 strings to match.
        switch (Name[3]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 244;	 // "r15b"
        case 'd':	 // 1 string to match.
          return 260;	 // "r15d"
        case 'w':	 // 1 string to match.
          return 268;	 // "r15w"
        }
        break;
      }
      break;
    case 'x':	 // 10 strings to match.
      if (memcmp(Name.data()+1, "mm", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return 141;	 // "xmm0"
      case '1':	 // 1 string to match.
        return 142;	 // "xmm1"
      case '2':	 // 1 string to match.
        return 143;	 // "xmm2"
      case '3':	 // 1 string to match.
        return 144;	 // "xmm3"
      case '4':	 // 1 string to match.
        return 145;	 // "xmm4"
      case '5':	 // 1 string to match.
        return 146;	 // "xmm5"
      case '6':	 // 1 string to match.
        return 147;	 // "xmm6"
      case '7':	 // 1 string to match.
        return 148;	 // "xmm7"
      case '8':	 // 1 string to match.
        return 149;	 // "xmm8"
      case '9':	 // 1 string to match.
        return 150;	 // "xmm9"
      }
      break;
    case 'y':	 // 10 strings to match.
      if (memcmp(Name.data()+1, "mm", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return 173;	 // "ymm0"
      case '1':	 // 1 string to match.
        return 174;	 // "ymm1"
      case '2':	 // 1 string to match.
        return 175;	 // "ymm2"
      case '3':	 // 1 string to match.
        return 176;	 // "ymm3"
      case '4':	 // 1 string to match.
        return 177;	 // "ymm4"
      case '5':	 // 1 string to match.
        return 178;	 // "ymm5"
      case '6':	 // 1 string to match.
        return 179;	 // "ymm6"
      case '7':	 // 1 string to match.
        return 180;	 // "ymm7"
      case '8':	 // 1 string to match.
        return 181;	 // "ymm8"
      case '9':	 // 1 string to match.
        return 182;	 // "ymm9"
      }
      break;
    case 'z':	 // 10 strings to match.
      if (memcmp(Name.data()+1, "mm", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return 205;	 // "zmm0"
      case '1':	 // 1 string to match.
        return 206;	 // "zmm1"
      case '2':	 // 1 string to match.
        return 207;	 // "zmm2"
      case '3':	 // 1 string to match.
        return 208;	 // "zmm3"
      case '4':	 // 1 string to match.
        return 209;	 // "zmm4"
      case '5':	 // 1 string to match.
        return 210;	 // "zmm5"
      case '6':	 // 1 string to match.
        return 211;	 // "zmm6"
      case '7':	 // 1 string to match.
        return 212;	 // "zmm7"
      case '8':	 // 1 string to match.
        return 213;	 // "zmm8"
      case '9':	 // 1 string to match.
        return 214;	 // "zmm9"
      }
      break;
    }
    break;
  case 5:	 // 75 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 1 string to match.
      if (memcmp(Name.data()+1, "lags", 4) != 0)
        break;
      return 28;	 // "flags"
    case 's':	 // 8 strings to match.
      if (memcmp(Name.data()+1, "t(", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 133;	 // "st(0)"
      case '1':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 134;	 // "st(1)"
      case '2':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 135;	 // "st(2)"
      case '3':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 136;	 // "st(3)"
      case '4':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 137;	 // "st(4)"
      case '5':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 138;	 // "st(5)"
      case '6':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 139;	 // "st(6)"
      case '7':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 140;	 // "st(7)"
      }
      break;
    case 'x':	 // 22 strings to match.
      if (memcmp(Name.data()+1, "mm", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '1':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 151;	 // "xmm10"
        case '1':	 // 1 string to match.
          return 152;	 // "xmm11"
        case '2':	 // 1 string to match.
          return 153;	 // "xmm12"
        case '3':	 // 1 string to match.
          return 154;	 // "xmm13"
        case '4':	 // 1 string to match.
          return 155;	 // "xmm14"
        case '5':	 // 1 string to match.
          return 156;	 // "xmm15"
        case '6':	 // 1 string to match.
          return 157;	 // "xmm16"
        case '7':	 // 1 string to match.
          return 158;	 // "xmm17"
        case '8':	 // 1 string to match.
          return 159;	 // "xmm18"
        case '9':	 // 1 string to match.
          return 160;	 // "xmm19"
        }
        break;
      case '2':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 161;	 // "xmm20"
        case '1':	 // 1 string to match.
          return 162;	 // "xmm21"
        case '2':	 // 1 string to match.
          return 163;	 // "xmm22"
        case '3':	 // 1 string to match.
          return 164;	 // "xmm23"
        case '4':	 // 1 string to match.
          return 165;	 // "xmm24"
        case '5':	 // 1 string to match.
          return 166;	 // "xmm25"
        case '6':	 // 1 string to match.
          return 167;	 // "xmm26"
        case '7':	 // 1 string to match.
          return 168;	 // "xmm27"
        case '8':	 // 1 string to match.
          return 169;	 // "xmm28"
        case '9':	 // 1 string to match.
          return 170;	 // "xmm29"
        }
        break;
      case '3':	 // 2 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 171;	 // "xmm30"
        case '1':	 // 1 string to match.
          return 172;	 // "xmm31"
        }
        break;
      }
      break;
    case 'y':	 // 22 strings to match.
      if (memcmp(Name.data()+1, "mm", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '1':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 183;	 // "ymm10"
        case '1':	 // 1 string to match.
          return 184;	 // "ymm11"
        case '2':	 // 1 string to match.
          return 185;	 // "ymm12"
        case '3':	 // 1 string to match.
          return 186;	 // "ymm13"
        case '4':	 // 1 string to match.
          return 187;	 // "ymm14"
        case '5':	 // 1 string to match.
          return 188;	 // "ymm15"
        case '6':	 // 1 string to match.
          return 189;	 // "ymm16"
        case '7':	 // 1 string to match.
          return 190;	 // "ymm17"
        case '8':	 // 1 string to match.
          return 191;	 // "ymm18"
        case '9':	 // 1 string to match.
          return 192;	 // "ymm19"
        }
        break;
      case '2':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 193;	 // "ymm20"
        case '1':	 // 1 string to match.
          return 194;	 // "ymm21"
        case '2':	 // 1 string to match.
          return 195;	 // "ymm22"
        case '3':	 // 1 string to match.
          return 196;	 // "ymm23"
        case '4':	 // 1 string to match.
          return 197;	 // "ymm24"
        case '5':	 // 1 string to match.
          return 198;	 // "ymm25"
        case '6':	 // 1 string to match.
          return 199;	 // "ymm26"
        case '7':	 // 1 string to match.
          return 200;	 // "ymm27"
        case '8':	 // 1 string to match.
          return 201;	 // "ymm28"
        case '9':	 // 1 string to match.
          return 202;	 // "ymm29"
        }
        break;
      case '3':	 // 2 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 203;	 // "ymm30"
        case '1':	 // 1 string to match.
          return 204;	 // "ymm31"
        }
        break;
      }
      break;
    case 'z':	 // 22 strings to match.
      if (memcmp(Name.data()+1, "mm", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '1':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 215;	 // "zmm10"
        case '1':	 // 1 string to match.
          return 216;	 // "zmm11"
        case '2':	 // 1 string to match.
          return 217;	 // "zmm12"
        case '3':	 // 1 string to match.
          return 218;	 // "zmm13"
        case '4':	 // 1 string to match.
          return 219;	 // "zmm14"
        case '5':	 // 1 string to match.
          return 220;	 // "zmm15"
        case '6':	 // 1 string to match.
          return 221;	 // "zmm16"
        case '7':	 // 1 string to match.
          return 222;	 // "zmm17"
        case '8':	 // 1 string to match.
          return 223;	 // "zmm18"
        case '9':	 // 1 string to match.
          return 224;	 // "zmm19"
        }
        break;
      case '2':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 225;	 // "zmm20"
        case '1':	 // 1 string to match.
          return 226;	 // "zmm21"
        case '2':	 // 1 string to match.
          return 227;	 // "zmm22"
        case '3':	 // 1 string to match.
          return 228;	 // "zmm23"
        case '4':	 // 1 string to match.
          return 229;	 // "zmm24"
        case '5':	 // 1 string to match.
          return 230;	 // "zmm25"
        case '6':	 // 1 string to match.
          return 231;	 // "zmm26"
        case '7':	 // 1 string to match.
          return 232;	 // "zmm27"
        case '8':	 // 1 string to match.
          return 233;	 // "zmm28"
        case '9':	 // 1 string to match.
          return 234;	 // "zmm29"
        }
        break;
      case '3':	 // 2 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 235;	 // "zmm30"
        case '1':	 // 1 string to match.
          return 236;	 // "zmm31"
        }
        break;
      }
      break;
    }
    break;
  case 7:	 // 1 string to match.
    if (memcmp(Name.data()+0, "dirflag", 7) != 0)
      break;
    return 14;	 // "dirflag"
  }
  return 0;
}

#endif // GET_REGISTER_MATCHER


#ifdef GET_SUBTARGET_FEATURE_NAME
#undef GET_SUBTARGET_FEATURE_NAME

// User-level names for subtarget features that participate in
// instruction matching.
static const char *getSubtargetFeatureName(uint64_t Val) {
  switch(Val) {
  case Feature_Not64BitMode: return "Not 64-bit mode";
  case Feature_In64BitMode: return "64-bit mode";
  case Feature_In16BitMode: return "16-bit mode";
  case Feature_Not16BitMode: return "Not 16-bit mode";
  case Feature_In32BitMode: return "32-bit mode";
  default: return "(unknown)";
  }
}

#endif // GET_SUBTARGET_FEATURE_NAME


#ifdef GET_MATCHER_IMPLEMENTATION
#undef GET_MATCHER_IMPLEMENTATION

static void applyMnemonicAliases(StringRef &Mnemonic, uint64_t Features, unsigned VariantID) {
  switch (VariantID) {
    case 0:
      switch (Mnemonic.size()) {
      default: break;
      case 3:	 // 6 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 4 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'b':	 // 1 string to match.
            if (Mnemonic[2] != 'w')
              break;
            Mnemonic = "cbtw";	 // "cbw"
            return;
          case 'd':	 // 1 string to match.
            if (Mnemonic[2] != 'q')
              break;
            Mnemonic = "cltd";	 // "cdq"
            return;
          case 'q':	 // 1 string to match.
            if (Mnemonic[2] != 'o')
              break;
            Mnemonic = "cqto";	 // "cqo"
            return;
          case 'w':	 // 1 string to match.
            if (Mnemonic[2] != 'd')
              break;
            Mnemonic = "cwtd";	 // "cwd"
            return;
          }
          break;
        case 'p':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "op", 2) != 0)
            break;
          if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "pop"
            Mnemonic = "popw";
          else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
            Mnemonic = "popl";
          else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
            Mnemonic = "popq";
          return;
        case 'r':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "et", 2) != 0)
            break;
          if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "ret"
            Mnemonic = "retw";
          else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
            Mnemonic = "retl";
          else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
            Mnemonic = "retq";
          return;
        }
        break;
      case 4:	 // 18 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 3 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'a':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "ll", 2) != 0)
              break;
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "call"
              Mnemonic = "callw";
            else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
              Mnemonic = "calll";
            else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
              Mnemonic = "callq";
            return;
          case 'd':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "qe", 2) != 0)
              break;
            Mnemonic = "cltq";	 // "cdqe"
            return;
          case 'w':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "de", 2) != 0)
              break;
            Mnemonic = "cwtl";	 // "cwde"
            return;
          }
          break;
        case 'i':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ret", 3) != 0)
            break;
          if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "iret"
            Mnemonic = "iretw";
          else if ((Features & Feature_Not16BitMode) == Feature_Not16BitMode)
            Mnemonic = "iretl";
          return;
        case 'l':	 // 3 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'g':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2) != 0)
              break;
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "lgdt"
              Mnemonic = "lgdtw";
            else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
              Mnemonic = "lgdtl";
            else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
              Mnemonic = "lgdtq";
            return;
          case 'i':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2) != 0)
              break;
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "lidt"
              Mnemonic = "lidtw";
            else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
              Mnemonic = "lidtl";
            else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
              Mnemonic = "lidtq";
            return;
          case 'r':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "et", 2) != 0)
              break;
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "lret"
              Mnemonic = "lretw";
            else if ((Features & Feature_Not16BitMode) == Feature_Not16BitMode)
              Mnemonic = "lretl";
            return;
          }
          break;
        case 'p':	 // 3 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'o':	 // 2 strings to match.
            if (Mnemonic[2] != 'p')
              break;
            switch (Mnemonic[3]) {
            default: break;
            case 'a':	 // 1 string to match.
              if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "popa"
                Mnemonic = "popaw";
              else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
                Mnemonic = "popal";
              return;
            case 'f':	 // 1 string to match.
              if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "popf"
                Mnemonic = "popfw";
              else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
                Mnemonic = "popfl";
              else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
                Mnemonic = "popfq";
              return;
            }
            break;
          case 'u':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "sh", 2) != 0)
              break;
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "push"
              Mnemonic = "pushw";
            else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
              Mnemonic = "pushl";
            else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
              Mnemonic = "pushq";
            return;
          }
          break;
        case 'r':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "etn", 3) != 0)
            break;
          if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "retn"
            Mnemonic = "retw";
          else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
            Mnemonic = "retl";
          else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
            Mnemonic = "retq";
          return;
        case 's':	 // 6 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'a':	 // 4 strings to match.
            if (Mnemonic[2] != 'l')
              break;
            switch (Mnemonic[3]) {
            default: break;
            case 'b':	 // 1 string to match.
              Mnemonic = "shlb";	 // "salb"
              return;
            case 'l':	 // 1 string to match.
              Mnemonic = "shll";	 // "sall"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "shlq";	 // "salq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "shlw";	 // "salw"
              return;
            }
            break;
          case 'g':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2) != 0)
              break;
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "sgdt"
              Mnemonic = "sgdtw";
            else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
              Mnemonic = "sgdtl";
            else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
              Mnemonic = "sgdtq";
            return;
          case 'i':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2) != 0)
              break;
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "sidt"
              Mnemonic = "sidtw";
            else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
              Mnemonic = "sidtl";
            else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
              Mnemonic = "sidtq";
            return;
          }
          break;
        case 'u':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "d2a", 3) != 0)
            break;
          Mnemonic = "ud2";	 // "ud2a"
          return;
        }
        break;
      case 5:	 // 9 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'f':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ildq", 4) != 0)
            break;
          Mnemonic = "fildll";	 // "fildq"
          return;
        case 'p':	 // 3 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'o':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "pfd", 3) != 0)
              break;
            Mnemonic = "popfl";	 // "popfd"
            return;
          case 'u':	 // 2 strings to match.
            if (memcmp(Mnemonic.data()+2, "sh", 2) != 0)
              break;
            switch (Mnemonic[4]) {
            default: break;
            case 'a':	 // 1 string to match.
              if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "pusha"
                Mnemonic = "pushaw";
              else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
                Mnemonic = "pushal";
              return;
            case 'f':	 // 1 string to match.
              if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "pushf"
                Mnemonic = "pushfw";
              else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
                Mnemonic = "pushfl";
              else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
                Mnemonic = "pushfq";
              return;
            }
            break;
          }
          break;
        case 's':	 // 4 strings to match.
          if (memcmp(Mnemonic.data()+1, "mov", 3) != 0)
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'b':	 // 1 string to match.
            Mnemonic = "movsb";	 // "smovb"
            return;
          case 'l':	 // 1 string to match.
            Mnemonic = "movsl";	 // "smovl"
            return;
          case 'q':	 // 1 string to match.
            Mnemonic = "movsq";	 // "smovq"
            return;
          case 'w':	 // 1 string to match.
            Mnemonic = "movsw";	 // "smovw"
            return;
          }
          break;
        case 'v':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "errw", 4) != 0)
            break;
          Mnemonic = "verr";	 // "verrw"
          return;
        }
        break;
      case 6:	 // 15 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 6 strings to match.
          if (memcmp(Mnemonic.data()+1, "mov", 3) != 0)
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'c':	 // 3 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmovbl";	 // "cmovcl"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "cmovbq";	 // "cmovcq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "cmovbw";	 // "cmovcw"
              return;
            }
            break;
          case 'z':	 // 3 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmovel";	 // "cmovzl"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "cmoveq";	 // "cmovzq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "cmovew";	 // "cmovzw"
              return;
            }
            break;
          }
          break;
        case 'f':	 // 4 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'c':	 // 2 strings to match.
            if (memcmp(Mnemonic.data()+2, "mov", 3) != 0)
              break;
            switch (Mnemonic[5]) {
            default: break;
            case 'a':	 // 1 string to match.
              Mnemonic = "fcmovnbe";	 // "fcmova"
              return;
            case 'z':	 // 1 string to match.
              Mnemonic = "fcmove";	 // "fcmovz"
              return;
            }
            break;
          case 'i':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "stpq", 4) != 0)
              break;
            Mnemonic = "fistpll";	 // "fistpq"
            return;
          case 'l':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dcww", 4) != 0)
              break;
            Mnemonic = "fldcw";	 // "fldcww"
            return;
          }
          break;
        case 'l':	 // 2 strings to match.
          if (memcmp(Mnemonic.data()+1, "eave", 4) != 0)
            break;
          switch (Mnemonic[5]) {
          default: break;
          case 'l':	 // 1 string to match.
            if ((Features & Feature_Not64BitMode) == Feature_Not64BitMode)	 // "leavel"
              Mnemonic = "leave";
            return;
          case 'q':	 // 1 string to match.
            if ((Features & Feature_In64BitMode) == Feature_In64BitMode)	 // "leaveq"
              Mnemonic = "leave";
            return;
          }
          break;
        case 'p':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ushfd", 5) != 0)
            break;
          Mnemonic = "pushfl";	 // "pushfd"
          return;
        case 's':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ysret", 5) != 0)
            break;
          Mnemonic = "sysretl";	 // "sysret"
          return;
        case 'x':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "saveq", 5) != 0)
            break;
          Mnemonic = "xsave64";	 // "xsaveq"
          return;
        }
        break;
      case 7:	 // 34 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 24 strings to match.
          if (memcmp(Mnemonic.data()+1, "mov", 3) != 0)
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'n':	 // 18 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'a':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovbel";	 // "cmovnal"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovbeq";	 // "cmovnaq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovbew";	 // "cmovnaw"
                return;
              }
              break;
            case 'b':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovael";	 // "cmovnbl"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovaeq";	 // "cmovnbq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovaew";	 // "cmovnbw"
                return;
              }
              break;
            case 'c':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovael";	 // "cmovncl"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovaeq";	 // "cmovncq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovaew";	 // "cmovncw"
                return;
              }
              break;
            case 'g':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovlel";	 // "cmovngl"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovleq";	 // "cmovngq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovlew";	 // "cmovngw"
                return;
              }
              break;
            case 'l':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovgel";	 // "cmovnll"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovgeq";	 // "cmovnlq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovgew";	 // "cmovnlw"
                return;
              }
              break;
            case 'z':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovnel";	 // "cmovnzl"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovneq";	 // "cmovnzq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovnew";	 // "cmovnzw"
                return;
              }
              break;
            }
            break;
          case 'p':	 // 6 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'e':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovpl";	 // "cmovpel"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovpq";	 // "cmovpeq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovpw";	 // "cmovpew"
                return;
              }
              break;
            case 'o':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovnpl";	 // "cmovpol"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovnpq";	 // "cmovpoq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovnpw";	 // "cmovpow"
                return;
              }
              break;
            }
            break;
          }
          break;
        case 'f':	 // 6 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'c':	 // 2 strings to match.
            if (memcmp(Mnemonic.data()+2, "mov", 3) != 0)
              break;
            switch (Mnemonic[5]) {
            default: break;
            case 'a':	 // 1 string to match.
              if (Mnemonic[6] != 'e')
                break;
              Mnemonic = "fcmovnb";	 // "fcmovae"
              return;
            case 'n':	 // 1 string to match.
              if (Mnemonic[6] != 'a')
                break;
              Mnemonic = "fcmovbe";	 // "fcmovna"
              return;
            }
            break;
          case 'i':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "sttpq", 5) != 0)
              break;
            Mnemonic = "fisttpll";	 // "fisttpq"
            return;
          case 'n':	 // 2 strings to match.
            if (memcmp(Mnemonic.data()+2, "st", 2) != 0)
              break;
            switch (Mnemonic[4]) {
            default: break;
            case 'c':	 // 1 string to match.
              if (memcmp(Mnemonic.data()+5, "ww", 2) != 0)
                break;
              Mnemonic = "fnstcw";	 // "fnstcww"
              return;
            case 's':	 // 1 string to match.
              if (memcmp(Mnemonic.data()+5, "ww", 2) != 0)
                break;
              Mnemonic = "fnstsw";	 // "fnstsww"
              return;
            }
            break;
          case 'x':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "saveq", 5) != 0)
              break;
            Mnemonic = "fxsave64";	 // "fxsaveq"
            return;
          }
          break;
        case 's':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ysexit", 6) != 0)
            break;
          Mnemonic = "sysexitl";	 // "sysexit"
          return;
        case 'x':	 // 3 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'r':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "storq", 5) != 0)
              break;
            Mnemonic = "xrstor64";	 // "xrstorq"
            return;
          case 's':	 // 2 strings to match.
            if (memcmp(Mnemonic.data()+2, "ave", 3) != 0)
              break;
            switch (Mnemonic[5]) {
            default: break;
            case 'c':	 // 1 string to match.
              if (Mnemonic[6] != 'q')
                break;
              Mnemonic = "xsavec64";	 // "xsavecq"
              return;
            case 's':	 // 1 string to match.
              if (Mnemonic[6] != 'q')
                break;
              Mnemonic = "xsaves64";	 // "xsavesq"
              return;
            }
            break;
          }
          break;
        }
        break;
      case 8:	 // 15 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 12 strings to match.
          if (memcmp(Mnemonic.data()+1, "movn", 4) != 0)
            break;
          switch (Mnemonic[5]) {
          default: break;
          case 'a':	 // 3 strings to match.
            if (Mnemonic[6] != 'e')
              break;
            switch (Mnemonic[7]) {
            default: break;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmovbl";	 // "cmovnael"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "cmovbq";	 // "cmovnaeq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "cmovbw";	 // "cmovnaew"
              return;
            }
            break;
          case 'b':	 // 3 strings to match.
            if (Mnemonic[6] != 'e')
              break;
            switch (Mnemonic[7]) {
            default: break;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmoval";	 // "cmovnbel"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "cmovaq";	 // "cmovnbeq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "cmovaw";	 // "cmovnbew"
              return;
            }
            break;
          case 'g':	 // 3 strings to match.
            if (Mnemonic[6] != 'e')
              break;
            switch (Mnemonic[7]) {
            default: break;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmovll";	 // "cmovngel"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "cmovlq";	 // "cmovngeq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "cmovlw";	 // "cmovngew"
              return;
            }
            break;
          case 'l':	 // 3 strings to match.
            if (Mnemonic[6] != 'e')
              break;
            switch (Mnemonic[7]) {
            default: break;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmovgl";	 // "cmovnlel"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "cmovgq";	 // "cmovnleq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "cmovgw";	 // "cmovnlew"
              return;
            }
            break;
          }
          break;
        case 'f':	 // 2 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'c':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "movnae", 6) != 0)
              break;
            Mnemonic = "fcmovb";	 // "fcmovnae"
            return;
          case 'x':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "rstorq", 6) != 0)
              break;
            Mnemonic = "fxrstor64";	 // "fxrstorq"
            return;
          }
          break;
        case 'x':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "rstorsq", 7) != 0)
            break;
          Mnemonic = "xrstors64";	 // "xrstorsq"
          return;
        }
        break;
      case 9:	 // 1 string to match.
        if (memcmp(Mnemonic.data()+0, "xsaveoptq", 9) != 0)
          break;
        Mnemonic = "xsaveopt64";	 // "xsaveoptq"
        return;
      }
    break;
    case 1:
      switch (Mnemonic.size()) {
      default: break;
      case 3:	 // 1 string to match.
        if (memcmp(Mnemonic.data()+0, "sal", 3) != 0)
          break;
        Mnemonic = "shl";	 // "sal"
        return;
      case 4:	 // 7 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'l':	 // 2 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'g':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2) != 0)
              break;
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "lgdt"
              Mnemonic = "lgdtw";
            else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
              Mnemonic = "lgdtd";
            return;
          case 'i':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2) != 0)
              break;
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "lidt"
              Mnemonic = "lidtw";
            else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
              Mnemonic = "lidtd";
            return;
          }
          break;
        case 'p':	 // 2 strings to match.
          if (memcmp(Mnemonic.data()+1, "op", 2) != 0)
            break;
          switch (Mnemonic[3]) {
          default: break;
          case 'a':	 // 1 string to match.
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "popa"
              Mnemonic = "popaw";
            else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
              Mnemonic = "popal";
            return;
          case 'f':	 // 1 string to match.
            if ((Features & Feature_In64BitMode) == Feature_In64BitMode)	 // "popf"
              Mnemonic = "popfq";
            return;
          }
          break;
        case 'r':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "etn", 3) != 0)
            break;
          Mnemonic = "ret";	 // "retn"
          return;
        case 's':	 // 2 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'g':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2) != 0)
              break;
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "sgdt"
              Mnemonic = "sgdtw";
            else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
              Mnemonic = "sgdtd";
            return;
          case 'i':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2) != 0)
              break;
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "sidt"
              Mnemonic = "sidtw";
            else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
              Mnemonic = "sidtd";
            return;
          }
          break;
        }
        break;
      case 5:	 // 5 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 2 strings to match.
          if (memcmp(Mnemonic.data()+1, "mov", 3) != 0)
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'c':	 // 1 string to match.
            Mnemonic = "cmovb";	 // "cmovc"
            return;
          case 'z':	 // 1 string to match.
            Mnemonic = "cmove";	 // "cmovz"
            return;
          }
          break;
        case 'p':	 // 3 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'o':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "pad", 3) != 0)
              break;
            if ((Features & Feature_Not64BitMode) == Feature_Not64BitMode)	 // "popad"
              Mnemonic = "popal";
            return;
          case 'u':	 // 2 strings to match.
            if (memcmp(Mnemonic.data()+2, "sh", 2) != 0)
              break;
            switch (Mnemonic[4]) {
            default: break;
            case 'a':	 // 1 string to match.
              if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "pusha"
                Mnemonic = "pushaw";
              else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
                Mnemonic = "pushal";
              return;
            case 'f':	 // 1 string to match.
              if ((Features & Feature_In64BitMode) == Feature_In64BitMode)	 // "pushf"
                Mnemonic = "pushfq";
              return;
            }
            break;
          }
          break;
        }
        break;
      case 6:	 // 9 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 8 strings to match.
          if (memcmp(Mnemonic.data()+1, "mov", 3) != 0)
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'n':	 // 6 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'a':	 // 1 string to match.
              Mnemonic = "cmovbe";	 // "cmovna"
              return;
            case 'b':	 // 1 string to match.
              Mnemonic = "cmovae";	 // "cmovnb"
              return;
            case 'c':	 // 1 string to match.
              Mnemonic = "cmovae";	 // "cmovnc"
              return;
            case 'g':	 // 1 string to match.
              Mnemonic = "cmovle";	 // "cmovng"
              return;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmovge";	 // "cmovnl"
              return;
            case 'z':	 // 1 string to match.
              Mnemonic = "cmovne";	 // "cmovnz"
              return;
            }
            break;
          case 'p':	 // 2 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'e':	 // 1 string to match.
              Mnemonic = "cmovp";	 // "cmovpe"
              return;
            case 'o':	 // 1 string to match.
              Mnemonic = "cmovnp";	 // "cmovpo"
              return;
            }
            break;
          }
          break;
        case 'p':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ushad", 5) != 0)
            break;
          if ((Features & Feature_Not64BitMode) == Feature_Not64BitMode)	 // "pushad"
            Mnemonic = "pushal";
          return;
        }
        break;
      case 7:	 // 6 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "cquire", 6) != 0)
            break;
          Mnemonic = "xacquire";	 // "acquire"
          return;
        case 'c':	 // 4 strings to match.
          if (memcmp(Mnemonic.data()+1, "movn", 4) != 0)
            break;
          switch (Mnemonic[5]) {
          default: break;
          case 'a':	 // 1 string to match.
            if (Mnemonic[6] != 'e')
              break;
            Mnemonic = "cmovb";	 // "cmovnae"
            return;
          case 'b':	 // 1 string to match.
            if (Mnemonic[6] != 'e')
              break;
            Mnemonic = "cmova";	 // "cmovnbe"
            return;
          case 'g':	 // 1 string to match.
            if (Mnemonic[6] != 'e')
              break;
            Mnemonic = "cmovl";	 // "cmovnge"
            return;
          case 'l':	 // 1 string to match.
            if (Mnemonic[6] != 'e')
              break;
            Mnemonic = "cmovg";	 // "cmovnle"
            return;
          }
          break;
        case 'r':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "elease", 6) != 0)
            break;
          Mnemonic = "xrelease";	 // "release"
          return;
        }
        break;
      }
    break;
  }
  switch (Mnemonic.size()) {
  default: break;
  case 2:	 // 2 strings to match.
    if (Mnemonic[0] != 'j')
      break;
    switch (Mnemonic[1]) {
    default: break;
    case 'c':	 // 1 string to match.
      Mnemonic = "jb";	 // "jc"
      return;
    case 'z':	 // 1 string to match.
      Mnemonic = "je";	 // "jz"
      return;
    }
    break;
  case 3:	 // 8 strings to match.
    if (Mnemonic[0] != 'j')
      break;
    switch (Mnemonic[1]) {
    default: break;
    case 'n':	 // 6 strings to match.
      switch (Mnemonic[2]) {
      default: break;
      case 'a':	 // 1 string to match.
        Mnemonic = "jbe";	 // "jna"
        return;
      case 'b':	 // 1 string to match.
        Mnemonic = "jae";	 // "jnb"
        return;
      case 'c':	 // 1 string to match.
        Mnemonic = "jae";	 // "jnc"
        return;
      case 'g':	 // 1 string to match.
        Mnemonic = "jle";	 // "jng"
        return;
      case 'l':	 // 1 string to match.
        Mnemonic = "jge";	 // "jnl"
        return;
      case 'z':	 // 1 string to match.
        Mnemonic = "jne";	 // "jnz"
        return;
      }
      break;
    case 'p':	 // 2 strings to match.
      switch (Mnemonic[2]) {
      default: break;
      case 'e':	 // 1 string to match.
        Mnemonic = "jp";	 // "jpe"
        return;
      case 'o':	 // 1 string to match.
        Mnemonic = "jnp";	 // "jpo"
        return;
      }
      break;
    }
    break;
  case 4:	 // 8 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'j':	 // 4 strings to match.
      if (Mnemonic[1] != 'n')
        break;
      switch (Mnemonic[2]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (Mnemonic[3] != 'e')
          break;
        Mnemonic = "jb";	 // "jnae"
        return;
      case 'b':	 // 1 string to match.
        if (Mnemonic[3] != 'e')
          break;
        Mnemonic = "ja";	 // "jnbe"
        return;
      case 'g':	 // 1 string to match.
        if (Mnemonic[3] != 'e')
          break;
        Mnemonic = "jl";	 // "jnge"
        return;
      case 'l':	 // 1 string to match.
        if (Mnemonic[3] != 'e')
          break;
        Mnemonic = "jg";	 // "jnle"
        return;
      }
      break;
    case 'r':	 // 2 strings to match.
      if (memcmp(Mnemonic.data()+1, "ep", 2) != 0)
        break;
      switch (Mnemonic[3]) {
      default: break;
      case 'e':	 // 1 string to match.
        Mnemonic = "rep";	 // "repe"
        return;
      case 'z':	 // 1 string to match.
        Mnemonic = "rep";	 // "repz"
        return;
      }
      break;
    case 's':	 // 2 strings to match.
      if (memcmp(Mnemonic.data()+1, "et", 2) != 0)
        break;
      switch (Mnemonic[3]) {
      default: break;
      case 'c':	 // 1 string to match.
        Mnemonic = "setb";	 // "setc"
        return;
      case 'z':	 // 1 string to match.
        Mnemonic = "sete";	 // "setz"
        return;
      }
      break;
    }
    break;
  case 5:	 // 11 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'f':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "wait", 4) != 0)
        break;
      Mnemonic = "wait";	 // "fwait"
      return;
    case 'l':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "oopz", 4) != 0)
        break;
      Mnemonic = "loope";	 // "loopz"
      return;
    case 'r':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "epnz", 4) != 0)
        break;
      Mnemonic = "repne";	 // "repnz"
      return;
    case 's':	 // 8 strings to match.
      if (memcmp(Mnemonic.data()+1, "et", 2) != 0)
        break;
      switch (Mnemonic[3]) {
      default: break;
      case 'n':	 // 6 strings to match.
        switch (Mnemonic[4]) {
        default: break;
        case 'a':	 // 1 string to match.
          Mnemonic = "setbe";	 // "setna"
          return;
        case 'b':	 // 1 string to match.
          Mnemonic = "setae";	 // "setnb"
          return;
        case 'c':	 // 1 string to match.
          Mnemonic = "setae";	 // "setnc"
          return;
        case 'g':	 // 1 string to match.
          Mnemonic = "setle";	 // "setng"
          return;
        case 'l':	 // 1 string to match.
          Mnemonic = "setge";	 // "setnl"
          return;
        case 'z':	 // 1 string to match.
          Mnemonic = "setne";	 // "setnz"
          return;
        }
        break;
      case 'p':	 // 2 strings to match.
        switch (Mnemonic[4]) {
        default: break;
        case 'e':	 // 1 string to match.
          Mnemonic = "setp";	 // "setpe"
          return;
        case 'o':	 // 1 string to match.
          Mnemonic = "setnp";	 // "setpo"
          return;
        }
        break;
      }
      break;
    }
    break;
  case 6:	 // 6 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'f':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "comip", 5) != 0)
        break;
      Mnemonic = "fcompi";	 // "fcomip"
      return;
    case 'l':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "oopnz", 5) != 0)
        break;
      Mnemonic = "loopne";	 // "loopnz"
      return;
    case 's':	 // 4 strings to match.
      if (memcmp(Mnemonic.data()+1, "etn", 3) != 0)
        break;
      switch (Mnemonic[4]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (Mnemonic[5] != 'e')
          break;
        Mnemonic = "setb";	 // "setnae"
        return;
      case 'b':	 // 1 string to match.
        if (Mnemonic[5] != 'e')
          break;
        Mnemonic = "seta";	 // "setnbe"
        return;
      case 'g':	 // 1 string to match.
        if (Mnemonic[5] != 'e')
          break;
        Mnemonic = "setl";	 // "setnge"
        return;
      case 'l':	 // 1 string to match.
        if (Mnemonic[5] != 'e')
          break;
        Mnemonic = "setg";	 // "setnle"
        return;
      }
      break;
    }
    break;
  case 7:	 // 1 string to match.
    if (memcmp(Mnemonic.data()+0, "fucomip", 7) != 0)
      break;
    Mnemonic = "fucompi";	 // "fucomip"
    return;
  }
}

enum {
  Tie0_1_1,
  Tie0_2_2,
  Tie0_3_3,
  Tie0_4_4,
  Tie1_1_1,
  Tie1_2_2,
  Tie1_3_3,
  Tie1_4_4,
};

static const uint8_t TiedAsmOperandTable[][3] = {
  /* Tie0_1_1 */ { 0, 1, 1 },
  /* Tie0_2_2 */ { 0, 2, 2 },
  /* Tie0_3_3 */ { 0, 3, 3 },
  /* Tie0_4_4 */ { 0, 4, 4 },
  /* Tie1_1_1 */ { 1, 1, 1 },
  /* Tie1_2_2 */ { 1, 2, 2 },
  /* Tie1_3_3 */ { 1, 3, 3 },
  /* Tie1_4_4 */ { 1, 4, 4 },
};

namespace {
enum OperatorConversionKind {
  CVT_Done,
  CVT_Reg,
  CVT_Tied,
  CVT_imm_95_10,
  CVT_95_addImmOperands,
  CVT_regAX,
  CVT_regEAX,
  CVT_regRAX,
  CVT_95_Reg,
  CVT_95_addMemOperands,
  CVT_95_addAbsMemOperands,
  CVT_95_addDstIdxOperands,
  CVT_95_addSrcIdxOperands,
  CVT_95_addGR32orGR64Operands,
  CVT_regST1,
  CVT_regST0,
  CVT_95_addMemOffsOperands,
  CVT_imm_95_17,
  CVT_imm_95_1,
  CVT_imm_95_16,
  CVT_imm_95_0,
  CVT_95_addAVX512RCOperands,
  CVT_NUM_CONVERTERS
};

enum InstructionConversionKind {
  Convert_NoOperands,
  Convert__imm_95_10,
  Convert__Imm1_0,
  Convert__Imm1_1,
  Convert__regAX__Tie0_1_1__ImmSExti16i81_1,
  Convert__regEAX__Tie0_1_1__ImmSExti32i81_1,
  Convert__regRAX__Tie0_1_1__ImmSExti64i81_1,
  Convert__ImmSExti64i321_1,
  Convert__Reg1_0__Tie0_1_1__Reg1_1,
  Convert__Reg1_0__Tie0_1_1__ImmSExti16i81_1,
  Convert__Reg1_0__Tie0_1_1__Imm1_1,
  Convert__Reg1_0__Tie0_1_1__Mem165_1,
  Convert__Reg1_0__Tie0_1_1__ImmSExti32i81_1,
  Convert__Reg1_0__Tie0_1_1__Mem325_1,
  Convert__Reg1_0__Tie0_1_1__ImmSExti64i81_1,
  Convert__Reg1_0__Tie0_1_1__ImmSExti64i321_1,
  Convert__Reg1_0__Tie0_1_1__Mem645_1,
  Convert__Reg1_0__Tie0_1_1__Mem85_1,
  Convert__Mem165_0__Reg1_1,
  Convert__Mem165_0__ImmSExti16i81_1,
  Convert__Mem165_0__Imm1_1,
  Convert__Mem325_0__Reg1_1,
  Convert__Mem325_0__ImmSExti32i81_1,
  Convert__Mem325_0__Imm1_1,
  Convert__Mem645_0__Reg1_1,
  Convert__Mem645_0__ImmSExti64i81_1,
  Convert__Mem645_0__ImmSExti64i321_1,
  Convert__Mem85_0__Reg1_1,
  Convert__Mem85_0__Imm1_1,
  Convert__Reg1_1__Tie0_2_2__Reg1_0,
  Convert__Mem85_1__Reg1_0,
  Convert__Reg1_1__Tie0_2_2__Imm1_0,
  Convert__Mem85_1__Imm1_0,
  Convert__Reg1_1__Tie0_2_2__Mem85_0,
  Convert__Mem325_1__Reg1_0,
  Convert__regEAX__Tie0_1_1__ImmSExti32i81_0,
  Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0,
  Convert__Mem325_1__ImmSExti32i81_0,
  Convert__Mem325_1__Imm1_0,
  Convert__Reg1_1__Tie0_2_2__Mem325_0,
  Convert__Mem645_1__Reg1_0,
  Convert__regRAX__Tie0_1_1__ImmSExti64i81_0,
  Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0,
  Convert__Mem645_1__ImmSExti64i81_0,
  Convert__ImmSExti64i321_0,
  Convert__Reg1_1__Tie0_2_2__ImmSExti64i321_0,
  Convert__Mem645_1__ImmSExti64i321_0,
  Convert__Reg1_1__Tie0_2_2__Mem645_0,
  Convert__Mem165_1__Reg1_0,
  Convert__regAX__Tie0_1_1__ImmSExti16i81_0,
  Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0,
  Convert__Mem165_1__ImmSExti16i81_0,
  Convert__Mem165_1__Imm1_0,
  Convert__Reg1_1__Tie0_2_2__Mem165_0,
  Convert__Reg1_1__Tie0_1_1__Reg1_0,
  Convert__Reg1_1__Tie0_1_1__Mem325_0,
  Convert__Reg1_1__Tie0_1_1__Mem645_0,
  Convert__Reg1_0__Tie0_1_1__Mem1285_1,
  Convert__Reg1_1__Tie0_1_1__Mem1285_0,
  Convert__Reg1_1__Reg1_0,
  Convert__Reg1_0__Reg1_1,
  Convert__Reg1_0__Mem1285_1,
  Convert__Reg1_1__Mem1285_0,
  Convert__Reg1_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Mem1285_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_1__Reg1_2,
  Convert__Reg1_0__Reg1_1__Mem325_2,
  Convert__Reg1_0__Reg1_1__Mem645_2,
  Convert__Reg1_2__Reg1_1__Reg1_0,
  Convert__Reg1_2__Reg1_1__Mem325_0,
  Convert__Reg1_2__Reg1_1__Mem645_0,
  Convert__Reg1_0__Reg1_1__Imm1_2,
  Convert__Reg1_0__Mem325_1__Reg1_2,
  Convert__Reg1_0__Mem325_1__Imm1_2,
  Convert__Reg1_0__Reg1_1__ImmSExti64i321_2,
  Convert__Reg1_0__Mem645_1__Reg1_2,
  Convert__Reg1_0__Mem645_1__ImmSExti64i321_2,
  Convert__Reg1_2__Mem325_1__Reg1_0,
  Convert__Reg1_2__Reg1_1__Imm1_0,
  Convert__Reg1_2__Mem325_1__Imm1_0,
  Convert__Reg1_2__Mem645_1__Reg1_0,
  Convert__Reg1_2__Reg1_1__ImmSExti64i321_0,
  Convert__Reg1_2__Mem645_1__ImmSExti64i321_0,
  Convert__Reg1_0__Mem325_1,
  Convert__Reg1_0__Mem645_1,
  Convert__Reg1_1__Mem325_0,
  Convert__Reg1_1__Mem645_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Tie0_1_1__Mem1285_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_1__Tie0_2_2__Mem1285_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_1,
  Convert__Reg1_2__Tie0_1_1__Mem1285_1,
  Convert__Reg1_0__Mem5_1,
  Convert__Reg1_1__Mem5_0,
  Convert__Mem1285_1__Reg1_0,
  Convert__Mem1285_0__Reg1_1,
  Convert__Mem5_1__Reg1_0,
  Convert__Mem5_0__Reg1_1,
  Convert__Reg1_0__Mem165_1,
  Convert__Reg1_1__Mem165_0,
  Convert__Reg1_0__Tie0_1_1,
  Convert__Reg1_0__ImmSExti16i81_1,
  Convert__Reg1_0__ImmSExti32i81_1,
  Convert__Reg1_0__ImmSExti64i81_1,
  Convert__Reg1_1__ImmSExti32i81_0,
  Convert__Reg1_1__ImmSExti64i81_0,
  Convert__Reg1_1__ImmSExti16i81_0,
  Convert__Reg1_0,
  Convert__AbsMem1_0,
  Convert__Mem165_0,
  Convert__Mem325_0,
  Convert__Mem645_0,
  Convert__Mem5_0,
  Convert__Imm1_1__Imm1_0,
  Convert__Reg1_1,
  Convert__Mem325_1,
  Convert__Mem645_1,
  Convert__Mem165_1,
  Convert__Mem85_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_0,
  Convert__Reg1_1__Tie0_1_1__Mem165_0,
  Convert__regAX__ImmSExti16i81_1,
  Convert__regEAX__ImmSExti32i81_1,
  Convert__regRAX__ImmSExti64i81_1,
  Convert__Reg1_0__Imm1_1,
  Convert__Reg1_0__ImmSExti64i321_1,
  Convert__Reg1_0__Mem85_1,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Imm1_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__Imm1_0,
  Convert__Reg1_2__Tie0_1_1__Mem1285_3__Imm1_0,
  Convert__Reg1_3__Tie0_1_1__Mem1285_2__Imm1_0,
  Convert__Reg1_2__Tie0_1_1__Mem645_3__Imm1_0,
  Convert__Reg1_3__Tie0_1_1__Mem645_2__Imm1_0,
  Convert__Reg1_2__Tie0_1_1__Mem325_3__Imm1_0,
  Convert__Reg1_3__Tie0_1_1__Mem325_2__Imm1_0,
  Convert__Reg1_1__Imm1_0,
  Convert__Reg1_1__Mem85_0,
  Convert__regEAX__ImmSExti32i81_0,
  Convert__regRAX__ImmSExti64i81_0,
  Convert__Reg1_1__ImmSExti64i321_0,
  Convert__DstIdx161_1__SrcIdx162_0,
  Convert__DstIdx321_1__SrcIdx322_0,
  Convert__DstIdx641_1__SrcIdx642_0,
  Convert__DstIdx81_1__SrcIdx82_0,
  Convert__DstIdx81_0__SrcIdx82_1,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Tie0_1_1__Mem645_1__ImmUnsignedi81_0,
  Convert__DstIdx321_0__SrcIdx322_1,
  Convert__DstIdx641_0__SrcIdx642_1,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Tie0_1_1__Mem325_1__ImmUnsignedi81_0,
  Convert__DstIdx161_0__SrcIdx162_1,
  Convert__regAX__ImmSExti16i81_0,
  Convert__Mem1285_0,
  Convert__Mem85_1,
  Convert__Imm1_0__Imm1_1,
  Convert__GR32orGR641_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem325_2__Reg1_1__ImmUnsignedi81_0,
  Convert__GR32orGR641_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Mem325_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Tie0_1_1__ImmUnsignedi81_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Tie0_3_3__ImmUnsignedi81_1__ImmUnsignedi81_0,
  Convert__regST1,
  Convert__regST0,
  Convert__Mem805_0,
  Convert__Reg1_0__Reg1_0__ImmSExti16i81_1,
  Convert__Reg1_0__Reg1_0__Imm1_1,
  Convert__Reg1_0__Reg1_0__ImmSExti32i81_1,
  Convert__Reg1_0__Reg1_0__ImmSExti64i81_1,
  Convert__Reg1_0__Reg1_0__ImmSExti64i321_1,
  Convert__Reg1_0__Reg1_1__ImmSExti16i81_2,
  Convert__Reg1_0__Mem165_1__ImmSExti16i81_2,
  Convert__Reg1_0__Mem165_1__Imm1_2,
  Convert__Reg1_0__Reg1_1__ImmSExti32i81_2,
  Convert__Reg1_0__Mem325_1__ImmSExti32i81_2,
  Convert__Reg1_0__Reg1_1__ImmSExti64i81_2,
  Convert__Reg1_0__Mem645_1__ImmSExti64i81_2,
  Convert__Reg1_1__Reg1_1__ImmSExti32i81_0,
  Convert__Reg1_1__Reg1_1__Imm1_0,
  Convert__Reg1_2__Reg1_1__ImmSExti32i81_0,
  Convert__Reg1_2__Mem325_1__ImmSExti32i81_0,
  Convert__Reg1_1__Reg1_1__ImmSExti64i81_0,
  Convert__Reg1_1__Reg1_1__ImmSExti64i321_0,
  Convert__Reg1_2__Reg1_1__ImmSExti64i81_0,
  Convert__Reg1_2__Mem645_1__ImmSExti64i81_0,
  Convert__Reg1_1__Reg1_1__ImmSExti16i81_0,
  Convert__Reg1_2__Reg1_1__ImmSExti16i81_0,
  Convert__Reg1_2__Mem165_1__ImmSExti16i81_0,
  Convert__Reg1_2__Mem165_1__Imm1_0,
  Convert__ImmUnsignedi81_1,
  Convert__ImmUnsignedi81_0,
  Convert__DstIdx161_0,
  Convert__DstIdx321_0,
  Convert__DstIdx81_0,
  Convert__DstIdx81_1,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__ImmUnsignedi81_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Tie0_4_4__Reg1_2__ImmUnsignedi81_1__ImmUnsignedi81_0,
  Convert__DstIdx321_1,
  Convert__DstIdx161_1,
  Convert__Mem5_1,
  Convert__SrcIdx162_0,
  Convert__SrcIdx322_0,
  Convert__SrcIdx642_0,
  Convert__SrcIdx82_0,
  Convert__SrcIdx82_1,
  Convert__SrcIdx162_1,
  Convert__SrcIdx322_1,
  Convert__SrcIdx642_1,
  Convert__MemOffs16_82_1,
  Convert__MemOffs32_82_1,
  Convert__MemOffs16_162_1,
  Convert__MemOffs32_162_1,
  Convert__MemOffs16_322_1,
  Convert__MemOffs32_322_1,
  Convert__MemOffs32_642_1,
  Convert__MemOffs16_162_0,
  Convert__MemOffs16_322_0,
  Convert__MemOffs16_82_0,
  Convert__MemOffs32_162_0,
  Convert__MemOffs32_322_0,
  Convert__MemOffs32_642_0,
  Convert__MemOffs32_82_0,
  Convert__MemOffs64_82_1,
  Convert__MemOffs64_162_1,
  Convert__MemOffs64_322_1,
  Convert__MemOffs64_642_1,
  Convert__MemOffs64_162_0,
  Convert__MemOffs64_322_0,
  Convert__MemOffs64_642_0,
  Convert__MemOffs64_82_0,
  Convert__Reg1_0__Mem5125_1,
  Convert__Reg1_1__Mem5125_0,
  Convert__GR32orGR641_1__Reg1_0,
  Convert__GR32orGR641_0__Reg1_1,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_17,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_17,
  Convert__Reg1_0__Tie0_1_1__Mem1285_1__imm_95_17,
  Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_17,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_1,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_1,
  Convert__Reg1_0__Tie0_1_1__Mem1285_1__imm_95_1,
  Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_1,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_16,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_16,
  Convert__Reg1_0__Tie0_1_1__Mem1285_1__imm_95_16,
  Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_16,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_0,
  Convert__Reg1_0__Tie0_1_1__Mem1285_1__imm_95_0,
  Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_0,
  Convert__Mem85_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem85_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Mem645_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem645_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Mem165_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem165_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Tie0_1_1__GR32orGR641_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Tie0_1_1__Mem85_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Tie0_1_1__GR32orGR641_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Tie0_1_1__Mem85_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Tie0_1_1__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Mem645_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__ImmUnsignedi81_1,
  Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0,
  Convert__ImmSExti64i81_0,
  Convert__ImmSExti16i81_0,
  Convert__ImmSExti32i81_0,
  Convert__Mem165_0__ImmUnsignedi81_1,
  Convert__Mem325_0__ImmUnsignedi81_1,
  Convert__Mem645_0__ImmUnsignedi81_1,
  Convert__Mem85_0__ImmUnsignedi81_1,
  Convert__Reg1_1__Tie0_1_1,
  Convert__Mem85_1__ImmUnsignedi81_0,
  Convert__Mem325_1__ImmUnsignedi81_0,
  Convert__Mem645_1__ImmUnsignedi81_0,
  Convert__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Mem325_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Mem325_1__ImmUnsignedi81_0,
  Convert__DstIdx641_0,
  Convert__DstIdx641_1,
  Convert__Mem325_2__Reg1_1,
  Convert__Mem645_2__Reg1_1,
  Convert__Mem165_2__Reg1_1,
  Convert__GR32orGR641_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem1285_2,
  Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem1285_5,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem1285_6,
  Convert__Reg1_0__Reg1_1__Mem1285_2,
  Convert__Reg1_0__Reg1_1__Mem2565_2,
  Convert__Reg1_0__Reg1_1__Mem5125_2,
  Convert__Reg1_2__Reg1_1__Mem1285_0,
  Convert__Reg1_2__Reg1_1__Mem2565_0,
  Convert__Reg1_2__Reg1_1__Mem5125_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__AVX512RC1_3,
  Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0,
  Convert__Reg1_3__Reg1_2__Mem645_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Reg1_5,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem2565_5,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem5125_5,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem1285_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem645_5,
  Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem2565_6,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem5125_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Reg1_5__AVX512RC1_6,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0,
  Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0,
  Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0,
  Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem645_6,
  Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6__AVX512RC1_7,
  Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0,
  Convert__Reg1_3__Reg1_2__Mem325_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem325_5,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem325_6,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem645_0,
  Convert__Reg1_2__Reg1_4__Reg1_1__Mem645_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem325_0,
  Convert__Reg1_2__Reg1_4__Reg1_1__Mem325_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__ImmUnsignedi81_3,
  Convert__Reg1_0__Reg1_1__Mem1285_2__ImmUnsignedi81_3,
  Convert__Reg1_0__Reg1_1__Mem2565_2__ImmUnsignedi81_3,
  Convert__Reg1_0__Reg1_1__Mem5125_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_2__Mem5125_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_1__Mem325_2__ImmUnsignedi81_4,
  Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem1285_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem2565_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem5125_5__ImmUnsignedi81_6,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem1285_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem2565_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem5125_6__ImmUnsignedi81_7,
  Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_8,
  Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_1__Mem645_2__ImmUnsignedi81_4,
  Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_7,
  Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_8,
  Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem1285_5,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem2565_5,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem5125_5,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem645_5,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem325_5,
  Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3,
  Convert__Reg1_0__Reg1_1__Mem1285_2__Reg1_3,
  Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0,
  Convert__Reg1_0__Reg1_1__Mem2565_2__Reg1_3,
  Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0,
  Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem645_4,
  Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0,
  Convert__Reg1_1__Reg1_3__Reg1_0,
  Convert__Reg1_0__Reg1_2__Reg1_5,
  Convert__Reg1_0__Reg1_2__Mem645_5,
  Convert__Reg1_1__Reg1_3__Mem645_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem1285_4,
  Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0,
  Convert__Reg1_0__Reg1_2__Mem1285_5,
  Convert__Reg1_1__Reg1_3__Mem1285_0,
  Convert__Reg1_0__Mem2565_1,
  Convert__Reg1_1__Mem2565_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem2565_4,
  Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0,
  Convert__Reg1_0__Reg1_2__Mem2565_5,
  Convert__Reg1_1__Reg1_3__Mem2565_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem325_4,
  Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem325_0,
  Convert__Reg1_0__Reg1_2__Mem325_5,
  Convert__Reg1_1__Reg1_3__Mem325_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__Imm1_0,
  Convert__Reg1_2__Reg1_3__Mem1285_4__Imm1_0,
  Convert__Reg1_2__Reg1_3__Mem2565_4__Imm1_0,
  Convert__Reg1_2__Reg1_3__Mem5125_4__Imm1_0,
  Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0,
  Convert__Reg1_4__Reg1_3__Mem1285_2__Imm1_0,
  Convert__Reg1_4__Reg1_3__Mem2565_2__Imm1_0,
  Convert__Reg1_4__Reg1_3__Mem5125_2__Imm1_0,
  Convert__Reg1_2__Reg1_3__Mem645_4__Imm1_0,
  Convert__Reg1_4__Reg1_3__Mem645_2__Imm1_0,
  Convert__Reg1_2__Reg1_3__Mem325_4__Imm1_0,
  Convert__Reg1_4__Reg1_3__Mem325_2__Imm1_0,
  Convert__Reg1_5__Reg1_4__Reg1_3__Imm1_0,
  Convert__Reg1_5__Reg1_4__Mem645_2__Imm1_0,
  Convert__Reg1_5__Reg1_4__Mem325_2__Imm1_0,
  Convert__Reg1_2__Reg1_4__Reg1_6__Reg1_7__Imm1_0,
  Convert__Reg1_2__Reg1_4__Reg1_6__Mem1285_7__Imm1_0,
  Convert__Reg1_2__Reg1_4__Reg1_6__Mem2565_7__Imm1_0,
  Convert__Reg1_2__Reg1_4__Reg1_6__Mem5125_7__Imm1_0,
  Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__Imm1_0,
  Convert__Reg1_4__Reg1_6__Reg1_3__Mem1285_2__Imm1_0,
  Convert__Reg1_4__Reg1_6__Reg1_3__Mem2565_2__Imm1_0,
  Convert__Reg1_4__Reg1_6__Reg1_3__Mem5125_2__Imm1_0,
  Convert__Reg1_2__Reg1_4__Reg1_6__Mem645_7__Imm1_0,
  Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_2__Imm1_0,
  Convert__Reg1_2__Reg1_4__Reg1_6__Mem325_7__Imm1_0,
  Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_2__Imm1_0,
  Convert__Reg1_5__Reg1_7__Reg1_4__Reg1_3__Imm1_0,
  Convert__Reg1_5__Reg1_7__Reg1_4__Mem645_2__Imm1_0,
  Convert__Reg1_5__Reg1_7__Reg1_4__Mem325_2__Imm1_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__ImmUnsignedi81_4,
  Convert__Reg1_4__Reg1_3__Reg1_2__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem1285_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem2565_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem5125_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_7,
  Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_1__Mem645_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Reg1_2__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_6,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_1__Mem325_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Reg1_2__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_6,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Reg1_1,
  Convert__Mem2565_1__Reg1_0,
  Convert__Mem5125_1__Reg1_0,
  Convert__Mem2565_0__Reg1_1,
  Convert__Mem5125_0__Reg1_1,
  Convert__Mem1285_1__Reg1_3__Reg1_0,
  Convert__Mem2565_1__Reg1_3__Reg1_0,
  Convert__Mem5125_1__Reg1_3__Reg1_0,
  Convert__Mem1285_0__Reg1_2__Reg1_4,
  Convert__Mem2565_0__Reg1_2__Reg1_4,
  Convert__Mem5125_0__Reg1_2__Reg1_4,
  Convert__Reg1_2__Mem325_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0,
  Convert__Reg1_2__Reg1_4__Mem325_0,
  Convert__Reg1_0__Reg1_1__AVX512RC1_2,
  Convert__Reg1_2__Reg1_1__AVX512RC1_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem5125_4,
  Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0,
  Convert__Reg1_0__Reg1_2__Mem5125_5,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__AVX512RC1_5,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0,
  Convert__Reg1_1__Reg1_3__Mem5125_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__AVX512RC1_6,
  Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0,
  Convert__Reg1_2__Mem645_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0,
  Convert__Reg1_2__Reg1_4__Mem645_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1,
  Convert__Reg1_2__Reg1_4__Reg1_1,
  Convert__Mem1285_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem2565_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem1285_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Mem2565_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Reg1_1__ImmUnsignedi81_3,
  Convert__Reg1_3__Reg1_2__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__ImmUnsignedi81_5,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem645_2__Reg1_4__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem1285_2__Reg1_4__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem2565_2__Reg1_4__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem1285_0__Reg1_2__Reg1_4__ImmUnsignedi81_5,
  Convert__Mem2565_0__Reg1_2__Reg1_4__ImmUnsignedi81_5,
  Convert__Mem645_0__Reg1_2__Reg1_4__ImmUnsignedi81_5,
  Convert__Reg1_0__Reg1_2__Reg1_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__ImmUnsignedi81_6,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__ImmUnsignedi81_0,
  Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__ImmUnsignedi81_7,
  Convert__Reg1_3__Reg1_5__Reg1_2__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_1__Reg1_3__AVX512RC1_2,
  Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1,
  Convert__Reg1_3__Reg1_2__Reg1_1,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1,
  Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__ImmUnsignedi81_3,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem1285_2__ImmUnsignedi81_3,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem2565_2__ImmUnsignedi81_3,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem5125_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem5125_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem645_2__ImmUnsignedi81_4,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__ImmUnsignedi81_4,
  Convert__Reg1_4__Tie0_1_1__Reg1_3__Reg1_2__ImmUnsignedi81_0,
  Convert__Reg1_4__Tie0_1_1__Reg1_3__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem1285_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem2565_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem5125_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_7,
  Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_8,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_8,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem325_2__ImmUnsignedi81_4,
  Convert__Reg1_4__Tie0_1_1__Reg1_3__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_8,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem645_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_6,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem325_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_6,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_7,
  Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem2565_2,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem5125_2,
  Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem5125_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem645_2,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__AVX512RC1_3,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Reg1_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem2565_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem5125_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem645_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Reg1_6__AVX512RC1_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem325_2,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem325_6,
  Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem645_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem325_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem1285_3,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem2565_3,
  Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0,
  Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem645_3,
  Convert__Reg1_0__Reg1_1__Mem645_2__Reg1_3,
  Convert__Reg1_3__Reg1_2__Mem645_1__Reg1_0,
  Convert__Reg1_3__Reg1_2__Reg1_1__Mem645_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem325_3,
  Convert__Reg1_0__Reg1_1__Mem325_2__Reg1_3,
  Convert__Reg1_3__Reg1_2__Mem325_1__Reg1_0,
  Convert__Reg1_3__Reg1_2__Reg1_1__Mem325_0,
  Convert__Reg1_0__Mem2565_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Mem5125_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Mem645_1__ImmUnsignedi81_3,
  Convert__Reg1_0__Reg1_2__Reg1_4__ImmUnsignedi81_5,
  Convert__Reg1_0__Reg1_2__Mem1285_4__ImmUnsignedi81_5,
  Convert__Reg1_0__Reg1_2__Mem2565_4__ImmUnsignedi81_5,
  Convert__Reg1_0__Reg1_2__Mem5125_4__ImmUnsignedi81_5,
  Convert__Reg1_0__Reg1_2__Mem645_4__ImmUnsignedi81_6,
  Convert__Reg1_3__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_5__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Reg1_4__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Reg1_4__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Mem5125_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Reg1_4__Mem5125_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Mem325_1__ImmUnsignedi81_3,
  Convert__Reg1_0__Reg1_2__Mem325_4__ImmUnsignedi81_6,
  Convert__Reg1_3__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_5__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Mem645_4__ImmUnsignedi81_5,
  Convert__Reg1_2__Reg1_4__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Mem325_4__ImmUnsignedi81_5,
  Convert__Reg1_2__Reg1_4__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem128_RC1285_1__Tie1_1_1,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem128_RC1285_1__Tie1_3_3,
  Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem256_RC1285_1__Tie1_1_1,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem256_RC1285_1__Tie1_3_3,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem128_RC128X5_4,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem256_RC128X5_4,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem512_RC256X5_4,
  Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem128_RC128X5_0,
  Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem256_RC128X5_0,
  Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem512_RC256X5_0,
  Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem256_RC2565_1__Tie1_1_1,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem256_RC2565_1__Tie1_3_3,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem256_RC256X5_4,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem512_RC5125_4,
  Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem256_RC256X5_0,
  Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem512_RC5125_0,
  Convert__Reg1_1__Mem512_RC256X5_3,
  Convert__Reg1_2__Mem512_RC256X5_0,
  Convert__Reg1_1__Mem512_RC5125_3,
  Convert__Reg1_2__Mem512_RC5125_0,
  Convert__Reg1_1__Mem256_RC5125_3,
  Convert__Reg1_2__Mem256_RC5125_0,
  Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem128_RC2565_1__Tie1_1_1,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem128_RC2565_1__Tie1_3_3,
  Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem64_RC1285_1__Tie1_1_1,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem64_RC1285_1__Tie1_3_3,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem128_RC256X5_4,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem64_RC128X5_4,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem256_RC5125_4,
  Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem128_RC256X5_0,
  Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem256_RC5125_0,
  Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem64_RC128X5_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem1285_4__ImmUnsignedi81_5,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem2565_4__ImmUnsignedi81_5,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem5125_4__ImmUnsignedi81_5,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem5125_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Mem1285_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem645_4__ImmUnsignedi81_6,
  Convert__Reg1_0__Reg1_2__Mem2565_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Reg1_2__Mem5125_5__ImmUnsignedi81_6,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Mem645_5__ImmUnsignedi81_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem325_4__ImmUnsignedi81_6,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Mem325_5__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_8,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_1__Mem85_2__ImmUnsignedi81_4,
  Convert__Reg1_4__Reg1_3__Mem85_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem85_5__ImmUnsignedi81_7,
  Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem85_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem85_6__ImmUnsignedi81_8,
  Convert__Reg1_4__Reg1_6__Reg1_3__Mem85_1__ImmUnsignedi81_0,
  Convert__Mem1285_2__Reg1_1__Reg1_0,
  Convert__Mem2565_2__Reg1_1__Reg1_0,
  Convert__Mem1285_0__Reg1_1__Reg1_2,
  Convert__Mem2565_0__Reg1_1__Reg1_2,
  Convert__Reg1_0__Reg1_2__Reg1_4,
  Convert__Mem645_1__Reg1_3__Reg1_0,
  Convert__Mem645_0__Reg1_2__Reg1_4,
  Convert__Reg1_2__Tie0_3_3__Reg1_4__Reg1_1__Reg1_0,
  Convert__Mem325_1__Reg1_3__Reg1_0,
  Convert__Mem325_0__Reg1_2__Reg1_4,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem85_4,
  Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem85_0,
  Convert__Reg1_0__Reg1_2__Mem85_5,
  Convert__Reg1_1__Reg1_3__Mem85_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem165_4,
  Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem165_0,
  Convert__Reg1_0__Reg1_2__Mem165_5,
  Convert__Reg1_1__Reg1_3__Mem165_0,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_17,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_17,
  Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_17,
  Convert__Reg1_0__Reg1_1__Mem2565_2__imm_95_17,
  Convert__Reg1_0__Reg1_1__Mem5125_2__imm_95_17,
  Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_17,
  Convert__Reg1_2__Reg1_1__Mem2565_0__imm_95_17,
  Convert__Reg1_2__Reg1_1__Mem5125_0__imm_95_17,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_1,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_1,
  Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_1,
  Convert__Reg1_0__Reg1_1__Mem2565_2__imm_95_1,
  Convert__Reg1_0__Reg1_1__Mem5125_2__imm_95_1,
  Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_1,
  Convert__Reg1_2__Reg1_1__Mem2565_0__imm_95_1,
  Convert__Reg1_2__Reg1_1__Mem5125_0__imm_95_1,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_16,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_16,
  Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_16,
  Convert__Reg1_0__Reg1_1__Mem2565_2__imm_95_16,
  Convert__Reg1_0__Reg1_1__Mem5125_2__imm_95_16,
  Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_16,
  Convert__Reg1_2__Reg1_1__Mem2565_0__imm_95_16,
  Convert__Reg1_2__Reg1_1__Mem5125_0__imm_95_16,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0,
  Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_0,
  Convert__Reg1_0__Reg1_1__Mem2565_2__imm_95_0,
  Convert__Reg1_0__Reg1_1__Mem5125_2__imm_95_0,
  Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_0,
  Convert__Reg1_2__Reg1_1__Mem2565_0__imm_95_0,
  Convert__Reg1_2__Reg1_1__Mem5125_0__imm_95_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__ImmUnsignedi81_4,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem1285_3__ImmUnsignedi81_4,
  Convert__Reg1_0__Reg1_1__Mem1285_2__Reg1_3__ImmUnsignedi81_4,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem2565_3__ImmUnsignedi81_4,
  Convert__Reg1_0__Reg1_1__Mem2565_2__Reg1_3__ImmUnsignedi81_4,
  Convert__Reg1_4__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_4__Reg1_3__Mem1285_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_4__Reg1_3__Mem2565_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_4__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_4__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_1__GR32orGR641_2__ImmUnsignedi81_3,
  Convert__Reg1_0__Reg1_1__Mem85_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Reg1_2__GR32orGR641_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_2__Mem85_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_1__Mem165_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Reg1_2__Mem165_1__ImmUnsignedi81_0,
  Convert__Mem165_1__Reg1_3__Reg1_0,
  Convert__Mem165_0__Reg1_2__Reg1_4,
  Convert__Reg1_2__Mem1285_1__Reg1_0,
  Convert__Reg1_0__Mem1285_1__Reg1_2,
  Convert__Reg1_3__Mem128_RC128X5_1__Tie0_4_4__Reg1_0,
  Convert__Reg1_3__Mem256_RC256X5_1__Tie0_4_4__Reg1_0,
  Convert__Reg1_3__Mem512_RC5125_1__Tie0_4_4__Reg1_0,
  Convert__Reg1_2__Mem128_RC128X5_0__Tie0_3_3__Reg1_4,
  Convert__Reg1_2__Mem256_RC256X5_0__Tie0_3_3__Reg1_4,
  Convert__Reg1_2__Mem512_RC5125_0__Tie0_3_3__Reg1_4,
  Convert__Reg1_3__Mem256_RC128X5_1__Tie0_4_4__Reg1_0,
  Convert__Reg1_3__Mem512_RC256X5_1__Tie0_4_4__Reg1_0,
  Convert__Reg1_2__Mem256_RC128X5_0__Tie0_3_3__Reg1_4,
  Convert__Reg1_2__Mem512_RC256X5_0__Tie0_3_3__Reg1_4,
  Convert__Reg1_3__Mem128_RC256X5_1__Tie0_4_4__Reg1_0,
  Convert__Reg1_3__Mem64_RC128X5_1__Tie0_4_4__Reg1_0,
  Convert__Reg1_3__Mem256_RC5125_1__Tie0_4_4__Reg1_0,
  Convert__Reg1_2__Mem128_RC256X5_0__Tie0_3_3__Reg1_4,
  Convert__Reg1_2__Mem256_RC5125_0__Tie0_3_3__Reg1_4,
  Convert__Reg1_2__Mem64_RC128X5_0__Tie0_3_3__Reg1_4,
  Convert__Reg1_0__Reg1_1__Tie0_1_1__Tie1_2_2,
  Convert__Reg1_1__Reg1_0__Tie0_2_2__Tie1_1_1,
  Convert__AbsMem161_0,
  Convert__Reg1_1__Tie0_2_2,
  Convert__regEAX__regEAX__Tie0_1_1__Tie1_1_1,
  CVT_NUM_SIGNATURES
};

} // end anonymous namespace

static const uint8_t ConversionTable[CVT_NUM_SIGNATURES][13] = {
  // Convert_NoOperands
  { CVT_Done },
  // Convert__imm_95_10
  { CVT_imm_95_10, 0, CVT_Done },
  // Convert__Imm1_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Imm1_1
  { CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regAX__Tie0_1_1__ImmSExti16i81_1
  { CVT_regAX, 0, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regEAX__Tie0_1_1__ImmSExti32i81_1
  { CVT_regEAX, 0, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regRAX__Tie0_1_1__ImmSExti64i81_1
  { CVT_regRAX, 0, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__ImmSExti64i321_1
  { CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__ImmSExti16i81_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Imm1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__ImmSExti32i81_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__ImmSExti64i81_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__ImmSExti64i321_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem85_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Mem165_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem165_0__ImmSExti16i81_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem165_0__Imm1_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem325_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem325_0__ImmSExti32i81_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem325_0__Imm1_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem645_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem645_0__ImmSExti64i81_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem645_0__ImmSExti64i321_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem85_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem85_0__Imm1_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem85_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Imm1_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem85_1__Imm1_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem85_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem325_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__regEAX__Tie0_1_1__ImmSExti32i81_0
  { CVT_regEAX, 0, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem325_1__ImmSExti32i81_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem325_1__Imm1_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem645_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__regRAX__Tie0_1_1__ImmSExti64i81_0
  { CVT_regRAX, 0, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i81_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__ImmSExti64i321_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__ImmSExti64i321_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i321_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem165_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__regAX__Tie0_1_1__ImmSExti16i81_0
  { CVT_regAX, 0, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem165_1__ImmSExti16i81_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem165_1__Imm1_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Mem325_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Mem645_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem1285_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Mem1285_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_0
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Mem1285_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem1285_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem1285_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem325_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem645_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Imm1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem325_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Mem325_1__Imm1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmSExti64i321_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem645_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Mem645_1__ImmSExti64i321_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Mem325_1__Reg1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem325_1__Imm1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem645_1__Reg1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmSExti64i321_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmSExti64i321_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem325_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Mem645_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem325_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Mem645_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem1285_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem1285_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_1
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Mem1285_1
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Mem5_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem5_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem1285_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem1285_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem5_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem5_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Mem165_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem165_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__Reg1_0__ImmSExti16i81_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__ImmSExti32i81_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__ImmSExti64i81_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_1__ImmSExti32i81_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i81_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__ImmSExti16i81_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0
  { CVT_95_Reg, 1, CVT_Done },
  // Convert__AbsMem1_0
  { CVT_95_addAbsMemOperands, 1, CVT_Done },
  // Convert__Mem165_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem325_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem645_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem5_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Imm1_1__Imm1_0
  { CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1
  { CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem325_1
  { CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Mem645_1
  { CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Mem165_1
  { CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Mem85_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_0
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Mem165_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__regAX__ImmSExti16i81_1
  { CVT_regAX, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regEAX__ImmSExti32i81_1
  { CVT_regEAX, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regRAX__ImmSExti64i81_1
  { CVT_regRAX, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Imm1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__ImmSExti64i321_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Mem85_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Imm1_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__Imm1_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Mem1285_3__Imm1_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 4, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Mem1285_2__Imm1_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Mem645_3__Imm1_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 4, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Mem645_2__Imm1_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Mem325_3__Imm1_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 4, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Mem325_2__Imm1_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Imm1_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Mem85_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__regEAX__ImmSExti32i81_0
  { CVT_regEAX, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__regRAX__ImmSExti64i81_0
  { CVT_regRAX, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i321_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx161_1__SrcIdx162_0
  { CVT_95_addDstIdxOperands, 2, CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__DstIdx321_1__SrcIdx322_0
  { CVT_95_addDstIdxOperands, 2, CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__DstIdx641_1__SrcIdx642_0
  { CVT_95_addDstIdxOperands, 2, CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__DstIdx81_1__SrcIdx82_0
  { CVT_95_addDstIdxOperands, 2, CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__DstIdx81_0__SrcIdx82_1
  { CVT_95_addDstIdxOperands, 1, CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx321_0__SrcIdx322_1
  { CVT_95_addDstIdxOperands, 1, CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__DstIdx641_0__SrcIdx642_1
  { CVT_95_addDstIdxOperands, 1, CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx161_0__SrcIdx162_1
  { CVT_95_addDstIdxOperands, 1, CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__regAX__ImmSExti16i81_0
  { CVT_regAX, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem1285_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem85_1
  { CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Imm1_0__Imm1_1
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR32orGR641_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addGR32orGR64Operands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem325_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__GR32orGR641_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addGR32orGR64Operands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem325_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__ImmUnsignedi81_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0_3_3__ImmUnsignedi81_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_3_3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__regST1
  { CVT_regST1, 0, CVT_Done },
  // Convert__regST0
  { CVT_regST0, 0, CVT_Done },
  // Convert__Mem805_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_0__ImmSExti16i81_1
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_0__Imm1_1
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_0__ImmSExti32i81_1
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_0__ImmSExti64i81_1
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_0__ImmSExti64i321_1
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmSExti16i81_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem165_1__ImmSExti16i81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem165_1__Imm1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmSExti32i81_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem325_1__ImmSExti32i81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmSExti64i81_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem645_1__ImmSExti64i81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_1__Reg1_1__ImmSExti32i81_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_1__Imm1_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmSExti32i81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem325_1__ImmSExti32i81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_1__ImmSExti64i81_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_1__ImmSExti64i321_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmSExti64i81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmSExti64i81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_1__ImmSExti16i81_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmSExti16i81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem165_1__ImmSExti16i81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem165_1__Imm1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__ImmUnsignedi81_1
  { CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__ImmUnsignedi81_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx161_0
  { CVT_95_addDstIdxOperands, 1, CVT_Done },
  // Convert__DstIdx321_0
  { CVT_95_addDstIdxOperands, 1, CVT_Done },
  // Convert__DstIdx81_0
  { CVT_95_addDstIdxOperands, 1, CVT_Done },
  // Convert__DstIdx81_1
  { CVT_95_addDstIdxOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__ImmUnsignedi81_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Tie0_4_4__Reg1_2__ImmUnsignedi81_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_4_4, CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx321_1
  { CVT_95_addDstIdxOperands, 2, CVT_Done },
  // Convert__DstIdx161_1
  { CVT_95_addDstIdxOperands, 2, CVT_Done },
  // Convert__Mem5_1
  { CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__SrcIdx162_0
  { CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__SrcIdx322_0
  { CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__SrcIdx642_0
  { CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__SrcIdx82_0
  { CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__SrcIdx82_1
  { CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__SrcIdx162_1
  { CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__SrcIdx322_1
  { CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__SrcIdx642_1
  { CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__MemOffs16_82_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs32_82_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs16_162_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs32_162_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs16_322_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs32_322_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs32_642_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs16_162_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs16_322_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs16_82_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs32_162_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs32_322_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs32_642_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs32_82_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs64_82_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs64_162_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs64_322_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs64_642_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs64_162_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs64_322_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs64_642_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs64_82_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem5125_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem5125_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__GR32orGR641_1__Reg1_0
  { CVT_95_addGR32orGR64Operands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__GR32orGR641_0__Reg1_1
  { CVT_95_addGR32orGR64Operands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_17
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_17
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem1285_1__imm_95_17
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_17
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_1
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem1285_1__imm_95_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_1
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_16
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_16
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem1285_1__imm_95_16
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_16
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_0
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem1285_1__imm_95_0
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem85_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem85_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem645_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem645_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem165_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem165_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__GR32orGR641_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addGR32orGR64Operands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem85_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__GR32orGR641_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addGR32orGR64Operands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Mem85_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Mem165_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem645_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__ImmUnsignedi81_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__ImmSExti64i81_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__ImmSExti16i81_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__ImmSExti32i81_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem165_0__ImmUnsignedi81_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem325_0__ImmUnsignedi81_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem645_0__ImmUnsignedi81_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem85_0__ImmUnsignedi81_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__Mem85_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem325_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem645_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem165_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem325_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx641_0
  { CVT_95_addDstIdxOperands, 1, CVT_Done },
  // Convert__DstIdx641_1
  { CVT_95_addDstIdxOperands, 2, CVT_Done },
  // Convert__Mem325_2__Reg1_1
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem645_2__Reg1_1
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem165_2__Reg1_1
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__GR32orGR641_0
  { CVT_95_addGR32orGR64Operands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem1285_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem1285_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem1285_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem5125_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem1285_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem2565_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem5125_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__AVX512RC1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addAVX512RCOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem645_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Reg1_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem2565_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem5125_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem1285_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem645_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem2565_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem5125_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Reg1_5__AVX512RC1_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addAVX512RCOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem645_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6__AVX512RC1_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addAVX512RCOperands, 8, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem325_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem325_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem325_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem645_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Mem645_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem325_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Mem325_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem5125_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem5125_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem1285_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem2565_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem5125_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem1285_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem2565_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem5125_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_Tied, Tie0_1_1, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_8
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 9, CVT_Done },
  // Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_Tied, Tie0_1_1, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_8
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 9, CVT_Done },
  // Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem1285_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem2565_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem5125_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem645_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem325_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem645_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Reg1_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem645_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem645_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem1285_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem1285_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem1285_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem2565_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem2565_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem2565_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem2565_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem2565_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem325_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem325_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem325_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem325_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Mem1285_4__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Mem2565_4__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Mem5125_4__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem1285_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem2565_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem5125_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Mem645_4__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem645_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Mem325_4__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem325_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_5__Reg1_4__Reg1_3__Imm1_0
  { CVT_95_Reg, 6, CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_5__Reg1_4__Mem645_2__Imm1_0
  { CVT_95_Reg, 6, CVT_95_Reg, 5, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_5__Reg1_4__Mem325_2__Imm1_0
  { CVT_95_Reg, 6, CVT_95_Reg, 5, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_6__Reg1_7__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 8, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_6__Mem1285_7__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_addMemOperands, 8, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_6__Mem2565_7__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_addMemOperands, 8, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_6__Mem5125_7__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_addMemOperands, 8, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_6__Reg1_3__Mem1285_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_6__Reg1_3__Mem2565_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_6__Reg1_3__Mem5125_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_6__Mem645_7__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_addMemOperands, 8, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_6__Mem325_7__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_addMemOperands, 8, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_5__Reg1_7__Reg1_4__Reg1_3__Imm1_0
  { CVT_95_Reg, 6, CVT_95_Reg, 8, CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_5__Reg1_7__Reg1_4__Mem645_2__Imm1_0
  { CVT_95_Reg, 6, CVT_95_Reg, 8, CVT_95_Reg, 5, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_5__Reg1_7__Reg1_4__Mem325_2__Imm1_0
  { CVT_95_Reg, 6, CVT_95_Reg, 8, CVT_95_Reg, 5, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Reg1_2__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem1285_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem2565_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem5125_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem2565_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem5125_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem2565_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem5125_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem1285_1__Reg1_3__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem2565_1__Reg1_3__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem5125_1__Reg1_3__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem1285_0__Reg1_2__Reg1_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Mem2565_0__Reg1_2__Reg1_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Mem5125_0__Reg1_2__Reg1_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__Mem325_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem325_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__AVX512RC1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 3, CVT_Done },
  // Convert__Reg1_2__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem5125_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem5125_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__AVX512RC1_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addAVX512RCOperands, 6, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem5125_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__AVX512RC1_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addAVX512RCOperands, 7, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem645_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem645_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem1285_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem2565_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem1285_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem2565_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem645_2__Reg1_4__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem1285_2__Reg1_4__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem2565_2__Reg1_4__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem1285_0__Reg1_2__Reg1_4__ImmUnsignedi81_5
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Mem2565_0__Reg1_2__Reg1_4__ImmUnsignedi81_5
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Mem645_0__Reg1_2__Reg1_4__ImmUnsignedi81_5
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_3__AVX512RC1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addAVX512RCOperands, 3, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addAVX512RCOperands, 2, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem1285_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem2565_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem5125_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem5125_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem645_2__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_4__Tie0_1_1__Reg1_3__Reg1_2__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Tie0_1_1__Reg1_3__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem1285_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem2565_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem5125_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_Tied, Tie0_1_1, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_8
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 9, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_8
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addImmOperands, 9, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem325_2__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_4__Tie0_1_1__Reg1_3__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_8
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 9, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem645_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem325_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem2565_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem5125_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem5125_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem645_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__AVX512RC1_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addAVX512RCOperands, 4, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Reg1_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem2565_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem5125_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem645_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Reg1_6__AVX512RC1_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addAVX512RCOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem325_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem325_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem645_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem325_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem1285_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem2565_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem645_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem645_1__Reg1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__Mem645_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem325_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem325_1__Reg1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__Mem325_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem2565_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem5125_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem645_1__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem1285_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem2565_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem5125_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem645_4__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem5125_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem5125_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem325_1__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem325_4__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem645_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem325_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem128_RC1285_1__Tie1_1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_1_1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem128_RC1285_1__Tie1_3_3
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_3_3, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem256_RC1285_1__Tie1_1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_1_1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem256_RC1285_1__Tie1_3_3
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_3_3, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem128_RC128X5_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_3_3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem256_RC128X5_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_3_3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem512_RC256X5_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_3_3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem128_RC128X5_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_4_4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem256_RC128X5_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_4_4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem512_RC256X5_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_4_4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem256_RC2565_1__Tie1_1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_1_1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem256_RC2565_1__Tie1_3_3
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_3_3, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem256_RC256X5_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_3_3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem512_RC5125_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_3_3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem256_RC256X5_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_4_4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem512_RC5125_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_4_4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Mem512_RC256X5_3
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_2__Mem512_RC256X5_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Mem512_RC5125_3
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_2__Mem512_RC5125_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Mem256_RC5125_3
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_2__Mem256_RC5125_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem128_RC2565_1__Tie1_1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_1_1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem128_RC2565_1__Tie1_3_3
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_3_3, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem64_RC1285_1__Tie1_1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_1_1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem64_RC1285_1__Tie1_3_3
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_3_3, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem128_RC256X5_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_3_3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem64_RC128X5_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_3_3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem256_RC5125_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_3_3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem128_RC256X5_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_4_4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem256_RC5125_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_4_4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem64_RC128X5_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_4_4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem1285_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem2565_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem5125_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem5125_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem1285_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem645_4__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem2565_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem5125_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem645_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem325_4__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem325_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_8
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addImmOperands, 9, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem85_2__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem85_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem85_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem85_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_Tied, Tie0_1_1, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem85_6__ImmUnsignedi81_8
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 9, CVT_Done },
  // Convert__Reg1_4__Reg1_6__Reg1_3__Mem85_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem1285_2__Reg1_1__Reg1_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem2565_2__Reg1_1__Reg1_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem1285_0__Reg1_1__Reg1_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Mem2565_0__Reg1_1__Reg1_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Mem645_1__Reg1_3__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem645_0__Reg1_2__Reg1_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__Tie0_3_3__Reg1_4__Reg1_1__Reg1_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem325_1__Reg1_3__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem325_0__Reg1_2__Reg1_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem85_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem85_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem85_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem85_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem165_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem165_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem165_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem165_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_17
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_17
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_17
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__imm_95_17
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem5125_2__imm_95_17
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_17
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem2565_0__imm_95_17
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem5125_0__imm_95_17
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_1
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__imm_95_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem5125_2__imm_95_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_1
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem2565_0__imm_95_1
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem5125_0__imm_95_1
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_16
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_16
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_16
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__imm_95_16
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem5125_2__imm_95_16
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_16
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem2565_0__imm_95_16
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem5125_0__imm_95_16
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem5125_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem2565_0__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem5125_0__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem1285_3__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__Reg1_3__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem2565_3__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__Reg1_3__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem1285_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem2565_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__GR32orGR641_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addGR32orGR64Operands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem85_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__GR32orGR641_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addGR32orGR64Operands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem85_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem165_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem165_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem165_1__Reg1_3__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem165_0__Reg1_2__Reg1_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__Mem1285_1__Reg1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Mem1285_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_3__Mem128_RC128X5_1__Tie0_4_4__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, Tie0_4_4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_3__Mem256_RC256X5_1__Tie0_4_4__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, Tie0_4_4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_3__Mem512_RC5125_1__Tie0_4_4__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, Tie0_4_4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Mem128_RC128X5_0__Tie0_3_3__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__Mem256_RC256X5_0__Tie0_3_3__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__Mem512_RC5125_0__Tie0_3_3__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_3__Mem256_RC128X5_1__Tie0_4_4__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, Tie0_4_4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_3__Mem512_RC256X5_1__Tie0_4_4__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, Tie0_4_4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Mem256_RC128X5_0__Tie0_3_3__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__Mem512_RC256X5_0__Tie0_3_3__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_3__Mem128_RC256X5_1__Tie0_4_4__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, Tie0_4_4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_3__Mem64_RC128X5_1__Tie0_4_4__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, Tie0_4_4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_3__Mem256_RC5125_1__Tie0_4_4__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, Tie0_4_4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Mem128_RC256X5_0__Tie0_3_3__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__Mem256_RC5125_0__Tie0_3_3__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__Mem64_RC128X5_0__Tie0_3_3__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Tie0_1_1__Tie1_2_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_2_2, CVT_Done },
  // Convert__Reg1_1__Reg1_0__Tie0_2_2__Tie1_1_1
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Tied, Tie0_2_2, CVT_Tied, Tie1_1_1, CVT_Done },
  // Convert__AbsMem161_0
  { CVT_95_addAbsMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_Done },
  // Convert__regEAX__regEAX__Tie0_1_1__Tie1_1_1
  { CVT_regEAX, 0, CVT_regEAX, 0, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_Done },
};

void X86AsmParser::
convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                const OperandVector &Operands) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  const uint8_t *Converter = ConversionTable[Kind];
  unsigned OpIdx;
  Inst.setOpcode(Opcode);
  for (const uint8_t *p = Converter; *p; p+= 2) {
    OpIdx = *(p + 1);
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      static_cast<X86Operand&>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_Tied: {
      assert(OpIdx < (size_t)(std::end(TiedAsmOperandTable) -
                          std::begin(TiedAsmOperandTable)) &&
             "Tied operand not found");
      unsigned TiedResOpnd = TiedAsmOperandTable[OpIdx][0];
      if (TiedResOpnd != (uint8_t) -1)
        Inst.addOperand(Inst.getOperand(TiedResOpnd));
      break;
    }
    case CVT_imm_95_10:
      Inst.addOperand(MCOperand::createImm(10));
      break;
    case CVT_95_addImmOperands:
      static_cast<X86Operand&>(*Operands[OpIdx]).addImmOperands(Inst, 1);
      break;
    case CVT_regAX:
      Inst.addOperand(MCOperand::createReg(X86::AX));
      break;
    case CVT_regEAX:
      Inst.addOperand(MCOperand::createReg(X86::EAX));
      break;
    case CVT_regRAX:
      Inst.addOperand(MCOperand::createReg(X86::RAX));
      break;
    case CVT_95_Reg:
      static_cast<X86Operand&>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_95_addMemOperands:
      static_cast<X86Operand&>(*Operands[OpIdx]).addMemOperands(Inst, 5);
      break;
    case CVT_95_addAbsMemOperands:
      static_cast<X86Operand&>(*Operands[OpIdx]).addAbsMemOperands(Inst, 1);
      break;
    case CVT_95_addDstIdxOperands:
      static_cast<X86Operand&>(*Operands[OpIdx]).addDstIdxOperands(Inst, 1);
      break;
    case CVT_95_addSrcIdxOperands:
      static_cast<X86Operand&>(*Operands[OpIdx]).addSrcIdxOperands(Inst, 2);
      break;
    case CVT_95_addGR32orGR64Operands:
      static_cast<X86Operand&>(*Operands[OpIdx]).addGR32orGR64Operands(Inst, 1);
      break;
    case CVT_regST1:
      Inst.addOperand(MCOperand::createReg(X86::ST1));
      break;
    case CVT_regST0:
      Inst.addOperand(MCOperand::createReg(X86::ST0));
      break;
    case CVT_95_addMemOffsOperands:
      static_cast<X86Operand&>(*Operands[OpIdx]).addMemOffsOperands(Inst, 2);
      break;
    case CVT_imm_95_17:
      Inst.addOperand(MCOperand::createImm(17));
      break;
    case CVT_imm_95_1:
      Inst.addOperand(MCOperand::createImm(1));
      break;
    case CVT_imm_95_16:
      Inst.addOperand(MCOperand::createImm(16));
      break;
    case CVT_imm_95_0:
      Inst.addOperand(MCOperand::createImm(0));
      break;
    case CVT_95_addAVX512RCOperands:
      static_cast<X86Operand&>(*Operands[OpIdx]).addAVX512RCOperands(Inst, 1);
      break;
    }
  }
}

void X86AsmParser::
convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  unsigned NumMCOperands = 0;
  const uint8_t *Converter = ConversionTable[Kind];
  for (const uint8_t *p = Converter; *p; p+= 2) {
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      ++NumMCOperands;
      break;
    case CVT_Tied:
      ++NumMCOperands;
      break;
    case CVT_imm_95_10:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_regAX:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regEAX:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regRAX:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_95_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      NumMCOperands += 1;
      break;
    case CVT_95_addMemOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 5;
      break;
    case CVT_95_addAbsMemOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addDstIdxOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addSrcIdxOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addGR32orGR64Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_regST1:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regST0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_95_addMemOffsOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_imm_95_17:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_1:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_16:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addAVX512RCOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    }
  }
}

namespace {

/// MatchClassKind - The kinds of classes which participate in
/// instruction matching.
enum MatchClassKind {
  InvalidMatchClass = 0,
  OptionalMatchClass = 1,
  MCK__STAR_, // '*'
  MCK_b, // 'b'
  MCK_d, // 'd'
  MCK_pd, // 'pd'
  MCK_ps, // 'ps'
  MCK_q, // 'q'
  MCK_sd, // 'sd'
  MCK_ss, // 'ss'
  MCK_ub, // 'ub'
  MCK_ud, // 'ud'
  MCK_uq, // 'uq'
  MCK_uw, // 'uw'
  MCK_w, // 'w'
  MCK__123_, // '{'
  MCK__123_1to16_125_, // '{1to16}'
  MCK__123_1to2_125_, // '{1to2}'
  MCK__123_1to4_125_, // '{1to4}'
  MCK__123_1to8_125_, // '{1to8}'
  MCK__123_sae_125_, // '{sae}'
  MCK__123_z_125_, // '{z}'
  MCK__125_, // '}'
  MCK_LAST_TOKEN = MCK__125_,
  MCK_Reg52, // derived register class
  MCK_Reg50, // derived register class
  MCK_AL, // register class 'AL'
  MCK_AX, // register class 'AX'
  MCK_CCR, // register class 'CCR'
  MCK_CL, // register class 'CL'
  MCK_CS, // register class 'CS'
  MCK_DFCCR, // register class 'DFCCR'
  MCK_DS, // register class 'DS'
  MCK_DX, // register class 'DX'
  MCK_EAX, // register class 'EAX'
  MCK_EBX, // register class 'EBX'
  MCK_ECX, // register class 'ECX'
  MCK_EDX, // register class 'EDX'
  MCK_ES, // register class 'ES'
  MCK_FPCCR, // register class 'FPCCR'
  MCK_FS, // register class 'FS'
  MCK_GS, // register class 'GS'
  MCK_RAX, // register class 'RAX'
  MCK_RBX, // register class 'RBX'
  MCK_RCX, // register class 'RCX'
  MCK_RDX, // register class 'RDX'
  MCK_SS, // register class 'SS'
  MCK_ST0, // register class 'ST0'
  MCK_XMM0, // register class 'XMM0'
  MCK_Reg51, // derived register class
  MCK_GR32_AD, // register class 'GR32_AD'
  MCK_GR64_AD, // register class 'GR64_AD'
  MCK_Reg30, // derived register class
  MCK_GR32_TC, // register class 'GR32_TC'
  MCK_Reg46, // derived register class
  MCK_BNDR, // register class 'BNDR'
  MCK_GR16_ABCD, // register class 'GR16_ABCD'
  MCK_GR32_ABCD, // register class 'GR32_ABCD'
  MCK_GR64_ABCD, // register class 'GR64_ABCD'
  MCK_GR8_ABCD_H, // register class 'GR8_ABCD_H'
  MCK_GR8_ABCD_L, // register class 'GR8_ABCD_L'
  MCK_Reg38, // derived register class
  MCK_Reg44, // derived register class
  MCK_Reg41, // derived register class
  MCK_SEGMENT_REG, // register class 'SEGMENT_REG'
  MCK_Reg45, // derived register class
  MCK_Reg42, // derived register class
  MCK_GR32_NOREX_NOSP, // register class 'GR32_NOREX_NOSP'
  MCK_GR64_NOREX_NOSP, // register class 'GR64_NOREX_NOSP'
  MCK_RFP32, // register class 'RFP32,RFP64,RFP80'
  MCK_VK16WM, // register class 'VK16WM,VK1WM,VK2WM,VK4WM,VK8WM,VK32WM,VK64WM'
  MCK_Reg67, // derived register class
  MCK_Reg64, // derived register class
  MCK_Reg39, // derived register class
  MCK_Reg33, // derived register class
  MCK_GR16_NOREX, // register class 'GR16_NOREX'
  MCK_GR32_NOREX, // register class 'GR32_NOREX'
  MCK_GR64_TCW64, // register class 'GR64_TCW64'
  MCK_GR8_NOREX, // register class 'GR8_NOREX'
  MCK_RST, // register class 'RST'
  MCK_VK1, // register class 'VK1,VK16,VK2,VK4,VK8,VK32,VK64'
  MCK_VR128H, // register class 'VR128H'
  MCK_VR128L, // register class 'VR128L'
  MCK_VR256H, // register class 'VR256H'
  MCK_VR256L, // register class 'VR256L'
  MCK_VR64, // register class 'VR64'
  MCK_Reg23, // derived register class
  MCK_GR64_NOREX, // register class 'GR64_NOREX'
  MCK_GR64_TC, // register class 'GR64_TC'
  MCK_GRH8, // register class 'GRH8'
  MCK_GR32_NOSP, // register class 'GR32_NOSP'
  MCK_GR64_NOSP, // register class 'GR64_NOSP'
  MCK_Reg65, // derived register class
  MCK_Reg34, // derived register class
  MCK_CONTROL_REG, // register class 'CONTROL_REG'
  MCK_DEBUG_REG, // register class 'DEBUG_REG'
  MCK_FR32, // register class 'FR32,FR64,VR128'
  MCK_GR16, // register class 'GR16'
  MCK_GR32, // register class 'GR32'
  MCK_VR256, // register class 'VR256'
  MCK_Reg20, // derived register class
  MCK_GR64, // register class 'GR64'
  MCK_GRH16, // register class 'GRH16'
  MCK_LOW32_ADDR_ACCESS, // register class 'LOW32_ADDR_ACCESS'
  MCK_LOW32_ADDR_ACCESS_RBP, // register class 'LOW32_ADDR_ACCESS_RBP'
  MCK_GR8, // register class 'GR8'
  MCK_FR32X, // register class 'FR32X,FR64X,VR128X'
  MCK_VR256X, // register class 'VR256X'
  MCK_VR512, // register class 'VR512'
  MCK_LAST_REGISTER = MCK_VR512,
  MCK_AVX512RC, // user defined class 'AVX512RCOperand'
  MCK_ImmSExti64i8, // user defined class 'ImmSExti64i8AsmOperand'
  MCK_ImmSExti16i8, // user defined class 'ImmSExti16i8AsmOperand'
  MCK_ImmSExti32i8, // user defined class 'ImmSExti32i8AsmOperand'
  MCK_ImmSExti64i32, // user defined class 'ImmSExti64i32AsmOperand'
  MCK_Imm, // user defined class 'ImmAsmOperand'
  MCK_ImmUnsignedi8, // user defined class 'ImmUnsignedi8AsmOperand'
  MCK_GR32orGR64, // user defined class 'X86GR32orGR64AsmOperand'
  MCK_AbsMem16, // user defined class 'X86AbsMem16AsmOperand'
  MCK_DstIdx16, // user defined class 'X86DstIdx16Operand'
  MCK_DstIdx32, // user defined class 'X86DstIdx32Operand'
  MCK_DstIdx64, // user defined class 'X86DstIdx64Operand'
  MCK_DstIdx8, // user defined class 'X86DstIdx8Operand'
  MCK_MemOffs16_16, // user defined class 'X86MemOffs16_16AsmOperand'
  MCK_MemOffs16_32, // user defined class 'X86MemOffs16_32AsmOperand'
  MCK_MemOffs16_8, // user defined class 'X86MemOffs16_8AsmOperand'
  MCK_MemOffs32_16, // user defined class 'X86MemOffs32_16AsmOperand'
  MCK_MemOffs32_32, // user defined class 'X86MemOffs32_32AsmOperand'
  MCK_MemOffs32_64, // user defined class 'X86MemOffs32_64AsmOperand'
  MCK_MemOffs32_8, // user defined class 'X86MemOffs32_8AsmOperand'
  MCK_MemOffs64_16, // user defined class 'X86MemOffs64_16AsmOperand'
  MCK_MemOffs64_32, // user defined class 'X86MemOffs64_32AsmOperand'
  MCK_MemOffs64_64, // user defined class 'X86MemOffs64_64AsmOperand'
  MCK_MemOffs64_8, // user defined class 'X86MemOffs64_8AsmOperand'
  MCK_SrcIdx16, // user defined class 'X86SrcIdx16Operand'
  MCK_SrcIdx32, // user defined class 'X86SrcIdx32Operand'
  MCK_SrcIdx64, // user defined class 'X86SrcIdx64Operand'
  MCK_SrcIdx8, // user defined class 'X86SrcIdx8Operand'
  MCK_AbsMem, // user defined class 'X86AbsMemAsmOperand'
  MCK_Mem128, // user defined class 'X86Mem128AsmOperand'
  MCK_Mem128_RC128, // user defined class 'X86Mem128_RC128Operand'
  MCK_Mem128_RC128X, // user defined class 'X86Mem128_RC128XOperand'
  MCK_Mem128_RC256, // user defined class 'X86Mem128_RC256Operand'
  MCK_Mem128_RC256X, // user defined class 'X86Mem128_RC256XOperand'
  MCK_Mem16, // user defined class 'X86Mem16AsmOperand'
  MCK_Mem256, // user defined class 'X86Mem256AsmOperand'
  MCK_Mem256_RC128, // user defined class 'X86Mem256_RC128Operand'
  MCK_Mem256_RC128X, // user defined class 'X86Mem256_RC128XOperand'
  MCK_Mem256_RC256, // user defined class 'X86Mem256_RC256Operand'
  MCK_Mem256_RC256X, // user defined class 'X86Mem256_RC256XOperand'
  MCK_Mem256_RC512, // user defined class 'X86Mem256_RC512Operand'
  MCK_Mem32, // user defined class 'X86Mem32AsmOperand'
  MCK_Mem512, // user defined class 'X86Mem512AsmOperand'
  MCK_Mem512_RC256X, // user defined class 'X86Mem512_RC256XOperand'
  MCK_Mem512_RC512, // user defined class 'X86Mem512_RC512Operand'
  MCK_Mem64, // user defined class 'X86Mem64AsmOperand'
  MCK_Mem64_RC128, // user defined class 'X86Mem64_RC128Operand'
  MCK_Mem64_RC128X, // user defined class 'X86Mem64_RC128XOperand'
  MCK_Mem80, // user defined class 'X86Mem80AsmOperand'
  MCK_Mem8, // user defined class 'X86Mem8AsmOperand'
  MCK_Mem, // user defined class 'X86MemAsmOperand'
  NumMatchClassKinds
};

}

static unsigned getDiagKindFromRegisterClass(MatchClassKind RegisterClass) {
  return MCTargetAsmParser::Match_InvalidOperand;
}

static MatchClassKind matchTokenString(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 1:	 // 7 strings to match.
    switch (Name[0]) {
    default: break;
    case '*':	 // 1 string to match.
      return MCK__STAR_;	 // "*"
    case 'b':	 // 1 string to match.
      return MCK_b;	 // "b"
    case 'd':	 // 1 string to match.
      return MCK_d;	 // "d"
    case 'q':	 // 1 string to match.
      return MCK_q;	 // "q"
    case 'w':	 // 1 string to match.
      return MCK_w;	 // "w"
    case '{':	 // 1 string to match.
      return MCK__123_;	 // "{"
    case '}':	 // 1 string to match.
      return MCK__125_;	 // "}"
    }
    break;
  case 2:	 // 8 strings to match.
    switch (Name[0]) {
    default: break;
    case 'p':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case 'd':	 // 1 string to match.
        return MCK_pd;	 // "pd"
      case 's':	 // 1 string to match.
        return MCK_ps;	 // "ps"
      }
      break;
    case 's':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case 'd':	 // 1 string to match.
        return MCK_sd;	 // "sd"
      case 's':	 // 1 string to match.
        return MCK_ss;	 // "ss"
      }
      break;
    case 'u':	 // 4 strings to match.
      switch (Name[1]) {
      default: break;
      case 'b':	 // 1 string to match.
        return MCK_ub;	 // "ub"
      case 'd':	 // 1 string to match.
        return MCK_ud;	 // "ud"
      case 'q':	 // 1 string to match.
        return MCK_uq;	 // "uq"
      case 'w':	 // 1 string to match.
        return MCK_uw;	 // "uw"
      }
      break;
    }
    break;
  case 3:	 // 1 string to match.
    if (memcmp(Name.data()+0, "{z}", 3) != 0)
      break;
    return MCK__123_z_125_;	 // "{z}"
  case 5:	 // 1 string to match.
    if (memcmp(Name.data()+0, "{sae}", 5) != 0)
      break;
    return MCK__123_sae_125_;	 // "{sae}"
  case 6:	 // 3 strings to match.
    if (memcmp(Name.data()+0, "{1to", 4) != 0)
      break;
    switch (Name[4]) {
    default: break;
    case '2':	 // 1 string to match.
      if (Name[5] != '}')
        break;
      return MCK__123_1to2_125_;	 // "{1to2}"
    case '4':	 // 1 string to match.
      if (Name[5] != '}')
        break;
      return MCK__123_1to4_125_;	 // "{1to4}"
    case '8':	 // 1 string to match.
      if (Name[5] != '}')
        break;
      return MCK__123_1to8_125_;	 // "{1to8}"
    }
    break;
  case 7:	 // 1 string to match.
    if (memcmp(Name.data()+0, "{1to16}", 7) != 0)
      break;
    return MCK__123_1to16_125_;	 // "{1to16}"
  }
  return InvalidMatchClass;
}

/// isSubclass - Compute whether \p A is a subclass of \p B.
static bool isSubclass(MatchClassKind A, MatchClassKind B) {
  if (A == B)
    return true;

  switch (A) {
  default:
    return false;

  case MCK_Reg52:
    switch (B) {
    default: return false;
    case MCK_Reg51: return true;
    case MCK_Reg46: return true;
    case MCK_Reg41: return true;
    case MCK_Reg45: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_Reg50:
    switch (B) {
    default: return false;
    case MCK_Reg51: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg33: return true;
    case MCK_Reg23: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg34: return true;
    case MCK_Reg20: return true;
    case MCK_GR64: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_AL:
    switch (B) {
    default: return false;
    case MCK_GR8_ABCD_L: return true;
    case MCK_GR8_NOREX: return true;
    case MCK_GR8: return true;
    }

  case MCK_AX:
    switch (B) {
    default: return false;
    case MCK_GR16_ABCD: return true;
    case MCK_GR16_NOREX: return true;
    case MCK_GR16: return true;
    }

  case MCK_CL:
    switch (B) {
    default: return false;
    case MCK_GR8_ABCD_L: return true;
    case MCK_GR8_NOREX: return true;
    case MCK_GR8: return true;
    }

  case MCK_CS:
    return B == MCK_SEGMENT_REG;

  case MCK_DS:
    return B == MCK_SEGMENT_REG;

  case MCK_DX:
    switch (B) {
    default: return false;
    case MCK_GR16_ABCD: return true;
    case MCK_GR16_NOREX: return true;
    case MCK_GR16: return true;
    }

  case MCK_EAX:
    switch (B) {
    default: return false;
    case MCK_GR32_AD: return true;
    case MCK_GR32_TC: return true;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_Reg23: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_EBX:
    switch (B) {
    default: return false;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_Reg23: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_ECX:
    switch (B) {
    default: return false;
    case MCK_GR32_TC: return true;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_Reg23: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_EDX:
    switch (B) {
    default: return false;
    case MCK_GR32_AD: return true;
    case MCK_GR32_TC: return true;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_Reg23: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_ES:
    return B == MCK_SEGMENT_REG;

  case MCK_FS:
    return B == MCK_SEGMENT_REG;

  case MCK_GS:
    return B == MCK_SEGMENT_REG;

  case MCK_RAX:
    switch (B) {
    default: return false;
    case MCK_GR64_AD: return true;
    case MCK_Reg30: return true;
    case MCK_Reg46: return true;
    case MCK_GR64_ABCD: return true;
    case MCK_Reg38: return true;
    case MCK_Reg44: return true;
    case MCK_Reg41: return true;
    case MCK_Reg45: return true;
    case MCK_Reg42: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg39: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg34: return true;
    case MCK_GR64: return true;
    }

  case MCK_RBX:
    switch (B) {
    default: return false;
    case MCK_GR64_ABCD: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg34: return true;
    case MCK_GR64: return true;
    }

  case MCK_RCX:
    switch (B) {
    default: return false;
    case MCK_Reg30: return true;
    case MCK_Reg46: return true;
    case MCK_GR64_ABCD: return true;
    case MCK_Reg38: return true;
    case MCK_Reg44: return true;
    case MCK_Reg41: return true;
    case MCK_Reg45: return true;
    case MCK_Reg42: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg39: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg34: return true;
    case MCK_GR64: return true;
    }

  case MCK_RDX:
    switch (B) {
    default: return false;
    case MCK_GR64_AD: return true;
    case MCK_Reg30: return true;
    case MCK_Reg46: return true;
    case MCK_GR64_ABCD: return true;
    case MCK_Reg38: return true;
    case MCK_Reg44: return true;
    case MCK_Reg41: return true;
    case MCK_Reg45: return true;
    case MCK_Reg42: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg39: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg34: return true;
    case MCK_GR64: return true;
    }

  case MCK_SS:
    return B == MCK_SEGMENT_REG;

  case MCK_ST0:
    return B == MCK_RST;

  case MCK_XMM0:
    switch (B) {
    default: return false;
    case MCK_VR128L: return true;
    case MCK_FR32: return true;
    case MCK_FR32X: return true;
    }

  case MCK_Reg51:
    switch (B) {
    default: return false;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_GR32_AD:
    switch (B) {
    default: return false;
    case MCK_GR32_TC: return true;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_Reg23: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_GR64_AD:
    switch (B) {
    default: return false;
    case MCK_Reg30: return true;
    case MCK_Reg46: return true;
    case MCK_GR64_ABCD: return true;
    case MCK_Reg38: return true;
    case MCK_Reg44: return true;
    case MCK_Reg41: return true;
    case MCK_Reg45: return true;
    case MCK_Reg42: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg39: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg34: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg30:
    switch (B) {
    default: return false;
    case MCK_Reg46: return true;
    case MCK_GR64_ABCD: return true;
    case MCK_Reg38: return true;
    case MCK_Reg44: return true;
    case MCK_Reg41: return true;
    case MCK_Reg45: return true;
    case MCK_Reg42: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg39: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg34: return true;
    case MCK_GR64: return true;
    }

  case MCK_GR32_TC:
    switch (B) {
    default: return false;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_Reg23: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_Reg46:
    switch (B) {
    default: return false;
    case MCK_Reg41: return true;
    case MCK_Reg45: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_GR16_ABCD:
    switch (B) {
    default: return false;
    case MCK_GR16_NOREX: return true;
    case MCK_GR16: return true;
    }

  case MCK_GR32_ABCD:
    switch (B) {
    default: return false;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_Reg23: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_GR64_ABCD:
    switch (B) {
    default: return false;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg34: return true;
    case MCK_GR64: return true;
    }

  case MCK_GR8_ABCD_H:
    switch (B) {
    default: return false;
    case MCK_GR8_NOREX: return true;
    case MCK_GR8: return true;
    }

  case MCK_GR8_ABCD_L:
    switch (B) {
    default: return false;
    case MCK_GR8_NOREX: return true;
    case MCK_GR8: return true;
    }

  case MCK_Reg38:
    switch (B) {
    default: return false;
    case MCK_Reg41: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg39: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg34: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg44:
    switch (B) {
    default: return false;
    case MCK_Reg45: return true;
    case MCK_Reg42: return true;
    case MCK_Reg39: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg34: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg41:
    switch (B) {
    default: return false;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg45:
    switch (B) {
    default: return false;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg42:
    switch (B) {
    default: return false;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg34: return true;
    case MCK_GR64: return true;
    }

  case MCK_GR32_NOREX_NOSP:
    switch (B) {
    default: return false;
    case MCK_GR32_NOREX: return true;
    case MCK_Reg23: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_GR64_NOREX_NOSP:
    switch (B) {
    default: return false;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg34: return true;
    case MCK_GR64: return true;
    }

  case MCK_VK16WM:
    return B == MCK_VK1;

  case MCK_Reg67:
    switch (B) {
    default: return false;
    case MCK_Reg65: return true;
    case MCK_VR512: return true;
    }

  case MCK_Reg64:
    switch (B) {
    default: return false;
    case MCK_Reg65: return true;
    case MCK_VR512: return true;
    }

  case MCK_Reg39:
    switch (B) {
    default: return false;
    case MCK_GR64_TC: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg34: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg33:
    switch (B) {
    default: return false;
    case MCK_GR64_NOREX: return true;
    case MCK_Reg34: return true;
    case MCK_GR64: return true;
    }

  case MCK_GR16_NOREX:
    return B == MCK_GR16;

  case MCK_GR32_NOREX:
    switch (B) {
    default: return false;
    case MCK_Reg23: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_GR64_TCW64:
    return B == MCK_GR64;

  case MCK_GR8_NOREX:
    return B == MCK_GR8;

  case MCK_VR128H:
    switch (B) {
    default: return false;
    case MCK_FR32: return true;
    case MCK_FR32X: return true;
    }

  case MCK_VR128L:
    switch (B) {
    default: return false;
    case MCK_FR32: return true;
    case MCK_FR32X: return true;
    }

  case MCK_VR256H:
    switch (B) {
    default: return false;
    case MCK_VR256: return true;
    case MCK_VR256X: return true;
    }

  case MCK_VR256L:
    switch (B) {
    default: return false;
    case MCK_VR256: return true;
    case MCK_VR256X: return true;
    }

  case MCK_Reg23:
    switch (B) {
    default: return false;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_GR64_NOREX:
    return B == MCK_GR64;

  case MCK_GR64_TC:
    return B == MCK_GR64;

  case MCK_GR32_NOSP:
    switch (B) {
    default: return false;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_GR64_NOSP:
    switch (B) {
    default: return false;
    case MCK_Reg34: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg65:
    return B == MCK_VR512;

  case MCK_Reg34:
    return B == MCK_GR64;

  case MCK_FR32:
    return B == MCK_FR32X;

  case MCK_GR32:
    switch (B) {
    default: return false;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_VR256:
    return B == MCK_VR256X;

  case MCK_Reg20:
    return B == MCK_LOW32_ADDR_ACCESS_RBP;

  case MCK_LOW32_ADDR_ACCESS:
    return B == MCK_LOW32_ADDR_ACCESS_RBP;

  case MCK_ImmSExti64i8:
    switch (B) {
    default: return false;
    case MCK_ImmSExti16i8: return true;
    case MCK_ImmSExti32i8: return true;
    case MCK_ImmSExti64i32: return true;
    case MCK_Imm: return true;
    }

  case MCK_ImmSExti16i8:
    switch (B) {
    default: return false;
    case MCK_ImmSExti64i32: return true;
    case MCK_Imm: return true;
    }

  case MCK_ImmSExti32i8:
    return B == MCK_Imm;

  case MCK_ImmSExti64i32:
    return B == MCK_Imm;

  case MCK_AbsMem16:
    switch (B) {
    default: return false;
    case MCK_AbsMem: return true;
    case MCK_Mem: return true;
    }

  case MCK_DstIdx16:
    switch (B) {
    default: return false;
    case MCK_Mem16: return true;
    case MCK_Mem: return true;
    }

  case MCK_DstIdx32:
    switch (B) {
    default: return false;
    case MCK_Mem32: return true;
    case MCK_Mem: return true;
    }

  case MCK_DstIdx64:
    switch (B) {
    default: return false;
    case MCK_Mem64: return true;
    case MCK_Mem: return true;
    }

  case MCK_DstIdx8:
    switch (B) {
    default: return false;
    case MCK_Mem8: return true;
    case MCK_Mem: return true;
    }

  case MCK_MemOffs16_16:
    switch (B) {
    default: return false;
    case MCK_Mem16: return true;
    case MCK_Mem: return true;
    }

  case MCK_MemOffs16_32:
    switch (B) {
    default: return false;
    case MCK_Mem32: return true;
    case MCK_Mem: return true;
    }

  case MCK_MemOffs16_8:
    switch (B) {
    default: return false;
    case MCK_Mem8: return true;
    case MCK_Mem: return true;
    }

  case MCK_MemOffs32_16:
    switch (B) {
    default: return false;
    case MCK_Mem16: return true;
    case MCK_Mem: return true;
    }

  case MCK_MemOffs32_32:
    switch (B) {
    default: return false;
    case MCK_Mem32: return true;
    case MCK_Mem: return true;
    }

  case MCK_MemOffs32_64:
    switch (B) {
    default: return false;
    case MCK_Mem64: return true;
    case MCK_Mem: return true;
    }

  case MCK_MemOffs32_8:
    switch (B) {
    default: return false;
    case MCK_Mem8: return true;
    case MCK_Mem: return true;
    }

  case MCK_MemOffs64_16:
    switch (B) {
    default: return false;
    case MCK_Mem16: return true;
    case MCK_Mem: return true;
    }

  case MCK_MemOffs64_32:
    switch (B) {
    default: return false;
    case MCK_Mem32: return true;
    case MCK_Mem: return true;
    }

  case MCK_MemOffs64_64:
    switch (B) {
    default: return false;
    case MCK_Mem64: return true;
    case MCK_Mem: return true;
    }

  case MCK_MemOffs64_8:
    switch (B) {
    default: return false;
    case MCK_Mem8: return true;
    case MCK_Mem: return true;
    }

  case MCK_SrcIdx16:
    switch (B) {
    default: return false;
    case MCK_Mem16: return true;
    case MCK_Mem: return true;
    }

  case MCK_SrcIdx32:
    switch (B) {
    default: return false;
    case MCK_Mem32: return true;
    case MCK_Mem: return true;
    }

  case MCK_SrcIdx64:
    switch (B) {
    default: return false;
    case MCK_Mem64: return true;
    case MCK_Mem: return true;
    }

  case MCK_SrcIdx8:
    switch (B) {
    default: return false;
    case MCK_Mem8: return true;
    case MCK_Mem: return true;
    }

  case MCK_AbsMem:
    return B == MCK_Mem;

  case MCK_Mem128:
    return B == MCK_Mem;

  case MCK_Mem128_RC128:
    return B == MCK_Mem;

  case MCK_Mem128_RC128X:
    return B == MCK_Mem;

  case MCK_Mem128_RC256:
    return B == MCK_Mem;

  case MCK_Mem128_RC256X:
    return B == MCK_Mem;

  case MCK_Mem16:
    return B == MCK_Mem;

  case MCK_Mem256:
    return B == MCK_Mem;

  case MCK_Mem256_RC128:
    return B == MCK_Mem;

  case MCK_Mem256_RC128X:
    return B == MCK_Mem;

  case MCK_Mem256_RC256:
    return B == MCK_Mem;

  case MCK_Mem256_RC256X:
    return B == MCK_Mem;

  case MCK_Mem256_RC512:
    return B == MCK_Mem;

  case MCK_Mem32:
    return B == MCK_Mem;

  case MCK_Mem512:
    return B == MCK_Mem;

  case MCK_Mem512_RC256X:
    return B == MCK_Mem;

  case MCK_Mem512_RC512:
    return B == MCK_Mem;

  case MCK_Mem64:
    return B == MCK_Mem;

  case MCK_Mem64_RC128:
    return B == MCK_Mem;

  case MCK_Mem64_RC128X:
    return B == MCK_Mem;

  case MCK_Mem80:
    return B == MCK_Mem;

  case MCK_Mem8:
    return B == MCK_Mem;
  }
}

static unsigned validateOperandClass(MCParsedAsmOperand &GOp, MatchClassKind Kind) {
  X86Operand &Operand = (X86Operand&)GOp;
  if (Kind == InvalidMatchClass)
    return MCTargetAsmParser::Match_InvalidOperand;

  if (Operand.isToken() && Kind <= MCK_LAST_TOKEN)
    return isSubclass(matchTokenString(Operand.getToken()), Kind) ?
             MCTargetAsmParser::Match_Success :
             MCTargetAsmParser::Match_InvalidOperand;

  switch (Kind) {
  default: break;
  // 'AVX512RC' class
  case MCK_AVX512RC: {
    DiagnosticPredicate DP(Operand.isAVX512RC());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ImmSExti64i8' class
  case MCK_ImmSExti64i8: {
    DiagnosticPredicate DP(Operand.isImmSExti64i8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ImmSExti16i8' class
  case MCK_ImmSExti16i8: {
    DiagnosticPredicate DP(Operand.isImmSExti16i8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ImmSExti32i8' class
  case MCK_ImmSExti32i8: {
    DiagnosticPredicate DP(Operand.isImmSExti32i8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ImmSExti64i32' class
  case MCK_ImmSExti64i32: {
    DiagnosticPredicate DP(Operand.isImmSExti64i32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Imm' class
  case MCK_Imm: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ImmUnsignedi8' class
  case MCK_ImmUnsignedi8: {
    DiagnosticPredicate DP(Operand.isImmUnsignedi8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'GR32orGR64' class
  case MCK_GR32orGR64: {
    DiagnosticPredicate DP(Operand.isGR32orGR64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'AbsMem16' class
  case MCK_AbsMem16: {
    DiagnosticPredicate DP(Operand.isAbsMem16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'DstIdx16' class
  case MCK_DstIdx16: {
    DiagnosticPredicate DP(Operand.isDstIdx16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'DstIdx32' class
  case MCK_DstIdx32: {
    DiagnosticPredicate DP(Operand.isDstIdx32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'DstIdx64' class
  case MCK_DstIdx64: {
    DiagnosticPredicate DP(Operand.isDstIdx64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'DstIdx8' class
  case MCK_DstIdx8: {
    DiagnosticPredicate DP(Operand.isDstIdx8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemOffs16_16' class
  case MCK_MemOffs16_16: {
    DiagnosticPredicate DP(Operand.isMemOffs16_16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemOffs16_32' class
  case MCK_MemOffs16_32: {
    DiagnosticPredicate DP(Operand.isMemOffs16_32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemOffs16_8' class
  case MCK_MemOffs16_8: {
    DiagnosticPredicate DP(Operand.isMemOffs16_8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemOffs32_16' class
  case MCK_MemOffs32_16: {
    DiagnosticPredicate DP(Operand.isMemOffs32_16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemOffs32_32' class
  case MCK_MemOffs32_32: {
    DiagnosticPredicate DP(Operand.isMemOffs32_32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemOffs32_64' class
  case MCK_MemOffs32_64: {
    DiagnosticPredicate DP(Operand.isMemOffs32_64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemOffs32_8' class
  case MCK_MemOffs32_8: {
    DiagnosticPredicate DP(Operand.isMemOffs32_8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemOffs64_16' class
  case MCK_MemOffs64_16: {
    DiagnosticPredicate DP(Operand.isMemOffs64_16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemOffs64_32' class
  case MCK_MemOffs64_32: {
    DiagnosticPredicate DP(Operand.isMemOffs64_32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemOffs64_64' class
  case MCK_MemOffs64_64: {
    DiagnosticPredicate DP(Operand.isMemOffs64_64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemOffs64_8' class
  case MCK_MemOffs64_8: {
    DiagnosticPredicate DP(Operand.isMemOffs64_8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'SrcIdx16' class
  case MCK_SrcIdx16: {
    DiagnosticPredicate DP(Operand.isSrcIdx16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'SrcIdx32' class
  case MCK_SrcIdx32: {
    DiagnosticPredicate DP(Operand.isSrcIdx32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'SrcIdx64' class
  case MCK_SrcIdx64: {
    DiagnosticPredicate DP(Operand.isSrcIdx64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'SrcIdx8' class
  case MCK_SrcIdx8: {
    DiagnosticPredicate DP(Operand.isSrcIdx8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'AbsMem' class
  case MCK_AbsMem: {
    DiagnosticPredicate DP(Operand.isAbsMem());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem128' class
  case MCK_Mem128: {
    DiagnosticPredicate DP(Operand.isMem128());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem128_RC128' class
  case MCK_Mem128_RC128: {
    DiagnosticPredicate DP(Operand.isMem128_RC128());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem128_RC128X' class
  case MCK_Mem128_RC128X: {
    DiagnosticPredicate DP(Operand.isMem128_RC128X());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem128_RC256' class
  case MCK_Mem128_RC256: {
    DiagnosticPredicate DP(Operand.isMem128_RC256());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem128_RC256X' class
  case MCK_Mem128_RC256X: {
    DiagnosticPredicate DP(Operand.isMem128_RC256X());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem16' class
  case MCK_Mem16: {
    DiagnosticPredicate DP(Operand.isMem16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem256' class
  case MCK_Mem256: {
    DiagnosticPredicate DP(Operand.isMem256());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem256_RC128' class
  case MCK_Mem256_RC128: {
    DiagnosticPredicate DP(Operand.isMem256_RC128());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem256_RC128X' class
  case MCK_Mem256_RC128X: {
    DiagnosticPredicate DP(Operand.isMem256_RC128X());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem256_RC256' class
  case MCK_Mem256_RC256: {
    DiagnosticPredicate DP(Operand.isMem256_RC256());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem256_RC256X' class
  case MCK_Mem256_RC256X: {
    DiagnosticPredicate DP(Operand.isMem256_RC256X());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem256_RC512' class
  case MCK_Mem256_RC512: {
    DiagnosticPredicate DP(Operand.isMem256_RC512());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem32' class
  case MCK_Mem32: {
    DiagnosticPredicate DP(Operand.isMem32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem512' class
  case MCK_Mem512: {
    DiagnosticPredicate DP(Operand.isMem512());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem512_RC256X' class
  case MCK_Mem512_RC256X: {
    DiagnosticPredicate DP(Operand.isMem512_RC256X());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem512_RC512' class
  case MCK_Mem512_RC512: {
    DiagnosticPredicate DP(Operand.isMem512_RC512());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem64' class
  case MCK_Mem64: {
    DiagnosticPredicate DP(Operand.isMem64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem64_RC128' class
  case MCK_Mem64_RC128: {
    DiagnosticPredicate DP(Operand.isMem64_RC128());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem64_RC128X' class
  case MCK_Mem64_RC128X: {
    DiagnosticPredicate DP(Operand.isMem64_RC128X());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem80' class
  case MCK_Mem80: {
    DiagnosticPredicate DP(Operand.isMem80());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem8' class
  case MCK_Mem8: {
    DiagnosticPredicate DP(Operand.isMem8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem' class
  case MCK_Mem: {
    DiagnosticPredicate DP(Operand.isMem());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  } // end switch (Kind)

  if (Operand.isReg()) {
    MatchClassKind OpKind;
    switch (Operand.getReg()) {
    default: OpKind = InvalidMatchClass; break;
    case X86::AL: OpKind = MCK_AL; break;
    case X86::DL: OpKind = MCK_GR8_ABCD_L; break;
    case X86::CL: OpKind = MCK_CL; break;
    case X86::BL: OpKind = MCK_GR8_ABCD_L; break;
    case X86::AH: OpKind = MCK_GR8_ABCD_H; break;
    case X86::DH: OpKind = MCK_GR8_ABCD_H; break;
    case X86::CH: OpKind = MCK_GR8_ABCD_H; break;
    case X86::BH: OpKind = MCK_GR8_ABCD_H; break;
    case X86::SIL: OpKind = MCK_GR8; break;
    case X86::DIL: OpKind = MCK_GR8; break;
    case X86::BPL: OpKind = MCK_GR8; break;
    case X86::SPL: OpKind = MCK_GR8; break;
    case X86::R8B: OpKind = MCK_GR8; break;
    case X86::R9B: OpKind = MCK_GR8; break;
    case X86::R10B: OpKind = MCK_GR8; break;
    case X86::R11B: OpKind = MCK_GR8; break;
    case X86::R12B: OpKind = MCK_GR8; break;
    case X86::R13B: OpKind = MCK_GR8; break;
    case X86::R14B: OpKind = MCK_GR8; break;
    case X86::R15B: OpKind = MCK_GR8; break;
    case X86::SIH: OpKind = MCK_GRH8; break;
    case X86::DIH: OpKind = MCK_GRH8; break;
    case X86::BPH: OpKind = MCK_GRH8; break;
    case X86::SPH: OpKind = MCK_GRH8; break;
    case X86::R8BH: OpKind = MCK_GRH8; break;
    case X86::R9BH: OpKind = MCK_GRH8; break;
    case X86::R10BH: OpKind = MCK_GRH8; break;
    case X86::R11BH: OpKind = MCK_GRH8; break;
    case X86::R12BH: OpKind = MCK_GRH8; break;
    case X86::R13BH: OpKind = MCK_GRH8; break;
    case X86::R14BH: OpKind = MCK_GRH8; break;
    case X86::R15BH: OpKind = MCK_GRH8; break;
    case X86::HAX: OpKind = MCK_GRH16; break;
    case X86::HDX: OpKind = MCK_GRH16; break;
    case X86::HCX: OpKind = MCK_GRH16; break;
    case X86::HBX: OpKind = MCK_GRH16; break;
    case X86::HSI: OpKind = MCK_GRH16; break;
    case X86::HDI: OpKind = MCK_GRH16; break;
    case X86::HBP: OpKind = MCK_GRH16; break;
    case X86::HSP: OpKind = MCK_GRH16; break;
    case X86::HIP: OpKind = MCK_GRH16; break;
    case X86::R8WH: OpKind = MCK_GRH16; break;
    case X86::R9WH: OpKind = MCK_GRH16; break;
    case X86::R10WH: OpKind = MCK_GRH16; break;
    case X86::R11WH: OpKind = MCK_GRH16; break;
    case X86::R12WH: OpKind = MCK_GRH16; break;
    case X86::R13WH: OpKind = MCK_GRH16; break;
    case X86::R14WH: OpKind = MCK_GRH16; break;
    case X86::R15WH: OpKind = MCK_GRH16; break;
    case X86::AX: OpKind = MCK_AX; break;
    case X86::DX: OpKind = MCK_DX; break;
    case X86::CX: OpKind = MCK_GR16_ABCD; break;
    case X86::BX: OpKind = MCK_GR16_ABCD; break;
    case X86::SI: OpKind = MCK_GR16_NOREX; break;
    case X86::DI: OpKind = MCK_GR16_NOREX; break;
    case X86::BP: OpKind = MCK_GR16_NOREX; break;
    case X86::SP: OpKind = MCK_GR16_NOREX; break;
    case X86::R8W: OpKind = MCK_GR16; break;
    case X86::R9W: OpKind = MCK_GR16; break;
    case X86::R10W: OpKind = MCK_GR16; break;
    case X86::R11W: OpKind = MCK_GR16; break;
    case X86::R12W: OpKind = MCK_GR16; break;
    case X86::R13W: OpKind = MCK_GR16; break;
    case X86::R14W: OpKind = MCK_GR16; break;
    case X86::R15W: OpKind = MCK_GR16; break;
    case X86::EAX: OpKind = MCK_EAX; break;
    case X86::EDX: OpKind = MCK_EDX; break;
    case X86::ECX: OpKind = MCK_ECX; break;
    case X86::EBX: OpKind = MCK_EBX; break;
    case X86::ESI: OpKind = MCK_GR32_NOREX_NOSP; break;
    case X86::EDI: OpKind = MCK_GR32_NOREX_NOSP; break;
    case X86::EBP: OpKind = MCK_GR32_NOREX_NOSP; break;
    case X86::ESP: OpKind = MCK_GR32_NOREX; break;
    case X86::R8D: OpKind = MCK_GR32_NOSP; break;
    case X86::R9D: OpKind = MCK_GR32_NOSP; break;
    case X86::R10D: OpKind = MCK_GR32_NOSP; break;
    case X86::R11D: OpKind = MCK_GR32_NOSP; break;
    case X86::R12D: OpKind = MCK_GR32_NOSP; break;
    case X86::R13D: OpKind = MCK_GR32_NOSP; break;
    case X86::R14D: OpKind = MCK_GR32_NOSP; break;
    case X86::R15D: OpKind = MCK_GR32_NOSP; break;
    case X86::RAX: OpKind = MCK_RAX; break;
    case X86::RDX: OpKind = MCK_RDX; break;
    case X86::RCX: OpKind = MCK_RCX; break;
    case X86::RBX: OpKind = MCK_RBX; break;
    case X86::RSI: OpKind = MCK_Reg38; break;
    case X86::RDI: OpKind = MCK_Reg38; break;
    case X86::RBP: OpKind = MCK_Reg50; break;
    case X86::RSP: OpKind = MCK_Reg33; break;
    case X86::R8: OpKind = MCK_Reg44; break;
    case X86::R9: OpKind = MCK_Reg44; break;
    case X86::R10: OpKind = MCK_Reg42; break;
    case X86::R11: OpKind = MCK_Reg44; break;
    case X86::R12: OpKind = MCK_GR64_NOSP; break;
    case X86::R13: OpKind = MCK_GR64_NOSP; break;
    case X86::R14: OpKind = MCK_GR64_NOSP; break;
    case X86::R15: OpKind = MCK_GR64_NOSP; break;
    case X86::RIP: OpKind = MCK_Reg52; break;
    case X86::MM0: OpKind = MCK_VR64; break;
    case X86::MM1: OpKind = MCK_VR64; break;
    case X86::MM2: OpKind = MCK_VR64; break;
    case X86::MM3: OpKind = MCK_VR64; break;
    case X86::MM4: OpKind = MCK_VR64; break;
    case X86::MM5: OpKind = MCK_VR64; break;
    case X86::MM6: OpKind = MCK_VR64; break;
    case X86::MM7: OpKind = MCK_VR64; break;
    case X86::FP0: OpKind = MCK_RFP32; break;
    case X86::FP1: OpKind = MCK_RFP32; break;
    case X86::FP2: OpKind = MCK_RFP32; break;
    case X86::FP3: OpKind = MCK_RFP32; break;
    case X86::FP4: OpKind = MCK_RFP32; break;
    case X86::FP5: OpKind = MCK_RFP32; break;
    case X86::FP6: OpKind = MCK_RFP32; break;
    case X86::XMM0: OpKind = MCK_XMM0; break;
    case X86::XMM1: OpKind = MCK_VR128L; break;
    case X86::XMM2: OpKind = MCK_VR128L; break;
    case X86::XMM3: OpKind = MCK_VR128L; break;
    case X86::XMM4: OpKind = MCK_VR128L; break;
    case X86::XMM5: OpKind = MCK_VR128L; break;
    case X86::XMM6: OpKind = MCK_VR128L; break;
    case X86::XMM7: OpKind = MCK_VR128L; break;
    case X86::XMM8: OpKind = MCK_VR128H; break;
    case X86::XMM9: OpKind = MCK_VR128H; break;
    case X86::XMM10: OpKind = MCK_VR128H; break;
    case X86::XMM11: OpKind = MCK_VR128H; break;
    case X86::XMM12: OpKind = MCK_VR128H; break;
    case X86::XMM13: OpKind = MCK_VR128H; break;
    case X86::XMM14: OpKind = MCK_VR128H; break;
    case X86::XMM15: OpKind = MCK_VR128H; break;
    case X86::XMM16: OpKind = MCK_FR32X; break;
    case X86::XMM17: OpKind = MCK_FR32X; break;
    case X86::XMM18: OpKind = MCK_FR32X; break;
    case X86::XMM19: OpKind = MCK_FR32X; break;
    case X86::XMM20: OpKind = MCK_FR32X; break;
    case X86::XMM21: OpKind = MCK_FR32X; break;
    case X86::XMM22: OpKind = MCK_FR32X; break;
    case X86::XMM23: OpKind = MCK_FR32X; break;
    case X86::XMM24: OpKind = MCK_FR32X; break;
    case X86::XMM25: OpKind = MCK_FR32X; break;
    case X86::XMM26: OpKind = MCK_FR32X; break;
    case X86::XMM27: OpKind = MCK_FR32X; break;
    case X86::XMM28: OpKind = MCK_FR32X; break;
    case X86::XMM29: OpKind = MCK_FR32X; break;
    case X86::XMM30: OpKind = MCK_FR32X; break;
    case X86::XMM31: OpKind = MCK_FR32X; break;
    case X86::YMM0: OpKind = MCK_VR256L; break;
    case X86::YMM1: OpKind = MCK_VR256L; break;
    case X86::YMM2: OpKind = MCK_VR256L; break;
    case X86::YMM3: OpKind = MCK_VR256L; break;
    case X86::YMM4: OpKind = MCK_VR256L; break;
    case X86::YMM5: OpKind = MCK_VR256L; break;
    case X86::YMM6: OpKind = MCK_VR256L; break;
    case X86::YMM7: OpKind = MCK_VR256L; break;
    case X86::YMM8: OpKind = MCK_VR256H; break;
    case X86::YMM9: OpKind = MCK_VR256H; break;
    case X86::YMM10: OpKind = MCK_VR256H; break;
    case X86::YMM11: OpKind = MCK_VR256H; break;
    case X86::YMM12: OpKind = MCK_VR256H; break;
    case X86::YMM13: OpKind = MCK_VR256H; break;
    case X86::YMM14: OpKind = MCK_VR256H; break;
    case X86::YMM15: OpKind = MCK_VR256H; break;
    case X86::YMM16: OpKind = MCK_VR256X; break;
    case X86::YMM17: OpKind = MCK_VR256X; break;
    case X86::YMM18: OpKind = MCK_VR256X; break;
    case X86::YMM19: OpKind = MCK_VR256X; break;
    case X86::YMM20: OpKind = MCK_VR256X; break;
    case X86::YMM21: OpKind = MCK_VR256X; break;
    case X86::YMM22: OpKind = MCK_VR256X; break;
    case X86::YMM23: OpKind = MCK_VR256X; break;
    case X86::YMM24: OpKind = MCK_VR256X; break;
    case X86::YMM25: OpKind = MCK_VR256X; break;
    case X86::YMM26: OpKind = MCK_VR256X; break;
    case X86::YMM27: OpKind = MCK_VR256X; break;
    case X86::YMM28: OpKind = MCK_VR256X; break;
    case X86::YMM29: OpKind = MCK_VR256X; break;
    case X86::YMM30: OpKind = MCK_VR256X; break;
    case X86::YMM31: OpKind = MCK_VR256X; break;
    case X86::ZMM0: OpKind = MCK_Reg64; break;
    case X86::ZMM1: OpKind = MCK_Reg64; break;
    case X86::ZMM2: OpKind = MCK_Reg64; break;
    case X86::ZMM3: OpKind = MCK_Reg64; break;
    case X86::ZMM4: OpKind = MCK_Reg64; break;
    case X86::ZMM5: OpKind = MCK_Reg64; break;
    case X86::ZMM6: OpKind = MCK_Reg64; break;
    case X86::ZMM7: OpKind = MCK_Reg64; break;
    case X86::ZMM8: OpKind = MCK_Reg67; break;
    case X86::ZMM9: OpKind = MCK_Reg67; break;
    case X86::ZMM10: OpKind = MCK_Reg67; break;
    case X86::ZMM11: OpKind = MCK_Reg67; break;
    case X86::ZMM12: OpKind = MCK_Reg67; break;
    case X86::ZMM13: OpKind = MCK_Reg67; break;
    case X86::ZMM14: OpKind = MCK_Reg67; break;
    case X86::ZMM15: OpKind = MCK_Reg67; break;
    case X86::ZMM16: OpKind = MCK_VR512; break;
    case X86::ZMM17: OpKind = MCK_VR512; break;
    case X86::ZMM18: OpKind = MCK_VR512; break;
    case X86::ZMM19: OpKind = MCK_VR512; break;
    case X86::ZMM20: OpKind = MCK_VR512; break;
    case X86::ZMM21: OpKind = MCK_VR512; break;
    case X86::ZMM22: OpKind = MCK_VR512; break;
    case X86::ZMM23: OpKind = MCK_VR512; break;
    case X86::ZMM24: OpKind = MCK_VR512; break;
    case X86::ZMM25: OpKind = MCK_VR512; break;
    case X86::ZMM26: OpKind = MCK_VR512; break;
    case X86::ZMM27: OpKind = MCK_VR512; break;
    case X86::ZMM28: OpKind = MCK_VR512; break;
    case X86::ZMM29: OpKind = MCK_VR512; break;
    case X86::ZMM30: OpKind = MCK_VR512; break;
    case X86::ZMM31: OpKind = MCK_VR512; break;
    case X86::K0: OpKind = MCK_VK1; break;
    case X86::K1: OpKind = MCK_VK16WM; break;
    case X86::K2: OpKind = MCK_VK16WM; break;
    case X86::K3: OpKind = MCK_VK16WM; break;
    case X86::K4: OpKind = MCK_VK16WM; break;
    case X86::K5: OpKind = MCK_VK16WM; break;
    case X86::K6: OpKind = MCK_VK16WM; break;
    case X86::K7: OpKind = MCK_VK16WM; break;
    case X86::ST0: OpKind = MCK_ST0; break;
    case X86::ST1: OpKind = MCK_RST; break;
    case X86::ST2: OpKind = MCK_RST; break;
    case X86::ST3: OpKind = MCK_RST; break;
    case X86::ST4: OpKind = MCK_RST; break;
    case X86::ST5: OpKind = MCK_RST; break;
    case X86::ST6: OpKind = MCK_RST; break;
    case X86::ST7: OpKind = MCK_RST; break;
    case X86::FPSW: OpKind = MCK_FPCCR; break;
    case X86::EFLAGS: OpKind = MCK_CCR; break;
    case X86::DF: OpKind = MCK_DFCCR; break;
    case X86::CS: OpKind = MCK_CS; break;
    case X86::DS: OpKind = MCK_DS; break;
    case X86::SS: OpKind = MCK_SS; break;
    case X86::ES: OpKind = MCK_ES; break;
    case X86::FS: OpKind = MCK_FS; break;
    case X86::GS: OpKind = MCK_GS; break;
    case X86::DR0: OpKind = MCK_DEBUG_REG; break;
    case X86::DR1: OpKind = MCK_DEBUG_REG; break;
    case X86::DR2: OpKind = MCK_DEBUG_REG; break;
    case X86::DR3: OpKind = MCK_DEBUG_REG; break;
    case X86::DR4: OpKind = MCK_DEBUG_REG; break;
    case X86::DR5: OpKind = MCK_DEBUG_REG; break;
    case X86::DR6: OpKind = MCK_DEBUG_REG; break;
    case X86::DR7: OpKind = MCK_DEBUG_REG; break;
    case X86::DR8: OpKind = MCK_DEBUG_REG; break;
    case X86::DR9: OpKind = MCK_DEBUG_REG; break;
    case X86::DR10: OpKind = MCK_DEBUG_REG; break;
    case X86::DR11: OpKind = MCK_DEBUG_REG; break;
    case X86::DR12: OpKind = MCK_DEBUG_REG; break;
    case X86::DR13: OpKind = MCK_DEBUG_REG; break;
    case X86::DR14: OpKind = MCK_DEBUG_REG; break;
    case X86::DR15: OpKind = MCK_DEBUG_REG; break;
    case X86::CR0: OpKind = MCK_CONTROL_REG; break;
    case X86::CR1: OpKind = MCK_CONTROL_REG; break;
    case X86::CR2: OpKind = MCK_CONTROL_REG; break;
    case X86::CR3: OpKind = MCK_CONTROL_REG; break;
    case X86::CR4: OpKind = MCK_CONTROL_REG; break;
    case X86::CR5: OpKind = MCK_CONTROL_REG; break;
    case X86::CR6: OpKind = MCK_CONTROL_REG; break;
    case X86::CR7: OpKind = MCK_CONTROL_REG; break;
    case X86::CR8: OpKind = MCK_CONTROL_REG; break;
    case X86::CR9: OpKind = MCK_CONTROL_REG; break;
    case X86::CR10: OpKind = MCK_CONTROL_REG; break;
    case X86::CR11: OpKind = MCK_CONTROL_REG; break;
    case X86::CR12: OpKind = MCK_CONTROL_REG; break;
    case X86::CR13: OpKind = MCK_CONTROL_REG; break;
    case X86::CR14: OpKind = MCK_CONTROL_REG; break;
    case X86::CR15: OpKind = MCK_CONTROL_REG; break;
    case X86::BND0: OpKind = MCK_BNDR; break;
    case X86::BND1: OpKind = MCK_BNDR; break;
    case X86::BND2: OpKind = MCK_BNDR; break;
    case X86::BND3: OpKind = MCK_BNDR; break;
    }
    return isSubclass(OpKind, Kind) ? (unsigned)MCTargetAsmParser::Match_Success :
                                      getDiagKindFromRegisterClass(Kind);
  }

  if (Kind > MCK_LAST_TOKEN && Kind <= MCK_LAST_REGISTER)
    return getDiagKindFromRegisterClass(Kind);

  return MCTargetAsmParser::Match_InvalidOperand;
}

#ifndef NDEBUG
const char *getMatchClassName(MatchClassKind Kind) {
  switch (Kind) {
  case InvalidMatchClass: return "InvalidMatchClass";
  case OptionalMatchClass: return "OptionalMatchClass";
  case MCK__STAR_: return "MCK__STAR_";
  case MCK_b: return "MCK_b";
  case MCK_d: return "MCK_d";
  case MCK_pd: return "MCK_pd";
  case MCK_ps: return "MCK_ps";
  case MCK_q: return "MCK_q";
  case MCK_sd: return "MCK_sd";
  case MCK_ss: return "MCK_ss";
  case MCK_ub: return "MCK_ub";
  case MCK_ud: return "MCK_ud";
  case MCK_uq: return "MCK_uq";
  case MCK_uw: return "MCK_uw";
  case MCK_w: return "MCK_w";
  case MCK__123_: return "MCK__123_";
  case MCK__123_1to16_125_: return "MCK__123_1to16_125_";
  case MCK__123_1to2_125_: return "MCK__123_1to2_125_";
  case MCK__123_1to4_125_: return "MCK__123_1to4_125_";
  case MCK__123_1to8_125_: return "MCK__123_1to8_125_";
  case MCK__123_sae_125_: return "MCK__123_sae_125_";
  case MCK__123_z_125_: return "MCK__123_z_125_";
  case MCK__125_: return "MCK__125_";
  case MCK_Reg52: return "MCK_Reg52";
  case MCK_Reg50: return "MCK_Reg50";
  case MCK_AL: return "MCK_AL";
  case MCK_AX: return "MCK_AX";
  case MCK_CCR: return "MCK_CCR";
  case MCK_CL: return "MCK_CL";
  case MCK_CS: return "MCK_CS";
  case MCK_DFCCR: return "MCK_DFCCR";
  case MCK_DS: return "MCK_DS";
  case MCK_DX: return "MCK_DX";
  case MCK_EAX: return "MCK_EAX";
  case MCK_EBX: return "MCK_EBX";
  case MCK_ECX: return "MCK_ECX";
  case MCK_EDX: return "MCK_EDX";
  case MCK_ES: return "MCK_ES";
  case MCK_FPCCR: return "MCK_FPCCR";
  case MCK_FS: return "MCK_FS";
  case MCK_GS: return "MCK_GS";
  case MCK_RAX: return "MCK_RAX";
  case MCK_RBX: return "MCK_RBX";
  case MCK_RCX: return "MCK_RCX";
  case MCK_RDX: return "MCK_RDX";
  case MCK_SS: return "MCK_SS";
  case MCK_ST0: return "MCK_ST0";
  case MCK_XMM0: return "MCK_XMM0";
  case MCK_Reg51: return "MCK_Reg51";
  case MCK_GR32_AD: return "MCK_GR32_AD";
  case MCK_GR64_AD: return "MCK_GR64_AD";
  case MCK_Reg30: return "MCK_Reg30";
  case MCK_GR32_TC: return "MCK_GR32_TC";
  case MCK_Reg46: return "MCK_Reg46";
  case MCK_BNDR: return "MCK_BNDR";
  case MCK_GR16_ABCD: return "MCK_GR16_ABCD";
  case MCK_GR32_ABCD: return "MCK_GR32_ABCD";
  case MCK_GR64_ABCD: return "MCK_GR64_ABCD";
  case MCK_GR8_ABCD_H: return "MCK_GR8_ABCD_H";
  case MCK_GR8_ABCD_L: return "MCK_GR8_ABCD_L";
  case MCK_Reg38: return "MCK_Reg38";
  case MCK_Reg44: return "MCK_Reg44";
  case MCK_Reg41: return "MCK_Reg41";
  case MCK_SEGMENT_REG: return "MCK_SEGMENT_REG";
  case MCK_Reg45: return "MCK_Reg45";
  case MCK_Reg42: return "MCK_Reg42";
  case MCK_GR32_NOREX_NOSP: return "MCK_GR32_NOREX_NOSP";
  case MCK_GR64_NOREX_NOSP: return "MCK_GR64_NOREX_NOSP";
  case MCK_RFP32: return "MCK_RFP32";
  case MCK_VK16WM: return "MCK_VK16WM";
  case MCK_Reg67: return "MCK_Reg67";
  case MCK_Reg64: return "MCK_Reg64";
  case MCK_Reg39: return "MCK_Reg39";
  case MCK_Reg33: return "MCK_Reg33";
  case MCK_GR16_NOREX: return "MCK_GR16_NOREX";
  case MCK_GR32_NOREX: return "MCK_GR32_NOREX";
  case MCK_GR64_TCW64: return "MCK_GR64_TCW64";
  case MCK_GR8_NOREX: return "MCK_GR8_NOREX";
  case MCK_RST: return "MCK_RST";
  case MCK_VK1: return "MCK_VK1";
  case MCK_VR128H: return "MCK_VR128H";
  case MCK_VR128L: return "MCK_VR128L";
  case MCK_VR256H: return "MCK_VR256H";
  case MCK_VR256L: return "MCK_VR256L";
  case MCK_VR64: return "MCK_VR64";
  case MCK_Reg23: return "MCK_Reg23";
  case MCK_GR64_NOREX: return "MCK_GR64_NOREX";
  case MCK_GR64_TC: return "MCK_GR64_TC";
  case MCK_GRH8: return "MCK_GRH8";
  case MCK_GR32_NOSP: return "MCK_GR32_NOSP";
  case MCK_GR64_NOSP: return "MCK_GR64_NOSP";
  case MCK_Reg65: return "MCK_Reg65";
  case MCK_Reg34: return "MCK_Reg34";
  case MCK_CONTROL_REG: return "MCK_CONTROL_REG";
  case MCK_DEBUG_REG: return "MCK_DEBUG_REG";
  case MCK_FR32: return "MCK_FR32";
  case MCK_GR16: return "MCK_GR16";
  case MCK_GR32: return "MCK_GR32";
  case MCK_VR256: return "MCK_VR256";
  case MCK_Reg20: return "MCK_Reg20";
  case MCK_GR64: return "MCK_GR64";
  case MCK_GRH16: return "MCK_GRH16";
  case MCK_LOW32_ADDR_ACCESS: return "MCK_LOW32_ADDR_ACCESS";
  case MCK_LOW32_ADDR_ACCESS_RBP: return "MCK_LOW32_ADDR_ACCESS_RBP";
  case MCK_GR8: return "MCK_GR8";
  case MCK_FR32X: return "MCK_FR32X";
  case MCK_VR256X: return "MCK_VR256X";
  case MCK_VR512: return "MCK_VR512";
  case MCK_AVX512RC: return "MCK_AVX512RC";
  case MCK_ImmSExti64i8: return "MCK_ImmSExti64i8";
  case MCK_ImmSExti16i8: return "MCK_ImmSExti16i8";
  case MCK_ImmSExti32i8: return "MCK_ImmSExti32i8";
  case MCK_ImmSExti64i32: return "MCK_ImmSExti64i32";
  case MCK_Imm: return "MCK_Imm";
  case MCK_ImmUnsignedi8: return "MCK_ImmUnsignedi8";
  case MCK_GR32orGR64: return "MCK_GR32orGR64";
  case MCK_AbsMem16: return "MCK_AbsMem16";
  case MCK_DstIdx16: return "MCK_DstIdx16";
  case MCK_DstIdx32: return "MCK_DstIdx32";
  case MCK_DstIdx64: return "MCK_DstIdx64";
  case MCK_DstIdx8: return "MCK_DstIdx8";
  case MCK_MemOffs16_16: return "MCK_MemOffs16_16";
  case MCK_MemOffs16_32: return "MCK_MemOffs16_32";
  case MCK_MemOffs16_8: return "MCK_MemOffs16_8";
  case MCK_MemOffs32_16: return "MCK_MemOffs32_16";
  case MCK_MemOffs32_32: return "MCK_MemOffs32_32";
  case MCK_MemOffs32_64: return "MCK_MemOffs32_64";
  case MCK_MemOffs32_8: return "MCK_MemOffs32_8";
  case MCK_MemOffs64_16: return "MCK_MemOffs64_16";
  case MCK_MemOffs64_32: return "MCK_MemOffs64_32";
  case MCK_MemOffs64_64: return "MCK_MemOffs64_64";
  case MCK_MemOffs64_8: return "MCK_MemOffs64_8";
  case MCK_SrcIdx16: return "MCK_SrcIdx16";
  case MCK_SrcIdx32: return "MCK_SrcIdx32";
  case MCK_SrcIdx64: return "MCK_SrcIdx64";
  case MCK_SrcIdx8: return "MCK_SrcIdx8";
  case MCK_AbsMem: return "MCK_AbsMem";
  case MCK_Mem128: return "MCK_Mem128";
  case MCK_Mem128_RC128: return "MCK_Mem128_RC128";
  case MCK_Mem128_RC128X: return "MCK_Mem128_RC128X";
  case MCK_Mem128_RC256: return "MCK_Mem128_RC256";
  case MCK_Mem128_RC256X: return "MCK_Mem128_RC256X";
  case MCK_Mem16: return "MCK_Mem16";
  case MCK_Mem256: return "MCK_Mem256";
  case MCK_Mem256_RC128: return "MCK_Mem256_RC128";
  case MCK_Mem256_RC128X: return "MCK_Mem256_RC128X";
  case MCK_Mem256_RC256: return "MCK_Mem256_RC256";
  case MCK_Mem256_RC256X: return "MCK_Mem256_RC256X";
  case MCK_Mem256_RC512: return "MCK_Mem256_RC512";
  case MCK_Mem32: return "MCK_Mem32";
  case MCK_Mem512: return "MCK_Mem512";
  case MCK_Mem512_RC256X: return "MCK_Mem512_RC256X";
  case MCK_Mem512_RC512: return "MCK_Mem512_RC512";
  case MCK_Mem64: return "MCK_Mem64";
  case MCK_Mem64_RC128: return "MCK_Mem64_RC128";
  case MCK_Mem64_RC128X: return "MCK_Mem64_RC128X";
  case MCK_Mem80: return "MCK_Mem80";
  case MCK_Mem8: return "MCK_Mem8";
  case MCK_Mem: return "MCK_Mem";
  case NumMatchClassKinds: return "NumMatchClassKinds";
  }
  llvm_unreachable("unhandled MatchClassKind!");
}

#endif // NDEBUG
uint64_t X86AsmParser::
ComputeAvailableFeatures(const FeatureBitset& FB) const {
  uint64_t Features = 0;
  if ((!FB[X86::Mode64Bit]))
    Features |= Feature_Not64BitMode;
  if ((FB[X86::Mode64Bit]))
    Features |= Feature_In64BitMode;
  if ((FB[X86::Mode16Bit]))
    Features |= Feature_In16BitMode;
  if ((!FB[X86::Mode16Bit]))
    Features |= Feature_Not16BitMode;
  if ((FB[X86::Mode32Bit]))
    Features |= Feature_In32BitMode;
  return Features;
}

static bool checkAsmTiedOperandConstraints(const X86AsmParser&AsmParser,
                               unsigned Kind,
                               const OperandVector &Operands,
                               uint64_t &ErrorInfo) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  const uint8_t *Converter = ConversionTable[Kind];
  for (const uint8_t *p = Converter; *p; p+= 2) {
    switch (*p) {
    case CVT_Tied: {
      unsigned OpIdx = *(p+1);
      assert(OpIdx < (size_t)(std::end(TiedAsmOperandTable) -
                              std::begin(TiedAsmOperandTable)) &&
             "Tied operand not found");
      unsigned OpndNum1 = TiedAsmOperandTable[OpIdx][1];
      unsigned OpndNum2 = TiedAsmOperandTable[OpIdx][2];
      if (OpndNum1 != OpndNum2) {
        auto &SrcOp1 = Operands[OpndNum1];
        auto &SrcOp2 = Operands[OpndNum2];
        if (SrcOp1->isReg() && SrcOp2->isReg()) {
          if (!AsmParser.regsEqual(*SrcOp1, *SrcOp2)) {
            ErrorInfo = OpndNum2;
            return false;
          }
        }
      }
      break;
    }
    default:
      break;
    }
  }
  return true;
}

static const char *const MnemonicTable =
    "\003aaa\003aad\003aam\003aas\003adc\004adcb\004adcl\004adcq\004adcw\004"
    "adcx\005adcxl\005adcxq\003add\004addb\004addl\005addpd\005addps\004addq"
    "\005addsd\005addss\010addsubpd\010addsubps\004addw\004adox\005adoxl\005"
    "adoxq\006aesdec\naesdeclast\006aesenc\naesenclast\006aesimc\017aeskeyge"
    "nassist\003and\004andb\004andl\004andn\005andnl\006andnpd\006andnps\005"
    "andnq\005andpd\005andps\004andq\004andw\004arpl\005bextr\006bextrl\006b"
    "extrq\007blcfill\010blcfilll\010blcfillq\004blci\005blcic\006blcicl\006"
    "blcicq\005blcil\005blciq\006blcmsk\007blcmskl\007blcmskq\004blcs\005blc"
    "sl\005blcsq\007blendpd\007blendps\010blendvpd\010blendvps\007blsfill\010"
    "blsfilll\010blsfillq\004blsi\005blsic\006blsicl\006blsicq\005blsil\005b"
    "lsiq\006blsmsk\007blsmskl\007blsmskq\004blsr\005blsrl\005blsrq\005bndcl"
    "\005bndcn\005bndcu\006bndldx\005bndmk\006bndmov\006bndstx\005bound\003b"
    "sf\004bsfl\004bsfq\004bsfw\003bsr\004bsrl\004bsrq\004bsrw\005bswap\006b"
    "swapl\006bswapq\002bt\003btc\004btcl\004btcq\004btcw\003btl\003btq\003b"
    "tr\004btrl\004btrq\004btrw\003bts\004btsl\004btsq\004btsw\003btw\004bzh"
    "i\005bzhil\005bzhiq\004call\005calll\005callq\005callw\004cbtw\003cbw\003"
    "cdq\004cdqe\004clac\003clc\003cld\010cldemote\007clflush\nclflushopt\004"
    "clgi\003cli\003clr\004clrb\004clrl\004clrq\010clrssbsy\004clrw\004cltd\004"
    "cltq\004clts\004clwb\006clzero\003cmc\005cmova\006cmovae\007cmovael\007"
    "cmovaeq\007cmovaew\006cmoval\006cmovaq\006cmovaw\005cmovb\006cmovbe\007"
    "cmovbel\007cmovbeq\007cmovbew\006cmovbl\006cmovbq\006cmovbw\005cmove\006"
    "cmovel\006cmoveq\006cmovew\005cmovg\006cmovge\007cmovgel\007cmovgeq\007"
    "cmovgew\006cmovgl\006cmovgq\006cmovgw\005cmovl\006cmovle\007cmovlel\007"
    "cmovleq\007cmovlew\006cmovll\006cmovlq\006cmovlw\006cmovne\007cmovnel\007"
    "cmovneq\007cmovnew\006cmovno\007cmovnol\007cmovnoq\007cmovnow\006cmovnp"
    "\007cmovnpl\007cmovnpq\007cmovnpw\006cmovns\007cmovnsl\007cmovnsq\007cm"
    "ovnsw\005cmovo\006cmovol\006cmovoq\006cmovow\005cmovp\006cmovpl\006cmov"
    "pq\006cmovpw\005cmovs\006cmovsl\006cmovsq\006cmovsw\003cmp\004cmpb\004c"
    "mpl\005cmppd\005cmpps\004cmpq\004cmps\005cmpsb\005cmpsd\005cmpsl\005cmp"
    "sq\005cmpss\005cmpsw\004cmpw\007cmpxchg\ncmpxchg16b\tcmpxchg8b\010cmpxc"
    "hgb\010cmpxchgl\010cmpxchgq\010cmpxchgw\006comisd\006comiss\005cpuid\003"
    "cqo\004cqto\005crc32\006crc32b\006crc32l\006crc32q\006crc32w\002cs\010c"
    "vtdq2pd\010cvtdq2ps\010cvtpd2dq\010cvtpd2pi\010cvtpd2ps\010cvtpi2pd\010"
    "cvtpi2ps\010cvtps2dq\010cvtps2pd\010cvtps2pi\010cvtsd2si\tcvtsd2sil\tcv"
    "tsd2siq\010cvtsd2ss\010cvtsi2sd\tcvtsi2sdl\tcvtsi2sdq\010cvtsi2ss\tcvts"
    "i2ssl\tcvtsi2ssq\010cvtss2sd\010cvtss2si\tcvtss2sil\tcvtss2siq\tcvttpd2"
    "dq\tcvttpd2pi\tcvttps2dq\tcvttps2pi\tcvttsd2si\ncvttsd2sil\ncvttsd2siq\t"
    "cvttss2si\ncvttss2sil\ncvttss2siq\003cwd\004cwde\004cwtd\004cwtl\003daa"
    "\003das\006data16\003dec\004decb\004decl\004decq\004decw\003div\004divb"
    "\004divl\005divpd\005divps\004divq\005divsd\005divss\004divw\004dppd\004"
    "dpps\002ds\004emms\005encls\005enclu\005enclv\007endbr32\007endbr64\005"
    "enter\002es\textractps\005extrq\005f2xm1\004fabs\004fadd\005faddl\005fa"
    "ddp\005fadds\004fbld\005fbstp\004fchs\006fcmovb\007fcmovbe\006fcmove\007"
    "fcmovnb\010fcmovnbe\007fcmovne\007fcmovnu\006fcmovu\004fcom\005fcomi\005"
    "fcoml\005fcomp\006fcompi\006fcompl\006fcompp\006fcomps\005fcoms\004fcos"
    "\007fdecstp\004fdiv\005fdivl\005fdivp\005fdivr\006fdivrl\006fdivrp\006f"
    "divrs\005fdivs\005femms\005ffree\006ffreep\005fiadd\006fiaddl\006fiadds"
    "\005ficom\006ficoml\006ficomp\007ficompl\007ficomps\006ficoms\005fidiv\006"
    "fidivl\006fidivr\007fidivrl\007fidivrs\006fidivs\004fild\005fildl\006fi"
    "ldll\005filds\005fimul\006fimull\006fimuls\007fincstp\004fist\005fistl\005"
    "fistp\006fistpl\007fistpll\006fistps\005fists\006fisttp\007fisttpl\010f"
    "isttpll\007fisttps\005fisub\006fisubl\006fisubr\007fisubrl\007fisubrs\006"
    "fisubs\003fld\004fld1\005fldcw\006fldenv\004fldl\006fldl2e\006fldl2t\006"
    "fldlg2\006fldln2\005fldpi\004flds\004fldt\004fldz\004fmul\005fmull\005f"
    "mulp\005fmuls\006fnclex\006fninit\004fnop\006fnsave\006fnstcw\007fnsten"
    "v\006fnstsw\006fpatan\005fprem\006fprem1\005fptan\007frndint\006frstor\002"
    "fs\006fscale\004fsin\007fsincos\005fsqrt\003fst\004fstl\004fstp\005fstp"
    "l\005fstps\005fstpt\004fsts\004fsub\005fsubl\005fsubp\005fsubr\006fsubr"
    "l\006fsubrp\006fsubrs\005fsubs\004ftst\005fucom\006fucomi\006fucomp\007"
    "fucompi\007fucompp\004fxam\004fxch\007fxrstor\tfxrstor64\006fxsave\010f"
    "xsave64\007fxtract\005fyl2x\007fyl2xp1\006getsec\020gf2p8affineinvqb\015"
    "gf2p8affineqb\tgf2p8mulb\002gs\006haddpd\006haddps\003hlt\006hsubpd\006"
    "hsubps\004idiv\005idivb\005idivl\005idivq\005idivw\004imul\005imulb\005"
    "imull\005imulq\005imulw\002in\003inb\003inc\004incb\004incl\004incq\007"
    "incsspd\007incsspq\004incw\003inl\003ins\004insb\004insd\010insertps\007"
    "insertq\004insl\004insw\003int\004int3\004into\004invd\006invept\006inv"
    "lpg\007invlpga\007invpcid\007invvpid\003inw\004iret\005iretd\005iretl\005"
    "iretq\005iretw\002ja\003jae\002jb\003jbe\004jcxz\002je\005jecxz\002jg\003"
    "jge\002jl\003jle\003jmp\004jmpl\004jmpq\004jmpw\003jne\003jno\003jnp\003"
    "jns\002jo\002jp\005jrcxz\002js\005kaddb\005kaddd\005kaddq\005kaddw\005k"
    "andb\005kandd\006kandnb\006kandnd\006kandnq\006kandnw\005kandq\005kandw"
    "\005kmovb\005kmovd\005kmovq\005kmovw\005knotb\005knotd\005knotq\005knot"
    "w\004korb\004kord\004korq\010kortestb\010kortestd\010kortestq\010kortes"
    "tw\004korw\010kshiftlb\010kshiftld\010kshiftlq\010kshiftlw\010kshiftrb\010"
    "kshiftrd\010kshiftrq\010kshiftrw\006ktestb\006ktestd\006ktestq\006ktest"
    "w\010kunpckbw\010kunpckdq\010kunpckwd\006kxnorb\006kxnord\006kxnorq\006"
    "kxnorw\005kxorb\005kxord\005kxorq\005kxorw\004lahf\003lar\004larl\004la"
    "rq\004larw\005lcall\006lcalll\006lcallq\006lcallw\005lddqu\007ldmxcsr\003"
    "lds\004ldsl\004ldsw\003lea\004leal\004leaq\005leave\004leaw\003les\004l"
    "esl\004lesw\006lfence\003lfs\004lfsl\004lfsq\004lfsw\004lgdt\005lgdtd\005"
    "lgdtl\005lgdtq\005lgdtw\003lgs\004lgsl\004lgsq\004lgsw\004lidt\005lidtd"
    "\005lidtl\005lidtq\005lidtw\004ljmp\005ljmpl\005ljmpq\005ljmpw\004lldt\005"
    "lldtw\006llwpcb\004lmsw\005lmsww\004lock\004lods\005lodsb\005lodsd\005l"
    "odsl\005lodsq\005lodsw\004loop\005loope\006loopne\005lretl\005lretq\005"
    "lretw\003lsl\004lsll\004lslq\004lslw\003lss\004lssl\004lssq\004lssw\003"
    "ltr\004ltrw\006lwpins\006lwpval\005lzcnt\006lzcntl\006lzcntq\006lzcntw\n"
    "maskmovdqu\010maskmovq\005maxpd\005maxps\005maxsd\005maxss\006mfence\005"
    "minpd\005minps\005minsd\005minss\007monitor\010monitorx\007montmul\003m"
    "ov\005mov.s\006movabs\007movabsb\007movabsl\007movabsq\007movabsw\006mo"
    "vapd\010movapd.s\006movaps\010movaps.s\004movb\006movb.s\005movbe\006mo"
    "vbel\006movbeq\006movbew\004movd\007movddup\tmovdir64b\007movdiri\007mo"
    "vdq2q\006movdqa\010movdqa.s\006movdqu\010movdqu.s\007movhlps\006movhpd\006"
    "movhps\004movl\006movl.s\007movlhps\006movlpd\006movlps\010movmskpd\010"
    "movmskps\007movntdq\010movntdqa\006movnti\007movntil\007movntiq\007movn"
    "tpd\007movntps\006movntq\007movntsd\007movntss\004movq\006movq.s\007mov"
    "q2dq\004movs\005movsb\006movsbl\006movsbq\006movsbw\005movsd\007movsd.s"
    "\010movshdup\005movsl\010movsldup\006movslq\005movsq\005movss\007movss."
    "s\005movsw\006movswl\006movswq\005movsx\006movsxd\006movupd\010movupd.s"
    "\006movups\010movups.s\004movw\006movw.s\006movzbl\006movzbq\006movzbw\006"
    "movzwl\006movzwq\005movzx\007mpsadbw\003mul\004mulb\004mull\005mulpd\005"
    "mulps\004mulq\005mulsd\005mulss\004mulw\004mulx\005mulxl\005mulxq\005mw"
    "ait\006mwaitx\003neg\004negb\004negl\004negq\004negw\003nop\004nopl\004"
    "nopq\004nopw\003not\004notb\004notl\004notq\004notw\002or\003orb\003orl"
    "\004orpd\004orps\003orq\003orw\003out\004outb\004outl\004outs\005outsb\005"
    "outsd\005outsl\005outsw\004outw\005pabsb\005pabsd\005pabsw\010packssdw\010"
    "packsswb\010packusdw\010packuswb\005paddb\005paddd\005paddq\006paddsb\006"
    "paddsw\007paddusb\007paddusw\005paddw\007palignr\004pand\005pandn\005pa"
    "use\005pavgb\007pavgusb\005pavgw\010pblendvb\007pblendw\014pclmulhqhqdq"
    "\014pclmulhqlqdq\014pclmullqhqdq\014pclmullqlqdq\tpclmulqdq\007pcmpeqb\007"
    "pcmpeqd\007pcmpeqq\007pcmpeqw\tpcmpestri\tpcmpestrm\007pcmpgtb\007pcmpg"
    "td\007pcmpgtq\007pcmpgtw\tpcmpistri\tpcmpistrm\007pconfig\004pdep\005pd"
    "epl\005pdepq\004pext\005pextl\005pextq\006pextrb\006pextrd\006pextrq\006"
    "pextrw\005pf2id\005pf2iw\005pfacc\005pfadd\007pfcmpeq\007pfcmpge\007pfc"
    "mpgt\005pfmax\005pfmin\005pfmul\006pfnacc\007pfpnacc\005pfrcp\010pfrcpi"
    "t1\010pfrcpit2\010pfrsqit1\007pfrsqrt\005pfsub\006pfsubr\006phaddd\007p"
    "haddsw\006phaddw\nphminposuw\006phsubd\007phsubsw\006phsubw\005pi2fd\005"
    "pi2fw\006pinsrb\006pinsrd\006pinsrq\006pinsrw\tpmaddubsw\007pmaddwd\006"
    "pmaxsb\006pmaxsd\006pmaxsw\006pmaxub\006pmaxud\006pmaxuw\006pminsb\006p"
    "minsd\006pminsw\006pminub\006pminud\006pminuw\010pmovmskb\010pmovsxbd\010"
    "pmovsxbq\010pmovsxbw\010pmovsxdq\010pmovsxwd\010pmovsxwq\010pmovzxbd\010"
    "pmovzxbq\010pmovzxbw\010pmovzxdq\010pmovzxwd\010pmovzxwq\006pmuldq\010p"
    "mulhrsw\007pmulhrw\007pmulhuw\006pmulhw\006pmulld\006pmullw\007pmuludq\003"
    "pop\005popal\005popaw\006popcnt\007popcntl\007popcntq\007popcntw\004pop"
    "f\005popfd\005popfl\005popfq\005popfw\004popl\004popq\004popw\003por\010"
    "prefetch\013prefetchnta\nprefetcht0\nprefetcht1\nprefetcht2\tprefetchw\013"
    "prefetchwt1\006psadbw\006pshufb\006pshufd\007pshufhw\007pshuflw\006pshu"
    "fw\006psignb\006psignd\006psignw\005pslld\006pslldq\005psllq\005psllw\005"
    "psrad\005psraw\005psrld\006psrldq\005psrlq\005psrlw\005psubb\005psubd\005"
    "psubq\006psubsb\006psubsw\007psubusb\007psubusw\005psubw\006pswapd\005p"
    "test\007ptwrite\010ptwritel\010ptwriteq\tpunpckhbw\tpunpckhdq\npunpckhq"
    "dq\tpunpckhwd\tpunpcklbw\tpunpckldq\npunpcklqdq\tpunpcklwd\004push\006p"
    "ushal\006pushaw\005pushf\006pushfd\006pushfl\006pushfq\006pushfw\005pus"
    "hl\005pushq\005pushw\004pxor\003rcl\004rclb\004rcll\004rclq\004rclw\005"
    "rcpps\005rcpss\003rcr\004rcrb\004rcrl\004rcrq\004rcrw\010rdfsbase\trdfs"
    "basel\trdfsbaseq\010rdgsbase\trdgsbasel\trdgsbaseq\005rdmsr\005rdpid\006"
    "rdpkru\005rdpmc\006rdrand\007rdrandl\007rdrandq\007rdrandw\006rdseed\007"
    "rdseedl\007rdseedq\007rdseedw\006rdsspd\006rdsspq\005rdtsc\006rdtscp\003"
    "rep\005repne\003ret\004retf\005retfq\004retl\004retq\004retw\005rex64\003"
    "rol\004rolb\004roll\004rolq\004rolw\003ror\004rorb\004rorl\004rorq\004r"
    "orw\004rorx\005rorxl\005rorxq\007roundpd\007roundps\007roundsd\007round"
    "ss\003rsm\007rsqrtps\007rsqrtss\010rstorssp\004sahf\004salc\003sar\004s"
    "arb\004sarl\004sarq\004sarw\004sarx\005sarxl\005sarxq\013saveprevssp\003"
    "sbb\004sbbb\004sbbl\004sbbq\004sbbw\004scas\005scasb\005scasd\005scasl\005"
    "scasq\005scasw\004seta\005setae\004setb\005setbe\004sete\004setg\005set"
    "ge\004setl\005setle\005setne\005setno\005setnp\005setns\004seto\004setp"
    "\004sets\010setssbsy\006sfence\004sgdt\005sgdtd\005sgdtl\005sgdtq\005sg"
    "dtw\010sha1msg1\010sha1msg2\tsha1nexte\tsha1rnds4\nsha256msg1\nsha256ms"
    "g2\013sha256rnds2\003shl\004shlb\004shld\005shldl\005shldq\005shldw\004"
    "shll\004shlq\004shlw\004shlx\005shlxl\005shlxq\003shr\004shrb\004shrd\005"
    "shrdl\005shrdq\005shrdw\004shrl\004shrq\004shrw\004shrx\005shrxl\005shr"
    "xq\006shufpd\006shufps\004sidt\005sidtd\005sidtl\005sidtq\005sidtw\006s"
    "kinit\004sldt\005sldtl\005sldtq\005sldtw\006slwpcb\004smsw\005smswl\005"
    "smswq\005smsww\006sqrtpd\006sqrtps\006sqrtsd\006sqrtss\002ss\004stac\003"
    "stc\003std\004stgi\003sti\007stmxcsr\004stos\005stosb\005stosd\005stosl"
    "\005stosq\005stosw\003str\004strl\004strq\004strw\003sub\004subb\004sub"
    "l\005subpd\005subps\004subq\005subsd\005subss\004subw\006swapgs\007sysc"
    "all\010sysenter\007sysexit\010sysexitl\010sysexitq\006sysret\007sysretl"
    "\007sysretq\006t1mskc\007t1mskcl\007t1mskcq\004test\005testb\005testl\005"
    "testq\005testw\006tpause\005tzcnt\006tzcntl\006tzcntq\006tzcntw\005tzms"
    "k\006tzmskl\006tzmskq\007ucomisd\007ucomiss\003ud2\004ud2b\010umonitor\006"
    "umwait\010unpckhpd\010unpckhps\010unpcklpd\010unpcklps\tv4fmaddps\tv4fm"
    "addss\nv4fnmaddps\nv4fnmaddss\006vaddpd\006vaddps\006vaddsd\006vaddss\t"
    "vaddsubpd\tvaddsubps\007vaesdec\013vaesdeclast\007vaesenc\013vaesenclas"
    "t\007vaesimc\020vaeskeygenassist\007valignd\007valignq\007vandnpd\007va"
    "ndnps\006vandpd\006vandps\tvblendmpd\tvblendmps\010vblendpd\010vblendps"
    "\tvblendvpd\tvblendvps\016vbroadcastf128\017vbroadcastf32x2\017vbroadca"
    "stf32x4\017vbroadcastf32x8\017vbroadcastf64x2\017vbroadcastf64x4\016vbr"
    "oadcasti128\017vbroadcasti32x2\017vbroadcasti32x4\017vbroadcasti32x8\017"
    "vbroadcasti64x2\017vbroadcasti64x4\014vbroadcastsd\014vbroadcastss\004v"
    "cmp\006vcmppd\006vcmpps\006vcmpsd\006vcmpss\007vcomisd\007vcomiss\013vc"
    "ompresspd\013vcompressps\tvcvtdq2pd\tvcvtdq2ps\tvcvtpd2dq\nvcvtpd2dqx\n"
    "vcvtpd2dqy\tvcvtpd2ps\nvcvtpd2psx\nvcvtpd2psy\tvcvtpd2qq\nvcvtpd2udq\013"
    "vcvtpd2udqx\013vcvtpd2udqy\nvcvtpd2uqq\tvcvtph2ps\tvcvtps2dq\tvcvtps2pd"
    "\tvcvtps2ph\tvcvtps2qq\nvcvtps2udq\nvcvtps2uqq\tvcvtqq2pd\tvcvtqq2ps\nv"
    "cvtqq2psx\nvcvtqq2psy\tvcvtsd2si\nvcvtsd2sil\nvcvtsd2siq\tvcvtsd2ss\nvc"
    "vtsd2usi\013vcvtsd2usil\013vcvtsd2usiq\tvcvtsi2sd\nvcvtsi2sdl\nvcvtsi2s"
    "dq\tvcvtsi2ss\nvcvtsi2ssl\nvcvtsi2ssq\tvcvtss2sd\tvcvtss2si\nvcvtss2sil"
    "\nvcvtss2siq\nvcvtss2usi\013vcvtss2usil\013vcvtss2usiq\nvcvttpd2dq\013v"
    "cvttpd2dqx\013vcvttpd2dqy\nvcvttpd2qq\013vcvttpd2udq\014vcvttpd2udqx\014"
    "vcvttpd2udqy\013vcvttpd2uqq\nvcvttps2dq\nvcvttps2qq\013vcvttps2udq\013v"
    "cvttps2uqq\nvcvttsd2si\013vcvttsd2sil\013vcvttsd2siq\013vcvttsd2usi\014"
    "vcvttsd2usil\014vcvttsd2usiq\nvcvttss2si\013vcvttss2sil\013vcvttss2siq\013"
    "vcvttss2usi\014vcvttss2usil\014vcvttss2usiq\nvcvtudq2pd\nvcvtudq2ps\nvc"
    "vtuqq2pd\nvcvtuqq2ps\013vcvtuqq2psx\013vcvtuqq2psy\nvcvtusi2sd\013vcvtu"
    "si2sdl\013vcvtusi2sdq\nvcvtusi2ss\013vcvtusi2ssl\013vcvtusi2ssq\tvdbpsa"
    "dbw\006vdivpd\006vdivps\006vdivsd\006vdivss\005vdppd\005vdpps\004verr\004"
    "verw\007vexp2pd\007vexp2ps\tvexpandpd\tvexpandps\014vextractf128\015vex"
    "tractf32x4\015vextractf32x8\015vextractf64x2\015vextractf64x4\014vextra"
    "cti128\015vextracti32x4\015vextracti32x8\015vextracti64x2\015vextracti6"
    "4x4\nvextractps\013vfixupimmpd\013vfixupimmps\013vfixupimmsd\013vfixupi"
    "mmss\013vfmadd132pd\013vfmadd132ps\013vfmadd132sd\013vfmadd132ss\013vfm"
    "add213pd\013vfmadd213ps\013vfmadd213sd\013vfmadd213ss\013vfmadd231pd\013"
    "vfmadd231ps\013vfmadd231sd\013vfmadd231ss\010vfmaddpd\010vfmaddps\010vf"
    "maddsd\010vfmaddss\016vfmaddsub132pd\016vfmaddsub132ps\016vfmaddsub213p"
    "d\016vfmaddsub213ps\016vfmaddsub231pd\016vfmaddsub231ps\013vfmaddsubpd\013"
    "vfmaddsubps\013vfmsub132pd\013vfmsub132ps\013vfmsub132sd\013vfmsub132ss"
    "\013vfmsub213pd\013vfmsub213ps\013vfmsub213sd\013vfmsub213ss\013vfmsub2"
    "31pd\013vfmsub231ps\013vfmsub231sd\013vfmsub231ss\016vfmsubadd132pd\016"
    "vfmsubadd132ps\016vfmsubadd213pd\016vfmsubadd213ps\016vfmsubadd231pd\016"
    "vfmsubadd231ps\013vfmsubaddpd\013vfmsubaddps\010vfmsubpd\010vfmsubps\010"
    "vfmsubsd\010vfmsubss\014vfnmadd132pd\014vfnmadd132ps\014vfnmadd132sd\014"
    "vfnmadd132ss\014vfnmadd213pd\014vfnmadd213ps\014vfnmadd213sd\014vfnmadd"
    "213ss\014vfnmadd231pd\014vfnmadd231ps\014vfnmadd231sd\014vfnmadd231ss\t"
    "vfnmaddpd\tvfnmaddps\tvfnmaddsd\tvfnmaddss\014vfnmsub132pd\014vfnmsub13"
    "2ps\014vfnmsub132sd\014vfnmsub132ss\014vfnmsub213pd\014vfnmsub213ps\014"
    "vfnmsub213sd\014vfnmsub213ss\014vfnmsub231pd\014vfnmsub231ps\014vfnmsub"
    "231sd\014vfnmsub231ss\tvfnmsubpd\tvfnmsubps\tvfnmsubsd\tvfnmsubss\nvfpc"
    "lasspd\013vfpclasspdq\013vfpclasspdx\013vfpclasspdy\013vfpclasspdz\nvfp"
    "classps\013vfpclasspsl\013vfpclasspsx\013vfpclasspsy\013vfpclasspsz\nvf"
    "pclasssd\nvfpclassss\007vfrczpd\007vfrczps\007vfrczsd\007vfrczss\nvgath"
    "erdpd\nvgatherdps\015vgatherpf0dpd\015vgatherpf0dps\015vgatherpf0qpd\015"
    "vgatherpf0qps\015vgatherpf1dpd\015vgatherpf1dps\015vgatherpf1qpd\015vga"
    "therpf1qps\nvgatherqpd\nvgatherqps\tvgetexppd\tvgetexpps\tvgetexpsd\tvg"
    "etexpss\nvgetmantpd\nvgetmantps\nvgetmantsd\nvgetmantss\021vgf2p8affine"
    "invqb\016vgf2p8affineqb\nvgf2p8mulb\007vhaddpd\007vhaddps\007vhsubpd\007"
    "vhsubps\013vinsertf128\014vinsertf32x4\014vinsertf32x8\014vinsertf64x2\014"
    "vinsertf64x4\013vinserti128\014vinserti32x4\014vinserti32x8\014vinserti"
    "64x2\014vinserti64x4\tvinsertps\006vlddqu\010vldmxcsr\013vmaskmovdqu\nv"
    "maskmovpd\nvmaskmovps\006vmaxpd\006vmaxps\006vmaxsd\006vmaxss\006vmcall"
    "\007vmclear\006vmfunc\006vminpd\006vminps\006vminsd\006vminss\010vmlaun"
    "ch\006vmload\007vmmcall\007vmovapd\tvmovapd.s\007vmovaps\tvmovaps.s\005"
    "vmovd\010vmovddup\007vmovdqa\tvmovdqa.s\tvmovdqa32\013vmovdqa32.s\tvmov"
    "dqa64\013vmovdqa64.s\007vmovdqu\tvmovdqu.s\tvmovdqu16\013vmovdqu16.s\tv"
    "movdqu32\013vmovdqu32.s\tvmovdqu64\013vmovdqu64.s\010vmovdqu8\nvmovdqu8"
    ".s\010vmovhlps\007vmovhpd\007vmovhps\010vmovlhps\007vmovlpd\007vmovlps\t"
    "vmovmskpd\tvmovmskps\010vmovntdq\tvmovntdqa\010vmovntpd\010vmovntps\005"
    "vmovq\007vmovq.s\006vmovsd\010vmovsd.s\tvmovshdup\tvmovsldup\006vmovss\010"
    "vmovss.s\007vmovupd\tvmovupd.s\007vmovups\tvmovups.s\010vmpsadbw\007vmp"
    "trld\007vmptrst\006vmread\007vmreadl\007vmreadq\010vmresume\005vmrun\006"
    "vmsave\006vmulpd\006vmulps\006vmulsd\006vmulss\007vmwrite\010vmwritel\010"
    "vmwriteq\006vmxoff\005vmxon\005vorpd\005vorps\tvp4dpwssd\nvp4dpwssds\006"
    "vpabsb\006vpabsd\006vpabsq\006vpabsw\tvpackssdw\tvpacksswb\tvpackusdw\t"
    "vpackuswb\006vpaddb\006vpaddd\006vpaddq\007vpaddsb\007vpaddsw\010vpaddu"
    "sb\010vpaddusw\006vpaddw\010vpalignr\005vpand\006vpandd\006vpandn\007vp"
    "andnd\007vpandnq\006vpandq\006vpavgb\006vpavgw\010vpblendd\tvpblendmb\t"
    "vpblendmd\tvpblendmq\tvpblendmw\tvpblendvb\010vpblendw\014vpbroadcastb\014"
    "vpbroadcastd\017vpbroadcastmb2q\017vpbroadcastmw2d\014vpbroadcastq\014v"
    "pbroadcastw\015vpclmulhqhqdq\015vpclmulhqlqdq\015vpclmullqhqdq\015vpclm"
    "ullqlqdq\nvpclmulqdq\006vpcmov\005vpcmp\006vpcmpb\006vpcmpd\010vpcmpeqb"
    "\010vpcmpeqd\010vpcmpeqq\010vpcmpeqw\nvpcmpestri\nvpcmpestrm\010vpcmpgt"
    "b\010vpcmpgtd\010vpcmpgtq\010vpcmpgtw\nvpcmpistri\nvpcmpistrm\006vpcmpq"
    "\007vpcmpub\007vpcmpud\007vpcmpuq\007vpcmpuw\006vpcmpw\005vpcom\006vpco"
    "mb\006vpcomd\013vpcompressb\013vpcompressd\013vpcompressq\013vpcompress"
    "w\006vpcomq\007vpcomub\007vpcomud\007vpcomuq\007vpcomuw\006vpcomw\013vp"
    "conflictd\013vpconflictq\010vpdpbusd\tvpdpbusds\010vpdpwssd\tvpdpwssds\n"
    "vperm2f128\nvperm2i128\006vpermb\006vpermd\010vpermi2b\010vpermi2d\tvpe"
    "rmi2pd\tvpermi2ps\010vpermi2q\010vpermi2w\nvpermil2pd\nvpermil2ps\tvper"
    "milpd\tvpermilps\007vpermpd\007vpermps\006vpermq\010vpermt2b\010vpermt2"
    "d\tvpermt2pd\tvpermt2ps\010vpermt2q\010vpermt2w\006vpermw\tvpexpandb\tv"
    "pexpandd\tvpexpandq\tvpexpandw\007vpextrb\007vpextrd\007vpextrq\007vpex"
    "trw\nvpgatherdd\nvpgatherdq\nvpgatherqd\nvpgatherqq\010vphaddbd\010vpha"
    "ddbq\010vphaddbw\007vphaddd\010vphadddq\010vphaddsw\tvphaddubd\tvphaddu"
    "bq\tvphaddubw\tvphaddudq\tvphadduwd\tvphadduwq\007vphaddw\010vphaddwd\010"
    "vphaddwq\013vphminposuw\010vphsubbw\007vphsubd\010vphsubdq\010vphsubsw\007"
    "vphsubw\010vphsubwd\007vpinsrb\007vpinsrd\007vpinsrq\007vpinsrw\010vplz"
    "cntd\010vplzcntq\010vpmacsdd\tvpmacsdqh\tvpmacsdql\tvpmacssdd\nvpmacssd"
    "qh\nvpmacssdql\tvpmacsswd\tvpmacssww\010vpmacswd\010vpmacsww\nvpmadcssw"
    "d\tvpmadcswd\013vpmadd52huq\013vpmadd52luq\nvpmaddubsw\010vpmaddwd\nvpm"
    "askmovd\nvpmaskmovq\007vpmaxsb\007vpmaxsd\007vpmaxsq\007vpmaxsw\007vpma"
    "xub\007vpmaxud\007vpmaxuq\007vpmaxuw\007vpminsb\007vpminsd\007vpminsq\007"
    "vpminsw\007vpminub\007vpminud\007vpminuq\007vpminuw\010vpmovb2m\010vpmo"
    "vd2m\007vpmovdb\007vpmovdw\010vpmovm2b\010vpmovm2d\010vpmovm2q\010vpmov"
    "m2w\tvpmovmskb\010vpmovq2m\007vpmovqb\007vpmovqd\007vpmovqw\010vpmovsdb"
    "\010vpmovsdw\010vpmovsqb\010vpmovsqd\010vpmovsqw\010vpmovswb\tvpmovsxbd"
    "\tvpmovsxbq\tvpmovsxbw\tvpmovsxdq\tvpmovsxwd\tvpmovsxwq\tvpmovusdb\tvpm"
    "ovusdw\tvpmovusqb\tvpmovusqd\tvpmovusqw\tvpmovuswb\010vpmovw2m\007vpmov"
    "wb\tvpmovzxbd\tvpmovzxbq\tvpmovzxbw\tvpmovzxdq\tvpmovzxwd\tvpmovzxwq\007"
    "vpmuldq\tvpmulhrsw\010vpmulhuw\007vpmulhw\007vpmulld\007vpmullq\007vpmu"
    "llw\016vpmultishiftqb\010vpmuludq\010vpopcntb\010vpopcntd\010vpopcntq\010"
    "vpopcntw\004vpor\005vpord\005vporq\006vpperm\006vprold\006vprolq\007vpr"
    "olvd\007vprolvq\006vprord\006vprorq\007vprorvd\007vprorvq\006vprotb\006"
    "vprotd\006vprotq\006vprotw\007vpsadbw\013vpscatterdd\013vpscatterdq\013"
    "vpscatterqd\013vpscatterqq\006vpshab\006vpshad\006vpshaq\006vpshaw\006v"
    "pshlb\006vpshld\007vpshldd\007vpshldq\010vpshldvd\010vpshldvq\010vpshld"
    "vw\007vpshldw\006vpshlq\006vpshlw\007vpshrdd\007vpshrdq\010vpshrdvd\010"
    "vpshrdvq\010vpshrdvw\007vpshrdw\007vpshufb\014vpshufbitqmb\007vpshufd\010"
    "vpshufhw\010vpshuflw\007vpsignb\007vpsignd\007vpsignw\006vpslld\007vpsl"
    "ldq\006vpsllq\007vpsllvd\007vpsllvq\007vpsllvw\006vpsllw\006vpsrad\006v"
    "psraq\007vpsravd\007vpsravq\007vpsravw\006vpsraw\006vpsrld\007vpsrldq\006"
    "vpsrlq\007vpsrlvd\007vpsrlvq\007vpsrlvw\006vpsrlw\006vpsubb\006vpsubd\006"
    "vpsubq\007vpsubsb\007vpsubsw\010vpsubusb\010vpsubusw\006vpsubw\nvpternl"
    "ogd\nvpternlogq\006vptest\010vptestmb\010vptestmd\010vptestmq\010vptest"
    "mw\tvptestnmb\tvptestnmd\tvptestnmq\tvptestnmw\nvpunpckhbw\nvpunpckhdq\013"
    "vpunpckhqdq\nvpunpckhwd\nvpunpcklbw\nvpunpckldq\013vpunpcklqdq\nvpunpck"
    "lwd\005vpxor\006vpxord\006vpxorq\010vrangepd\010vrangeps\010vrangesd\010"
    "vrangess\010vrcp14pd\010vrcp14ps\010vrcp14sd\010vrcp14ss\010vrcp28pd\010"
    "vrcp28ps\010vrcp28sd\010vrcp28ss\006vrcpps\006vrcpss\tvreducepd\tvreduc"
    "eps\tvreducesd\tvreducess\013vrndscalepd\013vrndscaleps\013vrndscalesd\013"
    "vrndscaless\010vroundpd\010vroundps\010vroundsd\010vroundss\nvrsqrt14pd"
    "\nvrsqrt14ps\nvrsqrt14sd\nvrsqrt14ss\nvrsqrt28pd\nvrsqrt28ps\nvrsqrt28s"
    "d\nvrsqrt28ss\010vrsqrtps\010vrsqrtss\tvscalefpd\tvscalefps\tvscalefsd\t"
    "vscalefss\013vscatterdpd\013vscatterdps\016vscatterpf0dpd\016vscatterpf"
    "0dps\016vscatterpf0qpd\016vscatterpf0qps\016vscatterpf1dpd\016vscatterp"
    "f1dps\016vscatterpf1qpd\016vscatterpf1qps\013vscatterqpd\013vscatterqps"
    "\nvshuff32x4\nvshuff64x2\nvshufi32x4\nvshufi64x2\007vshufpd\007vshufps\007"
    "vsqrtpd\007vsqrtps\007vsqrtsd\007vsqrtss\010vstmxcsr\006vsubpd\006vsubp"
    "s\006vsubsd\006vsubss\007vtestpd\007vtestps\010vucomisd\010vucomiss\tvu"
    "npckhpd\tvunpckhps\tvunpcklpd\tvunpcklps\006vxorpd\006vxorps\010vzeroal"
    "l\nvzeroupper\004wait\006wbinvd\010wbnoinvd\010wrfsbase\twrfsbasel\twrf"
    "sbaseq\010wrgsbase\twrgsbasel\twrgsbaseq\005wrmsr\006wrpkru\005wrssd\005"
    "wrssq\006wrussd\006wrussq\006xabort\010xacquire\004xadd\005xaddb\005xad"
    "dl\005xaddq\005xaddw\006xbegin\004xchg\005xchgb\005xchgl\005xchgq\005xc"
    "hgw\txcryptcbc\txcryptcfb\txcryptctr\txcryptecb\txcryptofb\004xend\006x"
    "getbv\005xlatb\003xor\004xorb\004xorl\005xorpd\005xorps\004xorq\004xorw"
    "\010xrelease\006xrstor\010xrstor64\007xrstors\txrstors64\005xsave\007xs"
    "ave64\006xsavec\010xsavec64\010xsaveopt\nxsaveopt64\006xsaves\010xsaves"
    "64\006xsetbv\005xsha1\007xsha256\006xstore\txstorerng\005xtest";

namespace {
  struct MatchEntry {
    uint16_t Mnemonic;
    uint16_t Opcode;
    uint16_t ConvertFn;
    uint8_t RequiredFeatures;
    uint8_t Classes[9];
    StringRef getMnemonic() const {
      return StringRef(MnemonicTable + Mnemonic + 1,
                       MnemonicTable[Mnemonic]);
    }
  };

  // Predicate for searching for an opcode.
  struct LessOpcode {
    bool operator()(const MatchEntry &LHS, StringRef RHS) {
      return LHS.getMnemonic() < RHS;
    }
    bool operator()(StringRef LHS, const MatchEntry &RHS) {
      return LHS < RHS.getMnemonic();
    }
    bool operator()(const MatchEntry &LHS, const MatchEntry &RHS) {
      return LHS.getMnemonic() < RHS.getMnemonic();
    }
  };
} // end anonymous namespace.

static const MatchEntry MatchTable0[] = {
  { 0 /* aaa */, X86::AAA, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 4 /* aad */, X86::AAD8i8, Convert__imm_95_10, Feature_Not64BitMode, {  }, },
  { 4 /* aad */, X86::AAD8i8, Convert__Imm1_0, Feature_Not64BitMode, { MCK_Imm }, },
  { 8 /* aam */, X86::AAM8i8, Convert__imm_95_10, Feature_Not64BitMode, {  }, },
  { 8 /* aam */, X86::AAM8i8, Convert__Imm1_0, Feature_Not64BitMode, { MCK_Imm }, },
  { 12 /* aas */, X86::AAS, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 20 /* adcb */, X86::ADC8rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 20 /* adcb */, X86::ADC8mr, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 20 /* adcb */, X86::ADC8i8, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 20 /* adcb */, X86::ADC8ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 20 /* adcb */, X86::ADC8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 20 /* adcb */, X86::ADC8rm, Convert__Reg1_1__Tie0_2_2__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 25 /* adcl */, X86::ADC32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 25 /* adcl */, X86::ADC32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 25 /* adcl */, X86::ADC32ri8, Convert__regEAX__Tie0_1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_EAX }, },
  { 25 /* adcl */, X86::ADC32ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 25 /* adcl */, X86::ADC32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 25 /* adcl */, X86::ADC32i32, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 25 /* adcl */, X86::ADC32ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 25 /* adcl */, X86::ADC32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 25 /* adcl */, X86::ADC32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 30 /* adcq */, X86::ADC64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 30 /* adcq */, X86::ADC64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 30 /* adcq */, X86::ADC64ri8, Convert__regRAX__Tie0_1_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_RAX }, },
  { 30 /* adcq */, X86::ADC64ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 30 /* adcq */, X86::ADC64mi8, Convert__Mem645_1__ImmSExti64i81_0, Feature_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 30 /* adcq */, X86::ADC64i32, Convert__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 30 /* adcq */, X86::ADC64ri32, Convert__Reg1_1__Tie0_2_2__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 30 /* adcq */, X86::ADC64mi32, Convert__Mem645_1__ImmSExti64i321_0, Feature_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 30 /* adcq */, X86::ADC64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 35 /* adcw */, X86::ADC16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 35 /* adcw */, X86::ADC16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 35 /* adcw */, X86::ADC16ri8, Convert__regAX__Tie0_1_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_AX }, },
  { 35 /* adcw */, X86::ADC16ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 35 /* adcw */, X86::ADC16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 35 /* adcw */, X86::ADC16i16, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 35 /* adcw */, X86::ADC16ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 35 /* adcw */, X86::ADC16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 35 /* adcw */, X86::ADC16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 45 /* adcxl */, X86::ADCX32rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 45 /* adcxl */, X86::ADCX32rm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 51 /* adcxq */, X86::ADCX64rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 51 /* adcxq */, X86::ADCX64rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 61 /* addb */, X86::ADD8rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 61 /* addb */, X86::ADD8mr, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 61 /* addb */, X86::ADD8i8, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 61 /* addb */, X86::ADD8ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 61 /* addb */, X86::ADD8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 61 /* addb */, X86::ADD8rm, Convert__Reg1_1__Tie0_2_2__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 66 /* addl */, X86::ADD32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 66 /* addl */, X86::ADD32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 66 /* addl */, X86::ADD32ri8, Convert__regEAX__Tie0_1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_EAX }, },
  { 66 /* addl */, X86::ADD32ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 66 /* addl */, X86::ADD32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 66 /* addl */, X86::ADD32i32, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 66 /* addl */, X86::ADD32ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 66 /* addl */, X86::ADD32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 66 /* addl */, X86::ADD32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 71 /* addpd */, X86::ADDPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 71 /* addpd */, X86::ADDPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 77 /* addps */, X86::ADDPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 77 /* addps */, X86::ADDPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 83 /* addq */, X86::ADD64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 83 /* addq */, X86::ADD64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 83 /* addq */, X86::ADD64ri8, Convert__regRAX__Tie0_1_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_RAX }, },
  { 83 /* addq */, X86::ADD64ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 83 /* addq */, X86::ADD64mi8, Convert__Mem645_1__ImmSExti64i81_0, Feature_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 83 /* addq */, X86::ADD64i32, Convert__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 83 /* addq */, X86::ADD64ri32, Convert__Reg1_1__Tie0_2_2__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 83 /* addq */, X86::ADD64mi32, Convert__Mem645_1__ImmSExti64i321_0, Feature_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 83 /* addq */, X86::ADD64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 88 /* addsd */, X86::ADDSDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 88 /* addsd */, X86::ADDSDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 94 /* addss */, X86::ADDSSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 94 /* addss */, X86::ADDSSrm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 100 /* addsubpd */, X86::ADDSUBPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 100 /* addsubpd */, X86::ADDSUBPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 109 /* addsubps */, X86::ADDSUBPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 109 /* addsubps */, X86::ADDSUBPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 118 /* addw */, X86::ADD16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 118 /* addw */, X86::ADD16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 118 /* addw */, X86::ADD16ri8, Convert__regAX__Tie0_1_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_AX }, },
  { 118 /* addw */, X86::ADD16ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 118 /* addw */, X86::ADD16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 118 /* addw */, X86::ADD16i16, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 118 /* addw */, X86::ADD16ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 118 /* addw */, X86::ADD16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 118 /* addw */, X86::ADD16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 128 /* adoxl */, X86::ADOX32rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 128 /* adoxl */, X86::ADOX32rm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 134 /* adoxq */, X86::ADOX64rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 134 /* adoxq */, X86::ADOX64rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 140 /* aesdec */, X86::AESDECrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 140 /* aesdec */, X86::AESDECrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 147 /* aesdeclast */, X86::AESDECLASTrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 147 /* aesdeclast */, X86::AESDECLASTrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 158 /* aesenc */, X86::AESENCrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 158 /* aesenc */, X86::AESENCrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 165 /* aesenclast */, X86::AESENCLASTrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 165 /* aesenclast */, X86::AESENCLASTrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 176 /* aesimc */, X86::AESIMCrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 176 /* aesimc */, X86::AESIMCrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 183 /* aeskeygenassist */, X86::AESKEYGENASSIST128rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 183 /* aeskeygenassist */, X86::AESKEYGENASSIST128rm, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 203 /* andb */, X86::AND8rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 203 /* andb */, X86::AND8mr, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 203 /* andb */, X86::AND8i8, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 203 /* andb */, X86::AND8ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 203 /* andb */, X86::AND8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 203 /* andb */, X86::AND8rm, Convert__Reg1_1__Tie0_2_2__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 208 /* andl */, X86::AND32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 208 /* andl */, X86::AND32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 208 /* andl */, X86::AND32ri8, Convert__regEAX__Tie0_1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_EAX }, },
  { 208 /* andl */, X86::AND32ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 208 /* andl */, X86::AND32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 208 /* andl */, X86::AND32i32, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 208 /* andl */, X86::AND32ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 208 /* andl */, X86::AND32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 208 /* andl */, X86::AND32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 218 /* andnl */, X86::ANDN32rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 218 /* andnl */, X86::ANDN32rm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 224 /* andnpd */, X86::ANDNPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 224 /* andnpd */, X86::ANDNPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 231 /* andnps */, X86::ANDNPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 231 /* andnps */, X86::ANDNPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 238 /* andnq */, X86::ANDN64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 238 /* andnq */, X86::ANDN64rm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 244 /* andpd */, X86::ANDPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 244 /* andpd */, X86::ANDPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 250 /* andps */, X86::ANDPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 250 /* andps */, X86::ANDPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 256 /* andq */, X86::AND64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 256 /* andq */, X86::AND64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 256 /* andq */, X86::AND64ri8, Convert__regRAX__Tie0_1_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_RAX }, },
  { 256 /* andq */, X86::AND64ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 256 /* andq */, X86::AND64mi8, Convert__Mem645_1__ImmSExti64i81_0, Feature_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 256 /* andq */, X86::AND64i32, Convert__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 256 /* andq */, X86::AND64ri32, Convert__Reg1_1__Tie0_2_2__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 256 /* andq */, X86::AND64mi32, Convert__Mem645_1__ImmSExti64i321_0, Feature_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 256 /* andq */, X86::AND64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 261 /* andw */, X86::AND16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 261 /* andw */, X86::AND16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 261 /* andw */, X86::AND16ri8, Convert__regAX__Tie0_1_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_AX }, },
  { 261 /* andw */, X86::AND16ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 261 /* andw */, X86::AND16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 261 /* andw */, X86::AND16i16, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 261 /* andw */, X86::AND16ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 261 /* andw */, X86::AND16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 261 /* andw */, X86::AND16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 266 /* arpl */, X86::ARPL16rr, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 266 /* arpl */, X86::ARPL16mr, Convert__Mem165_1__Reg1_0, Feature_Not64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 277 /* bextrl */, X86::BEXTR32rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 277 /* bextrl */, X86::BEXTR32rm, Convert__Reg1_2__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 277 /* bextrl */, X86::BEXTRI32ri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32, MCK_GR32 }, },
  { 277 /* bextrl */, X86::BEXTRI32mi, Convert__Reg1_2__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32, MCK_GR32 }, },
  { 284 /* bextrq */, X86::BEXTR64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 284 /* bextrq */, X86::BEXTR64rm, Convert__Reg1_2__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 284 /* bextrq */, X86::BEXTRI64ri, Convert__Reg1_2__Reg1_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64, MCK_GR64 }, },
  { 284 /* bextrq */, X86::BEXTRI64mi, Convert__Reg1_2__Mem645_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_Mem64, MCK_GR64 }, },
  { 299 /* blcfilll */, X86::BLCFILL32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 299 /* blcfilll */, X86::BLCFILL32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 308 /* blcfillq */, X86::BLCFILL64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 308 /* blcfillq */, X86::BLCFILL64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 328 /* blcicl */, X86::BLCIC32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 328 /* blcicl */, X86::BLCIC32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 335 /* blcicq */, X86::BLCIC64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 335 /* blcicq */, X86::BLCIC64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 342 /* blcil */, X86::BLCI32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 342 /* blcil */, X86::BLCI32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 348 /* blciq */, X86::BLCI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 348 /* blciq */, X86::BLCI64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 361 /* blcmskl */, X86::BLCMSK32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 361 /* blcmskl */, X86::BLCMSK32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 369 /* blcmskq */, X86::BLCMSK64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 369 /* blcmskq */, X86::BLCMSK64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 382 /* blcsl */, X86::BLCS32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 382 /* blcsl */, X86::BLCS32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 388 /* blcsq */, X86::BLCS64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 388 /* blcsq */, X86::BLCS64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 394 /* blendpd */, X86::BLENDPDrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 394 /* blendpd */, X86::BLENDPDrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 402 /* blendps */, X86::BLENDPSrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 402 /* blendps */, X86::BLENDPSrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 410 /* blendvpd */, X86::BLENDVPDrr0, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 410 /* blendvpd */, X86::BLENDVPDrm0, Convert__Reg1_1__Tie0_2_2__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 410 /* blendvpd */, X86::BLENDVPDrr0, Convert__Reg1_2__Tie0_1_1__Reg1_1, 0, { MCK_XMM0, MCK_FR32, MCK_FR32 }, },
  { 410 /* blendvpd */, X86::BLENDVPDrm0, Convert__Reg1_2__Tie0_1_1__Mem1285_1, 0, { MCK_XMM0, MCK_Mem128, MCK_FR32 }, },
  { 419 /* blendvps */, X86::BLENDVPSrr0, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 419 /* blendvps */, X86::BLENDVPSrm0, Convert__Reg1_1__Tie0_2_2__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 419 /* blendvps */, X86::BLENDVPSrr0, Convert__Reg1_2__Tie0_1_1__Reg1_1, 0, { MCK_XMM0, MCK_FR32, MCK_FR32 }, },
  { 419 /* blendvps */, X86::BLENDVPSrm0, Convert__Reg1_2__Tie0_1_1__Mem1285_1, 0, { MCK_XMM0, MCK_Mem128, MCK_FR32 }, },
  { 436 /* blsfilll */, X86::BLSFILL32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 436 /* blsfilll */, X86::BLSFILL32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 445 /* blsfillq */, X86::BLSFILL64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 445 /* blsfillq */, X86::BLSFILL64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 465 /* blsicl */, X86::BLSIC32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 465 /* blsicl */, X86::BLSIC32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 472 /* blsicq */, X86::BLSIC64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 472 /* blsicq */, X86::BLSIC64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 479 /* blsil */, X86::BLSI32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 479 /* blsil */, X86::BLSI32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 485 /* blsiq */, X86::BLSI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 485 /* blsiq */, X86::BLSI64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 498 /* blsmskl */, X86::BLSMSK32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 498 /* blsmskl */, X86::BLSMSK32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 506 /* blsmskq */, X86::BLSMSK64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 506 /* blsmskq */, X86::BLSMSK64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 519 /* blsrl */, X86::BLSR32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 519 /* blsrl */, X86::BLSR32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 525 /* blsrq */, X86::BLSR64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 525 /* blsrq */, X86::BLSR64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 531 /* bndcl */, X86::BNDCL32rr, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_GR32, MCK_BNDR }, },
  { 531 /* bndcl */, X86::BNDCL64rr, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_GR64, MCK_BNDR }, },
  { 531 /* bndcl */, X86::BNDCL32rm, Convert__Reg1_1__Mem5_0, Feature_Not64BitMode, { MCK_Mem, MCK_BNDR }, },
  { 531 /* bndcl */, X86::BNDCL64rm, Convert__Reg1_1__Mem5_0, Feature_In64BitMode, { MCK_Mem, MCK_BNDR }, },
  { 537 /* bndcn */, X86::BNDCN32rr, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_GR32, MCK_BNDR }, },
  { 537 /* bndcn */, X86::BNDCN64rr, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_GR64, MCK_BNDR }, },
  { 537 /* bndcn */, X86::BNDCN32rm, Convert__Reg1_1__Mem5_0, Feature_Not64BitMode, { MCK_Mem, MCK_BNDR }, },
  { 537 /* bndcn */, X86::BNDCN64rm, Convert__Reg1_1__Mem5_0, Feature_In64BitMode, { MCK_Mem, MCK_BNDR }, },
  { 543 /* bndcu */, X86::BNDCU32rr, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_GR32, MCK_BNDR }, },
  { 543 /* bndcu */, X86::BNDCU64rr, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_GR64, MCK_BNDR }, },
  { 543 /* bndcu */, X86::BNDCU32rm, Convert__Reg1_1__Mem5_0, Feature_Not64BitMode, { MCK_Mem, MCK_BNDR }, },
  { 543 /* bndcu */, X86::BNDCU64rm, Convert__Reg1_1__Mem5_0, Feature_In64BitMode, { MCK_Mem, MCK_BNDR }, },
  { 549 /* bndldx */, X86::BNDLDXrm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_BNDR }, },
  { 556 /* bndmk */, X86::BNDMK32rm, Convert__Reg1_1__Mem5_0, Feature_Not64BitMode, { MCK_Mem, MCK_BNDR }, },
  { 556 /* bndmk */, X86::BNDMK64rm, Convert__Reg1_1__Mem5_0, Feature_In64BitMode, { MCK_Mem, MCK_BNDR }, },
  { 562 /* bndmov */, X86::BNDMOVrr, Convert__Reg1_1__Reg1_0, 0, { MCK_BNDR, MCK_BNDR }, },
  { 562 /* bndmov */, X86::BNDMOV64mr, Convert__Mem1285_1__Reg1_0, Feature_In64BitMode, { MCK_BNDR, MCK_Mem128 }, },
  { 562 /* bndmov */, X86::BNDMOV32mr, Convert__Mem645_1__Reg1_0, Feature_Not64BitMode, { MCK_BNDR, MCK_Mem64 }, },
  { 562 /* bndmov */, X86::BNDMOV64rm, Convert__Reg1_1__Mem1285_0, Feature_In64BitMode, { MCK_Mem128, MCK_BNDR }, },
  { 562 /* bndmov */, X86::BNDMOV32rm, Convert__Reg1_1__Mem645_0, Feature_Not64BitMode, { MCK_Mem64, MCK_BNDR }, },
  { 569 /* bndstx */, X86::BNDSTXmr, Convert__Mem5_1__Reg1_0, 0, { MCK_BNDR, MCK_Mem }, },
  { 576 /* bound */, X86::BOUNDS16rm, Convert__Reg1_0__Mem165_1, Feature_Not64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 576 /* bound */, X86::BOUNDS32rm, Convert__Reg1_0__Mem325_1, Feature_Not64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 586 /* bsfl */, X86::BSF32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 586 /* bsfl */, X86::BSF32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 591 /* bsfq */, X86::BSF64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 591 /* bsfq */, X86::BSF64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 596 /* bsfw */, X86::BSF16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 596 /* bsfw */, X86::BSF16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 605 /* bsrl */, X86::BSR32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 605 /* bsrl */, X86::BSR32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 610 /* bsrq */, X86::BSR64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 610 /* bsrq */, X86::BSR64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 615 /* bsrw */, X86::BSR16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 615 /* bsrw */, X86::BSR16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 626 /* bswapl */, X86::BSWAP32r, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR32 }, },
  { 633 /* bswapq */, X86::BSWAP64r, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR64 }, },
  { 640 /* bt */, X86::BT32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 643 /* btc */, X86::BTC32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 647 /* btcl */, X86::BTC32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 647 /* btcl */, X86::BTC32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 647 /* btcl */, X86::BTC32ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 647 /* btcl */, X86::BTC32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 652 /* btcq */, X86::BTC64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 652 /* btcq */, X86::BTC64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 652 /* btcq */, X86::BTC64ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 652 /* btcq */, X86::BTC64mi8, Convert__Mem645_1__ImmSExti64i81_0, Feature_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 657 /* btcw */, X86::BTC16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 657 /* btcw */, X86::BTC16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 657 /* btcw */, X86::BTC16ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 657 /* btcw */, X86::BTC16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 662 /* btl */, X86::BT32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 662 /* btl */, X86::BT32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 662 /* btl */, X86::BT32ri8, Convert__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 662 /* btl */, X86::BT32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 666 /* btq */, X86::BT64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 666 /* btq */, X86::BT64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 666 /* btq */, X86::BT64ri8, Convert__Reg1_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 666 /* btq */, X86::BT64mi8, Convert__Mem645_1__ImmSExti64i81_0, Feature_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 670 /* btr */, X86::BTR32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 674 /* btrl */, X86::BTR32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 674 /* btrl */, X86::BTR32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 674 /* btrl */, X86::BTR32ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 674 /* btrl */, X86::BTR32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 679 /* btrq */, X86::BTR64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 679 /* btrq */, X86::BTR64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 679 /* btrq */, X86::BTR64ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 679 /* btrq */, X86::BTR64mi8, Convert__Mem645_1__ImmSExti64i81_0, Feature_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 684 /* btrw */, X86::BTR16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 684 /* btrw */, X86::BTR16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 684 /* btrw */, X86::BTR16ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 684 /* btrw */, X86::BTR16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 689 /* bts */, X86::BTS32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 693 /* btsl */, X86::BTS32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 693 /* btsl */, X86::BTS32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 693 /* btsl */, X86::BTS32ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 693 /* btsl */, X86::BTS32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 698 /* btsq */, X86::BTS64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 698 /* btsq */, X86::BTS64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 698 /* btsq */, X86::BTS64ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 698 /* btsq */, X86::BTS64mi8, Convert__Mem645_1__ImmSExti64i81_0, Feature_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 703 /* btsw */, X86::BTS16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 703 /* btsw */, X86::BTS16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 703 /* btsw */, X86::BTS16ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 703 /* btsw */, X86::BTS16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 708 /* btw */, X86::BT16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 708 /* btw */, X86::BT16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 708 /* btw */, X86::BT16ri8, Convert__Reg1_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 708 /* btw */, X86::BT16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 717 /* bzhil */, X86::BZHI32rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 717 /* bzhil */, X86::BZHI32rm, Convert__Reg1_2__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 723 /* bzhiq */, X86::BZHI64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 723 /* bzhiq */, X86::BZHI64rm, Convert__Reg1_2__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 729 /* call */, X86::FARCALL16i, Convert__Imm1_1__Imm1_0, Feature_In16BitMode, { MCK_Imm, MCK_Imm }, },
  { 729 /* call */, X86::FARCALL32i, Convert__Imm1_1__Imm1_0, Feature_In32BitMode, { MCK_Imm, MCK_Imm }, },
  { 734 /* calll */, X86::CALLpcrel32, Convert__AbsMem1_0, Feature_Not64BitMode, { MCK_AbsMem }, },
  { 734 /* calll */, X86::CALL32r, Convert__Reg1_1, Feature_Not64BitMode, { MCK__STAR_, MCK_GR32 }, },
  { 734 /* calll */, X86::CALL32m, Convert__Mem325_1, Feature_Not64BitMode, { MCK__STAR_, MCK_Mem32 }, },
  { 734 /* calll */, X86::FARCALL32i, Convert__Imm1_1__Imm1_0, Feature_Not64BitMode, { MCK_Imm, MCK_Imm }, },
  { 740 /* callq */, X86::CALL64pcrel32, Convert__AbsMem1_0, Feature_In64BitMode, { MCK_AbsMem }, },
  { 740 /* callq */, X86::CALL64r, Convert__Reg1_1, Feature_In64BitMode, { MCK__STAR_, MCK_GR64 }, },
  { 740 /* callq */, X86::CALL64m, Convert__Mem645_1, Feature_In64BitMode, { MCK__STAR_, MCK_Mem64 }, },
  { 746 /* callw */, X86::CALLpcrel16, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 746 /* callw */, X86::CALL16r, Convert__Reg1_1, Feature_Not64BitMode, { MCK__STAR_, MCK_GR16 }, },
  { 746 /* callw */, X86::CALL16m, Convert__Mem165_1, Feature_Not64BitMode, { MCK__STAR_, MCK_Mem16 }, },
  { 746 /* callw */, X86::FARCALL16i, Convert__Imm1_1__Imm1_0, Feature_Not64BitMode, { MCK_Imm, MCK_Imm }, },
  { 752 /* cbtw */, X86::CBW, Convert_NoOperands, 0, {  }, },
  { 770 /* clac */, X86::CLAC, Convert_NoOperands, 0, {  }, },
  { 775 /* clc */, X86::CLC, Convert_NoOperands, 0, {  }, },
  { 779 /* cld */, X86::CLD, Convert_NoOperands, 0, {  }, },
  { 783 /* cldemote */, X86::CLDEMOTE, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 792 /* clflush */, X86::CLFLUSH, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 800 /* clflushopt */, X86::CLFLUSHOPT, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 811 /* clgi */, X86::CLGI, Convert_NoOperands, 0, {  }, },
  { 816 /* cli */, X86::CLI, Convert_NoOperands, 0, {  }, },
  { 824 /* clrb */, X86::XOR8rr, Convert__Reg1_0__Tie0_1_1__Reg1_0, 0, { MCK_GR8 }, },
  { 829 /* clrl */, X86::XOR32rr, Convert__Reg1_0__Tie0_1_1__Reg1_0, 0, { MCK_GR32 }, },
  { 834 /* clrq */, X86::XOR64rr, Convert__Reg1_0__Tie0_1_1__Reg1_0, 0, { MCK_GR64 }, },
  { 839 /* clrssbsy */, X86::CLRSSBSY, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 848 /* clrw */, X86::XOR16rr, Convert__Reg1_0__Tie0_1_1__Reg1_0, 0, { MCK_GR16 }, },
  { 853 /* cltd */, X86::CDQ, Convert_NoOperands, 0, {  }, },
  { 858 /* cltq */, X86::CDQE, Convert_NoOperands, 0, {  }, },
  { 863 /* clts */, X86::CLTS, Convert_NoOperands, 0, {  }, },
  { 868 /* clwb */, X86::CLWB, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 873 /* clzero */, X86::CLZEROr, Convert_NoOperands, 0, {  }, },
  { 873 /* clzero */, X86::CLZEROr, Convert_NoOperands, Feature_Not64BitMode, { MCK_EAX }, },
  { 873 /* clzero */, X86::CLZEROr, Convert_NoOperands, Feature_In64BitMode, { MCK_RAX }, },
  { 880 /* cmc */, X86::CMC, Convert_NoOperands, 0, {  }, },
  { 897 /* cmovael */, X86::CMOVAE32rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 897 /* cmovael */, X86::CMOVAE32rm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 905 /* cmovaeq */, X86::CMOVAE64rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 905 /* cmovaeq */, X86::CMOVAE64rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 913 /* cmovaew */, X86::CMOVAE16rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 913 /* cmovaew */, X86::CMOVAE16rm, Convert__Reg1_1__Tie0_1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 921 /* cmoval */, X86::CMOVA32rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 921 /* cmoval */, X86::CMOVA32rm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 928 /* cmovaq */, X86::CMOVA64rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 928 /* cmovaq */, X86::CMOVA64rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 935 /* cmovaw */, X86::CMOVA16rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 935 /* cmovaw */, X86::CMOVA16rm, Convert__Reg1_1__Tie0_1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 955 /* cmovbel */, X86::CMOVBE32rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 955 /* cmovbel */, X86::CMOVBE32rm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 963 /* cmovbeq */, X86::CMOVBE64rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 963 /* cmovbeq */, X86::CMOVBE64rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 971 /* cmovbew */, X86::CMOVBE16rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 971 /* cmovbew */, X86::CMOVBE16rm, Convert__Reg1_1__Tie0_1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 979 /* cmovbl */, X86::CMOVB32rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 979 /* cmovbl */, X86::CMOVB32rm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 986 /* cmovbq */, X86::CMOVB64rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 986 /* cmovbq */, X86::CMOVB64rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 993 /* cmovbw */, X86::CMOVB16rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 993 /* cmovbw */, X86::CMOVB16rm, Convert__Reg1_1__Tie0_1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1006 /* cmovel */, X86::CMOVE32rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1006 /* cmovel */, X86::CMOVE32rm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1013 /* cmoveq */, X86::CMOVE64rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1013 /* cmoveq */, X86::CMOVE64rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1020 /* cmovew */, X86::CMOVE16rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1020 /* cmovew */, X86::CMOVE16rm, Convert__Reg1_1__Tie0_1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1040 /* cmovgel */, X86::CMOVGE32rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1040 /* cmovgel */, X86::CMOVGE32rm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1048 /* cmovgeq */, X86::CMOVGE64rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1048 /* cmovgeq */, X86::CMOVGE64rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1056 /* cmovgew */, X86::CMOVGE16rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1056 /* cmovgew */, X86::CMOVGE16rm, Convert__Reg1_1__Tie0_1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1064 /* cmovgl */, X86::CMOVG32rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1064 /* cmovgl */, X86::CMOVG32rm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1071 /* cmovgq */, X86::CMOVG64rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1071 /* cmovgq */, X86::CMOVG64rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1078 /* cmovgw */, X86::CMOVG16rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1078 /* cmovgw */, X86::CMOVG16rm, Convert__Reg1_1__Tie0_1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1098 /* cmovlel */, X86::CMOVLE32rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1098 /* cmovlel */, X86::CMOVLE32rm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1106 /* cmovleq */, X86::CMOVLE64rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1106 /* cmovleq */, X86::CMOVLE64rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1114 /* cmovlew */, X86::CMOVLE16rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1114 /* cmovlew */, X86::CMOVLE16rm, Convert__Reg1_1__Tie0_1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1122 /* cmovll */, X86::CMOVL32rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1122 /* cmovll */, X86::CMOVL32rm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1129 /* cmovlq */, X86::CMOVL64rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1129 /* cmovlq */, X86::CMOVL64rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1136 /* cmovlw */, X86::CMOVL16rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1136 /* cmovlw */, X86::CMOVL16rm, Convert__Reg1_1__Tie0_1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1150 /* cmovnel */, X86::CMOVNE32rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1150 /* cmovnel */, X86::CMOVNE32rm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1158 /* cmovneq */, X86::CMOVNE64rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1158 /* cmovneq */, X86::CMOVNE64rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1166 /* cmovnew */, X86::CMOVNE16rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1166 /* cmovnew */, X86::CMOVNE16rm, Convert__Reg1_1__Tie0_1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1181 /* cmovnol */, X86::CMOVNO32rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1181 /* cmovnol */, X86::CMOVNO32rm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1189 /* cmovnoq */, X86::CMOVNO64rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1189 /* cmovnoq */, X86::CMOVNO64rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1197 /* cmovnow */, X86::CMOVNO16rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1197 /* cmovnow */, X86::CMOVNO16rm, Convert__Reg1_1__Tie0_1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1212 /* cmovnpl */, X86::CMOVNP32rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1212 /* cmovnpl */, X86::CMOVNP32rm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1220 /* cmovnpq */, X86::CMOVNP64rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1220 /* cmovnpq */, X86::CMOVNP64rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1228 /* cmovnpw */, X86::CMOVNP16rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1228 /* cmovnpw */, X86::CMOVNP16rm, Convert__Reg1_1__Tie0_1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1243 /* cmovnsl */, X86::CMOVNS32rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1243 /* cmovnsl */, X86::CMOVNS32rm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1251 /* cmovnsq */, X86::CMOVNS64rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1251 /* cmovnsq */, X86::CMOVNS64rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1259 /* cmovnsw */, X86::CMOVNS16rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1259 /* cmovnsw */, X86::CMOVNS16rm, Convert__Reg1_1__Tie0_1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1273 /* cmovol */, X86::CMOVO32rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1273 /* cmovol */, X86::CMOVO32rm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1280 /* cmovoq */, X86::CMOVO64rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1280 /* cmovoq */, X86::CMOVO64rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1287 /* cmovow */, X86::CMOVO16rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1287 /* cmovow */, X86::CMOVO16rm, Convert__Reg1_1__Tie0_1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1300 /* cmovpl */, X86::CMOVP32rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1300 /* cmovpl */, X86::CMOVP32rm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1307 /* cmovpq */, X86::CMOVP64rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1307 /* cmovpq */, X86::CMOVP64rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1314 /* cmovpw */, X86::CMOVP16rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1314 /* cmovpw */, X86::CMOVP16rm, Convert__Reg1_1__Tie0_1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1327 /* cmovsl */, X86::CMOVS32rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1327 /* cmovsl */, X86::CMOVS32rm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1334 /* cmovsq */, X86::CMOVS64rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1334 /* cmovsq */, X86::CMOVS64rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1341 /* cmovsw */, X86::CMOVS16rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1341 /* cmovsw */, X86::CMOVS16rm, Convert__Reg1_1__Tie0_1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1348 /* cmp */, X86::CMPPDrri, Convert__Reg1_3__Tie0_1_1__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_FR32, MCK_FR32 }, },
  { 1348 /* cmp */, X86::CMPPDrmi, Convert__Reg1_3__Tie0_1_1__Mem1285_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_Mem128, MCK_FR32 }, },
  { 1348 /* cmp */, X86::CMPPSrri, Convert__Reg1_3__Tie0_1_1__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_FR32, MCK_FR32 }, },
  { 1348 /* cmp */, X86::CMPPSrmi, Convert__Reg1_3__Tie0_1_1__Mem1285_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_Mem128, MCK_FR32 }, },
  { 1348 /* cmp */, X86::CMPSDrr, Convert__Reg1_3__Tie0_1_1__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_sd, MCK_FR32, MCK_FR32 }, },
  { 1348 /* cmp */, X86::CMPSDrm, Convert__Reg1_3__Tie0_1_1__Mem645_2__Imm1_0, 0, { MCK_Imm, MCK_sd, MCK_Mem64, MCK_FR32 }, },
  { 1348 /* cmp */, X86::CMPSSrr, Convert__Reg1_3__Tie0_1_1__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_ss, MCK_FR32, MCK_FR32 }, },
  { 1348 /* cmp */, X86::CMPSSrm, Convert__Reg1_3__Tie0_1_1__Mem325_2__Imm1_0, 0, { MCK_Imm, MCK_ss, MCK_Mem32, MCK_FR32 }, },
  { 1352 /* cmpb */, X86::CMP8rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 1352 /* cmpb */, X86::CMP8mr, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 1352 /* cmpb */, X86::CMP8i8, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 1352 /* cmpb */, X86::CMP8ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 1352 /* cmpb */, X86::CMP8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 1352 /* cmpb */, X86::CMP8rm, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 1357 /* cmpl */, X86::CMP32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1357 /* cmpl */, X86::CMP32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 1357 /* cmpl */, X86::CMP32ri8, Convert__regEAX__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_EAX }, },
  { 1357 /* cmpl */, X86::CMP32ri8, Convert__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1357 /* cmpl */, X86::CMP32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1357 /* cmpl */, X86::CMP32i32, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 1357 /* cmpl */, X86::CMP32ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 1357 /* cmpl */, X86::CMP32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 1357 /* cmpl */, X86::CMP32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1362 /* cmppd */, X86::CMPPDrri_alt, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 1362 /* cmppd */, X86::CMPPDrmi_alt, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 1368 /* cmpps */, X86::CMPPSrri_alt, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 1368 /* cmpps */, X86::CMPPSrmi_alt, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 1374 /* cmpq */, X86::CMP64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1374 /* cmpq */, X86::CMP64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 1374 /* cmpq */, X86::CMP64ri8, Convert__regRAX__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_RAX }, },
  { 1374 /* cmpq */, X86::CMP64ri8, Convert__Reg1_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1374 /* cmpq */, X86::CMP64mi8, Convert__Mem645_1__ImmSExti64i81_0, Feature_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1374 /* cmpq */, X86::CMP64i32, Convert__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 1374 /* cmpq */, X86::CMP64ri32, Convert__Reg1_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1374 /* cmpq */, X86::CMP64mi32, Convert__Mem645_1__ImmSExti64i321_0, Feature_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1374 /* cmpq */, X86::CMP64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1384 /* cmpsb */, X86::CMPSB, Convert__DstIdx81_0__SrcIdx82_1, 0, { MCK_DstIdx8, MCK_SrcIdx8 }, },
  { 1390 /* cmpsd */, X86::CMPSDrr_alt, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 1390 /* cmpsd */, X86::CMPSDrm_alt, Convert__Reg1_2__Tie0_1_1__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_FR32 }, },
  { 1396 /* cmpsl */, X86::CMPSL, Convert__DstIdx321_0__SrcIdx322_1, 0, { MCK_DstIdx32, MCK_SrcIdx32 }, },
  { 1402 /* cmpsq */, X86::CMPSQ, Convert__DstIdx641_0__SrcIdx642_1, Feature_In64BitMode, { MCK_DstIdx64, MCK_SrcIdx64 }, },
  { 1408 /* cmpss */, X86::CMPSSrr_alt, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 1408 /* cmpss */, X86::CMPSSrm_alt, Convert__Reg1_2__Tie0_1_1__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_FR32 }, },
  { 1414 /* cmpsw */, X86::CMPSW, Convert__DstIdx161_0__SrcIdx162_1, 0, { MCK_DstIdx16, MCK_SrcIdx16 }, },
  { 1420 /* cmpw */, X86::CMP16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1420 /* cmpw */, X86::CMP16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 1420 /* cmpw */, X86::CMP16ri8, Convert__regAX__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_AX }, },
  { 1420 /* cmpw */, X86::CMP16ri8, Convert__Reg1_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1420 /* cmpw */, X86::CMP16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1420 /* cmpw */, X86::CMP16i16, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 1420 /* cmpw */, X86::CMP16ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 1420 /* cmpw */, X86::CMP16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 1420 /* cmpw */, X86::CMP16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1433 /* cmpxchg16b */, X86::CMPXCHG16B, Convert__Mem1285_0, Feature_In64BitMode, { MCK_Mem128 }, },
  { 1444 /* cmpxchg8b */, X86::CMPXCHG8B, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 1454 /* cmpxchgb */, X86::CMPXCHG8rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 1454 /* cmpxchgb */, X86::CMPXCHG8rm, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 1463 /* cmpxchgl */, X86::CMPXCHG32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1463 /* cmpxchgl */, X86::CMPXCHG32rm, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 1472 /* cmpxchgq */, X86::CMPXCHG64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1472 /* cmpxchgq */, X86::CMPXCHG64rm, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 1481 /* cmpxchgw */, X86::CMPXCHG16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1481 /* cmpxchgw */, X86::CMPXCHG16rm, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 1490 /* comisd */, X86::COMISDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1490 /* comisd */, X86::COMISDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 1497 /* comiss */, X86::COMISSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1497 /* comiss */, X86::COMISSrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 1504 /* cpuid */, X86::CPUID, Convert_NoOperands, 0, {  }, },
  { 1514 /* cqto */, X86::CQO, Convert_NoOperands, 0, {  }, },
  { 1525 /* crc32b */, X86::CRC32r32r8, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR8, MCK_GR32 }, },
  { 1525 /* crc32b */, X86::CRC32r64r8, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR8, MCK_GR64 }, },
  { 1525 /* crc32b */, X86::CRC32r32m8, Convert__Reg1_1__Tie0_2_2__Mem85_0, 0, { MCK_Mem8, MCK_GR32 }, },
  { 1525 /* crc32b */, X86::CRC32r64m8, Convert__Reg1_1__Tie0_2_2__Mem85_0, 0, { MCK_Mem8, MCK_GR64 }, },
  { 1532 /* crc32l */, X86::CRC32r32r32, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1532 /* crc32l */, X86::CRC32r32m32, Convert__Reg1_1__Tie0_2_2__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1539 /* crc32q */, X86::CRC32r64r64, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1539 /* crc32q */, X86::CRC32r64m64, Convert__Reg1_1__Tie0_2_2__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1546 /* crc32w */, X86::CRC32r32r16, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR16, MCK_GR32 }, },
  { 1546 /* crc32w */, X86::CRC32r32m16, Convert__Reg1_1__Tie0_2_2__Mem165_0, 0, { MCK_Mem16, MCK_GR32 }, },
  { 1553 /* cs */, X86::CS_PREFIX, Convert_NoOperands, 0, {  }, },
  { 1556 /* cvtdq2pd */, X86::CVTDQ2PDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1556 /* cvtdq2pd */, X86::CVTDQ2PDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 1565 /* cvtdq2ps */, X86::CVTDQ2PSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1565 /* cvtdq2ps */, X86::CVTDQ2PSrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1574 /* cvtpd2dq */, X86::CVTPD2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1574 /* cvtpd2dq */, X86::CVTPD2DQrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1583 /* cvtpd2pi */, X86::MMX_CVTPD2PIirr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR64 }, },
  { 1583 /* cvtpd2pi */, X86::MMX_CVTPD2PIirm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR64 }, },
  { 1592 /* cvtpd2ps */, X86::CVTPD2PSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1592 /* cvtpd2ps */, X86::CVTPD2PSrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1601 /* cvtpi2pd */, X86::MMX_CVTPI2PDirr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_FR32 }, },
  { 1601 /* cvtpi2pd */, X86::MMX_CVTPI2PDirm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 1610 /* cvtpi2ps */, X86::MMX_CVTPI2PSirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_FR32 }, },
  { 1610 /* cvtpi2ps */, X86::MMX_CVTPI2PSirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 1619 /* cvtps2dq */, X86::CVTPS2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1619 /* cvtps2dq */, X86::CVTPS2DQrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1628 /* cvtps2pd */, X86::CVTPS2PDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1628 /* cvtps2pd */, X86::CVTPS2PDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 1637 /* cvtps2pi */, X86::MMX_CVTPS2PIirr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR64 }, },
  { 1637 /* cvtps2pi */, X86::MMX_CVTPS2PIirm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 1646 /* cvtsd2si */, X86::CVTSD2SIrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 1646 /* cvtsd2si */, X86::CVTSD2SI64rr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 1646 /* cvtsd2si */, X86::CVTSD2SIrm_Int, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 1646 /* cvtsd2si */, X86::CVTSD2SI64rm_Int, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1655 /* cvtsd2sil */, X86::CVTSD2SIrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 1655 /* cvtsd2sil */, X86::CVTSD2SIrm_Int, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 1665 /* cvtsd2siq */, X86::CVTSD2SI64rr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 1665 /* cvtsd2siq */, X86::CVTSD2SI64rm_Int, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1675 /* cvtsd2ss */, X86::CVTSD2SSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1675 /* cvtsd2ss */, X86::CVTSD2SSrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 1684 /* cvtsi2sd */, X86::CVTSI2SDrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 1693 /* cvtsi2sdl */, X86::CVTSI2SDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_FR32 }, },
  { 1693 /* cvtsi2sdl */, X86::CVTSI2SDrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 1703 /* cvtsi2sdq */, X86::CVTSI642SDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_FR32 }, },
  { 1703 /* cvtsi2sdq */, X86::CVTSI642SDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 1713 /* cvtsi2ss */, X86::CVTSI2SSrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 1722 /* cvtsi2ssl */, X86::CVTSI2SSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_FR32 }, },
  { 1722 /* cvtsi2ssl */, X86::CVTSI2SSrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 1732 /* cvtsi2ssq */, X86::CVTSI642SSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_FR32 }, },
  { 1732 /* cvtsi2ssq */, X86::CVTSI642SSrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 1742 /* cvtss2sd */, X86::CVTSS2SDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1742 /* cvtss2sd */, X86::CVTSS2SDrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 1751 /* cvtss2si */, X86::CVTSS2SIrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 1751 /* cvtss2si */, X86::CVTSS2SI64rr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 1751 /* cvtss2si */, X86::CVTSS2SIrm_Int, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1751 /* cvtss2si */, X86::CVTSS2SI64rm_Int, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 1760 /* cvtss2sil */, X86::CVTSS2SIrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 1760 /* cvtss2sil */, X86::CVTSS2SIrm_Int, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1770 /* cvtss2siq */, X86::CVTSS2SI64rr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 1770 /* cvtss2siq */, X86::CVTSS2SI64rm_Int, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 1780 /* cvttpd2dq */, X86::CVTTPD2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1780 /* cvttpd2dq */, X86::CVTTPD2DQrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1790 /* cvttpd2pi */, X86::MMX_CVTTPD2PIirr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR64 }, },
  { 1790 /* cvttpd2pi */, X86::MMX_CVTTPD2PIirm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR64 }, },
  { 1800 /* cvttps2dq */, X86::CVTTPS2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1800 /* cvttps2dq */, X86::CVTTPS2DQrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1810 /* cvttps2pi */, X86::MMX_CVTTPS2PIirr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR64 }, },
  { 1810 /* cvttps2pi */, X86::MMX_CVTTPS2PIirm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 1820 /* cvttsd2si */, X86::CVTTSD2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 1820 /* cvttsd2si */, X86::CVTTSD2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 1820 /* cvttsd2si */, X86::CVTTSD2SIrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 1820 /* cvttsd2si */, X86::CVTTSD2SI64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1830 /* cvttsd2sil */, X86::CVTTSD2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 1830 /* cvttsd2sil */, X86::CVTTSD2SIrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 1841 /* cvttsd2siq */, X86::CVTTSD2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 1841 /* cvttsd2siq */, X86::CVTTSD2SI64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1852 /* cvttss2si */, X86::CVTTSS2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 1852 /* cvttss2si */, X86::CVTTSS2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 1852 /* cvttss2si */, X86::CVTTSS2SIrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1852 /* cvttss2si */, X86::CVTTSS2SI64rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 1862 /* cvttss2sil */, X86::CVTTSS2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 1862 /* cvttss2sil */, X86::CVTTSS2SIrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1873 /* cvttss2siq */, X86::CVTTSS2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 1873 /* cvttss2siq */, X86::CVTTSS2SI64rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 1893 /* cwtd */, X86::CWD, Convert_NoOperands, 0, {  }, },
  { 1898 /* cwtl */, X86::CWDE, Convert_NoOperands, 0, {  }, },
  { 1903 /* daa */, X86::DAA, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 1907 /* das */, X86::DAS, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 1911 /* data16 */, X86::DATA16_PREFIX, Convert_NoOperands, 0, {  }, },
  { 1922 /* decb */, X86::DEC8r, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR8 }, },
  { 1922 /* decb */, X86::DEC8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 1927 /* decl */, X86::DEC32r_alt, Convert__Reg1_0__Tie0_1_1, Feature_Not64BitMode, { MCK_GR32 }, },
  { 1927 /* decl */, X86::DEC32r, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR32 }, },
  { 1927 /* decl */, X86::DEC32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 1932 /* decq */, X86::DEC64r, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR64 }, },
  { 1932 /* decq */, X86::DEC64m, Convert__Mem645_0, Feature_In64BitMode, { MCK_Mem64 }, },
  { 1937 /* decw */, X86::DEC16r_alt, Convert__Reg1_0__Tie0_1_1, Feature_Not64BitMode, { MCK_GR16 }, },
  { 1937 /* decw */, X86::DEC16r, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR16 }, },
  { 1937 /* decw */, X86::DEC16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 1946 /* divb */, X86::DIV8r, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 1946 /* divb */, X86::DIV8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 1946 /* divb */, X86::DIV8r, Convert__Reg1_0, 0, { MCK_GR8, MCK_AL }, },
  { 1946 /* divb */, X86::DIV8m, Convert__Mem85_0, 0, { MCK_Mem8, MCK_AL }, },
  { 1951 /* divl */, X86::DIV32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 1951 /* divl */, X86::DIV32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 1951 /* divl */, X86::DIV32r, Convert__Reg1_0, 0, { MCK_GR32, MCK_EAX }, },
  { 1951 /* divl */, X86::DIV32m, Convert__Mem325_0, 0, { MCK_Mem32, MCK_EAX }, },
  { 1956 /* divpd */, X86::DIVPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1956 /* divpd */, X86::DIVPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1962 /* divps */, X86::DIVPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1962 /* divps */, X86::DIVPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1968 /* divq */, X86::DIV64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 1968 /* divq */, X86::DIV64m, Convert__Mem645_0, Feature_In64BitMode, { MCK_Mem64 }, },
  { 1968 /* divq */, X86::DIV64r, Convert__Reg1_0, 0, { MCK_GR64, MCK_RAX }, },
  { 1968 /* divq */, X86::DIV64m, Convert__Mem645_0, 0, { MCK_Mem64, MCK_RAX }, },
  { 1973 /* divsd */, X86::DIVSDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1973 /* divsd */, X86::DIVSDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 1979 /* divss */, X86::DIVSSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1979 /* divss */, X86::DIVSSrm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 1985 /* divw */, X86::DIV16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 1985 /* divw */, X86::DIV16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 1985 /* divw */, X86::DIV16r, Convert__Reg1_0, 0, { MCK_GR16, MCK_AX }, },
  { 1985 /* divw */, X86::DIV16m, Convert__Mem165_0, 0, { MCK_Mem16, MCK_AX }, },
  { 1990 /* dppd */, X86::DPPDrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 1990 /* dppd */, X86::DPPDrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 1995 /* dpps */, X86::DPPSrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 1995 /* dpps */, X86::DPPSrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 2000 /* ds */, X86::DS_PREFIX, Convert_NoOperands, 0, {  }, },
  { 2003 /* emms */, X86::MMX_EMMS, Convert_NoOperands, 0, {  }, },
  { 2008 /* encls */, X86::ENCLS, Convert_NoOperands, 0, {  }, },
  { 2014 /* enclu */, X86::ENCLU, Convert_NoOperands, 0, {  }, },
  { 2020 /* enclv */, X86::ENCLV, Convert_NoOperands, 0, {  }, },
  { 2026 /* endbr32 */, X86::ENDBR32, Convert_NoOperands, 0, {  }, },
  { 2034 /* endbr64 */, X86::ENDBR64, Convert_NoOperands, 0, {  }, },
  { 2042 /* enter */, X86::ENTER, Convert__Imm1_0__Imm1_1, 0, { MCK_Imm, MCK_Imm }, },
  { 2048 /* es */, X86::ES_PREFIX, Convert_NoOperands, 0, {  }, },
  { 2051 /* extractps */, X86::EXTRACTPSrr, Convert__GR32orGR641_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_GR32orGR64 }, },
  { 2051 /* extractps */, X86::EXTRACTPSmr, Convert__Mem325_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_Mem32 }, },
  { 2061 /* extrq */, X86::EXTRQ, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 2061 /* extrq */, X86::EXTRQI, Convert__Reg1_2__Tie0_3_3__ImmUnsignedi81_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_ImmUnsignedi8, MCK_FR32 }, },
  { 2067 /* f2xm1 */, X86::F2XM1, Convert_NoOperands, 0, {  }, },
  { 2073 /* fabs */, X86::ABS_F, Convert_NoOperands, 0, {  }, },
  { 2078 /* fadd */, X86::ADD_FPrST0, Convert__regST1, 0, {  }, },
  { 2078 /* fadd */, X86::ADD_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2078 /* fadd */, X86::ADD_FST0r, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2078 /* fadd */, X86::ADD_FrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2078 /* fadd */, X86::ADD_FST0r, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2083 /* faddl */, X86::ADD_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2089 /* faddp */, X86::ADD_FPrST0, Convert__regST1, 0, {  }, },
  { 2089 /* faddp */, X86::ADD_FPrST0, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2089 /* faddp */, X86::ADD_FPrST0, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2089 /* faddp */, X86::ADD_FPrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2089 /* faddp */, X86::ADD_FPrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2095 /* fadds */, X86::ADD_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2101 /* fbld */, X86::FBLDm, Convert__Mem805_0, 0, { MCK_Mem80 }, },
  { 2106 /* fbstp */, X86::FBSTPm, Convert__Mem805_0, 0, { MCK_Mem80 }, },
  { 2112 /* fchs */, X86::CHS_F, Convert_NoOperands, 0, {  }, },
  { 2117 /* fcmovb */, X86::CMOVB_F, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2124 /* fcmovbe */, X86::CMOVBE_F, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2132 /* fcmove */, X86::CMOVE_F, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2139 /* fcmovnb */, X86::CMOVNB_F, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2147 /* fcmovnbe */, X86::CMOVNBE_F, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2156 /* fcmovne */, X86::CMOVNE_F, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2164 /* fcmovnu */, X86::CMOVNP_F, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2172 /* fcmovu */, X86::CMOVP_F, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2179 /* fcom */, X86::COM_FST0r, Convert__regST1, 0, {  }, },
  { 2179 /* fcom */, X86::COM_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2184 /* fcomi */, X86::COM_FIr, Convert__regST1, 0, {  }, },
  { 2184 /* fcomi */, X86::COM_FIr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2184 /* fcomi */, X86::COM_FIr, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2184 /* fcomi */, X86::COM_FIr, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2190 /* fcoml */, X86::FCOM64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2196 /* fcomp */, X86::COMP_FST0r, Convert__regST1, 0, {  }, },
  { 2196 /* fcomp */, X86::COMP_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2202 /* fcompi */, X86::COM_FIPr, Convert__regST1, 0, {  }, },
  { 2202 /* fcompi */, X86::COM_FIPr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2202 /* fcompi */, X86::COM_FIPr, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2202 /* fcompi */, X86::COM_FIPr, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2209 /* fcompl */, X86::FCOMP64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2216 /* fcompp */, X86::FCOMPP, Convert_NoOperands, 0, {  }, },
  { 2223 /* fcomps */, X86::FCOMP32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2230 /* fcoms */, X86::FCOM32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2236 /* fcos */, X86::COS_F, Convert_NoOperands, 0, {  }, },
  { 2241 /* fdecstp */, X86::FDECSTP, Convert_NoOperands, 0, {  }, },
  { 2249 /* fdiv */, X86::DIV_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2249 /* fdiv */, X86::DIV_FST0r, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2249 /* fdiv */, X86::DIVR_FrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2249 /* fdiv */, X86::DIV_FST0r, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2254 /* fdivl */, X86::DIV_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2260 /* fdivp */, X86::DIVR_FPrST0, Convert__regST1, 0, {  }, },
  { 2260 /* fdivp */, X86::DIVR_FPrST0, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2260 /* fdivp */, X86::DIVR_FPrST0, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2260 /* fdivp */, X86::DIVR_FPrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2260 /* fdivp */, X86::DIVR_FPrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2266 /* fdivr */, X86::DIVR_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2266 /* fdivr */, X86::DIVR_FST0r, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2266 /* fdivr */, X86::DIV_FrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2266 /* fdivr */, X86::DIVR_FST0r, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2272 /* fdivrl */, X86::DIVR_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2279 /* fdivrp */, X86::DIV_FPrST0, Convert__regST1, 0, {  }, },
  { 2279 /* fdivrp */, X86::DIV_FPrST0, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2279 /* fdivrp */, X86::DIV_FPrST0, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2279 /* fdivrp */, X86::DIV_FPrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2279 /* fdivrp */, X86::DIV_FPrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2286 /* fdivrs */, X86::DIVR_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2293 /* fdivs */, X86::DIV_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2299 /* femms */, X86::FEMMS, Convert_NoOperands, 0, {  }, },
  { 2305 /* ffree */, X86::FFREE, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2311 /* ffreep */, X86::FFREEP, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2324 /* fiaddl */, X86::ADD_FI32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2331 /* fiadds */, X86::ADD_FI16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2344 /* ficoml */, X86::FICOM32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2358 /* ficompl */, X86::FICOMP32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2366 /* ficomps */, X86::FICOMP16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2374 /* ficoms */, X86::FICOM16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2387 /* fidivl */, X86::DIV_FI32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2401 /* fidivrl */, X86::DIVR_FI32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2409 /* fidivrs */, X86::DIVR_FI16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2417 /* fidivs */, X86::DIV_FI16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2429 /* fildl */, X86::ILD_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2435 /* fildll */, X86::ILD_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2442 /* filds */, X86::ILD_F16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2454 /* fimull */, X86::MUL_FI32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2461 /* fimuls */, X86::MUL_FI16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2468 /* fincstp */, X86::FINCSTP, Convert_NoOperands, 0, {  }, },
  { 2481 /* fistl */, X86::IST_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2493 /* fistpl */, X86::IST_FP32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2500 /* fistpll */, X86::IST_FP64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2508 /* fistps */, X86::IST_FP16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2515 /* fists */, X86::IST_F16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2528 /* fisttpl */, X86::ISTT_FP32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2536 /* fisttpll */, X86::ISTT_FP64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2545 /* fisttps */, X86::ISTT_FP16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2559 /* fisubl */, X86::SUB_FI32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2573 /* fisubrl */, X86::SUBR_FI32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2581 /* fisubrs */, X86::SUBR_FI16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2589 /* fisubs */, X86::SUB_FI16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2596 /* fld */, X86::LD_Frr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2600 /* fld1 */, X86::LD_F1, Convert_NoOperands, 0, {  }, },
  { 2605 /* fldcw */, X86::FLDCW16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2611 /* fldenv */, X86::FLDENVm, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2618 /* fldl */, X86::LD_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2623 /* fldl2e */, X86::FLDL2E, Convert_NoOperands, 0, {  }, },
  { 2630 /* fldl2t */, X86::FLDL2T, Convert_NoOperands, 0, {  }, },
  { 2637 /* fldlg2 */, X86::FLDLG2, Convert_NoOperands, 0, {  }, },
  { 2644 /* fldln2 */, X86::FLDLN2, Convert_NoOperands, 0, {  }, },
  { 2651 /* fldpi */, X86::FLDPI, Convert_NoOperands, 0, {  }, },
  { 2657 /* flds */, X86::LD_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2662 /* fldt */, X86::LD_F80m, Convert__Mem805_0, 0, { MCK_Mem80 }, },
  { 2667 /* fldz */, X86::LD_F0, Convert_NoOperands, 0, {  }, },
  { 2672 /* fmul */, X86::MUL_FPrST0, Convert__regST1, 0, {  }, },
  { 2672 /* fmul */, X86::MUL_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2672 /* fmul */, X86::MUL_FST0r, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2672 /* fmul */, X86::MUL_FrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2672 /* fmul */, X86::MUL_FST0r, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2677 /* fmull */, X86::MUL_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2683 /* fmulp */, X86::MUL_FPrST0, Convert__regST1, 0, {  }, },
  { 2683 /* fmulp */, X86::MUL_FPrST0, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2683 /* fmulp */, X86::MUL_FPrST0, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2683 /* fmulp */, X86::MUL_FPrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2683 /* fmulp */, X86::MUL_FPrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2689 /* fmuls */, X86::MUL_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2695 /* fnclex */, X86::FNCLEX, Convert_NoOperands, 0, {  }, },
  { 2702 /* fninit */, X86::FNINIT, Convert_NoOperands, 0, {  }, },
  { 2709 /* fnop */, X86::FNOP, Convert_NoOperands, 0, {  }, },
  { 2714 /* fnsave */, X86::FSAVEm, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2721 /* fnstcw */, X86::FNSTCW16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2728 /* fnstenv */, X86::FSTENVm, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2736 /* fnstsw */, X86::FNSTSW16r, Convert_NoOperands, 0, {  }, },
  { 2736 /* fnstsw */, X86::FNSTSW16r, Convert_NoOperands, 0, { MCK_AX }, },
  { 2736 /* fnstsw */, X86::FNSTSWm, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2743 /* fpatan */, X86::FPATAN, Convert_NoOperands, 0, {  }, },
  { 2750 /* fprem */, X86::FPREM, Convert_NoOperands, 0, {  }, },
  { 2756 /* fprem1 */, X86::FPREM1, Convert_NoOperands, 0, {  }, },
  { 2763 /* fptan */, X86::FPTAN, Convert_NoOperands, 0, {  }, },
  { 2769 /* frndint */, X86::FRNDINT, Convert_NoOperands, 0, {  }, },
  { 2777 /* frstor */, X86::FRSTORm, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2784 /* fs */, X86::FS_PREFIX, Convert_NoOperands, 0, {  }, },
  { 2787 /* fscale */, X86::FSCALE, Convert_NoOperands, 0, {  }, },
  { 2794 /* fsin */, X86::SIN_F, Convert_NoOperands, 0, {  }, },
  { 2799 /* fsincos */, X86::FSINCOS, Convert_NoOperands, 0, {  }, },
  { 2807 /* fsqrt */, X86::SQRT_F, Convert_NoOperands, 0, {  }, },
  { 2813 /* fst */, X86::ST_Frr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2817 /* fstl */, X86::ST_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2822 /* fstp */, X86::ST_FPrr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2827 /* fstpl */, X86::ST_FP64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2833 /* fstps */, X86::ST_FP32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2839 /* fstpt */, X86::ST_FP80m, Convert__Mem805_0, 0, { MCK_Mem80 }, },
  { 2845 /* fsts */, X86::ST_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2850 /* fsub */, X86::SUB_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2850 /* fsub */, X86::SUB_FST0r, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2850 /* fsub */, X86::SUBR_FrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2850 /* fsub */, X86::SUB_FST0r, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2855 /* fsubl */, X86::SUB_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2861 /* fsubp */, X86::SUBR_FPrST0, Convert__regST1, 0, {  }, },
  { 2861 /* fsubp */, X86::SUBR_FPrST0, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2861 /* fsubp */, X86::SUBR_FPrST0, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2861 /* fsubp */, X86::SUBR_FPrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2861 /* fsubp */, X86::SUBR_FPrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2867 /* fsubr */, X86::SUBR_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2867 /* fsubr */, X86::SUBR_FST0r, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2867 /* fsubr */, X86::SUB_FrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2867 /* fsubr */, X86::SUBR_FST0r, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2873 /* fsubrl */, X86::SUBR_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2880 /* fsubrp */, X86::SUB_FPrST0, Convert__regST1, 0, {  }, },
  { 2880 /* fsubrp */, X86::SUB_FPrST0, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2880 /* fsubrp */, X86::SUB_FPrST0, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2880 /* fsubrp */, X86::SUB_FPrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2880 /* fsubrp */, X86::SUB_FPrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2887 /* fsubrs */, X86::SUBR_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2894 /* fsubs */, X86::SUB_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2900 /* ftst */, X86::TST_F, Convert_NoOperands, 0, {  }, },
  { 2905 /* fucom */, X86::UCOM_Fr, Convert__regST1, 0, {  }, },
  { 2905 /* fucom */, X86::UCOM_Fr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2911 /* fucomi */, X86::UCOM_FIr, Convert__regST1, 0, {  }, },
  { 2911 /* fucomi */, X86::UCOM_FIr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2911 /* fucomi */, X86::UCOM_FIr, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2911 /* fucomi */, X86::UCOM_FIr, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2918 /* fucomp */, X86::UCOM_FPr, Convert__regST1, 0, {  }, },
  { 2918 /* fucomp */, X86::UCOM_FPr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2925 /* fucompi */, X86::UCOM_FIPr, Convert__regST1, 0, {  }, },
  { 2925 /* fucompi */, X86::UCOM_FIPr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2925 /* fucompi */, X86::UCOM_FIPr, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2925 /* fucompi */, X86::UCOM_FIPr, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2933 /* fucompp */, X86::UCOM_FPPr, Convert_NoOperands, 0, {  }, },
  { 2941 /* fxam */, X86::FXAM, Convert_NoOperands, 0, {  }, },
  { 2946 /* fxch */, X86::XCH_F, Convert__regST1, 0, {  }, },
  { 2946 /* fxch */, X86::XCH_F, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2951 /* fxrstor */, X86::FXRSTOR, Convert__Mem5_0, 0, { MCK_Mem }, },
  { 2959 /* fxrstor64 */, X86::FXRSTOR64, Convert__Mem5_0, Feature_In64BitMode, { MCK_Mem }, },
  { 2969 /* fxsave */, X86::FXSAVE, Convert__Mem5_0, 0, { MCK_Mem }, },
  { 2976 /* fxsave64 */, X86::FXSAVE64, Convert__Mem5_0, Feature_In64BitMode, { MCK_Mem }, },
  { 2985 /* fxtract */, X86::FXTRACT, Convert_NoOperands, 0, {  }, },
  { 2993 /* fyl2x */, X86::FYL2X, Convert_NoOperands, 0, {  }, },
  { 2999 /* fyl2xp1 */, X86::FYL2XP1, Convert_NoOperands, 0, {  }, },
  { 3007 /* getsec */, X86::GETSEC, Convert_NoOperands, 0, {  }, },
  { 3014 /* gf2p8affineinvqb */, X86::GF2P8AFFINEINVQBrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 3014 /* gf2p8affineinvqb */, X86::GF2P8AFFINEINVQBrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 3031 /* gf2p8affineqb */, X86::GF2P8AFFINEQBrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 3031 /* gf2p8affineqb */, X86::GF2P8AFFINEQBrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 3045 /* gf2p8mulb */, X86::GF2P8MULBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3045 /* gf2p8mulb */, X86::GF2P8MULBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3055 /* gs */, X86::GS_PREFIX, Convert_NoOperands, 0, {  }, },
  { 3058 /* haddpd */, X86::HADDPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3058 /* haddpd */, X86::HADDPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3065 /* haddps */, X86::HADDPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3065 /* haddps */, X86::HADDPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3072 /* hlt */, X86::HLT, Convert_NoOperands, 0, {  }, },
  { 3076 /* hsubpd */, X86::HSUBPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3076 /* hsubpd */, X86::HSUBPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3083 /* hsubps */, X86::HSUBPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3083 /* hsubps */, X86::HSUBPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3095 /* idivb */, X86::IDIV8r, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 3095 /* idivb */, X86::IDIV8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 3095 /* idivb */, X86::IDIV8r, Convert__Reg1_0, 0, { MCK_GR8, MCK_AL }, },
  { 3095 /* idivb */, X86::IDIV8m, Convert__Mem85_0, 0, { MCK_Mem8, MCK_AL }, },
  { 3101 /* idivl */, X86::IDIV32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 3101 /* idivl */, X86::IDIV32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 3101 /* idivl */, X86::IDIV32r, Convert__Reg1_0, 0, { MCK_GR32, MCK_EAX }, },
  { 3101 /* idivl */, X86::IDIV32m, Convert__Mem325_0, 0, { MCK_Mem32, MCK_EAX }, },
  { 3107 /* idivq */, X86::IDIV64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 3107 /* idivq */, X86::IDIV64m, Convert__Mem645_0, Feature_In64BitMode, { MCK_Mem64 }, },
  { 3107 /* idivq */, X86::IDIV64r, Convert__Reg1_0, 0, { MCK_GR64, MCK_RAX }, },
  { 3107 /* idivq */, X86::IDIV64m, Convert__Mem645_0, 0, { MCK_Mem64, MCK_RAX }, },
  { 3113 /* idivw */, X86::IDIV16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 3113 /* idivw */, X86::IDIV16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 3113 /* idivw */, X86::IDIV16r, Convert__Reg1_0, 0, { MCK_GR16, MCK_AX }, },
  { 3113 /* idivw */, X86::IDIV16m, Convert__Mem165_0, 0, { MCK_Mem16, MCK_AX }, },
  { 3124 /* imulb */, X86::IMUL8r, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 3124 /* imulb */, X86::IMUL8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 3130 /* imull */, X86::IMUL32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 3130 /* imull */, X86::IMUL32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 3130 /* imull */, X86::IMUL32rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 3130 /* imull */, X86::IMUL32rri8, Convert__Reg1_1__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 3130 /* imull */, X86::IMUL32rri, Convert__Reg1_1__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 3130 /* imull */, X86::IMUL32rm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 3130 /* imull */, X86::IMUL32rri8, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32, MCK_GR32 }, },
  { 3130 /* imull */, X86::IMUL32rmi8, Convert__Reg1_2__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32, MCK_GR32 }, },
  { 3130 /* imull */, X86::IMUL32rri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32, MCK_GR32 }, },
  { 3130 /* imull */, X86::IMUL32rmi, Convert__Reg1_2__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32, MCK_GR32 }, },
  { 3136 /* imulq */, X86::IMUL64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 3136 /* imulq */, X86::IMUL64m, Convert__Mem645_0, Feature_In64BitMode, { MCK_Mem64 }, },
  { 3136 /* imulq */, X86::IMUL64rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 3136 /* imulq */, X86::IMUL64rri8, Convert__Reg1_1__Reg1_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 3136 /* imulq */, X86::IMUL64rri32, Convert__Reg1_1__Reg1_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 3136 /* imulq */, X86::IMUL64rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 3136 /* imulq */, X86::IMUL64rri8, Convert__Reg1_2__Reg1_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64, MCK_GR64 }, },
  { 3136 /* imulq */, X86::IMUL64rmi8, Convert__Reg1_2__Mem645_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_Mem64, MCK_GR64 }, },
  { 3136 /* imulq */, X86::IMUL64rri32, Convert__Reg1_2__Reg1_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64, MCK_GR64 }, },
  { 3136 /* imulq */, X86::IMUL64rmi32, Convert__Reg1_2__Mem645_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_Mem64, MCK_GR64 }, },
  { 3142 /* imulw */, X86::IMUL16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 3142 /* imulw */, X86::IMUL16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 3142 /* imulw */, X86::IMUL16rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 3142 /* imulw */, X86::IMUL16rri8, Convert__Reg1_1__Reg1_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 3142 /* imulw */, X86::IMUL16rri, Convert__Reg1_1__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 3142 /* imulw */, X86::IMUL16rm, Convert__Reg1_1__Tie0_1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 3142 /* imulw */, X86::IMUL16rri8, Convert__Reg1_2__Reg1_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16, MCK_GR16 }, },
  { 3142 /* imulw */, X86::IMUL16rmi8, Convert__Reg1_2__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16, MCK_GR16 }, },
  { 3142 /* imulw */, X86::IMUL16rri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR16, MCK_GR16 }, },
  { 3142 /* imulw */, X86::IMUL16rmi, Convert__Reg1_2__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16, MCK_GR16 }, },
  { 3151 /* inb */, X86::IN8rr, Convert_NoOperands, 0, { MCK_DX }, },
  { 3151 /* inb */, X86::IN8ri, Convert__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8 }, },
  { 3151 /* inb */, X86::IN8rr, Convert_NoOperands, 0, { MCK_DX, MCK_AL }, },
  { 3151 /* inb */, X86::IN8ri, Convert__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_AL }, },
  { 3159 /* incb */, X86::INC8r, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR8 }, },
  { 3159 /* incb */, X86::INC8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 3164 /* incl */, X86::INC32r_alt, Convert__Reg1_0__Tie0_1_1, Feature_Not64BitMode, { MCK_GR32 }, },
  { 3164 /* incl */, X86::INC32r, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR32 }, },
  { 3164 /* incl */, X86::INC32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 3169 /* incq */, X86::INC64r, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR64 }, },
  { 3169 /* incq */, X86::INC64m, Convert__Mem645_0, Feature_In64BitMode, { MCK_Mem64 }, },
  { 3174 /* incsspd */, X86::INCSSPD, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 3182 /* incsspq */, X86::INCSSPQ, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 3190 /* incw */, X86::INC16r_alt, Convert__Reg1_0__Tie0_1_1, Feature_Not64BitMode, { MCK_GR16 }, },
  { 3190 /* incw */, X86::INC16r, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR16 }, },
  { 3190 /* incw */, X86::INC16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 3195 /* inl */, X86::IN32rr, Convert_NoOperands, 0, { MCK_DX }, },
  { 3195 /* inl */, X86::IN32ri, Convert__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8 }, },
  { 3195 /* inl */, X86::IN32rr, Convert_NoOperands, 0, { MCK_DX, MCK_EAX }, },
  { 3195 /* inl */, X86::IN32ri, Convert__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_EAX }, },
  { 3203 /* insb */, X86::INSB, Convert__DstIdx81_1, 0, { MCK_DX, MCK_DstIdx8 }, },
  { 3213 /* insertps */, X86::INSERTPSrr, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 3213 /* insertps */, X86::INSERTPSrm, Convert__Reg1_2__Tie0_1_1__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_FR32 }, },
  { 3222 /* insertq */, X86::INSERTQ, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3222 /* insertq */, X86::INSERTQI, Convert__Reg1_3__Tie0_4_4__Reg1_2__ImmUnsignedi81_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 3230 /* insl */, X86::INSL, Convert__DstIdx321_1, 0, { MCK_DX, MCK_DstIdx32 }, },
  { 3235 /* insw */, X86::INSW, Convert__DstIdx161_1, 0, { MCK_DX, MCK_DstIdx16 }, },
  { 3240 /* int */, X86::INT, Convert__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8 }, },
  { 3244 /* int3 */, X86::INT3, Convert_NoOperands, 0, {  }, },
  { 3249 /* into */, X86::INTO, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 3254 /* invd */, X86::INVD, Convert_NoOperands, 0, {  }, },
  { 3259 /* invept */, X86::INVEPT32, Convert__Reg1_1__Mem1285_0, Feature_Not64BitMode, { MCK_Mem128, MCK_GR32 }, },
  { 3259 /* invept */, X86::INVEPT64, Convert__Reg1_1__Mem1285_0, Feature_In64BitMode, { MCK_Mem128, MCK_GR64 }, },
  { 3266 /* invlpg */, X86::INVLPG, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 3273 /* invlpga */, X86::INVLPGA32, Convert_NoOperands, Feature_Not64BitMode, { MCK_EAX, MCK_ECX }, },
  { 3273 /* invlpga */, X86::INVLPGA64, Convert_NoOperands, Feature_In64BitMode, { MCK_RAX, MCK_ECX }, },
  { 3281 /* invpcid */, X86::INVPCID32, Convert__Reg1_1__Mem1285_0, Feature_Not64BitMode, { MCK_Mem128, MCK_GR32 }, },
  { 3281 /* invpcid */, X86::INVPCID64, Convert__Reg1_1__Mem1285_0, Feature_In64BitMode, { MCK_Mem128, MCK_GR64 }, },
  { 3289 /* invvpid */, X86::INVVPID32, Convert__Reg1_1__Mem1285_0, Feature_Not64BitMode, { MCK_Mem128, MCK_GR32 }, },
  { 3289 /* invvpid */, X86::INVVPID64, Convert__Reg1_1__Mem1285_0, Feature_In64BitMode, { MCK_Mem128, MCK_GR64 }, },
  { 3297 /* inw */, X86::IN16rr, Convert_NoOperands, 0, { MCK_DX }, },
  { 3297 /* inw */, X86::IN16ri, Convert__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8 }, },
  { 3297 /* inw */, X86::IN16rr, Convert_NoOperands, 0, { MCK_DX, MCK_AX }, },
  { 3297 /* inw */, X86::IN16ri, Convert__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_AX }, },
  { 3312 /* iretl */, X86::IRET32, Convert_NoOperands, 0, {  }, },
  { 3318 /* iretq */, X86::IRET64, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 3324 /* iretw */, X86::IRET16, Convert_NoOperands, 0, {  }, },
  { 3330 /* ja */, X86::JA_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3333 /* jae */, X86::JAE_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3337 /* jb */, X86::JB_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3340 /* jbe */, X86::JBE_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3344 /* jcxz */, X86::JCXZ, Convert__AbsMem1_0, Feature_Not64BitMode, { MCK_AbsMem }, },
  { 3349 /* je */, X86::JE_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3352 /* jecxz */, X86::JECXZ, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3358 /* jg */, X86::JG_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3361 /* jge */, X86::JGE_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3365 /* jl */, X86::JL_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3368 /* jle */, X86::JLE_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3372 /* jmp */, X86::JMP_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3372 /* jmp */, X86::JMP16m, Convert__Mem165_1, Feature_In16BitMode, { MCK__STAR_, MCK_Mem16 }, },
  { 3372 /* jmp */, X86::JMP32m, Convert__Mem325_1, Feature_In32BitMode, { MCK__STAR_, MCK_Mem32 }, },
  { 3372 /* jmp */, X86::JMP64m, Convert__Mem645_1, Feature_In64BitMode, { MCK__STAR_, MCK_Mem64 }, },
  { 3372 /* jmp */, X86::FARJMP16i, Convert__Imm1_1__Imm1_0, Feature_In16BitMode, { MCK_Imm, MCK_Imm }, },
  { 3372 /* jmp */, X86::FARJMP32i, Convert__Imm1_1__Imm1_0, Feature_In32BitMode, { MCK_Imm, MCK_Imm }, },
  { 3376 /* jmpl */, X86::JMP32r, Convert__Reg1_1, Feature_Not64BitMode, { MCK__STAR_, MCK_GR32 }, },
  { 3376 /* jmpl */, X86::JMP32m, Convert__Mem325_1, Feature_Not64BitMode, { MCK__STAR_, MCK_Mem32 }, },
  { 3376 /* jmpl */, X86::FARJMP32i, Convert__Imm1_1__Imm1_0, Feature_Not64BitMode, { MCK_Imm, MCK_Imm }, },
  { 3381 /* jmpq */, X86::JMP64r, Convert__Reg1_1, Feature_In64BitMode, { MCK__STAR_, MCK_GR64 }, },
  { 3381 /* jmpq */, X86::JMP64m, Convert__Mem645_1, Feature_In64BitMode, { MCK__STAR_, MCK_Mem64 }, },
  { 3386 /* jmpw */, X86::JMP16r, Convert__Reg1_1, Feature_Not64BitMode, { MCK__STAR_, MCK_GR16 }, },
  { 3386 /* jmpw */, X86::JMP16m, Convert__Mem165_1, Feature_Not64BitMode, { MCK__STAR_, MCK_Mem16 }, },
  { 3386 /* jmpw */, X86::FARJMP16i, Convert__Imm1_1__Imm1_0, Feature_Not64BitMode, { MCK_Imm, MCK_Imm }, },
  { 3391 /* jne */, X86::JNE_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3395 /* jno */, X86::JNO_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3399 /* jnp */, X86::JNP_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3403 /* jns */, X86::JNS_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3407 /* jo */, X86::JO_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3410 /* jp */, X86::JP_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3413 /* jrcxz */, X86::JRCXZ, Convert__AbsMem1_0, Feature_In64BitMode, { MCK_AbsMem }, },
  { 3419 /* js */, X86::JS_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3422 /* kaddb */, X86::KADDBrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3428 /* kaddd */, X86::KADDDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3434 /* kaddq */, X86::KADDQrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3440 /* kaddw */, X86::KADDWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3446 /* kandb */, X86::KANDBrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3452 /* kandd */, X86::KANDDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3458 /* kandnb */, X86::KANDNBrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3465 /* kandnd */, X86::KANDNDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3472 /* kandnq */, X86::KANDNQrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3479 /* kandnw */, X86::KANDNWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3486 /* kandq */, X86::KANDQrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3492 /* kandw */, X86::KANDWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3498 /* kmovb */, X86::KMOVBkk, Convert__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1 }, },
  { 3498 /* kmovb */, X86::KMOVBrk, Convert__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_GR32 }, },
  { 3498 /* kmovb */, X86::KMOVBmk, Convert__Mem85_1__Reg1_0, 0, { MCK_VK1, MCK_Mem8 }, },
  { 3498 /* kmovb */, X86::KMOVBkr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_VK1 }, },
  { 3498 /* kmovb */, X86::KMOVBkm, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_VK1 }, },
  { 3504 /* kmovd */, X86::KMOVDkk, Convert__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1 }, },
  { 3504 /* kmovd */, X86::KMOVDrk, Convert__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_GR32 }, },
  { 3504 /* kmovd */, X86::KMOVDmk, Convert__Mem325_1__Reg1_0, 0, { MCK_VK1, MCK_Mem32 }, },
  { 3504 /* kmovd */, X86::KMOVDkr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_VK1 }, },
  { 3504 /* kmovd */, X86::KMOVDkm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_VK1 }, },
  { 3510 /* kmovq */, X86::KMOVQkk, Convert__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1 }, },
  { 3510 /* kmovq */, X86::KMOVQrk, Convert__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_GR64 }, },
  { 3510 /* kmovq */, X86::KMOVQmk, Convert__Mem645_1__Reg1_0, 0, { MCK_VK1, MCK_Mem64 }, },
  { 3510 /* kmovq */, X86::KMOVQkr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_VK1 }, },
  { 3510 /* kmovq */, X86::KMOVQkm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VK1 }, },
  { 3516 /* kmovw */, X86::KMOVWkk, Convert__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1 }, },
  { 3516 /* kmovw */, X86::KMOVWrk, Convert__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_GR32 }, },
  { 3516 /* kmovw */, X86::KMOVWmk, Convert__Mem165_1__Reg1_0, 0, { MCK_VK1, MCK_Mem16 }, },
  { 3516 /* kmovw */, X86::KMOVWkr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_VK1 }, },
  { 3516 /* kmovw */, X86::KMOVWkm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_VK1 }, },
  { 3522 /* knotb */, X86::KNOTBrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1 }, },
  { 3528 /* knotd */, X86::KNOTDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1 }, },
  { 3534 /* knotq */, X86::KNOTQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1 }, },
  { 3540 /* knotw */, X86::KNOTWrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1 }, },
  { 3546 /* korb */, X86::KORBrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3551 /* kord */, X86::KORDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3556 /* korq */, X86::KORQrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3561 /* kortestb */, X86::KORTESTBrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1 }, },
  { 3570 /* kortestd */, X86::KORTESTDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1 }, },
  { 3579 /* kortestq */, X86::KORTESTQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1 }, },
  { 3588 /* kortestw */, X86::KORTESTWrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1 }, },
  { 3597 /* korw */, X86::KORWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3602 /* kshiftlb */, X86::KSHIFTLBri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VK1, MCK_VK1 }, },
  { 3611 /* kshiftld */, X86::KSHIFTLDri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VK1, MCK_VK1 }, },
  { 3620 /* kshiftlq */, X86::KSHIFTLQri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VK1, MCK_VK1 }, },
  { 3629 /* kshiftlw */, X86::KSHIFTLWri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VK1, MCK_VK1 }, },
  { 3638 /* kshiftrb */, X86::KSHIFTRBri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VK1, MCK_VK1 }, },
  { 3647 /* kshiftrd */, X86::KSHIFTRDri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VK1, MCK_VK1 }, },
  { 3656 /* kshiftrq */, X86::KSHIFTRQri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VK1, MCK_VK1 }, },
  { 3665 /* kshiftrw */, X86::KSHIFTRWri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VK1, MCK_VK1 }, },
  { 3674 /* ktestb */, X86::KTESTBrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1 }, },
  { 3681 /* ktestd */, X86::KTESTDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1 }, },
  { 3688 /* ktestq */, X86::KTESTQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1 }, },
  { 3695 /* ktestw */, X86::KTESTWrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1 }, },
  { 3702 /* kunpckbw */, X86::KUNPCKBWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3711 /* kunpckdq */, X86::KUNPCKDQrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3720 /* kunpckwd */, X86::KUNPCKWDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3729 /* kxnorb */, X86::KXNORBrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3736 /* kxnord */, X86::KXNORDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3743 /* kxnorq */, X86::KXNORQrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3750 /* kxnorw */, X86::KXNORWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3757 /* kxorb */, X86::KXORBrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3763 /* kxord */, X86::KXORDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3769 /* kxorq */, X86::KXORQrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3775 /* kxorw */, X86::KXORWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3781 /* lahf */, X86::LAHF, Convert_NoOperands, 0, {  }, },
  { 3790 /* larl */, X86::LAR32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 3790 /* larl */, X86::LAR32rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR32 }, },
  { 3795 /* larq */, X86::LAR64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR64 }, },
  { 3795 /* larq */, X86::LAR64rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR64 }, },
  { 3800 /* larw */, X86::LAR16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 3800 /* larw */, X86::LAR16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 3805 /* lcall */, X86::FARCALL32m, Convert__Mem5_1, Feature_Not16BitMode, { MCK__STAR_, MCK_Mem }, },
  { 3805 /* lcall */, X86::FARCALL16m, Convert__Mem5_1, Feature_In16BitMode, { MCK__STAR_, MCK_Mem }, },
  { 3805 /* lcall */, X86::FARCALL32i, Convert__Imm1_1__Imm1_0, Feature_In32BitMode, { MCK_Imm, MCK_Imm }, },
  { 3805 /* lcall */, X86::FARCALL16i, Convert__Imm1_1__Imm1_0, Feature_In16BitMode, { MCK_Imm, MCK_Imm }, },
  { 3811 /* lcalll */, X86::FARCALL32m, Convert__Mem5_1, 0, { MCK__STAR_, MCK_Mem }, },
  { 3811 /* lcalll */, X86::FARCALL32i, Convert__Imm1_1__Imm1_0, Feature_Not64BitMode, { MCK_Imm, MCK_Imm }, },
  { 3818 /* lcallq */, X86::FARCALL64, Convert__Mem5_1, 0, { MCK__STAR_, MCK_Mem }, },
  { 3825 /* lcallw */, X86::FARCALL16m, Convert__Mem5_1, 0, { MCK__STAR_, MCK_Mem }, },
  { 3825 /* lcallw */, X86::FARCALL16i, Convert__Imm1_1__Imm1_0, Feature_Not64BitMode, { MCK_Imm, MCK_Imm }, },
  { 3832 /* lddqu */, X86::LDDQUrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3838 /* ldmxcsr */, X86::LDMXCSR, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 3850 /* ldsl */, X86::LDS32rm, Convert__Reg1_1__Mem5_0, Feature_Not64BitMode, { MCK_Mem, MCK_GR32 }, },
  { 3855 /* ldsw */, X86::LDS16rm, Convert__Reg1_1__Mem5_0, Feature_Not64BitMode, { MCK_Mem, MCK_GR16 }, },
  { 3864 /* leal */, X86::LEA32r, Convert__Reg1_1__Mem5_0, Feature_Not64BitMode, { MCK_Mem, MCK_GR32 }, },
  { 3864 /* leal */, X86::LEA64_32r, Convert__Reg1_1__Mem5_0, Feature_In64BitMode, { MCK_Mem, MCK_GR32 }, },
  { 3869 /* leaq */, X86::LEA64r, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR64 }, },
  { 3874 /* leave */, X86::LEAVE, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 3874 /* leave */, X86::LEAVE64, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 3880 /* leaw */, X86::LEA16r, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR16 }, },
  { 3889 /* lesl */, X86::LES32rm, Convert__Reg1_1__Mem5_0, Feature_Not64BitMode, { MCK_Mem, MCK_GR32 }, },
  { 3894 /* lesw */, X86::LES16rm, Convert__Reg1_1__Mem5_0, Feature_Not64BitMode, { MCK_Mem, MCK_GR16 }, },
  { 3899 /* lfence */, X86::LFENCE, Convert_NoOperands, 0, {  }, },
  { 3910 /* lfsl */, X86::LFS32rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR32 }, },
  { 3915 /* lfsq */, X86::LFS64rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR64 }, },
  { 3920 /* lfsw */, X86::LFS16rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR16 }, },
  { 3936 /* lgdtl */, X86::LGDT32m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 3942 /* lgdtq */, X86::LGDT64m, Convert__Mem5_0, Feature_In64BitMode, { MCK_Mem }, },
  { 3948 /* lgdtw */, X86::LGDT16m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 3958 /* lgsl */, X86::LGS32rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR32 }, },
  { 3963 /* lgsq */, X86::LGS64rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR64 }, },
  { 3968 /* lgsw */, X86::LGS16rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR16 }, },
  { 3984 /* lidtl */, X86::LIDT32m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 3990 /* lidtq */, X86::LIDT64m, Convert__Mem5_0, Feature_In64BitMode, { MCK_Mem }, },
  { 3996 /* lidtw */, X86::LIDT16m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 4002 /* ljmp */, X86::FARJMP32m, Convert__Mem5_1, Feature_Not16BitMode, { MCK__STAR_, MCK_Mem }, },
  { 4002 /* ljmp */, X86::FARJMP16m, Convert__Mem5_1, Feature_In16BitMode, { MCK__STAR_, MCK_Mem }, },
  { 4002 /* ljmp */, X86::FARJMP32i, Convert__Imm1_1__Imm1_0, Feature_In32BitMode, { MCK_Imm, MCK_Imm }, },
  { 4002 /* ljmp */, X86::FARJMP16i, Convert__Imm1_1__Imm1_0, Feature_In16BitMode, { MCK_Imm, MCK_Imm }, },
  { 4007 /* ljmpl */, X86::FARJMP32m, Convert__Mem5_1, 0, { MCK__STAR_, MCK_Mem }, },
  { 4007 /* ljmpl */, X86::FARJMP32i, Convert__Imm1_1__Imm1_0, Feature_Not64BitMode, { MCK_Imm, MCK_Imm }, },
  { 4013 /* ljmpq */, X86::FARJMP64, Convert__Mem5_1, Feature_In64BitMode, { MCK__STAR_, MCK_Mem }, },
  { 4019 /* ljmpw */, X86::FARJMP16m, Convert__Mem5_1, 0, { MCK__STAR_, MCK_Mem }, },
  { 4019 /* ljmpw */, X86::FARJMP16i, Convert__Imm1_1__Imm1_0, Feature_Not64BitMode, { MCK_Imm, MCK_Imm }, },
  { 4030 /* lldtw */, X86::LLDT16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 4030 /* lldtw */, X86::LLDT16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 4036 /* llwpcb */, X86::LLWPCB, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 4036 /* llwpcb */, X86::LLWPCB64, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 4048 /* lmsww */, X86::LMSW16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 4048 /* lmsww */, X86::LMSW16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 4054 /* lock */, X86::LOCK_PREFIX, Convert_NoOperands, 0, {  }, },
  { 4059 /* lods */, X86::LODSW, Convert__SrcIdx162_0, 0, { MCK_SrcIdx16, MCK_AX }, },
  { 4059 /* lods */, X86::LODSL, Convert__SrcIdx322_0, 0, { MCK_SrcIdx32, MCK_EAX }, },
  { 4059 /* lods */, X86::LODSQ, Convert__SrcIdx642_0, Feature_In64BitMode, { MCK_SrcIdx64, MCK_RAX }, },
  { 4059 /* lods */, X86::LODSB, Convert__SrcIdx82_0, 0, { MCK_SrcIdx8, MCK_AL }, },
  { 4064 /* lodsb */, X86::LODSB, Convert__SrcIdx82_0, 0, { MCK_SrcIdx8 }, },
  { 4064 /* lodsb */, X86::LODSB, Convert__SrcIdx82_0, 0, { MCK_SrcIdx8, MCK_AL }, },
  { 4076 /* lodsl */, X86::LODSL, Convert__SrcIdx322_0, 0, { MCK_SrcIdx32 }, },
  { 4076 /* lodsl */, X86::LODSL, Convert__SrcIdx322_0, 0, { MCK_SrcIdx32, MCK_EAX }, },
  { 4082 /* lodsq */, X86::LODSQ, Convert__SrcIdx642_0, Feature_In64BitMode, { MCK_SrcIdx64 }, },
  { 4082 /* lodsq */, X86::LODSQ, Convert__SrcIdx642_0, Feature_In64BitMode, { MCK_SrcIdx64, MCK_RAX }, },
  { 4088 /* lodsw */, X86::LODSW, Convert__SrcIdx162_0, 0, { MCK_SrcIdx16 }, },
  { 4088 /* lodsw */, X86::LODSW, Convert__SrcIdx162_0, 0, { MCK_SrcIdx16, MCK_AX }, },
  { 4094 /* loop */, X86::LOOP, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 4099 /* loope */, X86::LOOPE, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 4105 /* loopne */, X86::LOOPNE, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 4112 /* lretl */, X86::LRETL, Convert_NoOperands, 0, {  }, },
  { 4112 /* lretl */, X86::LRETIL, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 4118 /* lretq */, X86::LRETQ, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 4118 /* lretq */, X86::LRETIQ, Convert__Imm1_0, Feature_In64BitMode, { MCK_Imm }, },
  { 4124 /* lretw */, X86::LRETW, Convert_NoOperands, 0, {  }, },
  { 4124 /* lretw */, X86::LRETIW, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 4134 /* lsll */, X86::LSL32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 4134 /* lsll */, X86::LSL32rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR32 }, },
  { 4139 /* lslq */, X86::LSL64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR64 }, },
  { 4139 /* lslq */, X86::LSL64rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR64 }, },
  { 4144 /* lslw */, X86::LSL16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 4144 /* lslw */, X86::LSL16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 4153 /* lssl */, X86::LSS32rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR32 }, },
  { 4158 /* lssq */, X86::LSS64rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR64 }, },
  { 4163 /* lssw */, X86::LSS16rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR16 }, },
  { 4172 /* ltrw */, X86::LTRr, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 4172 /* ltrw */, X86::LTRm, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 4177 /* lwpins */, X86::LWPINS32rri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32, MCK_GR32 }, },
  { 4177 /* lwpins */, X86::LWPINS64rri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32, MCK_GR64 }, },
  { 4177 /* lwpins */, X86::LWPINS32rmi, Convert__Reg1_2__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32, MCK_GR32 }, },
  { 4177 /* lwpins */, X86::LWPINS64rmi, Convert__Reg1_2__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32, MCK_GR64 }, },
  { 4184 /* lwpval */, X86::LWPVAL32rri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32, MCK_GR32 }, },
  { 4184 /* lwpval */, X86::LWPVAL64rri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32, MCK_GR64 }, },
  { 4184 /* lwpval */, X86::LWPVAL32rmi, Convert__Reg1_2__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32, MCK_GR32 }, },
  { 4184 /* lwpval */, X86::LWPVAL64rmi, Convert__Reg1_2__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32, MCK_GR64 }, },
  { 4197 /* lzcntl */, X86::LZCNT32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 4197 /* lzcntl */, X86::LZCNT32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 4204 /* lzcntq */, X86::LZCNT64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 4204 /* lzcntq */, X86::LZCNT64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 4211 /* lzcntw */, X86::LZCNT16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 4211 /* lzcntw */, X86::LZCNT16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 4218 /* maskmovdqu */, X86::MASKMOVDQU, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_FR32, MCK_FR32 }, },
  { 4218 /* maskmovdqu */, X86::MASKMOVDQU64, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_FR32, MCK_FR32 }, },
  { 4229 /* maskmovq */, X86::MMX_MASKMOVQ, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_VR64, MCK_VR64 }, },
  { 4229 /* maskmovq */, X86::MMX_MASKMOVQ64, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_VR64, MCK_VR64 }, },
  { 4238 /* maxpd */, X86::MAXPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4238 /* maxpd */, X86::MAXPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4244 /* maxps */, X86::MAXPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4244 /* maxps */, X86::MAXPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4250 /* maxsd */, X86::MAXSDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4250 /* maxsd */, X86::MAXSDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 4256 /* maxss */, X86::MAXSSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4256 /* maxss */, X86::MAXSSrm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 4262 /* mfence */, X86::MFENCE, Convert_NoOperands, 0, {  }, },
  { 4269 /* minpd */, X86::MINPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4269 /* minpd */, X86::MINPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4275 /* minps */, X86::MINPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4275 /* minps */, X86::MINPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4281 /* minsd */, X86::MINSDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4281 /* minsd */, X86::MINSDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 4287 /* minss */, X86::MINSSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4287 /* minss */, X86::MINSSrm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 4293 /* monitor */, X86::MONITORrrr, Convert_NoOperands, 0, {  }, },
  { 4293 /* monitor */, X86::MONITORrrr, Convert_NoOperands, Feature_Not64BitMode, { MCK_EAX, MCK_ECX, MCK_EDX }, },
  { 4293 /* monitor */, X86::MONITORrrr, Convert_NoOperands, Feature_In64BitMode, { MCK_RAX, MCK_RCX, MCK_RDX }, },
  { 4301 /* monitorx */, X86::MONITORXrrr, Convert_NoOperands, 0, {  }, },
  { 4301 /* monitorx */, X86::MONITORXrrr, Convert_NoOperands, Feature_Not64BitMode, { MCK_EAX, MCK_ECX, MCK_EDX }, },
  { 4301 /* monitorx */, X86::MONITORXrrr, Convert_NoOperands, Feature_In64BitMode, { MCK_RAX, MCK_RCX, MCK_RDX }, },
  { 4310 /* montmul */, X86::MONTMUL, Convert_NoOperands, 0, {  }, },
  { 4322 /* mov.s */, X86::MOV16rr_REV, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 4322 /* mov.s */, X86::MOV32rr_REV, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 4322 /* mov.s */, X86::MOV64rr_REV, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 4322 /* mov.s */, X86::MOV8rr_REV, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 4335 /* movabsb */, X86::MOV8o64a, Convert__MemOffs64_82_1, 0, { MCK_AL, MCK_MemOffs64_8 }, },
  { 4335 /* movabsb */, X86::MOV8ao64, Convert__MemOffs64_82_0, 0, { MCK_MemOffs64_8, MCK_AL }, },
  { 4343 /* movabsl */, X86::MOV32o64a, Convert__MemOffs64_322_1, 0, { MCK_EAX, MCK_MemOffs64_32 }, },
  { 4343 /* movabsl */, X86::MOV32ao64, Convert__MemOffs64_322_0, 0, { MCK_MemOffs64_32, MCK_EAX }, },
  { 4351 /* movabsq */, X86::MOV64o64a, Convert__MemOffs64_642_1, 0, { MCK_RAX, MCK_MemOffs64_64 }, },
  { 4351 /* movabsq */, X86::MOV64ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR64 }, },
  { 4351 /* movabsq */, X86::MOV64ao64, Convert__MemOffs64_642_0, 0, { MCK_MemOffs64_64, MCK_RAX }, },
  { 4359 /* movabsw */, X86::MOV16o64a, Convert__MemOffs64_162_1, 0, { MCK_AX, MCK_MemOffs64_16 }, },
  { 4359 /* movabsw */, X86::MOV16ao64, Convert__MemOffs64_162_0, 0, { MCK_MemOffs64_16, MCK_AX }, },
  { 4367 /* movapd */, X86::MOVAPDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4367 /* movapd */, X86::MOVAPDmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4367 /* movapd */, X86::MOVAPDrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4374 /* movapd.s */, X86::MOVAPDrr_REV, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4383 /* movaps */, X86::MOVAPSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4383 /* movaps */, X86::MOVAPSmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4383 /* movaps */, X86::MOVAPSrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4390 /* movaps.s */, X86::MOVAPSrr_REV, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4399 /* movb */, X86::MOV8o16a, Convert__MemOffs16_82_1, 0, { MCK_AL, MCK_MemOffs16_8 }, },
  { 4399 /* movb */, X86::MOV8o32a, Convert__MemOffs32_82_1, 0, { MCK_AL, MCK_MemOffs32_8 }, },
  { 4399 /* movb */, X86::MOV8rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 4399 /* movb */, X86::MOV8mr, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 4399 /* movb */, X86::MOV8ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 4399 /* movb */, X86::MOV8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 4399 /* movb */, X86::MOV8ao16, Convert__MemOffs16_82_0, 0, { MCK_MemOffs16_8, MCK_AL }, },
  { 4399 /* movb */, X86::MOV8ao32, Convert__MemOffs32_82_0, 0, { MCK_MemOffs32_8, MCK_AL }, },
  { 4399 /* movb */, X86::MOV8rm, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 4404 /* movb.s */, X86::MOV8rr_REV, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 4417 /* movbel */, X86::MOVBE32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 4417 /* movbel */, X86::MOVBE32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 4424 /* movbeq */, X86::MOVBE64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 4424 /* movbeq */, X86::MOVBE64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 4431 /* movbew */, X86::MOVBE16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 4431 /* movbew */, X86::MOVBE16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 4438 /* movd */, X86::MMX_MOVD64grr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_GR32 }, },
  { 4438 /* movd */, X86::MMX_MOVD64from64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_GR64 }, },
  { 4438 /* movd */, X86::MMX_MOVD64mr, Convert__Mem325_1__Reg1_0, 0, { MCK_VR64, MCK_Mem32 }, },
  { 4438 /* movd */, X86::MOVPDI2DIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 4438 /* movd */, X86::MOVPQIto64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 4438 /* movd */, X86::MOVPDI2DImr, Convert__Mem325_1__Reg1_0, 0, { MCK_FR32, MCK_Mem32 }, },
  { 4438 /* movd */, X86::MMX_MOVD64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_VR64 }, },
  { 4438 /* movd */, X86::MOVDI2PDIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_FR32 }, },
  { 4438 /* movd */, X86::MMX_MOVD64to64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_VR64 }, },
  { 4438 /* movd */, X86::MOV64toPQIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_FR32 }, },
  { 4438 /* movd */, X86::MMX_MOVD64rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_VR64 }, },
  { 4438 /* movd */, X86::MOVDI2PDIrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 4443 /* movddup */, X86::MOVDDUPrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4443 /* movddup */, X86::MOVDDUPrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 4451 /* movdir64b */, X86::MOVDIR64B16, Convert__Reg1_1__Mem5125_0, Feature_Not64BitMode, { MCK_Mem512, MCK_GR16 }, },
  { 4451 /* movdir64b */, X86::MOVDIR64B32, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_GR32 }, },
  { 4451 /* movdir64b */, X86::MOVDIR64B64, Convert__Reg1_1__Mem5125_0, Feature_In64BitMode, { MCK_Mem512, MCK_GR64 }, },
  { 4461 /* movdiri */, X86::MOVDIRI32, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 4461 /* movdiri */, X86::MOVDIRI64, Convert__Mem645_1__Reg1_0, Feature_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 4469 /* movdq2q */, X86::MMX_MOVDQ2Qrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR64 }, },
  { 4477 /* movdqa */, X86::MOVDQArr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4477 /* movdqa */, X86::MOVDQAmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4477 /* movdqa */, X86::MOVDQArm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4484 /* movdqa.s */, X86::MOVDQArr_REV, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4493 /* movdqu */, X86::MOVDQUrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4493 /* movdqu */, X86::MOVDQUmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4493 /* movdqu */, X86::MOVDQUrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4500 /* movdqu.s */, X86::MOVDQUrr_REV, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4509 /* movhlps */, X86::MOVHLPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4517 /* movhpd */, X86::MOVHPDmr, Convert__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64 }, },
  { 4517 /* movhpd */, X86::MOVHPDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 4524 /* movhps */, X86::MOVHPSmr, Convert__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64 }, },
  { 4524 /* movhps */, X86::MOVHPSrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 4531 /* movl */, X86::MOV32o16a, Convert__MemOffs16_322_1, 0, { MCK_EAX, MCK_MemOffs16_32 }, },
  { 4531 /* movl */, X86::MOV32o32a, Convert__MemOffs32_322_1, 0, { MCK_EAX, MCK_MemOffs32_32 }, },
  { 4531 /* movl */, X86::MOV32rs, Convert__Reg1_1__Reg1_0, 0, { MCK_SEGMENT_REG, MCK_GR32 }, },
  { 4531 /* movl */, X86::MOV32rc, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_CONTROL_REG, MCK_GR32 }, },
  { 4531 /* movl */, X86::MOV32rd, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_DEBUG_REG, MCK_GR32 }, },
  { 4531 /* movl */, X86::MOV32sr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_SEGMENT_REG }, },
  { 4531 /* movl */, X86::MOV32cr, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_GR32, MCK_CONTROL_REG }, },
  { 4531 /* movl */, X86::MOV32dr, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_GR32, MCK_DEBUG_REG }, },
  { 4531 /* movl */, X86::MOV32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 4531 /* movl */, X86::MOV32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 4531 /* movl */, X86::MOV32ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 4531 /* movl */, X86::MOV32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 4531 /* movl */, X86::MOV32ao16, Convert__MemOffs16_322_0, 0, { MCK_MemOffs16_32, MCK_EAX }, },
  { 4531 /* movl */, X86::MOV32ao32, Convert__MemOffs32_322_0, 0, { MCK_MemOffs32_32, MCK_EAX }, },
  { 4531 /* movl */, X86::MOV32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 4536 /* movl.s */, X86::MOV32rr_REV, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 4543 /* movlhps */, X86::MOVLHPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4551 /* movlpd */, X86::MOVLPDmr, Convert__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64 }, },
  { 4551 /* movlpd */, X86::MOVLPDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 4558 /* movlps */, X86::MOVLPSmr, Convert__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64 }, },
  { 4558 /* movlps */, X86::MOVLPSrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 4565 /* movmskpd */, X86::MOVMSKPDrr, Convert__GR32orGR641_1__Reg1_0, 0, { MCK_FR32, MCK_GR32orGR64 }, },
  { 4574 /* movmskps */, X86::MOVMSKPSrr, Convert__GR32orGR641_1__Reg1_0, 0, { MCK_FR32, MCK_GR32orGR64 }, },
  { 4583 /* movntdq */, X86::MOVNTDQmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4591 /* movntdqa */, X86::MOVNTDQArm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4607 /* movntil */, X86::MOVNTImr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 4615 /* movntiq */, X86::MOVNTI_64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 4623 /* movntpd */, X86::MOVNTPDmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4631 /* movntps */, X86::MOVNTPSmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4639 /* movntq */, X86::MMX_MOVNTQmr, Convert__Mem645_1__Reg1_0, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4646 /* movntsd */, X86::MOVNTSD, Convert__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64 }, },
  { 4654 /* movntss */, X86::MOVNTSS, Convert__Mem325_1__Reg1_0, 0, { MCK_FR32, MCK_Mem32 }, },
  { 4662 /* movq */, X86::MOV64o32a, Convert__MemOffs32_642_1, 0, { MCK_RAX, MCK_MemOffs32_64 }, },
  { 4662 /* movq */, X86::MOV64rs, Convert__Reg1_1__Reg1_0, 0, { MCK_SEGMENT_REG, MCK_GR64 }, },
  { 4662 /* movq */, X86::MMX_MOVQ64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4662 /* movq */, X86::MMX_MOVD64from64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_GR64 }, },
  { 4662 /* movq */, X86::MMX_MOVQ64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4662 /* movq */, X86::MOV64rc, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_CONTROL_REG, MCK_GR64 }, },
  { 4662 /* movq */, X86::MOV64rd, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_DEBUG_REG, MCK_GR64 }, },
  { 4662 /* movq */, X86::MOVZPQILo2PQIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4662 /* movq */, X86::MOVPQIto64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 4662 /* movq */, X86::MOVPQI2QImr, Convert__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64 }, },
  { 4662 /* movq */, X86::MOV64sr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_SEGMENT_REG }, },
  { 4662 /* movq */, X86::MMX_MOVD64to64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_VR64 }, },
  { 4662 /* movq */, X86::MOV64cr, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_GR64, MCK_CONTROL_REG }, },
  { 4662 /* movq */, X86::MOV64dr, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_GR64, MCK_DEBUG_REG }, },
  { 4662 /* movq */, X86::MOV64toPQIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_FR32 }, },
  { 4662 /* movq */, X86::MOV64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 4662 /* movq */, X86::MOV64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 4662 /* movq */, X86::MOV64ri32, Convert__Reg1_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 4662 /* movq */, X86::MOV64mi32, Convert__Mem645_1__ImmSExti64i321_0, Feature_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 4662 /* movq */, X86::MOV64ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR64 }, },
  { 4662 /* movq */, X86::MOV64ao32, Convert__MemOffs32_642_0, 0, { MCK_MemOffs32_64, MCK_RAX }, },
  { 4662 /* movq */, X86::MMX_MOVQ64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4662 /* movq */, X86::MOVQI2PQIrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 4662 /* movq */, X86::MOV64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 4667 /* movq.s */, X86::MMX_MOVQ64rr_REV, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4667 /* movq.s */, X86::MOVPQI2QIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4667 /* movq.s */, X86::MOV64rr_REV, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 4674 /* movq2dq */, X86::MMX_MOVQ2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_FR32 }, },
  { 4687 /* movsb */, X86::MOVSB, Convert__DstIdx81_1__SrcIdx82_0, 0, { MCK_SrcIdx8, MCK_DstIdx8 }, },
  { 4693 /* movsbl */, X86::MOVSX32rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR32 }, },
  { 4693 /* movsbl */, X86::MOVSX32rm8, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR32 }, },
  { 4700 /* movsbq */, X86::MOVSX64rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR64 }, },
  { 4700 /* movsbq */, X86::MOVSX64rm8, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR64 }, },
  { 4707 /* movsbw */, X86::MOVSX16rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR16 }, },
  { 4707 /* movsbw */, X86::MOVSX16rm8, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR16 }, },
  { 4714 /* movsd */, X86::MOVSDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4714 /* movsd */, X86::MOVSDmr, Convert__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64 }, },
  { 4714 /* movsd */, X86::MOVSDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 4720 /* movsd.s */, X86::MOVSDrr_REV, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4728 /* movshdup */, X86::MOVSHDUPrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4728 /* movshdup */, X86::MOVSHDUPrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4737 /* movsl */, X86::MOVSL, Convert__DstIdx321_1__SrcIdx322_0, 0, { MCK_SrcIdx32, MCK_DstIdx32 }, },
  { 4743 /* movsldup */, X86::MOVSLDUPrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4743 /* movsldup */, X86::MOVSLDUPrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4752 /* movslq */, X86::MOVSX64rr32, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_GR32, MCK_GR64 }, },
  { 4752 /* movslq */, X86::MOVSX64rm32, Convert__Reg1_1__Mem325_0, Feature_In64BitMode, { MCK_Mem32, MCK_GR64 }, },
  { 4759 /* movsq */, X86::MOVSQ, Convert__DstIdx641_1__SrcIdx642_0, Feature_In64BitMode, { MCK_SrcIdx64, MCK_DstIdx64 }, },
  { 4765 /* movss */, X86::MOVSSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4765 /* movss */, X86::MOVSSmr, Convert__Mem325_1__Reg1_0, 0, { MCK_FR32, MCK_Mem32 }, },
  { 4765 /* movss */, X86::MOVSSrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 4771 /* movss.s */, X86::MOVSSrr_REV, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4779 /* movsw */, X86::MOVSW, Convert__DstIdx161_1__SrcIdx162_0, 0, { MCK_SrcIdx16, MCK_DstIdx16 }, },
  { 4785 /* movswl */, X86::MOVSX32rr16, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR32 }, },
  { 4785 /* movswl */, X86::MOVSX32rm16, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR32 }, },
  { 4792 /* movswq */, X86::MOVSX64rr16, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR64 }, },
  { 4792 /* movswq */, X86::MOVSX64rm16, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR64 }, },
  { 4799 /* movsx */, X86::MOVSX32rr16, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR32 }, },
  { 4799 /* movsx */, X86::MOVSX64rr16, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR64 }, },
  { 4799 /* movsx */, X86::MOVSX64rr32, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR64 }, },
  { 4799 /* movsx */, X86::MOVSX16rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR16 }, },
  { 4799 /* movsx */, X86::MOVSX32rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR32 }, },
  { 4799 /* movsx */, X86::MOVSX64rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR64 }, },
  { 4799 /* movsx */, X86::MOVSX16rm8, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR16 }, },
  { 4812 /* movupd */, X86::MOVUPDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4812 /* movupd */, X86::MOVUPDmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4812 /* movupd */, X86::MOVUPDrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4819 /* movupd.s */, X86::MOVUPDrr_REV, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4828 /* movups */, X86::MOVUPSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4828 /* movups */, X86::MOVUPSmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4828 /* movups */, X86::MOVUPSrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4835 /* movups.s */, X86::MOVUPSrr_REV, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4844 /* movw */, X86::MOV16o16a, Convert__MemOffs16_162_1, 0, { MCK_AX, MCK_MemOffs16_16 }, },
  { 4844 /* movw */, X86::MOV16o32a, Convert__MemOffs32_162_1, 0, { MCK_AX, MCK_MemOffs32_16 }, },
  { 4844 /* movw */, X86::MOV16rs, Convert__Reg1_1__Reg1_0, 0, { MCK_SEGMENT_REG, MCK_GR16 }, },
  { 4844 /* movw */, X86::MOV16ms, Convert__Mem165_1__Reg1_0, 0, { MCK_SEGMENT_REG, MCK_Mem16 }, },
  { 4844 /* movw */, X86::MOV16sr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_SEGMENT_REG }, },
  { 4844 /* movw */, X86::MOV16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 4844 /* movw */, X86::MOV16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 4844 /* movw */, X86::MOV16ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 4844 /* movw */, X86::MOV16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 4844 /* movw */, X86::MOV16ao16, Convert__MemOffs16_162_0, 0, { MCK_MemOffs16_16, MCK_AX }, },
  { 4844 /* movw */, X86::MOV16ao32, Convert__MemOffs32_162_0, 0, { MCK_MemOffs32_16, MCK_AX }, },
  { 4844 /* movw */, X86::MOV16sm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_SEGMENT_REG }, },
  { 4844 /* movw */, X86::MOV16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 4849 /* movw.s */, X86::MOV16rr_REV, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 4856 /* movzbl */, X86::MOVZX32rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR32 }, },
  { 4856 /* movzbl */, X86::MOVZX32rm8, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR32 }, },
  { 4863 /* movzbq */, X86::MOVZX64rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR64 }, },
  { 4863 /* movzbq */, X86::MOVZX64rm8, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR64 }, },
  { 4870 /* movzbw */, X86::MOVZX16rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR16 }, },
  { 4870 /* movzbw */, X86::MOVZX16rm8, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR16 }, },
  { 4877 /* movzwl */, X86::MOVZX32rr16, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR32 }, },
  { 4877 /* movzwl */, X86::MOVZX32rm16, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR32 }, },
  { 4884 /* movzwq */, X86::MOVZX64rr16, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR64 }, },
  { 4884 /* movzwq */, X86::MOVZX64rm16, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR64 }, },
  { 4891 /* movzx */, X86::MOVZX32rr16, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR32 }, },
  { 4891 /* movzx */, X86::MOVZX64rr16, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR64 }, },
  { 4891 /* movzx */, X86::MOVZX16rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR16 }, },
  { 4891 /* movzx */, X86::MOVZX32rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR32 }, },
  { 4891 /* movzx */, X86::MOVZX64rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR64 }, },
  { 4891 /* movzx */, X86::MOVZX16rm8, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR16 }, },
  { 4897 /* mpsadbw */, X86::MPSADBWrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 4897 /* mpsadbw */, X86::MPSADBWrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 4909 /* mulb */, X86::MUL8r, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 4909 /* mulb */, X86::MUL8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 4914 /* mull */, X86::MUL32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 4914 /* mull */, X86::MUL32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 4919 /* mulpd */, X86::MULPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4919 /* mulpd */, X86::MULPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4925 /* mulps */, X86::MULPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4925 /* mulps */, X86::MULPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4931 /* mulq */, X86::MUL64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 4931 /* mulq */, X86::MUL64m, Convert__Mem645_0, Feature_In64BitMode, { MCK_Mem64 }, },
  { 4936 /* mulsd */, X86::MULSDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4936 /* mulsd */, X86::MULSDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 4942 /* mulss */, X86::MULSSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4942 /* mulss */, X86::MULSSrm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 4948 /* mulw */, X86::MUL16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 4948 /* mulw */, X86::MUL16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 4958 /* mulxl */, X86::MULX32rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 4958 /* mulxl */, X86::MULX32rm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 4964 /* mulxq */, X86::MULX64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 4964 /* mulxq */, X86::MULX64rm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 4970 /* mwait */, X86::MWAITrr, Convert_NoOperands, 0, {  }, },
  { 4970 /* mwait */, X86::MWAITrr, Convert_NoOperands, Feature_Not64BitMode, { MCK_EAX, MCK_ECX }, },
  { 4970 /* mwait */, X86::MWAITrr, Convert_NoOperands, Feature_In64BitMode, { MCK_RAX, MCK_RCX }, },
  { 4976 /* mwaitx */, X86::MWAITXrrr, Convert_NoOperands, 0, {  }, },
  { 4976 /* mwaitx */, X86::MWAITXrrr, Convert_NoOperands, Feature_Not64BitMode, { MCK_EAX, MCK_ECX, MCK_EBX }, },
  { 4976 /* mwaitx */, X86::MWAITXrrr, Convert_NoOperands, Feature_In64BitMode, { MCK_RAX, MCK_RCX, MCK_RBX }, },
  { 4987 /* negb */, X86::NEG8r, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR8 }, },
  { 4987 /* negb */, X86::NEG8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 4992 /* negl */, X86::NEG32r, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR32 }, },
  { 4992 /* negl */, X86::NEG32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 4997 /* negq */, X86::NEG64r, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR64 }, },
  { 4997 /* negq */, X86::NEG64m, Convert__Mem645_0, Feature_In64BitMode, { MCK_Mem64 }, },
  { 5002 /* negw */, X86::NEG16r, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR16 }, },
  { 5002 /* negw */, X86::NEG16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 5007 /* nop */, X86::NOOP, Convert_NoOperands, 0, {  }, },
  { 5011 /* nopl */, X86::NOOPLr, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 5011 /* nopl */, X86::NOOPL, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 5016 /* nopq */, X86::NOOPQr, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 5016 /* nopq */, X86::NOOPQ, Convert__Mem645_0, Feature_In64BitMode, { MCK_Mem64 }, },
  { 5021 /* nopw */, X86::NOOPWr, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 5021 /* nopw */, X86::NOOPW, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 5030 /* notb */, X86::NOT8r, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR8 }, },
  { 5030 /* notb */, X86::NOT8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 5035 /* notl */, X86::NOT32r, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR32 }, },
  { 5035 /* notl */, X86::NOT32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 5040 /* notq */, X86::NOT64r, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR64 }, },
  { 5040 /* notq */, X86::NOT64m, Convert__Mem645_0, Feature_In64BitMode, { MCK_Mem64 }, },
  { 5045 /* notw */, X86::NOT16r, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR16 }, },
  { 5045 /* notw */, X86::NOT16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 5053 /* orb */, X86::OR8rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 5053 /* orb */, X86::OR8mr, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 5053 /* orb */, X86::OR8i8, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 5053 /* orb */, X86::OR8ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 5053 /* orb */, X86::OR8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 5053 /* orb */, X86::OR8rm, Convert__Reg1_1__Tie0_2_2__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 5057 /* orl */, X86::OR32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 5057 /* orl */, X86::OR32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 5057 /* orl */, X86::OR32ri8, Convert__regEAX__Tie0_1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_EAX }, },
  { 5057 /* orl */, X86::OR32ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 5057 /* orl */, X86::OR32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 5057 /* orl */, X86::OR32i32, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 5057 /* orl */, X86::OR32ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 5057 /* orl */, X86::OR32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 5057 /* orl */, X86::OR32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 5061 /* orpd */, X86::ORPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5061 /* orpd */, X86::ORPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5066 /* orps */, X86::ORPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5066 /* orps */, X86::ORPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5071 /* orq */, X86::OR64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 5071 /* orq */, X86::OR64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 5071 /* orq */, X86::OR64ri8, Convert__regRAX__Tie0_1_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_RAX }, },
  { 5071 /* orq */, X86::OR64ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 5071 /* orq */, X86::OR64mi8, Convert__Mem645_1__ImmSExti64i81_0, Feature_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 5071 /* orq */, X86::OR64i32, Convert__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 5071 /* orq */, X86::OR64ri32, Convert__Reg1_1__Tie0_2_2__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 5071 /* orq */, X86::OR64mi32, Convert__Mem645_1__ImmSExti64i321_0, Feature_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 5071 /* orq */, X86::OR64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 5075 /* orw */, X86::OR16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 5075 /* orw */, X86::OR16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 5075 /* orw */, X86::OR16ri8, Convert__regAX__Tie0_1_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_AX }, },
  { 5075 /* orw */, X86::OR16ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 5075 /* orw */, X86::OR16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 5075 /* orw */, X86::OR16i16, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 5075 /* orw */, X86::OR16ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 5075 /* orw */, X86::OR16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 5075 /* orw */, X86::OR16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 5083 /* outb */, X86::OUT8rr, Convert_NoOperands, 0, { MCK_DX }, },
  { 5083 /* outb */, X86::OUT8ir, Convert__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8 }, },
  { 5083 /* outb */, X86::OUT8rr, Convert_NoOperands, 0, { MCK_AL, MCK_DX }, },
  { 5083 /* outb */, X86::OUT8ir, Convert__ImmUnsignedi81_1, 0, { MCK_AL, MCK_ImmUnsignedi8 }, },
  { 5088 /* outl */, X86::OUT32rr, Convert_NoOperands, 0, { MCK_DX }, },
  { 5088 /* outl */, X86::OUT32ir, Convert__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8 }, },
  { 5088 /* outl */, X86::OUT32rr, Convert_NoOperands, 0, { MCK_EAX, MCK_DX }, },
  { 5088 /* outl */, X86::OUT32ir, Convert__ImmUnsignedi81_1, 0, { MCK_EAX, MCK_ImmUnsignedi8 }, },
  { 5098 /* outsb */, X86::OUTSB, Convert__SrcIdx82_0, 0, { MCK_SrcIdx8, MCK_DX }, },
  { 5110 /* outsl */, X86::OUTSL, Convert__SrcIdx322_0, 0, { MCK_SrcIdx32, MCK_DX }, },
  { 5116 /* outsw */, X86::OUTSW, Convert__SrcIdx162_0, 0, { MCK_SrcIdx16, MCK_DX }, },
  { 5122 /* outw */, X86::OUT16rr, Convert_NoOperands, 0, { MCK_DX }, },
  { 5122 /* outw */, X86::OUT16ir, Convert__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8 }, },
  { 5122 /* outw */, X86::OUT16rr, Convert_NoOperands, 0, { MCK_AX, MCK_DX }, },
  { 5122 /* outw */, X86::OUT16ir, Convert__ImmUnsignedi81_1, 0, { MCK_AX, MCK_ImmUnsignedi8 }, },
  { 5127 /* pabsb */, X86::MMX_PABSBrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5127 /* pabsb */, X86::PABSBrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5127 /* pabsb */, X86::PABSBrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5127 /* pabsb */, X86::MMX_PABSBrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5133 /* pabsd */, X86::MMX_PABSDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5133 /* pabsd */, X86::PABSDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5133 /* pabsd */, X86::PABSDrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5133 /* pabsd */, X86::MMX_PABSDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5139 /* pabsw */, X86::MMX_PABSWrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5139 /* pabsw */, X86::PABSWrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5139 /* pabsw */, X86::PABSWrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5139 /* pabsw */, X86::MMX_PABSWrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5145 /* packssdw */, X86::MMX_PACKSSDWirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5145 /* packssdw */, X86::PACKSSDWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5145 /* packssdw */, X86::PACKSSDWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5145 /* packssdw */, X86::MMX_PACKSSDWirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5154 /* packsswb */, X86::MMX_PACKSSWBirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5154 /* packsswb */, X86::PACKSSWBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5154 /* packsswb */, X86::PACKSSWBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5154 /* packsswb */, X86::MMX_PACKSSWBirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5163 /* packusdw */, X86::PACKUSDWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5163 /* packusdw */, X86::PACKUSDWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5172 /* packuswb */, X86::MMX_PACKUSWBirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5172 /* packuswb */, X86::PACKUSWBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5172 /* packuswb */, X86::PACKUSWBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5172 /* packuswb */, X86::MMX_PACKUSWBirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5181 /* paddb */, X86::MMX_PADDBirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5181 /* paddb */, X86::PADDBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5181 /* paddb */, X86::PADDBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5181 /* paddb */, X86::MMX_PADDBirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5187 /* paddd */, X86::MMX_PADDDirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5187 /* paddd */, X86::PADDDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5187 /* paddd */, X86::PADDDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5187 /* paddd */, X86::MMX_PADDDirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5193 /* paddq */, X86::MMX_PADDQirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5193 /* paddq */, X86::PADDQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5193 /* paddq */, X86::PADDQrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5193 /* paddq */, X86::MMX_PADDQirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5199 /* paddsb */, X86::MMX_PADDSBirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5199 /* paddsb */, X86::PADDSBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5199 /* paddsb */, X86::PADDSBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5199 /* paddsb */, X86::MMX_PADDSBirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5206 /* paddsw */, X86::MMX_PADDSWirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5206 /* paddsw */, X86::PADDSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5206 /* paddsw */, X86::PADDSWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5206 /* paddsw */, X86::MMX_PADDSWirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5213 /* paddusb */, X86::MMX_PADDUSBirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5213 /* paddusb */, X86::PADDUSBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5213 /* paddusb */, X86::PADDUSBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5213 /* paddusb */, X86::MMX_PADDUSBirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5221 /* paddusw */, X86::MMX_PADDUSWirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5221 /* paddusw */, X86::PADDUSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5221 /* paddusw */, X86::PADDUSWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5221 /* paddusw */, X86::MMX_PADDUSWirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5229 /* paddw */, X86::MMX_PADDWirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5229 /* paddw */, X86::PADDWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5229 /* paddw */, X86::PADDWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5229 /* paddw */, X86::MMX_PADDWirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5235 /* palignr */, X86::MMX_PALIGNRrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR64, MCK_VR64 }, },
  { 5235 /* palignr */, X86::PALIGNRrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 5235 /* palignr */, X86::PALIGNRrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 5235 /* palignr */, X86::MMX_PALIGNRrmi, Convert__Reg1_2__Tie0_1_1__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_VR64 }, },
  { 5243 /* pand */, X86::MMX_PANDirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5243 /* pand */, X86::PANDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5243 /* pand */, X86::PANDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5243 /* pand */, X86::MMX_PANDirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5248 /* pandn */, X86::MMX_PANDNirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5248 /* pandn */, X86::PANDNrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5248 /* pandn */, X86::PANDNrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5248 /* pandn */, X86::MMX_PANDNirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5254 /* pause */, X86::PAUSE, Convert_NoOperands, 0, {  }, },
  { 5260 /* pavgb */, X86::MMX_PAVGBirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5260 /* pavgb */, X86::PAVGBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5260 /* pavgb */, X86::PAVGBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5260 /* pavgb */, X86::MMX_PAVGBirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5266 /* pavgusb */, X86::PAVGUSBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5266 /* pavgusb */, X86::PAVGUSBrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5274 /* pavgw */, X86::MMX_PAVGWirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5274 /* pavgw */, X86::PAVGWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5274 /* pavgw */, X86::PAVGWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5274 /* pavgw */, X86::MMX_PAVGWirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5280 /* pblendvb */, X86::PBLENDVBrr0, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5280 /* pblendvb */, X86::PBLENDVBrm0, Convert__Reg1_1__Tie0_2_2__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5280 /* pblendvb */, X86::PBLENDVBrr0, Convert__Reg1_2__Tie0_1_1__Reg1_1, 0, { MCK_XMM0, MCK_FR32, MCK_FR32 }, },
  { 5280 /* pblendvb */, X86::PBLENDVBrm0, Convert__Reg1_2__Tie0_1_1__Mem1285_1, 0, { MCK_XMM0, MCK_Mem128, MCK_FR32 }, },
  { 5289 /* pblendw */, X86::PBLENDWrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 5289 /* pblendw */, X86::PBLENDWrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 5297 /* pclmulhqhqdq */, X86::PCLMULQDQrr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_17, 0, { MCK_FR32, MCK_FR32 }, },
  { 5297 /* pclmulhqhqdq */, X86::PCLMULQDQrm, Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_17, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5310 /* pclmulhqlqdq */, X86::PCLMULQDQrr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5310 /* pclmulhqlqdq */, X86::PCLMULQDQrm, Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_1, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5323 /* pclmullqhqdq */, X86::PCLMULQDQrr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_16, 0, { MCK_FR32, MCK_FR32 }, },
  { 5323 /* pclmullqhqdq */, X86::PCLMULQDQrm, Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_16, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5336 /* pclmullqlqdq */, X86::PCLMULQDQrr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5336 /* pclmullqlqdq */, X86::PCLMULQDQrm, Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5349 /* pclmulqdq */, X86::PCLMULQDQrr, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 5349 /* pclmulqdq */, X86::PCLMULQDQrm, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 5359 /* pcmpeqb */, X86::MMX_PCMPEQBirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5359 /* pcmpeqb */, X86::PCMPEQBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5359 /* pcmpeqb */, X86::PCMPEQBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5359 /* pcmpeqb */, X86::MMX_PCMPEQBirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5367 /* pcmpeqd */, X86::MMX_PCMPEQDirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5367 /* pcmpeqd */, X86::PCMPEQDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5367 /* pcmpeqd */, X86::PCMPEQDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5367 /* pcmpeqd */, X86::MMX_PCMPEQDirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5375 /* pcmpeqq */, X86::PCMPEQQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5375 /* pcmpeqq */, X86::PCMPEQQrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5383 /* pcmpeqw */, X86::MMX_PCMPEQWirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5383 /* pcmpeqw */, X86::PCMPEQWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5383 /* pcmpeqw */, X86::PCMPEQWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5383 /* pcmpeqw */, X86::MMX_PCMPEQWirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5391 /* pcmpestri */, X86::PCMPESTRIrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 5391 /* pcmpestri */, X86::PCMPESTRIrm, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 5401 /* pcmpestrm */, X86::PCMPESTRMrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 5401 /* pcmpestrm */, X86::PCMPESTRMrm, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 5411 /* pcmpgtb */, X86::MMX_PCMPGTBirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5411 /* pcmpgtb */, X86::PCMPGTBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5411 /* pcmpgtb */, X86::PCMPGTBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5411 /* pcmpgtb */, X86::MMX_PCMPGTBirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5419 /* pcmpgtd */, X86::MMX_PCMPGTDirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5419 /* pcmpgtd */, X86::PCMPGTDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5419 /* pcmpgtd */, X86::PCMPGTDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5419 /* pcmpgtd */, X86::MMX_PCMPGTDirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5427 /* pcmpgtq */, X86::PCMPGTQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5427 /* pcmpgtq */, X86::PCMPGTQrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5435 /* pcmpgtw */, X86::MMX_PCMPGTWirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5435 /* pcmpgtw */, X86::PCMPGTWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5435 /* pcmpgtw */, X86::PCMPGTWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5435 /* pcmpgtw */, X86::MMX_PCMPGTWirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5443 /* pcmpistri */, X86::PCMPISTRIrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 5443 /* pcmpistri */, X86::PCMPISTRIrm, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 5453 /* pcmpistrm */, X86::PCMPISTRMrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 5453 /* pcmpistrm */, X86::PCMPISTRMrm, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 5463 /* pconfig */, X86::PCONFIG, Convert_NoOperands, 0, {  }, },
  { 5476 /* pdepl */, X86::PDEP32rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 5476 /* pdepl */, X86::PDEP32rm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 5482 /* pdepq */, X86::PDEP64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 5482 /* pdepq */, X86::PDEP64rm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 5493 /* pextl */, X86::PEXT32rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 5493 /* pextl */, X86::PEXT32rm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 5499 /* pextq */, X86::PEXT64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 5499 /* pextq */, X86::PEXT64rm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 5505 /* pextrb */, X86::PEXTRBrr, Convert__GR32orGR641_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_GR32orGR64 }, },
  { 5505 /* pextrb */, X86::PEXTRBmr, Convert__Mem85_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_Mem8 }, },
  { 5512 /* pextrd */, X86::PEXTRDrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_GR32 }, },
  { 5512 /* pextrd */, X86::PEXTRDmr, Convert__Mem325_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_Mem32 }, },
  { 5519 /* pextrq */, X86::PEXTRQrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_GR64 }, },
  { 5519 /* pextrq */, X86::PEXTRQmr, Convert__Mem645_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_Mem64 }, },
  { 5526 /* pextrw */, X86::MMX_PEXTRWrr, Convert__GR32orGR641_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR64, MCK_GR32orGR64 }, },
  { 5526 /* pextrw */, X86::PEXTRWrr, Convert__GR32orGR641_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_GR32orGR64 }, },
  { 5526 /* pextrw */, X86::PEXTRWmr, Convert__Mem165_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_Mem16 }, },
  { 5533 /* pf2id */, X86::PF2IDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5533 /* pf2id */, X86::PF2IDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5539 /* pf2iw */, X86::PF2IWrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5539 /* pf2iw */, X86::PF2IWrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5545 /* pfacc */, X86::PFACCrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5545 /* pfacc */, X86::PFACCrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5551 /* pfadd */, X86::PFADDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5551 /* pfadd */, X86::PFADDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5557 /* pfcmpeq */, X86::PFCMPEQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5557 /* pfcmpeq */, X86::PFCMPEQrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5565 /* pfcmpge */, X86::PFCMPGErr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5565 /* pfcmpge */, X86::PFCMPGErm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5573 /* pfcmpgt */, X86::PFCMPGTrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5573 /* pfcmpgt */, X86::PFCMPGTrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5581 /* pfmax */, X86::PFMAXrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5581 /* pfmax */, X86::PFMAXrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5587 /* pfmin */, X86::PFMINrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5587 /* pfmin */, X86::PFMINrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5593 /* pfmul */, X86::PFMULrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5593 /* pfmul */, X86::PFMULrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5599 /* pfnacc */, X86::PFNACCrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5599 /* pfnacc */, X86::PFNACCrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5606 /* pfpnacc */, X86::PFPNACCrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5606 /* pfpnacc */, X86::PFPNACCrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5614 /* pfrcp */, X86::PFRCPrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5614 /* pfrcp */, X86::PFRCPrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5620 /* pfrcpit1 */, X86::PFRCPIT1rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5620 /* pfrcpit1 */, X86::PFRCPIT1rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5629 /* pfrcpit2 */, X86::PFRCPIT2rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5629 /* pfrcpit2 */, X86::PFRCPIT2rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5638 /* pfrsqit1 */, X86::PFRSQIT1rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5638 /* pfrsqit1 */, X86::PFRSQIT1rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5647 /* pfrsqrt */, X86::PFRSQRTrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5647 /* pfrsqrt */, X86::PFRSQRTrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5655 /* pfsub */, X86::PFSUBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5655 /* pfsub */, X86::PFSUBrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5661 /* pfsubr */, X86::PFSUBRrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5661 /* pfsubr */, X86::PFSUBRrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5668 /* phaddd */, X86::MMX_PHADDDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5668 /* phaddd */, X86::PHADDDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5668 /* phaddd */, X86::PHADDDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5668 /* phaddd */, X86::MMX_PHADDDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5675 /* phaddsw */, X86::MMX_PHADDSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5675 /* phaddsw */, X86::PHADDSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5675 /* phaddsw */, X86::PHADDSWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5675 /* phaddsw */, X86::MMX_PHADDSWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5683 /* phaddw */, X86::MMX_PHADDWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5683 /* phaddw */, X86::PHADDWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5683 /* phaddw */, X86::PHADDWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5683 /* phaddw */, X86::MMX_PHADDWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5690 /* phminposuw */, X86::PHMINPOSUWrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5690 /* phminposuw */, X86::PHMINPOSUWrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5701 /* phsubd */, X86::MMX_PHSUBDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5701 /* phsubd */, X86::PHSUBDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5701 /* phsubd */, X86::PHSUBDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5701 /* phsubd */, X86::MMX_PHSUBDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5708 /* phsubsw */, X86::MMX_PHSUBSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5708 /* phsubsw */, X86::PHSUBSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5708 /* phsubsw */, X86::PHSUBSWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5708 /* phsubsw */, X86::MMX_PHSUBSWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5716 /* phsubw */, X86::MMX_PHSUBWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5716 /* phsubw */, X86::PHSUBWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5716 /* phsubw */, X86::PHSUBWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5716 /* phsubw */, X86::MMX_PHSUBWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5723 /* pi2fd */, X86::PI2FDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5723 /* pi2fd */, X86::PI2FDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5729 /* pi2fw */, X86::PI2FWrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5729 /* pi2fw */, X86::PI2FWrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5735 /* pinsrb */, X86::PINSRBrr, Convert__Reg1_2__Tie0_1_1__GR32orGR641_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR32orGR64, MCK_FR32 }, },
  { 5735 /* pinsrb */, X86::PINSRBrm, Convert__Reg1_2__Tie0_1_1__Mem85_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem8, MCK_FR32 }, },
  { 5742 /* pinsrd */, X86::PINSRDrr, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR32, MCK_FR32 }, },
  { 5742 /* pinsrd */, X86::PINSRDrm, Convert__Reg1_2__Tie0_1_1__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_FR32 }, },
  { 5749 /* pinsrq */, X86::PINSRQrr, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR64, MCK_FR32 }, },
  { 5749 /* pinsrq */, X86::PINSRQrm, Convert__Reg1_2__Tie0_1_1__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_FR32 }, },
  { 5756 /* pinsrw */, X86::MMX_PINSRWrr, Convert__Reg1_2__Tie0_1_1__GR32orGR641_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR32orGR64, MCK_VR64 }, },
  { 5756 /* pinsrw */, X86::PINSRWrr, Convert__Reg1_2__Tie0_1_1__GR32orGR641_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR32orGR64, MCK_FR32 }, },
  { 5756 /* pinsrw */, X86::MMX_PINSRWrm, Convert__Reg1_2__Tie0_1_1__Mem165_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem16, MCK_VR64 }, },
  { 5756 /* pinsrw */, X86::PINSRWrm, Convert__Reg1_2__Tie0_1_1__Mem165_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem16, MCK_FR32 }, },
  { 5763 /* pmaddubsw */, X86::MMX_PMADDUBSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5763 /* pmaddubsw */, X86::PMADDUBSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5763 /* pmaddubsw */, X86::PMADDUBSWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5763 /* pmaddubsw */, X86::MMX_PMADDUBSWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5773 /* pmaddwd */, X86::MMX_PMADDWDirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5773 /* pmaddwd */, X86::PMADDWDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5773 /* pmaddwd */, X86::PMADDWDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5773 /* pmaddwd */, X86::MMX_PMADDWDirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5781 /* pmaxsb */, X86::PMAXSBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5781 /* pmaxsb */, X86::PMAXSBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5788 /* pmaxsd */, X86::PMAXSDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5788 /* pmaxsd */, X86::PMAXSDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5795 /* pmaxsw */, X86::MMX_PMAXSWirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5795 /* pmaxsw */, X86::PMAXSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5795 /* pmaxsw */, X86::PMAXSWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5795 /* pmaxsw */, X86::MMX_PMAXSWirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5802 /* pmaxub */, X86::MMX_PMAXUBirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5802 /* pmaxub */, X86::PMAXUBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5802 /* pmaxub */, X86::PMAXUBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5802 /* pmaxub */, X86::MMX_PMAXUBirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5809 /* pmaxud */, X86::PMAXUDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5809 /* pmaxud */, X86::PMAXUDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5816 /* pmaxuw */, X86::PMAXUWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5816 /* pmaxuw */, X86::PMAXUWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5823 /* pminsb */, X86::PMINSBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5823 /* pminsb */, X86::PMINSBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5830 /* pminsd */, X86::PMINSDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5830 /* pminsd */, X86::PMINSDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5837 /* pminsw */, X86::MMX_PMINSWirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5837 /* pminsw */, X86::PMINSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5837 /* pminsw */, X86::PMINSWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5837 /* pminsw */, X86::MMX_PMINSWirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5844 /* pminub */, X86::MMX_PMINUBirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5844 /* pminub */, X86::PMINUBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5844 /* pminub */, X86::PMINUBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5844 /* pminub */, X86::MMX_PMINUBirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5851 /* pminud */, X86::PMINUDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5851 /* pminud */, X86::PMINUDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5858 /* pminuw */, X86::PMINUWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5858 /* pminuw */, X86::PMINUWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5865 /* pmovmskb */, X86::MMX_PMOVMSKBrr, Convert__GR32orGR641_1__Reg1_0, 0, { MCK_VR64, MCK_GR32orGR64 }, },
  { 5865 /* pmovmskb */, X86::PMOVMSKBrr, Convert__GR32orGR641_1__Reg1_0, 0, { MCK_FR32, MCK_GR32orGR64 }, },
  { 5874 /* pmovsxbd */, X86::PMOVSXBDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5874 /* pmovsxbd */, X86::PMOVSXBDrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 5883 /* pmovsxbq */, X86::PMOVSXBQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5883 /* pmovsxbq */, X86::PMOVSXBQrm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_FR32 }, },
  { 5892 /* pmovsxbw */, X86::PMOVSXBWrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5892 /* pmovsxbw */, X86::PMOVSXBWrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 5901 /* pmovsxdq */, X86::PMOVSXDQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5901 /* pmovsxdq */, X86::PMOVSXDQrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 5910 /* pmovsxwd */, X86::PMOVSXWDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5910 /* pmovsxwd */, X86::PMOVSXWDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 5919 /* pmovsxwq */, X86::PMOVSXWQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5919 /* pmovsxwq */, X86::PMOVSXWQrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 5928 /* pmovzxbd */, X86::PMOVZXBDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5928 /* pmovzxbd */, X86::PMOVZXBDrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 5937 /* pmovzxbq */, X86::PMOVZXBQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5937 /* pmovzxbq */, X86::PMOVZXBQrm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_FR32 }, },
  { 5946 /* pmovzxbw */, X86::PMOVZXBWrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5946 /* pmovzxbw */, X86::PMOVZXBWrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 5955 /* pmovzxdq */, X86::PMOVZXDQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5955 /* pmovzxdq */, X86::PMOVZXDQrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 5964 /* pmovzxwd */, X86::PMOVZXWDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5964 /* pmovzxwd */, X86::PMOVZXWDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 5973 /* pmovzxwq */, X86::PMOVZXWQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5973 /* pmovzxwq */, X86::PMOVZXWQrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 5982 /* pmuldq */, X86::PMULDQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5982 /* pmuldq */, X86::PMULDQrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5989 /* pmulhrsw */, X86::MMX_PMULHRSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5989 /* pmulhrsw */, X86::PMULHRSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5989 /* pmulhrsw */, X86::PMULHRSWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5989 /* pmulhrsw */, X86::MMX_PMULHRSWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5998 /* pmulhrw */, X86::PMULHRWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5998 /* pmulhrw */, X86::PMULHRWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6006 /* pmulhuw */, X86::MMX_PMULHUWirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6006 /* pmulhuw */, X86::PMULHUWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6006 /* pmulhuw */, X86::PMULHUWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6006 /* pmulhuw */, X86::MMX_PMULHUWirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6014 /* pmulhw */, X86::MMX_PMULHWirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6014 /* pmulhw */, X86::PMULHWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6014 /* pmulhw */, X86::PMULHWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6014 /* pmulhw */, X86::MMX_PMULHWirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6021 /* pmulld */, X86::PMULLDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6021 /* pmulld */, X86::PMULLDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6028 /* pmullw */, X86::MMX_PMULLWirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6028 /* pmullw */, X86::PMULLWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6028 /* pmullw */, X86::PMULLWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6028 /* pmullw */, X86::MMX_PMULLWirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6035 /* pmuludq */, X86::MMX_PMULUDQirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6035 /* pmuludq */, X86::PMULUDQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6035 /* pmuludq */, X86::PMULUDQrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6035 /* pmuludq */, X86::MMX_PMULUDQirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6047 /* popal */, X86::POPA32, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 6053 /* popaw */, X86::POPA16, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 6066 /* popcntl */, X86::POPCNT32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 6066 /* popcntl */, X86::POPCNT32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 6074 /* popcntq */, X86::POPCNT64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 6074 /* popcntq */, X86::POPCNT64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 6082 /* popcntw */, X86::POPCNT16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 6082 /* popcntw */, X86::POPCNT16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 6101 /* popfl */, X86::POPF32, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 6107 /* popfq */, X86::POPF64, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 6113 /* popfw */, X86::POPF16, Convert_NoOperands, 0, {  }, },
  { 6119 /* popl */, X86::POPDS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_DS }, },
  { 6119 /* popl */, X86::POPES32, Convert_NoOperands, Feature_Not64BitMode, { MCK_ES }, },
  { 6119 /* popl */, X86::POPFS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_FS }, },
  { 6119 /* popl */, X86::POPGS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_GS }, },
  { 6119 /* popl */, X86::POPSS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_SS }, },
  { 6119 /* popl */, X86::POP32r, Convert__Reg1_0, Feature_Not64BitMode, { MCK_GR32 }, },
  { 6119 /* popl */, X86::POP32rmm, Convert__Mem325_0, Feature_Not64BitMode, { MCK_Mem32 }, },
  { 6124 /* popq */, X86::POPFS64, Convert_NoOperands, Feature_In64BitMode, { MCK_FS }, },
  { 6124 /* popq */, X86::POPGS64, Convert_NoOperands, Feature_In64BitMode, { MCK_GS }, },
  { 6124 /* popq */, X86::POP64r, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 6124 /* popq */, X86::POP64rmm, Convert__Mem645_0, Feature_In64BitMode, { MCK_Mem64 }, },
  { 6129 /* popw */, X86::POPDS16, Convert_NoOperands, Feature_Not64BitMode, { MCK_DS }, },
  { 6129 /* popw */, X86::POPES16, Convert_NoOperands, Feature_Not64BitMode, { MCK_ES }, },
  { 6129 /* popw */, X86::POPFS16, Convert_NoOperands, 0, { MCK_FS }, },
  { 6129 /* popw */, X86::POPGS16, Convert_NoOperands, 0, { MCK_GS }, },
  { 6129 /* popw */, X86::POPSS16, Convert_NoOperands, Feature_Not64BitMode, { MCK_SS }, },
  { 6129 /* popw */, X86::POP16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 6129 /* popw */, X86::POP16rmm, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6134 /* por */, X86::MMX_PORirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6134 /* por */, X86::PORrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6134 /* por */, X86::PORrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6134 /* por */, X86::MMX_PORirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6138 /* prefetch */, X86::PREFETCH, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6147 /* prefetchnta */, X86::PREFETCHNTA, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6159 /* prefetcht0 */, X86::PREFETCHT0, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6170 /* prefetcht1 */, X86::PREFETCHT1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6181 /* prefetcht2 */, X86::PREFETCHT2, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6192 /* prefetchw */, X86::PREFETCHW, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6202 /* prefetchwt1 */, X86::PREFETCHWT1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6214 /* psadbw */, X86::MMX_PSADBWirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6214 /* psadbw */, X86::PSADBWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6214 /* psadbw */, X86::PSADBWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6214 /* psadbw */, X86::MMX_PSADBWirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6221 /* pshufb */, X86::MMX_PSHUFBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6221 /* pshufb */, X86::PSHUFBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6221 /* pshufb */, X86::PSHUFBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6221 /* pshufb */, X86::MMX_PSHUFBrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6228 /* pshufd */, X86::PSHUFDri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 6228 /* pshufd */, X86::PSHUFDmi, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 6235 /* pshufhw */, X86::PSHUFHWri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 6235 /* pshufhw */, X86::PSHUFHWmi, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 6243 /* pshuflw */, X86::PSHUFLWri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 6243 /* pshuflw */, X86::PSHUFLWmi, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 6251 /* pshufw */, X86::MMX_PSHUFWri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR64, MCK_VR64 }, },
  { 6251 /* pshufw */, X86::MMX_PSHUFWmi, Convert__Reg1_2__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_VR64 }, },
  { 6258 /* psignb */, X86::MMX_PSIGNBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6258 /* psignb */, X86::PSIGNBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6258 /* psignb */, X86::PSIGNBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6258 /* psignb */, X86::MMX_PSIGNBrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6265 /* psignd */, X86::MMX_PSIGNDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6265 /* psignd */, X86::PSIGNDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6265 /* psignd */, X86::PSIGNDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6265 /* psignd */, X86::MMX_PSIGNDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6272 /* psignw */, X86::MMX_PSIGNWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6272 /* psignw */, X86::PSIGNWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6272 /* psignw */, X86::PSIGNWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6272 /* psignw */, X86::MMX_PSIGNWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6279 /* pslld */, X86::MMX_PSLLDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6279 /* pslld */, X86::PSLLDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6279 /* pslld */, X86::MMX_PSLLDri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR64 }, },
  { 6279 /* pslld */, X86::PSLLDri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32 }, },
  { 6279 /* pslld */, X86::PSLLDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6279 /* pslld */, X86::MMX_PSLLDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6285 /* pslldq */, X86::PSLLDQri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32 }, },
  { 6292 /* psllq */, X86::MMX_PSLLQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6292 /* psllq */, X86::PSLLQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6292 /* psllq */, X86::MMX_PSLLQri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR64 }, },
  { 6292 /* psllq */, X86::PSLLQri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32 }, },
  { 6292 /* psllq */, X86::PSLLQrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6292 /* psllq */, X86::MMX_PSLLQrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6298 /* psllw */, X86::MMX_PSLLWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6298 /* psllw */, X86::PSLLWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6298 /* psllw */, X86::MMX_PSLLWri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR64 }, },
  { 6298 /* psllw */, X86::PSLLWri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32 }, },
  { 6298 /* psllw */, X86::PSLLWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6298 /* psllw */, X86::MMX_PSLLWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6304 /* psrad */, X86::MMX_PSRADrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6304 /* psrad */, X86::PSRADrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6304 /* psrad */, X86::MMX_PSRADri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR64 }, },
  { 6304 /* psrad */, X86::PSRADri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32 }, },
  { 6304 /* psrad */, X86::PSRADrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6304 /* psrad */, X86::MMX_PSRADrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6310 /* psraw */, X86::MMX_PSRAWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6310 /* psraw */, X86::PSRAWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6310 /* psraw */, X86::MMX_PSRAWri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR64 }, },
  { 6310 /* psraw */, X86::PSRAWri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32 }, },
  { 6310 /* psraw */, X86::PSRAWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6310 /* psraw */, X86::MMX_PSRAWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6316 /* psrld */, X86::MMX_PSRLDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6316 /* psrld */, X86::PSRLDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6316 /* psrld */, X86::MMX_PSRLDri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR64 }, },
  { 6316 /* psrld */, X86::PSRLDri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32 }, },
  { 6316 /* psrld */, X86::PSRLDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6316 /* psrld */, X86::MMX_PSRLDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6322 /* psrldq */, X86::PSRLDQri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32 }, },
  { 6329 /* psrlq */, X86::MMX_PSRLQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6329 /* psrlq */, X86::PSRLQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6329 /* psrlq */, X86::MMX_PSRLQri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR64 }, },
  { 6329 /* psrlq */, X86::PSRLQri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32 }, },
  { 6329 /* psrlq */, X86::PSRLQrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6329 /* psrlq */, X86::MMX_PSRLQrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6335 /* psrlw */, X86::MMX_PSRLWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6335 /* psrlw */, X86::PSRLWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6335 /* psrlw */, X86::MMX_PSRLWri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR64 }, },
  { 6335 /* psrlw */, X86::PSRLWri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32 }, },
  { 6335 /* psrlw */, X86::PSRLWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6335 /* psrlw */, X86::MMX_PSRLWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6341 /* psubb */, X86::MMX_PSUBBirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6341 /* psubb */, X86::PSUBBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6341 /* psubb */, X86::PSUBBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6341 /* psubb */, X86::MMX_PSUBBirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6347 /* psubd */, X86::MMX_PSUBDirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6347 /* psubd */, X86::PSUBDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6347 /* psubd */, X86::PSUBDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6347 /* psubd */, X86::MMX_PSUBDirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6353 /* psubq */, X86::MMX_PSUBQirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6353 /* psubq */, X86::PSUBQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6353 /* psubq */, X86::PSUBQrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6353 /* psubq */, X86::MMX_PSUBQirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6359 /* psubsb */, X86::MMX_PSUBSBirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6359 /* psubsb */, X86::PSUBSBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6359 /* psubsb */, X86::PSUBSBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6359 /* psubsb */, X86::MMX_PSUBSBirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6366 /* psubsw */, X86::MMX_PSUBSWirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6366 /* psubsw */, X86::PSUBSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6366 /* psubsw */, X86::PSUBSWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6366 /* psubsw */, X86::MMX_PSUBSWirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6373 /* psubusb */, X86::MMX_PSUBUSBirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6373 /* psubusb */, X86::PSUBUSBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6373 /* psubusb */, X86::PSUBUSBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6373 /* psubusb */, X86::MMX_PSUBUSBirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6381 /* psubusw */, X86::MMX_PSUBUSWirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6381 /* psubusw */, X86::PSUBUSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6381 /* psubusw */, X86::PSUBUSWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6381 /* psubusw */, X86::MMX_PSUBUSWirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6389 /* psubw */, X86::MMX_PSUBWirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6389 /* psubw */, X86::PSUBWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6389 /* psubw */, X86::PSUBWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6389 /* psubw */, X86::MMX_PSUBWirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6395 /* pswapd */, X86::PSWAPDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6395 /* pswapd */, X86::PSWAPDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6402 /* ptest */, X86::PTESTrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6402 /* ptest */, X86::PTESTrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6416 /* ptwritel */, X86::PTWRITEr, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 6416 /* ptwritel */, X86::PTWRITEm, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 6425 /* ptwriteq */, X86::PTWRITE64r, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 6425 /* ptwriteq */, X86::PTWRITE64m, Convert__Mem645_0, Feature_In64BitMode, { MCK_Mem64 }, },
  { 6434 /* punpckhbw */, X86::MMX_PUNPCKHBWirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6434 /* punpckhbw */, X86::PUNPCKHBWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6434 /* punpckhbw */, X86::PUNPCKHBWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6434 /* punpckhbw */, X86::MMX_PUNPCKHBWirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6444 /* punpckhdq */, X86::MMX_PUNPCKHDQirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6444 /* punpckhdq */, X86::PUNPCKHDQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6444 /* punpckhdq */, X86::PUNPCKHDQrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6444 /* punpckhdq */, X86::MMX_PUNPCKHDQirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6454 /* punpckhqdq */, X86::PUNPCKHQDQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6454 /* punpckhqdq */, X86::PUNPCKHQDQrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6465 /* punpckhwd */, X86::MMX_PUNPCKHWDirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6465 /* punpckhwd */, X86::PUNPCKHWDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6465 /* punpckhwd */, X86::PUNPCKHWDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6465 /* punpckhwd */, X86::MMX_PUNPCKHWDirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6475 /* punpcklbw */, X86::MMX_PUNPCKLBWirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6475 /* punpcklbw */, X86::PUNPCKLBWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6475 /* punpcklbw */, X86::PUNPCKLBWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6475 /* punpcklbw */, X86::MMX_PUNPCKLBWirm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_VR64 }, },
  { 6485 /* punpckldq */, X86::MMX_PUNPCKLDQirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6485 /* punpckldq */, X86::PUNPCKLDQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6485 /* punpckldq */, X86::PUNPCKLDQrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6485 /* punpckldq */, X86::MMX_PUNPCKLDQirm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_VR64 }, },
  { 6495 /* punpcklqdq */, X86::PUNPCKLQDQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6495 /* punpcklqdq */, X86::PUNPCKLQDQrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6506 /* punpcklwd */, X86::MMX_PUNPCKLWDirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6506 /* punpcklwd */, X86::PUNPCKLWDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6506 /* punpcklwd */, X86::PUNPCKLWDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6506 /* punpcklwd */, X86::MMX_PUNPCKLWDirm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_VR64 }, },
  { 6521 /* pushal */, X86::PUSHA32, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 6528 /* pushaw */, X86::PUSHA16, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 6548 /* pushfl */, X86::PUSHF32, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 6555 /* pushfq */, X86::PUSHF64, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 6562 /* pushfw */, X86::PUSHF16, Convert_NoOperands, 0, {  }, },
  { 6569 /* pushl */, X86::PUSHCS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_CS }, },
  { 6569 /* pushl */, X86::PUSHDS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_DS }, },
  { 6569 /* pushl */, X86::PUSHES32, Convert_NoOperands, Feature_Not64BitMode, { MCK_ES }, },
  { 6569 /* pushl */, X86::PUSHFS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_FS }, },
  { 6569 /* pushl */, X86::PUSHGS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_GS }, },
  { 6569 /* pushl */, X86::PUSHSS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_SS }, },
  { 6569 /* pushl */, X86::PUSH32r, Convert__Reg1_0, Feature_Not64BitMode, { MCK_GR32 }, },
  { 6569 /* pushl */, X86::PUSH32i8, Convert__ImmSExti32i81_0, Feature_Not64BitMode, { MCK_ImmSExti32i8 }, },
  { 6569 /* pushl */, X86::PUSHi32, Convert__Imm1_0, Feature_Not64BitMode, { MCK_Imm }, },
  { 6569 /* pushl */, X86::PUSH32rmm, Convert__Mem325_0, Feature_Not64BitMode, { MCK_Mem32 }, },
  { 6575 /* pushq */, X86::PUSHFS64, Convert_NoOperands, Feature_In64BitMode, { MCK_FS }, },
  { 6575 /* pushq */, X86::PUSHGS64, Convert_NoOperands, Feature_In64BitMode, { MCK_GS }, },
  { 6575 /* pushq */, X86::PUSH64r, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 6575 /* pushq */, X86::PUSH64i8, Convert__ImmSExti64i81_0, Feature_In64BitMode, { MCK_ImmSExti64i8 }, },
  { 6575 /* pushq */, X86::PUSH64i32, Convert__ImmSExti64i321_0, Feature_In64BitMode, { MCK_ImmSExti64i32 }, },
  { 6575 /* pushq */, X86::PUSH64rmm, Convert__Mem645_0, Feature_In64BitMode, { MCK_Mem64 }, },
  { 6581 /* pushw */, X86::PUSHCS16, Convert_NoOperands, Feature_Not64BitMode, { MCK_CS }, },
  { 6581 /* pushw */, X86::PUSHDS16, Convert_NoOperands, Feature_Not64BitMode, { MCK_DS }, },
  { 6581 /* pushw */, X86::PUSHES16, Convert_NoOperands, Feature_Not64BitMode, { MCK_ES }, },
  { 6581 /* pushw */, X86::PUSHFS16, Convert_NoOperands, 0, { MCK_FS }, },
  { 6581 /* pushw */, X86::PUSHGS16, Convert_NoOperands, 0, { MCK_GS }, },
  { 6581 /* pushw */, X86::PUSHSS16, Convert_NoOperands, Feature_Not64BitMode, { MCK_SS }, },
  { 6581 /* pushw */, X86::PUSH16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 6581 /* pushw */, X86::PUSH16i8, Convert__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8 }, },
  { 6581 /* pushw */, X86::PUSHi16, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 6581 /* pushw */, X86::PUSH16rmm, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6587 /* pxor */, X86::MMX_PXORirr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6587 /* pxor */, X86::PXORrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6587 /* pxor */, X86::PXORrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6587 /* pxor */, X86::MMX_PXORirm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6596 /* rclb */, X86::RCL8r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR8 }, },
  { 6596 /* rclb */, X86::RCL8m1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6596 /* rclb */, X86::RCL8rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR8 }, },
  { 6596 /* rclb */, X86::RCL8mCL, Convert__Mem85_1, 0, { MCK_CL, MCK_Mem8 }, },
  { 6596 /* rclb */, X86::RCL8ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR8 }, },
  { 6596 /* rclb */, X86::RCL8mi, Convert__Mem85_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem8 }, },
  { 6601 /* rcll */, X86::RCL32r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR32 }, },
  { 6601 /* rcll */, X86::RCL32m1, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 6601 /* rcll */, X86::RCL32rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR32 }, },
  { 6601 /* rcll */, X86::RCL32mCL, Convert__Mem325_1, 0, { MCK_CL, MCK_Mem32 }, },
  { 6601 /* rcll */, X86::RCL32ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR32 }, },
  { 6601 /* rcll */, X86::RCL32mi, Convert__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 6606 /* rclq */, X86::RCL64r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR64 }, },
  { 6606 /* rclq */, X86::RCL64m1, Convert__Mem645_0, Feature_In64BitMode, { MCK_Mem64 }, },
  { 6606 /* rclq */, X86::RCL64rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR64 }, },
  { 6606 /* rclq */, X86::RCL64mCL, Convert__Mem645_1, Feature_In64BitMode, { MCK_CL, MCK_Mem64 }, },
  { 6606 /* rclq */, X86::RCL64ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR64 }, },
  { 6606 /* rclq */, X86::RCL64mi, Convert__Mem645_1__ImmUnsignedi81_0, Feature_In64BitMode, { MCK_ImmUnsignedi8, MCK_Mem64 }, },
  { 6611 /* rclw */, X86::RCL16r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR16 }, },
  { 6611 /* rclw */, X86::RCL16m1, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6611 /* rclw */, X86::RCL16rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR16 }, },
  { 6611 /* rclw */, X86::RCL16mCL, Convert__Mem165_1, 0, { MCK_CL, MCK_Mem16 }, },
  { 6611 /* rclw */, X86::RCL16ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR16 }, },
  { 6611 /* rclw */, X86::RCL16mi, Convert__Mem165_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem16 }, },
  { 6616 /* rcpps */, X86::RCPPSr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6616 /* rcpps */, X86::RCPPSm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6622 /* rcpss */, X86::RCPSSr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6622 /* rcpss */, X86::RCPSSm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 6632 /* rcrb */, X86::RCR8r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR8 }, },
  { 6632 /* rcrb */, X86::RCR8m1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6632 /* rcrb */, X86::RCR8rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR8 }, },
  { 6632 /* rcrb */, X86::RCR8mCL, Convert__Mem85_1, 0, { MCK_CL, MCK_Mem8 }, },
  { 6632 /* rcrb */, X86::RCR8ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR8 }, },
  { 6632 /* rcrb */, X86::RCR8mi, Convert__Mem85_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem8 }, },
  { 6637 /* rcrl */, X86::RCR32r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR32 }, },
  { 6637 /* rcrl */, X86::RCR32m1, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 6637 /* rcrl */, X86::RCR32rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR32 }, },
  { 6637 /* rcrl */, X86::RCR32mCL, Convert__Mem325_1, 0, { MCK_CL, MCK_Mem32 }, },
  { 6637 /* rcrl */, X86::RCR32ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR32 }, },
  { 6637 /* rcrl */, X86::RCR32mi, Convert__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 6642 /* rcrq */, X86::RCR64r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR64 }, },
  { 6642 /* rcrq */, X86::RCR64m1, Convert__Mem645_0, Feature_In64BitMode, { MCK_Mem64 }, },
  { 6642 /* rcrq */, X86::RCR64rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR64 }, },
  { 6642 /* rcrq */, X86::RCR64mCL, Convert__Mem645_1, Feature_In64BitMode, { MCK_CL, MCK_Mem64 }, },
  { 6642 /* rcrq */, X86::RCR64ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR64 }, },
  { 6642 /* rcrq */, X86::RCR64mi, Convert__Mem645_1__ImmUnsignedi81_0, Feature_In64BitMode, { MCK_ImmUnsignedi8, MCK_Mem64 }, },
  { 6647 /* rcrw */, X86::RCR16r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR16 }, },
  { 6647 /* rcrw */, X86::RCR16m1, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6647 /* rcrw */, X86::RCR16rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR16 }, },
  { 6647 /* rcrw */, X86::RCR16mCL, Convert__Mem165_1, 0, { MCK_CL, MCK_Mem16 }, },
  { 6647 /* rcrw */, X86::RCR16ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR16 }, },
  { 6647 /* rcrw */, X86::RCR16mi, Convert__Mem165_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem16 }, },
  { 6661 /* rdfsbasel */, X86::RDFSBASE, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR32 }, },
  { 6671 /* rdfsbaseq */, X86::RDFSBASE64, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 6690 /* rdgsbasel */, X86::RDGSBASE, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR32 }, },
  { 6700 /* rdgsbaseq */, X86::RDGSBASE64, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 6710 /* rdmsr */, X86::RDMSR, Convert_NoOperands, 0, {  }, },
  { 6716 /* rdpid */, X86::RDPID32, Convert__Reg1_0, Feature_Not64BitMode, { MCK_GR32 }, },
  { 6716 /* rdpid */, X86::RDPID64, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 6722 /* rdpkru */, X86::RDPKRUr, Convert_NoOperands, 0, {  }, },
  { 6729 /* rdpmc */, X86::RDPMC, Convert_NoOperands, 0, {  }, },
  { 6742 /* rdrandl */, X86::RDRAND32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 6750 /* rdrandq */, X86::RDRAND64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 6758 /* rdrandw */, X86::RDRAND16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 6773 /* rdseedl */, X86::RDSEED32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 6781 /* rdseedq */, X86::RDSEED64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 6789 /* rdseedw */, X86::RDSEED16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 6797 /* rdsspd */, X86::RDSSPD, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR32 }, },
  { 6804 /* rdsspq */, X86::RDSSPQ, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR64 }, },
  { 6811 /* rdtsc */, X86::RDTSC, Convert_NoOperands, 0, {  }, },
  { 6817 /* rdtscp */, X86::RDTSCP, Convert_NoOperands, 0, {  }, },
  { 6824 /* rep */, X86::REP_PREFIX, Convert_NoOperands, 0, {  }, },
  { 6828 /* repne */, X86::REPNE_PREFIX, Convert_NoOperands, 0, {  }, },
  { 6849 /* retl */, X86::RETL, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 6849 /* retl */, X86::RETIL, Convert__Imm1_0, Feature_Not64BitMode, { MCK_Imm }, },
  { 6854 /* retq */, X86::RETQ, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 6854 /* retq */, X86::RETIQ, Convert__Imm1_0, Feature_In64BitMode, { MCK_Imm }, },
  { 6859 /* retw */, X86::RETW, Convert_NoOperands, 0, {  }, },
  { 6859 /* retw */, X86::RETIW, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 6864 /* rex64 */, X86::REX64_PREFIX, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 6874 /* rolb */, X86::ROL8r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR8 }, },
  { 6874 /* rolb */, X86::ROL8m1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6874 /* rolb */, X86::ROL8rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR8 }, },
  { 6874 /* rolb */, X86::ROL8mCL, Convert__Mem85_1, 0, { MCK_CL, MCK_Mem8 }, },
  { 6874 /* rolb */, X86::ROL8ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR8 }, },
  { 6874 /* rolb */, X86::ROL8mi, Convert__Mem85_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem8 }, },
  { 6879 /* roll */, X86::ROL32r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR32 }, },
  { 6879 /* roll */, X86::ROL32m1, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 6879 /* roll */, X86::ROL32rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR32 }, },
  { 6879 /* roll */, X86::ROL32mCL, Convert__Mem325_1, 0, { MCK_CL, MCK_Mem32 }, },
  { 6879 /* roll */, X86::ROL32ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR32 }, },
  { 6879 /* roll */, X86::ROL32mi, Convert__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 6884 /* rolq */, X86::ROL64r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR64 }, },
  { 6884 /* rolq */, X86::ROL64m1, Convert__Mem645_0, Feature_In64BitMode, { MCK_Mem64 }, },
  { 6884 /* rolq */, X86::ROL64rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR64 }, },
  { 6884 /* rolq */, X86::ROL64mCL, Convert__Mem645_1, Feature_In64BitMode, { MCK_CL, MCK_Mem64 }, },
  { 6884 /* rolq */, X86::ROL64ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR64 }, },
  { 6884 /* rolq */, X86::ROL64mi, Convert__Mem645_1__ImmUnsignedi81_0, Feature_In64BitMode, { MCK_ImmUnsignedi8, MCK_Mem64 }, },
  { 6889 /* rolw */, X86::ROL16r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR16 }, },
  { 6889 /* rolw */, X86::ROL16m1, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6889 /* rolw */, X86::ROL16rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR16 }, },
  { 6889 /* rolw */, X86::ROL16mCL, Convert__Mem165_1, 0, { MCK_CL, MCK_Mem16 }, },
  { 6889 /* rolw */, X86::ROL16ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR16 }, },
  { 6889 /* rolw */, X86::ROL16mi, Convert__Mem165_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem16 }, },
  { 6898 /* rorb */, X86::ROR8r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR8 }, },
  { 6898 /* rorb */, X86::ROR8m1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6898 /* rorb */, X86::ROR8rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR8 }, },
  { 6898 /* rorb */, X86::ROR8mCL, Convert__Mem85_1, 0, { MCK_CL, MCK_Mem8 }, },
  { 6898 /* rorb */, X86::ROR8ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR8 }, },
  { 6898 /* rorb */, X86::ROR8mi, Convert__Mem85_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem8 }, },
  { 6903 /* rorl */, X86::ROR32r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR32 }, },
  { 6903 /* rorl */, X86::ROR32m1, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 6903 /* rorl */, X86::ROR32rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR32 }, },
  { 6903 /* rorl */, X86::ROR32mCL, Convert__Mem325_1, 0, { MCK_CL, MCK_Mem32 }, },
  { 6903 /* rorl */, X86::ROR32ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR32 }, },
  { 6903 /* rorl */, X86::ROR32mi, Convert__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 6908 /* rorq */, X86::ROR64r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR64 }, },
  { 6908 /* rorq */, X86::ROR64m1, Convert__Mem645_0, Feature_In64BitMode, { MCK_Mem64 }, },
  { 6908 /* rorq */, X86::ROR64rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR64 }, },
  { 6908 /* rorq */, X86::ROR64mCL, Convert__Mem645_1, Feature_In64BitMode, { MCK_CL, MCK_Mem64 }, },
  { 6908 /* rorq */, X86::ROR64ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR64 }, },
  { 6908 /* rorq */, X86::ROR64mi, Convert__Mem645_1__ImmUnsignedi81_0, Feature_In64BitMode, { MCK_ImmUnsignedi8, MCK_Mem64 }, },
  { 6913 /* rorw */, X86::ROR16r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR16 }, },
  { 6913 /* rorw */, X86::ROR16m1, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6913 /* rorw */, X86::ROR16rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR16 }, },
  { 6913 /* rorw */, X86::ROR16mCL, Convert__Mem165_1, 0, { MCK_CL, MCK_Mem16 }, },
  { 6913 /* rorw */, X86::ROR16ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR16 }, },
  { 6913 /* rorw */, X86::ROR16mi, Convert__Mem165_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem16 }, },
  { 6923 /* rorxl */, X86::RORX32ri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR32, MCK_GR32 }, },
  { 6923 /* rorxl */, X86::RORX32mi, Convert__Reg1_2__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_GR32 }, },
  { 6929 /* rorxq */, X86::RORX64ri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR64, MCK_GR64 }, },
  { 6929 /* rorxq */, X86::RORX64mi, Convert__Reg1_2__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_GR64 }, },
  { 6935 /* roundpd */, X86::ROUNDPDr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 6935 /* roundpd */, X86::ROUNDPDm, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 6943 /* roundps */, X86::ROUNDPSr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 6943 /* roundps */, X86::ROUNDPSm, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 6951 /* roundsd */, X86::ROUNDSDr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 6951 /* roundsd */, X86::ROUNDSDm, Convert__Reg1_2__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_FR32 }, },
  { 6959 /* roundss */, X86::ROUNDSSr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 6959 /* roundss */, X86::ROUNDSSm, Convert__Reg1_2__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_FR32 }, },
  { 6967 /* rsm */, X86::RSM, Convert_NoOperands, 0, {  }, },
  { 6971 /* rsqrtps */, X86::RSQRTPSr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6971 /* rsqrtps */, X86::RSQRTPSm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6979 /* rsqrtss */, X86::RSQRTSSr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6979 /* rsqrtss */, X86::RSQRTSSm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 6987 /* rstorssp */, X86::RSTORSSP, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 6996 /* sahf */, X86::SAHF, Convert_NoOperands, 0, {  }, },
  { 7001 /* salc */, X86::SALC, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 7010 /* sarb */, X86::SAR8r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR8 }, },
  { 7010 /* sarb */, X86::SAR8m1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 7010 /* sarb */, X86::SAR8rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR8 }, },
  { 7010 /* sarb */, X86::SAR8mCL, Convert__Mem85_1, 0, { MCK_CL, MCK_Mem8 }, },
  { 7010 /* sarb */, X86::SAR8ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR8 }, },
  { 7010 /* sarb */, X86::SAR8mi, Convert__Mem85_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem8 }, },
  { 7015 /* sarl */, X86::SAR32r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR32 }, },
  { 7015 /* sarl */, X86::SAR32m1, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 7015 /* sarl */, X86::SAR32rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR32 }, },
  { 7015 /* sarl */, X86::SAR32mCL, Convert__Mem325_1, 0, { MCK_CL, MCK_Mem32 }, },
  { 7015 /* sarl */, X86::SAR32ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR32 }, },
  { 7015 /* sarl */, X86::SAR32mi, Convert__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 7020 /* sarq */, X86::SAR64r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR64 }, },
  { 7020 /* sarq */, X86::SAR64m1, Convert__Mem645_0, Feature_In64BitMode, { MCK_Mem64 }, },
  { 7020 /* sarq */, X86::SAR64rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR64 }, },
  { 7020 /* sarq */, X86::SAR64mCL, Convert__Mem645_1, Feature_In64BitMode, { MCK_CL, MCK_Mem64 }, },
  { 7020 /* sarq */, X86::SAR64ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR64 }, },
  { 7020 /* sarq */, X86::SAR64mi, Convert__Mem645_1__ImmUnsignedi81_0, Feature_In64BitMode, { MCK_ImmUnsignedi8, MCK_Mem64 }, },
  { 7025 /* sarw */, X86::SAR16r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR16 }, },
  { 7025 /* sarw */, X86::SAR16m1, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 7025 /* sarw */, X86::SAR16rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR16 }, },
  { 7025 /* sarw */, X86::SAR16mCL, Convert__Mem165_1, 0, { MCK_CL, MCK_Mem16 }, },
  { 7025 /* sarw */, X86::SAR16ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR16 }, },
  { 7025 /* sarw */, X86::SAR16mi, Convert__Mem165_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem16 }, },
  { 7035 /* sarxl */, X86::SARX32rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 7035 /* sarxl */, X86::SARX32rm, Convert__Reg1_2__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 7041 /* sarxq */, X86::SARX64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 7041 /* sarxq */, X86::SARX64rm, Convert__Reg1_2__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 7047 /* saveprevssp */, X86::SAVEPREVSSP, Convert_NoOperands, 0, {  }, },
  { 7063 /* sbbb */, X86::SBB8rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 7063 /* sbbb */, X86::SBB8mr, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 7063 /* sbbb */, X86::SBB8i8, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 7063 /* sbbb */, X86::SBB8ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 7063 /* sbbb */, X86::SBB8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 7063 /* sbbb */, X86::SBB8rm, Convert__Reg1_1__Tie0_2_2__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 7068 /* sbbl */, X86::SBB32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 7068 /* sbbl */, X86::SBB32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 7068 /* sbbl */, X86::SBB32ri8, Convert__regEAX__Tie0_1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_EAX }, },
  { 7068 /* sbbl */, X86::SBB32ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 7068 /* sbbl */, X86::SBB32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 7068 /* sbbl */, X86::SBB32i32, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 7068 /* sbbl */, X86::SBB32ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 7068 /* sbbl */, X86::SBB32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 7068 /* sbbl */, X86::SBB32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 7073 /* sbbq */, X86::SBB64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 7073 /* sbbq */, X86::SBB64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 7073 /* sbbq */, X86::SBB64ri8, Convert__regRAX__Tie0_1_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_RAX }, },
  { 7073 /* sbbq */, X86::SBB64ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 7073 /* sbbq */, X86::SBB64mi8, Convert__Mem645_1__ImmSExti64i81_0, Feature_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 7073 /* sbbq */, X86::SBB64i32, Convert__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 7073 /* sbbq */, X86::SBB64ri32, Convert__Reg1_1__Tie0_2_2__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 7073 /* sbbq */, X86::SBB64mi32, Convert__Mem645_1__ImmSExti64i321_0, Feature_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 7073 /* sbbq */, X86::SBB64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 7078 /* sbbw */, X86::SBB16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 7078 /* sbbw */, X86::SBB16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 7078 /* sbbw */, X86::SBB16ri8, Convert__regAX__Tie0_1_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_AX }, },
  { 7078 /* sbbw */, X86::SBB16ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 7078 /* sbbw */, X86::SBB16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 7078 /* sbbw */, X86::SBB16i16, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 7078 /* sbbw */, X86::SBB16ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 7078 /* sbbw */, X86::SBB16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 7078 /* sbbw */, X86::SBB16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 7083 /* scas */, X86::SCASW, Convert__DstIdx161_0, 0, { MCK_DstIdx16, MCK_AX }, },
  { 7083 /* scas */, X86::SCASL, Convert__DstIdx321_0, 0, { MCK_DstIdx32, MCK_EAX }, },
  { 7083 /* scas */, X86::SCASQ, Convert__DstIdx641_0, Feature_In64BitMode, { MCK_DstIdx64, MCK_RAX }, },
  { 7083 /* scas */, X86::SCASB, Convert__DstIdx81_0, 0, { MCK_DstIdx8, MCK_AL }, },
  { 7088 /* scasb */, X86::SCASB, Convert__DstIdx81_0, 0, { MCK_DstIdx8 }, },
  { 7088 /* scasb */, X86::SCASB, Convert__DstIdx81_0, 0, { MCK_DstIdx8, MCK_AL }, },
  { 7100 /* scasl */, X86::SCASL, Convert__DstIdx321_0, 0, { MCK_DstIdx32 }, },
  { 7100 /* scasl */, X86::SCASL, Convert__DstIdx321_0, 0, { MCK_DstIdx32, MCK_EAX }, },
  { 7106 /* scasq */, X86::SCASQ, Convert__DstIdx641_0, Feature_In64BitMode, { MCK_DstIdx64 }, },
  { 7106 /* scasq */, X86::SCASQ, Convert__DstIdx641_0, Feature_In64BitMode, { MCK_DstIdx64, MCK_RAX }, },
  { 7112 /* scasw */, X86::SCASW, Convert__DstIdx161_0, 0, { MCK_DstIdx16 }, },
  { 7112 /* scasw */, X86::SCASW, Convert__DstIdx161_0, 0, { MCK_DstIdx16, MCK_AX }, },
  { 7118 /* seta */, X86::SETAr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 7118 /* seta */, X86::SETAm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 7123 /* setae */, X86::SETAEr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 7123 /* setae */, X86::SETAEm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 7129 /* setb */, X86::SETBr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 7129 /* setb */, X86::SETBm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 7134 /* setbe */, X86::SETBEr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 7134 /* setbe */, X86::SETBEm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 7140 /* sete */, X86::SETEr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 7140 /* sete */, X86::SETEm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 7145 /* setg */, X86::SETGr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 7145 /* setg */, X86::SETGm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 7150 /* setge */, X86::SETGEr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 7150 /* setge */, X86::SETGEm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 7156 /* setl */, X86::SETLr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 7156 /* setl */, X86::SETLm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 7161 /* setle */, X86::SETLEr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 7161 /* setle */, X86::SETLEm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 7167 /* setne */, X86::SETNEr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 7167 /* setne */, X86::SETNEm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 7173 /* setno */, X86::SETNOr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 7173 /* setno */, X86::SETNOm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 7179 /* setnp */, X86::SETNPr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 7179 /* setnp */, X86::SETNPm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 7185 /* setns */, X86::SETNSr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 7185 /* setns */, X86::SETNSm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 7191 /* seto */, X86::SETOr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 7191 /* seto */, X86::SETOm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 7196 /* setp */, X86::SETPr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 7196 /* setp */, X86::SETPm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 7201 /* sets */, X86::SETSr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 7201 /* sets */, X86::SETSm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 7206 /* setssbsy */, X86::SETSSBSY, Convert_NoOperands, 0, {  }, },
  { 7215 /* sfence */, X86::SFENCE, Convert_NoOperands, 0, {  }, },
  { 7233 /* sgdtl */, X86::SGDT32m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 7239 /* sgdtq */, X86::SGDT64m, Convert__Mem5_0, Feature_In64BitMode, { MCK_Mem }, },
  { 7245 /* sgdtw */, X86::SGDT16m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 7251 /* sha1msg1 */, X86::SHA1MSG1rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7251 /* sha1msg1 */, X86::SHA1MSG1rm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7260 /* sha1msg2 */, X86::SHA1MSG2rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7260 /* sha1msg2 */, X86::SHA1MSG2rm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7269 /* sha1nexte */, X86::SHA1NEXTErr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7269 /* sha1nexte */, X86::SHA1NEXTErm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7279 /* sha1rnds4 */, X86::SHA1RNDS4rri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 7279 /* sha1rnds4 */, X86::SHA1RNDS4rmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 7289 /* sha256msg1 */, X86::SHA256MSG1rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7289 /* sha256msg1 */, X86::SHA256MSG1rm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7300 /* sha256msg2 */, X86::SHA256MSG2rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7300 /* sha256msg2 */, X86::SHA256MSG2rm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7311 /* sha256rnds2 */, X86::SHA256RNDS2rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7311 /* sha256rnds2 */, X86::SHA256RNDS2rm, Convert__Reg1_1__Tie0_2_2__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7311 /* sha256rnds2 */, X86::SHA256RNDS2rr, Convert__Reg1_2__Tie0_1_1__Reg1_1, 0, { MCK_XMM0, MCK_FR32, MCK_FR32 }, },
  { 7311 /* sha256rnds2 */, X86::SHA256RNDS2rm, Convert__Reg1_2__Tie0_1_1__Mem1285_1, 0, { MCK_XMM0, MCK_Mem128, MCK_FR32 }, },
  { 7327 /* shlb */, X86::SHL8r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR8 }, },
  { 7327 /* shlb */, X86::SHL8m1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 7327 /* shlb */, X86::SHL8rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR8 }, },
  { 7327 /* shlb */, X86::SHL8mCL, Convert__Mem85_1, 0, { MCK_CL, MCK_Mem8 }, },
  { 7327 /* shlb */, X86::SHL8ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR8 }, },
  { 7327 /* shlb */, X86::SHL8mi, Convert__Mem85_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem8 }, },
  { 7337 /* shldl */, X86::SHLD32rrCL, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 7337 /* shldl */, X86::SHLD32mrCL, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 7337 /* shldl */, X86::SHLD32rrCL, Convert__Reg1_2__Tie0_1_1__Reg1_1, 0, { MCK_CL, MCK_GR32, MCK_GR32 }, },
  { 7337 /* shldl */, X86::SHLD32mrCL, Convert__Mem325_2__Reg1_1, 0, { MCK_CL, MCK_GR32, MCK_Mem32 }, },
  { 7337 /* shldl */, X86::SHLD32rri8, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR32, MCK_GR32 }, },
  { 7337 /* shldl */, X86::SHLD32mri8, Convert__Mem325_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR32, MCK_Mem32 }, },
  { 7343 /* shldq */, X86::SHLD64rrCL, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 7343 /* shldq */, X86::SHLD64mrCL, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 7343 /* shldq */, X86::SHLD64rrCL, Convert__Reg1_2__Tie0_1_1__Reg1_1, 0, { MCK_CL, MCK_GR64, MCK_GR64 }, },
  { 7343 /* shldq */, X86::SHLD64mrCL, Convert__Mem645_2__Reg1_1, 0, { MCK_CL, MCK_GR64, MCK_Mem64 }, },
  { 7343 /* shldq */, X86::SHLD64rri8, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR64, MCK_GR64 }, },
  { 7343 /* shldq */, X86::SHLD64mri8, Convert__Mem645_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR64, MCK_Mem64 }, },
  { 7349 /* shldw */, X86::SHLD16rrCL, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 7349 /* shldw */, X86::SHLD16mrCL, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 7349 /* shldw */, X86::SHLD16rrCL, Convert__Reg1_2__Tie0_1_1__Reg1_1, 0, { MCK_CL, MCK_GR16, MCK_GR16 }, },
  { 7349 /* shldw */, X86::SHLD16mrCL, Convert__Mem165_2__Reg1_1, 0, { MCK_CL, MCK_GR16, MCK_Mem16 }, },
  { 7349 /* shldw */, X86::SHLD16rri8, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR16, MCK_GR16 }, },
  { 7349 /* shldw */, X86::SHLD16mri8, Convert__Mem165_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR16, MCK_Mem16 }, },
  { 7355 /* shll */, X86::SHL32r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR32 }, },
  { 7355 /* shll */, X86::SHL32m1, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 7355 /* shll */, X86::SHL32rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR32 }, },
  { 7355 /* shll */, X86::SHL32mCL, Convert__Mem325_1, 0, { MCK_CL, MCK_Mem32 }, },
  { 7355 /* shll */, X86::SHL32ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR32 }, },
  { 7355 /* shll */, X86::SHL32mi, Convert__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 7360 /* shlq */, X86::SHL64r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR64 }, },
  { 7360 /* shlq */, X86::SHL64m1, Convert__Mem645_0, Feature_In64BitMode, { MCK_Mem64 }, },
  { 7360 /* shlq */, X86::SHL64rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR64 }, },
  { 7360 /* shlq */, X86::SHL64mCL, Convert__Mem645_1, Feature_In64BitMode, { MCK_CL, MCK_Mem64 }, },
  { 7360 /* shlq */, X86::SHL64ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR64 }, },
  { 7360 /* shlq */, X86::SHL64mi, Convert__Mem645_1__ImmUnsignedi81_0, Feature_In64BitMode, { MCK_ImmUnsignedi8, MCK_Mem64 }, },
  { 7365 /* shlw */, X86::SHL16r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR16 }, },
  { 7365 /* shlw */, X86::SHL16m1, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 7365 /* shlw */, X86::SHL16rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR16 }, },
  { 7365 /* shlw */, X86::SHL16mCL, Convert__Mem165_1, 0, { MCK_CL, MCK_Mem16 }, },
  { 7365 /* shlw */, X86::SHL16ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR16 }, },
  { 7365 /* shlw */, X86::SHL16mi, Convert__Mem165_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem16 }, },
  { 7375 /* shlxl */, X86::SHLX32rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 7375 /* shlxl */, X86::SHLX32rm, Convert__Reg1_2__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 7381 /* shlxq */, X86::SHLX64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 7381 /* shlxq */, X86::SHLX64rm, Convert__Reg1_2__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 7391 /* shrb */, X86::SHR8r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR8 }, },
  { 7391 /* shrb */, X86::SHR8m1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 7391 /* shrb */, X86::SHR8rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR8 }, },
  { 7391 /* shrb */, X86::SHR8mCL, Convert__Mem85_1, 0, { MCK_CL, MCK_Mem8 }, },
  { 7391 /* shrb */, X86::SHR8ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR8 }, },
  { 7391 /* shrb */, X86::SHR8mi, Convert__Mem85_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem8 }, },
  { 7401 /* shrdl */, X86::SHRD32rrCL, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 7401 /* shrdl */, X86::SHRD32mrCL, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 7401 /* shrdl */, X86::SHRD32rrCL, Convert__Reg1_2__Tie0_1_1__Reg1_1, 0, { MCK_CL, MCK_GR32, MCK_GR32 }, },
  { 7401 /* shrdl */, X86::SHRD32mrCL, Convert__Mem325_2__Reg1_1, 0, { MCK_CL, MCK_GR32, MCK_Mem32 }, },
  { 7401 /* shrdl */, X86::SHRD32rri8, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR32, MCK_GR32 }, },
  { 7401 /* shrdl */, X86::SHRD32mri8, Convert__Mem325_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR32, MCK_Mem32 }, },
  { 7407 /* shrdq */, X86::SHRD64rrCL, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 7407 /* shrdq */, X86::SHRD64mrCL, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 7407 /* shrdq */, X86::SHRD64rrCL, Convert__Reg1_2__Tie0_1_1__Reg1_1, 0, { MCK_CL, MCK_GR64, MCK_GR64 }, },
  { 7407 /* shrdq */, X86::SHRD64mrCL, Convert__Mem645_2__Reg1_1, 0, { MCK_CL, MCK_GR64, MCK_Mem64 }, },
  { 7407 /* shrdq */, X86::SHRD64rri8, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR64, MCK_GR64 }, },
  { 7407 /* shrdq */, X86::SHRD64mri8, Convert__Mem645_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR64, MCK_Mem64 }, },
  { 7413 /* shrdw */, X86::SHRD16rrCL, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 7413 /* shrdw */, X86::SHRD16mrCL, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 7413 /* shrdw */, X86::SHRD16rrCL, Convert__Reg1_2__Tie0_1_1__Reg1_1, 0, { MCK_CL, MCK_GR16, MCK_GR16 }, },
  { 7413 /* shrdw */, X86::SHRD16mrCL, Convert__Mem165_2__Reg1_1, 0, { MCK_CL, MCK_GR16, MCK_Mem16 }, },
  { 7413 /* shrdw */, X86::SHRD16rri8, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR16, MCK_GR16 }, },
  { 7413 /* shrdw */, X86::SHRD16mri8, Convert__Mem165_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR16, MCK_Mem16 }, },
  { 7419 /* shrl */, X86::SHR32r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR32 }, },
  { 7419 /* shrl */, X86::SHR32m1, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 7419 /* shrl */, X86::SHR32rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR32 }, },
  { 7419 /* shrl */, X86::SHR32mCL, Convert__Mem325_1, 0, { MCK_CL, MCK_Mem32 }, },
  { 7419 /* shrl */, X86::SHR32ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR32 }, },
  { 7419 /* shrl */, X86::SHR32mi, Convert__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 7424 /* shrq */, X86::SHR64r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR64 }, },
  { 7424 /* shrq */, X86::SHR64m1, Convert__Mem645_0, Feature_In64BitMode, { MCK_Mem64 }, },
  { 7424 /* shrq */, X86::SHR64rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR64 }, },
  { 7424 /* shrq */, X86::SHR64mCL, Convert__Mem645_1, Feature_In64BitMode, { MCK_CL, MCK_Mem64 }, },
  { 7424 /* shrq */, X86::SHR64ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR64 }, },
  { 7424 /* shrq */, X86::SHR64mi, Convert__Mem645_1__ImmUnsignedi81_0, Feature_In64BitMode, { MCK_ImmUnsignedi8, MCK_Mem64 }, },
  { 7429 /* shrw */, X86::SHR16r1, Convert__Reg1_0__Tie0_1_1, 0, { MCK_GR16 }, },
  { 7429 /* shrw */, X86::SHR16m1, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 7429 /* shrw */, X86::SHR16rCL, Convert__Reg1_1__Tie0_1_1, 0, { MCK_CL, MCK_GR16 }, },
  { 7429 /* shrw */, X86::SHR16mCL, Convert__Mem165_1, 0, { MCK_CL, MCK_Mem16 }, },
  { 7429 /* shrw */, X86::SHR16ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR16 }, },
  { 7429 /* shrw */, X86::SHR16mi, Convert__Mem165_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem16 }, },
  { 7439 /* shrxl */, X86::SHRX32rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 7439 /* shrxl */, X86::SHRX32rm, Convert__Reg1_2__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 7445 /* shrxq */, X86::SHRX64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 7445 /* shrxq */, X86::SHRX64rm, Convert__Reg1_2__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 7451 /* shufpd */, X86::SHUFPDrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 7451 /* shufpd */, X86::SHUFPDrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 7458 /* shufps */, X86::SHUFPSrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 7458 /* shufps */, X86::SHUFPSrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 7476 /* sidtl */, X86::SIDT32m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 7482 /* sidtq */, X86::SIDT64m, Convert__Mem5_0, Feature_In64BitMode, { MCK_Mem }, },
  { 7488 /* sidtw */, X86::SIDT16m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 7494 /* skinit */, X86::SKINIT, Convert_NoOperands, 0, { MCK_EAX }, },
  { 7501 /* sldt */, X86::SLDT16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 7506 /* sldtl */, X86::SLDT32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 7512 /* sldtq */, X86::SLDT64r, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 7518 /* sldtw */, X86::SLDT16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 7518 /* sldtw */, X86::SLDT16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 7524 /* slwpcb */, X86::SLWPCB, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 7524 /* slwpcb */, X86::SLWPCB64, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 7536 /* smswl */, X86::SMSW32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 7542 /* smswq */, X86::SMSW64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 7548 /* smsww */, X86::SMSW16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 7548 /* smsww */, X86::SMSW16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 7554 /* sqrtpd */, X86::SQRTPDr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7554 /* sqrtpd */, X86::SQRTPDm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7561 /* sqrtps */, X86::SQRTPSr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7561 /* sqrtps */, X86::SQRTPSm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7568 /* sqrtsd */, X86::SQRTSDr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7568 /* sqrtsd */, X86::SQRTSDm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 7575 /* sqrtss */, X86::SQRTSSr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7575 /* sqrtss */, X86::SQRTSSm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 7582 /* ss */, X86::SS_PREFIX, Convert_NoOperands, 0, {  }, },
  { 7585 /* stac */, X86::STAC, Convert_NoOperands, 0, {  }, },
  { 7590 /* stc */, X86::STC, Convert_NoOperands, 0, {  }, },
  { 7594 /* std */, X86::STD, Convert_NoOperands, 0, {  }, },
  { 7598 /* stgi */, X86::STGI, Convert_NoOperands, 0, {  }, },
  { 7603 /* sti */, X86::STI, Convert_NoOperands, 0, {  }, },
  { 7607 /* stmxcsr */, X86::STMXCSR, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 7615 /* stos */, X86::STOSB, Convert__DstIdx81_1, 0, { MCK_AL, MCK_DstIdx8 }, },
  { 7615 /* stos */, X86::STOSW, Convert__DstIdx161_1, 0, { MCK_AX, MCK_DstIdx16 }, },
  { 7615 /* stos */, X86::STOSL, Convert__DstIdx321_1, 0, { MCK_EAX, MCK_DstIdx32 }, },
  { 7615 /* stos */, X86::STOSQ, Convert__DstIdx641_1, Feature_In64BitMode, { MCK_RAX, MCK_DstIdx64 }, },
  { 7620 /* stosb */, X86::STOSB, Convert__DstIdx81_0, 0, { MCK_DstIdx8 }, },
  { 7620 /* stosb */, X86::STOSB, Convert__DstIdx81_1, 0, { MCK_AL, MCK_DstIdx8 }, },
  { 7632 /* stosl */, X86::STOSL, Convert__DstIdx321_0, 0, { MCK_DstIdx32 }, },
  { 7632 /* stosl */, X86::STOSL, Convert__DstIdx321_1, 0, { MCK_EAX, MCK_DstIdx32 }, },
  { 7638 /* stosq */, X86::STOSQ, Convert__DstIdx641_0, Feature_In64BitMode, { MCK_DstIdx64 }, },
  { 7638 /* stosq */, X86::STOSQ, Convert__DstIdx641_1, Feature_In64BitMode, { MCK_RAX, MCK_DstIdx64 }, },
  { 7644 /* stosw */, X86::STOSW, Convert__DstIdx161_0, 0, { MCK_DstIdx16 }, },
  { 7644 /* stosw */, X86::STOSW, Convert__DstIdx161_1, 0, { MCK_AX, MCK_DstIdx16 }, },
  { 7654 /* strl */, X86::STR32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 7659 /* strq */, X86::STR64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 7664 /* strw */, X86::STR16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 7664 /* strw */, X86::STRm, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 7673 /* subb */, X86::SUB8rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 7673 /* subb */, X86::SUB8mr, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 7673 /* subb */, X86::SUB8i8, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 7673 /* subb */, X86::SUB8ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 7673 /* subb */, X86::SUB8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 7673 /* subb */, X86::SUB8rm, Convert__Reg1_1__Tie0_2_2__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 7678 /* subl */, X86::SUB32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 7678 /* subl */, X86::SUB32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 7678 /* subl */, X86::SUB32ri8, Convert__regEAX__Tie0_1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_EAX }, },
  { 7678 /* subl */, X86::SUB32ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 7678 /* subl */, X86::SUB32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 7678 /* subl */, X86::SUB32i32, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 7678 /* subl */, X86::SUB32ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 7678 /* subl */, X86::SUB32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 7678 /* subl */, X86::SUB32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 7683 /* subpd */, X86::SUBPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7683 /* subpd */, X86::SUBPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7689 /* subps */, X86::SUBPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7689 /* subps */, X86::SUBPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7695 /* subq */, X86::SUB64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 7695 /* subq */, X86::SUB64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 7695 /* subq */, X86::SUB64ri8, Convert__regRAX__Tie0_1_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_RAX }, },
  { 7695 /* subq */, X86::SUB64ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 7695 /* subq */, X86::SUB64mi8, Convert__Mem645_1__ImmSExti64i81_0, Feature_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 7695 /* subq */, X86::SUB64i32, Convert__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 7695 /* subq */, X86::SUB64ri32, Convert__Reg1_1__Tie0_2_2__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 7695 /* subq */, X86::SUB64mi32, Convert__Mem645_1__ImmSExti64i321_0, Feature_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 7695 /* subq */, X86::SUB64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 7700 /* subsd */, X86::SUBSDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7700 /* subsd */, X86::SUBSDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 7706 /* subss */, X86::SUBSSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7706 /* subss */, X86::SUBSSrm, Convert__Reg1_1__Tie0_1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 7712 /* subw */, X86::SUB16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 7712 /* subw */, X86::SUB16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 7712 /* subw */, X86::SUB16ri8, Convert__regAX__Tie0_1_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_AX }, },
  { 7712 /* subw */, X86::SUB16ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 7712 /* subw */, X86::SUB16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 7712 /* subw */, X86::SUB16i16, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 7712 /* subw */, X86::SUB16ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 7712 /* subw */, X86::SUB16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 7712 /* subw */, X86::SUB16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 7717 /* swapgs */, X86::SWAPGS, Convert_NoOperands, 0, {  }, },
  { 7724 /* syscall */, X86::SYSCALL, Convert_NoOperands, 0, {  }, },
  { 7732 /* sysenter */, X86::SYSENTER, Convert_NoOperands, 0, {  }, },
  { 7749 /* sysexitl */, X86::SYSEXIT, Convert_NoOperands, 0, {  }, },
  { 7758 /* sysexitq */, X86::SYSEXIT64, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 7774 /* sysretl */, X86::SYSRET, Convert_NoOperands, 0, {  }, },
  { 7782 /* sysretq */, X86::SYSRET64, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 7797 /* t1mskcl */, X86::T1MSKC32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 7797 /* t1mskcl */, X86::T1MSKC32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 7805 /* t1mskcq */, X86::T1MSKC64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 7805 /* t1mskcq */, X86::T1MSKC64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 7818 /* testb */, X86::TEST8rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 7818 /* testb */, X86::TEST8mr, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 7818 /* testb */, X86::TEST8i8, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 7818 /* testb */, X86::TEST8ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 7818 /* testb */, X86::TEST8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 7818 /* testb */, X86::TEST8mr, Convert__Mem85_0__Reg1_1, 0, { MCK_Mem8, MCK_GR8 }, },
  { 7824 /* testl */, X86::TEST32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 7824 /* testl */, X86::TEST32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 7824 /* testl */, X86::TEST32i32, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 7824 /* testl */, X86::TEST32ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 7824 /* testl */, X86::TEST32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 7824 /* testl */, X86::TEST32mr, Convert__Mem325_0__Reg1_1, 0, { MCK_Mem32, MCK_GR32 }, },
  { 7830 /* testq */, X86::TEST64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 7830 /* testq */, X86::TEST64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 7830 /* testq */, X86::TEST64i32, Convert__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 7830 /* testq */, X86::TEST64ri32, Convert__Reg1_1__ImmSExti64i321_0, Feature_In64BitMode, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 7830 /* testq */, X86::TEST64mi32, Convert__Mem645_1__ImmSExti64i321_0, Feature_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 7830 /* testq */, X86::TEST64mr, Convert__Mem645_0__Reg1_1, 0, { MCK_Mem64, MCK_GR64 }, },
  { 7836 /* testw */, X86::TEST16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 7836 /* testw */, X86::TEST16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 7836 /* testw */, X86::TEST16i16, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 7836 /* testw */, X86::TEST16ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 7836 /* testw */, X86::TEST16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 7836 /* testw */, X86::TEST16mr, Convert__Mem165_0__Reg1_1, 0, { MCK_Mem16, MCK_GR16 }, },
  { 7842 /* tpause */, X86::TPAUSE, Convert__GR32orGR641_0, 0, { MCK_GR32orGR64 }, },
  { 7855 /* tzcntl */, X86::TZCNT32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 7855 /* tzcntl */, X86::TZCNT32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 7862 /* tzcntq */, X86::TZCNT64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 7862 /* tzcntq */, X86::TZCNT64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 7869 /* tzcntw */, X86::TZCNT16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 7869 /* tzcntw */, X86::TZCNT16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 7882 /* tzmskl */, X86::TZMSK32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 7882 /* tzmskl */, X86::TZMSK32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 7889 /* tzmskq */, X86::TZMSK64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 7889 /* tzmskq */, X86::TZMSK64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 7896 /* ucomisd */, X86::UCOMISDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7896 /* ucomisd */, X86::UCOMISDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 7904 /* ucomiss */, X86::UCOMISSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7904 /* ucomiss */, X86::UCOMISSrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 7912 /* ud2 */, X86::TRAP, Convert_NoOperands, 0, {  }, },
  { 7916 /* ud2b */, X86::UD2B, Convert_NoOperands, 0, {  }, },
  { 7921 /* umonitor */, X86::UMONITOR16, Convert__Reg1_0, Feature_Not64BitMode, { MCK_GR16 }, },
  { 7921 /* umonitor */, X86::UMONITOR32, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 7921 /* umonitor */, X86::UMONITOR64, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 7930 /* umwait */, X86::UMWAIT, Convert__GR32orGR641_0, 0, { MCK_GR32orGR64 }, },
  { 7937 /* unpckhpd */, X86::UNPCKHPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7937 /* unpckhpd */, X86::UNPCKHPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7946 /* unpckhps */, X86::UNPCKHPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7946 /* unpckhps */, X86::UNPCKHPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7955 /* unpcklpd */, X86::UNPCKLPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7955 /* unpcklpd */, X86::UNPCKLPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7964 /* unpcklps */, X86::UNPCKLPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7964 /* unpcklps */, X86::UNPCKLPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7973 /* v4fmaddps */, X86::V4FMADDPSrm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR512, MCK_VR512 }, },
  { 7973 /* v4fmaddps */, X86::V4FMADDPSrmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 7973 /* v4fmaddps */, X86::V4FMADDPSrmkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 7983 /* v4fmaddss */, X86::V4FMADDSSrm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 7983 /* v4fmaddss */, X86::V4FMADDSSrmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 7983 /* v4fmaddss */, X86::V4FMADDSSrmkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 7993 /* v4fnmaddps */, X86::V4FNMADDPSrm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR512, MCK_VR512 }, },
  { 7993 /* v4fnmaddps */, X86::V4FNMADDPSrmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 7993 /* v4fnmaddps */, X86::V4FNMADDPSrmkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8004 /* v4fnmaddss */, X86::V4FNMADDSSrm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8004 /* v4fnmaddss */, X86::V4FNMADDSSrmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8004 /* v4fnmaddss */, X86::V4FNMADDSSrmkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8015 /* vaddpd */, X86::VADDPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8015 /* vaddpd */, X86::VADDPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8015 /* vaddpd */, X86::VADDPDZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8015 /* vaddpd */, X86::VADDPDZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8015 /* vaddpd */, X86::VADDPDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8015 /* vaddpd */, X86::VADDPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8015 /* vaddpd */, X86::VADDPDZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8015 /* vaddpd */, X86::VADDPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8015 /* vaddpd */, X86::VADDPDZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8015 /* vaddpd */, X86::VADDPDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8015 /* vaddpd */, X86::VADDPDZrrb, Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8015 /* vaddpd */, X86::VADDPDZ128rmb, Convert__Reg1_3__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 8015 /* vaddpd */, X86::VADDPDZ256rmb, Convert__Reg1_3__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 8015 /* vaddpd */, X86::VADDPDZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8015 /* vaddpd */, X86::VADDPDZ128rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8015 /* vaddpd */, X86::VADDPDZ256rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8015 /* vaddpd */, X86::VADDPDZrrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8015 /* vaddpd */, X86::VADDPDZ128rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8015 /* vaddpd */, X86::VADDPDZ256rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8015 /* vaddpd */, X86::VADDPDZrmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8015 /* vaddpd */, X86::VADDPDZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8015 /* vaddpd */, X86::VADDPDZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8015 /* vaddpd */, X86::VADDPDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8015 /* vaddpd */, X86::VADDPDZrrbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8015 /* vaddpd */, X86::VADDPDZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8015 /* vaddpd */, X86::VADDPDZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8015 /* vaddpd */, X86::VADDPDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8015 /* vaddpd */, X86::VADDPDZ128rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8015 /* vaddpd */, X86::VADDPDZ256rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8015 /* vaddpd */, X86::VADDPDZrmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8015 /* vaddpd */, X86::VADDPDZrrbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8015 /* vaddpd */, X86::VADDPDZ128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8015 /* vaddpd */, X86::VADDPDZ256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8015 /* vaddpd */, X86::VADDPDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8022 /* vaddps */, X86::VADDPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8022 /* vaddps */, X86::VADDPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8022 /* vaddps */, X86::VADDPSZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8022 /* vaddps */, X86::VADDPSZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8022 /* vaddps */, X86::VADDPSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8022 /* vaddps */, X86::VADDPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8022 /* vaddps */, X86::VADDPSZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8022 /* vaddps */, X86::VADDPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8022 /* vaddps */, X86::VADDPSZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8022 /* vaddps */, X86::VADDPSZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8022 /* vaddps */, X86::VADDPSZrrb, Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8022 /* vaddps */, X86::VADDPSZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 8022 /* vaddps */, X86::VADDPSZ128rmb, Convert__Reg1_3__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 8022 /* vaddps */, X86::VADDPSZ256rmb, Convert__Reg1_3__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 8022 /* vaddps */, X86::VADDPSZ128rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8022 /* vaddps */, X86::VADDPSZ256rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8022 /* vaddps */, X86::VADDPSZrrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8022 /* vaddps */, X86::VADDPSZ128rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8022 /* vaddps */, X86::VADDPSZ256rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8022 /* vaddps */, X86::VADDPSZrmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8022 /* vaddps */, X86::VADDPSZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8022 /* vaddps */, X86::VADDPSZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8022 /* vaddps */, X86::VADDPSZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8022 /* vaddps */, X86::VADDPSZrrbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8022 /* vaddps */, X86::VADDPSZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8022 /* vaddps */, X86::VADDPSZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8022 /* vaddps */, X86::VADDPSZrmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8022 /* vaddps */, X86::VADDPSZ128rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8022 /* vaddps */, X86::VADDPSZ256rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8022 /* vaddps */, X86::VADDPSZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8022 /* vaddps */, X86::VADDPSZrrbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8022 /* vaddps */, X86::VADDPSZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8022 /* vaddps */, X86::VADDPSZ128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8022 /* vaddps */, X86::VADDPSZ256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8029 /* vaddsd */, X86::VADDSDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8029 /* vaddsd */, X86::VADDSDZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8029 /* vaddsd */, X86::VADDSDrm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8029 /* vaddsd */, X86::VADDSDZrm_Int, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 8029 /* vaddsd */, X86::VADDSDZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8029 /* vaddsd */, X86::VADDSDZrr_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8029 /* vaddsd */, X86::VADDSDZrm_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8029 /* vaddsd */, X86::VADDSDZrr_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8029 /* vaddsd */, X86::VADDSDZrrb_Intk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8029 /* vaddsd */, X86::VADDSDZrm_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8029 /* vaddsd */, X86::VADDSDZrrb_Intkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8036 /* vaddss */, X86::VADDSSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8036 /* vaddss */, X86::VADDSSZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8036 /* vaddss */, X86::VADDSSrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8036 /* vaddss */, X86::VADDSSZrm_Int, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 8036 /* vaddss */, X86::VADDSSZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8036 /* vaddss */, X86::VADDSSZrr_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8036 /* vaddss */, X86::VADDSSZrm_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8036 /* vaddss */, X86::VADDSSZrr_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8036 /* vaddss */, X86::VADDSSZrrb_Intk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8036 /* vaddss */, X86::VADDSSZrm_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8036 /* vaddss */, X86::VADDSSZrrb_Intkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8043 /* vaddsubpd */, X86::VADDSUBPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8043 /* vaddsubpd */, X86::VADDSUBPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8043 /* vaddsubpd */, X86::VADDSUBPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8043 /* vaddsubpd */, X86::VADDSUBPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8053 /* vaddsubps */, X86::VADDSUBPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8053 /* vaddsubps */, X86::VADDSUBPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8053 /* vaddsubps */, X86::VADDSUBPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8053 /* vaddsubps */, X86::VADDSUBPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8063 /* vaesdec */, X86::VAESDECrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8063 /* vaesdec */, X86::VAESDECYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8063 /* vaesdec */, X86::VAESDECZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8063 /* vaesdec */, X86::VAESDECZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8063 /* vaesdec */, X86::VAESDECZrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8063 /* vaesdec */, X86::VAESDECrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8063 /* vaesdec */, X86::VAESDECZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8063 /* vaesdec */, X86::VAESDECYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8063 /* vaesdec */, X86::VAESDECZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8063 /* vaesdec */, X86::VAESDECZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8071 /* vaesdeclast */, X86::VAESDECLASTrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8071 /* vaesdeclast */, X86::VAESDECLASTYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8071 /* vaesdeclast */, X86::VAESDECLASTZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8071 /* vaesdeclast */, X86::VAESDECLASTZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8071 /* vaesdeclast */, X86::VAESDECLASTZrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8071 /* vaesdeclast */, X86::VAESDECLASTrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8071 /* vaesdeclast */, X86::VAESDECLASTZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8071 /* vaesdeclast */, X86::VAESDECLASTYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8071 /* vaesdeclast */, X86::VAESDECLASTZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8071 /* vaesdeclast */, X86::VAESDECLASTZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8083 /* vaesenc */, X86::VAESENCrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8083 /* vaesenc */, X86::VAESENCYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8083 /* vaesenc */, X86::VAESENCZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8083 /* vaesenc */, X86::VAESENCZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8083 /* vaesenc */, X86::VAESENCZrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8083 /* vaesenc */, X86::VAESENCrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8083 /* vaesenc */, X86::VAESENCZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8083 /* vaesenc */, X86::VAESENCYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8083 /* vaesenc */, X86::VAESENCZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8083 /* vaesenc */, X86::VAESENCZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8091 /* vaesenclast */, X86::VAESENCLASTrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8091 /* vaesenclast */, X86::VAESENCLASTYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8091 /* vaesenclast */, X86::VAESENCLASTZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8091 /* vaesenclast */, X86::VAESENCLASTZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8091 /* vaesenclast */, X86::VAESENCLASTZrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8091 /* vaesenclast */, X86::VAESENCLASTrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8091 /* vaesenclast */, X86::VAESENCLASTZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8091 /* vaesenclast */, X86::VAESENCLASTYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8091 /* vaesenclast */, X86::VAESENCLASTZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8091 /* vaesenclast */, X86::VAESENCLASTZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8103 /* vaesimc */, X86::VAESIMCrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 8103 /* vaesimc */, X86::VAESIMCrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 8111 /* vaeskeygenassist */, X86::VAESKEYGENASSIST128rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 8111 /* vaeskeygenassist */, X86::VAESKEYGENASSIST128rm, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 8128 /* valignd */, X86::VALIGNDZ128rri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8128 /* valignd */, X86::VALIGNDZ256rri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8128 /* valignd */, X86::VALIGNDZrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8128 /* valignd */, X86::VALIGNDZ128rmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8128 /* valignd */, X86::VALIGNDZ256rmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8128 /* valignd */, X86::VALIGNDZrmi, Convert__Reg1_3__Reg1_2__Mem5125_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8128 /* valignd */, X86::VALIGNDZrmbi, Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 8128 /* valignd */, X86::VALIGNDZ128rmbi, Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 8128 /* valignd */, X86::VALIGNDZ256rmbi, Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 8128 /* valignd */, X86::VALIGNDZ128rrik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8128 /* valignd */, X86::VALIGNDZ256rrik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8128 /* valignd */, X86::VALIGNDZrrik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8128 /* valignd */, X86::VALIGNDZ128rmik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8128 /* valignd */, X86::VALIGNDZ256rmik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8128 /* valignd */, X86::VALIGNDZrmik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8128 /* valignd */, X86::VALIGNDZ128rrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8128 /* valignd */, X86::VALIGNDZ256rrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8128 /* valignd */, X86::VALIGNDZrrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8128 /* valignd */, X86::VALIGNDZ128rmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8128 /* valignd */, X86::VALIGNDZ256rmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8128 /* valignd */, X86::VALIGNDZrmbik, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8128 /* valignd */, X86::VALIGNDZ128rmbik, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8128 /* valignd */, X86::VALIGNDZ256rmbik, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8128 /* valignd */, X86::VALIGNDZrmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8128 /* valignd */, X86::VALIGNDZrmbikz, Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8128 /* valignd */, X86::VALIGNDZ128rmbikz, Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8128 /* valignd */, X86::VALIGNDZ256rmbikz, Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8136 /* valignq */, X86::VALIGNQZ128rri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8136 /* valignq */, X86::VALIGNQZ256rri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8136 /* valignq */, X86::VALIGNQZrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8136 /* valignq */, X86::VALIGNQZ128rmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8136 /* valignq */, X86::VALIGNQZ256rmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8136 /* valignq */, X86::VALIGNQZrmi, Convert__Reg1_3__Reg1_2__Mem5125_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8136 /* valignq */, X86::VALIGNQZ128rmbi, Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 8136 /* valignq */, X86::VALIGNQZ256rmbi, Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 8136 /* valignq */, X86::VALIGNQZrmbi, Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8136 /* valignq */, X86::VALIGNQZ128rrik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8136 /* valignq */, X86::VALIGNQZ256rrik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8136 /* valignq */, X86::VALIGNQZrrik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8136 /* valignq */, X86::VALIGNQZ128rmik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8136 /* valignq */, X86::VALIGNQZ256rmik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8136 /* valignq */, X86::VALIGNQZrmik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8136 /* valignq */, X86::VALIGNQZ128rrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8136 /* valignq */, X86::VALIGNQZ256rrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8136 /* valignq */, X86::VALIGNQZrrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8136 /* valignq */, X86::VALIGNQZ128rmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8136 /* valignq */, X86::VALIGNQZ256rmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8136 /* valignq */, X86::VALIGNQZrmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8136 /* valignq */, X86::VALIGNQZ128rmbik, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8136 /* valignq */, X86::VALIGNQZ256rmbik, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8136 /* valignq */, X86::VALIGNQZrmbik, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8136 /* valignq */, X86::VALIGNQZ128rmbikz, Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8136 /* valignq */, X86::VALIGNQZ256rmbikz, Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8136 /* valignq */, X86::VALIGNQZrmbikz, Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8144 /* vandnpd */, X86::VANDNPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8144 /* vandnpd */, X86::VANDNPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8144 /* vandnpd */, X86::VANDNPDZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8144 /* vandnpd */, X86::VANDNPDZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8144 /* vandnpd */, X86::VANDNPDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8144 /* vandnpd */, X86::VANDNPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8144 /* vandnpd */, X86::VANDNPDZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8144 /* vandnpd */, X86::VANDNPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8144 /* vandnpd */, X86::VANDNPDZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8144 /* vandnpd */, X86::VANDNPDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8144 /* vandnpd */, X86::VANDNPDZ128rmb, Convert__Reg1_3__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 8144 /* vandnpd */, X86::VANDNPDZ256rmb, Convert__Reg1_3__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 8144 /* vandnpd */, X86::VANDNPDZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8144 /* vandnpd */, X86::VANDNPDZ128rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8144 /* vandnpd */, X86::VANDNPDZ256rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8144 /* vandnpd */, X86::VANDNPDZrrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8144 /* vandnpd */, X86::VANDNPDZ128rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8144 /* vandnpd */, X86::VANDNPDZ256rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8144 /* vandnpd */, X86::VANDNPDZrmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8144 /* vandnpd */, X86::VANDNPDZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8144 /* vandnpd */, X86::VANDNPDZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8144 /* vandnpd */, X86::VANDNPDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8144 /* vandnpd */, X86::VANDNPDZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8144 /* vandnpd */, X86::VANDNPDZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8144 /* vandnpd */, X86::VANDNPDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8144 /* vandnpd */, X86::VANDNPDZ128rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8144 /* vandnpd */, X86::VANDNPDZ256rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8144 /* vandnpd */, X86::VANDNPDZrmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8144 /* vandnpd */, X86::VANDNPDZ128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8144 /* vandnpd */, X86::VANDNPDZ256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8144 /* vandnpd */, X86::VANDNPDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8152 /* vandnps */, X86::VANDNPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8152 /* vandnps */, X86::VANDNPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8152 /* vandnps */, X86::VANDNPSZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8152 /* vandnps */, X86::VANDNPSZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8152 /* vandnps */, X86::VANDNPSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8152 /* vandnps */, X86::VANDNPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8152 /* vandnps */, X86::VANDNPSZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8152 /* vandnps */, X86::VANDNPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8152 /* vandnps */, X86::VANDNPSZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8152 /* vandnps */, X86::VANDNPSZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8152 /* vandnps */, X86::VANDNPSZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 8152 /* vandnps */, X86::VANDNPSZ128rmb, Convert__Reg1_3__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 8152 /* vandnps */, X86::VANDNPSZ256rmb, Convert__Reg1_3__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 8152 /* vandnps */, X86::VANDNPSZ128rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8152 /* vandnps */, X86::VANDNPSZ256rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8152 /* vandnps */, X86::VANDNPSZrrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8152 /* vandnps */, X86::VANDNPSZ128rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8152 /* vandnps */, X86::VANDNPSZ256rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8152 /* vandnps */, X86::VANDNPSZrmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8152 /* vandnps */, X86::VANDNPSZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8152 /* vandnps */, X86::VANDNPSZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8152 /* vandnps */, X86::VANDNPSZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8152 /* vandnps */, X86::VANDNPSZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8152 /* vandnps */, X86::VANDNPSZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8152 /* vandnps */, X86::VANDNPSZrmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8152 /* vandnps */, X86::VANDNPSZ128rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8152 /* vandnps */, X86::VANDNPSZ256rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8152 /* vandnps */, X86::VANDNPSZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8152 /* vandnps */, X86::VANDNPSZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8152 /* vandnps */, X86::VANDNPSZ128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8152 /* vandnps */, X86::VANDNPSZ256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8160 /* vandpd */, X86::VANDPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8160 /* vandpd */, X86::VANDPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8160 /* vandpd */, X86::VANDPDZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8160 /* vandpd */, X86::VANDPDZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8160 /* vandpd */, X86::VANDPDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8160 /* vandpd */, X86::VANDPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8160 /* vandpd */, X86::VANDPDZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8160 /* vandpd */, X86::VANDPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8160 /* vandpd */, X86::VANDPDZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8160 /* vandpd */, X86::VANDPDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8160 /* vandpd */, X86::VANDPDZ128rmb, Convert__Reg1_3__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 8160 /* vandpd */, X86::VANDPDZ256rmb, Convert__Reg1_3__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 8160 /* vandpd */, X86::VANDPDZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8160 /* vandpd */, X86::VANDPDZ128rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8160 /* vandpd */, X86::VANDPDZ256rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8160 /* vandpd */, X86::VANDPDZrrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8160 /* vandpd */, X86::VANDPDZ128rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8160 /* vandpd */, X86::VANDPDZ256rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8160 /* vandpd */, X86::VANDPDZrmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8160 /* vandpd */, X86::VANDPDZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8160 /* vandpd */, X86::VANDPDZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8160 /* vandpd */, X86::VANDPDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8160 /* vandpd */, X86::VANDPDZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8160 /* vandpd */, X86::VANDPDZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8160 /* vandpd */, X86::VANDPDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8160 /* vandpd */, X86::VANDPDZ128rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8160 /* vandpd */, X86::VANDPDZ256rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8160 /* vandpd */, X86::VANDPDZrmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8160 /* vandpd */, X86::VANDPDZ128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8160 /* vandpd */, X86::VANDPDZ256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8160 /* vandpd */, X86::VANDPDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8167 /* vandps */, X86::VANDPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8167 /* vandps */, X86::VANDPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8167 /* vandps */, X86::VANDPSZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8167 /* vandps */, X86::VANDPSZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8167 /* vandps */, X86::VANDPSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8167 /* vandps */, X86::VANDPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8167 /* vandps */, X86::VANDPSZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8167 /* vandps */, X86::VANDPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8167 /* vandps */, X86::VANDPSZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8167 /* vandps */, X86::VANDPSZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8167 /* vandps */, X86::VANDPSZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 8167 /* vandps */, X86::VANDPSZ128rmb, Convert__Reg1_3__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 8167 /* vandps */, X86::VANDPSZ256rmb, Convert__Reg1_3__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 8167 /* vandps */, X86::VANDPSZ128rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8167 /* vandps */, X86::VANDPSZ256rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8167 /* vandps */, X86::VANDPSZrrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8167 /* vandps */, X86::VANDPSZ128rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8167 /* vandps */, X86::VANDPSZ256rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8167 /* vandps */, X86::VANDPSZrmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8167 /* vandps */, X86::VANDPSZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8167 /* vandps */, X86::VANDPSZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8167 /* vandps */, X86::VANDPSZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8167 /* vandps */, X86::VANDPSZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8167 /* vandps */, X86::VANDPSZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8167 /* vandps */, X86::VANDPSZrmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8167 /* vandps */, X86::VANDPSZ128rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8167 /* vandps */, X86::VANDPSZ256rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8167 /* vandps */, X86::VANDPSZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8167 /* vandps */, X86::VANDPSZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8167 /* vandps */, X86::VANDPSZ128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8167 /* vandps */, X86::VANDPSZ256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8174 /* vblendmpd */, X86::VBLENDMPDZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8174 /* vblendmpd */, X86::VBLENDMPDZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8174 /* vblendmpd */, X86::VBLENDMPDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8174 /* vblendmpd */, X86::VBLENDMPDZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8174 /* vblendmpd */, X86::VBLENDMPDZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8174 /* vblendmpd */, X86::VBLENDMPDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8174 /* vblendmpd */, X86::VBLENDMPDZ128rmb, Convert__Reg1_3__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 8174 /* vblendmpd */, X86::VBLENDMPDZ256rmb, Convert__Reg1_3__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 8174 /* vblendmpd */, X86::VBLENDMPDZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8174 /* vblendmpd */, X86::VBLENDMPDZ128rrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8174 /* vblendmpd */, X86::VBLENDMPDZ256rrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8174 /* vblendmpd */, X86::VBLENDMPDZrrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8174 /* vblendmpd */, X86::VBLENDMPDZ128rmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8174 /* vblendmpd */, X86::VBLENDMPDZ256rmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8174 /* vblendmpd */, X86::VBLENDMPDZrmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8174 /* vblendmpd */, X86::VBLENDMPDZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8174 /* vblendmpd */, X86::VBLENDMPDZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8174 /* vblendmpd */, X86::VBLENDMPDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8174 /* vblendmpd */, X86::VBLENDMPDZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8174 /* vblendmpd */, X86::VBLENDMPDZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8174 /* vblendmpd */, X86::VBLENDMPDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8174 /* vblendmpd */, X86::VBLENDMPDZ128rmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8174 /* vblendmpd */, X86::VBLENDMPDZ256rmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8174 /* vblendmpd */, X86::VBLENDMPDZrmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8174 /* vblendmpd */, X86::VBLENDMPDZ128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8174 /* vblendmpd */, X86::VBLENDMPDZ256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8174 /* vblendmpd */, X86::VBLENDMPDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8184 /* vblendmps */, X86::VBLENDMPSZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8184 /* vblendmps */, X86::VBLENDMPSZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8184 /* vblendmps */, X86::VBLENDMPSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8184 /* vblendmps */, X86::VBLENDMPSZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8184 /* vblendmps */, X86::VBLENDMPSZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8184 /* vblendmps */, X86::VBLENDMPSZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8184 /* vblendmps */, X86::VBLENDMPSZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 8184 /* vblendmps */, X86::VBLENDMPSZ128rmb, Convert__Reg1_3__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 8184 /* vblendmps */, X86::VBLENDMPSZ256rmb, Convert__Reg1_3__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 8184 /* vblendmps */, X86::VBLENDMPSZ128rrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8184 /* vblendmps */, X86::VBLENDMPSZ256rrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8184 /* vblendmps */, X86::VBLENDMPSZrrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8184 /* vblendmps */, X86::VBLENDMPSZ128rmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8184 /* vblendmps */, X86::VBLENDMPSZ256rmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8184 /* vblendmps */, X86::VBLENDMPSZrmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8184 /* vblendmps */, X86::VBLENDMPSZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8184 /* vblendmps */, X86::VBLENDMPSZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8184 /* vblendmps */, X86::VBLENDMPSZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8184 /* vblendmps */, X86::VBLENDMPSZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8184 /* vblendmps */, X86::VBLENDMPSZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8184 /* vblendmps */, X86::VBLENDMPSZrmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8184 /* vblendmps */, X86::VBLENDMPSZ128rmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8184 /* vblendmps */, X86::VBLENDMPSZ256rmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8184 /* vblendmps */, X86::VBLENDMPSZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8184 /* vblendmps */, X86::VBLENDMPSZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8184 /* vblendmps */, X86::VBLENDMPSZ128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8184 /* vblendmps */, X86::VBLENDMPSZ256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8194 /* vblendpd */, X86::VBLENDPDrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8194 /* vblendpd */, X86::VBLENDPDYrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8194 /* vblendpd */, X86::VBLENDPDrmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8194 /* vblendpd */, X86::VBLENDPDYrmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8203 /* vblendps */, X86::VBLENDPSrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8203 /* vblendps */, X86::VBLENDPSYrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8203 /* vblendps */, X86::VBLENDPSrmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8203 /* vblendps */, X86::VBLENDPSYrmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8212 /* vblendvpd */, X86::VBLENDVPDrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8212 /* vblendvpd */, X86::VBLENDVPDrm, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8212 /* vblendvpd */, X86::VBLENDVPDYrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8212 /* vblendvpd */, X86::VBLENDVPDYrm, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8222 /* vblendvps */, X86::VBLENDVPSrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8222 /* vblendvps */, X86::VBLENDVPSrm, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8222 /* vblendvps */, X86::VBLENDVPSYrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8222 /* vblendvps */, X86::VBLENDVPSYrm, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8232 /* vbroadcastf128 */, X86::VBROADCASTF128, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256 }, },
  { 8247 /* vbroadcastf32x2 */, X86::VBROADCASTF32X2Z256r, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_VR256X }, },
  { 8247 /* vbroadcastf32x2 */, X86::VBROADCASTF32X2Zr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_VR512 }, },
  { 8247 /* vbroadcastf32x2 */, X86::VBROADCASTF32X2Z256m, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR256X }, },
  { 8247 /* vbroadcastf32x2 */, X86::VBROADCASTF32X2Zm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR512 }, },
  { 8247 /* vbroadcastf32x2 */, X86::VBROADCASTF32X2Z256rk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8247 /* vbroadcastf32x2 */, X86::VBROADCASTF32X2Zrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8247 /* vbroadcastf32x2 */, X86::VBROADCASTF32X2Z256mk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8247 /* vbroadcastf32x2 */, X86::VBROADCASTF32X2Zmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8247 /* vbroadcastf32x2 */, X86::VBROADCASTF32X2Z256rkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8247 /* vbroadcastf32x2 */, X86::VBROADCASTF32X2Zrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8247 /* vbroadcastf32x2 */, X86::VBROADCASTF32X2Z256mkz, Convert__Reg1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8247 /* vbroadcastf32x2 */, X86::VBROADCASTF32X2Zmkz, Convert__Reg1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8263 /* vbroadcastf32x4 */, X86::VBROADCASTF32X4Z256rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X }, },
  { 8263 /* vbroadcastf32x4 */, X86::VBROADCASTF32X4rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR512 }, },
  { 8263 /* vbroadcastf32x4 */, X86::VBROADCASTF32X4Z256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8263 /* vbroadcastf32x4 */, X86::VBROADCASTF32X4rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8263 /* vbroadcastf32x4 */, X86::VBROADCASTF32X4Z256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8263 /* vbroadcastf32x4 */, X86::VBROADCASTF32X4rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8279 /* vbroadcastf32x8 */, X86::VBROADCASTF32X8rm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR512 }, },
  { 8279 /* vbroadcastf32x8 */, X86::VBROADCASTF32X8rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8279 /* vbroadcastf32x8 */, X86::VBROADCASTF32X8rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8295 /* vbroadcastf64x2 */, X86::VBROADCASTF64X2Z128rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X }, },
  { 8295 /* vbroadcastf64x2 */, X86::VBROADCASTF64X2rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR512 }, },
  { 8295 /* vbroadcastf64x2 */, X86::VBROADCASTF64X2Z128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8295 /* vbroadcastf64x2 */, X86::VBROADCASTF64X2rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8295 /* vbroadcastf64x2 */, X86::VBROADCASTF64X2Z128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8295 /* vbroadcastf64x2 */, X86::VBROADCASTF64X2rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8311 /* vbroadcastf64x4 */, X86::VBROADCASTF64X4rm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR512 }, },
  { 8311 /* vbroadcastf64x4 */, X86::VBROADCASTF64X4rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8311 /* vbroadcastf64x4 */, X86::VBROADCASTF64X4rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8327 /* vbroadcasti128 */, X86::VBROADCASTI128, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256 }, },
  { 8342 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Z128r, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 8342 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Z256r, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_VR256X }, },
  { 8342 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Zr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_VR512 }, },
  { 8342 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Z128m, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X }, },
  { 8342 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Z256m, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR256X }, },
  { 8342 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Zm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR512 }, },
  { 8342 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Z128rk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8342 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Z256rk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8342 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Zrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8342 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Z128mk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8342 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Z256mk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8342 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Zmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8342 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Z128rkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8342 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Z256rkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8342 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Zrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8342 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Z128mkz, Convert__Reg1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8342 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Z256mkz, Convert__Reg1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8342 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Zmkz, Convert__Reg1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8358 /* vbroadcasti32x4 */, X86::VBROADCASTI32X4Z256rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X }, },
  { 8358 /* vbroadcasti32x4 */, X86::VBROADCASTI32X4rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR512 }, },
  { 8358 /* vbroadcasti32x4 */, X86::VBROADCASTI32X4Z256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8358 /* vbroadcasti32x4 */, X86::VBROADCASTI32X4rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8358 /* vbroadcasti32x4 */, X86::VBROADCASTI32X4Z256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8358 /* vbroadcasti32x4 */, X86::VBROADCASTI32X4rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8374 /* vbroadcasti32x8 */, X86::VBROADCASTI32X8rm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR512 }, },
  { 8374 /* vbroadcasti32x8 */, X86::VBROADCASTI32X8rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8374 /* vbroadcasti32x8 */, X86::VBROADCASTI32X8rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8390 /* vbroadcasti64x2 */, X86::VBROADCASTI64X2Z128rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X }, },
  { 8390 /* vbroadcasti64x2 */, X86::VBROADCASTI64X2rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR512 }, },
  { 8390 /* vbroadcasti64x2 */, X86::VBROADCASTI64X2Z128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8390 /* vbroadcasti64x2 */, X86::VBROADCASTI64X2rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8390 /* vbroadcasti64x2 */, X86::VBROADCASTI64X2Z128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8390 /* vbroadcasti64x2 */, X86::VBROADCASTI64X2rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8406 /* vbroadcasti64x4 */, X86::VBROADCASTI64X4rm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR512 }, },
  { 8406 /* vbroadcasti64x4 */, X86::VBROADCASTI64X4rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8406 /* vbroadcasti64x4 */, X86::VBROADCASTI64X4rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8422 /* vbroadcastsd */, X86::VBROADCASTSDYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 8422 /* vbroadcastsd */, X86::VBROADCASTSDZ256r, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_VR256X }, },
  { 8422 /* vbroadcastsd */, X86::VBROADCASTSDZr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_VR512 }, },
  { 8422 /* vbroadcastsd */, X86::VBROADCASTSDYrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR256 }, },
  { 8422 /* vbroadcastsd */, X86::VBROADCASTSDZ256m, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR256X }, },
  { 8422 /* vbroadcastsd */, X86::VBROADCASTSDZm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR512 }, },
  { 8422 /* vbroadcastsd */, X86::VBROADCASTSDZ256rk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8422 /* vbroadcastsd */, X86::VBROADCASTSDZrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8422 /* vbroadcastsd */, X86::VBROADCASTSDZ256mk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8422 /* vbroadcastsd */, X86::VBROADCASTSDZmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8422 /* vbroadcastsd */, X86::VBROADCASTSDZ256rkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8422 /* vbroadcastsd */, X86::VBROADCASTSDZrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8422 /* vbroadcastsd */, X86::VBROADCASTSDZ256mkz, Convert__Reg1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8422 /* vbroadcastsd */, X86::VBROADCASTSDZmkz, Convert__Reg1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8435 /* vbroadcastss */, X86::VBROADCASTSSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 8435 /* vbroadcastss */, X86::VBROADCASTSSYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 8435 /* vbroadcastss */, X86::VBROADCASTSSZ128r, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 8435 /* vbroadcastss */, X86::VBROADCASTSSZ256r, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_VR256X }, },
  { 8435 /* vbroadcastss */, X86::VBROADCASTSSZr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_VR512 }, },
  { 8435 /* vbroadcastss */, X86::VBROADCASTSSrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 8435 /* vbroadcastss */, X86::VBROADCASTSSYrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_VR256 }, },
  { 8435 /* vbroadcastss */, X86::VBROADCASTSSZ128m, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X }, },
  { 8435 /* vbroadcastss */, X86::VBROADCASTSSZ256m, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_VR256X }, },
  { 8435 /* vbroadcastss */, X86::VBROADCASTSSZm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_VR512 }, },
  { 8435 /* vbroadcastss */, X86::VBROADCASTSSZ128rk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8435 /* vbroadcastss */, X86::VBROADCASTSSZ256rk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8435 /* vbroadcastss */, X86::VBROADCASTSSZrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8435 /* vbroadcastss */, X86::VBROADCASTSSZ128mk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8435 /* vbroadcastss */, X86::VBROADCASTSSZ256mk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem325_0, 0, { MCK_Mem32, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8435 /* vbroadcastss */, X86::VBROADCASTSSZmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem325_0, 0, { MCK_Mem32, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8435 /* vbroadcastss */, X86::VBROADCASTSSZ128rkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8435 /* vbroadcastss */, X86::VBROADCASTSSZ256rkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8435 /* vbroadcastss */, X86::VBROADCASTSSZrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8435 /* vbroadcastss */, X86::VBROADCASTSSZ128mkz, Convert__Reg1_1__Reg1_3__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8435 /* vbroadcastss */, X86::VBROADCASTSSZ256mkz, Convert__Reg1_1__Reg1_3__Mem325_0, 0, { MCK_Mem32, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8435 /* vbroadcastss */, X86::VBROADCASTSSZmkz, Convert__Reg1_1__Reg1_3__Mem325_0, 0, { MCK_Mem32, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8448 /* vcmp */, X86::VCMPPDrri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8448 /* vcmp */, X86::VCMPPDYrri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8448 /* vcmp */, X86::VCMPPDZ128rri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_FR32X, MCK_FR32X, MCK_VK1 }, },
  { 8448 /* vcmp */, X86::VCMPPDZ256rri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_VR256X, MCK_VR256X, MCK_VK1 }, },
  { 8448 /* vcmp */, X86::VCMPPDZrri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 8448 /* vcmp */, X86::VCMPPDrmi, Convert__Reg1_4__Reg1_3__Mem1285_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8448 /* vcmp */, X86::VCMPPDZ128rmi, Convert__Reg1_4__Reg1_3__Mem1285_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_Mem128, MCK_FR32X, MCK_VK1 }, },
  { 8448 /* vcmp */, X86::VCMPPDYrmi, Convert__Reg1_4__Reg1_3__Mem2565_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8448 /* vcmp */, X86::VCMPPDZ256rmi, Convert__Reg1_4__Reg1_3__Mem2565_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_Mem256, MCK_VR256X, MCK_VK1 }, },
  { 8448 /* vcmp */, X86::VCMPPDZrmi, Convert__Reg1_4__Reg1_3__Mem5125_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 8448 /* vcmp */, X86::VCMPPSrri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8448 /* vcmp */, X86::VCMPPSYrri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8448 /* vcmp */, X86::VCMPPSZ128rri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_FR32X, MCK_FR32X, MCK_VK1 }, },
  { 8448 /* vcmp */, X86::VCMPPSZ256rri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_VR256X, MCK_VR256X, MCK_VK1 }, },
  { 8448 /* vcmp */, X86::VCMPPSZrri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 8448 /* vcmp */, X86::VCMPPSrmi, Convert__Reg1_4__Reg1_3__Mem1285_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8448 /* vcmp */, X86::VCMPPSZ128rmi, Convert__Reg1_4__Reg1_3__Mem1285_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_Mem128, MCK_FR32X, MCK_VK1 }, },
  { 8448 /* vcmp */, X86::VCMPPSYrmi, Convert__Reg1_4__Reg1_3__Mem2565_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8448 /* vcmp */, X86::VCMPPSZ256rmi, Convert__Reg1_4__Reg1_3__Mem2565_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_Mem256, MCK_VR256X, MCK_VK1 }, },
  { 8448 /* vcmp */, X86::VCMPPSZrmi, Convert__Reg1_4__Reg1_3__Mem5125_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 8448 /* vcmp */, X86::VCMPSDrr, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_sd, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8448 /* vcmp */, X86::VCMPSDZrr_Int, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_sd, MCK_FR32X, MCK_FR32X, MCK_VK1 }, },
  { 8448 /* vcmp */, X86::VCMPSDrm, Convert__Reg1_4__Reg1_3__Mem645_2__Imm1_0, 0, { MCK_Imm, MCK_sd, MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8448 /* vcmp */, X86::VCMPSDZrm_Int, Convert__Reg1_4__Reg1_3__Mem645_2__Imm1_0, 0, { MCK_Imm, MCK_sd, MCK_Mem64, MCK_FR32X, MCK_VK1 }, },
  { 8448 /* vcmp */, X86::VCMPSSrr, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_ss, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8448 /* vcmp */, X86::VCMPSSZrr_Int, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_ss, MCK_FR32X, MCK_FR32X, MCK_VK1 }, },
  { 8448 /* vcmp */, X86::VCMPSSrm, Convert__Reg1_4__Reg1_3__Mem325_2__Imm1_0, 0, { MCK_Imm, MCK_ss, MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8448 /* vcmp */, X86::VCMPSSZrm_Int, Convert__Reg1_4__Reg1_3__Mem325_2__Imm1_0, 0, { MCK_Imm, MCK_ss, MCK_Mem32, MCK_FR32X, MCK_VK1 }, },
  { 8448 /* vcmp */, X86::VCMPPDZrrib, Convert__Reg1_5__Reg1_4__Reg1_3__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 8448 /* vcmp */, X86::VCMPPDZ128rmbi, Convert__Reg1_5__Reg1_4__Mem645_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_VK1 }, },
  { 8448 /* vcmp */, X86::VCMPPDZ256rmbi, Convert__Reg1_5__Reg1_4__Mem645_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VK1 }, },
  { 8448 /* vcmp */, X86::VCMPPDZrmbi, Convert__Reg1_5__Reg1_4__Mem645_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VK1 }, },
  { 8448 /* vcmp */, X86::VCMPPSZrrib, Convert__Reg1_5__Reg1_4__Reg1_3__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 8448 /* vcmp */, X86::VCMPPSZrmbi, Convert__Reg1_5__Reg1_4__Mem325_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VK1 }, },
  { 8448 /* vcmp */, X86::VCMPPSZ128rmbi, Convert__Reg1_5__Reg1_4__Mem325_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_VK1 }, },
  { 8448 /* vcmp */, X86::VCMPPSZ256rmbi, Convert__Reg1_5__Reg1_4__Mem325_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VK1 }, },
  { 8448 /* vcmp */, X86::VCMPSDZrrb_Int, Convert__Reg1_5__Reg1_4__Reg1_3__Imm1_0, 0, { MCK_Imm, MCK_sd, MCK__123_sae_125_, MCK_FR32X, MCK_FR32X, MCK_VK1 }, },
  { 8448 /* vcmp */, X86::VCMPSSZrrb_Int, Convert__Reg1_5__Reg1_4__Reg1_3__Imm1_0, 0, { MCK_Imm, MCK_ss, MCK__123_sae_125_, MCK_FR32X, MCK_FR32X, MCK_VK1 }, },
  { 8448 /* vcmp */, X86::VCMPPDZ128rrik, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_FR32X, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8448 /* vcmp */, X86::VCMPPDZ256rrik, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_VR256X, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8448 /* vcmp */, X86::VCMPPDZrrik, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_VR512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8448 /* vcmp */, X86::VCMPPDZ128rmik, Convert__Reg1_4__Reg1_6__Reg1_3__Mem1285_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_Mem128, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8448 /* vcmp */, X86::VCMPPDZ256rmik, Convert__Reg1_4__Reg1_6__Reg1_3__Mem2565_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_Mem256, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8448 /* vcmp */, X86::VCMPPDZrmik, Convert__Reg1_4__Reg1_6__Reg1_3__Mem5125_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_Mem512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8448 /* vcmp */, X86::VCMPPSZ128rrik, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_FR32X, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8448 /* vcmp */, X86::VCMPPSZ256rrik, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_VR256X, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8448 /* vcmp */, X86::VCMPPSZrrik, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_VR512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8448 /* vcmp */, X86::VCMPPSZ128rmik, Convert__Reg1_4__Reg1_6__Reg1_3__Mem1285_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_Mem128, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8448 /* vcmp */, X86::VCMPPSZ256rmik, Convert__Reg1_4__Reg1_6__Reg1_3__Mem2565_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_Mem256, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8448 /* vcmp */, X86::VCMPPSZrmik, Convert__Reg1_4__Reg1_6__Reg1_3__Mem5125_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_Mem512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8448 /* vcmp */, X86::VCMPSDZrr_Intk, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_sd, MCK_FR32X, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8448 /* vcmp */, X86::VCMPSDZrm_Intk, Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_2__Imm1_0, 0, { MCK_Imm, MCK_sd, MCK_Mem64, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8448 /* vcmp */, X86::VCMPSSZrr_Intk, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_ss, MCK_FR32X, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8448 /* vcmp */, X86::VCMPSSZrm_Intk, Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_2__Imm1_0, 0, { MCK_Imm, MCK_ss, MCK_Mem32, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8448 /* vcmp */, X86::VCMPPDZrribk, Convert__Reg1_5__Reg1_7__Reg1_4__Reg1_3__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8448 /* vcmp */, X86::VCMPPDZ128rmbik, Convert__Reg1_5__Reg1_7__Reg1_4__Mem645_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8448 /* vcmp */, X86::VCMPPDZ256rmbik, Convert__Reg1_5__Reg1_7__Reg1_4__Mem645_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8448 /* vcmp */, X86::VCMPPDZrmbik, Convert__Reg1_5__Reg1_7__Reg1_4__Mem645_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8448 /* vcmp */, X86::VCMPPSZrribk, Convert__Reg1_5__Reg1_7__Reg1_4__Reg1_3__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8448 /* vcmp */, X86::VCMPPSZrmbik, Convert__Reg1_5__Reg1_7__Reg1_4__Mem325_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8448 /* vcmp */, X86::VCMPPSZ128rmbik, Convert__Reg1_5__Reg1_7__Reg1_4__Mem325_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8448 /* vcmp */, X86::VCMPPSZ256rmbik, Convert__Reg1_5__Reg1_7__Reg1_4__Mem325_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8448 /* vcmp */, X86::VCMPSDZrrb_Intk, Convert__Reg1_5__Reg1_7__Reg1_4__Reg1_3__Imm1_0, 0, { MCK_Imm, MCK_sd, MCK__123_sae_125_, MCK_FR32X, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8448 /* vcmp */, X86::VCMPSSZrrb_Intk, Convert__Reg1_5__Reg1_7__Reg1_4__Reg1_3__Imm1_0, 0, { MCK_Imm, MCK_ss, MCK__123_sae_125_, MCK_FR32X, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8453 /* vcmppd */, X86::VCMPPDrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8453 /* vcmppd */, X86::VCMPPDYrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8453 /* vcmppd */, X86::VCMPPDZ128rri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_VK1 }, },
  { 8453 /* vcmppd */, X86::VCMPPDZ256rri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VK1 }, },
  { 8453 /* vcmppd */, X86::VCMPPDZrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 8453 /* vcmppd */, X86::VCMPPDrmi_alt, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8453 /* vcmppd */, X86::VCMPPDZ128rmi_alt, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_VK1 }, },
  { 8453 /* vcmppd */, X86::VCMPPDYrmi_alt, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8453 /* vcmppd */, X86::VCMPPDZ256rmi_alt, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VK1 }, },
  { 8453 /* vcmppd */, X86::VCMPPDZrmi_alt, Convert__Reg1_3__Reg1_2__Mem5125_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 8453 /* vcmppd */, X86::VCMPPDZrrib_alt, Convert__Reg1_4__Reg1_3__Reg1_2__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 8453 /* vcmppd */, X86::VCMPPDZ128rmbi_alt, Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_VK1 }, },
  { 8453 /* vcmppd */, X86::VCMPPDZ256rmbi_alt, Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VK1 }, },
  { 8453 /* vcmppd */, X86::VCMPPDZrmbi_alt, Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VK1 }, },
  { 8453 /* vcmppd */, X86::VCMPPDZ128rri_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8453 /* vcmppd */, X86::VCMPPDZ256rri_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8453 /* vcmppd */, X86::VCMPPDZrri_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8453 /* vcmppd */, X86::VCMPPDZ128rmi_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8453 /* vcmppd */, X86::VCMPPDZ256rmi_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8453 /* vcmppd */, X86::VCMPPDZrmi_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8453 /* vcmppd */, X86::VCMPPDZrrib_altk, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8453 /* vcmppd */, X86::VCMPPDZ128rmbi_altk, Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8453 /* vcmppd */, X86::VCMPPDZ256rmbi_altk, Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8453 /* vcmppd */, X86::VCMPPDZrmbi_altk, Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8460 /* vcmpps */, X86::VCMPPSrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8460 /* vcmpps */, X86::VCMPPSYrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8460 /* vcmpps */, X86::VCMPPSZ128rri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_VK1 }, },
  { 8460 /* vcmpps */, X86::VCMPPSZ256rri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VK1 }, },
  { 8460 /* vcmpps */, X86::VCMPPSZrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 8460 /* vcmpps */, X86::VCMPPSrmi_alt, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8460 /* vcmpps */, X86::VCMPPSZ128rmi_alt, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_VK1 }, },
  { 8460 /* vcmpps */, X86::VCMPPSYrmi_alt, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8460 /* vcmpps */, X86::VCMPPSZ256rmi_alt, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VK1 }, },
  { 8460 /* vcmpps */, X86::VCMPPSZrmi_alt, Convert__Reg1_3__Reg1_2__Mem5125_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 8460 /* vcmpps */, X86::VCMPPSZrrib_alt, Convert__Reg1_4__Reg1_3__Reg1_2__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 8460 /* vcmpps */, X86::VCMPPSZrmbi_alt, Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VK1 }, },
  { 8460 /* vcmpps */, X86::VCMPPSZ128rmbi_alt, Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_VK1 }, },
  { 8460 /* vcmpps */, X86::VCMPPSZ256rmbi_alt, Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VK1 }, },
  { 8460 /* vcmpps */, X86::VCMPPSZ128rri_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8460 /* vcmpps */, X86::VCMPPSZ256rri_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8460 /* vcmpps */, X86::VCMPPSZrri_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8460 /* vcmpps */, X86::VCMPPSZ128rmi_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8460 /* vcmpps */, X86::VCMPPSZ256rmi_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8460 /* vcmpps */, X86::VCMPPSZrmi_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8460 /* vcmpps */, X86::VCMPPSZrrib_altk, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8460 /* vcmpps */, X86::VCMPPSZrmbi_altk, Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8460 /* vcmpps */, X86::VCMPPSZ128rmbi_altk, Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8460 /* vcmpps */, X86::VCMPPSZ256rmbi_altk, Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8467 /* vcmpsd */, X86::VCMPSDrr_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8467 /* vcmpsd */, X86::VCMPSDZrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_VK1 }, },
  { 8467 /* vcmpsd */, X86::VCMPSDrm_alt, Convert__Reg1_3__Reg1_2__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8467 /* vcmpsd */, X86::VCMPSDZrmi_alt, Convert__Reg1_3__Reg1_2__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_FR32X, MCK_VK1 }, },
  { 8467 /* vcmpsd */, X86::VCMPSDZrrb_alt, Convert__Reg1_4__Reg1_3__Reg1_2__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_FR32X, MCK_FR32X, MCK_VK1 }, },
  { 8467 /* vcmpsd */, X86::VCMPSDZrri_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8467 /* vcmpsd */, X86::VCMPSDZrmi_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8467 /* vcmpsd */, X86::VCMPSDZrrb_altk, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_FR32X, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8474 /* vcmpss */, X86::VCMPSSrr_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8474 /* vcmpss */, X86::VCMPSSZrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_VK1 }, },
  { 8474 /* vcmpss */, X86::VCMPSSrm_alt, Convert__Reg1_3__Reg1_2__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8474 /* vcmpss */, X86::VCMPSSZrmi_alt, Convert__Reg1_3__Reg1_2__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_FR32X, MCK_VK1 }, },
  { 8474 /* vcmpss */, X86::VCMPSSZrrb_alt, Convert__Reg1_4__Reg1_3__Reg1_2__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_FR32X, MCK_FR32X, MCK_VK1 }, },
  { 8474 /* vcmpss */, X86::VCMPSSZrri_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8474 /* vcmpss */, X86::VCMPSSZrmi_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8474 /* vcmpss */, X86::VCMPSSZrrb_altk, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_FR32X, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8481 /* vcomisd */, X86::VCOMISDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 8481 /* vcomisd */, X86::VCOMISDZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 8481 /* vcomisd */, X86::VCOMISDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 8481 /* vcomisd */, X86::VCOMISDZrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X }, },
  { 8481 /* vcomisd */, X86::VCOMISDZrrb, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_FR32X, MCK_FR32X }, },
  { 8489 /* vcomiss */, X86::VCOMISSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 8489 /* vcomiss */, X86::VCOMISSZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 8489 /* vcomiss */, X86::VCOMISSrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 8489 /* vcomiss */, X86::VCOMISSZrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X }, },
  { 8489 /* vcomiss */, X86::VCOMISSZrrb, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_FR32X, MCK_FR32X }, },
  { 8497 /* vcompresspd */, X86::VCOMPRESSPDZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 8497 /* vcompresspd */, X86::VCOMPRESSPDZ128mr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32X, MCK_Mem128 }, },
  { 8497 /* vcompresspd */, X86::VCOMPRESSPDZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X }, },
  { 8497 /* vcompresspd */, X86::VCOMPRESSPDZ256mr, Convert__Mem2565_1__Reg1_0, 0, { MCK_VR256X, MCK_Mem256 }, },
  { 8497 /* vcompresspd */, X86::VCOMPRESSPDZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512 }, },
  { 8497 /* vcompresspd */, X86::VCOMPRESSPDZmr, Convert__Mem5125_1__Reg1_0, 0, { MCK_VR512, MCK_Mem512 }, },
  { 8497 /* vcompresspd */, X86::VCOMPRESSPDZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8497 /* vcompresspd */, X86::VCOMPRESSPDZ128mrk, Convert__Mem1285_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_Mem128, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8497 /* vcompresspd */, X86::VCOMPRESSPDZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8497 /* vcompresspd */, X86::VCOMPRESSPDZ256mrk, Convert__Mem2565_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_Mem256, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8497 /* vcompresspd */, X86::VCOMPRESSPDZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8497 /* vcompresspd */, X86::VCOMPRESSPDZmrk, Convert__Mem5125_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_Mem512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8497 /* vcompresspd */, X86::VCOMPRESSPDZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8497 /* vcompresspd */, X86::VCOMPRESSPDZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8497 /* vcompresspd */, X86::VCOMPRESSPDZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8509 /* vcompressps */, X86::VCOMPRESSPSZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 8509 /* vcompressps */, X86::VCOMPRESSPSZ128mr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32X, MCK_Mem128 }, },
  { 8509 /* vcompressps */, X86::VCOMPRESSPSZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X }, },
  { 8509 /* vcompressps */, X86::VCOMPRESSPSZ256mr, Convert__Mem2565_1__Reg1_0, 0, { MCK_VR256X, MCK_Mem256 }, },
  { 8509 /* vcompressps */, X86::VCOMPRESSPSZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512 }, },
  { 8509 /* vcompressps */, X86::VCOMPRESSPSZmr, Convert__Mem5125_1__Reg1_0, 0, { MCK_VR512, MCK_Mem512 }, },
  { 8509 /* vcompressps */, X86::VCOMPRESSPSZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8509 /* vcompressps */, X86::VCOMPRESSPSZ128mrk, Convert__Mem1285_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_Mem128, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8509 /* vcompressps */, X86::VCOMPRESSPSZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8509 /* vcompressps */, X86::VCOMPRESSPSZ256mrk, Convert__Mem2565_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_Mem256, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8509 /* vcompressps */, X86::VCOMPRESSPSZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8509 /* vcompressps */, X86::VCOMPRESSPSZmrk, Convert__Mem5125_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_Mem512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8509 /* vcompressps */, X86::VCOMPRESSPSZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8509 /* vcompressps */, X86::VCOMPRESSPSZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8509 /* vcompressps */, X86::VCOMPRESSPSZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_VR256X }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR512 }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDYrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256 }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDZ256rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDZrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR512 }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDZ128rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDZ128rmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR32X }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDZ256rmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDZrmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512 }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDZ256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDZrmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDZ128rmkz, Convert__Reg1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8521 /* vcvtdq2pd */, X86::VCVTDQ2PDZrmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512 }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZ128rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZ256rm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZrm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512 }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512 }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZrmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512 }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZ128rmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZ256rmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZrmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8531 /* vcvtdq2ps */, X86::VCVTDQ2PSZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8541 /* vcvtpd2dq */, X86::VCVTPD2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 8541 /* vcvtpd2dq */, X86::VCVTPD2DQYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_FR32 }, },
  { 8541 /* vcvtpd2dq */, X86::VCVTPD2DQZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 8541 /* vcvtpd2dq */, X86::VCVTPD2DQZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_FR32X }, },
  { 8541 /* vcvtpd2dq */, X86::VCVTPD2DQZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR256X }, },
  { 8541 /* vcvtpd2dq */, X86::VCVTPD2DQZrm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR256X }, },
  { 8541 /* vcvtpd2dq */, X86::VCVTPD2DQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR256X }, },
  { 8541 /* vcvtpd2dq */, X86::VCVTPD2DQZ128rmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X }, },
  { 8541 /* vcvtpd2dq */, X86::VCVTPD2DQZ256rmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR32X }, },
  { 8541 /* vcvtpd2dq */, X86::VCVTPD2DQZrmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X }, },
  { 8541 /* vcvtpd2dq */, X86::VCVTPD2DQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8541 /* vcvtpd2dq */, X86::VCVTPD2DQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8541 /* vcvtpd2dq */, X86::VCVTPD2DQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8541 /* vcvtpd2dq */, X86::VCVTPD2DQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8541 /* vcvtpd2dq */, X86::VCVTPD2DQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8541 /* vcvtpd2dq */, X86::VCVTPD2DQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8541 /* vcvtpd2dq */, X86::VCVTPD2DQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8541 /* vcvtpd2dq */, X86::VCVTPD2DQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8541 /* vcvtpd2dq */, X86::VCVTPD2DQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8541 /* vcvtpd2dq */, X86::VCVTPD2DQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8541 /* vcvtpd2dq */, X86::VCVTPD2DQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8541 /* vcvtpd2dq */, X86::VCVTPD2DQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8541 /* vcvtpd2dq */, X86::VCVTPD2DQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8541 /* vcvtpd2dq */, X86::VCVTPD2DQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8541 /* vcvtpd2dq */, X86::VCVTPD2DQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8541 /* vcvtpd2dq */, X86::VCVTPD2DQZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8551 /* vcvtpd2dqx */, X86::VCVTPD2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 8551 /* vcvtpd2dqx */, X86::VCVTPD2DQZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 8551 /* vcvtpd2dqx */, X86::VCVTPD2DQrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 8551 /* vcvtpd2dqx */, X86::VCVTPD2DQZ128rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X }, },
  { 8551 /* vcvtpd2dqx */, X86::VCVTPD2DQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8551 /* vcvtpd2dqx */, X86::VCVTPD2DQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8562 /* vcvtpd2dqy */, X86::VCVTPD2DQYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_FR32 }, },
  { 8562 /* vcvtpd2dqy */, X86::VCVTPD2DQZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_FR32X }, },
  { 8562 /* vcvtpd2dqy */, X86::VCVTPD2DQYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_FR32 }, },
  { 8562 /* vcvtpd2dqy */, X86::VCVTPD2DQZ256rm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_FR32X }, },
  { 8562 /* vcvtpd2dqy */, X86::VCVTPD2DQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8562 /* vcvtpd2dqy */, X86::VCVTPD2DQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8573 /* vcvtpd2ps */, X86::VCVTPD2PSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 8573 /* vcvtpd2ps */, X86::VCVTPD2PSYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_FR32 }, },
  { 8573 /* vcvtpd2ps */, X86::VCVTPD2PSZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 8573 /* vcvtpd2ps */, X86::VCVTPD2PSZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_FR32X }, },
  { 8573 /* vcvtpd2ps */, X86::VCVTPD2PSZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR256X }, },
  { 8573 /* vcvtpd2ps */, X86::VCVTPD2PSZrm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR256X }, },
  { 8573 /* vcvtpd2ps */, X86::VCVTPD2PSZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR256X }, },
  { 8573 /* vcvtpd2ps */, X86::VCVTPD2PSZ128rmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X }, },
  { 8573 /* vcvtpd2ps */, X86::VCVTPD2PSZ256rmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR32X }, },
  { 8573 /* vcvtpd2ps */, X86::VCVTPD2PSZrmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X }, },
  { 8573 /* vcvtpd2ps */, X86::VCVTPD2PSZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8573 /* vcvtpd2ps */, X86::VCVTPD2PSZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8573 /* vcvtpd2ps */, X86::VCVTPD2PSZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8573 /* vcvtpd2ps */, X86::VCVTPD2PSZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8573 /* vcvtpd2ps */, X86::VCVTPD2PSZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8573 /* vcvtpd2ps */, X86::VCVTPD2PSZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8573 /* vcvtpd2ps */, X86::VCVTPD2PSZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8573 /* vcvtpd2ps */, X86::VCVTPD2PSZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8573 /* vcvtpd2ps */, X86::VCVTPD2PSZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8573 /* vcvtpd2ps */, X86::VCVTPD2PSZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8573 /* vcvtpd2ps */, X86::VCVTPD2PSZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8573 /* vcvtpd2ps */, X86::VCVTPD2PSZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8573 /* vcvtpd2ps */, X86::VCVTPD2PSZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8573 /* vcvtpd2ps */, X86::VCVTPD2PSZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8573 /* vcvtpd2ps */, X86::VCVTPD2PSZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8573 /* vcvtpd2ps */, X86::VCVTPD2PSZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8583 /* vcvtpd2psx */, X86::VCVTPD2PSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 8583 /* vcvtpd2psx */, X86::VCVTPD2PSZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 8583 /* vcvtpd2psx */, X86::VCVTPD2PSrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 8583 /* vcvtpd2psx */, X86::VCVTPD2PSZ128rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X }, },
  { 8583 /* vcvtpd2psx */, X86::VCVTPD2PSZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8583 /* vcvtpd2psx */, X86::VCVTPD2PSZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8594 /* vcvtpd2psy */, X86::VCVTPD2PSYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_FR32 }, },
  { 8594 /* vcvtpd2psy */, X86::VCVTPD2PSZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_FR32X }, },
  { 8594 /* vcvtpd2psy */, X86::VCVTPD2PSYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_FR32 }, },
  { 8594 /* vcvtpd2psy */, X86::VCVTPD2PSZ256rm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_FR32X }, },
  { 8594 /* vcvtpd2psy */, X86::VCVTPD2PSZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8594 /* vcvtpd2psy */, X86::VCVTPD2PSZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512 }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZ128rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZ256rm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZrm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512 }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512 }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZ128rmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZ256rmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZrmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512 }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8605 /* vcvtpd2qq */, X86::VCVTPD2QQZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8615 /* vcvtpd2udq */, X86::VCVTPD2UDQZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 8615 /* vcvtpd2udq */, X86::VCVTPD2UDQZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_FR32X }, },
  { 8615 /* vcvtpd2udq */, X86::VCVTPD2UDQZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR256X }, },
  { 8615 /* vcvtpd2udq */, X86::VCVTPD2UDQZrm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR256X }, },
  { 8615 /* vcvtpd2udq */, X86::VCVTPD2UDQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR256X }, },
  { 8615 /* vcvtpd2udq */, X86::VCVTPD2UDQZ128rmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X }, },
  { 8615 /* vcvtpd2udq */, X86::VCVTPD2UDQZ256rmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR32X }, },
  { 8615 /* vcvtpd2udq */, X86::VCVTPD2UDQZrmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X }, },
  { 8615 /* vcvtpd2udq */, X86::VCVTPD2UDQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8615 /* vcvtpd2udq */, X86::VCVTPD2UDQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8615 /* vcvtpd2udq */, X86::VCVTPD2UDQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8615 /* vcvtpd2udq */, X86::VCVTPD2UDQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8615 /* vcvtpd2udq */, X86::VCVTPD2UDQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8615 /* vcvtpd2udq */, X86::VCVTPD2UDQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8615 /* vcvtpd2udq */, X86::VCVTPD2UDQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8615 /* vcvtpd2udq */, X86::VCVTPD2UDQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8615 /* vcvtpd2udq */, X86::VCVTPD2UDQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8615 /* vcvtpd2udq */, X86::VCVTPD2UDQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8615 /* vcvtpd2udq */, X86::VCVTPD2UDQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8615 /* vcvtpd2udq */, X86::VCVTPD2UDQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8615 /* vcvtpd2udq */, X86::VCVTPD2UDQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8615 /* vcvtpd2udq */, X86::VCVTPD2UDQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8615 /* vcvtpd2udq */, X86::VCVTPD2UDQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8615 /* vcvtpd2udq */, X86::VCVTPD2UDQZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8626 /* vcvtpd2udqx */, X86::VCVTPD2UDQZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 8626 /* vcvtpd2udqx */, X86::VCVTPD2UDQZ128rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X }, },
  { 8626 /* vcvtpd2udqx */, X86::VCVTPD2UDQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8626 /* vcvtpd2udqx */, X86::VCVTPD2UDQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8638 /* vcvtpd2udqy */, X86::VCVTPD2UDQZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_FR32X }, },
  { 8638 /* vcvtpd2udqy */, X86::VCVTPD2UDQZ256rm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_FR32X }, },
  { 8638 /* vcvtpd2udqy */, X86::VCVTPD2UDQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8638 /* vcvtpd2udqy */, X86::VCVTPD2UDQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512 }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ128rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ256rm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512 }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512 }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ128rmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ256rmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512 }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8650 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8661 /* vcvtph2ps */, X86::VCVTPH2PSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 8661 /* vcvtph2ps */, X86::VCVTPH2PSYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 8661 /* vcvtph2ps */, X86::VCVTPH2PSZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 8661 /* vcvtph2ps */, X86::VCVTPH2PSZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_VR256X }, },
  { 8661 /* vcvtph2ps */, X86::VCVTPH2PSZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR512 }, },
  { 8661 /* vcvtph2ps */, X86::VCVTPH2PSYrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256 }, },
  { 8661 /* vcvtph2ps */, X86::VCVTPH2PSZ256rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X }, },
  { 8661 /* vcvtph2ps */, X86::VCVTPH2PSZrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR512 }, },
  { 8661 /* vcvtph2ps */, X86::VCVTPH2PSrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 8661 /* vcvtph2ps */, X86::VCVTPH2PSZ128rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X }, },
  { 8661 /* vcvtph2ps */, X86::VCVTPH2PSZrrb, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512 }, },
  { 8661 /* vcvtph2ps */, X86::VCVTPH2PSZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8661 /* vcvtph2ps */, X86::VCVTPH2PSZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8661 /* vcvtph2ps */, X86::VCVTPH2PSZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8661 /* vcvtph2ps */, X86::VCVTPH2PSZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8661 /* vcvtph2ps */, X86::VCVTPH2PSZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8661 /* vcvtph2ps */, X86::VCVTPH2PSZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8661 /* vcvtph2ps */, X86::VCVTPH2PSZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8661 /* vcvtph2ps */, X86::VCVTPH2PSZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8661 /* vcvtph2ps */, X86::VCVTPH2PSZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8661 /* vcvtph2ps */, X86::VCVTPH2PSZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8661 /* vcvtph2ps */, X86::VCVTPH2PSZ256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8661 /* vcvtph2ps */, X86::VCVTPH2PSZrmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8661 /* vcvtph2ps */, X86::VCVTPH2PSZ128rmkz, Convert__Reg1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8661 /* vcvtph2ps */, X86::VCVTPH2PSZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512 }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZ128rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZ256rm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZrm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512 }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512 }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZrmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512 }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZ128rmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZ256rmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZrmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8671 /* vcvtps2dq */, X86::VCVTPS2DQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_VR256X }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR512 }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDYrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256 }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZ256rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR512 }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZ128rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZrrb, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512 }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZ128rmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR32X }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZ256rmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZrmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512 }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZ256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZrmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZ128rmkz, Convert__Reg1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8681 /* vcvtps2pd */, X86::VCVTPS2PDZrmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8691 /* vcvtps2ph */, X86::VCVTPS2PHrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 8691 /* vcvtps2ph */, X86::VCVTPS2PHmr, Convert__Mem645_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_Mem64 }, },
  { 8691 /* vcvtps2ph */, X86::VCVTPS2PHYrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256, MCK_FR32 }, },
  { 8691 /* vcvtps2ph */, X86::VCVTPS2PHYmr, Convert__Mem1285_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256, MCK_Mem128 }, },
  { 8691 /* vcvtps2ph */, X86::VCVTPS2PHZ128rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X }, },
  { 8691 /* vcvtps2ph */, X86::VCVTPS2PHZ128mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_Mem64 }, },
  { 8691 /* vcvtps2ph */, X86::VCVTPS2PHZ256rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_FR32X }, },
  { 8691 /* vcvtps2ph */, X86::VCVTPS2PHZ256mr, Convert__Mem1285_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_Mem128 }, },
  { 8691 /* vcvtps2ph */, X86::VCVTPS2PHZrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR256X }, },
  { 8691 /* vcvtps2ph */, X86::VCVTPS2PHZmr, Convert__Mem2565_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_Mem256 }, },
  { 8691 /* vcvtps2ph */, X86::VCVTPS2PHZrrb, Convert__Reg1_3__Reg1_2__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR256X }, },
  { 8691 /* vcvtps2ph */, X86::VCVTPS2PHZ128rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8691 /* vcvtps2ph */, X86::VCVTPS2PHZ128mrk, Convert__Mem645_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_Mem64, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8691 /* vcvtps2ph */, X86::VCVTPS2PHZ256rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8691 /* vcvtps2ph */, X86::VCVTPS2PHZ256mrk, Convert__Mem1285_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_Mem128, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8691 /* vcvtps2ph */, X86::VCVTPS2PHZrrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8691 /* vcvtps2ph */, X86::VCVTPS2PHZmrk, Convert__Mem2565_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_Mem256, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8691 /* vcvtps2ph */, X86::VCVTPS2PHZrrbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8691 /* vcvtps2ph */, X86::VCVTPS2PHZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8691 /* vcvtps2ph */, X86::VCVTPS2PHZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8691 /* vcvtps2ph */, X86::VCVTPS2PHZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8691 /* vcvtps2ph */, X86::VCVTPS2PHZrrbkz, Convert__Reg1_3__Reg1_5__Reg1_2__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_VR256X }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR512 }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZ256rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR512 }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZ128rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR256X, MCK_VR512 }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZ128rmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR32X }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZ256rmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZrmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512 }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZrmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8701 /* vcvtps2qq */, X86::VCVTPS2QQZrmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512 }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZ128rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZ256rm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZrm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512 }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512 }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZrmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512 }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZ128rmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZ256rmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZrmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8711 /* vcvtps2udq */, X86::VCVTPS2UDQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_VR256X }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR512 }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZ256rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR512 }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZ128rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR256X, MCK_VR512 }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZ128rmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR32X }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZ256rmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZrmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512 }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZrmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8722 /* vcvtps2uqq */, X86::VCVTPS2UQQZrmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512 }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZ128rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZ256rm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZrm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512 }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512 }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZ128rmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZ256rmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZrmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512 }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8733 /* vcvtqq2pd */, X86::VCVTQQ2PDZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8743 /* vcvtqq2ps */, X86::VCVTQQ2PSZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 8743 /* vcvtqq2ps */, X86::VCVTQQ2PSZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_FR32X }, },
  { 8743 /* vcvtqq2ps */, X86::VCVTQQ2PSZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR256X }, },
  { 8743 /* vcvtqq2ps */, X86::VCVTQQ2PSZrm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR256X }, },
  { 8743 /* vcvtqq2ps */, X86::VCVTQQ2PSZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR256X }, },
  { 8743 /* vcvtqq2ps */, X86::VCVTQQ2PSZ128rmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X }, },
  { 8743 /* vcvtqq2ps */, X86::VCVTQQ2PSZ256rmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR32X }, },
  { 8743 /* vcvtqq2ps */, X86::VCVTQQ2PSZrmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X }, },
  { 8743 /* vcvtqq2ps */, X86::VCVTQQ2PSZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8743 /* vcvtqq2ps */, X86::VCVTQQ2PSZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8743 /* vcvtqq2ps */, X86::VCVTQQ2PSZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8743 /* vcvtqq2ps */, X86::VCVTQQ2PSZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8743 /* vcvtqq2ps */, X86::VCVTQQ2PSZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8743 /* vcvtqq2ps */, X86::VCVTQQ2PSZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8743 /* vcvtqq2ps */, X86::VCVTQQ2PSZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8743 /* vcvtqq2ps */, X86::VCVTQQ2PSZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8743 /* vcvtqq2ps */, X86::VCVTQQ2PSZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8743 /* vcvtqq2ps */, X86::VCVTQQ2PSZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8743 /* vcvtqq2ps */, X86::VCVTQQ2PSZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8743 /* vcvtqq2ps */, X86::VCVTQQ2PSZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8743 /* vcvtqq2ps */, X86::VCVTQQ2PSZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8743 /* vcvtqq2ps */, X86::VCVTQQ2PSZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8743 /* vcvtqq2ps */, X86::VCVTQQ2PSZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8743 /* vcvtqq2ps */, X86::VCVTQQ2PSZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8753 /* vcvtqq2psx */, X86::VCVTQQ2PSZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 8753 /* vcvtqq2psx */, X86::VCVTQQ2PSZ128rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X }, },
  { 8753 /* vcvtqq2psx */, X86::VCVTQQ2PSZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8753 /* vcvtqq2psx */, X86::VCVTQQ2PSZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8764 /* vcvtqq2psy */, X86::VCVTQQ2PSZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_FR32X }, },
  { 8764 /* vcvtqq2psy */, X86::VCVTQQ2PSZ256rm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_FR32X }, },
  { 8764 /* vcvtqq2psy */, X86::VCVTQQ2PSZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8764 /* vcvtqq2psy */, X86::VCVTQQ2PSZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8775 /* vcvtsd2si */, X86::VCVTSD2SIrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 8775 /* vcvtsd2si */, X86::VCVTSD2SI64rr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 8775 /* vcvtsd2si */, X86::VCVTSD2SIZrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR32 }, },
  { 8775 /* vcvtsd2si */, X86::VCVTSD2SI64Zrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR64 }, },
  { 8775 /* vcvtsd2si */, X86::VCVTSD2SIrm_Int, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 8775 /* vcvtsd2si */, X86::VCVTSD2SI64rm_Int, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 8775 /* vcvtsd2si */, X86::VCVTSD2SIZrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_GR32 }, },
  { 8775 /* vcvtsd2si */, X86::VCVTSD2SI64Zrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_GR64 }, },
  { 8785 /* vcvtsd2sil */, X86::VCVTSD2SIrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 8785 /* vcvtsd2sil */, X86::VCVTSD2SIZrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR32 }, },
  { 8785 /* vcvtsd2sil */, X86::VCVTSD2SIrm_Int, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 8785 /* vcvtsd2sil */, X86::VCVTSD2SIZrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_GR32 }, },
  { 8796 /* vcvtsd2siq */, X86::VCVTSD2SI64rr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 8796 /* vcvtsd2siq */, X86::VCVTSD2SI64Zrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR64 }, },
  { 8796 /* vcvtsd2siq */, X86::VCVTSD2SI64rm_Int, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 8796 /* vcvtsd2siq */, X86::VCVTSD2SI64Zrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_GR64 }, },
  { 8807 /* vcvtsd2ss */, X86::VCVTSD2SSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8807 /* vcvtsd2ss */, X86::VCVTSD2SSZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8807 /* vcvtsd2ss */, X86::VCVTSD2SSrm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8807 /* vcvtsd2ss */, X86::VCVTSD2SSZrm_Int, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 8807 /* vcvtsd2ss */, X86::VCVTSD2SSZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8807 /* vcvtsd2ss */, X86::VCVTSD2SSZrr_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8807 /* vcvtsd2ss */, X86::VCVTSD2SSZrm_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8807 /* vcvtsd2ss */, X86::VCVTSD2SSZrr_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8807 /* vcvtsd2ss */, X86::VCVTSD2SSZrrb_Intk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8807 /* vcvtsd2ss */, X86::VCVTSD2SSZrm_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8807 /* vcvtsd2ss */, X86::VCVTSD2SSZrrb_Intkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8817 /* vcvtsd2usi */, X86::VCVTSD2USIZrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR32 }, },
  { 8817 /* vcvtsd2usi */, X86::VCVTSD2USI64Zrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR64 }, },
  { 8817 /* vcvtsd2usi */, X86::VCVTSD2USIZrm_Int, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 8817 /* vcvtsd2usi */, X86::VCVTSD2USI64Zrm_Int, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 8817 /* vcvtsd2usi */, X86::VCVTSD2USIZrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_GR32 }, },
  { 8817 /* vcvtsd2usi */, X86::VCVTSD2USI64Zrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_GR64 }, },
  { 8828 /* vcvtsd2usil */, X86::VCVTSD2USIZrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR32 }, },
  { 8828 /* vcvtsd2usil */, X86::VCVTSD2USIZrm_Int, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 8828 /* vcvtsd2usil */, X86::VCVTSD2USIZrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_GR32 }, },
  { 8840 /* vcvtsd2usiq */, X86::VCVTSD2USI64Zrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR64 }, },
  { 8840 /* vcvtsd2usiq */, X86::VCVTSD2USI64Zrm_Int, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 8840 /* vcvtsd2usiq */, X86::VCVTSD2USI64Zrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_GR64 }, },
  { 8852 /* vcvtsi2sd */, X86::VCVTSI2SDrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8852 /* vcvtsi2sd */, X86::VCVTSI2SDZrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 8862 /* vcvtsi2sdl */, X86::VCVTSI2SDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_FR32, MCK_FR32 }, },
  { 8862 /* vcvtsi2sdl */, X86::VCVTSI2SDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_FR32X, MCK_FR32X }, },
  { 8862 /* vcvtsi2sdl */, X86::VCVTSI2SDrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8862 /* vcvtsi2sdl */, X86::VCVTSI2SDZrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 8862 /* vcvtsi2sdl */, X86::VCVTSI2SDZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1, 0, { MCK_GR32, MCK_AVX512RC, MCK_FR32X, MCK_FR32X }, },
  { 8873 /* vcvtsi2sdq */, X86::VCVTSI642SDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_FR32, MCK_FR32 }, },
  { 8873 /* vcvtsi2sdq */, X86::VCVTSI642SDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_FR32X, MCK_FR32X }, },
  { 8873 /* vcvtsi2sdq */, X86::VCVTSI642SDrm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8873 /* vcvtsi2sdq */, X86::VCVTSI642SDZrm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 8873 /* vcvtsi2sdq */, X86::VCVTSI642SDZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1, 0, { MCK_GR64, MCK_AVX512RC, MCK_FR32X, MCK_FR32X }, },
  { 8884 /* vcvtsi2ss */, X86::VCVTSI2SSrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8884 /* vcvtsi2ss */, X86::VCVTSI2SSZrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 8894 /* vcvtsi2ssl */, X86::VCVTSI2SSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_FR32, MCK_FR32 }, },
  { 8894 /* vcvtsi2ssl */, X86::VCVTSI2SSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_FR32X, MCK_FR32X }, },
  { 8894 /* vcvtsi2ssl */, X86::VCVTSI2SSrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8894 /* vcvtsi2ssl */, X86::VCVTSI2SSZrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 8894 /* vcvtsi2ssl */, X86::VCVTSI2SSZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1, 0, { MCK_GR32, MCK_AVX512RC, MCK_FR32X, MCK_FR32X }, },
  { 8905 /* vcvtsi2ssq */, X86::VCVTSI642SSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_FR32, MCK_FR32 }, },
  { 8905 /* vcvtsi2ssq */, X86::VCVTSI642SSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_FR32X, MCK_FR32X }, },
  { 8905 /* vcvtsi2ssq */, X86::VCVTSI642SSrm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8905 /* vcvtsi2ssq */, X86::VCVTSI642SSZrm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 8905 /* vcvtsi2ssq */, X86::VCVTSI642SSZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1, 0, { MCK_GR64, MCK_AVX512RC, MCK_FR32X, MCK_FR32X }, },
  { 8916 /* vcvtss2sd */, X86::VCVTSS2SDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8916 /* vcvtss2sd */, X86::VCVTSS2SDZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8916 /* vcvtss2sd */, X86::VCVTSS2SDrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8916 /* vcvtss2sd */, X86::VCVTSS2SDZrm_Int, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 8916 /* vcvtss2sd */, X86::VCVTSS2SDZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8916 /* vcvtss2sd */, X86::VCVTSS2SDZrr_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8916 /* vcvtss2sd */, X86::VCVTSS2SDZrm_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8916 /* vcvtss2sd */, X86::VCVTSS2SDZrrb_Intk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8916 /* vcvtss2sd */, X86::VCVTSS2SDZrr_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8916 /* vcvtss2sd */, X86::VCVTSS2SDZrm_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8916 /* vcvtss2sd */, X86::VCVTSS2SDZrrb_Intkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8926 /* vcvtss2si */, X86::VCVTSS2SIrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 8926 /* vcvtss2si */, X86::VCVTSS2SI64rr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 8926 /* vcvtss2si */, X86::VCVTSS2SIZrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR32 }, },
  { 8926 /* vcvtss2si */, X86::VCVTSS2SI64Zrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR64 }, },
  { 8926 /* vcvtss2si */, X86::VCVTSS2SIrm_Int, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 8926 /* vcvtss2si */, X86::VCVTSS2SI64rm_Int, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 8926 /* vcvtss2si */, X86::VCVTSS2SIZrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_GR32 }, },
  { 8926 /* vcvtss2si */, X86::VCVTSS2SI64Zrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_GR64 }, },
  { 8936 /* vcvtss2sil */, X86::VCVTSS2SIrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 8936 /* vcvtss2sil */, X86::VCVTSS2SIZrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR32 }, },
  { 8936 /* vcvtss2sil */, X86::VCVTSS2SIrm_Int, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 8936 /* vcvtss2sil */, X86::VCVTSS2SIZrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_GR32 }, },
  { 8947 /* vcvtss2siq */, X86::VCVTSS2SI64rr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 8947 /* vcvtss2siq */, X86::VCVTSS2SI64Zrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR64 }, },
  { 8947 /* vcvtss2siq */, X86::VCVTSS2SI64rm_Int, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 8947 /* vcvtss2siq */, X86::VCVTSS2SI64Zrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_GR64 }, },
  { 8958 /* vcvtss2usi */, X86::VCVTSS2USIZrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR32 }, },
  { 8958 /* vcvtss2usi */, X86::VCVTSS2USI64Zrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR64 }, },
  { 8958 /* vcvtss2usi */, X86::VCVTSS2USIZrm_Int, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 8958 /* vcvtss2usi */, X86::VCVTSS2USI64Zrm_Int, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 8958 /* vcvtss2usi */, X86::VCVTSS2USIZrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_GR32 }, },
  { 8958 /* vcvtss2usi */, X86::VCVTSS2USI64Zrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_GR64 }, },
  { 8969 /* vcvtss2usil */, X86::VCVTSS2USIZrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR32 }, },
  { 8969 /* vcvtss2usil */, X86::VCVTSS2USIZrm_Int, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 8969 /* vcvtss2usil */, X86::VCVTSS2USIZrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_GR32 }, },
  { 8981 /* vcvtss2usiq */, X86::VCVTSS2USI64Zrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR64 }, },
  { 8981 /* vcvtss2usiq */, X86::VCVTSS2USI64Zrm_Int, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 8981 /* vcvtss2usiq */, X86::VCVTSS2USI64Zrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_GR64 }, },
  { 8993 /* vcvttpd2dq */, X86::VCVTTPD2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 8993 /* vcvttpd2dq */, X86::VCVTTPD2DQYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_FR32 }, },
  { 8993 /* vcvttpd2dq */, X86::VCVTTPD2DQZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 8993 /* vcvttpd2dq */, X86::VCVTTPD2DQZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_FR32X }, },
  { 8993 /* vcvttpd2dq */, X86::VCVTTPD2DQZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR256X }, },
  { 8993 /* vcvttpd2dq */, X86::VCVTTPD2DQZrm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR256X }, },
  { 8993 /* vcvttpd2dq */, X86::VCVTTPD2DQZrrb, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR256X }, },
  { 8993 /* vcvttpd2dq */, X86::VCVTTPD2DQZ128rmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X }, },
  { 8993 /* vcvttpd2dq */, X86::VCVTTPD2DQZ256rmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR32X }, },
  { 8993 /* vcvttpd2dq */, X86::VCVTTPD2DQZrmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X }, },
  { 8993 /* vcvttpd2dq */, X86::VCVTTPD2DQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8993 /* vcvttpd2dq */, X86::VCVTTPD2DQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8993 /* vcvttpd2dq */, X86::VCVTTPD2DQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8993 /* vcvttpd2dq */, X86::VCVTTPD2DQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8993 /* vcvttpd2dq */, X86::VCVTTPD2DQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8993 /* vcvttpd2dq */, X86::VCVTTPD2DQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8993 /* vcvttpd2dq */, X86::VCVTTPD2DQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8993 /* vcvttpd2dq */, X86::VCVTTPD2DQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8993 /* vcvttpd2dq */, X86::VCVTTPD2DQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8993 /* vcvttpd2dq */, X86::VCVTTPD2DQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8993 /* vcvttpd2dq */, X86::VCVTTPD2DQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8993 /* vcvttpd2dq */, X86::VCVTTPD2DQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8993 /* vcvttpd2dq */, X86::VCVTTPD2DQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8993 /* vcvttpd2dq */, X86::VCVTTPD2DQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8993 /* vcvttpd2dq */, X86::VCVTTPD2DQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8993 /* vcvttpd2dq */, X86::VCVTTPD2DQZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9004 /* vcvttpd2dqx */, X86::VCVTTPD2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 9004 /* vcvttpd2dqx */, X86::VCVTTPD2DQZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 9004 /* vcvttpd2dqx */, X86::VCVTTPD2DQrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 9004 /* vcvttpd2dqx */, X86::VCVTTPD2DQZ128rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X }, },
  { 9004 /* vcvttpd2dqx */, X86::VCVTTPD2DQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9004 /* vcvttpd2dqx */, X86::VCVTTPD2DQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9016 /* vcvttpd2dqy */, X86::VCVTTPD2DQYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_FR32 }, },
  { 9016 /* vcvttpd2dqy */, X86::VCVTTPD2DQZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_FR32X }, },
  { 9016 /* vcvttpd2dqy */, X86::VCVTTPD2DQYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_FR32 }, },
  { 9016 /* vcvttpd2dqy */, X86::VCVTTPD2DQZ256rm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_FR32X }, },
  { 9016 /* vcvttpd2dqy */, X86::VCVTTPD2DQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9016 /* vcvttpd2dqy */, X86::VCVTTPD2DQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512 }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZ128rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZ256rm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZrm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512 }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZrrb, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR512 }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZ128rmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZ256rmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZrmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512 }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9028 /* vcvttpd2qq */, X86::VCVTTPD2QQZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9039 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 9039 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_FR32X }, },
  { 9039 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR256X }, },
  { 9039 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR256X }, },
  { 9039 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrrb, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR256X }, },
  { 9039 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ128rmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X }, },
  { 9039 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ256rmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR32X }, },
  { 9039 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X }, },
  { 9039 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9039 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9039 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9039 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9039 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9039 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9039 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9039 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9039 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9039 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9039 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9039 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9039 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9039 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9039 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9039 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9051 /* vcvttpd2udqx */, X86::VCVTTPD2UDQZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 9051 /* vcvttpd2udqx */, X86::VCVTTPD2UDQZ128rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X }, },
  { 9051 /* vcvttpd2udqx */, X86::VCVTTPD2UDQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9051 /* vcvttpd2udqx */, X86::VCVTTPD2UDQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9064 /* vcvttpd2udqy */, X86::VCVTTPD2UDQZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_FR32X }, },
  { 9064 /* vcvttpd2udqy */, X86::VCVTTPD2UDQZ256rm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_FR32X }, },
  { 9064 /* vcvttpd2udqy */, X86::VCVTTPD2UDQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9064 /* vcvttpd2udqy */, X86::VCVTTPD2UDQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512 }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ128rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ256rm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512 }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrrb, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR512 }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ128rmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ256rmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512 }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9077 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512 }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZ128rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZ256rm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZrm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512 }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZrrb, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR512 }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZrmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512 }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZ128rmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZ256rmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZrmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9089 /* vcvttps2dq */, X86::VCVTTPS2DQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_VR256X }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR512 }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZ256rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR512 }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZ128rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZrrb, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512 }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZ128rmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR32X }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZ256rmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZrmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512 }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZrmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9100 /* vcvttps2qq */, X86::VCVTTPS2QQZrmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512 }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZ128rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZ256rm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZrm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512 }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZrrb, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR512 }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZrmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512 }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZ128rmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZ256rmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZrmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9111 /* vcvttps2udq */, X86::VCVTTPS2UDQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_VR256X }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR512 }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ256rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR512 }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ128rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZrrb, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512 }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ128rmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR32X }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ256rmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZrmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512 }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZrmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9123 /* vcvttps2uqq */, X86::VCVTTPS2UQQZrmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9135 /* vcvttsd2si */, X86::VCVTTSD2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 9135 /* vcvttsd2si */, X86::VCVTTSD2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 9135 /* vcvttsd2si */, X86::VCVTTSD2SIZrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR32 }, },
  { 9135 /* vcvttsd2si */, X86::VCVTTSD2SI64Zrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR64 }, },
  { 9135 /* vcvttsd2si */, X86::VCVTTSD2SIrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 9135 /* vcvttsd2si */, X86::VCVTTSD2SI64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 9135 /* vcvttsd2si */, X86::VCVTTSD2SIZrrb_Int, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_FR32X, MCK_GR32 }, },
  { 9135 /* vcvttsd2si */, X86::VCVTTSD2SI64Zrrb_Int, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_FR32X, MCK_GR64 }, },
  { 9146 /* vcvttsd2sil */, X86::VCVTTSD2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 9146 /* vcvttsd2sil */, X86::VCVTTSD2SIZrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR32 }, },
  { 9146 /* vcvttsd2sil */, X86::VCVTTSD2SIrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 9146 /* vcvttsd2sil */, X86::VCVTTSD2SIZrrb_Int, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_FR32X, MCK_GR32 }, },
  { 9158 /* vcvttsd2siq */, X86::VCVTTSD2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 9158 /* vcvttsd2siq */, X86::VCVTTSD2SI64Zrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR64 }, },
  { 9158 /* vcvttsd2siq */, X86::VCVTTSD2SI64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 9158 /* vcvttsd2siq */, X86::VCVTTSD2SI64Zrrb_Int, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_FR32X, MCK_GR64 }, },
  { 9170 /* vcvttsd2usi */, X86::VCVTTSD2USIZrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR32 }, },
  { 9170 /* vcvttsd2usi */, X86::VCVTTSD2USI64Zrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR64 }, },
  { 9170 /* vcvttsd2usi */, X86::VCVTTSD2USIZrm_Int, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 9170 /* vcvttsd2usi */, X86::VCVTTSD2USI64Zrm_Int, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 9170 /* vcvttsd2usi */, X86::VCVTTSD2USIZrrb_Int, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_FR32X, MCK_GR32 }, },
  { 9170 /* vcvttsd2usi */, X86::VCVTTSD2USI64Zrrb_Int, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_FR32X, MCK_GR64 }, },
  { 9182 /* vcvttsd2usil */, X86::VCVTTSD2USIZrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR32 }, },
  { 9182 /* vcvttsd2usil */, X86::VCVTTSD2USIZrm_Int, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 9182 /* vcvttsd2usil */, X86::VCVTTSD2USIZrrb_Int, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_FR32X, MCK_GR32 }, },
  { 9195 /* vcvttsd2usiq */, X86::VCVTTSD2USI64Zrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR64 }, },
  { 9195 /* vcvttsd2usiq */, X86::VCVTTSD2USI64Zrm_Int, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 9195 /* vcvttsd2usiq */, X86::VCVTTSD2USI64Zrrb_Int, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_FR32X, MCK_GR64 }, },
  { 9208 /* vcvttss2si */, X86::VCVTTSS2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 9208 /* vcvttss2si */, X86::VCVTTSS2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 9208 /* vcvttss2si */, X86::VCVTTSS2SIZrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR32 }, },
  { 9208 /* vcvttss2si */, X86::VCVTTSS2SI64Zrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR64 }, },
  { 9208 /* vcvttss2si */, X86::VCVTTSS2SIrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 9208 /* vcvttss2si */, X86::VCVTTSS2SI64rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 9208 /* vcvttss2si */, X86::VCVTTSS2SIZrrb_Int, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_FR32X, MCK_GR32 }, },
  { 9208 /* vcvttss2si */, X86::VCVTTSS2SI64Zrrb_Int, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_FR32X, MCK_GR64 }, },
  { 9219 /* vcvttss2sil */, X86::VCVTTSS2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 9219 /* vcvttss2sil */, X86::VCVTTSS2SIZrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR32 }, },
  { 9219 /* vcvttss2sil */, X86::VCVTTSS2SIrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 9219 /* vcvttss2sil */, X86::VCVTTSS2SIZrrb_Int, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_FR32X, MCK_GR32 }, },
  { 9231 /* vcvttss2siq */, X86::VCVTTSS2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 9231 /* vcvttss2siq */, X86::VCVTTSS2SI64Zrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR64 }, },
  { 9231 /* vcvttss2siq */, X86::VCVTTSS2SI64rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 9231 /* vcvttss2siq */, X86::VCVTTSS2SI64Zrrb_Int, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_FR32X, MCK_GR64 }, },
  { 9243 /* vcvttss2usi */, X86::VCVTTSS2USIZrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR32 }, },
  { 9243 /* vcvttss2usi */, X86::VCVTTSS2USI64Zrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR64 }, },
  { 9243 /* vcvttss2usi */, X86::VCVTTSS2USIZrm_Int, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 9243 /* vcvttss2usi */, X86::VCVTTSS2USI64Zrm_Int, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 9243 /* vcvttss2usi */, X86::VCVTTSS2USIZrrb_Int, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_FR32X, MCK_GR32 }, },
  { 9243 /* vcvttss2usi */, X86::VCVTTSS2USI64Zrrb_Int, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_FR32X, MCK_GR64 }, },
  { 9255 /* vcvttss2usil */, X86::VCVTTSS2USIZrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR32 }, },
  { 9255 /* vcvttss2usil */, X86::VCVTTSS2USIZrm_Int, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 9255 /* vcvttss2usil */, X86::VCVTTSS2USIZrrb_Int, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_FR32X, MCK_GR32 }, },
  { 9268 /* vcvttss2usiq */, X86::VCVTTSS2USI64Zrr_Int, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_GR64 }, },
  { 9268 /* vcvttss2usiq */, X86::VCVTTSS2USI64Zrm_Int, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 9268 /* vcvttss2usiq */, X86::VCVTTSS2USI64Zrrb_Int, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_FR32X, MCK_GR64 }, },
  { 9281 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 9281 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_VR256X }, },
  { 9281 /* vcvtudq2pd */, X86::VCVTUDQ2PDZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR512 }, },
  { 9281 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ256rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X }, },
  { 9281 /* vcvtudq2pd */, X86::VCVTUDQ2PDZrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR512 }, },
  { 9281 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ128rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X }, },
  { 9281 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ128rmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR32X }, },
  { 9281 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ256rmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X }, },
  { 9281 /* vcvtudq2pd */, X86::VCVTUDQ2PDZrmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512 }, },
  { 9281 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9281 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9281 /* vcvtudq2pd */, X86::VCVTUDQ2PDZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9281 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9281 /* vcvtudq2pd */, X86::VCVTUDQ2PDZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9281 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9281 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9281 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9281 /* vcvtudq2pd */, X86::VCVTUDQ2PDZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9281 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9281 /* vcvtudq2pd */, X86::VCVTUDQ2PDZrmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9281 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9281 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9281 /* vcvtudq2pd */, X86::VCVTUDQ2PDZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9281 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ128rmkz, Convert__Reg1_1__Reg1_3__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9281 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9281 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9281 /* vcvtudq2pd */, X86::VCVTUDQ2PDZrmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512 }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ128rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ256rm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZrm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512 }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512 }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZrmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512 }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ128rmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ256rmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZrmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9292 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512 }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ128rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ256rm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZrm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512 }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512 }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ128rmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ256rmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZrmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512 }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9303 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9314 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 9314 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_FR32X }, },
  { 9314 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR256X }, },
  { 9314 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZrm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR256X }, },
  { 9314 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR256X }, },
  { 9314 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZ128rmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X }, },
  { 9314 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZ256rmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR32X }, },
  { 9314 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZrmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X }, },
  { 9314 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9314 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9314 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9314 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9314 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9314 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9314 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9314 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9314 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9314 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9314 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9314 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9314 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9314 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9314 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9314 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9325 /* vcvtuqq2psx */, X86::VCVTUQQ2PSZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 9325 /* vcvtuqq2psx */, X86::VCVTUQQ2PSZ128rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X }, },
  { 9325 /* vcvtuqq2psx */, X86::VCVTUQQ2PSZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9325 /* vcvtuqq2psx */, X86::VCVTUQQ2PSZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9337 /* vcvtuqq2psy */, X86::VCVTUQQ2PSZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_FR32X }, },
  { 9337 /* vcvtuqq2psy */, X86::VCVTUQQ2PSZ256rm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_FR32X }, },
  { 9337 /* vcvtuqq2psy */, X86::VCVTUQQ2PSZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9337 /* vcvtuqq2psy */, X86::VCVTUQQ2PSZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9349 /* vcvtusi2sd */, X86::VCVTUSI2SDZrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 9360 /* vcvtusi2sdl */, X86::VCVTUSI2SDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_FR32X, MCK_FR32X }, },
  { 9360 /* vcvtusi2sdl */, X86::VCVTUSI2SDZrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 9372 /* vcvtusi2sdq */, X86::VCVTUSI642SDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_FR32X, MCK_FR32X }, },
  { 9372 /* vcvtusi2sdq */, X86::VCVTUSI642SDZrm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 9372 /* vcvtusi2sdq */, X86::VCVTUSI642SDZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1, 0, { MCK_GR64, MCK_AVX512RC, MCK_FR32X, MCK_FR32X }, },
  { 9384 /* vcvtusi2ss */, X86::VCVTUSI2SSZrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 9395 /* vcvtusi2ssl */, X86::VCVTUSI2SSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_FR32X, MCK_FR32X }, },
  { 9395 /* vcvtusi2ssl */, X86::VCVTUSI2SSZrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 9395 /* vcvtusi2ssl */, X86::VCVTUSI2SSZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1, 0, { MCK_GR32, MCK_AVX512RC, MCK_FR32X, MCK_FR32X }, },
  { 9407 /* vcvtusi2ssq */, X86::VCVTUSI642SSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_FR32X, MCK_FR32X }, },
  { 9407 /* vcvtusi2ssq */, X86::VCVTUSI642SSZrm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 9407 /* vcvtusi2ssq */, X86::VCVTUSI642SSZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1, 0, { MCK_GR64, MCK_AVX512RC, MCK_FR32X, MCK_FR32X }, },
  { 9419 /* vdbpsadbw */, X86::VDBPSADBWZ128rri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9419 /* vdbpsadbw */, X86::VDBPSADBWZ256rri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9419 /* vdbpsadbw */, X86::VDBPSADBWZrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9419 /* vdbpsadbw */, X86::VDBPSADBWZ128rmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9419 /* vdbpsadbw */, X86::VDBPSADBWZ256rmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9419 /* vdbpsadbw */, X86::VDBPSADBWZrmi, Convert__Reg1_3__Reg1_2__Mem5125_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9419 /* vdbpsadbw */, X86::VDBPSADBWZ128rrik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9419 /* vdbpsadbw */, X86::VDBPSADBWZ256rrik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9419 /* vdbpsadbw */, X86::VDBPSADBWZrrik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9419 /* vdbpsadbw */, X86::VDBPSADBWZ128rmik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9419 /* vdbpsadbw */, X86::VDBPSADBWZ256rmik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9419 /* vdbpsadbw */, X86::VDBPSADBWZrmik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9419 /* vdbpsadbw */, X86::VDBPSADBWZ128rrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9419 /* vdbpsadbw */, X86::VDBPSADBWZ256rrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9419 /* vdbpsadbw */, X86::VDBPSADBWZrrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9419 /* vdbpsadbw */, X86::VDBPSADBWZ128rmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9419 /* vdbpsadbw */, X86::VDBPSADBWZ256rmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9419 /* vdbpsadbw */, X86::VDBPSADBWZrmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9429 /* vdivpd */, X86::VDIVPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9429 /* vdivpd */, X86::VDIVPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9429 /* vdivpd */, X86::VDIVPDZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9429 /* vdivpd */, X86::VDIVPDZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9429 /* vdivpd */, X86::VDIVPDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9429 /* vdivpd */, X86::VDIVPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9429 /* vdivpd */, X86::VDIVPDZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9429 /* vdivpd */, X86::VDIVPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9429 /* vdivpd */, X86::VDIVPDZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9429 /* vdivpd */, X86::VDIVPDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9429 /* vdivpd */, X86::VDIVPDZrrb, Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9429 /* vdivpd */, X86::VDIVPDZ128rmb, Convert__Reg1_3__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 9429 /* vdivpd */, X86::VDIVPDZ256rmb, Convert__Reg1_3__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 9429 /* vdivpd */, X86::VDIVPDZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 9429 /* vdivpd */, X86::VDIVPDZ128rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9429 /* vdivpd */, X86::VDIVPDZ256rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9429 /* vdivpd */, X86::VDIVPDZrrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9429 /* vdivpd */, X86::VDIVPDZ128rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9429 /* vdivpd */, X86::VDIVPDZ256rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9429 /* vdivpd */, X86::VDIVPDZrmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9429 /* vdivpd */, X86::VDIVPDZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9429 /* vdivpd */, X86::VDIVPDZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9429 /* vdivpd */, X86::VDIVPDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9429 /* vdivpd */, X86::VDIVPDZrrbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9429 /* vdivpd */, X86::VDIVPDZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9429 /* vdivpd */, X86::VDIVPDZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9429 /* vdivpd */, X86::VDIVPDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9429 /* vdivpd */, X86::VDIVPDZ128rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9429 /* vdivpd */, X86::VDIVPDZ256rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9429 /* vdivpd */, X86::VDIVPDZrmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9429 /* vdivpd */, X86::VDIVPDZrrbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9429 /* vdivpd */, X86::VDIVPDZ128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9429 /* vdivpd */, X86::VDIVPDZ256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9429 /* vdivpd */, X86::VDIVPDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9436 /* vdivps */, X86::VDIVPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9436 /* vdivps */, X86::VDIVPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9436 /* vdivps */, X86::VDIVPSZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9436 /* vdivps */, X86::VDIVPSZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9436 /* vdivps */, X86::VDIVPSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9436 /* vdivps */, X86::VDIVPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9436 /* vdivps */, X86::VDIVPSZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9436 /* vdivps */, X86::VDIVPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9436 /* vdivps */, X86::VDIVPSZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9436 /* vdivps */, X86::VDIVPSZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9436 /* vdivps */, X86::VDIVPSZrrb, Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9436 /* vdivps */, X86::VDIVPSZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 9436 /* vdivps */, X86::VDIVPSZ128rmb, Convert__Reg1_3__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 9436 /* vdivps */, X86::VDIVPSZ256rmb, Convert__Reg1_3__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 9436 /* vdivps */, X86::VDIVPSZ128rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9436 /* vdivps */, X86::VDIVPSZ256rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9436 /* vdivps */, X86::VDIVPSZrrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9436 /* vdivps */, X86::VDIVPSZ128rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9436 /* vdivps */, X86::VDIVPSZ256rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9436 /* vdivps */, X86::VDIVPSZrmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9436 /* vdivps */, X86::VDIVPSZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9436 /* vdivps */, X86::VDIVPSZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9436 /* vdivps */, X86::VDIVPSZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9436 /* vdivps */, X86::VDIVPSZrrbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9436 /* vdivps */, X86::VDIVPSZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9436 /* vdivps */, X86::VDIVPSZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9436 /* vdivps */, X86::VDIVPSZrmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9436 /* vdivps */, X86::VDIVPSZ128rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9436 /* vdivps */, X86::VDIVPSZ256rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9436 /* vdivps */, X86::VDIVPSZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9436 /* vdivps */, X86::VDIVPSZrrbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9436 /* vdivps */, X86::VDIVPSZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9436 /* vdivps */, X86::VDIVPSZ128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9436 /* vdivps */, X86::VDIVPSZ256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9443 /* vdivsd */, X86::VDIVSDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9443 /* vdivsd */, X86::VDIVSDZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9443 /* vdivsd */, X86::VDIVSDrm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 9443 /* vdivsd */, X86::VDIVSDZrm_Int, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 9443 /* vdivsd */, X86::VDIVSDZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9443 /* vdivsd */, X86::VDIVSDZrr_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9443 /* vdivsd */, X86::VDIVSDZrm_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9443 /* vdivsd */, X86::VDIVSDZrr_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9443 /* vdivsd */, X86::VDIVSDZrrb_Intk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9443 /* vdivsd */, X86::VDIVSDZrm_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9443 /* vdivsd */, X86::VDIVSDZrrb_Intkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9450 /* vdivss */, X86::VDIVSSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9450 /* vdivss */, X86::VDIVSSZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9450 /* vdivss */, X86::VDIVSSrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 9450 /* vdivss */, X86::VDIVSSZrm_Int, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 9450 /* vdivss */, X86::VDIVSSZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9450 /* vdivss */, X86::VDIVSSZrr_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9450 /* vdivss */, X86::VDIVSSZrm_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9450 /* vdivss */, X86::VDIVSSZrr_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9450 /* vdivss */, X86::VDIVSSZrrb_Intk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9450 /* vdivss */, X86::VDIVSSZrm_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9450 /* vdivss */, X86::VDIVSSZrrb_Intkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9457 /* vdppd */, X86::VDPPDrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9457 /* vdppd */, X86::VDPPDrmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9463 /* vdpps */, X86::VDPPSrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9463 /* vdpps */, X86::VDPPSYrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9463 /* vdpps */, X86::VDPPSrmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9463 /* vdpps */, X86::VDPPSYrmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9469 /* verr */, X86::VERRr, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 9469 /* verr */, X86::VERRm, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 9474 /* verw */, X86::VERWr, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 9474 /* verw */, X86::VERWm, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 9479 /* vexp2pd */, X86::VEXP2PDZr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512 }, },
  { 9479 /* vexp2pd */, X86::VEXP2PDZm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512 }, },
  { 9479 /* vexp2pd */, X86::VEXP2PDZrb, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR512 }, },
  { 9479 /* vexp2pd */, X86::VEXP2PDZmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512 }, },
  { 9479 /* vexp2pd */, X86::VEXP2PDZrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9479 /* vexp2pd */, X86::VEXP2PDZmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9479 /* vexp2pd */, X86::VEXP2PDZrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9479 /* vexp2pd */, X86::VEXP2PDZrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9479 /* vexp2pd */, X86::VEXP2PDZmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9479 /* vexp2pd */, X86::VEXP2PDZmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9479 /* vexp2pd */, X86::VEXP2PDZrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9479 /* vexp2pd */, X86::VEXP2PDZmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9487 /* vexp2ps */, X86::VEXP2PSZr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512 }, },
  { 9487 /* vexp2ps */, X86::VEXP2PSZm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512 }, },
  { 9487 /* vexp2ps */, X86::VEXP2PSZrb, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR512 }, },
  { 9487 /* vexp2ps */, X86::VEXP2PSZmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512 }, },
  { 9487 /* vexp2ps */, X86::VEXP2PSZrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9487 /* vexp2ps */, X86::VEXP2PSZmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9487 /* vexp2ps */, X86::VEXP2PSZrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9487 /* vexp2ps */, X86::VEXP2PSZrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9487 /* vexp2ps */, X86::VEXP2PSZmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9487 /* vexp2ps */, X86::VEXP2PSZmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9487 /* vexp2ps */, X86::VEXP2PSZrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9487 /* vexp2ps */, X86::VEXP2PSZmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9495 /* vexpandpd */, X86::VEXPANDPDZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 9495 /* vexpandpd */, X86::VEXPANDPDZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X }, },
  { 9495 /* vexpandpd */, X86::VEXPANDPDZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512 }, },
  { 9495 /* vexpandpd */, X86::VEXPANDPDZ128rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X }, },
  { 9495 /* vexpandpd */, X86::VEXPANDPDZ256rm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X }, },
  { 9495 /* vexpandpd */, X86::VEXPANDPDZrm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512 }, },
  { 9495 /* vexpandpd */, X86::VEXPANDPDZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9495 /* vexpandpd */, X86::VEXPANDPDZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9495 /* vexpandpd */, X86::VEXPANDPDZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9495 /* vexpandpd */, X86::VEXPANDPDZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9495 /* vexpandpd */, X86::VEXPANDPDZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9495 /* vexpandpd */, X86::VEXPANDPDZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9495 /* vexpandpd */, X86::VEXPANDPDZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9495 /* vexpandpd */, X86::VEXPANDPDZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9495 /* vexpandpd */, X86::VEXPANDPDZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9495 /* vexpandpd */, X86::VEXPANDPDZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9495 /* vexpandpd */, X86::VEXPANDPDZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9495 /* vexpandpd */, X86::VEXPANDPDZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9505 /* vexpandps */, X86::VEXPANDPSZ128rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X }, },
  { 9505 /* vexpandps */, X86::VEXPANDPSZ256rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X }, },
  { 9505 /* vexpandps */, X86::VEXPANDPSZrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512 }, },
  { 9505 /* vexpandps */, X86::VEXPANDPSZ128rm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X }, },
  { 9505 /* vexpandps */, X86::VEXPANDPSZ256rm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X }, },
  { 9505 /* vexpandps */, X86::VEXPANDPSZrm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512 }, },
  { 9505 /* vexpandps */, X86::VEXPANDPSZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9505 /* vexpandps */, X86::VEXPANDPSZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9505 /* vexpandps */, X86::VEXPANDPSZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9505 /* vexpandps */, X86::VEXPANDPSZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9505 /* vexpandps */, X86::VEXPANDPSZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9505 /* vexpandps */, X86::VEXPANDPSZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9505 /* vexpandps */, X86::VEXPANDPSZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9505 /* vexpandps */, X86::VEXPANDPSZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9505 /* vexpandps */, X86::VEXPANDPSZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9505 /* vexpandps */, X86::VEXPANDPSZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9505 /* vexpandps */, X86::VEXPANDPSZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9505 /* vexpandps */, X86::VEXPANDPSZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9515 /* vextractf128 */, X86::VEXTRACTF128rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256, MCK_FR32 }, },
  { 9515 /* vextractf128 */, X86::VEXTRACTF128mr, Convert__Mem1285_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256, MCK_Mem128 }, },
  { 9528 /* vextractf32x4 */, X86::VEXTRACTF32x4Z256rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_FR32X }, },
  { 9528 /* vextractf32x4 */, X86::VEXTRACTF32x4Z256mr, Convert__Mem1285_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_Mem128 }, },
  { 9528 /* vextractf32x4 */, X86::VEXTRACTF32x4Zrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_FR32X }, },
  { 9528 /* vextractf32x4 */, X86::VEXTRACTF32x4Zmr, Convert__Mem1285_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_Mem128 }, },
  { 9528 /* vextractf32x4 */, X86::VEXTRACTF32x4Z256rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9528 /* vextractf32x4 */, X86::VEXTRACTF32x4Z256mrk, Convert__Mem1285_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_Mem128, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9528 /* vextractf32x4 */, X86::VEXTRACTF32x4Zrrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9528 /* vextractf32x4 */, X86::VEXTRACTF32x4Zmrk, Convert__Mem1285_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_Mem128, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9528 /* vextractf32x4 */, X86::VEXTRACTF32x4Z256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9528 /* vextractf32x4 */, X86::VEXTRACTF32x4Zrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9542 /* vextractf32x8 */, X86::VEXTRACTF32x8Zrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR256X }, },
  { 9542 /* vextractf32x8 */, X86::VEXTRACTF32x8Zmr, Convert__Mem2565_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_Mem256 }, },
  { 9542 /* vextractf32x8 */, X86::VEXTRACTF32x8Zrrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9542 /* vextractf32x8 */, X86::VEXTRACTF32x8Zmrk, Convert__Mem2565_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_Mem256, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9542 /* vextractf32x8 */, X86::VEXTRACTF32x8Zrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9556 /* vextractf64x2 */, X86::VEXTRACTF64x2Z256rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_FR32X }, },
  { 9556 /* vextractf64x2 */, X86::VEXTRACTF64x2Z256mr, Convert__Mem1285_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_Mem128 }, },
  { 9556 /* vextractf64x2 */, X86::VEXTRACTF64x2Zrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_FR32X }, },
  { 9556 /* vextractf64x2 */, X86::VEXTRACTF64x2Zmr, Convert__Mem1285_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_Mem128 }, },
  { 9556 /* vextractf64x2 */, X86::VEXTRACTF64x2Z256rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9556 /* vextractf64x2 */, X86::VEXTRACTF64x2Z256mrk, Convert__Mem1285_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_Mem128, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9556 /* vextractf64x2 */, X86::VEXTRACTF64x2Zrrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9556 /* vextractf64x2 */, X86::VEXTRACTF64x2Zmrk, Convert__Mem1285_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_Mem128, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9556 /* vextractf64x2 */, X86::VEXTRACTF64x2Z256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9556 /* vextractf64x2 */, X86::VEXTRACTF64x2Zrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9570 /* vextractf64x4 */, X86::VEXTRACTF64x4Zrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR256X }, },
  { 9570 /* vextractf64x4 */, X86::VEXTRACTF64x4Zmr, Convert__Mem2565_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_Mem256 }, },
  { 9570 /* vextractf64x4 */, X86::VEXTRACTF64x4Zrrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9570 /* vextractf64x4 */, X86::VEXTRACTF64x4Zmrk, Convert__Mem2565_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_Mem256, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9570 /* vextractf64x4 */, X86::VEXTRACTF64x4Zrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9584 /* vextracti128 */, X86::VEXTRACTI128rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256, MCK_FR32 }, },
  { 9584 /* vextracti128 */, X86::VEXTRACTI128mr, Convert__Mem1285_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256, MCK_Mem128 }, },
  { 9597 /* vextracti32x4 */, X86::VEXTRACTI32x4Z256rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_FR32X }, },
  { 9597 /* vextracti32x4 */, X86::VEXTRACTI32x4Z256mr, Convert__Mem1285_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_Mem128 }, },
  { 9597 /* vextracti32x4 */, X86::VEXTRACTI32x4Zrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_FR32X }, },
  { 9597 /* vextracti32x4 */, X86::VEXTRACTI32x4Zmr, Convert__Mem1285_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_Mem128 }, },
  { 9597 /* vextracti32x4 */, X86::VEXTRACTI32x4Z256rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9597 /* vextracti32x4 */, X86::VEXTRACTI32x4Z256mrk, Convert__Mem1285_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_Mem128, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9597 /* vextracti32x4 */, X86::VEXTRACTI32x4Zrrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9597 /* vextracti32x4 */, X86::VEXTRACTI32x4Zmrk, Convert__Mem1285_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_Mem128, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9597 /* vextracti32x4 */, X86::VEXTRACTI32x4Z256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9597 /* vextracti32x4 */, X86::VEXTRACTI32x4Zrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9611 /* vextracti32x8 */, X86::VEXTRACTI32x8Zrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR256X }, },
  { 9611 /* vextracti32x8 */, X86::VEXTRACTI32x8Zmr, Convert__Mem2565_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_Mem256 }, },
  { 9611 /* vextracti32x8 */, X86::VEXTRACTI32x8Zrrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9611 /* vextracti32x8 */, X86::VEXTRACTI32x8Zmrk, Convert__Mem2565_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_Mem256, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9611 /* vextracti32x8 */, X86::VEXTRACTI32x8Zrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9625 /* vextracti64x2 */, X86::VEXTRACTI64x2Z256rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_FR32X }, },
  { 9625 /* vextracti64x2 */, X86::VEXTRACTI64x2Z256mr, Convert__Mem1285_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_Mem128 }, },
  { 9625 /* vextracti64x2 */, X86::VEXTRACTI64x2Zrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_FR32X }, },
  { 9625 /* vextracti64x2 */, X86::VEXTRACTI64x2Zmr, Convert__Mem1285_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_Mem128 }, },
  { 9625 /* vextracti64x2 */, X86::VEXTRACTI64x2Z256rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9625 /* vextracti64x2 */, X86::VEXTRACTI64x2Z256mrk, Convert__Mem1285_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_Mem128, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9625 /* vextracti64x2 */, X86::VEXTRACTI64x2Zrrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9625 /* vextracti64x2 */, X86::VEXTRACTI64x2Zmrk, Convert__Mem1285_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_Mem128, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9625 /* vextracti64x2 */, X86::VEXTRACTI64x2Z256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9625 /* vextracti64x2 */, X86::VEXTRACTI64x2Zrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9639 /* vextracti64x4 */, X86::VEXTRACTI64x4Zrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR256X }, },
  { 9639 /* vextracti64x4 */, X86::VEXTRACTI64x4Zmr, Convert__Mem2565_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_Mem256 }, },
  { 9639 /* vextracti64x4 */, X86::VEXTRACTI64x4Zrrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9639 /* vextracti64x4 */, X86::VEXTRACTI64x4Zmrk, Convert__Mem2565_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_Mem256, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9639 /* vextracti64x4 */, X86::VEXTRACTI64x4Zrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9653 /* vextractps */, X86::VEXTRACTPSrr, Convert__GR32orGR641_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_GR32orGR64 }, },
  { 9653 /* vextractps */, X86::VEXTRACTPSmr, Convert__Mem325_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_Mem32 }, },
  { 9653 /* vextractps */, X86::VEXTRACTPSZrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_GR32 }, },
  { 9653 /* vextractps */, X86::VEXTRACTPSZmr, Convert__Mem325_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_Mem32 }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZ128rri, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZ256rri, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZrri, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZ128rmi, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZ256rmi, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZrmi, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem5125_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZrrib, Convert__Reg1_4__Tie0_1_1__Reg1_3__Reg1_2__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZ128rmbi, Convert__Reg1_4__Tie0_1_1__Reg1_3__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZ256rmbi, Convert__Reg1_4__Tie0_1_1__Reg1_3__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZrmbi, Convert__Reg1_4__Tie0_1_1__Reg1_3__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZ128rrik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZ256rrik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZrrik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZ128rmik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZ256rmik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZrmik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZrribk, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZ128rrikz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZ256rrikz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZrrikz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZ128rmikz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZ256rmikz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZrmikz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZ128rmbik, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZ256rmbik, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZrmbik, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZrribkz, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZ128rmbikz, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZ256rmbikz, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9664 /* vfixupimmpd */, X86::VFIXUPIMMPDZrmbikz, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZ128rri, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZ256rri, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZrri, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZ128rmi, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZ256rmi, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZrmi, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem5125_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZrrib, Convert__Reg1_4__Tie0_1_1__Reg1_3__Reg1_2__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZrmbi, Convert__Reg1_4__Tie0_1_1__Reg1_3__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZ128rmbi, Convert__Reg1_4__Tie0_1_1__Reg1_3__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZ256rmbi, Convert__Reg1_4__Tie0_1_1__Reg1_3__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZ128rrik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZ256rrik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZrrik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZ128rmik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZ256rmik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZrmik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZrribk, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZ128rrikz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZ256rrikz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZrrikz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZ128rmikz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZ256rmikz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZrmbik, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZ128rmbik, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZ256rmbik, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZrmikz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZrribkz, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZrmbikz, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZ128rmbikz, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9676 /* vfixupimmps */, X86::VFIXUPIMMPSZ256rmbikz, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9688 /* vfixupimmsd */, X86::VFIXUPIMMSDZrri, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9688 /* vfixupimmsd */, X86::VFIXUPIMMSDZrmi, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 9688 /* vfixupimmsd */, X86::VFIXUPIMMSDZrrib, Convert__Reg1_4__Tie0_1_1__Reg1_3__Reg1_2__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9688 /* vfixupimmsd */, X86::VFIXUPIMMSDZrrik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9688 /* vfixupimmsd */, X86::VFIXUPIMMSDZrmik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9688 /* vfixupimmsd */, X86::VFIXUPIMMSDZrribk, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9688 /* vfixupimmsd */, X86::VFIXUPIMMSDZrrikz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9688 /* vfixupimmsd */, X86::VFIXUPIMMSDZrmikz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9688 /* vfixupimmsd */, X86::VFIXUPIMMSDZrribkz, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9700 /* vfixupimmss */, X86::VFIXUPIMMSSZrri, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9700 /* vfixupimmss */, X86::VFIXUPIMMSSZrmi, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 9700 /* vfixupimmss */, X86::VFIXUPIMMSSZrrib, Convert__Reg1_4__Tie0_1_1__Reg1_3__Reg1_2__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9700 /* vfixupimmss */, X86::VFIXUPIMMSSZrrik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9700 /* vfixupimmss */, X86::VFIXUPIMMSSZrmik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9700 /* vfixupimmss */, X86::VFIXUPIMMSSZrribk, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9700 /* vfixupimmss */, X86::VFIXUPIMMSSZrrikz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9700 /* vfixupimmss */, X86::VFIXUPIMMSSZrmikz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9700 /* vfixupimmss */, X86::VFIXUPIMMSSZrribkz, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDYr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZ128r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZ256r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZ128m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDYm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZ256m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZrb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZ128mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZ256mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZmb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZ128rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZ256rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZ128mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZ256mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZ128rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZ256rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZrkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZrbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZ128mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZ256mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZmkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZ128mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZ256mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZrbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZ128mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZ256mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9712 /* vfmadd132pd */, X86::VFMADD132PDZmbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSYr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZ128r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZ256r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZ128m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSYm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZ256m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZrb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZmb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZ128mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZ256mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZ128rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZ256rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZ128mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZ256mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZ128rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZ256rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZrkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZrbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZ128mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZ256mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZ128mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZ256mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZmkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZrbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZmbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZ128mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9724 /* vfmadd132ps */, X86::VFMADD132PSZ256mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9736 /* vfmadd132sd */, X86::VFMADD132SDr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9736 /* vfmadd132sd */, X86::VFMADD132SDZr_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9736 /* vfmadd132sd */, X86::VFMADD132SDm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 9736 /* vfmadd132sd */, X86::VFMADD132SDZm_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 9736 /* vfmadd132sd */, X86::VFMADD132SDZrb_Int, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9736 /* vfmadd132sd */, X86::VFMADD132SDZr_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9736 /* vfmadd132sd */, X86::VFMADD132SDZm_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9736 /* vfmadd132sd */, X86::VFMADD132SDZr_Intkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9736 /* vfmadd132sd */, X86::VFMADD132SDZrb_Intk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9736 /* vfmadd132sd */, X86::VFMADD132SDZm_Intkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9736 /* vfmadd132sd */, X86::VFMADD132SDZrb_Intkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9748 /* vfmadd132ss */, X86::VFMADD132SSr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9748 /* vfmadd132ss */, X86::VFMADD132SSZr_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9748 /* vfmadd132ss */, X86::VFMADD132SSm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 9748 /* vfmadd132ss */, X86::VFMADD132SSZm_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 9748 /* vfmadd132ss */, X86::VFMADD132SSZrb_Int, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9748 /* vfmadd132ss */, X86::VFMADD132SSZr_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9748 /* vfmadd132ss */, X86::VFMADD132SSZm_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9748 /* vfmadd132ss */, X86::VFMADD132SSZr_Intkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9748 /* vfmadd132ss */, X86::VFMADD132SSZrb_Intk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9748 /* vfmadd132ss */, X86::VFMADD132SSZm_Intkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9748 /* vfmadd132ss */, X86::VFMADD132SSZrb_Intkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDYr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZ128r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZ256r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZ128m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDYm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZ256m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZrb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZ128mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZ256mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZmb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZ128rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZ256rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZ128mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZ256mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZ128rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZ256rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZrkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZrbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZ128mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZ256mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZmkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZ128mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZ256mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZrbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZ128mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZ256mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9760 /* vfmadd213pd */, X86::VFMADD213PDZmbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSYr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZ128r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZ256r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZ128m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSYm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZ256m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZrb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZmb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZ128mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZ256mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZ128rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZ256rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZ128mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZ256mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZ128rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZ256rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZrkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZrbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZ128mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZ256mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZ128mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZ256mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZmkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZrbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZmbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZ128mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9772 /* vfmadd213ps */, X86::VFMADD213PSZ256mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9784 /* vfmadd213sd */, X86::VFMADD213SDr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9784 /* vfmadd213sd */, X86::VFMADD213SDZr_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9784 /* vfmadd213sd */, X86::VFMADD213SDm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 9784 /* vfmadd213sd */, X86::VFMADD213SDZm_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 9784 /* vfmadd213sd */, X86::VFMADD213SDZrb_Int, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9784 /* vfmadd213sd */, X86::VFMADD213SDZr_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9784 /* vfmadd213sd */, X86::VFMADD213SDZm_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9784 /* vfmadd213sd */, X86::VFMADD213SDZr_Intkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9784 /* vfmadd213sd */, X86::VFMADD213SDZrb_Intk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9784 /* vfmadd213sd */, X86::VFMADD213SDZm_Intkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9784 /* vfmadd213sd */, X86::VFMADD213SDZrb_Intkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9796 /* vfmadd213ss */, X86::VFMADD213SSr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9796 /* vfmadd213ss */, X86::VFMADD213SSZr_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9796 /* vfmadd213ss */, X86::VFMADD213SSm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 9796 /* vfmadd213ss */, X86::VFMADD213SSZm_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 9796 /* vfmadd213ss */, X86::VFMADD213SSZrb_Int, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9796 /* vfmadd213ss */, X86::VFMADD213SSZr_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9796 /* vfmadd213ss */, X86::VFMADD213SSZm_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9796 /* vfmadd213ss */, X86::VFMADD213SSZr_Intkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9796 /* vfmadd213ss */, X86::VFMADD213SSZrb_Intk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9796 /* vfmadd213ss */, X86::VFMADD213SSZm_Intkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9796 /* vfmadd213ss */, X86::VFMADD213SSZrb_Intkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDYr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZ128r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZ256r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZ128m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDYm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZ256m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZrb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZ128mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZ256mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZmb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZ128rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZ256rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZ128mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZ256mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZ128rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZ256rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZrkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZrbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZ128mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZ256mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZmkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZ128mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZ256mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZrbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZ128mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZ256mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9808 /* vfmadd231pd */, X86::VFMADD231PDZmbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSYr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZ128r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZ256r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZ128m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSYm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZ256m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZrb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZmb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZ128mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZ256mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZ128rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZ256rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZ128mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZ256mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZ128rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZ256rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZrkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZrbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZ128mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZ256mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZ128mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZ256mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZmkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZrbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZmbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZ128mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9820 /* vfmadd231ps */, X86::VFMADD231PSZ256mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9832 /* vfmadd231sd */, X86::VFMADD231SDr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9832 /* vfmadd231sd */, X86::VFMADD231SDZr_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9832 /* vfmadd231sd */, X86::VFMADD231SDm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 9832 /* vfmadd231sd */, X86::VFMADD231SDZm_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 9832 /* vfmadd231sd */, X86::VFMADD231SDZrb_Int, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9832 /* vfmadd231sd */, X86::VFMADD231SDZr_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9832 /* vfmadd231sd */, X86::VFMADD231SDZm_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9832 /* vfmadd231sd */, X86::VFMADD231SDZr_Intkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9832 /* vfmadd231sd */, X86::VFMADD231SDZrb_Intk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9832 /* vfmadd231sd */, X86::VFMADD231SDZm_Intkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9832 /* vfmadd231sd */, X86::VFMADD231SDZrb_Intkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9844 /* vfmadd231ss */, X86::VFMADD231SSr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9844 /* vfmadd231ss */, X86::VFMADD231SSZr_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9844 /* vfmadd231ss */, X86::VFMADD231SSm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 9844 /* vfmadd231ss */, X86::VFMADD231SSZm_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 9844 /* vfmadd231ss */, X86::VFMADD231SSZrb_Int, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9844 /* vfmadd231ss */, X86::VFMADD231SSZr_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9844 /* vfmadd231ss */, X86::VFMADD231SSZm_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9844 /* vfmadd231ss */, X86::VFMADD231SSZr_Intkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9844 /* vfmadd231ss */, X86::VFMADD231SSZrb_Intk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9844 /* vfmadd231ss */, X86::VFMADD231SSZm_Intkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9844 /* vfmadd231ss */, X86::VFMADD231SSZrb_Intkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9856 /* vfmaddpd */, X86::VFMADDPD4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9856 /* vfmaddpd */, X86::VFMADDPD4mr, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9856 /* vfmaddpd */, X86::VFMADDPD4Yrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9856 /* vfmaddpd */, X86::VFMADDPD4Ymr, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9856 /* vfmaddpd */, X86::VFMADDPD4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9856 /* vfmaddpd */, X86::VFMADDPD4Yrm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9865 /* vfmaddps */, X86::VFMADDPS4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9865 /* vfmaddps */, X86::VFMADDPS4mr, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9865 /* vfmaddps */, X86::VFMADDPS4Yrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9865 /* vfmaddps */, X86::VFMADDPS4Ymr, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9865 /* vfmaddps */, X86::VFMADDPS4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9865 /* vfmaddps */, X86::VFMADDPS4Yrm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9874 /* vfmaddsd */, X86::VFMADDSD4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9874 /* vfmaddsd */, X86::VFMADDSD4mr, Convert__Reg1_3__Reg1_2__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 9874 /* vfmaddsd */, X86::VFMADDSD4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9883 /* vfmaddss */, X86::VFMADDSS4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9883 /* vfmaddss */, X86::VFMADDSS4mr, Convert__Reg1_3__Reg1_2__Mem325_1__Reg1_0, 0, { MCK_FR32, MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 9883 /* vfmaddss */, X86::VFMADDSS4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDYr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ128r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ256r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ128m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDYm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ256m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZrb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ128mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ256mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZmb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ128rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ256rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ128mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ256mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ128rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ256rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZrkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZrbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ128mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ256mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZmkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ128mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ256mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZrbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ128mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ256mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9892 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZmbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSYr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ128r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ256r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ128m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSYm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ256m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZrb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZmb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ128mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ256mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ128rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ256rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ128mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ256mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ128rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ256rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZrkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZrbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ128mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ256mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ128mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ256mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZmkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZrbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZmbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ128mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9907 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ256mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDYr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ128r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ256r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ128m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDYm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ256m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZrb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ128mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ256mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZmb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ128rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ256rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ128mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ256mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ128rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ256rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZrkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZrbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ128mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ256mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZmkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ128mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ256mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZrbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ128mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ256mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9922 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZmbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSYr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ128r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ256r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ128m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSYm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ256m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZrb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZmb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ128mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ256mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ128rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ256rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ128mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ256mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ128rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ256rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZrkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZrbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ128mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ256mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ128mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ256mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZmkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZrbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZmbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ128mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9937 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ256mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDYr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ128r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ256r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ128m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDYm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ256m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZrb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ128mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ256mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZmb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ128rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ256rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ128mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ256mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ128rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ256rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZrkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZrbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ128mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ256mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZmkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ128mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ256mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZrbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ128mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ256mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9952 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZmbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSYr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ128r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ256r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ128m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSYm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ256m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZrb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZmb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ128mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ256mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ128rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ256rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ128mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ256mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ128rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ256rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZrkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZrbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ128mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ256mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ128mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ256mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZmkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZrbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZmbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ128mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9967 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ256mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9982 /* vfmaddsubpd */, X86::VFMADDSUBPD4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9982 /* vfmaddsubpd */, X86::VFMADDSUBPD4mr, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9982 /* vfmaddsubpd */, X86::VFMADDSUBPD4Yrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9982 /* vfmaddsubpd */, X86::VFMADDSUBPD4Ymr, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9982 /* vfmaddsubpd */, X86::VFMADDSUBPD4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9982 /* vfmaddsubpd */, X86::VFMADDSUBPD4Yrm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9994 /* vfmaddsubps */, X86::VFMADDSUBPS4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9994 /* vfmaddsubps */, X86::VFMADDSUBPS4mr, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9994 /* vfmaddsubps */, X86::VFMADDSUBPS4Yrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9994 /* vfmaddsubps */, X86::VFMADDSUBPS4Ymr, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9994 /* vfmaddsubps */, X86::VFMADDSUBPS4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9994 /* vfmaddsubps */, X86::VFMADDSUBPS4Yrm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDYr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZ128r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZ256r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZ128m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDYm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZ256m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZrb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZ128mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZ256mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZmb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZ128rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZ256rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZ128mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZ256mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZ128rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZ256rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZrkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZrbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZ128mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZ256mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZmkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZ128mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZ256mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZrbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZ128mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZ256mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10006 /* vfmsub132pd */, X86::VFMSUB132PDZmbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSYr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZ128r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZ256r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZ128m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSYm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZ256m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZrb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZmb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZ128mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZ256mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZ128rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZ256rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZ128mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZ256mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZ128rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZ256rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZrkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZrbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZ128mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZ256mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZ128mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZ256mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZmkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZrbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZmbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZ128mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10018 /* vfmsub132ps */, X86::VFMSUB132PSZ256mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10030 /* vfmsub132sd */, X86::VFMSUB132SDr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10030 /* vfmsub132sd */, X86::VFMSUB132SDZr_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 10030 /* vfmsub132sd */, X86::VFMSUB132SDm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 10030 /* vfmsub132sd */, X86::VFMSUB132SDZm_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 10030 /* vfmsub132sd */, X86::VFMSUB132SDZrb_Int, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 10030 /* vfmsub132sd */, X86::VFMSUB132SDZr_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10030 /* vfmsub132sd */, X86::VFMSUB132SDZm_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10030 /* vfmsub132sd */, X86::VFMSUB132SDZr_Intkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10030 /* vfmsub132sd */, X86::VFMSUB132SDZrb_Intk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10030 /* vfmsub132sd */, X86::VFMSUB132SDZm_Intkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10030 /* vfmsub132sd */, X86::VFMSUB132SDZrb_Intkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10042 /* vfmsub132ss */, X86::VFMSUB132SSr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10042 /* vfmsub132ss */, X86::VFMSUB132SSZr_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 10042 /* vfmsub132ss */, X86::VFMSUB132SSm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 10042 /* vfmsub132ss */, X86::VFMSUB132SSZm_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 10042 /* vfmsub132ss */, X86::VFMSUB132SSZrb_Int, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 10042 /* vfmsub132ss */, X86::VFMSUB132SSZr_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10042 /* vfmsub132ss */, X86::VFMSUB132SSZm_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10042 /* vfmsub132ss */, X86::VFMSUB132SSZr_Intkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10042 /* vfmsub132ss */, X86::VFMSUB132SSZrb_Intk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10042 /* vfmsub132ss */, X86::VFMSUB132SSZm_Intkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10042 /* vfmsub132ss */, X86::VFMSUB132SSZrb_Intkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDYr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZ128r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZ256r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZ128m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDYm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZ256m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZrb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZ128mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZ256mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZmb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZ128rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZ256rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZ128mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZ256mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZ128rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZ256rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZrkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZrbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZ128mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZ256mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZmkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZ128mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZ256mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZrbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZ128mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZ256mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10054 /* vfmsub213pd */, X86::VFMSUB213PDZmbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSYr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZ128r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZ256r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZ128m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSYm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZ256m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZrb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZmb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZ128mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZ256mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZ128rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZ256rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZ128mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZ256mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZ128rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZ256rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZrkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZrbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZ128mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZ256mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZ128mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZ256mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZmkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZrbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZmbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZ128mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10066 /* vfmsub213ps */, X86::VFMSUB213PSZ256mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10078 /* vfmsub213sd */, X86::VFMSUB213SDr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10078 /* vfmsub213sd */, X86::VFMSUB213SDZr_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 10078 /* vfmsub213sd */, X86::VFMSUB213SDm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 10078 /* vfmsub213sd */, X86::VFMSUB213SDZm_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 10078 /* vfmsub213sd */, X86::VFMSUB213SDZrb_Int, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 10078 /* vfmsub213sd */, X86::VFMSUB213SDZr_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10078 /* vfmsub213sd */, X86::VFMSUB213SDZm_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10078 /* vfmsub213sd */, X86::VFMSUB213SDZr_Intkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10078 /* vfmsub213sd */, X86::VFMSUB213SDZrb_Intk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10078 /* vfmsub213sd */, X86::VFMSUB213SDZm_Intkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10078 /* vfmsub213sd */, X86::VFMSUB213SDZrb_Intkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10090 /* vfmsub213ss */, X86::VFMSUB213SSr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10090 /* vfmsub213ss */, X86::VFMSUB213SSZr_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 10090 /* vfmsub213ss */, X86::VFMSUB213SSm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 10090 /* vfmsub213ss */, X86::VFMSUB213SSZm_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 10090 /* vfmsub213ss */, X86::VFMSUB213SSZrb_Int, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 10090 /* vfmsub213ss */, X86::VFMSUB213SSZr_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10090 /* vfmsub213ss */, X86::VFMSUB213SSZm_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10090 /* vfmsub213ss */, X86::VFMSUB213SSZr_Intkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10090 /* vfmsub213ss */, X86::VFMSUB213SSZrb_Intk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10090 /* vfmsub213ss */, X86::VFMSUB213SSZm_Intkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10090 /* vfmsub213ss */, X86::VFMSUB213SSZrb_Intkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDYr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZ128r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZ256r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZ128m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDYm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZ256m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZrb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZ128mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZ256mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZmb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZ128rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZ256rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZ128mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZ256mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZ128rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZ256rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZrkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZrbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZ128mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZ256mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZmkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZ128mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZ256mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZrbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZ128mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZ256mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10102 /* vfmsub231pd */, X86::VFMSUB231PDZmbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSYr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZ128r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZ256r, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZ128m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSYm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZ256m, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZrb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZmb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZ128mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZ256mb, Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZ128rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZ256rk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZ128mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZ256mk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZ128rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZ256rkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZrkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZrbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZ128mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZ256mkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZ128mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZ256mbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZmkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZrbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZmbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZ128mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10114 /* vfmsub231ps */, X86::VFMSUB231PSZ256mbkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10126 /* vfmsub231sd */, X86::VFMSUB231SDr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10126 /* vfmsub231sd */, X86::VFMSUB231SDZr_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 10126 /* vfmsub231sd */, X86::VFMSUB231SDm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 10126 /* vfmsub231sd */, X86::VFMSUB231SDZm_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 10126 /* vfmsub231sd */, X86::VFMSUB231SDZrb_Int, Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 10126 /* vfmsub231sd */, X86::VFMSUB231SDZr_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10126 /* vfmsub231sd */, X86::VFMSUB231SDZm_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10126 /* vfmsub231sd */, X86::VFMSUB231SDZr_Intkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10126 /* vfmsub231sd */, X86::VFMSUB231SDZrb_Intk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10126 /* vfmsub231sd */, X86::VFMSUB231SDZm_Intkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10126 /* vfmsub231sd */, X86::VFMSUB231SDZrb_Intkz, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, 0, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10138 /* vfmsub231ss */, X86::VFMSUB231SSr, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10138 /* vfmsub231ss */, X86::VFMSUB231SSZr_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 10138 /* vfmsub231ss */, X86::VFMSUB231SSm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 10138 /* vfmsub231ss */, X86::VFMSUB231SSZm_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_