#include <inttypes.h>
#include <stdint.h>
#include <stdio.h>

struct BlockProfileInfo {
  uint64_t Counter;
  const char *const BlockName;
} __attribute__((aligned(8)));

extern const struct BlockProfileInfo *__Sz_block_profile_info;

static const char SubzeroLogo[] =
    "\n"
    "\n"
    "__________________________________________________________________________"
    "____________________________\n"
    " _____/\\\\\\\\\\\\\\\\\\\\\\__________________/"
    "\\\\\\_______________________________________________________________\n"
    "  "
    "___/\\\\\\/////////\\\\\\_______________\\/"
    "\\\\\\_______________________________________________________________\n"
    "   "
    "__\\//\\\\\\______\\///________________\\/"
    "\\\\\\_______________________________________________________________\n"
    "    "
    "___\\////\\\\\\__________/\\\\\\____/\\\\\\_\\/\\\\\\_________/"
    "\\\\\\\\\\\\\\\\\\\\\\_____/\\\\\\\\\\\\\\\\___/\\\\/\\\\\\\\\\\\\\____/"
    "\\\\\\\\\\____\n"
    "     "
    "______\\////\\\\\\______\\/\\\\\\___\\/\\\\\\_\\/\\\\\\\\\\\\\\\\\\__\\///"
    "////\\\\\\/____/\\\\\\/////\\\\\\_\\/\\\\\\/////\\\\\\_/\\\\\\///"
    "\\\\\\__\n"
    "      "
    "_________\\////\\\\\\___\\/\\\\\\___\\/\\\\\\_\\/\\\\\\////\\\\\\______/"
    "\\\\\\/_____/\\\\\\\\\\\\\\\\\\\\\\__\\/\\\\\\__\\///__/\\\\\\__\\//"
    "\\\\\\_\n"
    "       "
    "__/\\\\\\______\\//\\\\\\__\\/\\\\\\___\\/\\\\\\_\\/\\\\\\__\\/\\\\\\____/"
    "\\\\\\/______\\//\\\\///////___\\/\\\\\\_______\\//\\\\\\__/\\\\\\__\n"
    "        "
    "_\\///\\\\\\\\\\\\\\\\\\\\\\/___\\//\\\\\\\\\\\\\\\\\\__\\/"
    "\\\\\\\\\\\\\\\\\\___/\\\\\\\\\\\\\\\\\\\\\\__\\//\\\\\\\\\\\\\\\\\\\\_\\/"
    "\\\\\\________\\///\\\\\\\\\\/___\n"
    "         "
    "___\\///////////______\\/////////___\\/////////___\\///////////____\\/////"
    "/////__\\///___________\\/////_____\n"
    "          "
    "__________________________________________________________________________"
    "____________________________\n"
    "\n"
    "\n";

void __Sz_profile_summary() {
  printf("%s", SubzeroLogo);
  for (const struct BlockProfileInfo **curr = &__Sz_block_profile_info;
       *curr != NULL; ++curr) {
    printf("%" PRIu64 "\t%s\n", (*curr)->Counter, (*curr)->BlockName);
  }
  fflush(stdout);
}
