/*
 * Copyright (C) 2008 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 * 3.  Neither the name of Apple Computer, Inc. ("Apple") nor the names of
 *     its contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef TimeoutChecker_h
#define TimeoutChecker_h

#include <wtf/Assertions.h>

#ifdef ANDROID_INSTRUMENT
#include "TimeCounter.h"
#endif

namespace JSC {

    class ExecState;

    class TimeoutChecker {
    public:
        TimeoutChecker();

        void setTimeoutInterval(unsigned timeoutInterval) { m_timeoutInterval = timeoutInterval; }
        unsigned timeoutInterval() const { return m_timeoutInterval; }
        
        unsigned ticksUntilNextCheck() { return m_ticksUntilNextCheck; }
        
        void start()
        {
            if (!m_startCount)
                reset();
#ifdef ANDROID_INSTRUMENT
            if (!m_startCount)
                android::TimeCounter::start(android::TimeCounter::JavaScriptTimeCounter);
#endif
            ++m_startCount;
        }

        void stop()
        {
            ASSERT(m_startCount);
            --m_startCount;
#ifdef ANDROID_INSTRUMENT
            if (!m_startCount)
                android::TimeCounter::record(android::TimeCounter::JavaScriptTimeCounter, __FUNCTION__);
#endif
        }

        void reset();

        bool didTimeOut(ExecState*);

    private:
        unsigned m_timeoutInterval;
        unsigned m_timeAtLastCheck;
        unsigned m_timeExecuting;
        unsigned m_startCount;
        unsigned m_ticksUntilNextCheck;
    };

} // namespace JSC

#endif // TimeoutChecker_h
