/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __DRM1_JNI_H__
#define __DRM1_JNI_H__

#ifdef __cplusplus
extern "C" {
#endif

/* DO NOT EDIT THIS FILE - it is machine generated */
#include <jni.h>
/* Header for class android_drm_mobile1_DrmRawContent */

#undef android_drm_mobile1_DrmRawContent_DRM_FORWARD_LOCK
#define android_drm_mobile1_DrmRawContent_DRM_FORWARD_LOCK 1L
#undef android_drm_mobile1_DrmRawContent_DRM_COMBINED_DELIVERY
#define android_drm_mobile1_DrmRawContent_DRM_COMBINED_DELIVERY 2L
#undef android_drm_mobile1_DrmRawContent_DRM_SEPARATE_DELIVERY
#define android_drm_mobile1_DrmRawContent_DRM_SEPARATE_DELIVERY 3L
#undef android_drm_mobile1_DrmRawContent_DRM_SEPARATE_DELIVERY_DM
#define android_drm_mobile1_DrmRawContent_DRM_SEPARATE_DELIVERY_DM 4L
#undef android_drm_mobile1_DrmRawContent_DRM_MIMETYPE_MESSAGE
#define android_drm_mobile1_DrmRawContent_DRM_MIMETYPE_MESSAGE 1L
#undef android_drm_mobile1_DrmRawContent_DRM_MIMETYPE_CONTENT
#define android_drm_mobile1_DrmRawContent_DRM_MIMETYPE_CONTENT 2L
#undef android_drm_mobile1_DrmRawContent_JNI_DRM_SUCCESS
#define android_drm_mobile1_DrmRawContent_JNI_DRM_SUCCESS 0L
#undef android_drm_mobile1_DrmRawContent_JNI_DRM_FAILURE
#define android_drm_mobile1_DrmRawContent_JNI_DRM_FAILURE -1L
#undef android_drm_mobile1_DrmRawContent_JNI_DRM_EOF
#define android_drm_mobile1_DrmRawContent_JNI_DRM_EOF -2L
#undef android_drm_mobile1_DrmRawContent_JNI_DRM_UNKNOWN_DATA_LEN
#define android_drm_mobile1_DrmRawContent_JNI_DRM_UNKNOWN_DATA_LEN -3L
/*
 * Class:     android_drm_mobile1_DrmRawContent
 * Method:    nativeConstructDrmContent
 * Signature: (Ljava/io/InputStream;II)I
 */
JNIEXPORT jint JNICALL Java_android_drm_mobile1_DrmRawContent_nativeConstructDrmContent
  (JNIEnv *, jobject, jobject, jint, jint);

/*
 * Class:     android_drm_mobile1_DrmRawContent
 * Method:    nativeGetRightsAddress
 * Signature: ()Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_android_drm_mobile1_DrmRawContent_nativeGetRightsAddress
  (JNIEnv *, jobject);

/*
 * Class:     android_drm_mobile1_DrmRawContent
 * Method:    nativeGetDeliveryMethod
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_android_drm_mobile1_DrmRawContent_nativeGetDeliveryMethod
  (JNIEnv *, jobject);

/*
 * Class:     android_drm_mobile1_DrmRawContent
 * Method:    nativeReadPieceOfContent
 * Signature: ([BIII)I
 */
JNIEXPORT jint JNICALL Java_android_drm_mobile1_DrmRawContent_nativeReadContent
  (JNIEnv *, jobject, jbyteArray, jint, jint, jint);

/*
 * Class:     android_drm_mobile1_DrmRawContent
 * Method:    nativeGetContentType
 * Signature: ()Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_android_drm_mobile1_DrmRawContent_nativeGetContentType
  (JNIEnv *, jobject);

/*
 * Class:     android_drm_mobile1_DrmRawContent
 * Method:    nativeGetContentLength
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_android_drm_mobile1_DrmRawContent_nativeGetContentLength
  (JNIEnv *, jobject);

/*
 * Class:     android_drm_mobile1_DrmRawContent
 * Method:    finalize
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_android_drm_mobile1_DrmRawContent_finalize
  (JNIEnv *, jobject);

/* Header for class android_drm_mobile1_DrmRights */

#undef android_drm_mobile1_DrmRights_DRM_PERMISSION_PLAY
#define android_drm_mobile1_DrmRights_DRM_PERMISSION_PLAY 1L
#undef android_drm_mobile1_DrmRights_DRM_PERMISSION_DISPLAY
#define android_drm_mobile1_DrmRights_DRM_PERMISSION_DISPLAY 2L
#undef android_drm_mobile1_DrmRights_DRM_PERMISSION_EXECUTE
#define android_drm_mobile1_DrmRights_DRM_PERMISSION_EXECUTE 3L
#undef android_drm_mobile1_DrmRights_DRM_PERMISSION_PRINT
#define android_drm_mobile1_DrmRights_DRM_PERMISSION_PRINT 4L
#undef android_drm_mobile1_DrmRights_DRM_CONSUME_RIGHTS_SUCCESS
#define android_drm_mobile1_DrmRights_DRM_CONSUME_RIGHTS_SUCCESS 0L
#undef android_drm_mobile1_DrmRights_DRM_CONSUME_RIGHTS_FAILURE
#define android_drm_mobile1_DrmRights_DRM_CONSUME_RIGHTS_FAILURE -1L
#undef android_drm_mobile1_DrmRights_JNI_DRM_SUCCESS
#define android_drm_mobile1_DrmRights_JNI_DRM_SUCCESS 0L
#undef android_drm_mobile1_DrmRights_JNI_DRM_FAILURE
#define android_drm_mobile1_DrmRights_JNI_DRM_FAILURE -1L
/*
 * Class:     android_drm_mobile1_DrmRights
 * Method:    nativeGetConstraintInfo
 * Signature: (ILandroid/drm/mobile1/DrmConstraintInfo;)I
 */
JNIEXPORT jint JNICALL Java_android_drm_mobile1_DrmRights_nativeGetConstraintInfo
  (JNIEnv *, jobject, jint, jobject);

/*
 * Class:     android_drm_mobile1_DrmRights
 * Method:    nativeConsumeRights
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_android_drm_mobile1_DrmRights_nativeConsumeRights
  (JNIEnv *, jobject, jint);

/* Header for class android_drm_mobile1_DrmRightsManager */

#undef android_drm_mobile1_DrmRightsManager_DRM_MIMETYPE_RIGHTS_XML
#define android_drm_mobile1_DrmRightsManager_DRM_MIMETYPE_RIGHTS_XML 3L
#undef android_drm_mobile1_DrmRightsManager_DRM_MIMETYPE_RIGHTS_WBXML
#define android_drm_mobile1_DrmRightsManager_DRM_MIMETYPE_RIGHTS_WBXML 4L
#undef android_drm_mobile1_DrmRightsManager_DRM_MIMETYPE_MESSAGE
#define android_drm_mobile1_DrmRightsManager_DRM_MIMETYPE_MESSAGE 1L
#undef android_drm_mobile1_DrmRightsManager_JNI_DRM_SUCCESS
#define android_drm_mobile1_DrmRightsManager_JNI_DRM_SUCCESS 0L
#undef android_drm_mobile1_DrmRightsManager_JNI_DRM_FAILURE
#define android_drm_mobile1_DrmRightsManager_JNI_DRM_FAILURE -1L
/* Inaccessible static: singleton */
/*
 * Class:     android_drm_mobile1_DrmRightsManager
 * Method:    nativeInstallDrmRights
 * Signature: (Ljava/io/InputStream;IILandroid/drm/mobile1/DrmRights;)I
 */
JNIEXPORT jint JNICALL Java_android_drm_mobile1_DrmRightsManager_nativeInstallDrmRights
  (JNIEnv *, jobject, jobject, jint, jint, jobject);

/*
 * Class:     android_drm_mobile1_DrmRightsManager
 * Method:    nativeQueryRights
 * Signature: (Landroid/drm/mobile1/DrmRawContent;Landroid/drm/mobile1/DrmRights;)I
 */
JNIEXPORT jint JNICALL Java_android_drm_mobile1_DrmRightsManager_nativeQueryRights
  (JNIEnv *, jobject, jobject, jobject);

/*
 * Class:     android_drm_mobile1_DrmRightsManager
 * Method:    nativeGetRightsNumber
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_android_drm_mobile1_DrmRightsManager_nativeGetNumOfRights
  (JNIEnv *, jobject);

/*
 * Class:     android_drm_mobile1_DrmRightsManager
 * Method:    nativeGetRightsList
 * Signature: ([Landroid/drm/mobile1/DrmRights;I)I
 */
JNIEXPORT jint JNICALL Java_android_drm_mobile1_DrmRightsManager_nativeGetRightsList
  (JNIEnv *, jobject, jobjectArray, jint);

/*
 * Class:     android_drm_mobile1_DrmRightsManager
 * Method:    nativeDeleteRights
 * Signature: (Landroid/drm/mobile1/DrmRights;)I
 */
JNIEXPORT jint JNICALL Java_android_drm_mobile1_DrmRightsManager_nativeDeleteRights
  (JNIEnv *, jobject, jobject);

/**
 * DRM return value defines
 */
#define JNI_DRM_SUCCESS \
    android_drm_mobile1_DrmRawContent_JNI_DRM_SUCCESS   /**< Successful operation */
#define JNI_DRM_FAILURE \
    android_drm_mobile1_DrmRawContent_JNI_DRM_FAILURE   /**< General failure */
#define JNI_DRM_EOF \
    android_drm_mobile1_DrmRawContent_JNI_DRM_EOF       /**< Indicates the end of the DRM content is reached */
#define JNI_DRM_UNKNOWN_DATA_LEN \
    android_drm_mobile1_DrmRawContent_JNI_DRM_UNKNOWN_DATA_LEN  /**< Indicates the data length is unknown */

/**
 * DRM MIME type defines
 */
#define JNI_DRM_MIMETYPE_MESSAGE \
    android_drm_mobile1_DrmRawContent_DRM_MIMETYPE_MESSAGE          /**< The "application/vnd.oma.drm.message" MIME type */
#define JNI_DRM_MIMETYPE_CONTENT \
    android_drm_mobile1_DrmRawContent_DRM_MIMETYPE_CONTENT          /**< The "application/vnd.oma.drm.content" MIME type */
#define JNI_DRM_MIMETYPE_RIGHTS_XML \
    android_drm_mobile1_DrmRightsManager_DRM_MIMETYPE_RIGHTS_XML    /**< The "application/vnd.oma.drm.rights+xml" MIME type */
#define JNI_DRM_MIMETYPE_RIGHTS_WBXML \
    android_drm_mobile1_DrmRightsManager_DRM_MIMETYPE_RIGHTS_WBXML  /**< The "application/vnd.oma.drm.rights+wbxml" MIME type */

/**
 * DRM permission defines
 */
#define JNI_DRM_PERMISSION_PLAY \
    android_drm_mobile1_DrmRights_DRM_PERMISSION_PLAY       /**< The permission to play */
#define JNI_DRM_PERMISSION_DISPLAY \
    android_drm_mobile1_DrmRights_DRM_PERMISSION_DISPLAY    /**< The permission to display */
#define JNI_DRM_PERMISSION_EXECUTE \
    android_drm_mobile1_DrmRights_DRM_PERMISSION_EXECUTE    /**< The permission to execute */
#define JNI_DRM_PERMISSION_PRINT \
    android_drm_mobile1_DrmRights_DRM_PERMISSION_PRINT      /**< The permission to print */

/**
 * DRM delivery type defines
 */
#define JNI_DRM_FORWARD_LOCK \
    android_drm_mobile1_DrmRawContent_DRM_FORWARD_LOCK          /**< forward lock */
#define JNI_DRM_COMBINED_DELIVERY \
    android_drm_mobile1_DrmRawContent_DRM_COMBINED_DELIVERY     /**< combined delivery */
#define JNI_DRM_SEPARATE_DELIVERY \
    android_drm_mobile1_DrmRawContent_DRM_SEPARATE_DELIVERY     /**< separate delivery */
#define JNI_DRM_SEPARATE_DELIVERY_DM \
    android_drm_mobile1_DrmRawContent_DRM_SEPARATE_DELIVERY_DM  /**< separate delivery DRM message */
#ifdef __cplusplus
}
#endif
#endif /* __DRM1_JNI_H__ */

