/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package tests.security.spec;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * This is autogenerated source file. Includes tests for package tests.security.spec;
 */

public class AllTests {
    public static Test suite() {
        TestSuite suite = new TestSuite("All tests for package tests.security.spec;");
        // $JUnit-BEGIN$

        suite.addTestSuite(DSAParameterSpecTest.class);
        suite.addTestSuite(DSAPrivateKeySpecTest.class);
        suite.addTestSuite(DSAPublicKeySpecTest.class);
        suite.addTestSuite(ECFieldF2mTest.class);
        suite.addTestSuite(ECFieldFpTest.class);
        suite.addTestSuite(ECGenParameterSpecTest.class);
        suite.addTestSuite(ECParameterSpecTest.class);
        suite.addTestSuite(ECPointTest.class);
        suite.addTestSuite(ECPrivateKeySpecTest.class);
        suite.addTestSuite(ECPublicKeySpecTest.class);
        suite.addTestSuite(EllipticCurveTest.class);
        suite.addTestSuite(EncodedKeySpec2Test.class);
        suite.addTestSuite(EncodedKeySpecTest.class);
        suite.addTestSuite(InvalidKeySpecExceptionTest.class);
        suite.addTestSuite(InvalidParameterSpecExceptionTest.class);
        suite.addTestSuite(MGF1ParameterSpecTest.class);
        suite.addTestSuite(PKCS8EncodedKeySpecTest.class);
        suite.addTestSuite(PSSParameterSpecTest.class);
        suite.addTestSuite(RSAKeyGenParameterSpecTest.class);
        suite.addTestSuite(RSAMultiPrimePrivateCrtKeySpecTest.class);
        suite.addTestSuite(RSAOtherPrimeInfoTest.class);
        suite.addTestSuite(RSAPrivateCrtKeySpecTest.class);
        suite.addTestSuite(RSAPrivateKeySpecTest.class);
        suite.addTestSuite(RSAPublicKeySpecTest.class);
        suite.addTestSuite(X509EncodedKeySpecTest.class);

        // $JUnit-END$
        return suite;
    }
}
