/*
 * Copyright (C) 2008 Esmertec AG.
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <embUnit.h>
#include <stdlib.h>
#include <string.h>
#include "wbxml_parser.h"

#define DEFINE_TEST(test)   \
    new_TestFixture( #test, test)

#define ASSERT_EQUAL_INT(expected, actual) \
    {   \
        int tmp = actual;             /* avoid duplicated evaluation in TEST_ASSERT_EQUAL_INT */    \
        TEST_ASSERT_EQUAL_INT(expected, tmp);   \
    }

/*
<?xml version="1.0" encoding="UTF-8" ?>
-//SYNCML//DTD SyncML 1.2//EN
*/
static const char incomplete_array[] = {
    0x02, 0x00, 0x00, 0x6A, 0x1E, '-', '/', '/', 'S', 'Y',
    'N', 'C', 'M', 'L', '/', '/', 'D', 'T', 'D', ' ', 'S',
    'y', 'n', 'c', 'M', 'L', ' ', '1', '.', '2', '/', '/',
    'E', 'N', 0x00, 0x01
};

static const char complete_array_scts[] = {
    0x02, 0x00, 0x00, 0x6a, 0x1e, 0x2d, 0x2f, 0x2f, 0x53,
    0x59, 0x4e, 0x43, 0x4d, 0x4c, 0x2f, 0x2f, 0x44, 0x54,
    0x44, 0x20, 0x53, 0x79, 0x6e, 0x63, 0x4d, 0x4c, 0x20,
    0x31, 0x2e, 0x31, 0x2f, 0x2f, 0x45, 0x4e, 0x00, 0x6d,
    0x6c, 0x71, 0x03, 0x31, 0x2e, 0x31, 0x00, 0x01, 0x72,
    0x03, 0x53, 0x79, 0x6e, 0x63, 0x4d, 0x4c, 0x2f, 0x31,
    0x2e, 0x31, 0x00, 0x01, 0x65, 0x03, 0x34, 0x00, 0x01,
    0x5b, 0x03, 0x32, 0x00, 0x01, 0x6e, 0x57, 0x03, 0x68,
    0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x31, 0x30, 0x2e,
    0x31, 0x35, 0x2e, 0x31, 0x31, 0x2e, 0x32, 0x35, 0x34,
    0x2f, 0x53, 0x63, 0x74, 0x73, 0x3f, 0x51, 0x4e, 0x41,
    0x35, 0x41, 0x41, 0x3d, 0x3d, 0x00, 0x01, 0x01, 0x67,
    0x57, 0x03, 0x53, 0x59, 0x4e, 0x43, 0x4d, 0x4c, 0x3a,
    0x31, 0x00, 0x01, 0x01, 0x4e, 0x5a, 0x00, 0x01, 0x47,
    0x03, 0x62, 0x36, 0x34, 0x00, 0x01, 0x53, 0x03, 0x73,
    0x79, 0x6e, 0x63, 0x6d, 0x6c, 0x3a, 0x61, 0x75, 0x74,
    0x68, 0x2d, 0x62, 0x61, 0x73, 0x69, 0x63, 0x00, 0x01,
    0x01, 0x00, 0x00, 0x4f, 0x03, 0x63, 0x32, 0x56, 0x79,
    0x64, 0x6d, 0x56, 0x79, 0x4f, 0x6e, 0x4e, 0x6c, 0x63,
    0x6e, 0x5a, 0x6c, 0x63, 0x67, 0x3d, 0x3d, 0x00, 0x01,
    0x01, 0x5a, 0x00, 0x01, 0x4c, 0x03, 0x32, 0x30, 0x30,
    0x30, 0x30, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x6b,
    0x69, 0x4b, 0x03, 0x31, 0x00, 0x01, 0x5c, 0x03, 0x31,
    0x00, 0x01, 0x4c, 0x03, 0x30, 0x00, 0x01, 0x4a, 0x03,
    0x53, 0x79, 0x6e, 0x63, 0x48, 0x64, 0x72, 0x00, 0x01,
    0x6f, 0x03, 0x53, 0x59, 0x4e, 0x43, 0x4d, 0x4c, 0x3a,
    0x31, 0x00, 0x01, 0x68, 0x03, 0x68, 0x74, 0x74, 0x70,
    0x3a, 0x2f, 0x2f, 0x31, 0x30, 0x2e, 0x31, 0x35, 0x2e,
    0x31, 0x31, 0x2e, 0x32, 0x35, 0x34, 0x2f, 0x53, 0x79,
    0x6e, 0x63, 0x00, 0x01, 0x4f, 0x03, 0x32, 0x31, 0x32,
    0x00, 0x01, 0x01, 0x46, 0x4b, 0x03, 0x32, 0x00, 0x01,
    0x4f, 0x03, 0x32, 0x30, 0x30, 0x00, 0x01, 0x54, 0x6e,
    0x57, 0x03, 0x64, 0x62, 0x00, 0x01, 0x01, 0x67, 0x57,
    0x03, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x73,
    0x00, 0x01, 0x01, 0x5a, 0x00, 0x01, 0x45, 0x4a, 0x03,
    0x32, 0x30, 0x30, 0x38, 0x30, 0x31, 0x31, 0x37, 0x54,
    0x30, 0x33, 0x30, 0x38, 0x32, 0x34, 0x5a, 0x00, 0x01,
    0x4f, 0x03, 0x32, 0x30, 0x30, 0x38, 0x30, 0x31, 0x31,
    0x37, 0x54, 0x30, 0x33, 0x31, 0x31, 0x31, 0x33, 0x5a,
    0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x12,
    0x01, 0x01
};

static const char complete_array2[] = {
    0x02, 0x00, 0x00, 0x6A, 0x1E, '-', '/', '/', 'S', 'Y',
    'N', 'C', 'M', 'L', '/', '/', 'D', 'T', 'D', ' ', 'S',
    'y', 'n', 'c', 'M', 'L', ' ', '1', '.', '2', '/', '/',
    'E', 'N', 0x00, 0x6D, 0x6C, 0x71, 0xC3, 0x03, '1', '.',
    '2', 0x01, 0x72, 0xC3, 0x0A, 'S', 'y', 'n', 'c', 'M',
    'L', '/', '1', '.', '2', 0x01, 0x65, 0xC3, 0x01, '1',
    0x01, 0x5B, 0xC3, 0x01, '2', 0x01, 0x6E, 0x57, 0xC3,
    0x20, 'h', 't', 't', 'p', ':', '/', '/', 'w', 'w', 'w',
    '1', '.', 'd', 'a', 't', 'a', 's', 'y', 'n', 'c', '.',
    'o', 'r', 'g', '/', 's', 'e', 'r', 'v', 'l', 'e', 't',
    0x01, 0x01, 0x67, 0x57, 0xC3, 0x12, 'I', 'M', 'E', 'I',
    ':', '1', '5', '6', '4', '4', '6', '9', '2', '1', '0',
    '9', '4', '8', 0x01, 0x01, 0x01, 0x6B, 0x69, 0x4B,
    0xC3, 0x01, '1', 0x01, 0x5C, 0xC3, 0x01, '1', 0x01,
    0x4C, 0xC3, 0x01, '0', 0x01, 0x4A, 0xC3, 0x07, 'S',
    'y', 'n', 'c', 'H', 'd', 'r', 0x01, 0x6F, 0xC3, 0x12,
    'I', 'M', 'E', 'I', ':', '1', '5', '6', '4', '4', '6',
    '9', '2', '1', '0', '9', '4', '8', 0x01, 0x68, 0xC3,
    0x20, 'h', 't', 't', 'p', ':', '/', '/', 'w', 'w', 'w',
    '1', '.', 'd', 'a', 't', 'a', 's', 'y', 'n', 'c', '.',
    'o', 'r', 'g', '/', 's', 'e', 'r', 'v', 'l', 'e', 't',
    0x01, 0x4F, 0xC3, 0x3, '2', '0', '0', 0x01, 0x01,
    0x69, 0x4B, 0xC3, 0x01, '2', 0x01, 0x5C, 0xC3, 0x01,
    '1', 0x01, 0x4C, 0xC3, 0x01, '1', 0x01, 0x4A, 0xC3,
    0x05, 'A', 'l', 'e', 'r', 't', 0x01, 0x6F, 0xC3, 0x0E,
    '.', '\\', 'd', 'e', 'v', '-', 'c', 'a', 'l', 'e', 'n',
    'd', 'a', 'r', 0x01, 0x68, 0xC3, 0x0A, '.', '/', 'c',
    'a', 'l', 'e', 'n', 'd', 'a', 'r', 0x01, 0x4F, 0xC3,
    0x03, '2', '0', '0', 0x01, 0x54, 0x4F, 0x00, 0x01,
    0x4F, 0xC3, 0x11, '2', '0', '0', '0', '0', '5', '0',
    '2', '2', 'T', '0', '9', '3', '2', '2', '3', 'Z',
    0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x6A, 0x4B, 0xC3,
    0x01, '3', 0x01, 0x6E, 0x57, 0xC3, 0x0A, '.', '/',
    'c', 'a', 'l', 'e', 'n', 'd', 'a', 'r', 0x01, 0x01,
    0x67, 0x57, 0xC3, 0x0E, '.', '\\', 'd', 'e', 'v', '-',
    'c', 'a', 'l', 'e', 'n', 'd', 'a', 'r', 0x01, 0x01,
    0x33, 0xC3, 0x01, '1', 0x01, 0x60, 0x4B, 0xC3, 0x01,
    '4', 0x01, 0x5A, 0x00, 0x01, 0x4D, 0x03, 't', 'e', 'x',
    't', '/', 'x', '-', 'v', 'c', 'a', 'l', 'e', 'n', 'd',
    'a', 'r', 0x00, 0x01, 0x00, 0x00, 0x01, 0x54, 0x67,
    0x57, 0xC3, 0x02, '2', '6', 0x01, 0x01, 0x4F, 0xC3,
    0x04, 'C', 'A', 'L', '1', 0x01, 0x01, 0x01, 0x01, 0x12,
    0x01, 0x01, 0x01
};

static void setUp(void)
{
}

static void tearDown(void)
{
}

static void testSyncmlIncomplete(void)
{
    WbxmlParser parser(0);
    ASSERT_EQUAL_INT(WBXML_STATUS_ERROR,
                     parser.parse(incomplete_array, sizeof(incomplete_array), true));
}

static void testSyncmlComplete(void)
{
    WbxmlParser parser(0);
    ASSERT_EQUAL_INT(WBXML_STATUS_OK,
                     parser.parse(complete_array_scts, sizeof(complete_array_scts), true));
}

static void testSyncmlComplete2(void)
{
    WbxmlParser parser(0);
    ASSERT_EQUAL_INT(WBXML_STATUS_OK,
                     parser.parse(complete_array2, sizeof(complete_array2), true));
}

extern "C" TestRef SyncmlParserTest_tests(void)
{
    EMB_UNIT_TESTFIXTURES(fixtures) {
        DEFINE_TEST(testSyncmlIncomplete),
        DEFINE_TEST(testSyncmlComplete),
        DEFINE_TEST(testSyncmlComplete2),
    };
    EMB_UNIT_TESTCALLER(SyncmlParserTest, "SyncmlParserTest", setUp, tearDown, fixtures);

    // temporary work around for the linker/loader problem of the sooner build
    static TestCaller t = SyncmlParserTest;
    t.isa = (TestImplement *) & TestCallerImplement;
    return (TestRef) & t;
}
