/*
 * Copyright (C) 2007-2008 Esmertec AG.
 * Copyright (C) 2007-2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef IMPS_CSP13_H
#define IMPS_CSP13_H

#include "wbxml_tabledef.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Extracted from OMA-TS-IMPS_CSP_WBXML-V1_3-20070123-A.pdf
 * Note:
 *   - IMPS 1.2 tags that have been removed in IMPS_CSP_WBXML-V1_3-20070123:
 *     - tag page 0 value 0x18 "InUse" and tag page 7 value 0x1F "Users"
 *     - tag page 2 value 0x06 "AttListFunc", 0x08 "CAAUT" and 0x30 "REACT"
 *     - tag page 3 value 0x05 "AcceptedCharset" and 0x06 "AcceptedContentLength"
 *     - tag page 4 value 0x05 "CancelAuth-Request", value 0x19 "PresenceAuth-Request",
 *                  value 0x1A "PresenceAuth-User", value 0x1F "GetReactiveAuthStatus-Request",
 *                  value 0x20 "GetReactiveAuthStatus-Response" and value 0x1E "AutoSubscribe"
 *
 *     We keep them in order to support IMPS 1.2
 *
 *   - value token "History" has a same value 0x3D as "GROUP_ID".
 */

/* Common code page (0x00) */
static const TokenData csp13TagPage0[] = {
    { 0x05, "Acceptance" },
    { 0x06, "AddList" },
    { 0x07, "AddNickList" },
    { 0x08, "SName" },
    { 0x09, "WV-CSP-Message" },
    { 0x0A, "ClientID" },
    { 0x0B, "Code" },
    { 0x0C, "ContactList" },
    { 0x0D, "ContentData" },
    { 0x0E, "ContentEncoding" },
    { 0x0F, "ContentSize" },
    { 0x10, "ContentType" },
    { 0x11, "DateTime" },
    { 0x12, "Description" },
    { 0x13, "DetailedResult" },
    { 0x14, "EntityList" },
    { 0x15, "Group" },
    { 0x16, "GroupID" },
    { 0x17, "GroupList" },
    { 0x18, "InUse" },  /* Removed in IMPS_CSP_WBXML-V1_3-20070123 */
    { 0x19, "Logo" },
    { 0x1A, "MessageCount" },
    { 0x1B, "MessageID" },
    { 0x1C, "MessageURI" },
    { 0x1D, "MSISDN" },
    { 0x1E, "Name" },
    { 0x1F, "NickList" },
    { 0x20, "NickName" },
    { 0x21, "Poll" },
    { 0x22, "Presence" },
    { 0x23, "PresenceSubList" },
    { 0x24, "PresenceValue" },
    { 0x25, "Property" },
    { 0x26, "Qualifier" },
    { 0x27, "Recipient" },
    { 0x28, "RemoveList" },
    { 0x29, "RemoveNickList" },
    { 0x2A, "Result" },
    { 0x2B, "ScreenName" },
    { 0x2C, "Sender" },
    { 0x2D, "Session" },
    { 0x2E, "SessionDescriptor" },
    { 0x2F, "SessionID" },
    { 0x30, "SessionType" },
    { 0x31, "Status" },
    { 0x32, "Transaction" },
    { 0x33, "TransactionContent" },
    { 0x34, "TransactionDescriptor" },
    { 0x35, "TransactionID" },
    { 0x36, "TransactionMode" },
    { 0x37, "URL" },
    { 0x38, "URLList" },
    { 0x39, "User" },
    { 0x3A, "UserID" },
    { 0x3B, "UserList" },
    { 0x3C, "Validity" },
    { 0x3D, "Value" },
};

/* Access code page (0x01) */
static const TokenData csp13TagPage1[] = {
    { 0x05, "AllFunctions" },
    { 0x06, "AllFunctionsRequest" },
    { 0x07, "CancelInvite-Request" },
    { 0x08, "CancelInviteUser-Request" },
    { 0x0A, "CapabilityList" },
    { 0x0B, "CapabilityRequest" },
    { 0x0C, "ClientCapability-Request" },
    { 0x0D, "ClientCapability-Response" },
    { 0x0E, "DigestBytes" },
    { 0x0F, "DigestSchema" },
    { 0x10, "Disconnect" },
    { 0x11, "Functions" },
    { 0x12, "GetSPInfo-Request" },
    { 0x13, "GetSPInfo-Response" },
    { 0x14, "InviteID" },
    { 0x15, "InviteNote" },
    { 0x16, "Invite-Request" },
    { 0x17, "Invite-Response" },
    { 0x18, "InviteType" },
    { 0x19, "InviteUser-Request" },
    { 0x1A, "InviteUser-Response" },
    { 0x1B, "KeepAlive-Request" },
    { 0x1C, "KeepAliveTime" },
    { 0x1D, "Login-Request" },
    { 0x1E, "Login-Response" },
    { 0x1F, "Logout-Request" },
    { 0x20, "Nonce" },
    { 0x21, "Password" },
    { 0x22, "Polling-Request" },
    { 0x23, "ResponseNote" },
    { 0x24, "SearchElement" },
    { 0x25, "SearchFindings" },
    { 0x26, "SearchID" },
    { 0x27, "SearchIndex" },
    { 0x28, "SearchLimit" },
    { 0x29, "KeepAlive-Response" },
    { 0x2A, "SearchPairList" },
    { 0x2B, "Search-Request" },
    { 0x2C, "Search-Response" },
    { 0x2D, "SearchResult" },
    { 0x2E, "Service-Request" },
    { 0x2F, "Service-Response" },
    { 0x30, "SessionCookie" },
    { 0x31, "StopSearch-Request" },
    { 0x32, "TimeToLive" },
    { 0x33, "SearchString" },
    { 0x34, "CompletionFlag" },
    { 0x36, "ReceiveList" },
    { 0x37, "VerifyID-Request" },
    { 0x38, "Extended-Request" },
    { 0x39, "Extended-Response" },
    { 0x3A, "AgreedCapabilityList" },
    { 0x3B, "ExtendedData" },
    { 0x3C, "OtherServer" },
    { 0x3D, "PresenceAttributeNSName" },
    { 0x3E, "SessionNSName" },
    { 0x3F, "TransactionNSName" },
};

/* Service code page (0x02) */
static const TokenData csp13TagPage2[] = {
    { 0x05, "ADDGM" },
    { 0x06, "AttListFunc" }, /* Removed in IMPS_CSP_WBXML-V1_3-20070123 */
    { 0x07, "BLENT" },
    { 0x08, "CAAUT" }, /* Removed in IMPS_CSP_WBXML-V1_3-20070123 */
    { 0x09, "CAINV" },
    { 0x0B, "CCLI" },
    { 0x0C, "ContListFunc" },
    { 0x0D, "CREAG" },
    { 0x0F, "DCLI" },
    { 0x10, "DELGR" },
    { 0x11, "FundamentalFeat" },
    { 0x12, "FWMSG" },
    { 0x14, "GCLI" },
    { 0x15, "GETGM" },
    { 0x16, "GETGP" },
    { 0x17, "GETLM" },
    { 0x18, "GETM" },
    { 0x19, "GETPR" },
    { 0x1A, "GETSPI" },
    { 0x1B, "GETWL" },
    { 0x1C, "GLBLU" },
    { 0x1D, "GRCHN" },
    { 0x1E, "GroupAuthFunc" },
    { 0x1F, "GroupFeat" },
    { 0x20, "GroupMgmtFunc" },
    { 0x21, "GroupUseFunc" },
    { 0x22, "IMAuthFunc" },
    { 0x23, "IMFeat" },
    { 0x24, "IMReceiveFunc" },
    { 0x25, "IMSendFunc" },
    { 0x26, "INVIT" },
    { 0x27, "InviteFunc" },
    { 0x28, "MBRAC" },
    { 0x29, "MCLS" },
    { 0x2A, "MDELIV" },
    { 0x2B, "NEWM" },
    { 0x2C, "NOTIF" },
    { 0x2D, "PresenceAuthFunc" },
    { 0x2E, "PresenceDeliverFunc" },
    { 0x2F, "PresenceFeat" },
    { 0x30, "REACT" }, /* Removed in IMPS_CSP_WBXML-V1_3-20070123 */
    { 0x31, "REJCM" },
    { 0x32, "REJEC" },
    { 0x33, "RMVGM" },
    { 0x34, "SearchFunc" },
    { 0x35, "ServiceFunc" },
    { 0x36, "SETD" },
    { 0x37, "SETGP" },
    { 0x38, "SRCH" },
    { 0x39, "STSRC" },
    { 0x3A, "SUBGCN" },
    { 0x3B, "UPDPR" },
    { 0x3C, "WVCSPFeat" },
    { 0x3D, "MF" },
    { 0x3E, "MG" },
    { 0x3F, "MM" },
};

/* Client capability code page (0x03) */
static const TokenData csp13TagPage3[] = {
    { 0x05, "AcceptedCharset" },            /* IMPS 1.2 only */
    { 0x06, "AcceptedContentLength" },      /* IMPS 1.2 only */
    { 0x07, "AcceptedContentType" },
    { 0x08, "AcceptedTransferEncoding" },
    { 0x09, "AnyContent" },
    { 0x0A, "DefaultLanguage" },
    { 0x0B, "InitialDeliveryMethod" },
    { 0x0C, "MultiTrans" },
    { 0x0D, "ParserSize" },
    { 0x0E, "ServerPollMin" },
    { 0x0F, "SupportedBearer" },
    { 0x10, "SupportedCIRMethod" },
    { 0x11, "TCPAddress" },
    { 0x12, "TCPPort" },
    { 0x13, "UDPPort" },
    { 0x14, "CIRHTTPAddress" },
    { 0x15, "UDPAddress" },
    { 0x16, "AcceptedPullLength" },
    { 0x17, "AcceptedPushLength" },
    { 0x18, "AcceptedRichContentLength" },
    { 0x19, "AcceptedTextContentLength" },
    { 0x1A, "OfflineETEMHandling" },
    { 0x1B, "PlainTextCharset" },
    { 0x1C, "SessionPriority" },
    { 0x1D, "SupportedOfflineBearer" },
    { 0x1F, "UserSessionLimit" },
    { 0x20, "CIRSMSAddress" },
    { 0x21, "MultiTransPerMessage" },
    { 0x22, "OnlineETEMHandling" },
    { 0x23, "ContentPolicy" },
    { 0x24, "ContentPolicyLimit" },
};

/* Presence primitive code page (0x04) */
static const TokenData csp13TagPage4[] = {
    { 0x05, "CancelAuth-Request" },             /* IMPS 1.2 only */
    { 0x06, "ContactListProperties" },
    { 0x07, "CreateAttributeList-Request" },
    { 0x08, "CreateList-Request" },
    { 0x09, "DefaultAttributeList" },
    { 0x0A, "DefaultContactList" },
    { 0x0B, "DefaultList" },
    { 0x0C, "DeleteAttributeList-Request" },
    { 0x0D, "DeleteList-Request" },
    { 0x0E, "GetAttributeList-Request" },
    { 0x0F, "GetAttributeList-Response" },
    { 0x10, "GetList-Request" },
    { 0x11, "GetList-Response" },
    { 0x12, "GetPresence-Request" },
    { 0x13, "GetPresence-Response" },
    { 0x14, "GetWatcherList-Request" },
    { 0x15, "GetWatcherList-Response" },
    { 0x16, "ListManage-Request" },
    { 0x17, "ListManage-Response" },
    { 0x18, "UnsubscribePresence-Request" },
    { 0x19, "PresenceAuth-Request" },            /* IMPS 1.2 only */
    { 0x1A, "PresenceAuth-User" },               /* IMPS 1.2 only */
    { 0x1B, "PresenceNotification-Request" },
    { 0x1C, "UpdatePresence-Request" },
    { 0x1D, "SubscribePresence-Request" },
    { 0x1E, "AutoSubscribe" },
    { 0x1F, "GetReactiveAuthStatus-Request" },   /* IMPS 1.2 only */
    { 0x20, "GetReactiveAuthStatus-Response" },  /* IMPS 1.2 only */
    { 0x21, "CreateList-Response" },
};

/* Presence attribute code page (0x05) */
static const TokenData csp13TagPage5[] = {
    { 0x05, "Accuracy" },
    { 0x06, "Address" },
    { 0x07, "AddrPref" },
    { 0x08, "Alias" },
    { 0x09, "Altitude" },
    { 0x0A, "Building" },
    { 0x0B, "Caddr" },
    { 0x0C, "City" },
    { 0x0D, "ClientInfo" },
    { 0x0E, "ClientProducer" },
    { 0x0F, "ClientType" },
    { 0x10, "ClientVersion" },
    { 0x11, "CommC" },
    { 0x12, "CommCap" },
    { 0x13, "ContactInfo" },
    { 0x14, "ContainedvCard" },
    { 0x15, "Country" },
    { 0x16, "Crossing1" },
    { 0x17, "Crossing2" },
    { 0x18, "DevManufacturer" },
    { 0x19, "DirectContent" },
    { 0x1A, "FreeTextLocation" },
    { 0x1B, "GeoLocation" },
    { 0x1C, "Language" },
    { 0x1D, "Latitude" },
    { 0x1E, "Longitude" },
    { 0x1F, "Model" },
    { 0x20, "NamedArea" },
    { 0x21, "OnlineStatus" },
    { 0x22, "PLMN" },
    { 0x23, "PrefC" },
    { 0x24, "PreferredContacts" },
    { 0x25, "PreferredLanguage" },
    { 0x26, "ReferredContent" },
    { 0x27, "ReferredvCard" },
    { 0x28, "Registration" },
    { 0x29, "StatusContent" },
    { 0x2A, "StatusMood" },
    { 0x2B, "StatusText" },
    { 0x2C, "Street" },
    { 0x2D, "TimeZone" },
    { 0x2E, "UserAvailability" },
    { 0x2F, "Cap" },
    { 0x30, "Cname" },
    { 0x31, "Contact" },
    { 0x32, "Cpriority" },
    { 0x33, "Cstatus" },
    { 0x34, "Note" },
    { 0x35, "Zone" },
    { 0x37, "Inf_link" },
    { 0x38, "InfoLink" },
    { 0x39, "Link" },
    { 0x3A, "Text" },
    { 0x3B, "ClientContentLimit" },
    { 0x3C, "ClientIMPriority" },
    { 0x3D, "MaxPullLength" },
    { 0x3E, "MaxPushLength" },
};

/* Messaging code page (0x06) */
static const TokenData csp13TagPage6[] = {
    { 0x05, "BlockList" },
    { 0x06, "BlockEntity-Request" },
    { 0x07, "DeliveryMethod" },
    { 0x08, "DeliveryReport" },
    { 0x09, "DeliveryReport-Request" },
    { 0x0A, "ForwardMessage-Request" },
    { 0x0B, "GetBlockedList-Request" },
    { 0x0C, "GetBlockedList-Response" },
    { 0x0D, "GetMessageList-Request" },
    { 0x0E, "GetMessageList-Response" },
    { 0x0F, "GetMessage-Request" },
    { 0x10, "GetMessage-Response" },
    { 0x11, "GrantList" },
    { 0x12, "MessageDelivered" },
    { 0x13, "MessageInfo" },
    { 0x14, "MessageNotification" },
    { 0x15, "NewMessage" },
    { 0x16, "RejectMessage-Request" },
    { 0x17, "SendMessage-Request" },
    { 0x18, "SendMessage-Response" },
    { 0x19, "SetDeliveryMethod-Request" },
    { 0x1A, "DeliveryTime" },
    { 0x20, "MessageInfoList" },
    { 0x21, "ForwardMessage-Response" },
};

/* Group code page (0x07) */
static const TokenData csp13TagPage7[] = {
    { 0x05, "AddGroupMembers-Request" },
    { 0x06, "Admin" },
    { 0x07, "CreateGroup-Request" },
    { 0x08, "DeleteGroup-Request" },
    { 0x09, "GetGroupMembers-Request" },
    { 0x0A, "GetGroupMembers-Response" },
    { 0x0B, "GetGroupProps-Request" },
    { 0x0C, "GetGroupProps-Response" },
    { 0x0D, "GroupChangeNotice" },
    { 0x0E, "GroupProperties" },
    { 0x0F, "Joined" },
    { 0x10, "JoinedRequest" },
    { 0x11, "JoinGroup-Request" },
    { 0x12, "JoinGroup-Response" },
    { 0x13, "LeaveGroup-Request" },
    { 0x14, "LeaveGroup-Response" },
    { 0x15, "Left" },
    { 0x16, "MemberAccess-Request" },
    { 0x17, "Mod" },
    { 0x18, "OwnProperties" },
    { 0x19, "RejectList-Request" },
    { 0x1A, "RejectList-Response" },
    { 0x1B, "RemoveGroupMembers-Request" },
    { 0x1C, "SetGroupProps-Request" },
    { 0x1D, "SubscribeGroupNotice-Request" },
    { 0x1E, "SubscribeGroupNotice-Response" },
    { 0x1F, "Users" }, /* Removed in IMPS_CSP_WBXML-V1_3-20070123 */
    { 0x20, "WelcomeNote" },
    { 0x21, "JoinGroup" },
    { 0x22, "SubscribeNotification" },
    { 0x23, "SubscribeType" },
    { 0x24, "GetJoinedUsers-Request" },
    { 0x25, "GetJoinedUsers-Response" },
    { 0x26, "AdminMapList" },
    { 0x27, "AdminMapping" },
    { 0x28, "Mapping" },
    { 0x29, "ModMapping" },
    { 0x2A, "UserMapList" },
    { 0x2B, "UserMapping" },
    { 0x2C, "JoinedBlocked" },
    { 0x2D, "LeftBlocked" },
};

/* Service code page - continued (0x08) */
static const TokenData csp13TagPage8[] = {
    { 0x05, "MP" },
    { 0x06, "GETAUT" },
    { 0x07, "GETJU" },
    { 0x08, "VRID" },
    { 0x09, "VerifyIDFunc" },
    { 0x0A, "GETMAP" },
    { 0x0B, "SGMNT" },
    { 0x0C, "EXCON" },
    { 0x0D, "OFFNOTIF" },
    { 0x0E, "ADVSR" },
};

/* Common code page - continued (0x09) */
static const TokenData csp13TagPage9[] = {
    { 0x05, "CIR" },
    { 0x06, "Domain" },
    { 0x07, "ExtBlock" },
    { 0x08, "HistoryPeriod" },
    { 0x09, "IDList" },
    { 0x0A, "MaxWatcherList" },
    { 0x0B, "AnswerOptionText" },
    { 0x0E, "Watcher" },
    { 0x0F, "WatcherStatus" },
    { 0x10, "Font" },
    { 0x11, "Size" },
    { 0x12, "Style" },
    { 0x13, "Color" },
    { 0x14, "ContentName" },
    { 0x15, "Map" },
    { 0x16, "NotificationType" },
    { 0x17, "NotificationTypeList" },
    { 0x18, "FriendlyName" },
    { 0x19, "ClearPublicProfile" },
    { 0x1A, "PublicProfile" },
    { 0x1B, "AnswerOption" },
    { 0x1C, "AnswerOptionID" },
    { 0x1D, "AnswerOptions" },
    { 0x1E, "ApplicationID" },
    { 0x1F, "AuthorizeAndGrant" },
    { 0x20, "ChosenOptionID" },
    { 0x21, "ContactListNotify" },
    { 0x22, "DefaultNotify" },
    { 0x23, "ExtendConversationUser" },
    { 0x24, "InText" },
    { 0x25, "SegmentCount" },
    { 0x26, "SegmentID" },
    { 0x27, "SegmentInfo" },
    { 0x28, "SegmentReference" },
    { 0x29, "SystemMessage" },
    { 0x2A, "SystemMessageID" },
    { 0x2B, "SystemMessageList" },
    { 0x2C, "SystemMessageResponse" },
    { 0x2D, "SystemMessageResponseList" },
    { 0x2F, "SystemMessageText" },
    { 0x30, "TryAgainTimeout" },
    { 0x31, "UserNotify" },
    { 0x32, "VerificationKey" },
    { 0x33, "VerificationMechanism" },
    { 0x34, "GetMap-Request" },
    { 0x35, "GetMap-Response" },
    { 0x36, "ExtendConversationID" },
    { 0x37, "WatcherCount" },
    { 0x38, "RequiresResponse" },
    { 0x39, "ExtBlockETEM" },
    { 0x3A, "GroupContentLimit" },
    { 0x3B, "MessageTotalCount" },
    { 0x3C, "UnrecognizedUserID" },
    { 0x3D, "UserIDPair" },
    { 0x3E, "ValidUserID" },
    { 0x3F, "UserIDList" },
};

/* Access code page - continued (0x0A) */
static const TokenData csp13TagPageA[] = {
    { 0x05, "WV-CSP-VersionDiscovery-Request" },
    { 0x06, "WV-CSP-VersionDiscovery-Response" },
    { 0x07, "VersionList" },
    { 0x08, "SubscribeNotification-Request" },
    { 0x09, "UnsubscribeNotification-Request" },
    { 0x0A, "Notification-Request" },
    { 0x0B, "AdvancedCriteria" },
    { 0x0C, "PairID" },
    { 0x0D, "GetPublicProfile-Request" },
    { 0x0E, "GetPublicProfile-Response" },
    { 0x0F, "UpdatePublicProfile-Request" },
    { 0x10, "DropSegment-Request" },
    { 0x11, "ExtendConversation-Response" },
    { 0x12, "ExtendConversation-Request" },
    { 0x13, "GetSegment-Request" },
    { 0x14, "GetSegment-Response" },
    { 0x15, "SystemMessage-Request" },
    { 0x16, "SystemMessage-User" },
    { 0x17, "SearchPair" },
    { 0x18, "SegmentContent" },
};

/* Common code page - continued (0x0B) */
static const TokenData csp13TagPageB[] = {
    { 0x05, "GrantListInUse" },
    { 0x06, "BlockListInUse" },
    { 0x07, "ContactListIDList" },
    { 0x08, "AnswerOptionsText" },
};

static const TagCodePage csp13TagPages[] = {
    PAGE_DATA(0, csp13TagPage0),
    PAGE_DATA(1, csp13TagPage1),
    PAGE_DATA(2, csp13TagPage2),
    PAGE_DATA(3, csp13TagPage3),
    PAGE_DATA(4, csp13TagPage4),
    PAGE_DATA(5, csp13TagPage5),
    PAGE_DATA(6, csp13TagPage6),
    PAGE_DATA(7, csp13TagPage7),
    PAGE_DATA(8, csp13TagPage8),
    PAGE_DATA(9, csp13TagPage9),
    PAGE_DATA(0x0A, csp13TagPageA),
    PAGE_DATA(0x0B, csp13TagPageB),
};

static const AttrData csp13AttrPage0[] = {
    { 0x05, "xmlns", "http://www.wireless-village.org/CSP" },
    { 0x06, "xmlns", "http://www.wireless-village.org/PA" },
    { 0x07, "xmlns", "http://www.wireless-village.org/TRC" },
    { 0x08, "xmlns", "http://www.openmobilealliance.org/DTD/WV-CSP" },
    { 0x09, "xmlns", "http://www.openmobilealliance.org/DTD/WV-PA" },
    { 0x0A, "xmlns", "http://www.openmobilealliance.org/DTD/WV-TRC" },
    { 0x0B, "xmlns", "http://www.openmobilealliance.org/DTD/IMPS-CSP" },
    { 0x0C, "xmlns", "http://www.openmobilealliance.org/DTD/IMPS-PA" },
    { 0x0D, "xmlns", "http://www.openmobilealliance.org/DTD/IMPS-TRC" },
};

static const AttrCodePage csp13AttrPages[] = {
    PAGE_DATA(0, csp13AttrPage0),
};

/*
 * Value tokens defined for EXT_T_0
 */
static const TokenData csp13ExtValueTokens[] = {
    { 0x00, "AccessType" },
    { 0x01, "ActiveUsers" },
    { 0x02, "Admin" },
    { 0x03, "application/" },
    { 0x04, "application/vnd.wap.mms-message" },
    { 0x05, "application/x-sms" },
    { 0x06, "AutoJoin" },
    { 0x07, "BASE64" },
    { 0x08, "Closed" },
    { 0x09, "Default" },
    { 0x0A, "DisplayName" },
    { 0x0B, "F" },
    { 0x0C, "G" },
    { 0x0D, "GR" },
    { 0x0E, "http://" },
    { 0x0F, "https://" },
    { 0x10, "image/" },
    { 0x11, "Inband" },
    { 0x12, "IM" },
    { 0x13, "MaxActiveUsers" },
    { 0x14, "Mod" },
    { 0x15, "Name" },
    { 0x16, "None" },
    { 0x17, "N" },
    { 0x18, "Open" },
    { 0x19, "Outband" },
    { 0x1A, "PR" },
    { 0x1B, "Private" },
    { 0x1C, "PrivateMessaging" },
    { 0x1D, "PrivilegeLevel" },
    { 0x1E, "Public" },
    { 0x1F, "P" },
    { 0x20, "Request" },
    { 0x21, "Response" },
    { 0x22, "Restricted" },
    { 0x23, "ScreenName" },
    { 0x24, "Searchable" },
    { 0x25, "S" },
    { 0x26, "SC" },
    { 0x27, "text/" },
    { 0x28, "text/plain" },
    { 0x29, "text/x-vCalendar" },
    { 0x2A, "text/x-vCard" },
    { 0x2B, "Topic" },
    { 0x2C, "T" },
    { 0x2D, "Type" },
    { 0x2E, "U" },
    { 0x2F, "US" },
    { 0x30, "www.wireless-village.org" },
    { 0x31, "AutoDelete" },
    { 0x32, "GM" },
    { 0x33, "Validity" },
    { 0x34, "DENIED" },
    { 0x35, "GRANTED" },
    { 0x36, "PENDING" },
    { 0x37, "ShowID" },
    { 0x38, "RequireInvitation" },
    { 0x39, "Tiny" },
    { 0x3A, "PPU" },
    { 0x3B, "SPA" },
    { 0x3C, "ANC" },
    { 0x3D, "GROUP_ID" },
    /* { 0x3D, "History" }, */ /* FIXME */
    { 0x3E, "GROUP_NAME" },
    { 0x3F, "GROUP_TOPIC" },
    { 0x40, "GROUP_USER_ID_JOINED" },
    { 0x41, "GROUP_USER_ID_OWNER" },
    { 0x42, "HTTP" },
    { 0x43, "SMS" },
    { 0x44, "STCP" },
    { 0x45, "SUDP" },
    { 0x46, "USER_ALIAS" },
    { 0x47, "USER_EMAIL_ADDRESS" },
    { 0x48, "USER_FIRST_NAME" },
    { 0x49, "USER_ID" },
    { 0x4A, "USER_LAST_NAME" },
    { 0x4B, "USER_MOBILE_NUMBER" },
    { 0x4C, "USER_ONLINE_STATUS" },
    { 0x4D, "WAPSMS" },
    { 0x4E, "WAPUDP" },
    { 0x4F, "WSP" },
    { 0x50, "GROUP_USER_ID_AUTOJOIN" },
    { 0x51, "AND" },
    { 0x52, "AC" },
    { 0x53, "BLC" },
    { 0x54, "BLUC" },
    { 0x55, "CLCR" },
    { 0x56, "CLD" },
    { 0x57, "GC" },
    { 0x58, "GD" },
    { 0x59, "GLC" },
    { 0x5A, "ANU" },
    { 0x5B, "ANGRY" },
    { 0x5C, "ANXIOUS" },
    { 0x5D, "ASHAMED" },
    { 0x5F, "AVAILABLE" },
    { 0x60, "BORED" },
    { 0x61, "CALL" },
    { 0x62, "CLI" },
    { 0x63, "COMPUTER" },
    { 0x64, "DISCREET" },
    { 0x65, "EMAIL" },
    { 0x66, "EXCITED" },
    { 0x67, "HAPPY" },
    { 0x68, "AP" },
    { 0x6B, "IN_LOVE" },
    { 0x6C, "INVINCIBLE" },
    { 0x6D, "JEALOUS" },
    { 0x6E, "MMS" },
    { 0x6F, "MOBILE_PHONE" },
    { 0x70, "NOT_AVAILABLE" },
    { 0x71, "OTHER" },
    { 0x72, "PDA" },
    { 0x73, "SAD" },
    { 0x74, "SLEEPY" },
    { 0x75, "SMS" },
    { 0x78, "www.openmobilealliance.org" },
    { 0x79, "Small" },
    { 0x7A, "Medium" },
    { 0x7B, "Big" },
    { 0x7C, "Huge" },
    { 0x7D, "Bold" },
    { 0x7E, "Italic" },
    { 0x7F, "Underline" },
    { 0x80, "Black" },
    { 0x81, "Silver" },
    { 0x82, "Gray" },
    { 0x83, "White" },
    { 0x84, "Maroon" },
    { 0x85, "Red" },
    { 0x86, "Purple" },
    { 0x87, "Fuchsia" },
    { 0x88, "Green" },
    { 0x89, "Lime" },
    { 0x8A, "Olive" },
    { 0x8B, "Yellow" },
    { 0x8C, "Navy" },
    { 0x8D, "Blue" },
    { 0x8E, "Teal" },
    { 0x8F, "Aqua" },
    { 0x90, "ATCL" },
    { 0x91, "CLC" },
    { 0x93, "USER_CITY" },
    { 0x94, "USER_COUNTRY" },
    { 0x95, "USER_FRIENDLY_NAME" },
    { 0x96, "USER_GENDER" },
    { 0x97, "USER_INTENTION" },
    { 0x98, "USER_INTERESTS_HOBBIES" },
    { 0x99, "USER_MARITAL_STATUS" },
    { 0x9A, "PRIORITYREJECT" },
    { 0x9B, "PRIORITYSTORE" },
    { 0x9C, "REJECT" },
    { 0x9D, "SENDREJECT" },
    { 0x9E, "SENDSTORE" },
    { 0x9F, "IR" },
    { 0xA0, "EC" },
    { 0xA1, "GLUC" },
    { 0xA2, "IA" },
    { 0xA3, "IC" },
    { 0xA4, "SSMS" },  /* The values of SSMS and SHTTP were wrong in IMPS 1.3
                          20060606-C but get fixed in 1.3 20070123-A */
    { 0xA5, "SHTTP" },
    { 0xA6, "DoNotNotify" },
    { 0xA7, "GMAU" },
    { 0xA8, "GMG" },
    { 0xA9, "GMR" },
    { 0xAA, "GMU" },
    { 0xAB, "DETECT" },
    { 0xAC, "FORKALL" },
    { 0xAD, "OEU" },
    { 0xAE, "SERVERLOGIC" },
    { 0xAF, "PP_AGE" },
    { 0xB0, "PP_CITY" },
    { 0xB1, "PP_COUNTRY" },
    { 0xB2, "PP_FRIENDLY_NAME" },
    { 0xB3, "PP_FREE_TEXT" },
    { 0xB4, "PP_GENDER" },
    { 0xB5, "PP_INTENTION" },
    { 0xB6, "PP_INTERESTS" },
    { 0xB7, "PP_MARITAL_STATUS" },
    { 0xB8, "USER_AGE_MAX" },
    { 0xB9, "USER_AGE_MIN" },
    { 0xBA, "EG" },
    { 0xBB, "MinimumAge" },
    { 0xBC, "C" },
    { 0xBD, "CURRENT_SUBSCRIBER" },
    { 0xBE, "FORMER_SUBSCRIBER" },
    { 0xBF, "PRESENCE_ACCESS" },
    { 0xC0, "R" },
};

#ifdef __cplusplus
}
#endif

#endif

