/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.settings.development;

import static com.google.common.truth.Truth.assertThat;

import android.content.Context;

import com.android.settings.R;
import com.android.settings.testutils.SettingsRobolectricTestRunner;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.robolectric.Robolectric;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.shadows.ShadowToast;

@RunWith(SettingsRobolectricTestRunner.class)
public class DevelopmentSettingsDisabledActivityTest {

    @Test
    public void launchActivity_shouldShowToast() {
        Robolectric.setupActivity(DevelopmentSettingsDisabledActivity.class);

        final Context context = RuntimeEnvironment.application;
        assertThat(ShadowToast.getTextOfLatestToast())
            .isEqualTo(context.getString(R.string.dev_settings_disabled_warning));
    }
}
