/* Copyright 2020 Braden Farmer
 *
 * Licensed under the Apache License, Version 2.0(the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.farmerbb.taskbar.backup;

public interface BackupAgent {

    void putString(String key, String value);
    void putStringArray(String key, String[] value);
    void putLongArray(String key, long[] value);

    String getString(String key);
    String[] getStringArray(String key);
    long[] getLongArray(String key);
}