/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragAndDropEffect;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.carbon.DataBrowserCallbacks;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

class TableDragAndDropEffect
extends DragAndDropEffect {
    Table table;
    TableItem scrollItem;
    long scrollBeginTime;
    int currentEffect = 0;
    static Callback AcceptDragProc;
    static final int SCROLL_HYSTERESIS = 150;
    static /* synthetic */ Class class$0;

    static {
        int acceptDragProc;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.TableDragAndDropEffect");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((acceptDragProc = (AcceptDragProc = new Callback(clazz, "AcceptDragProc", 5)).getAddress()) == 0) {
            SWT.error(3);
        }
    }

    TableDragAndDropEffect(Table table) {
        this.table = table;
        DataBrowserCallbacks callbacks = new DataBrowserCallbacks();
        OS.GetDataBrowserCallbacks(table.handle, callbacks);
        callbacks.v1_acceptDragCallback = AcceptDragProc.getAddress();
        OS.SetDataBrowserCallbacks(table.handle, callbacks);
    }

    static int AcceptDragProc(int theControl, int itemID, int property, int theRect, int theDrag) {
        DropTarget target = TableDragAndDropEffect.FindDropTarget(theControl, theDrag);
        if (target == null || target.effect == null) {
            return 0;
        }
        TableDragAndDropEffect effect = (TableDragAndDropEffect)target.effect;
        return effect.acceptDragProc(theControl, itemID, property, theRect, theDrag);
    }

    static DropTarget FindDropTarget(int theControl, int theDrag) {
        if (theControl == 0) {
            return null;
        }
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(theControl);
        if (widget == null) {
            return null;
        }
        return (DropTarget)widget.getData("DropTarget");
    }

    int acceptDragProc(int theControl, int itemID, int property, int theRect, int theDrag) {
        return (this.currentEffect & 1) != 0 ? 1 : 0;
    }

    int checkEffect(int effect) {
        if ((effect & 1) != 0) {
            effect = effect & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((effect & 2) != 0) {
            effect &= 0xFFFFFFFB;
        }
        return effect;
    }

    Widget getItem(int x, int y) {
        Rectangle area;
        Point coordinates = new Point(x, y);
        TableItem item = this.table.getItem(coordinates = this.table.toControl(coordinates));
        if (item == null && (area = this.table.getClientArea()).contains(coordinates)) {
            int x1 = area.x;
            while (x1 < area.x + area.width) {
                Point pt = new Point(x1, coordinates.y);
                item = this.table.getItem(pt);
                if (item != null) break;
                ++x1;
            }
        }
        return item;
    }

    void showDropTargetEffect(int effect, int x, int y) {
        effect = this.checkEffect(effect);
        TableItem item = (TableItem)this.getItem(x, y);
        if ((effect & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollItem = null;
        } else if (item != null && item.equals(this.scrollItem) && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                int index;
                Rectangle area = this.table.getClientArea();
                int headerHeight = this.table.getHeaderHeight();
                int itemHeight = this.table.getItemHeight();
                Point pt = new Point(x, y);
                pt = this.table.getDisplay().map(null, (Control)this.table, pt);
                TableItem nextItem = null;
                if (pt.y < area.y + headerHeight + 2 * itemHeight) {
                    index = Math.max(0, this.table.indexOf(item) - 1);
                    nextItem = this.table.getItem(index);
                }
                if (pt.y > area.y + area.height - 2 * itemHeight) {
                    index = Math.min(this.table.getItemCount() - 1, this.table.indexOf(item) + 1);
                    nextItem = this.table.getItem(index);
                }
                if (nextItem != null) {
                    this.table.showItem(nextItem);
                }
                this.scrollBeginTime = 0L;
                this.scrollItem = null;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 150L;
            this.scrollItem = item;
        }
        this.currentEffect = effect;
    }
}

